--
-- PostgreSQL database dump
--

\restrict jAzmwsgpFHpxHXIpfh4RdKMhZtbNdn3l7UYiAcw3MGytIFgdzmJqdRgbwZpyQJ7

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: public; Type: SCHEMA; Schema: -; Owner: -
--

-- *not* creating schema, since initdb creates it


--
-- Name: pgroonga; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS pgroonga WITH SCHEMA public;


--
-- Name: EXTENSION pgroonga; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION pgroonga IS 'Super fast and all languages supported full text search index based on Groonga';


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: argument; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument (
    id integer NOT NULL,
    statement_id integer NOT NULL,
    pro boolean NOT NULL,
    argument_type_id_expl_id integer,
    id_expl_id integer,
    pro_expl_id integer,
    statement_id_expl_id integer,
    title_expl_id integer,
    argument_type_id integer NOT NULL,
    chat_text_expl_id integer,
    strength numeric(6,5) DEFAULT NULL::numeric,
    strength_expl_id integer
);


--
-- Name: argument_analogy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_analogy (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_authority; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_authority (
    id integer NOT NULL,
    source_url character varying NOT NULL,
    authority_expl_id integer,
    id_expl_id integer,
    quote_expl_id integer,
    source_title_expl_id integer,
    source_url_expl_id integer
);


--
-- Name: argument_causal; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_causal (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_certainty_criterion; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_certainty_criterion (
    id integer NOT NULL,
    id_expl_id integer,
    argument_type_id integer NOT NULL,
    argument_type_id_expl_id integer,
    min_value_expl_id integer,
    max_value_expl_id integer,
    description_expl_id integer,
    min_value numeric(6,5) NOT NULL,
    max_value numeric(6,5) NOT NULL
);


--
-- Name: argument_certainty_criterion_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.argument_certainty_criterion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: argument_certainty_criterion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.argument_certainty_criterion_id_seq OWNED BY public.argument_certainty_criterion.id;


--
-- Name: argument_conditional; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_conditional (
    id integer NOT NULL,
    conditional_confidence numeric(6,5) NOT NULL,
    conditional_confidence_expl_id integer,
    conditional_explanation_expl_id integer,
    id_expl_id integer
);


--
-- Name: argument_contradiction; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_contradiction (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_deduction; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_deduction (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_definition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_definition (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_epistemic; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_epistemic (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_example; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_example (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_explanation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_explanation (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_extrapolation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_extrapolation (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_feasibility; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_feasibility (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_grading_example; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_grading_example (
    id integer NOT NULL,
    id_expl_id integer,
    argument_type_id integer NOT NULL,
    argument_type_id_expl_id integer,
    grade_expl_id integer,
    argument_expl_id integer,
    conclusion_expl_id integer,
    explanation_expl_id integer,
    grade numeric(6,5) NOT NULL
);


--
-- Name: argument_grading_example_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.argument_grading_example_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: argument_grading_example_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.argument_grading_example_id_seq OWNED BY public.argument_grading_example.id;


--
-- Name: argument_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.argument_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: argument_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.argument_id_seq OWNED BY public.argument.id;


--
-- Name: argument_induction; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_induction (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_judgement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_judgement (
    id integer NOT NULL,
    isolated_confidence numeric(6,5) NOT NULL,
    id_expl_id integer,
    isolated_confidence_expl_id integer,
    isolated_explanation_expl_id integer
);


--
-- Name: argument_normative; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_normative (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_obvious; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_obvious (
    id integer NOT NULL,
    id_expl_id integer,
    obvious_to_majority_expl_id integer,
    majority_is_qualified_expl_id integer,
    obvious_to_majority boolean NOT NULL,
    majority_is_qualified boolean NOT NULL
);


--
-- Name: argument_other; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_other (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_pragmatic; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_pragmatic (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_statistical; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_statistical (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_type (
    name character varying NOT NULL,
    description_expl_id integer,
    id_expl_id integer,
    id integer NOT NULL,
    name_expl_id integer
);


--
-- Name: argument_type_example; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_type_example (
    id integer NOT NULL,
    id_expl_id integer,
    argument_type_id integer,
    argument_type_id_expl_id integer,
    argument_expl_id integer,
    conclusion_expl_id integer
);


--
-- Name: argument_type_example_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.argument_type_example_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: argument_type_example_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.argument_type_example_id_seq OWNED BY public.argument_type_example.id;


--
-- Name: argument_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.argument_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: argument_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.argument_type_id_seq OWNED BY public.argument_type.id;


--
-- Name: argument_unknown; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_unknown (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: argument_weight; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_weight (
    id integer NOT NULL,
    weight_lower_limit numeric(9,2) NOT NULL,
    weight_mode numeric(9,2) NOT NULL,
    weight_upper_limit numeric(9,2) NOT NULL,
    id_expl_id integer,
    weight_explanation_expl_id integer,
    weight_lower_limit_expl_id integer,
    weight_mode_expl_id integer,
    weight_upper_limit_expl_id integer
);


--
-- Name: argument_x_definition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.argument_x_definition (
    argument_id integer NOT NULL,
    definition_id integer NOT NULL,
    argument_id_expl_id integer,
    definition_id_expl_id integer
);


--
-- Name: auth_role; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.auth_role (
    id integer NOT NULL,
    id_expl_id integer,
    name_expl_id integer,
    name character varying NOT NULL
);


--
-- Name: auth_role_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.auth_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: auth_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.auth_role_id_seq OWNED BY public.auth_role.id;


--
-- Name: bet; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bet (
    id integer NOT NULL,
    creator_id integer NOT NULL,
    statement_id integer NOT NULL,
    stake integer NOT NULL,
    duration_days integer NOT NULL,
    taker_id integer,
    start_date date,
    creator_above boolean NOT NULL,
    creator_won boolean
);


--
-- Name: bet_confidence; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bet_confidence (
    id integer NOT NULL,
    threshold_value numeric(6,5) NOT NULL,
    outcome_value numeric(6,5) DEFAULT NULL::numeric
);


--
-- Name: bet_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.bet_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bet_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.bet_id_seq OWNED BY public.bet.id;


--
-- Name: bet_net_value; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bet_net_value (
    id integer NOT NULL,
    moral_weight_profile_id integer NOT NULL,
    threshold_value integer NOT NULL,
    outcome_value integer
);


--
-- Name: chat_message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.chat_message (
    id integer NOT NULL,
    user_id integer NOT NULL,
    "timestamp" integer NOT NULL,
    text text NOT NULL
);


--
-- Name: chat_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.chat_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: chat_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.chat_message_id_seq OWNED BY public.chat_message.id;


--
-- Name: critical_question; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.critical_question (
    id integer NOT NULL,
    argument_type_id_expl_id integer,
    id_expl_id integer,
    text_expl_id integer,
    argument_type_id integer
);


--
-- Name: critical_question_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.critical_question_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: critical_question_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.critical_question_id_seq OWNED BY public.critical_question.id;


--
-- Name: critical_statement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.critical_statement (
    id integer NOT NULL,
    argument_id integer NOT NULL,
    critical_question_id integer NOT NULL,
    statement_id integer NOT NULL,
    argument_id_expl_id integer,
    critical_question_id_expl_id integer,
    id_expl_id integer,
    statement_id_expl_id integer
);


--
-- Name: critical_statement_example; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.critical_statement_example (
    id integer NOT NULL,
    id_expl_id integer,
    argument_type_example_id integer NOT NULL,
    critical_question_id integer NOT NULL,
    argument_type_example_id_expl_id integer,
    critical_question_id_expl_id integer,
    statement_expl_id integer
);


--
-- Name: critical_statement_example_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.critical_statement_example_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: critical_statement_example_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.critical_statement_example_id_seq OWNED BY public.critical_statement_example.id;


--
-- Name: critical_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.critical_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: critical_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.critical_statement_id_seq OWNED BY public.critical_statement.id;


--
-- Name: debate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.debate (
    id integer NOT NULL,
    creator_id integer NOT NULL,
    statement_id integer NOT NULL,
    taker_id integer,
    creator_above boolean NOT NULL,
    creator_won boolean
);


--
-- Name: debate_confidence; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.debate_confidence (
    id integer NOT NULL,
    threshold_value numeric(6,5) NOT NULL
);


--
-- Name: debate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.debate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: debate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.debate_id_seq OWNED BY public.debate.id;


--
-- Name: debate_net_value; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.debate_net_value (
    id integer NOT NULL,
    moral_weight_profile_id integer NOT NULL,
    threshold_value integer NOT NULL
);


--
-- Name: deed; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deed (
    id integer NOT NULL,
    id_expl_id integer,
    text_expl_id integer
);


--
-- Name: deed_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deed_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deed_id_seq OWNED BY public.deed.id;


--
-- Name: definition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.definition (
    id integer NOT NULL,
    id_expl_id integer,
    term_expl_id integer,
    text_expl_id integer
);


--
-- Name: definition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.definition_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: definition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.definition_id_seq OWNED BY public.definition.id;


--
-- Name: definition_target_x_definition_source; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.definition_target_x_definition_source (
    definition_target_id integer NOT NULL,
    definition_source_id integer NOT NULL,
    definition_target_id_expl_id integer,
    definition_source_id_expl_id integer
);


--
-- Name: directive; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.directive (
    id integer NOT NULL,
    deed_id integer NOT NULL,
    deed_id_expl_id integer,
    id_expl_id integer
);


--
-- Name: directive_consequence; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.directive_consequence (
    id integer NOT NULL,
    moral_good_id integer NOT NULL,
    value_id integer NOT NULL,
    id_expl_id integer,
    moral_good_id_expl_id integer,
    value_id_expl_id integer,
    argument_id integer NOT NULL,
    argument_id_expl_id integer
);


--
-- Name: directive_consequence_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.directive_consequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: directive_consequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.directive_consequence_id_seq OWNED BY public.directive_consequence.id;


--
-- Name: directive_scope; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.directive_scope (
    id integer NOT NULL,
    directive_id integer NOT NULL,
    person_category_id integer NOT NULL,
    include boolean DEFAULT true NOT NULL,
    directive_id_expl_id integer,
    id_expl_id integer,
    include_expl_id integer,
    person_category_id_expl_id integer
);


--
-- Name: directive_scope_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.directive_scope_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: directive_scope_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.directive_scope_id_seq OWNED BY public.directive_scope.id;


--
-- Name: expl; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.expl (
    "timestamp" timestamp with time zone NOT NULL,
    id integer NOT NULL,
    user_id integer,
    version integer NOT NULL,
    record_id integer,
    action text NOT NULL,
    table_name text,
    data jsonb
);


--
-- Name: expl_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.expl_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: expl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.expl_id_seq OWNED BY public.expl.id;


--
-- Name: forum_post; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_post (
    id integer NOT NULL,
    id_expl_id integer,
    thread_id integer NOT NULL,
    owner_id integer NOT NULL,
    thread_id_expl_id integer,
    owner_id_expl_id integer,
    text_expl_id integer
);


--
-- Name: forum_post_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.forum_post_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: forum_post_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.forum_post_id_seq OWNED BY public.forum_post.id;


--
-- Name: forum_thread; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.forum_thread (
    id integer NOT NULL,
    id_expl_id integer,
    title_expl_id integer
);


--
-- Name: forum_thread_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.forum_thread_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: forum_thread_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.forum_thread_id_seq OWNED BY public.forum_thread.id;


--
-- Name: invite; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.invite (
    id integer NOT NULL,
    owner_id integer NOT NULL,
    code character varying NOT NULL,
    code_expl_id integer,
    id_expl_id integer,
    owner_id_expl_id integer,
    person_id integer,
    person_id_expl_id integer
);


--
-- Name: invite_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.invite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.invite_id_seq OWNED BY public.invite.id;


--
-- Name: issue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.issue (
    id integer NOT NULL,
    id_expl_id integer,
    title_expl_id integer,
    description_expl_id integer
);


--
-- Name: issue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.issue_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: issue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.issue_id_seq OWNED BY public.issue.id;


--
-- Name: moral_good; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.moral_good (
    id integer NOT NULL,
    unit_id integer NOT NULL,
    id_expl_id integer,
    name_expl_id integer,
    unit_id_expl_id integer,
    description_expl_id integer
);


--
-- Name: moral_good_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.moral_good_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: moral_good_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.moral_good_id_seq OWNED BY public.moral_good.id;


--
-- Name: moral_persuasion; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.moral_persuasion (
    id integer NOT NULL,
    pro boolean NOT NULL,
    moral_good_id integer NOT NULL,
    id_expl_id integer,
    moral_good_id_expl_id integer,
    pro_expl_id integer,
    text_expl_id integer,
    title_expl_id integer
);


--
-- Name: moral_persuasion_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.moral_persuasion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: moral_persuasion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.moral_persuasion_id_seq OWNED BY public.moral_persuasion.id;


--
-- Name: moral_weight_of_person_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.moral_weight_of_person_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: moral_weight_of_profile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.moral_weight_of_profile (
    id integer NOT NULL,
    id_expl_id integer,
    profile_id integer NOT NULL,
    profile_id_expl_id integer,
    moral_good_id integer NOT NULL,
    moral_good_id_expl_id integer,
    weight numeric(9,2) NOT NULL,
    weight_expl_id integer
);


--
-- Name: moral_weight_of_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.moral_weight_of_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: moral_weight_of_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.moral_weight_of_profile_id_seq OWNED BY public.moral_weight_of_profile.id;


--
-- Name: moral_weight_profile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.moral_weight_profile (
    id integer NOT NULL,
    id_expl_id integer,
    name_expl_id integer,
    description_expl_id integer
);


--
-- Name: moral_weight_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.moral_weight_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: moral_weight_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.moral_weight_profile_id_seq OWNED BY public.moral_weight_profile.id;


--
-- Name: person; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.person (
    id integer NOT NULL,
    id_expl_id integer,
    name_expl_id integer,
    auth_role_id integer NOT NULL,
    auth_role_id_expl_id integer,
    language character varying DEFAULT 'english'::character varying NOT NULL,
    language_expl_id integer,
    competition_credits integer DEFAULT 100 NOT NULL,
    competition_credits_expl_id integer,
    permission_level integer DEFAULT 100 NOT NULL,
    permission_level_expl_id integer
);


--
-- Name: person_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.person_category (
    id integer NOT NULL,
    id_expl_id integer,
    name_expl_id integer
);


--
-- Name: person_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.person_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: person_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.person_category_id_seq OWNED BY public.person_category.id;


--
-- Name: person_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.person_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: person_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.person_id_seq OWNED BY public.person.id;


--
-- Name: persuasion_critique; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.persuasion_critique (
    id integer NOT NULL,
    moral_persuasion_id integer NOT NULL,
    statement_id integer NOT NULL,
    id_expl_id integer,
    moral_persuasion_id_expl_id integer,
    statement_id_expl_id integer
);


--
-- Name: persuasion_critique_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.persuasion_critique_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: persuasion_critique_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.persuasion_critique_id_seq OWNED BY public.persuasion_critique.id;


--
-- Name: premise; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.premise (
    id integer NOT NULL,
    id_expl_id integer,
    argument_id integer NOT NULL,
    statement_id integer NOT NULL,
    argument_id_expl_id integer,
    invert_expl_id integer,
    statement_id_expl_id integer,
    invert boolean DEFAULT false NOT NULL
);


--
-- Name: premise_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.premise_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: premise_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.premise_id_seq OWNED BY public.premise.id;


--
-- Name: research_note; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.research_note (
    id integer NOT NULL,
    statement_id integer NOT NULL,
    id_expl_id integer,
    statement_id_expl_id integer,
    text_expl_id integer,
    title_expl_id integer
);


--
-- Name: research_note_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.research_note_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: research_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.research_note_id_seq OWNED BY public.research_note.id;


--
-- Name: root_statement_update; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.root_statement_update (
    statement_id integer NOT NULL,
    expl_id integer NOT NULL
);


--
-- Name: statement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.statement (
    id integer NOT NULL,
    confidence numeric(6,5) DEFAULT 0.5,
    featured boolean DEFAULT false NOT NULL,
    statement_type_id_expl_id integer,
    confidence_expl_id integer,
    featured_expl_id integer,
    id_expl_id integer,
    text_expl_id integer,
    statement_type_id integer NOT NULL,
    chat_text_expl_id integer
);


--
-- Name: statement_discussion_message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.statement_discussion_message (
    id integer NOT NULL,
    statement_id integer NOT NULL,
    owner_id integer NOT NULL
);


--
-- Name: statement_discussion_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.statement_discussion_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: statement_discussion_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.statement_discussion_message_id_seq OWNED BY public.statement_discussion_message.id;


--
-- Name: statement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.statement_id_seq OWNED BY public.statement.id;


--
-- Name: statement_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.statement_type (
    name character varying NOT NULL,
    description_expl_id integer,
    id_expl_id integer,
    id integer NOT NULL,
    name_expl_id integer
);


--
-- Name: statement_type_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.statement_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: statement_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.statement_type_id_seq OWNED BY public.statement_type.id;


--
-- Name: statement_x_definition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.statement_x_definition (
    statement_id integer NOT NULL,
    definition_id integer NOT NULL,
    statement_id_expl_id integer,
    definition_id_expl_id integer
);


--
-- Name: statement_x_tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.statement_x_tag (
    statement_id integer NOT NULL,
    tag_id integer NOT NULL,
    statement_id_expl_id integer,
    tag_id_expl_id integer
);


--
-- Name: subscription; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subscription (
    last_opened timestamp with time zone,
    person_id integer NOT NULL,
    statement_id integer NOT NULL,
    subscribed boolean NOT NULL
);


--
-- Name: tag; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.tag (
    id integer NOT NULL,
    id_expl_id integer,
    name_expl_id integer,
    description_expl_id integer
);


--
-- Name: tag_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.tag_id_seq OWNED BY public.tag.id;


--
-- Name: task; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.task (
    id integer NOT NULL,
    id_expl_id integer,
    status_expl_id integer,
    project_stage_expl_id integer,
    functional_area_expl_id integer,
    status character varying DEFAULT 'backlog'::character varying NOT NULL,
    project_stage character varying NOT NULL,
    functional_area character varying NOT NULL
);


--
-- Name: translation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.translation (
    table_name text NOT NULL,
    column_name text NOT NULL,
    record_id integer NOT NULL,
    english text,
    chinese text,
    spanish text,
    arabic text,
    portuguese text,
    french text,
    russian text,
    german text,
    ukrainian text,
    original_language text NOT NULL
);


--
-- Name: unit; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.unit (
    id integer NOT NULL,
    column_type character varying NOT NULL,
    column_type_expl_id integer,
    id_expl_id integer,
    name_expl_id integer,
    description_expl_id integer
);


--
-- Name: unit_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.unit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: unit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.unit_id_seq OWNED BY public.unit.id;


--
-- Name: value_type_boolean; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.value_type_boolean (
    id integer NOT NULL,
    value boolean,
    id_expl_id integer,
    value_expl_id integer
);


--
-- Name: value_type_boolean_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.value_type_boolean_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: value_type_boolean_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.value_type_boolean_id_seq OWNED BY public.value_type_boolean.id;


--
-- Name: value_type_date; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.value_type_date (
    id integer NOT NULL,
    id_expl_id integer,
    value date,
    value_expl_id integer
);


--
-- Name: value_type_date_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.value_type_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: value_type_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.value_type_date_id_seq OWNED BY public.value_type_date.id;


--
-- Name: value_type_integer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.value_type_integer (
    id integer NOT NULL,
    value integer,
    id_expl_id integer,
    value_expl_id integer
);


--
-- Name: value_type_integer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.value_type_integer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: value_type_integer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.value_type_integer_id_seq OWNED BY public.value_type_integer.id;


--
-- Name: value_type_numeric_6_5; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.value_type_numeric_6_5 (
    id integer NOT NULL,
    value numeric(6,5),
    id_expl_id integer,
    value_expl_id integer
);


--
-- Name: value_type_numeric_6_5_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.value_type_numeric_6_5_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: value_type_numeric_6_5_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.value_type_numeric_6_5_id_seq OWNED BY public.value_type_numeric_6_5.id;


--
-- Name: value_type_numeric_9_2; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.value_type_numeric_9_2 (
    id integer NOT NULL,
    value numeric(9,2),
    id_expl_id integer,
    value_expl_id integer
);


--
-- Name: value_type_numeric_9_2_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.value_type_numeric_9_2_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: value_type_numeric_9_2_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.value_type_numeric_9_2_id_seq OWNED BY public.value_type_numeric_9_2.id;


--
-- Name: value_type_text; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.value_type_text (
    id integer NOT NULL,
    value text,
    id_expl_id integer,
    value_expl_id integer
);


--
-- Name: value_type_text_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.value_type_text_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: value_type_text_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.value_type_text_id_seq OWNED BY public.value_type_text.id;


--
-- Name: value_type_varchar; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.value_type_varchar (
    id integer NOT NULL,
    value character varying,
    id_expl_id integer,
    value_expl_id integer
);


--
-- Name: value_type_varchar_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.value_type_varchar_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: value_type_varchar_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.value_type_varchar_id_seq OWNED BY public.value_type_varchar.id;


--
-- Name: argument id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.argument ALTER COLUMN id SET DEFAULT nextval('public.argument_id_seq'::regclass);


--
-- Name: argument_certainty_criterion id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.argument_certainty_criterion ALTER COLUMN id SET DEFAULT nextval('public.argument_certainty_criterion_id_seq'::regclass);


--
-- Name: argument_grading_example id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.argument_grading_example ALTER COLUMN id SET DEFAULT nextval('public.argument_grading_example_id_seq'::regclass);


--
-- Name: argument_type id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.argument_type ALTER COLUMN id SET DEFAULT nextval('public.argument_type_id_seq'::regclass);


--
-- Name: argument_type_example id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.argument_type_example ALTER COLUMN id SET DEFAULT nextval('public.argument_type_example_id_seq'::regclass);


--
-- Name: auth_role id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.auth_role ALTER COLUMN id SET DEFAULT nextval('public.auth_role_id_seq'::regclass);


--
-- Name: bet id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.bet ALTER COLUMN id SET DEFAULT nextval('public.bet_id_seq'::regclass);


--
-- Name: chat_message id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.chat_message ALTER COLUMN id SET DEFAULT nextval('public.chat_message_id_seq'::regclass);


--
-- Name: critical_question id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.critical_question ALTER COLUMN id SET DEFAULT nextval('public.critical_question_id_seq'::regclass);


--
-- Name: critical_statement id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.critical_statement ALTER COLUMN id SET DEFAULT nextval('public.critical_statement_id_seq'::regclass);


--
-- Name: critical_statement_example id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.critical_statement_example ALTER COLUMN id SET DEFAULT nextval('public.critical_statement_example_id_seq'::regclass);


--
-- Name: debate id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.debate ALTER COLUMN id SET DEFAULT nextval('public.debate_id_seq'::regclass);


--
-- Name: deed id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.deed ALTER COLUMN id SET DEFAULT nextval('public.deed_id_seq'::regclass);


--
-- Name: definition id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.definition ALTER COLUMN id SET DEFAULT nextval('public.definition_id_seq'::regclass);


--
-- Name: directive_consequence id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.directive_consequence ALTER COLUMN id SET DEFAULT nextval('public.directive_consequence_id_seq'::regclass);


--
-- Name: directive_scope id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.directive_scope ALTER COLUMN id SET DEFAULT nextval('public.directive_scope_id_seq'::regclass);


--
-- Name: expl id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.expl ALTER COLUMN id SET DEFAULT nextval('public.expl_id_seq'::regclass);


--
-- Name: forum_post id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.forum_post ALTER COLUMN id SET DEFAULT nextval('public.forum_post_id_seq'::regclass);


--
-- Name: forum_thread id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.forum_thread ALTER COLUMN id SET DEFAULT nextval('public.forum_thread_id_seq'::regclass);


--
-- Name: invite id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.invite ALTER COLUMN id SET DEFAULT nextval('public.invite_id_seq'::regclass);


--
-- Name: issue id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.issue ALTER COLUMN id SET DEFAULT nextval('public.issue_id_seq'::regclass);


--
-- Name: moral_good id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.moral_good ALTER COLUMN id SET DEFAULT nextval('public.moral_good_id_seq'::regclass);


--
-- Name: moral_persuasion id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.moral_persuasion ALTER COLUMN id SET DEFAULT nextval('public.moral_persuasion_id_seq'::regclass);


--
-- Name: moral_weight_of_profile id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.moral_weight_of_profile ALTER COLUMN id SET DEFAULT nextval('public.moral_weight_of_profile_id_seq'::regclass);


--
-- Name: moral_weight_profile id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.moral_weight_profile ALTER COLUMN id SET DEFAULT nextval('public.moral_weight_profile_id_seq'::regclass);


--
-- Name: person id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.person ALTER COLUMN id SET DEFAULT nextval('public.person_id_seq'::regclass);


--
-- Name: person_category id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.person_category ALTER COLUMN id SET DEFAULT nextval('public.person_category_id_seq'::regclass);


--
-- Name: persuasion_critique id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.persuasion_critique ALTER COLUMN id SET DEFAULT nextval('public.persuasion_critique_id_seq'::regclass);


--
-- Name: premise id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.premise ALTER COLUMN id SET DEFAULT nextval('public.premise_id_seq'::regclass);


--
-- Name: research_note id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.research_note ALTER COLUMN id SET DEFAULT nextval('public.research_note_id_seq'::regclass);


--
-- Name: statement id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.statement ALTER COLUMN id SET DEFAULT nextval('public.statement_id_seq'::regclass);


--
-- Name: statement_discussion_message id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.statement_discussion_message ALTER COLUMN id SET DEFAULT nextval('public.statement_discussion_message_id_seq'::regclass);


--
-- Name: statement_type id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.statement_type ALTER COLUMN id SET DEFAULT nextval('public.statement_type_id_seq'::regclass);


--
-- Name: tag id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tag ALTER COLUMN id SET DEFAULT nextval('public.tag_id_seq'::regclass);


--
-- Name: unit id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.unit ALTER COLUMN id SET DEFAULT nextval('public.unit_id_seq'::regclass);


--
-- Name: value_type_boolean id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.value_type_boolean ALTER COLUMN id SET DEFAULT nextval('public.value_type_boolean_id_seq'::regclass);


--
-- Name: value_type_date id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.value_type_date ALTER COLUMN id SET DEFAULT nextval('public.value_type_date_id_seq'::regclass);


--
-- Name: value_type_integer id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.value_type_integer ALTER COLUMN id SET DEFAULT nextval('public.value_type_integer_id_seq'::regclass);


--
-- Name: value_type_numeric_6_5 id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.value_type_numeric_6_5 ALTER COLUMN id SET DEFAULT nextval('public.value_type_numeric_6_5_id_seq'::regclass);


--
-- Name: value_type_numeric_9_2 id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.value_type_numeric_9_2 ALTER COLUMN id SET DEFAULT nextval('public.value_type_numeric_9_2_id_seq'::regclass);


--
-- Name: value_type_text id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.value_type_text ALTER COLUMN id SET DEFAULT nextval('public.value_type_text_id_seq'::regclass);


--
-- Name: value_type_varchar id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.value_type_varchar ALTER COLUMN id SET DEFAULT nextval('public.value_type_varchar_id_seq'::regclass);


--
-- Data for Name: argument; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument (id, statement_id, pro, argument_type_id_expl_id, id_expl_id, pro_expl_id, statement_id_expl_id, title_expl_id, argument_type_id, chat_text_expl_id, strength, strength_expl_id) FROM stdin;
59	47	f	285	285	285	285	1151	4	\N	\N	\N
60	47	f	286	286	286	286	1152	4	\N	\N	\N
61	47	f	287	287	287	287	1153	4	\N	\N	\N
124	104	t	902	902	902	902	1154	1	\N	\N	\N
121	103	t	895	895	895	895	1155	4	\N	\N	\N
123	103	t	899	899	899	899	1156	8	\N	\N	\N
122	103	t	897	897	897	897	1157	8	\N	\N	\N
48	48	t	167	167	167	194	1158	1	\N	\N	\N
46	40	f	163	163	163	163	1159	4	\N	\N	\N
47	40	f	164	164	164	164	1160	4	\N	\N	\N
42	38	f	153	153	153	153	1119	5	\N	0.95000	2092
40	37	f	146	146	146	146	1168	5	\N	\N	\N
118	100	t	869	869	869	869	1134	8	1169	\N	\N
151	138	t	1190	1190	1190	1190	1190	10	1190	\N	\N
153	138	f	1193	1193	1193	1193	1193	10	1193	\N	\N
154	138	t	1194	1194	1194	1194	1194	10	1194	\N	\N
155	138	f	1195	1195	1195	1195	1195	10	1195	\N	\N
156	138	t	1196	1196	1196	1196	1196	10	1196	\N	\N
157	138	f	1197	1197	1197	1197	1197	10	1197	\N	\N
158	138	t	1198	1198	1198	1198	1198	10	1198	\N	\N
159	139	t	1248	1248	1248	1248	1248	6	1248	\N	\N
160	140	t	1253	1253	1253	1253	1253	6	1253	\N	\N
161	141	t	1257	1257	1257	1257	1257	6	1257	\N	\N
162	142	t	1261	1261	1261	1261	1261	6	1261	\N	\N
163	144	t	1268	1268	1268	1268	1268	6	1268	\N	\N
164	145	t	1272	1272	1272	1272	1272	6	1272	\N	\N
165	143	t	1293	1293	1293	1293	1293	6	1293	\N	\N
248	232	f	2040	2040	2040	2040	2040	18	2040	0.90000	2043
186	152	t	1409	1409	1409	1409	1409	4	1409	0.05000	2043
185	150	t	1405	1405	1405	1405	1405	4	1405	0.36191	2048
92	69	f	673	673	673	673	673	4	\N	\N	\N
93	69	f	674	674	674	674	674	4	\N	\N	\N
94	70	t	685	685	685	685	685	10	\N	\N	\N
95	70	t	687	687	687	687	687	10	\N	\N	\N
84	63	t	511	511	511	511	1792	4	\N	0.48400	2078
97	72	t	699	699	699	699	699	1	\N	\N	\N
167	146	t	1304	1304	1304	1304	1304	4	1304	\N	\N
168	146	t	1305	1305	1305	1305	1305	4	1305	\N	\N
189	62	f	1422	1422	1422	1422	1422	3	1422	0.41797	2147
203	174	f	1623	1623	1623	1623	1623	8	1623	0.05911	2194
250	183	f	2075	2075	2075	2075	2075	18	2075	0.80000	2078
210	182	f	1654	1654	1654	1654	1654	3	1654	0.03200	2078
43	40	t	158	158	158	158	1161	1	\N	0.90000	2092
107	70	f	780	780	780	780	780	10	\N	\N	\N
207	176	f	1638	1638	1638	1638	1638	3	1638	0.19700	2178
134	128	t	994	994	994	994	994	8	\N	\N	\N
110	91	t	828	828	828	828	1128	6	\N	\N	\N
254	246	t	2124	2124	2124	2124	2124	18	2124	\N	2124
169	146	t	1306	1306	1306	1306	1306	4	1306	\N	\N
83	62	t	507	507	507	507	1430	4	\N	0.03216	2147
205	174	t	1626	1626	1626	1626	1626	3	1626	0.50000	2198
127	115	t	934	934	934	934	934	1	\N	\N	\N
128	116	t	937	937	937	937	937	1	\N	\N	\N
129	117	t	941	941	941	941	941	1	\N	\N	\N
256	246	t	2126	2126	2126	2126	2126	18	2126	\N	2126
33	28	t	\N	\N	\N	\N	1116	4	\N	0.97500	2096
82	62	t	506	506	506	506	1678	4	\N	0.48230	2099
257	246	t	2127	2127	2127	2127	2127	18	2127	\N	2127
135	131	t	1033	1033	1033	1033	1033	13	\N	\N	\N
136	132	t	1036	1036	1036	1036	1036	6	\N	\N	\N
170	146	t	1307	1307	1307	1307	1307	4	1307	\N	\N
171	146	f	1308	1308	1308	1308	1308	4	1308	\N	\N
172	146	f	1309	1309	1309	1309	1309	4	1309	\N	\N
173	146	f	1310	1310	1310	1310	1310	4	1310	\N	\N
175	146	f	1312	1312	1312	1312	1312	11	1312	\N	\N
174	146	f	1311	1311	1311	1311	1313	1	1311	\N	\N
166	146	t	1303	1303	1303	1303	1314	1	1303	\N	\N
34	28	f	\N	\N	\N	\N	1115	2	\N	\N	\N
44	38	t	161	161	161	161	1117	7	\N	\N	\N
45	38	t	162	162	162	162	1118	6	\N	\N	\N
111	96	t	831	831	831	831	1130	1	\N	\N	\N
117	49	t	867	867	867	867	1122	1	\N	\N	\N
41	39	t	149	149	149	149	1123	1	\N	\N	\N
80	42	t	452	452	452	452	1124	8	\N	\N	\N
49	43	t	173	173	173	173	1125	1	\N	\N	\N
81	44	t	455	455	455	455	1126	8	\N	\N	\N
50	46	t	183	183	183	183	1127	8	\N	\N	\N
112	97	t	834	834	834	834	1132	1	\N	\N	\N
114	98	t	850	850	850	850	1133	1	\N	\N	\N
119	101	t	874	874	874	874	1135	1	\N	\N	\N
120	102	t	877	877	877	877	1136	1	\N	\N	\N
115	99	t	857	857	857	857	1137	1	\N	\N	\N
116	99	t	858	858	858	858	1138	1	\N	\N	\N
113	45	f	845	845	845	845	1139	6	\N	\N	\N
62	52	t	288	288	288	288	1140	1	\N	\N	\N
68	53	t	296	296	296	296	1141	8	\N	\N	\N
72	53	t	307	307	307	307	1142	8	\N	\N	\N
63	52	t	289	289	289	289	1143	4	\N	\N	\N
74	54	t	311	311	311	311	1144	8	\N	\N	\N
75	54	t	312	312	312	312	1145	8	\N	\N	\N
73	52	t	308	308	308	308	1146	4	\N	\N	\N
51	47	t	187	187	187	187	1147	4	\N	\N	\N
52	47	t	188	188	188	188	1148	4	\N	\N	\N
53	47	t	189	189	189	189	1149	4	\N	\N	\N
54	47	f	203	203	203	203	1150	4	\N	\N	\N
194	158	f	1527	1527	1527	1527	1527	6	1527	\N	\N
197	167	t	1582	1582	1582	1582	1582	17	1582	\N	\N
198	168	t	1588	1588	1588	1588	1588	8	1588	\N	\N
199	168	t	1589	1589	1589	1589	1590	8	1589	\N	\N
200	169	f	1593	1593	1593	1593	1593	15	1593	\N	\N
201	172	f	1606	1606	1606	1606	1606	3	1606	\N	\N
204	174	f	1624	1624	1624	1624	1624	8	1624	\N	\N
208	177	t	1643	1643	1643	1643	1643	12	1643	\N	\N
209	181	f	1651	1651	1651	1651	1651	3	1651	\N	\N
211	183	f	1659	1659	1659	1659	1659	3	1659	\N	\N
212	184	f	1662	1662	1662	1662	1662	3	1662	\N	\N
184	150	f	1404	1404	1404	1404	1404	17	1404	0.95000	1970
187	152	f	1410	1410	1410	1410	1410	4	1410	0.30000	1967
206	175	f	1632	1632	1635	1632	1664	3	1632	\N	\N
218	190	t	1718	1718	1718	1718	1728	3	1718	\N	\N
228	217	f	1818	1818	1818	1818	1818	13	1818	\N	\N
229	218	t	1825	1825	1825	1825	1825	13	1825	\N	\N
230	218	f	1826	1826	1826	1826	1826	13	1826	\N	\N
249	215	f	2066	2066	2066	2066	2066	18	2066	\N	2066
224	183	f	1801	1801	1801	1801	1801	13	1801	0.60000	2072
225	183	f	1802	1802	1802	1802	1802	13	1802	0.20000	2074
251	176	t	2082	2082	2082	2082	2082	18	2082	0.98000	2085
245	233	f	1962	1962	1962	1962	1962	18	1962	0.40000	1967
253	173	f	2100	2100	2100	2100	2100	18	2100	0.85000	2103
255	246	t	2125	2125	2125	2125	2125	18	2125	\N	2125
258	246	t	2128	2128	2128	2128	2128	18	2128	\N	2128
259	246	t	2129	2129	2129	2129	2129	18	2129	\N	2129
260	246	t	2130	2130	2130	2130	2130	18	2130	\N	2130
262	253	t	2139	2139	2139	2139	2139	18	2139	0.17000	2147
261	252	f	2135	2135	2135	2135	2135	18	2135	0.58500	2147
252	171	f	2086	2086	2086	2086	2086	18	2086	0.15562	2147
202	173	f	1609	1609	1609	1609	1609	3	1609	0.42219	2147
263	255	f	2148	2148	2148	2148	2148	18	2148	\N	2148
265	258	t	2175	2175	2175	2175	2175	18	2175	0.92000	2178
264	244	t	2154	2154	2154	2154	2159	18	2154	0.57600	2178
266	260	f	2188	2188	2188	2188	2188	18	2188	0.88000	2194
\.


--
-- Data for Name: argument_analogy; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_analogy (id, id_expl_id, text_expl_id) FROM stdin;
34	\N	329
\.


--
-- Data for Name: argument_authority; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_authority (id, source_url, authority_expl_id, id_expl_id, quote_expl_id, source_title_expl_id, source_url_expl_id) FROM stdin;
48	https://www.theguardian.com/environment/2009/nov/20/climate-sceptics-hackers-leaked-emails	167	167	167	167	167
49	https://www.metoffice.gov.uk/research/approach/collaboration/ukcp/forecasts-projections	173	173	173	173	173
62	https://www.bbc.co.uk/news/uk-67665218	288	288	288	288	288
43	https://science.nasa.gov/earth/climate-change/study-confirms-climate-models-are-getting-future-warming-projections-right/	158	158	338	158	158
97	https://www.europarl.europa.eu/doceo/document/E-9-2023-001201_EN.html	699	699	699	699	699
41	https://www.pbs.org/newshour/science/analysis-is-it-actually-hotter-now-than-any-time-in-the-last-100000-years	810	149	149	149	149
111	https://en.wikipedia.org/wiki/Discovery_of_penicillin#:~:text=In%201944%2C%20Margaret%20Jennings%20,This%20brought%20Fleming%27s%20explanation%20into	831	831	831	831	831
112	https://www.ox.ac.uk/news/science-blog/penicillin-oxford-story#:~:text=Still%2C%20Eric%20Sidebottom%20suggests%20some,%E2%80%99	834	834	834	834	834
114	https://www.ipcc.ch/report/ar6/wg1/chapter/chapter-7/#7.4.2.2	850	850	850	850	850
115	https://www.sciencedaily.com/releases/2021/07/210719153522.htm	857	857	857	857	857
116	https://www.ipcc.ch/report/ar6/wg1/chapter/chapter-7/#7.4.2.4.3	858	858	858	858	858
119	https://archive.ipcc.ch/publications_and_data/ar4/wg2/en/ch10s10-6-2.html	874	874	874	874	874
120	IPCC officials admit mistake over melting Himalayan glaciers	877	877	877	877	877
124	https://www.sciencemediacentre.org/expert-reaction-to-claims-climate-research-was-suppressed/#:~:text=%E2%80%9CI%20was%20surprised%20by%20the,into%20the%20global%20climate%20debate	902	902	902	902	902
127	https://historyofeconomicthought.mcmaster.ca/aristotle/Ethics.pdf	934	934	934	934	934
128	https://historyofeconomicthought.mcmaster.ca/aristotle/Politics.pdf	937	937	937	937	938
129	https://historyofeconomicthought.mcmaster.ca/aristotle/Politics.pdf	941	941	941	941	941
117	https://www.youtube.com/watch?v=02eF9W_u1nI	867	867	1120	867	867
174	https://www.who.int/news/item/27-06-2025-who-scientific-advisory-group-issues-report-on-origins-of-covid-19	1311	1311	1311	1311	1311
166	https://www.wsj.com/politics/national-security/cia-now-favors-lab-leak-theory-on-origins-of-covid-19-eff4e67c	1314	1303	1336	1303	1303
\.


--
-- Data for Name: argument_causal; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_causal (id, id_expl_id, text_expl_id) FROM stdin;
135	1033	1033
228	1818	1818
229	1825	1825
230	1826	1826
224	1801	2060
225	1802	2067
\.


--
-- Data for Name: argument_certainty_criterion; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_certainty_criterion (id, id_expl_id, argument_type_id, argument_type_id_expl_id, min_value_expl_id, max_value_expl_id, description_expl_id, min_value, max_value) FROM stdin;
1	\N	2	\N	\N	\N	\N	0.00000	0.20000
2	\N	2	\N	\N	\N	\N	0.20000	0.50000
3	\N	2	\N	\N	\N	\N	0.50000	0.80000
4	\N	2	\N	\N	\N	\N	0.80000	1.00000
5	\N	7	\N	\N	\N	\N	0.00000	0.20000
6	\N	7	\N	\N	\N	\N	0.20000	0.50000
7	\N	7	\N	\N	\N	\N	0.50000	0.80000
8	\N	7	\N	\N	\N	\N	0.80000	1.00000
9	\N	6	\N	\N	\N	\N	0.00000	0.50000
10	\N	6	\N	\N	\N	\N	0.50000	0.75000
11	\N	6	\N	\N	\N	\N	0.75000	0.99000
12	\N	6	\N	\N	\N	\N	1.00000	1.00000
13	\N	5	\N	\N	\N	\N	0.00000	0.50000
14	\N	5	\N	\N	\N	\N	0.50000	0.75000
15	\N	5	\N	\N	\N	\N	0.75000	0.99000
16	\N	5	\N	\N	\N	\N	0.99000	1.00000
17	\N	12	\N	\N	\N	\N	0.00000	0.50000
18	\N	12	\N	\N	\N	\N	0.50000	0.75000
19	\N	12	\N	\N	\N	\N	0.75000	0.99000
20	\N	12	\N	\N	\N	\N	0.99000	1.00000
21	\N	1	\N	\N	\N	\N	0.00000	0.05000
22	\N	1	\N	\N	\N	\N	0.05000	0.25000
23	\N	1	\N	\N	\N	\N	0.25000	0.50000
24	\N	1	\N	\N	\N	\N	0.50000	0.75000
25	\N	1	\N	\N	\N	\N	0.75000	1.00000
26	\N	8	\N	\N	\N	\N	0.00000	0.05000
27	\N	8	\N	\N	\N	\N	0.05000	0.25000
28	\N	8	\N	\N	\N	\N	0.25000	0.50000
29	\N	8	\N	\N	\N	\N	0.50000	0.75000
30	\N	8	\N	\N	\N	\N	0.75000	1.00000
31	\N	9	\N	\N	\N	\N	0.00000	0.00000
32	\N	9	\N	\N	\N	\N	0.00000	0.25000
33	\N	9	\N	\N	\N	\N	0.25000	0.50000
34	\N	9	\N	\N	\N	\N	0.50000	0.75000
35	\N	9	\N	\N	\N	\N	0.75000	1.00000
36	\N	4	\N	\N	\N	\N	0.00000	0.20000
37	\N	4	\N	\N	\N	\N	0.20000	0.40000
38	\N	4	\N	\N	\N	\N	0.40000	0.60000
39	\N	4	\N	\N	\N	\N	0.60000	0.80000
40	\N	4	\N	\N	\N	\N	0.80000	1.00000
41	\N	11	\N	\N	\N	\N	0.00000	0.20000
42	\N	11	\N	\N	\N	\N	0.20000	0.40000
43	\N	11	\N	\N	\N	\N	0.40000	0.60000
44	\N	11	\N	\N	\N	\N	0.60000	0.80000
45	\N	11	\N	\N	\N	\N	0.80000	1.00000
46	\N	13	\N	\N	\N	\N	0.00000	0.10000
47	\N	13	\N	\N	\N	\N	0.10000	0.30000
48	\N	13	\N	\N	\N	\N	0.30000	0.50000
49	\N	13	\N	\N	\N	\N	0.50000	0.70000
50	\N	13	\N	\N	\N	\N	0.70000	0.90000
51	\N	13	\N	\N	\N	\N	0.90000	1.00000
52	\N	14	\N	\N	\N	\N	0.00000	0.10000
53	\N	14	\N	\N	\N	\N	0.10000	0.35000
54	\N	14	\N	\N	\N	\N	0.35000	0.65000
55	\N	14	\N	\N	\N	\N	0.65000	0.90000
56	\N	14	\N	\N	\N	\N	0.90000	1.00000
57	\N	10	\N	\N	\N	\N	0.00000	0.10000
58	\N	10	\N	\N	\N	\N	0.10000	0.35000
59	\N	10	\N	\N	\N	\N	0.35000	0.65000
60	\N	10	\N	\N	\N	\N	0.65000	0.90000
61	\N	10	\N	\N	\N	\N	0.90000	1.00000
62	\N	15	\N	\N	\N	\N	0.00000	0.10000
63	\N	15	\N	\N	\N	\N	0.10000	0.35000
64	\N	15	\N	\N	\N	\N	0.35000	0.60000
65	\N	15	\N	\N	\N	\N	0.60000	0.85000
66	\N	15	\N	\N	\N	\N	0.85000	1.00000
67	\N	16	\N	\N	\N	\N	0.00000	0.10000
68	\N	16	\N	\N	\N	\N	0.10000	0.35000
69	\N	16	\N	\N	\N	\N	0.35000	0.60000
70	\N	16	\N	\N	\N	\N	0.60000	0.85000
71	\N	16	\N	\N	\N	\N	0.85000	1.00000
72	1385	17	1385	1387	1385	1387	0.00000	0.20000
73	1386	17	1386	1386	1386	1388	0.20000	0.40000
74	1389	17	1389	1389	1389	1389	0.40000	0.60000
75	1390	17	1390	1390	1390	1390	0.60000	0.80000
76	1391	17	1391	1391	1391	1391	0.80000	1.00000
\.


--
-- Data for Name: argument_conditional; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_conditional (id, conditional_confidence, conditional_confidence_expl_id, conditional_explanation_expl_id, id_expl_id) FROM stdin;
63	0.30000	473	473	473
73	0.10000	477	475	475
116	0.02500	885	862	862
167	0.15000	1329	1329	1318
168	0.10000	1331	1331	1320
169	0.18000	1333	1333	1323
170	0.05000	1335	1335	1325
172	0.15000	1339	1339	1339
173	0.07000	1341	1341	1341
174	0.10000	1343	1343	1343
175	0.05000	1346	1346	1346
\.


--
-- Data for Name: argument_contradiction; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_contradiction (id, id_expl_id, text_expl_id) FROM stdin;
200	1593	1726
\.


--
-- Data for Name: argument_deduction; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_deduction (id, id_expl_id, text_expl_id) FROM stdin;
45	162	162
110	828	828
113	845	845
136	1036	1036
159	1248	1248
160	1253	1253
161	1257	1257
162	1261	1261
163	1268	1268
164	1272	1272
165	1293	1293
194	1527	1527
\.


--
-- Data for Name: argument_definition; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_definition (id, id_expl_id, text_expl_id) FROM stdin;
208	1643	1643
\.


--
-- Data for Name: argument_epistemic; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_epistemic (id, id_expl_id, text_expl_id) FROM stdin;
40	146	146
42	153	153
\.


--
-- Data for Name: argument_example; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_example (id, id_expl_id, text_expl_id) FROM stdin;
50	183	183
68	296	296
72	307	307
74	311	311
75	312	312
80	452	452
81	455	455
118	869	869
122	897	897
123	899	899
134	994	994
198	1588	1588
199	1589	1589
203	1623	1623
204	1624	1624
\.


--
-- Data for Name: argument_explanation; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_explanation (id, id_expl_id, text_expl_id) FROM stdin;
33	\N	\N
46	163	163
47	164	164
51	187	187
52	188	188
54	203	203
59	285	285
60	286	286
61	287	287
63	289	289
73	308	308
53	189	487
82	506	506
83	507	507
84	511	516
92	673	673
93	674	674
121	895	895
167	1304	1304
168	1305	1305
170	1307	1307
171	1308	1308
172	1309	1309
173	1310	1310
169	1306	1353
185	1405	1405
186	1409	1409
187	1410	1410
\.


--
-- Data for Name: argument_extrapolation; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_extrapolation (id, id_expl_id, text_expl_id) FROM stdin;
44	161	161
\.


--
-- Data for Name: argument_feasibility; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_feasibility (id, id_expl_id, text_expl_id) FROM stdin;
\.


--
-- Data for Name: argument_grading_example; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_grading_example (id, id_expl_id, argument_type_id, argument_type_id_expl_id, grade_expl_id, argument_expl_id, conclusion_expl_id, explanation_expl_id, grade) FROM stdin;
1	\N	2	\N	\N	\N	\N	\N	0.15000
2	\N	2	\N	\N	\N	\N	\N	0.40000
3	\N	2	\N	\N	\N	\N	\N	0.75000
4	\N	7	\N	\N	\N	\N	\N	0.10000
5	\N	7	\N	\N	\N	\N	\N	0.35000
6	\N	7	\N	\N	\N	\N	\N	0.70000
7	\N	6	\N	\N	\N	\N	\N	1.00000
8	\N	6	\N	\N	\N	\N	\N	0.85000
9	\N	6	\N	\N	\N	\N	\N	0.60000
10	\N	6	\N	\N	\N	\N	\N	0.20000
11	\N	5	\N	\N	\N	\N	\N	0.95000
12	\N	5	\N	\N	\N	\N	\N	0.80000
13	\N	5	\N	\N	\N	\N	\N	0.60000
14	\N	5	\N	\N	\N	\N	\N	0.25000
15	\N	12	\N	\N	\N	\N	\N	1.00000
16	\N	12	\N	\N	\N	\N	\N	0.85000
17	\N	12	\N	\N	\N	\N	\N	0.60000
18	\N	12	\N	\N	\N	\N	\N	0.30000
19	\N	1	\N	\N	\N	\N	\N	0.25000
20	\N	1	\N	\N	\N	\N	\N	0.50000
21	\N	1	\N	\N	\N	\N	\N	0.75000
22	\N	8	\N	\N	\N	\N	\N	0.25000
23	\N	8	\N	\N	\N	\N	\N	0.50000
24	\N	8	\N	\N	\N	\N	\N	0.75000
25	\N	9	\N	\N	\N	\N	\N	0.25000
26	\N	9	\N	\N	\N	\N	\N	0.50000
27	\N	9	\N	\N	\N	\N	\N	0.75000
28	\N	4	\N	\N	\N	\N	\N	0.20000
29	\N	4	\N	\N	\N	\N	\N	0.65000
30	\N	4	\N	\N	\N	\N	\N	0.95000
32	\N	11	\N	\N	\N	\N	\N	0.60000
33	\N	11	\N	\N	\N	\N	\N	0.90000
34	\N	13	\N	\N	\N	\N	\N	0.05000
35	\N	13	\N	\N	\N	\N	\N	0.55000
36	\N	13	\N	\N	\N	\N	\N	0.90000
37	\N	14	\N	\N	\N	\N	\N	0.25000
38	\N	14	\N	\N	\N	\N	\N	0.50000
39	\N	14	\N	\N	\N	\N	\N	0.75000
40	\N	14	\N	\N	\N	\N	\N	1.00000
41	\N	10	\N	\N	\N	\N	\N	0.25000
42	\N	10	\N	\N	\N	\N	\N	0.50000
43	\N	10	\N	\N	\N	\N	\N	0.75000
44	\N	10	\N	\N	\N	\N	\N	1.00000
45	\N	15	\N	\N	\N	\N	\N	0.00000
46	\N	15	\N	\N	\N	\N	\N	0.25000
47	\N	15	\N	\N	\N	\N	\N	0.50000
48	\N	15	\N	\N	\N	\N	\N	0.75000
49	\N	15	\N	\N	\N	\N	\N	1.00000
50	\N	16	\N	\N	\N	\N	\N	0.00000
51	\N	16	\N	\N	\N	\N	\N	0.25000
52	\N	16	\N	\N	\N	\N	\N	0.50000
53	\N	16	\N	\N	\N	\N	\N	0.75000
54	\N	16	\N	\N	\N	\N	\N	1.00000
31	\N	11	\N	\N	817	817	\N	0.10000
\.


--
-- Data for Name: argument_induction; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_induction (id, id_expl_id, text_expl_id) FROM stdin;
175	1312	1312
\.


--
-- Data for Name: argument_judgement; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_judgement (id, isolated_confidence, id_expl_id, isolated_confidence_expl_id, isolated_explanation_expl_id) FROM stdin;
80	0.90000	453	453	453
81	0.99000	456	456	456
49	0.90000	458	458	458
44	0.02000	460	460	460
62	0.85000	463	463	463
68	0.95000	464	464	464
72	0.95000	465	465	465
63	0.65000	467	467	467
74	0.95000	468	468	468
75	0.95000	469	469	469
73	0.75000	471	471	471
112	0.99900	836	836	836
111	0.98000	838	838	838
110	0.99000	840	840	840
50	1.00000	842	842	842
113	0.90000	846	846	846
115	0.50000	860	864	864
119	0.99990	875	875	875
120	0.99900	878	878	878
118	0.90000	880	880	880
116	0.05000	859	883	883
114	0.05000	853	888	888
45	0.85000	866	890	890
134	1.00000	995	995	995
136	1.00000	1037	1037	1037
135	0.15000	1039	1039	1039
166	0.25000	1316	1327	1327
167	0.20000	1317	1328	1328
168	0.15000	1319	1330	1330
169	0.30000	1322	1332	1332
170	0.18000	1324	1334	1334
171	0.30000	1337	1337	1337
172	0.22000	1338	1338	1338
173	0.10000	1340	1340	1340
174	0.18000	1342	1342	1342
175	0.12000	1344	1344	1344
186	0.70000	1411	1411	1411
187	0.30000	1412	1412	1412
185	0.75000	1414	1414	1414
184	0.90000	1415	1415	1415
194	0.70000	1528	1528	1528
228	0.70000	1819	1819	1819
\.


--
-- Data for Name: argument_normative; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_normative (id, id_expl_id, text_expl_id) FROM stdin;
\.


--
-- Data for Name: argument_obvious; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_obvious (id, id_expl_id, obvious_to_majority_expl_id, majority_is_qualified_expl_id, obvious_to_majority, majority_is_qualified) FROM stdin;
\.


--
-- Data for Name: argument_other; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_other (id, id_expl_id, text_expl_id) FROM stdin;
212	1662	1800
189	1422	2105
205	1626	2195
201	1606	1606
202	1609	1609
207	1638	1638
209	1651	1651
210	1654	1658
211	1659	1659
206	1632	1666
218	1718	1718
\.


--
-- Data for Name: argument_pragmatic; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_pragmatic (id, id_expl_id, text_expl_id) FROM stdin;
94	685	686
95	687	687
107	780	780
151	1190	1190
153	1193	1193
154	1194	1194
155	1195	1195
156	1196	1196
157	1197	1197
158	1198	1198
\.


--
-- Data for Name: argument_statistical; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_statistical (id, id_expl_id, text_expl_id) FROM stdin;
184	1404	1404
197	1582	1585
\.


--
-- Data for Name: argument_type; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_type (name, description_expl_id, id_expl_id, id, name_expl_id) FROM stdin;
analogy	781	\N	2	\N
deduction	783	159	6	159
epistemic	784	145	5	145
induction	785	785	11	785
causal	787	787	13	787
normative	788	788	14	788
contradiction	789	789	15	789
authority	792	\N	1	\N
explanation	794	\N	4	\N
example	795	182	8	182
obvious	796	385	9	385
definition	797	786	12	786
other	806	\N	3	\N
extrapolation	1173	160	7	160
feasibility	1174	790	16	790
pragmatic	1176	537	10	537
statistical	1384	1384	17	1384
unknown	1860	\N	18	\N
\.


--
-- Data for Name: argument_type_example; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_type_example (id, id_expl_id, argument_type_id, argument_type_id_expl_id, argument_expl_id, conclusion_expl_id) FROM stdin;
1	\N	2	\N	\N	\N
2	\N	2	\N	\N	\N
3	\N	2	\N	\N	\N
4	\N	7	\N	\N	\N
5	\N	7	\N	\N	\N
6	\N	7	\N	\N	\N
7	\N	6	\N	\N	\N
8	\N	6	\N	\N	\N
9	\N	6	\N	\N	\N
10	\N	5	\N	\N	\N
11	\N	5	\N	\N	\N
12	\N	5	\N	\N	\N
13	\N	12	\N	\N	\N
14	\N	12	\N	\N	\N
15	\N	1	\N	\N	\N
16	\N	1	\N	\N	\N
17	\N	1	\N	\N	\N
18	\N	8	\N	\N	\N
19	\N	9	\N	\N	\N
20	\N	9	\N	\N	\N
21	\N	9	\N	\N	\N
22	\N	4	\N	\N	\N
23	\N	4	\N	\N	\N
24	\N	4	\N	\N	\N
25	\N	11	\N	\N	\N
26	\N	11	\N	\N	\N
27	\N	11	\N	\N	\N
28	\N	13	\N	\N	\N
29	\N	13	\N	\N	\N
30	\N	13	\N	\N	\N
31	\N	14	\N	\N	\N
32	\N	14	\N	\N	\N
33	\N	14	\N	\N	\N
34	\N	10	\N	\N	\N
35	\N	10	\N	\N	\N
36	\N	10	\N	\N	\N
37	\N	15	\N	\N	\N
38	\N	15	\N	\N	\N
39	\N	15	\N	\N	\N
40	\N	15	\N	\N	\N
41	\N	15	\N	\N	\N
42	\N	15	\N	\N	\N
43	\N	16	\N	\N	\N
44	\N	16	\N	\N	\N
45	\N	\N	\N	\N	\N
46	\N	\N	\N	\N	\N
48	\N	\N	\N	\N	\N
49	\N	\N	\N	\N	\N
50	\N	\N	\N	\N	\N
47	\N	\N	\N	808	\N
\.


--
-- Data for Name: argument_unknown; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_unknown (id, id_expl_id, text_expl_id) FROM stdin;
245	1962	1962
248	2040	2040
249	2066	2066
250	2075	2075
251	2082	2082
253	2100	2100
254	2124	2124
255	2125	2125
256	2126	2126
257	2127	2127
258	2128	2128
259	2129	2129
260	2130	2130
252	2086	2131
262	2139	2141
263	2148	2148
261	2135	2151
264	2154	2170
265	2175	2175
266	2188	2204
\.


--
-- Data for Name: argument_weight; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_weight (id, weight_lower_limit, weight_mode, weight_upper_limit, id_expl_id, weight_explanation_expl_id, weight_lower_limit_expl_id, weight_mode_expl_id, weight_upper_limit_expl_id) FROM stdin;
59	5.00	10.00	20.00	484	484	484	484	484
51	5.00	10.00	20.00	485	485	485	485	485
53	0.00	5.00	20.00	488	488	488	488	488
60	5.00	10.00	20.00	489	489	489	489	489
61	5.00	7.00	10.00	490	490	490	490	490
52	5.00	15.00	20.00	492	492	492	492	492
54	10.00	15.00	25.00	491	491	491	491	741
229	1.00	3.00	7.00	1830	1830	1830	1830	1830
230	0.00	1.00	2.00	1831	1831	1831	1831	1831
\.


--
-- Data for Name: argument_x_definition; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.argument_x_definition (argument_id, definition_id, argument_id_expl_id, definition_id_expl_id) FROM stdin;
206	3	1634	1634
206	4	1668	1668
218	12	1719	1719
218	13	1719	1719
219	13	1773	1773
219	12	1773	1773
219	5	1774	1774
221	7	1778	1778
222	7	1780	1780
227	14	1813	1813
200	13	1851	1851
246	15	2008	2008
263	18	2150	2150
264	19	2155	2155
203	20	2181	2181
266	6	2189	2189
266	21	2189	2189
266	20	2189	2189
\.


--
-- Data for Name: auth_role; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.auth_role (id, id_expl_id, name_expl_id, name) FROM stdin;
1	\N	\N	admin
2	\N	\N	invited
\.


--
-- Data for Name: bet; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.bet (id, creator_id, statement_id, stake, duration_days, taker_id, start_date, creator_above, creator_won) FROM stdin;
3	18	150	5	14	\N	\N	f	\N
4	18	150	1	14	24	2025-11-20	t	\N
7	24	160	5	21	\N	\N	t	\N
8	32	169	4	14	\N	\N	f	\N
9	32	167	4	14	\N	\N	t	\N
10	32	172	4	14	\N	\N	f	\N
\.


--
-- Data for Name: bet_confidence; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.bet_confidence (id, threshold_value, outcome_value) FROM stdin;
3	0.10000	\N
4	0.05000	\N
5	0.50000	\N
8	0.51000	\N
9	0.49000	\N
10	0.51000	\N
\.


--
-- Data for Name: bet_net_value; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.bet_net_value (id, moral_weight_profile_id, threshold_value, outcome_value) FROM stdin;
7	1	0	\N
\.


--
-- Data for Name: chat_message; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.chat_message (id, user_id, "timestamp", text) FROM stdin;
22	34	1765121502	What are the different types of arguments that can be made in this app?
\.


--
-- Data for Name: critical_question; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.critical_question (id, argument_type_id_expl_id, id_expl_id, text_expl_id, argument_type_id) FROM stdin;
3	\N	\N	\N	1
1	155	\N	\N	\N
11	196	196	196	1
5	\N	\N	\N	\N
6	\N	\N	\N	\N
12	\N	\N	\N	\N
10	177	177	798	\N
4	\N	\N	799	1
7	138	138	800	2
8	141	141	801	4
9	168	168	802	7
16	\N	\N	\N	7
17	\N	\N	\N	6
18	\N	\N	\N	6
19	\N	\N	\N	5
20	\N	\N	\N	5
21	\N	\N	\N	5
22	\N	\N	\N	12
23	\N	\N	\N	12
24	\N	\N	\N	12
25	\N	\N	\N	1
26	\N	\N	\N	1
27	\N	\N	\N	8
28	\N	\N	\N	9
29	\N	\N	\N	9
30	\N	\N	\N	4
31	\N	\N	\N	4
32	\N	\N	\N	11
33	\N	\N	\N	11
34	\N	\N	\N	11
35	\N	\N	\N	11
36	\N	\N	\N	13
37	\N	\N	\N	10
38	\N	\N	\N	10
39	\N	\N	\N	10
40	\N	\N	\N	15
42	\N	\N	\N	15
43	\N	\N	\N	16
13	\N	\N	803	2
14	\N	\N	804	2
15	\N	\N	805	7
2	\N	\N	\N	\N
44	813	813	813	3
45	814	814	814	3
47	1018	1018	1018	10
41	\N	\N	1594	15
\.


--
-- Data for Name: critical_statement; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.critical_statement (id, argument_id, critical_question_id, statement_id, argument_id_expl_id, critical_question_id_expl_id, id_expl_id, statement_id_expl_id) FROM stdin;
20	34	7	37	140	140	140	140
21	33	8	38	143	143	143	143
22	34	7	39	148	148	148	148
24	42	1	40	157	157	157	157
26	44	9	42	170	170	170	170
27	44	9	43	172	172	172	172
28	49	4	44	175	175	175	175
29	45	10	45	179	179	179	179
30	45	1	46	181	181	181	181
31	47	1	47	185	185	185	185
32	47	1	48	192	192	192	192
33	48	11	49	198	198	198	198
34	48	11	50	200	200	200	200
35	48	11	51	202	202	202	202
36	54	1	52	205	205	205	205
37	63	1	53	291	291	291	291
38	73	1	54	310	310	310	310
51	82	1	63	509	509	509	509
52	83	1	63	510	510	510	510
57	50	1	91	821	821	821	821
59	110	1	96	830	830	830	830
60	110	1	97	833	833	833	833
61	45	1	98	849	849	849	849
62	45	1	99	856	856	856	856
63	118	1	101	871	871	871	871
64	118	1	102	873	873	873	873
65	116	25	100	882	882	882	882
66	114	25	100	887	887	887	887
68	46	1	103	894	894	894	894
69	121	1	47	896	896	896	896
70	122	1	100	898	898	898	898
71	123	1	104	901	901	901	901
81	128	4	119	947	947	947	947
82	129	1	120	949	949	949	949
83	129	1	121	951	951	951	951
94	135	36	132	1035	1035	1035	1035
99	151	47	139	1240	1240	1240	1240
100	153	47	140	1251	1251	1251	1251
101	154	47	141	1255	1255	1255	1255
102	155	47	142	1259	1259	1259	1259
103	156	47	143	1263	1263	1263	1263
104	157	47	144	1267	1267	1267	1267
105	158	47	145	1271	1271	1271	1271
108	185	1	152	1408	1408	1408	1408
112	197	1	168	1587	1587	1587	1587
113	197	12	170	1596	1596	1596	1596
114	189	1	171	1601	1601	1601	1601
115	83	1	173	1608	1608	1608	1608
116	202	1	171	1610	1610	1610	1610
118	203	1	176	1637	1637	1637	1637
119	207	1	177	1640	1640	1640	1640
120	207	1	178	1642	1642	1642	1642
121	208	1	179	1645	1645	1645	1645
122	208	1	180	1647	1647	1647	1647
123	204	1	181	1649	1649	1649	1649
124	84	1	182	1653	1653	1653	1653
125	210	1	183	1657	1657	1657	1657
126	211	1	184	1661	1661	1661	1661
127	218	1	187	1720	1720	1720	1720
128	218	1	169	1721	1721	1721	1721
130	225	12	214	1804	1804	1804	1804
131	224	12	215	1806	1806	1806	1806
133	230	6	217	1827	1827	1827	1827
\.


--
-- Data for Name: critical_statement_example; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.critical_statement_example (id, id_expl_id, argument_type_example_id, critical_question_id, argument_type_example_id_expl_id, critical_question_id_expl_id, statement_expl_id) FROM stdin;
1	\N	1	7	\N	\N	\N
2	\N	2	13	\N	\N	\N
3	\N	3	14	\N	\N	\N
4	\N	4	9	\N	\N	\N
5	\N	5	15	\N	\N	\N
6	\N	6	16	\N	\N	\N
7	\N	7	17	\N	\N	\N
8	\N	8	18	\N	\N	\N
9	\N	10	20	\N	\N	\N
10	\N	11	19	\N	\N	\N
11	\N	12	21	\N	\N	\N
12	\N	13	22	\N	\N	\N
13	\N	14	23	\N	\N	\N
14	\N	15	25	\N	\N	\N
15	\N	15	26	\N	\N	\N
16	\N	16	11	\N	\N	\N
17	\N	16	4	\N	\N	\N
19	\N	17	26	\N	\N	\N
20	\N	18	27	\N	\N	\N
21	\N	19	28	\N	\N	\N
22	\N	20	29	\N	\N	\N
23	\N	21	28	\N	\N	\N
24	\N	22	30	\N	\N	\N
25	\N	23	8	\N	\N	\N
26	\N	24	31	\N	\N	\N
27	\N	25	32	\N	\N	\N
28	\N	26	35	\N	\N	\N
29	\N	27	34	\N	\N	\N
30	\N	28	36	\N	\N	\N
31	\N	29	36	\N	\N	\N
32	\N	34	37	\N	\N	\N
33	\N	35	38	\N	\N	\N
34	\N	36	39	\N	\N	\N
35	\N	37	41	\N	\N	\N
36	\N	38	42	\N	\N	\N
37	\N	39	40	\N	\N	\N
38	\N	43	43	\N	\N	\N
39	\N	44	43	\N	\N	\N
40	\N	45	1	\N	\N	\N
41	\N	46	10	\N	\N	\N
42	\N	47	2	\N	\N	\N
43	\N	48	5	\N	\N	\N
44	\N	49	6	\N	\N	\N
45	\N	50	12	\N	\N	\N
18	\N	17	3	\N	\N	\N
\.


--
-- Data for Name: debate; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.debate (id, creator_id, statement_id, taker_id, creator_above, creator_won) FROM stdin;
1	18	174	26	f	\N
\.


--
-- Data for Name: debate_confidence; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.debate_confidence (id, threshold_value) FROM stdin;
1	0.50000
\.


--
-- Data for Name: debate_net_value; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.debate_net_value (id, moral_weight_profile_id, threshold_value) FROM stdin;
\.


--
-- Data for Name: deed; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.deed (id, id_expl_id, text_expl_id) FROM stdin;
1	\N	\N
2	495	495
3	526	526
4	677	677
5	688	688
6	755	755
7	761	761
8	766	766
9	925	958
11	1041	1041
12	1186	1186
13	1564	1564
\.


--
-- Data for Name: definition; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.definition (id, id_expl_id, term_expl_id, text_expl_id) FROM stdin;
6	1674	1674	1674
7	1681	1681	1681
8	1692	1692	1692
9	1694	1694	1694
10	1696	1696	1696
11	1698	1698	1698
12	1700	1700	1700
13	1701	1701	1710
14	1808	1808	1808
15	2006	2006	2006
17	2055	2055	2055
16	2051	2058	2051
18	2149	2149	2149
19	2153	2153	2153
20	2179	2179	2179
21	2185	2187	2187
22	2199	2199	2199
\.


--
-- Data for Name: definition_target_x_definition_source; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.definition_target_x_definition_source (definition_target_id, definition_source_id, definition_target_id_expl_id, definition_source_id_expl_id) FROM stdin;
1	2	1663	1663
4	5	1670	1670
5	2	1671	1671
6	21	2186	2186
21	22	2200	2200
\.


--
-- Data for Name: directive; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.directive (id, deed_id, deed_id_expl_id, id_expl_id) FROM stdin;
70	4	678	678
124	3	975	975
133	11	1042	1042
138	12	1187	1187
160	13	1565	1565
\.


--
-- Data for Name: directive_consequence; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.directive_consequence (id, moral_good_id, value_id, id_expl_id, moral_good_id_expl_id, value_id_expl_id, argument_id, argument_id_expl_id) FROM stdin;
18	6	1	1247	1247	1247	151	1247
19	6	2	1249	1249	1249	153	1249
20	7	3	1256	1256	1256	154	1256
21	8	4	1260	1260	1260	155	1260
22	8	5	1264	1264	1264	156	1264
23	9	6	1266	1266	1266	157	1266
24	10	7	1270	1270	1270	158	1270
\.


--
-- Data for Name: directive_scope; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.directive_scope (id, directive_id, person_category_id, include, directive_id_expl_id, id_expl_id, include_expl_id, person_category_id_expl_id) FROM stdin;
6	70	4	t	680	680	680	680
14	124	4	t	977	977	977	977
15	124	3	f	987	987	987	987
17	133	7	t	1045	1045	1045	1045
18	138	5	t	1189	1189	1189	1189
19	160	8	t	1567	1567	1567	1567
\.


--
-- Data for Name: expl; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.expl ("timestamp", id, user_id, version, record_id, action, table_name, data) FROM stdin;
2025-03-03 15:04:20.630152+00	48	2	1	29	updateRecord	statement	{"id": 29, "diff": {"after": {"text": "Test statement 1.9"}, "before": {"text": "Test statement 1.8", "text_expl_id": null}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "statement", "targetLabel": "(?) Test statement 1.9"}
2025-03-03 15:05:03.967416+00	49	2	1	29	updateRecord	statement	{"id": 29, "diff": {"after": {"text": "Test statement 1.10"}, "before": {"text": "Test statement 1.9", "text_expl_id": 48}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "statement", "targetLabel": "(?) Test statement 1.10"}
2025-03-03 15:22:04.971773+00	50	2	1	1	updateExtRecord	argument	{"id": 1, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {"title": "Both are yellow and round.."}, "before": {"title": "Both are yellow and round.", "title_expl_id": null}}, "extRecord": {"after": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese.."}, "before": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese.", "text_expl_id": null}}, "tableName": "argument", "targetLabel": "Both are yellow and round..", "extTableName": "argument_analogy"}
2025-03-10 08:35:45.036068+00	214	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"name": "Martinnn"}, "before": {"name": "MartinnnM", "name_expl_id": 213}}, "user": {"id": 11, "name": "MartinnnM", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martinnn"}
2025-03-03 16:35:49.091061+00	53	2	1	8	insertRecord	invite	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 8, "code": "mScxXVHd", "owner_id": 2, "person_id": null, "id_expl_id": 53, "code_expl_id": 53, "owner_id_expl_id": 53, "person_id_expl_id": 53}, "tableName": "invite", "targetLabel": "mScxXVHd"}
2025-03-04 10:38:03.305519+00	59	2	1	2	insertRecord	person_secret	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 2, "email": "eee", "owner_id": 2, "password": "ppp", "id_expl_id": 59, "email_expl_id": 59, "owner_id_expl_id": 59, "password_expl_id": 59}, "tableName": "person_secret", "targetLabel": "eee"}
2025-03-04 17:16:11.957482+00	71	2	1	31	insertRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 31, "text": "Brussels is the capital of Belgium", "label": "(?) Brussels is the capital of Belgium", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 71, "text_expl_id": 71, "decided_expl_id": 71, "featured_expl_id": 71, "confidence_expl_id": 71, "judgement_requested": false, "judgement_requested_expl_id": 71, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}, "tableName": "statement", "targetLabel": "(?) Brussels is the capital of Belgium"}
2025-03-04 10:58:59.566953+00	62	2	1	15	join	person	{"person": {"id": 15, "name": "Toro"}, "inviter": {"id": 2, "name": "Alice", "auth_role": "invited"}}
2025-03-04 17:49:03.692499+00	72	2	1	35	insertExtRecord	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 35, "pro": true, "title": "Both start with B", "id_expl_id": 72, "pro_expl_id": 72, "statement_id": 31, "title_expl_id": 72, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": 72, "argument_type_id_expl_id": 72, "judgement_requested_expl_id": 72}, "extRecord": {"id": 35, "text": "Both start with the letter \\"B\\"", "id_expl_id": 72, "text_expl_id": 72}, "tableName": "argument", "targetLabel": "Both start with B", "extTableName": "argument_analogy"}
2025-03-04 11:05:15.569102+00	63	2	1	9	insertRecord	invite	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 9, "code": "VUNuFl9Q", "owner_id": 2, "person_id": null, "id_expl_id": 63, "code_expl_id": 63, "owner_id_expl_id": 63, "person_id_expl_id": 63}, "tableName": "invite", "targetLabel": "VUNuFl9Q"}
2025-03-04 17:52:39.99959+00	73	2	1	36	insertExtRecord	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 36, "pro": false, "title": "End in different letters", "id_expl_id": 73, "pro_expl_id": 73, "statement_id": 31, "title_expl_id": 73, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": 73, "argument_type_id_expl_id": 73, "judgement_requested_expl_id": 73}, "extRecord": {"id": 36, "text": "One ends with \\"s\\", another with \\"m\\".", "id_expl_id": 73, "text_expl_id": 73}, "tableName": "argument", "targetLabel": "End in different letters", "extTableName": "argument_analogy"}
2025-03-04 11:14:33.206391+00	64	2	1	16	join	person	{"person": {"id": 16, "name": "Goro"}, "inviter": {"id": 2, "name": "Alice", "auth_role": "invited"}}
2025-03-04 11:21:23.823752+00	65	2	1	29	deleteExtById	statement	{"id": 29, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 29, "text": "Test statement 1.10", "label": "(?) Test statement 1.10", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": null, "text_expl_id": 49, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "judgement_requested": false, "judgement_requested_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": null}, "tableName": "statement", "targetLabel": "(?) Test statement 1.10"}
2025-03-31 18:56:23.744815+00	504	5	1	18	join	person	{"person": {"id": 18, "name": "Durante"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-03-05 06:24:59.4097+00	89	2	1	15	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 15, "id_expl_id": 89, "argument_id": 37, "statement_id": 17, "argument_id_expl_id": 89, "critical_question_id": 2, "statement_id_expl_id": 89, "critical_question_id_expl_id": 89}, "tableName": "critical_statement", "targetLabel": "Wikipedia is not always correct"}
2025-03-08 06:58:27.856457+00	141	13	1	8	insertRecord	critical_question	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 8, "text": "Is the effect strong enough to explain the full extent of the observed change?", "id_expl_id": 141, "text_expl_id": 141, "argument_type_id": 4, "argument_type_id_expl_id": 141}, "tableName": "critical_question", "targetLabel": "Is the effect strong enough to explain the full extent of the observed change?"}
2025-11-30 06:52:03.937856+00	1719	32	1	218	insertCrossRecords	argument	\N
2025-03-04 17:53:02.185225+00	74	2	1	36	deleteExtById	argument	{"id": 36, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 36, "pro": false, "title": "End in different letters", "id_expl_id": 73, "pro_expl_id": 73, "statement_id": 31, "title_expl_id": 73, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": 73, "argument_type_id_expl_id": 73, "judgement_requested_expl_id": 73}, "extRecord": {"id": 36, "text": "One ends with \\"s\\", another with \\"m\\".", "id_expl_id": 73, "text_expl_id": 73}, "tableName": "argument", "targetLabel": "End in different letters", "extTableName": "argument_analogy"}
2025-03-10 08:39:08.9175+00	215	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"name": "MartinnnZ"}, "before": {"name": "Martinnn", "name_expl_id": 214}}, "user": {"id": 11, "name": "Martinnn", "auth_role": "invited"}, "tableName": "person", "targetLabel": "MartinnnZ"}
2025-03-04 19:35:40.942718+00	82	15	1	31	submitTaskVoteChangeProposal	statement	{"diff": {"after": {"decided": true, "approved": true, "votes_in_favour": 2}, "before": {"decided": false, "approved": false, "decided_expl_id": 81, "votes_in_favour": 1, "approved_expl_id": 81, "votes_in_favour_expl_id": 81}}, "user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "proposal": {"id": 4, "decided": false, "approved": false, "target_id": 31, "id_expl_id": 81, "table_name": "statement", "column_name": "featured", "new_value_id": 10, "old_value_id": 9, "votes_against": 0, "decided_expl_id": 81, "votes_in_favour": 1, "approved_expl_id": 81, "target_id_expl_id": 81, "table_name_expl_id": 81, "column_name_expl_id": 81, "new_value_id_expl_id": 81, "old_value_id_expl_id": 81, "votes_against_expl_id": 81, "votes_in_favour_expl_id": 81}, "targetLabel": "(?) Brussels is the capital of Belgium", "targetRecord": {"id": 31, "text": "Brussels is the capital of Belgium", "label": "(?) Brussels is the capital of Belgium", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 71, "text_expl_id": 71, "decided_expl_id": 71, "featured_expl_id": 71, "confidence_expl_id": 71, "judgement_requested": false, "judgement_requested_expl_id": 71, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}}
2025-03-06 20:25:27.418249+00	125	2	1	1	updateRecord	argument	{"id": 1, "diff": {"after": {"title": "Both are yellow and round -> 🟡"}, "before": {"title": "Both are yellow and round.", "title_expl_id": 124}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "Both are yellow and round -> 🟡"}
2025-03-06 20:43:07.452034+00	126	2	1	1	updateExtRecord	argument	{"id": 1, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese.."}, "before": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese.", "text_expl_id": 121}}, "tableName": "argument", "targetLabel": "Both are yellow and round -> 🟡", "extTableName": "argument_analogy"}
2025-03-04 18:18:12.707108+00	79	2	1	31	insertCrossRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "cross": {"id": 3, "label": "housing", "tableName": "tag"}, "record": {"tag_id": 3, "statement_id": 31, "tag_id_expl_id": 79, "statement_id_expl_id": 79}, "target": {"id": 31, "label": "(?) Brussels is the capital of Belgium", "tableName": "statement"}}
2025-03-04 18:18:13.659388+00	80	2	1	31	deleteCrossRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "cross": {"id": 3, "label": "housing", "tableName": "tag"}, "record": {"tag_id": 3, "statement_id": 31, "tag_id_expl_id": 79, "statement_id_expl_id": 79}, "target": {"id": 31, "label": "(?) Brussels is the capital of Belgium", "tableName": "statement"}}
2025-03-04 18:25:25.142574+00	81	2	1	31	submitChangeProposal	statement	{"id": "31", "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 31, "text": "Brussels is the capital of Belgium", "label": "(?) Brussels is the capital of Belgium", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 71, "text_expl_id": 71, "decided_expl_id": 71, "featured_expl_id": 71, "confidence_expl_id": 71, "judgement_requested": false, "judgement_requested_expl_id": 71, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}, "colName": "featured", "newValue": true, "oldValue": false, "userExpl": "It's kind of important.", "tableName": "statement", "targetLabel": "(?) Brussels is the capital of Belgium"}
2025-03-06 20:51:33.281125+00	128	2	1	1	updateExtRecord	argument	{"id": 1, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese. :)"}, "before": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese.", "text_expl_id": 127}}, "tableName": "argument", "targetLabel": "Both are yellow and round -> 🟡", "extTableName": "argument_analogy"}
2025-03-06 20:43:34.851164+00	127	2	1	1	updateExtRecord	argument	{"id": 1, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese."}, "before": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese..", "text_expl_id": 126}}, "tableName": "argument", "targetLabel": "Both are yellow and round -> 🟡", "extTableName": "argument_analogy"}
2025-03-06 20:53:28.237575+00	129	2	1	1	updateExtRecord	argument	{"id": 1, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese."}, "before": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese. :)", "text_expl_id": 128}}, "tableName": "argument", "targetLabel": "Both are yellow and round -> 🟡", "extTableName": "argument_analogy"}
2025-03-04 19:35:40.956766+00	83	\N	1	31	executeProposalChange	statement	{"diff": {"after": {"featured": true}, "before": {"featured": false, "featured_expl_id": 71}}, "trigger": {"label": "user voted in favour", "explId": 82}, "proposal": {"id": 4, "decided": false, "approved": false, "target_id": 31, "id_expl_id": 81, "table_name": "statement", "column_name": "featured", "new_value_id": 10, "old_value_id": 9, "votes_against": 0, "decided_expl_id": 81, "votes_in_favour": 1, "approved_expl_id": 81, "target_id_expl_id": 81, "table_name_expl_id": 81, "column_name_expl_id": 81, "new_value_id_expl_id": 81, "old_value_id_expl_id": 81, "votes_against_expl_id": 81, "votes_in_favour_expl_id": 81}, "targetLabel": "(?) Brussels is the capital of Belgium", "targetRecord": {"id": 31, "text": "Brussels is the capital of Belgium", "label": "(?) Brussels is the capital of Belgium", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 71, "text_expl_id": 71, "decided_expl_id": 71, "featured_expl_id": 71, "confidence_expl_id": 71, "judgement_requested": false, "judgement_requested_expl_id": 71, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}}
2025-03-04 19:59:31.616151+00	84	2	1	31	submitChangeProposal	statement	{"id": "31", "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 31, "text": "Brussels is the capital of Belgium", "label": "(?) Brussels is the capital of Belgium", "decided": false, "featured": true, "confidence": 0.5, "id_expl_id": 71, "text_expl_id": 71, "decided_expl_id": 71, "featured_expl_id": 83, "confidence_expl_id": 71, "judgement_requested": false, "judgement_requested_expl_id": 71, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}, "colName": "featured", "newValue": false, "oldValue": true, "userExpl": "let's develop the argument first", "tableName": "statement", "targetLabel": "(?) Brussels is the capital of Belgium"}
2025-03-04 20:04:09.495205+00	85	16	1	31	submitTaskVoteChangeProposal	statement	{"diff": {"after": {"decided": true, "approved": true, "votes_in_favour": 2}, "before": {"decided": false, "approved": false, "decided_expl_id": 84, "votes_in_favour": 1, "approved_expl_id": 84, "votes_in_favour_expl_id": 84}}, "user": {"id": 16, "name": "Goro", "auth_role": "invited"}, "proposal": {"id": 5, "decided": false, "approved": false, "target_id": 31, "id_expl_id": 84, "table_name": "statement", "column_name": "featured", "new_value_id": 12, "old_value_id": 11, "votes_against": 0, "decided_expl_id": 84, "votes_in_favour": 1, "approved_expl_id": 84, "target_id_expl_id": 84, "table_name_expl_id": 84, "column_name_expl_id": 84, "new_value_id_expl_id": 84, "old_value_id_expl_id": 84, "votes_against_expl_id": 84, "votes_in_favour_expl_id": 84}, "targetLabel": "(?) Brussels is the capital of Belgium", "targetRecord": {"id": 31, "text": "Brussels is the capital of Belgium", "label": "(?) Brussels is the capital of Belgium", "decided": false, "featured": true, "confidence": 0.5, "id_expl_id": 71, "text_expl_id": 71, "decided_expl_id": 71, "featured_expl_id": 83, "confidence_expl_id": 71, "judgement_requested": false, "judgement_requested_expl_id": 71, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}}
2025-03-04 20:04:09.513152+00	86	\N	1	31	executeProposalChange	statement	{"diff": {"after": {"featured": false}, "before": {"featured": true, "featured_expl_id": 83}}, "trigger": {"label": "user voted in favour", "explId": 85}, "proposal": {"id": 5, "decided": false, "approved": false, "target_id": 31, "id_expl_id": 84, "table_name": "statement", "column_name": "featured", "new_value_id": 12, "old_value_id": 11, "votes_against": 0, "decided_expl_id": 84, "votes_in_favour": 1, "approved_expl_id": 84, "target_id_expl_id": 84, "table_name_expl_id": 84, "column_name_expl_id": 84, "new_value_id_expl_id": 84, "old_value_id_expl_id": 84, "votes_against_expl_id": 84, "votes_in_favour_expl_id": 84}, "targetLabel": "(?) Brussels is the capital of Belgium", "targetRecord": {"id": 31, "text": "Brussels is the capital of Belgium", "label": "(?) Brussels is the capital of Belgium", "decided": false, "featured": true, "confidence": 0.5, "id_expl_id": 71, "text_expl_id": 71, "decided_expl_id": 71, "featured_expl_id": 83, "confidence_expl_id": 71, "judgement_requested": false, "judgement_requested_expl_id": 71, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}}
2025-03-04 20:06:11.137815+00	87	3	1	31	submitChangeProposal	statement	{"id": "31", "user": {"id": 3, "name": "Bob", "auth_role": "invited"}, "record": {"id": 31, "text": "Brussels is the capital of Belgium", "label": "(?) Brussels is the capital of Belgium", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 71, "text_expl_id": 71, "decided_expl_id": 71, "featured_expl_id": 86, "confidence_expl_id": 71, "judgement_requested": false, "judgement_requested_expl_id": 71, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}, "colName": "featured", "newValue": true, "oldValue": false, "userExpl": "it's on the news a lot", "tableName": "statement", "targetLabel": "(?) Brussels is the capital of Belgium"}
2025-03-05 06:21:05.850245+00	88	2	1	37	insertExtRecord	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 37, "pro": true, "title": "Wikipedia says so", "id_expl_id": 88, "pro_expl_id": 88, "statement_id": 31, "title_expl_id": 88, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 88, "argument_type_id_expl_id": 88, "judgement_requested_expl_id": 88}, "extRecord": {"id": 37, "text": "https://en.wikipedia.org/wiki/List_of_national_capitals", "id_expl_id": 88, "text_expl_id": 88}, "tableName": "argument", "targetLabel": "Wikipedia says so", "extTableName": "argument_other"}
2025-03-05 06:56:38.270053+00	90	2	1	5	insertRecord	tag	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 5, "name": "test1", "id_expl_id": 90, "name_expl_id": 90}, "tableName": "tag", "targetLabel": "test1"}
2025-03-05 07:04:53.507021+00	91	2	1	5	deleteExtById	tag	{"id": 5, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 5, "name": "test1", "id_expl_id": 90, "name_expl_id": 90}, "tableName": "tag", "targetLabel": "test1"}
2025-03-16 11:56:56.597157+00	256	2	1	8	insertRecord	tag	{"user": {"id": 2, "name": "أليس", "auth_role": "invited"}, "record": {"id": 8, "name": "вода", "id_expl_id": 256, "name_expl_id": 256}, "tableName": "tag", "targetLabel": "вода"}
2025-03-10 08:39:35.664609+00	216	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "chinese"}, "before": {"language": "english", "language_expl_id": null}}, "user": {"id": 11, "name": "Martinnn", "auth_role": "invited"}, "tableName": "person", "targetLabel": "MartinnnZ"}
2025-03-05 07:35:24.078113+00	93	2	1	37	askToJudgeArgument	statement	{"diff": {"after": {"judgement_requested": true}, "before": {"judgement_requested": false, "judgement_requested_expl_id": 88}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "argument": {"title": "Wikipedia says so", "statement_id": 31, "title_expl_id": 88, "judgement_requested": false, "statement_id_expl_id": 88, "judgement_requested_expl_id": 88}, "statement": {"argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}, "criticalStatement": {"id": 15, "id_expl_id": 89, "argument_id": 37, "statement_id": 17, "argument_id_expl_id": 89, "critical_question_id": 2, "statement_id_expl_id": 89, "critical_question_id_expl_id": 89}}
2025-03-05 07:56:13.180839+00	94	15	1	37	submitTaskJudgeArgument	argument	{"diff": {"after": {"judgement_requested": false}, "before": {"judgement_requested": true, "judgement_requested_expl_id": 93}}, "user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "insert": {"argument_judgement": {"isolated_confidence": "0.8", "isolated_explanation": "Not always correct doesn't mean not often correct."}}, "argument": {"id": 37, "title": "Wikipedia says so", "id_expl_id": 88, "statement_id": 31, "title_expl_id": 88, "statement_id_expl_id": 88}, "statement": {"id": 31, "text": "Brussels is the capital of Belgium", "id_expl_id": 71, "text_expl_id": 71}}
2025-03-05 08:34:25.328335+00	95	2	1	32	insertRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 32, "text": "Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "label": "(?) Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 95, "text_expl_id": 95, "decided_expl_id": 95, "featured_expl_id": 95, "confidence_expl_id": 95, "judgement_requested": false, "judgement_requested_expl_id": 95, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 95}, "tableName": "statement", "targetLabel": "(?) Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\""}
2025-03-05 08:43:14.321528+00	96	15	1	32	submitTaskConfirmOrChallenge	statement	{"user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "statement": {"id": 32, "text": "Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "label": "(?) Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 95, "text_expl_id": 95, "decided_expl_id": 95, "featured_expl_id": 95, "confidence_expl_id": 95, "judgement_requested": false, "judgement_requested_expl_id": 95, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 95}, "confirmation": {"id": 32, "count": 1, "id_expl_id": 96, "count_expl_id": 96}}
2025-03-05 08:48:10.543497+00	97	16	1	32	submitTaskConfirmOrChallenge	statement	{"user": {"id": 16, "name": "Goro", "auth_role": "invited"}, "statement": {"id": 32, "text": "Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "label": "(?) Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 95, "text_expl_id": 95, "decided_expl_id": 95, "featured_expl_id": 95, "confidence_expl_id": 95, "judgement_requested": false, "judgement_requested_expl_id": 95, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 95}, "confirmation": {"id": 32, "count": 2, "id_expl_id": 96, "count_expl_id": 97}, "statementDiff": {"after": {"decided": true, "confidence": 1}, "before": {"decided": false, "confidence": 0.5, "decided_expl_id": 95, "confidence_expl_id": 95}}, "confirmationDiff": {"after": {"count": 2}, "before": {"count": 1, "count_expl_id": 96}}}
2025-03-05 08:56:35.870247+00	100	15	1	35	submitTaskJudgeArgument	argument	{"diff": {"after": {"judgement_requested": false}, "before": {"judgement_requested": true, "judgement_requested_expl_id": 99}}, "user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "insert": {"argument_judgement": {"isolated_confidence": "0.3", "isolated_explanation": "this seems like a weak argument"}}, "argument": {"id": 35, "title": "Both start with B", "id_expl_id": 72, "statement_id": 31, "title_expl_id": 72, "statement_id_expl_id": 72}, "statement": {"id": 31, "text": "Brussels is the capital of Belgium", "id_expl_id": 71, "text_expl_id": 71}}
2025-03-05 08:55:08.130798+00	98	2	1	16	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 16, "label": "Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "id_expl_id": 98, "argument_id": 35, "statement_id": 32, "argument_id_expl_id": 98, "critical_question_id": 1, "statement_id_expl_id": 98, "critical_question_id_expl_id": 98}, "tableName": "critical_statement", "targetLabel": "Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\""}
2025-03-05 08:55:15.516977+00	99	2	1	35	askToJudgeArgument	statement	{"diff": {"after": {"judgement_requested": true}, "before": {"judgement_requested": false, "judgement_requested_expl_id": 72}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "argument": {"title": "Both start with B", "statement_id": 31, "title_expl_id": 72, "judgement_requested": false, "statement_id_expl_id": 72, "judgement_requested_expl_id": 72}, "statement": {"argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}, "criticalStatement": {"id": 16, "id_expl_id": 98, "argument_id": 35, "statement_id": 32, "argument_id_expl_id": 98, "critical_question_id": 1, "statement_id_expl_id": 98, "critical_question_id_expl_id": 98}}
2025-03-05 08:56:54.42716+00	101	2	1	31	askToJudgeEvidentialStatement	statement	{"diff": {"after": {"judgement_requested": true}, "before": {"judgement_requested": false, "judgement_requested_expl_id": 71}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "statement": {"id": 31, "text": "Brussels is the capital of Belgium", "id_expl_id": 71, "text_expl_id": 71, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 71}}
2025-03-10 08:42:29.375445+00	217	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"name": "Martin", "language": "english"}, "before": {"name": "MartinnnZ", "language": "chinese", "name_expl_id": 215, "language_expl_id": 216}}, "user": {"id": 11, "name": "Martinnn", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-05 12:06:10.401393+00	105	15	1	31	submitTaskJudgeCorrelations	statement	{"user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "statement": {"id": 31, "text": "Brussels is the capital of Belgium", "id_expl_id": 71, "text_expl_id": 71}, "statementArguments": [{"id": 37, "pro": true, "title": "Wikipedia says so", "id_expl_id": 88, "pro_expl_id": 88, "statement_id": 31, "title_expl_id": 88, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 88, "argument_type_id_expl_id": 88, "judgement_requested_expl_id": 94}, {"id": 35, "pro": true, "title": "Both start with B", "id_expl_id": 72, "pro_expl_id": 72, "statement_id": 31, "title_expl_id": 72, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": 72, "argument_type_id_expl_id": 72, "judgement_requested_expl_id": 100}], "argumentConditionals": [{"id": 35, "id_expl_id": 105, "conditional_confidence": 0.3, "conditional_explanation": "The two arguments are completely independent.", "conditional_confidence_expl_id": 105, "conditional_explanation_expl_id": 105}]}
2025-03-05 12:06:10.413361+00	106	\N	1	31	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.965, "judgement_requested": false}, "before": {"decided": false, "confidence": 0.5, "decided_expl_id": 71, "confidence_expl_id": 71, "judgement_requested": true, "judgement_requested_expl_id": 71}}, "statement": {"id": 31, "text": "Brussels is the capital of Belgium", "text_expl_id": 71}, "confidences": [[], [0.8, 0.3]], "triggerLabel": "user submitted correlations", "triggerExplId": 105, "statementArguments": [{"id": 37, "pro": true, "title": "Wikipedia says so", "id_expl_id": 88, "pro_expl_id": 88, "statement_id": 31, "title_expl_id": 88, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 88, "argument_type_id_expl_id": 88, "judgement_requested_expl_id": 94}, {"id": 35, "pro": true, "title": "Both start with B", "id_expl_id": 72, "pro_expl_id": 72, "statement_id": 31, "title_expl_id": 72, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": 72, "argument_type_id_expl_id": 72, "judgement_requested_expl_id": 100}], "argumentConfidences": [{"pro": true, "pro_expl_id": 88, "isolated_confidence": 0.8, "conditional_confidence": null, "isolated_confidence_expl_id": 94, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": 72, "isolated_confidence": 0.3, "conditional_confidence": 0.3, "isolated_confidence_expl_id": 100, "conditional_confidence_expl_id": 105}]}
2025-03-05 12:47:07.990229+00	107	2	1	9	submitChangeProposal	statement	{"id": "9", "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 9, "text": "John Smith will take bribes if offered", "label": "(20%) John Smith will take bribes if offered", "decided": true, "featured": false, "confidence": 0.202, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "judgement_requested": false, "judgement_requested_expl_id": null, "argument_aggregation_type_id": 2, "argument_aggregation_type_id_expl_id": null}, "colName": "decided", "newValue": false, "oldValue": true, "userExpl": "the previous evaluation was a test", "tableName": "statement", "targetLabel": "(20%) John Smith will take bribes if offered"}
2025-03-05 12:47:46.849361+00	108	15	1	9	submitTaskVoteChangeProposal	statement	{"diff": {"after": {"decided": true, "approved": true, "votes_in_favour": 2}, "before": {"decided": false, "approved": false, "decided_expl_id": 107, "votes_in_favour": 1, "approved_expl_id": 107, "votes_in_favour_expl_id": 107}}, "user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "proposal": {"id": 7, "decided": false, "approved": false, "target_id": 9, "id_expl_id": 107, "table_name": "statement", "column_name": "decided", "new_value_id": 16, "old_value_id": 15, "votes_against": 0, "decided_expl_id": 107, "votes_in_favour": 1, "approved_expl_id": 107, "target_id_expl_id": 107, "table_name_expl_id": 107, "column_name_expl_id": 107, "new_value_id_expl_id": 107, "old_value_id_expl_id": 107, "votes_against_expl_id": 107, "votes_in_favour_expl_id": 107}, "targetLabel": "(20%) John Smith will take bribes if offered", "targetRecord": {"id": 9, "text": "John Smith will take bribes if offered", "label": "(20%) John Smith will take bribes if offered", "decided": true, "featured": false, "confidence": 0.202, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "judgement_requested": false, "judgement_requested_expl_id": null, "argument_aggregation_type_id": 2, "argument_aggregation_type_id_expl_id": null}}
2025-03-05 12:47:46.856453+00	109	\N	1	9	executeProposalChange	statement	{"diff": {"after": {"decided": false}, "before": {"decided": true, "decided_expl_id": null}}, "trigger": {"label": "user voted in favour", "explId": 108}, "proposal": {"id": 7, "decided": false, "approved": false, "target_id": 9, "id_expl_id": 107, "table_name": "statement", "column_name": "decided", "new_value_id": 16, "old_value_id": 15, "votes_against": 0, "decided_expl_id": 107, "votes_in_favour": 1, "approved_expl_id": 107, "target_id_expl_id": 107, "table_name_expl_id": 107, "column_name_expl_id": 107, "new_value_id_expl_id": 107, "old_value_id_expl_id": 107, "votes_against_expl_id": 107, "votes_in_favour_expl_id": 107}, "targetLabel": "(20%) John Smith will take bribes if offered", "targetRecord": {"id": 9, "text": "John Smith will take bribes if offered", "label": "(20%) John Smith will take bribes if offered", "decided": true, "featured": false, "confidence": 0.202, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "judgement_requested": false, "judgement_requested_expl_id": null, "argument_aggregation_type_id": 2, "argument_aggregation_type_id_expl_id": null}}
2025-03-05 12:54:51.418912+00	110	15	1	9	askToJudgeAdditiveStatement	statement	{"diff": {"after": {"judgement_requested": true}, "before": {"judgement_requested": false, "judgement_requested_expl_id": null}}, "user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "statement": {"id": 9, "text": "John Smith will take bribes if offered", "id_expl_id": null, "text_expl_id": null, "judgement_requested": false, "judgement_requested_expl_id": null, "argument_aggregation_type_id": 2, "argument_aggregation_type_id_expl_id": null}}
2025-03-16 12:05:16.897274+00	266	2	1	12	insertRecord	tag	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 12, "name": "бизнес", "id_expl_id": 266, "name_expl_id": 266}, "tableName": "tag", "targetLabel": "бизнес"}
2025-03-06 10:24:07.370725+00	117	2	1	38	insertExtRecord	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 38, "pro": false, "title": "historians use many techniques to ensure that their techniques are reliable ", "id_expl_id": 117, "pro_expl_id": 117, "statement_id": 5, "title_expl_id": 117, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 117, "argument_type_id_expl_id": 117, "judgement_requested_expl_id": 117}, "extRecord": {"id": 38, "text": "historians use many techniques to ensure that their techniques are reliable ", "id_expl_id": 117, "text_expl_id": 117}, "tableName": "argument", "targetLabel": "historians use many techniques to ensure that their techniques are reliable ", "extTableName": "argument_other"}
2025-03-05 13:23:54.117496+00	114	2	1	15	submitTaskWeighArgument	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "argument": {"id": 15, "title": "John Smith would like to provide for his family as much as possible.", "id_expl_id": null, "statement_id": 9, "title_expl_id": null, "statement_id_expl_id": null}, "statement": {"id": 9, "text": "John Smith will take bribes if offered", "id_expl_id": null, "text_expl_id": null}, "weightData": {"weight_mode": "45", "weight_explanation": "family is often very important", "weight_lower_limit": "0", "weight_upper_limit": "60"}, "argumentWeight": {"id": 15, "id_expl_id": 114, "weight_mode": 45, "weight_explanation": "family is often very important", "weight_lower_limit": 0, "weight_upper_limit": 60, "weight_mode_expl_id": 114, "weight_explanation_expl_id": 114, "weight_lower_limit_expl_id": 114, "weight_upper_limit_expl_id": 114}}
2025-03-05 13:24:54.265995+00	115	2	1	13	submitTaskWeighArgument	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "argument": {"id": 13, "title": "John Smith like many people would like to have luxuries.", "id_expl_id": null, "statement_id": 9, "title_expl_id": null, "statement_id_expl_id": null}, "statement": {"id": 9, "text": "John Smith will take bribes if offered", "id_expl_id": null, "text_expl_id": null}, "weightData": {"weight_mode": "15", "weight_explanation": "Luxuries are often not a must.", "weight_lower_limit": "0", "weight_upper_limit": "50"}, "argumentWeight": {"id": 13, "id_expl_id": 115, "weight_mode": 15, "weight_explanation": "Luxuries are often not a must.", "weight_lower_limit": 0, "weight_upper_limit": 50, "weight_mode_expl_id": 115, "weight_explanation_expl_id": 115, "weight_lower_limit_expl_id": 115, "weight_upper_limit_expl_id": 115}}
2025-03-05 13:24:54.296351+00	116	\N	1	9	attemptAggregateArguments	statement	{"diff": {"after": {"decided": true, "confidence": 0.208, "judgement_requested": false}, "before": {"decided": false, "confidence": 0.191, "decided_expl_id": null, "confidence_expl_id": null, "judgement_requested": true, "judgement_requested_expl_id": null}}, "statement": {"id": 9, "text": "John Smith will take bribes if offered", "id_expl_id": null, "text_expl_id": null}, "weightedArguments": [{"id": 14, "pro": true, "title": "John Smith would like to have a nice early retirement.", "id_expl_id": null, "weight_mode": 20, "weight_explanation": "", "weight_lower_limit": 2, "weight_upper_limit": 40, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 17, "pro": false, "title": "John Smith doesn't want to loose reputation of his family.", "id_expl_id": null, "weight_mode": 20, "weight_explanation": "", "weight_lower_limit": 5, "weight_upper_limit": 35, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 19, "pro": false, "title": "John Smith doesn't want to ruin his career.", "id_expl_id": null, "weight_mode": 20, "weight_explanation": "", "weight_lower_limit": 15, "weight_upper_limit": 40, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 16, "pro": false, "title": "John Smith doesn't want to go to jail.", "id_expl_id": null, "weight_mode": 60, "weight_explanation": "", "weight_lower_limit": 35, "weight_upper_limit": 90, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 15, "pro": true, "title": "John Smith would like to provide for his family as much as possible.", "id_expl_id": 114, "weight_mode": 45, "weight_explanation": "family is often very important", "weight_lower_limit": 0, "weight_upper_limit": 60, "weight_mode_expl_id": 114, "weight_explanation_expl_id": 114, "weight_lower_limit_expl_id": 114, "weight_upper_limit_expl_id": 114}, {"id": 13, "pro": true, "title": "John Smith like many people would like to have luxuries.", "id_expl_id": 115, "weight_mode": 15, "weight_explanation": "Luxuries are often not a must.", "weight_lower_limit": 0, "weight_upper_limit": 50, "weight_mode_expl_id": 115, "weight_explanation_expl_id": 115, "weight_lower_limit_expl_id": 115, "weight_upper_limit_expl_id": 115}]}
2025-03-06 20:22:45.278566+00	123	2	1	1	updateRecord	argument	{"id": 1, "diff": {"after": {"title": "Both are yellow and round.."}, "before": {"title": "Both are yellow and round.", "title_expl_id": 122}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "Both are yellow and round.."}
2025-03-06 10:24:55.999746+00	118	2	1	33	insertRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 33, "text": "carbon dating is a flawed technique", "label": "(?) carbon dating is a flawed technique", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 118, "text_expl_id": 118, "decided_expl_id": 118, "featured_expl_id": 118, "confidence_expl_id": 118, "judgement_requested": false, "judgement_requested_expl_id": 118, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 118}, "tableName": "statement", "targetLabel": "(?) carbon dating is a flawed technique"}
2025-03-06 10:25:06.795867+00	119	2	1	17	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 17, "label": "carbon dating is a flawed technique", "id_expl_id": 119, "argument_id": 38, "statement_id": 33, "argument_id_expl_id": 119, "critical_question_id": 2, "statement_id_expl_id": 119, "critical_question_id_expl_id": 119}, "tableName": "critical_statement", "targetLabel": "carbon dating is a flawed technique"}
2025-03-06 20:00:43.498188+00	120	3	1	1	updateRecord	argument	{"id": 1, "diff": {"after": {"title": "Both are yellow and round."}, "before": {"title": "Both are yellow and round..", "title_expl_id": 50}}, "user": {"id": 3, "name": "Bob", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "Both are yellow and round."}
2025-03-06 20:03:27.965073+00	121	2	1	1	updateExtRecord	argument	{"id": 1, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {"title": "Both are yellow and round!"}, "before": {"title": "Both are yellow and round.", "title_expl_id": 120}}, "extRecord": {"after": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese."}, "before": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese..", "text_expl_id": 50}}, "tableName": "argument", "targetLabel": "Both are yellow and round!", "extTableName": "argument_analogy"}
2025-03-06 20:07:54.74206+00	122	3	1	1	updateRecord	argument	{"id": 1, "diff": {"after": {"title": "Both are yellow and round."}, "before": {"title": "Both are yellow and round!", "title_expl_id": 121}}, "user": {"id": 3, "name": "Bob", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "Both are yellow and round."}
2025-03-06 20:24:38.356058+00	124	3	1	1	updateRecord	argument	{"id": 1, "diff": {"after": {"title": "Both are yellow and round."}, "before": {"title": "Both are yellow and round..", "title_expl_id": 123}}, "user": {"id": 3, "name": "Bob", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "Both are yellow and round."}
2025-03-06 20:57:01.913667+00	130	2	1	1	updateExtRecord	argument	{"id": 1, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese. :)"}, "before": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese.", "text_expl_id": 129}}, "tableName": "argument", "targetLabel": "Both are yellow and round -> 🟡", "extTableName": "argument_analogy"}
2025-03-08 05:17:05.834958+00	140	11	1	20	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 20, "label": "The temperature has never risen so rapidly before until humans started burning fossil fuels.", "id_expl_id": 140, "argument_id": 34, "statement_id": 37, "argument_id_expl_id": 140, "critical_question_id": 7, "statement_id_expl_id": 140, "critical_question_id_expl_id": 140}, "tableName": "critical_statement", "targetLabel": "The temperature has never risen so rapidly before until humans started burning fossil fuels."}
2025-03-06 22:28:37.45083+00	131	15	1	34	insertRecord	statement	{"user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "record": {"id": 34, "text": "Banana must be peeled from the tip", "label": "(?) Banana must be peeled from the tip", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 131, "text_expl_id": 131, "decided_expl_id": 131, "featured_expl_id": 131, "confidence_expl_id": 131, "judgement_requested": false, "judgement_requested_expl_id": 131, "argument_aggregation_type_id": 2, "argument_aggregation_type_id_expl_id": 131}, "tableName": "statement", "targetLabel": "(?) Banana must be peeled from the tip"}
2025-03-06 22:29:16.867932+00	132	15	1	34	insertCrossRecord	statement	{"user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "cross": {"id": 1, "label": "silly", "tableName": "tag"}, "record": {"tag_id": 1, "statement_id": 34, "tag_id_expl_id": 132, "statement_id_expl_id": 132}, "target": {"id": 34, "label": "(?) Banana must be peeled from the tip", "tableName": "statement"}}
2025-03-10 13:17:32.184052+00	218	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "chinese"}, "before": {"language": "english", "language_expl_id": 217}}, "user": {"id": 11, "name": "Martinnn", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-06 22:32:52.684562+00	133	16	1	39	insertExtRecord	argument	{"user": {"id": 16, "name": "Goro", "auth_role": "invited"}, "record": {"id": 39, "pro": false, "title": "It's easier to pull banana's leg then dig the tip with your nail. ", "id_expl_id": 133, "pro_expl_id": 133, "statement_id": 34, "title_expl_id": 133, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 133, "argument_type_id_expl_id": 133, "judgement_requested_expl_id": 133}, "extRecord": {"id": 39, "text": "monkey says so", "id_expl_id": 133, "text_expl_id": 133}, "tableName": "argument", "targetLabel": "It's easier to pull banana's leg then dig the tip with your nail. ", "extTableName": "argument_other"}
2025-03-06 22:36:24.458455+00	134	15	1	35	insertRecord	statement	{"user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "record": {"id": 35, "text": "We are humans, not monkeys", "label": "(?) We are humans, not monkeys", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 134, "text_expl_id": 134, "decided_expl_id": 134, "featured_expl_id": 134, "confidence_expl_id": 134, "judgement_requested": false, "judgement_requested_expl_id": 134, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 134}, "tableName": "statement", "targetLabel": "(?) We are humans, not monkeys"}
2025-03-06 22:36:39.745906+00	135	15	1	18	insertRecord	critical_statement	{"user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "record": {"id": 18, "label": "We are humans, not monkeys", "id_expl_id": 135, "argument_id": 39, "statement_id": 35, "argument_id_expl_id": 135, "critical_question_id": 2, "statement_id_expl_id": 135, "critical_question_id_expl_id": 135}, "tableName": "critical_statement", "targetLabel": "We are humans, not monkeys"}
2025-03-07 16:21:57.581579+00	136	2	1	36	insertRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 36, "text": "Bananas don't have legs", "label": "(?) Bananas don't have legs", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 136, "text_expl_id": 136, "decided_expl_id": 136, "featured_expl_id": 136, "confidence_expl_id": 136, "judgement_requested": false, "judgement_requested_expl_id": 136, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 136}, "tableName": "statement", "targetLabel": "(?) Bananas don't have legs"}
2025-03-07 16:22:05.998062+00	137	2	1	19	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 19, "label": "Bananas don't have legs", "id_expl_id": 137, "argument_id": 39, "statement_id": 36, "argument_id_expl_id": 137, "critical_question_id": 2, "statement_id_expl_id": 137, "critical_question_id_expl_id": 137}, "tableName": "critical_statement", "targetLabel": "Bananas don't have legs"}
2025-03-08 04:44:26.947269+00	138	11	1	7	insertRecord	critical_question	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 7, "text": "Are there relevant differences?", "id_expl_id": 138, "text_expl_id": 138, "argument_type_id": 2, "argument_type_id_expl_id": 138}, "tableName": "critical_question", "targetLabel": "Are there relevant differences?"}
2025-03-08 05:16:04.296661+00	139	11	1	37	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 37, "text": "The temperature has never risen so rapidly before until humans started burning fossil fuels.", "label": "(?) The temperature has never risen so rapidly before until humans started burning fossil fuels.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 139, "text_expl_id": 139, "decided_expl_id": 139, "featured_expl_id": 139, "confidence_expl_id": 139, "judgement_requested": false, "judgement_requested_expl_id": 139, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 139}, "tableName": "statement", "targetLabel": "(?) The temperature has never risen so rapidly before until humans started burning fossil fuels."}
2025-03-08 07:17:02.528469+00	142	13	1	38	insertRecord	statement	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 38, "text": "The climate is too complicated to determine if burning fossil fuels has caused the full extent of global warming using out current models.", "label": "(?) The climate is too complicated to determine if burning fossil fuels has caused the full extent of global warming using out current models.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 142, "text_expl_id": 142, "decided_expl_id": 142, "featured_expl_id": 142, "confidence_expl_id": 142, "judgement_requested": false, "judgement_requested_expl_id": 142, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 142}, "tableName": "statement", "targetLabel": "(?) The climate is too complicated to determine if burning fossil fuels has caused the full extent of global warming using out current models."}
2025-03-08 07:41:33.000978+00	146	11	1	40	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 40, "pro": false, "title": "Past temperature changes are unknowable with certainty.", "id_expl_id": 146, "pro_expl_id": 146, "statement_id": 37, "title_expl_id": 146, "argument_type_id": 5, "judgement_requested": false, "statement_id_expl_id": 146, "argument_type_id_expl_id": 146, "judgement_requested_expl_id": 146}, "extRecord": {}, "tableName": "argument", "targetLabel": "Past temperature changes are unknowable with certainty.", "extTableName": "argument_epistemic"}
2025-03-08 07:17:05.820954+00	143	13	1	21	insertRecord	critical_statement	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 21, "label": "The climate is too complicated to determine if burning fossil fuels has caused the full extent of global warming using out current models.", "id_expl_id": 143, "argument_id": 33, "statement_id": 38, "argument_id_expl_id": 143, "critical_question_id": 8, "statement_id_expl_id": 143, "critical_question_id_expl_id": 143}, "tableName": "critical_statement", "targetLabel": "The climate is too complicated to determine if burning fossil fuels has caused the full extent of global warming using out current models."}
2025-03-08 11:17:19.691427+00	166	13	1	25	insertRecord	critical_statement	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 25, "label": "There are leaked emails with one climate scientist telling the other how he is hiding decline in temperatures by using a “trick”.", "id_expl_id": 166, "argument_id": 47, "statement_id": 41, "argument_id_expl_id": 166, "critical_question_id": 1, "statement_id_expl_id": 166, "critical_question_id_expl_id": 166}, "tableName": "critical_statement", "targetLabel": "There are leaked emails with one climate scientist telling the other how he is hiding decline in temperatures by using a “trick”."}
2025-03-08 07:23:08.69288+00	144	11	1	1	insertRecord	research_note	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 1, "text": "Found quotes about \\"warmest year on record\\". But the record goes only ~150 years back. Obviously the history of the Earth goes back much further than that.\\n\\nOther quotes talk about \\"likely rate of change over the next century\\", so not the observed change so far.", "title": "Could not find good evidence for this.", "id_expl_id": 144, "statement_id": 37, "text_expl_id": 144, "title_expl_id": 144, "statement_id_expl_id": 144}, "tableName": "research_note", "targetLabel": "Could not find good evidence for this."}
2025-03-08 07:38:37.115418+00	145	5	1	5	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 5, "name": "epistemic", "id_expl_id": 145, "description": "The argument against the statement is an epistemic argument, if it challenges the knowability or certainty of the claim rather than directly refuting its factual content. This type of argument is often used to introduce skepticism about the evidence or methods used to support a claim.", "name_expl_id": 145, "description_expl_id": 145}, "tableName": "argument_type", "targetLabel": "epistemic"}
2025-03-08 11:31:34.795661+00	174	11	1	44	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 44, "text": "Met Office UK is not the only respectable weather organisation in the world", "label": "(?) Met Office UK is not the only respectable weather organisation in the world", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 174, "text_expl_id": 174, "decided_expl_id": 174, "featured_expl_id": 174, "confidence_expl_id": 174, "judgement_requested": false, "judgement_requested_expl_id": 174, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 174}, "tableName": "statement", "targetLabel": "(?) Met Office UK is not the only respectable weather organisation in the world"}
2025-03-10 13:18:20.46723+00	219	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "ukrainian"}, "before": {"language": "chinese", "language_expl_id": 218}}, "user": {"id": 11, "name": "Martinnn", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-08 07:42:48.639159+00	147	11	1	39	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 39, "text": "The Earth’s atmosphere did not warm to such a high temperature as now due to natural causes over the past 100,000 years.", "label": "(?) The Earth’s atmosphere did not warm to such a high temperature as now due to natural causes over the past 100,000 years.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 147, "text_expl_id": 147, "decided_expl_id": 147, "featured_expl_id": 147, "confidence_expl_id": 147, "judgement_requested": false, "judgement_requested_expl_id": 147, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 147}, "tableName": "statement", "targetLabel": "(?) The Earth’s atmosphere did not warm to such a high temperature as now due to natural causes over the past 100,000 years."}
2025-03-08 07:43:03.884551+00	148	11	1	22	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 22, "label": "The Earth’s atmosphere did not warm to such a high temperature as now due to natural causes over the past 100,000 years.", "id_expl_id": 148, "argument_id": 34, "statement_id": 39, "argument_id_expl_id": 148, "critical_question_id": 7, "statement_id_expl_id": 148, "critical_question_id_expl_id": 148}, "tableName": "critical_statement", "targetLabel": "The Earth’s atmosphere did not warm to such a high temperature as now due to natural causes over the past 100,000 years."}
2025-03-08 07:52:51.001189+00	149	11	1	41	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 41, "pro": true, "title": "According to a professor of earth and environmental sciences this is probably true.", "id_expl_id": 149, "pro_expl_id": 149, "statement_id": 39, "title_expl_id": 149, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 149, "argument_type_id_expl_id": 149, "judgement_requested_expl_id": 149}, "extRecord": {"id": 41, "quote": "“While this claim may well be correct, there are no detailed temperature records extending back 100,000 years, so we don’t know for sure.”\\n\\n“Looking at that 12,000-year interglacial period, global temperature averaged over multiple centuries might have peaked roughly around 6,000 years ago, but probably did not exceed the 1 C global warming level at that point, according to the IPCC report.”\\n\\n“If we look even farther back, to the previous interglacial period, which peaked around 125,000 years ago, we do find evidence of warmer temperatures.", "authority": "Darrell Kaufman is a professor of earth and environmental sciences at Northern Arizona University.", "id_expl_id": 149, "source_url": "https://www.pbs.org/newshour/science/analysis-is-it-actually-hotter-now-than-any-time-in-the-last-100000-years", "source_title": "Analysis: Is it actually hotter now than any time in the last 100,000 years?", "quote_expl_id": 149, "authority_expl_id": 149, "source_url_expl_id": 149, "source_title_expl_id": 149}, "tableName": "argument", "targetLabel": "According to a professor of earth and environmental sciences this is probably true.", "extTableName": "argument_authority"}
2025-03-08 11:31:39.227723+00	175	11	1	28	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 28, "label": "Met Office UK is not the only respectable weather organisation in the world", "id_expl_id": 175, "argument_id": 49, "statement_id": 44, "argument_id_expl_id": 175, "critical_question_id": 4, "statement_id_expl_id": 175, "critical_question_id_expl_id": 175}, "tableName": "critical_statement", "targetLabel": "Met Office UK is not the only respectable weather organisation in the world"}
2025-03-08 09:24:59.771054+00	150	11	1	23	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 23, "label": "Berlin is the capital of Germany", "id_expl_id": 150, "argument_id": 41, "statement_id": 18, "argument_id_expl_id": 150, "critical_question_id": 3, "statement_id_expl_id": 150, "critical_question_id_expl_id": 150}, "tableName": "critical_statement", "targetLabel": "Berlin is the capital of Germany"}
2025-03-08 09:25:12.019301+00	151	11	1	23	deleteExtById	critical_statement	{"id": 23, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 23, "label": "Berlin is the capital of Germany", "id_expl_id": 150, "argument_id": 41, "statement_id": 18, "argument_id_expl_id": 150, "critical_question_id": 3, "statement_id_expl_id": 150, "critical_question_id_expl_id": 150}, "tableName": "critical_statement", "targetLabel": "Berlin is the capital of Germany"}
2025-03-08 09:46:43.397131+00	152	11	1	40	updateExtRecord	argument	{"id": 40, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"text": "t is not possible to determine how rapidly the global average temperature has changed in each century over the past million years with the current scientific methods."}}, "tableName": "argument", "targetLabel": "Past temperature changes are unknowable with certainty.", "extTableName": "argument_epistemic"}
2025-03-08 10:27:21.670169+00	157	11	1	24	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 24, "label": "Climate models developed before 2007 were correctly predicting global warming.", "id_expl_id": 157, "argument_id": 42, "statement_id": 40, "argument_id_expl_id": 157, "critical_question_id": 1, "statement_id_expl_id": 157, "critical_question_id_expl_id": 157}, "tableName": "critical_statement", "targetLabel": "Climate models developed before 2007 were correctly predicting global warming."}
2025-03-08 10:05:26.268245+00	153	11	1	42	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 42, "pro": false, "title": "current models are sufficient", "id_expl_id": 153, "pro_expl_id": 153, "statement_id": 38, "title_expl_id": 153, "argument_type_id": 5, "judgement_requested": false, "statement_id_expl_id": 153, "argument_type_id_expl_id": 153, "judgement_requested_expl_id": 153}, "extRecord": {"id": 42, "text": "Climate models developed before 2007 were already correctly predicting global warming.\\nThe models became more accurate since 2007.\\nTherefore our current models are sufficient to determine if burning fossil fuels has caused the full extent of global warming.", "id_expl_id": 153, "text_expl_id": 153}, "tableName": "argument", "targetLabel": "current models are sufficient", "extTableName": "argument_epistemic"}
2025-03-08 10:18:51.230708+00	154	11	1	1	updateRecord	critical_question	{"id": 1, "diff": {"after": {"argument_type_id": null}, "before": {"argument_type_id": 2, "argument_type_id_expl_id": null}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "critical_question", "targetLabel": "Are the statements used in the argument true?"}
2025-03-08 10:19:40.751885+00	155	11	1	1	updateRecord	critical_question	{"id": 1, "diff": {"after": {"argument_type_id": null}, "before": {"argument_type_id": 2, "argument_type_id_expl_id": null}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "critical_question", "targetLabel": "Are the statements used in the argument true?"}
2025-03-16 12:03:31.788428+00	262	2	1	8	deleteExtById	tag	{"id": 8, "user": {"id": 2, "name": "أليس", "auth_role": "invited"}, "record": {"id": 8, "name": "вода", "id_expl_id": 256, "name_expl_id": 256}, "tableName": "tag", "targetLabel": "вода"}
2025-03-08 10:27:07.785883+00	156	11	1	40	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 40, "text": "Climate models developed before 2007 were correctly predicting global warming.", "label": "(?) Climate models developed before 2007 were correctly predicting global warming.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 156, "text_expl_id": 156, "decided_expl_id": 156, "featured_expl_id": 156, "confidence_expl_id": 156, "judgement_requested": false, "judgement_requested_expl_id": 156, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 156}, "tableName": "statement", "targetLabel": "(?) Climate models developed before 2007 were correctly predicting global warming."}
2025-03-08 10:29:18.639793+00	158	11	1	43	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 43, "pro": true, "title": "This was confirmed in a published study by comparing their predictions with the actual data recorder since 2007.", "id_expl_id": 158, "pro_expl_id": 158, "statement_id": 40, "title_expl_id": 158, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 158, "argument_type_id_expl_id": 158, "judgement_requested_expl_id": 158}, "extRecord": {"id": 43, "quote": "The results: 10 of the [17] model projections closely matched observations. Moreover, after accounting for differences between modeled and actual changes in atmospheric carbon dioxide and other factors that drive climate, the number increased to 14. The authors found no evidence that the climate models evaluated either systematically overestimated or underestimated warming over the period of their projections.", "authority": "published study", "id_expl_id": 158, "source_url": "https://science.nasa.gov/earth/climate-change/study-confirms-climate-models-are-getting-future-warming-projections-right/", "source_title": "Study Confirms Climate Models are Getting Future Warming Projections Right", "quote_expl_id": 158, "authority_expl_id": 158, "source_url_expl_id": 158, "source_title_expl_id": 158}, "tableName": "argument", "targetLabel": "This was confirmed in a published study by comparing their predictions with the actual data recorder since 2007.", "extTableName": "argument_authority"}
2025-03-08 10:41:32.450988+00	159	5	1	6	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 6, "name": "deduction", "id_expl_id": 159, "description": "logical derivation from known facts", "name_expl_id": 159, "description_expl_id": 159}, "tableName": "argument_type", "targetLabel": "deduction"}
2025-03-10 13:33:59.91837+00	220	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "russian"}, "before": {"language": "ukrainian", "language_expl_id": 219}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-08 10:44:00.867928+00	160	5	1	7	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 7, "name": "comparison", "id_expl_id": 160, "description": "draw a comparison between something known and something that is claimed", "name_expl_id": 160, "description_expl_id": 160}, "tableName": "argument_type", "targetLabel": "comparison"}
2025-03-08 11:17:18.649206+00	165	13	1	41	insertRecord	statement	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 41, "text": "There are leaked emails with one climate scientist telling the other how he is hiding decline in temperatures by using a “trick”.", "label": "(?) There are leaked emails with one climate scientist telling the other how he is hiding decline in temperatures by using a “trick”.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 165, "text_expl_id": 165, "decided_expl_id": 165, "featured_expl_id": 165, "confidence_expl_id": 165, "judgement_requested": false, "judgement_requested_expl_id": 165, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 165}, "tableName": "statement", "targetLabel": "(?) There are leaked emails with one climate scientist telling the other how he is hiding decline in temperatures by using a “trick”."}
2025-03-08 10:45:06.470325+00	161	13	1	44	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 44, "pro": true, "title": "can't even predict weather", "id_expl_id": 161, "pro_expl_id": 161, "statement_id": 38, "title_expl_id": 161, "argument_type_id": 7, "judgement_requested": false, "statement_id_expl_id": 161, "argument_type_id_expl_id": 161, "judgement_requested_expl_id": 161}, "extRecord": {"id": 44, "text": "Science can’t predict the weather with any accuracy just a couple of weeks into the future. Making predictions years into the future is a much more complicated task.", "id_expl_id": 161, "text_expl_id": 161}, "tableName": "argument", "targetLabel": "can't even predict weather", "extTableName": "argument_comparison"}
2025-03-08 10:46:14.73541+00	162	13	1	45	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 45, "pro": true, "title": "lack of understanding of clouds and effects of vapour", "id_expl_id": 162, "pro_expl_id": 162, "statement_id": 38, "title_expl_id": 162, "argument_type_id": 6, "judgement_requested": false, "statement_id_expl_id": 162, "argument_type_id_expl_id": 162, "judgement_requested_expl_id": 162}, "extRecord": {"id": 45, "text": "Our understanding of key climate feedback mechanisms, such as cloud formation and water vapour is incomplete. These factors have a very large impact on the energy balance in the atmosphere. The models built without this understanding can not be anywhere close to accurate.", "id_expl_id": 162, "text_expl_id": 162}, "tableName": "argument", "targetLabel": "lack of understanding of clouds and effects of vapour", "extTableName": "argument_deduction"}
2025-03-08 11:15:37.40308+00	163	13	1	46	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 46, "pro": false, "title": "study selection bias", "id_expl_id": 163, "pro_expl_id": 163, "statement_id": 40, "title_expl_id": 163, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 163, "argument_type_id_expl_id": 163, "judgement_requested_expl_id": 163}, "extRecord": {"id": 46, "text": "There are many different climate models. Some of them do not confirm that humans are causing climate change. However, we are shown only the ones that do because there is a strong bias towards that conclusion among climate scientists.", "id_expl_id": 163, "text_expl_id": 163}, "tableName": "argument", "targetLabel": "study selection bias", "extTableName": "argument_explanation"}
2025-03-08 11:16:44.73208+00	164	13	1	47	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 47, "pro": false, "title": "the models are doctored", "id_expl_id": 164, "pro_expl_id": 164, "statement_id": 40, "title_expl_id": 164, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 164, "argument_type_id_expl_id": 164, "judgement_requested_expl_id": 164}, "extRecord": {"id": 47, "text": "Prominent climate scientists forge their results to fit a predefined conclusion.", "id_expl_id": 164, "text_expl_id": 164}, "tableName": "argument", "targetLabel": "the models are doctored", "extTableName": "argument_explanation"}
2025-06-29 22:24:18.445035+00	1181	18	1	132	insertExtRecord	issue	{"user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "record": {"id": 132, "title": "Add (subsurface) automated E2E tests", "id_expl_id": 1181, "description": "Automated testing idea. The main weakness of end to end tests is that they break easily. This can be mitigated if the task plan is linked directly to the code rather than it been linked to DOM locator. If your editing code and you see that this particular component is referenced by a test plan in this particular way you will have awareness and context to adjust both the task plan and the hook inside the code such that predictably it will probably work. This hook will be placed inside a UI component and it will be essentially a subscriber that will subscribe to a data plus operation locator rather than a DOM locator. This is much less arbitrary and susceptible to unexpected and unimportant changes. The test runner would fire events it would run from well the page itself since we have an SPA. It will wait until there is at least one appropriate subscriber and then activate the first subscriber. Subscribers can return data in response to events. This data could serve multiple purposes. It could be essential for running the test so like passing an ID. It could also be used for assertions. Some subscribers could function just as assertions not changing the application state in any way. If you're adding an intermediate step to user flow you must check that the subscribers that will become hidden by introduction of this intermediate step it should have this intermediate step edit to every test that calls those subscribers if they are now coming through this step as opposed to why some other route. Creating documentation from test runs still remains a possibility. This documentation could be even run in the form of a tutorial by running the test but waiting for the user to click the next button and also by perhaps showing a panel with comments about what's going on that could also contain those next buttons. The advantage here is that the user can interact with the application open links if he's curious, open hidden descriptions if you want to, making certain changes if you likes to like adding additional items that were not in the tutorial. In the tutorial mode assertions shouldn't cause a failure because well it's no use to the user and because it could be that the user have made additional actions or made changes that conflict with the asserted values. Another benefit is that this will be done in the screen resolution and zoom level that is comfortable and adjustable by the user. In conclusion testing DOM is too much pain for too little benefit. 🤩 Amazing benefit! If we are treating test plans as specification of the fact that code is linked directly to the test plan via the subscriber gives great amazing context to the requirements that this code is following. This is especially relevant to Apollo because most of Apollo UI components are highly abstract and I'm already encountering situations where I'm looking at a UI component and I have trouble figuring out where in what scenario it's used. If I had implemented subscribers to the task plan it would link me a specific scenario that I can see and understand how this piece of UI is used, and I can even run the test and it will show me on the screen how it's used. Isn't this absolutely amazing!?!", "title_expl_id": 1181, "description_expl_id": 1181}, "extRecord": {"id": 132, "status": "backlog", "id_expl_id": 1181, "project_stage": "launch", "status_expl_id": 1181, "functional_area": "testing", "project_stage_expl_id": 1181, "functional_area_expl_id": 1181}, "tableName": "issue", "targetLabel": "Add (subsurface) automated E2E tests", "extTableName": "task"}
2025-03-08 11:21:18.741949+00	167	13	1	48	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 48, "pro": true, "title": "Published leaked materials confirm this", "id_expl_id": 167, "pro_expl_id": 167, "statement_id": 41, "title_expl_id": 167, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 167, "argument_type_id_expl_id": 167, "judgement_requested_expl_id": 167}, "extRecord": {"id": 48, "quote": "In one email, dated November 1999, one scientist wrote: \\"I've just completed Mike's Nature [the science journal] trick of adding in the real temps to each series for the last 20 years (ie, from 1981 onwards) and from 1961 for Keith's to hide the decline.”", "authority": "The leak was widely published and the the persons in it did not deny it.", "id_expl_id": 167, "source_url": "https://www.theguardian.com/environment/2009/nov/20/climate-sceptics-hackers-leaked-emails", "source_title": "Climate sceptics claim leaked emails are evidence of collusion among scientists", "quote_expl_id": 167, "authority_expl_id": 167, "source_url_expl_id": 167, "source_title_expl_id": 167}, "tableName": "argument", "targetLabel": "Published leaked materials confirm this", "extTableName": "argument_authority"}
2025-03-08 11:25:39.269909+00	168	5	1	9	insertRecord	critical_question	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 9, "text": "Are there relevant differences?", "id_expl_id": 168, "text_expl_id": 168, "argument_type_id": 7, "argument_type_id_expl_id": 168}, "tableName": "critical_question", "targetLabel": "Are there relevant differences?"}
2025-03-08 11:29:46.174365+00	173	11	1	49	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 49, "pro": true, "title": "Met Office UK says so", "id_expl_id": 173, "pro_expl_id": 173, "statement_id": 43, "title_expl_id": 173, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 173, "argument_type_id_expl_id": 173, "judgement_requested_expl_id": 173}, "extRecord": {"id": 49, "quote": "Weather forecasts and climate projections are very different things. They have different goals and work in such different ways that one should not be used to comment on or disparage the other.", "authority": "Met Office UK is the main weather authority in the UK", "id_expl_id": 173, "source_url": "https://www.metoffice.gov.uk/research/approach/collaboration/ukcp/forecasts-projections", "source_title": "The role of different timescales", "quote_expl_id": 173, "authority_expl_id": 173, "source_url_expl_id": 173, "source_title_expl_id": 173}, "tableName": "argument", "targetLabel": "Met Office UK says so", "extTableName": "argument_authority"}
2025-03-08 11:26:43.001811+00	169	11	1	42	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 42, "text": "Weather and climate predictions look at averages over a different ranges of space and time. City or country vs the whole earth. Days or weeks vs years and decades. There is a lot more variation on the smaller scale compared to large scale averages.", "label": "(?) Weather and climate predictions look at averages over a different ranges of space and time. City or country vs the whole earth. Days or weeks vs years and decades. There is a lot more variation on the smaller scale compared to large scale averages.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 169, "text_expl_id": 169, "decided_expl_id": 169, "featured_expl_id": 169, "confidence_expl_id": 169, "judgement_requested": false, "judgement_requested_expl_id": 169, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 169}, "tableName": "statement", "targetLabel": "(?) Weather and climate predictions look at averages over a different ranges of space and time. City or country vs the whole earth. Days or weeks vs years and decades. There is a lot more variation on the smaller scale compared to large scale averages."}
2025-03-16 12:06:08.116356+00	268	2	1	11	deleteExtById	tag	{"id": 11, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 11, "name": "бюрократия", "id_expl_id": 259, "name_expl_id": 259}, "tableName": "tag", "targetLabel": "бюрократия"}
2025-03-08 11:26:45.525295+00	170	11	1	26	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 26, "label": "Weather and climate predictions look at averages over a different ranges of space and time. City or country vs the whole earth. Days or weeks vs years and decades. There is a lot more variation on the smaller scale compared to large scale averages.", "id_expl_id": 170, "argument_id": 44, "statement_id": 42, "argument_id_expl_id": 170, "critical_question_id": 9, "statement_id_expl_id": 170, "critical_question_id_expl_id": 170}, "tableName": "critical_statement", "targetLabel": "Weather and climate predictions look at averages over a different ranges of space and time. City or country vs the whole earth. Days or weeks vs years and decades. There is a lot more variation on the smaller scale compared to large scale averages."}
2025-03-08 11:27:54.298081+00	171	11	1	43	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 43, "text": "Weather forecasts and climate projections are very different things. They have different goals and work in such different ways that one should not be used to comment on or disparage the other.", "label": "(?) Weather forecasts and climate projections are very different things. They have different goals and work in such different ways that one should not be used to comment on or disparage the other.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 171, "text_expl_id": 171, "decided_expl_id": 171, "featured_expl_id": 171, "confidence_expl_id": 171, "judgement_requested": false, "judgement_requested_expl_id": 171, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 171}, "tableName": "statement", "targetLabel": "(?) Weather forecasts and climate projections are very different things. They have different goals and work in such different ways that one should not be used to comment on or disparage the other."}
2025-03-08 11:27:56.422468+00	172	11	1	27	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 27, "label": "Weather forecasts and climate projections are very different things. They have different goals and work in such different ways that one should not be used to comment on or disparage the other.", "id_expl_id": 172, "argument_id": 44, "statement_id": 43, "argument_id_expl_id": 172, "critical_question_id": 9, "statement_id_expl_id": 172, "critical_question_id_expl_id": 172}, "tableName": "critical_statement", "targetLabel": "Weather forecasts and climate projections are very different things. They have different goals and work in such different ways that one should not be used to comment on or disparage the other."}
2025-03-08 11:31:50.323869+00	176	11	1	49	askToJudgeArgument	statement	{"diff": {"after": {"judgement_requested": true}, "before": {"judgement_requested": false, "judgement_requested_expl_id": 173}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "argument": {"title": "Met Office UK says so", "statement_id": 43, "title_expl_id": 173, "judgement_requested": false, "statement_id_expl_id": 173, "judgement_requested_expl_id": 173}, "statement": {"argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 171}, "criticalStatement": {"id": 28, "id_expl_id": 175, "argument_id": 49, "statement_id": 44, "argument_id_expl_id": 175, "critical_question_id": 4, "statement_id_expl_id": 175, "critical_question_id_expl_id": 175}}
2025-03-08 11:33:46.037723+00	177	5	1	10	insertRecord	critical_question	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 10, "text": "Does the argument address the right question?", "id_expl_id": 177, "text_expl_id": 177, "argument_type_id": null, "argument_type_id_expl_id": 177}, "tableName": "critical_question", "targetLabel": "Does the argument address the right question?"}
2025-03-10 13:37:22.859361+00	221	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "spanish"}, "before": {"language": "russian", "language_expl_id": 220}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-08 11:34:32.364651+00	178	11	1	45	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 45, "text": "While a significant gap in understanding and modelling cloud formation creates a problem for predicting future climate, the actual question is about the past.", "label": "(?) While a significant gap in understanding and modelling cloud formation creates a problem for predicting future climate, the actual question is about the past.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 178, "text_expl_id": 178, "decided_expl_id": 178, "featured_expl_id": 178, "confidence_expl_id": 178, "judgement_requested": false, "judgement_requested_expl_id": 178, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 178}, "tableName": "statement", "targetLabel": "(?) While a significant gap in understanding and modelling cloud formation creates a problem for predicting future climate, the actual question is about the past."}
2025-03-10 13:54:22.87242+00	227	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "english"}, "before": {"language": "russian", "language_expl_id": 226}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-08 11:38:38.413839+00	182	5	1	8	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 8, "name": "example", "id_expl_id": 182, "description": "show the existence of some category by providing an example ", "name_expl_id": 182, "description_expl_id": 182}, "tableName": "argument_type", "targetLabel": "example"}
2025-03-13 10:30:03.317126+00	235	\N	1	1	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.5616120614670923, "judgement_requested": false}, "before": {"decided": true, "confidence": 0.56161, "decided_expl_id": 233, "confidence_expl_id": 233, "judgement_requested": false, "judgement_requested_expl_id": 233}}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null}, "confidences": [[0.2, 0.8], [0.2, 0.1, 0.65]], "triggerLabel": "user requested judgement of the statement", "triggerExplId": 234, "statementArguments": [{"id": 1, "pro": true, "title": "Both are yellow and round -> 🟡", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 125, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 5, "pro": true, "title": "Like the Moon, cheese is often a perfect circle.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 4, "pro": true, "title": "Both have holes", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 12, "pro": false, "title": "The Moon is too big", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 3, "pro": false, "title": "There are evidence of the Moon before we were able to launch objects in space.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}], "argumentConfidences": [{"pro": true, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.5, "conditional_confidence": 0.1, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.8, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.65, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}]}
2025-03-13 10:31:24.244832+00	237	\N	1	1	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.5616120614670923, "judgement_requested": false}, "before": {"decided": true, "confidence": 0.56161, "decided_expl_id": 235, "confidence_expl_id": 235, "judgement_requested": false, "judgement_requested_expl_id": 235}}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null}, "confidences": [[0.2, 0.8], [0.2, 0.1, 0.65]], "triggerLabel": "user requested judgement of the statement", "triggerExplId": 236, "statementArguments": [{"id": 1, "pro": true, "title": "Both are yellow and round -> 🟡", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 125, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 5, "pro": true, "title": "Like the Moon, cheese is often a perfect circle.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 4, "pro": true, "title": "Both have holes", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 12, "pro": false, "title": "The Moon is too big", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 3, "pro": false, "title": "There are evidence of the Moon before we were able to launch objects in space.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}], "argumentConfidences": [{"pro": true, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.5, "conditional_confidence": 0.1, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.8, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.65, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}]}
2025-03-13 10:32:53.216045+00	239	\N	1	1	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.5616120614670923, "judgement_requested": false}, "before": {"decided": true, "confidence": 0.56161, "decided_expl_id": 237, "confidence_expl_id": 237, "judgement_requested": false, "judgement_requested_expl_id": 237}}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null}, "confidences": [[0.2, 0.8], [0.2, 0.1, 0.65]], "triggerLabel": "user requested judgement of the statement", "triggerExplId": 238, "statementArguments": [{"id": 1, "pro": true, "title": "Both are yellow and round -> 🟡", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 125, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 5, "pro": true, "title": "Like the Moon, cheese is often a perfect circle.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 4, "pro": true, "title": "Both have holes", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 12, "pro": false, "title": "The Moon is too big", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 3, "pro": false, "title": "There are evidence of the Moon before we were able to launch objects in space.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}], "argumentConfidences": [{"pro": true, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.5, "conditional_confidence": 0.1, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.8, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.65, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}]}
2025-03-13 10:32:53.206421+00	238	2	1	1	askToJudgeEvidentialStatement	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": null}, "judged_expl_id": 239}
2025-03-16 05:38:18.97074+00	247	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"language": "ukrainian", "language_expl_id": 246}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Аліса"}
2025-03-16 07:37:21.208224+00	252	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "arabic"}, "before": {"language": "chinese", "language_expl_id": 251}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "person", "targetLabel": "爱丽丝"}
2025-03-08 11:34:33.64453+00	179	11	1	29	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 29, "label": "While a significant gap in understanding and modelling cloud formation creates a problem for predicting future climate, the actual question is about the past.", "id_expl_id": 179, "argument_id": 45, "statement_id": 45, "argument_id_expl_id": 179, "critical_question_id": 10, "statement_id_expl_id": 179, "critical_question_id_expl_id": 179}, "tableName": "critical_statement", "targetLabel": "While a significant gap in understanding and modelling cloud formation creates a problem for predicting future climate, the actual question is about the past."}
2025-03-10 13:38:26.173644+00	222	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "russian"}, "before": {"language": "spanish", "language_expl_id": 221}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-10 14:26:26.834915+00	228	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "ukrainian"}, "before": {"language": "english", "language_expl_id": 227}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-13 06:25:32.594942+00	231	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"language": "english", "language_expl_id": null}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Alice"}
2025-03-13 10:30:03.307579+00	234	2	1	1	askToJudgeEvidentialStatement	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": null}, "judged_expl_id": 235}
2025-03-13 10:33:51.086393+00	241	\N	1	1	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.5616120614670923, "judgement_requested": false}, "before": {"decided": true, "confidence": 0.56161, "decided_expl_id": 239, "confidence_expl_id": 239, "judgement_requested": false, "judgement_requested_expl_id": 239}}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null}, "confidences": [[0.2, 0.8], [0.2, 0.1, 0.65]], "triggerLabel": "user requested judgement of the statement", "triggerExplId": 240, "statementArguments": [{"id": 1, "pro": true, "title": "Both are yellow and round -> 🟡", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 125, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 5, "pro": true, "title": "Like the Moon, cheese is often a perfect circle.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 4, "pro": true, "title": "Both have holes", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 12, "pro": false, "title": "The Moon is too big", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 3, "pro": false, "title": "There are evidence of the Moon before we were able to launch objects in space.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}], "argumentConfidences": [{"pro": true, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.5, "conditional_confidence": 0.1, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.8, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.65, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}]}
2025-03-13 10:35:24.743132+00	245	\N	1	1	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.5616120614670923, "judgement_requested": false}, "before": {"decided": true, "confidence": 0.56161, "decided_expl_id": 243, "confidence_expl_id": 243, "judgement_requested": false, "judgement_requested_expl_id": 243}}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null}, "confidences": [[0.2, 0.8], [0.2, 0.1, 0.65]], "triggerLabel": "user requested judgement of the statement", "triggerExplId": 244, "statementArguments": [{"id": 1, "pro": true, "title": "Both are yellow and round -> 🟡", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 125, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 5, "pro": true, "title": "Like the Moon, cheese is often a perfect circle.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 4, "pro": true, "title": "Both have holes", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 12, "pro": false, "title": "The Moon is too big", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 3, "pro": false, "title": "There are evidence of the Moon before we were able to launch objects in space.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}], "argumentConfidences": [{"pro": true, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.5, "conditional_confidence": 0.1, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.8, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.65, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}]}
2025-03-13 10:35:24.732544+00	244	2	1	1	askToJudgeEvidentialStatement	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": null}, "judged_expl_id": 245}
2025-03-16 11:48:15.316934+00	254	2	1	\N	insertRecord	tag	\N
2025-03-16 11:59:28.27441+00	257	2	1	9	insertRecord	tag	{"user": {"id": 2, "name": "أليس", "auth_role": "invited"}, "record": {"id": 9, "name": "искуственный интеллект ", "id_expl_id": 257, "name_expl_id": 257}, "tableName": "tag", "targetLabel": "искуственный интеллект "}
2025-03-16 12:04:55.080468+00	265	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"language": "english", "language_expl_id": 264}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Alice"}
2025-03-16 12:01:29.284248+00	258	2	1	10	insertRecord	tag	{"user": {"id": 2, "name": "أليس", "auth_role": "invited"}, "record": {"id": 10, "name": "фантастика", "id_expl_id": 258, "name_expl_id": 258}, "tableName": "tag", "targetLabel": "фантастика"}
2025-03-16 12:03:26.81924+00	260	2	1	10	deleteExtById	tag	{"id": 10, "user": {"id": 2, "name": "أليس", "auth_role": "invited"}, "record": {"id": 10, "name": "фантастика", "id_expl_id": 258, "name_expl_id": 258}, "tableName": "tag", "targetLabel": "фантастика"}
2025-03-16 12:03:29.450259+00	261	2	1	9	deleteExtById	tag	{"id": 9, "user": {"id": 2, "name": "أليس", "auth_role": "invited"}, "record": {"id": 9, "name": "искуственный интеллект ", "id_expl_id": 257, "name_expl_id": 257}, "tableName": "tag", "targetLabel": "искуственный интеллект "}
2025-03-16 12:03:34.035348+00	263	2	1	7	deleteExtById	tag	{"id": 7, "user": {"id": 2, "name": "أليس", "auth_role": "invited"}, "record": {"id": 7, "name": "еда", "id_expl_id": 255, "name_expl_id": 255}, "tableName": "tag", "targetLabel": "еда"}
2025-03-16 12:04:37.600139+00	264	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "english"}, "before": {"language": "russian", "language_expl_id": 253}}, "user": {"id": 2, "name": "أليس", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Алиса"}
2025-03-16 12:05:32.324841+00	267	2	1	12	deleteExtById	tag	{"id": 12, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 12, "name": "бизнес", "id_expl_id": 266, "name_expl_id": 266}, "tableName": "tag", "targetLabel": "бизнес"}
2025-03-08 11:35:07.485336+00	180	11	1	46	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 46, "text": "Models built without full understanding of the underlying mechanism can be accurate enough to be very useful.", "label": "(?) Models built without full understanding of the underlying mechanism can be accurate enough to be very useful.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 180, "text_expl_id": 180, "decided_expl_id": 180, "featured_expl_id": 180, "confidence_expl_id": 180, "judgement_requested": false, "judgement_requested_expl_id": 180, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 180}, "tableName": "statement", "targetLabel": "(?) Models built without full understanding of the underlying mechanism can be accurate enough to be very useful."}
2025-03-08 11:35:09.208428+00	181	11	1	30	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 30, "label": "Models built without full understanding of the underlying mechanism can be accurate enough to be very useful.", "id_expl_id": 181, "argument_id": 45, "statement_id": 46, "argument_id_expl_id": 181, "critical_question_id": 1, "statement_id_expl_id": 181, "critical_question_id_expl_id": 181}, "tableName": "critical_statement", "targetLabel": "Models built without full understanding of the underlying mechanism can be accurate enough to be very useful."}
2025-03-08 11:44:34.138923+00	183	11	1	50	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 50, "pro": true, "title": "Examples of such models", "id_expl_id": 183, "pro_expl_id": 183, "statement_id": 46, "title_expl_id": 183, "argument_type_id": 8, "judgement_requested": false, "statement_id_expl_id": 183, "argument_type_id_expl_id": 183, "judgement_requested_expl_id": 183}, "extRecord": {"id": 50, "text": "There are several notable examples of models that were built without a complete understanding of the underlying mechanisms but were still accurate enough to be highly useful.\\n\\n# Examples provided by ChatGPT\\n\\n**Date**: 2024-06-25\\n\\n**Model**: 4o\\n\\n**Prompt**\\n\\nPlease provide examples of models built without full understanding of the underlying mechanism that at the same time were accurate enough to be very useful.\\n\\n**Answer**\\n\\nThere are several notable examples of models that were built without a complete understanding of the underlying mechanisms but were still accurate enough to be highly useful. Here are a few examples from various fields:\\n\\n### 1. **Weather Forecasting Models**:\\n\\n- **Historical Context**: Early weather forecasting models in the mid-20th century were based on empirical relationships and statistical methods, without a complete understanding of atmospheric dynamics.\\n- **Utility**: These models were able to predict short-term weather patterns accurately enough to be useful for agriculture, aviation, and daily activities, despite significant gaps in understanding of atmospheric processes.\\n\\n### 2. **Antibiotics and Medical Treatments**:\\n\\n- **Penicillin**: As mentioned earlier, penicillin was used extensively to treat bacterial infections well before the full mechanisms of bacterial cell wall synthesis and antibiotic resistance were understood.\\n- **Utility**: Penicillin dramatically reduced mortality rates from bacterial infections and was a major breakthrough in medicine, saving countless lives.\\n\\n### 3. **Thermodynamics**:\\n\\n- **Steam Engines**: The development of steam engines in the 18th century was based on empirical observations and early principles of thermodynamics, long before the laws of thermodynamics were fully formulated.\\n- **Utility**: These engines powered the Industrial Revolution, transforming transportation and manufacturing despite limited theoretical understanding.\\n\\n### 4. **Economics**:\\n\\n- **Keynesian Economic Models**: John Maynard Keynes developed his economic theories and models in the 1930s, focusing on aggregate demand to explain economic fluctuations, without a complete understanding of microeconomic foundations and individual behavior.\\n- **Utility**: Keynesian models were instrumental in shaping economic policy, particularly in guiding fiscal policy to mitigate the effects of economic recessions and depressions.\\n\\n### 5. **Aerodynamics**:\\n\\n- **Wright Brothers' Airplane**: The Wright brothers successfully developed and flew the first powered airplane in 1903 using wind tunnel experiments and empirical data, without a comprehensive understanding of the principles of aerodynamics.\\n- **Utility**: Their work laid the foundation for modern aviation, despite the lack of a full theoretical framework.\\n\\n### 6. **Genetics**:\\n\\n- **Mendelian Genetics**: Gregor Mendel's work on inheritance patterns in pea plants in the 1860s established the fundamental principles of genetics, without knowledge of DNA, chromosomes, or molecular biology.\\n- **Utility**: Mendel's laws of inheritance provided the basis for modern genetics, guiding breeding and heredity studies.\\n\\n### 7. **Quantum Mechanics**:\\n\\n- **Early Quantum Models**: Early models of quantum mechanics, such as Niels Bohr's model of the atom, were developed with incomplete understanding of the underlying quantum phenomena.\\n- **Utility**: These models successfully explained atomic spectra and laid the groundwork for more comprehensive quantum theories, leading to advancements in chemistry and physics.\\n\\n### Conclusion:\\n\\nThese examples demonstrate that models can be highly useful even when built without a full understanding of the underlying mechanisms. The utility of these models often lies in their ability to make accurate predictions or provide practical solutions, which can then be refined and improved as scientific understanding advances. This approach allows for progress and innovation even in the face of incomplete knowledge.", "id_expl_id": 183, "text_expl_id": 183}, "tableName": "argument", "targetLabel": "Examples of such models", "extTableName": "argument_example"}
2025-03-08 11:51:38.441709+00	189	11	1	53	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 53, "pro": true, "title": "the scientist would be motivated by their pursuit of truth", "id_expl_id": 189, "pro_expl_id": 189, "statement_id": 47, "title_expl_id": 189, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 189, "argument_type_id_expl_id": 189, "judgement_requested_expl_id": 189}, "extRecord": {"id": 53, "text": "Such climate scientist would make a contribution in search for truth.", "id_expl_id": 189, "text_expl_id": 189}, "tableName": "argument", "targetLabel": "the scientist would be motivated by their pursuit of truth", "extTableName": "argument_explanation"}
2025-03-08 11:46:47.152025+00	184	11	1	47	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 47, "text": "Let’s suppose a climate scientist has discovered a model that fits observations well and contradicts climate change. In many such cases the scientist would have stronger incentive to publish and popularise this result.", "label": "(?) Let’s suppose a climate scientist has discovered a model that fits observations well and contradicts climate change. In many such cases the scientist would have stronger incentive to publish and popularise this result.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 184, "text_expl_id": 184, "decided_expl_id": 184, "featured_expl_id": 184, "confidence_expl_id": 184, "judgement_requested": false, "judgement_requested_expl_id": 184, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 184}, "tableName": "statement", "targetLabel": "(?) Let’s suppose a climate scientist has discovered a model that fits observations well and contradicts climate change. In many such cases the scientist would have stronger incentive to publish and popularise this result."}
2025-03-08 11:56:51.037132+00	190	11	1	47	updateRecord	argument	{"id": 47, "diff": {"after": {"title": "Prominent climate scientists forge their results to fit a predefined conclusion."}, "before": {"title": "the models are doctored", "title_expl_id": 164}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "Prominent climate scientists forge their results to fit a predefined conclusion."}
2025-03-08 11:46:57.309899+00	185	11	1	31	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 31, "label": "Let’s suppose a climate scientist has discovered a model that fits observations well and contradicts climate change. In many such cases the scientist would have stronger incentive to publish and popularise this result.", "id_expl_id": 185, "argument_id": 47, "statement_id": 47, "argument_id_expl_id": 185, "critical_question_id": 1, "statement_id_expl_id": 185, "critical_question_id_expl_id": 185}, "tableName": "critical_statement", "targetLabel": "Let’s suppose a climate scientist has discovered a model that fits observations well and contradicts climate change. In many such cases the scientist would have stronger incentive to publish and popularise this result."}
2025-03-08 11:49:12.430044+00	186	11	1	47	updateRecord	statement	{"id": 47, "diff": {"after": {"argument_aggregation_type_id": 2}, "before": {"argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 184}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "statement", "targetLabel": "(?) Let’s suppose a climate scientist has discovered a model that fits observations well and contradicts climate change. In many such cases the scientist would have stronger incentive to publish and popularise this result."}
2025-03-08 11:49:46.22832+00	187	11	1	51	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 51, "pro": true, "title": "they will gain fame and recognition", "id_expl_id": 187, "pro_expl_id": 187, "statement_id": 47, "title_expl_id": 187, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 187, "argument_type_id_expl_id": 187, "judgement_requested_expl_id": 187}, "extRecord": {"id": 51, "text": "Such a climate scientist would become famous and an important figure in the history of science.", "id_expl_id": 187, "text_expl_id": 187}, "tableName": "argument", "targetLabel": "they will gain fame and recognition", "extTableName": "argument_explanation"}
2025-03-08 11:50:15.421863+00	188	11	1	52	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 52, "pro": true, "title": "Financial support from Climate Change critics", "id_expl_id": 188, "pro_expl_id": 188, "statement_id": 47, "title_expl_id": 188, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 188, "argument_type_id_expl_id": 188, "judgement_requested_expl_id": 188}, "extRecord": {"id": 52, "text": "Such a climate scientist would be offered financial support by organisations that are disadvantaged by climate policies.", "id_expl_id": 188, "text_expl_id": 188}, "tableName": "argument", "targetLabel": "Financial support from Climate Change critics", "extTableName": "argument_explanation"}
2025-03-08 11:57:38.552942+00	191	11	1	48	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 48, "text": "Prominent climate scientists forge their results to fit a predefined conclusion.", "label": "(?) Prominent climate scientists forge their results to fit a predefined conclusion.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 191, "text_expl_id": 191, "decided_expl_id": 191, "featured_expl_id": 191, "confidence_expl_id": 191, "judgement_requested": false, "judgement_requested_expl_id": 191, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 191}, "tableName": "statement", "targetLabel": "(?) Prominent climate scientists forge their results to fit a predefined conclusion."}
2025-03-08 12:04:22.695942+00	199	11	1	50	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 50, "text": "The \\"decline\\" does not refer to a \\"decline in global temperature\\" as often claimed. It actually refers to a decline in tree growth at certain high-latitude locations. This decline began in the 1960s when tree-ring proxies diverged from the temperature record.", "label": "(?) The \\"decline\\" does not refer to a \\"decline in global temperature\\" as often claimed. It actually refers to a decline in tree growth at certain high-latitude locations. This decline began in the 1960s when tree-ring proxies diverged from the temperature record.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 199, "text_expl_id": 199, "decided_expl_id": 199, "featured_expl_id": 199, "confidence_expl_id": 199, "judgement_requested": false, "judgement_requested_expl_id": 199, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 199}, "tableName": "statement", "targetLabel": "(?) The \\"decline\\" does not refer to a \\"decline in global temperature\\" as often claimed. It actually refers to a decline in tree growth at certain high-latitude locations. This decline began in the 1960s when tree-ring proxies diverged from the temperature record."}
2025-03-08 11:57:39.72508+00	192	11	1	32	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 32, "label": "Prominent climate scientists forge their results to fit a predefined conclusion.", "id_expl_id": 192, "argument_id": 47, "statement_id": 48, "argument_id_expl_id": 192, "critical_question_id": 1, "statement_id_expl_id": 192, "critical_question_id_expl_id": 192}, "tableName": "critical_statement", "targetLabel": "Prominent climate scientists forge their results to fit a predefined conclusion."}
2025-03-08 11:58:16.76771+00	193	11	1	25	deleteExtById	critical_statement	{"id": 25, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 25, "label": "There are leaked emails with one climate scientist telling the other how he is hiding decline in temperatures by using a “trick”.", "id_expl_id": 166, "argument_id": 47, "statement_id": 41, "argument_id_expl_id": 166, "critical_question_id": 1, "statement_id_expl_id": 166, "critical_question_id_expl_id": 166}, "tableName": "critical_statement", "targetLabel": "There are leaked emails with one climate scientist telling the other how he is hiding decline in temperatures by using a “trick”."}
2025-03-08 12:00:59.705521+00	194	11	1	48	updateRecord	argument	{"id": 48, "diff": {"after": {"statement_id": 48}, "before": {"statement_id": 41, "statement_id_expl_id": 167}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "Published leaked materials confirm this"}
2025-03-08 12:02:06.713381+00	195	11	1	41	deleteExtById	statement	{"id": 41, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 41, "text": "There are leaked emails with one climate scientist telling the other how he is hiding decline in temperatures by using a “trick”.", "label": "(?) There are leaked emails with one climate scientist telling the other how he is hiding decline in temperatures by using a “trick”.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 165, "text_expl_id": 165, "decided_expl_id": 165, "featured_expl_id": 165, "confidence_expl_id": 165, "judgement_requested": false, "judgement_requested_expl_id": 165, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 165}, "tableName": "statement", "targetLabel": "(?) There are leaked emails with one climate scientist telling the other how he is hiding decline in temperatures by using a “trick”."}
2025-03-08 12:03:23.524725+00	196	5	1	11	insertRecord	critical_question	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 11, "text": "Does the quote actually make this statement?", "id_expl_id": 196, "text_expl_id": 196, "argument_type_id": 1, "argument_type_id_expl_id": 196}, "tableName": "critical_question", "targetLabel": "Does the quote actually make this statement?"}
2025-03-08 12:04:04.57187+00	197	11	1	49	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 49, "text": "\\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium.", "label": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 197, "text_expl_id": 197, "decided_expl_id": 197, "featured_expl_id": 197, "confidence_expl_id": 197, "judgement_requested": false, "judgement_requested_expl_id": 197, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 197}, "tableName": "statement", "targetLabel": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium."}
2025-03-08 12:04:05.581088+00	198	11	1	33	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 33, "label": "\\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium.", "id_expl_id": 198, "argument_id": 48, "statement_id": 49, "argument_id_expl_id": 198, "critical_question_id": 11, "statement_id_expl_id": 198, "critical_question_id_expl_id": 198}, "tableName": "critical_statement", "targetLabel": "\\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium."}
2025-07-15 00:24:34.102161+00	1186	18	1	12	insertRecord	deed	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 12, "text": "tip", "id_expl_id": 1186, "text_expl_id": 1186}, "tableName": "deed", "targetLabel": "tip"}
2025-03-08 12:04:23.639487+00	200	11	1	34	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 34, "label": "The \\"decline\\" does not refer to a \\"decline in global temperature\\" as often claimed. It actually refers to a decline in tree growth at certain high-latitude locations. This decline began in the 1960s when tree-ring proxies diverged from the temperature record.", "id_expl_id": 200, "argument_id": 48, "statement_id": 50, "argument_id_expl_id": 200, "critical_question_id": 11, "statement_id_expl_id": 200, "critical_question_id_expl_id": 200}, "tableName": "critical_statement", "targetLabel": "The \\"decline\\" does not refer to a \\"decline in global temperature\\" as often claimed. It actually refers to a decline in tree growth at certain high-latitude locations. This decline began in the 1960s when tree-ring proxies diverged from the temperature record."}
2025-03-10 13:41:50.11167+00	223	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "english"}, "before": {"language": "russian", "language_expl_id": 222}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-08 12:04:54.028018+00	202	11	1	35	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 35, "label": "The divergence of tree-ring proxies from temperatures after 1960 is openly discussed in the peer-reviewed literature and the last two IPCC assessment reports.", "id_expl_id": 202, "argument_id": 48, "statement_id": 51, "argument_id_expl_id": 202, "critical_question_id": 11, "statement_id_expl_id": 202, "critical_question_id_expl_id": 202}, "tableName": "critical_statement", "targetLabel": "The divergence of tree-ring proxies from temperatures after 1960 is openly discussed in the peer-reviewed literature and the last two IPCC assessment reports."}
2025-03-10 13:54:10.393322+00	226	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "russian"}, "before": {"language": "ukrainian", "language_expl_id": 225}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-10 14:38:22.67861+00	229	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "english"}, "before": {"language": "ukrainian", "language_expl_id": 228}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-13 10:29:55.22885+00	233	\N	1	1	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.5616120614670923, "judgement_requested": false}, "before": {"decided": true, "confidence": 0.47898, "decided_expl_id": null, "confidence_expl_id": null, "judgement_requested": false, "judgement_requested_expl_id": null}}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null}, "confidences": [[0.2, 0.8], [0.2, 0.1, 0.65]], "triggerLabel": "user requested judgement of the statement", "triggerExplId": 232, "statementArguments": [{"id": 1, "pro": true, "title": "Both are yellow and round -> 🟡", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 125, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 5, "pro": true, "title": "Like the Moon, cheese is often a perfect circle.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 4, "pro": true, "title": "Both have holes", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 12, "pro": false, "title": "The Moon is too big", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 3, "pro": false, "title": "There are evidence of the Moon before we were able to launch objects in space.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}], "argumentConfidences": [{"pro": true, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.5, "conditional_confidence": 0.1, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.8, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.65, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}]}
2025-03-13 10:31:24.234705+00	236	2	1	1	askToJudgeEvidentialStatement	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": null}, "judged_expl_id": 237}
2025-03-13 10:33:51.077453+00	240	2	1	1	askToJudgeEvidentialStatement	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": null}, "judged_expl_id": 241}
2025-03-13 10:34:42.288211+00	243	\N	1	1	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.5616120614670923, "judgement_requested": false}, "before": {"decided": true, "confidence": 0.56161, "decided_expl_id": 241, "confidence_expl_id": 241, "judgement_requested": false, "judgement_requested_expl_id": 241}}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null}, "confidences": [[0.2, 0.8], [0.2, 0.1, 0.65]], "triggerLabel": "user requested judgement of the statement", "triggerExplId": 242, "statementArguments": [{"id": 1, "pro": true, "title": "Both are yellow and round -> 🟡", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 125, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 5, "pro": true, "title": "Like the Moon, cheese is often a perfect circle.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 4, "pro": true, "title": "Both have holes", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 12, "pro": false, "title": "The Moon is too big", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 3, "pro": false, "title": "There are evidence of the Moon before we were able to launch objects in space.", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": null, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}], "argumentConfidences": [{"pro": true, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.5, "conditional_confidence": 0.1, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.2, "conditional_confidence": 0.2, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.8, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.65, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}]}
2025-03-13 10:34:42.278884+00	242	2	1	1	askToJudgeEvidentialStatement	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": null}, "judged_expl_id": 243}
2025-03-16 05:37:36.862452+00	246	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "ukrainian"}, "before": {"language": "russian", "language_expl_id": 231}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Алиса"}
2025-03-16 07:36:53.604757+00	251	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "chinese"}, "before": {"language": "russian", "language_expl_id": 247}}, "user": {"id": 2, "name": "Аліса", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Алиса"}
2025-03-16 07:37:47.63495+00	253	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"language": "arabic", "language_expl_id": 252}}, "user": {"id": 2, "name": "爱丽丝", "auth_role": "invited"}, "tableName": "person", "targetLabel": "أليس"}
2025-03-16 11:53:39.283785+00	255	2	1	7	insertRecord	tag	{"user": {"id": 2, "name": "أليس", "auth_role": "invited"}, "record": {"id": 7, "name": "еда", "id_expl_id": 255, "name_expl_id": 255}, "tableName": "tag", "targetLabel": "еда"}
2025-03-16 12:03:07.382409+00	259	2	1	11	insertRecord	tag	{"user": {"id": 2, "name": "أليس", "auth_role": "invited"}, "record": {"id": 11, "name": "бюрократия", "id_expl_id": 259, "name_expl_id": 259}, "tableName": "tag", "targetLabel": "бюрократия"}
2025-03-08 12:04:52.936994+00	201	11	1	51	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 51, "text": "The divergence of tree-ring proxies from temperatures after 1960 is openly discussed in the peer-reviewed literature and the last two IPCC assessment reports.", "label": "(?) The divergence of tree-ring proxies from temperatures after 1960 is openly discussed in the peer-reviewed literature and the last two IPCC assessment reports.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 201, "text_expl_id": 201, "decided_expl_id": 201, "featured_expl_id": 201, "confidence_expl_id": 201, "judgement_requested": false, "judgement_requested_expl_id": 201, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 201}, "tableName": "statement", "targetLabel": "(?) The divergence of tree-ring proxies from temperatures after 1960 is openly discussed in the peer-reviewed literature and the last two IPCC assessment reports."}
2025-03-10 13:53:02.521637+00	224	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "russian"}, "before": {"language": "english", "language_expl_id": 223}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-09 08:23:16.310345+00	203	13	1	54	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 54, "pro": false, "title": "This scientist will fear attacks by climate activists.", "id_expl_id": 203, "pro_expl_id": 203, "statement_id": 47, "title_expl_id": 203, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 203, "argument_type_id_expl_id": 203, "judgement_requested_expl_id": 203}, "extRecord": {"id": 54, "text": "This scientist will fear attacks by climate activists.", "id_expl_id": 203, "text_expl_id": 203}, "tableName": "argument", "targetLabel": "This scientist will fear attacks by climate activists.", "extTableName": "argument_explanation"}
2025-03-09 08:23:36.061418+00	204	13	1	52	insertRecord	statement	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 52, "text": "This scientist will fear attacks by climate activists.", "label": "(?) This scientist will fear attacks by climate activists.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 204, "text_expl_id": 204, "decided_expl_id": 204, "featured_expl_id": 204, "confidence_expl_id": 204, "judgement_requested": false, "judgement_requested_expl_id": 204, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 204}, "tableName": "statement", "targetLabel": "(?) This scientist will fear attacks by climate activists."}
2025-03-10 13:53:30.376935+00	225	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "ukrainian"}, "before": {"language": "russian", "language_expl_id": 224}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-09 08:23:41.562388+00	205	13	1	36	insertRecord	critical_statement	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 36, "label": "This scientist will fear attacks by climate activists.", "id_expl_id": 205, "argument_id": 54, "statement_id": 52, "argument_id_expl_id": 205, "critical_question_id": 1, "statement_id_expl_id": 205, "critical_question_id_expl_id": 205}, "tableName": "critical_statement", "targetLabel": "This scientist will fear attacks by climate activists."}
2025-03-09 08:25:03.89109+00	206	13	1	52	updateRecord	statement	{"id": 52, "diff": {"after": {"text": "This scientist will fear attacks by climate activists"}, "before": {"text": "This scientist will fear attacks by climate activists.", "text_expl_id": 204}}, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "tableName": "statement", "targetLabel": "(?) This scientist will fear attacks by climate activists"}
2025-03-09 08:26:04.288106+00	207	13	1	52	updateRecord	statement	{"id": 52, "diff": {"after": {"text": "This scientist will fear attacks by climate activists."}, "before": {"text": "This scientist will fear attacks by climate activists", "text_expl_id": 206}}, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "tableName": "statement", "targetLabel": "(?) This scientist will fear attacks by climate activists."}
2025-03-10 07:29:09.913586+00	208	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"name": "Martinn", "language": "english"}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-10 08:23:09.342074+00	209	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"name": "Martinn"}, "before": {"name": "Martin", "name_expl_id": null}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martinn"}
2025-03-10 08:23:20.94791+00	210	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"name": "Martin"}, "before": {"name": "Martinn", "name_expl_id": 209}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-10 08:33:40.705813+00	211	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"name": "Martinn"}, "before": {"name": "Martin", "name_expl_id": 210}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martinn"}
2025-03-10 08:34:53.455218+00	212	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"name": "Martinnn"}, "before": {"name": "Martinn", "name_expl_id": 211}}, "user": {"id": 11, "name": "Martinn", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martinnn"}
2025-03-10 08:35:16.927586+00	213	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"name": "MartinnnM"}, "before": {"name": "Martinnn", "name_expl_id": 212}}, "user": {"id": 11, "name": "Martinnn", "auth_role": "invited"}, "tableName": "person", "targetLabel": "MartinnnM"}
2025-03-10 14:38:50.152614+00	230	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "russian"}, "before": {"language": "english", "language_expl_id": 229}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Martin"}
2025-03-13 10:29:55.209871+00	232	2	1	1	askToJudgeEvidentialStatement	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "statement": {"id": 1, "text": "Луна сделана из сыра", "id_expl_id": null, "text_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": null}, "judged_expl_id": 233}
2025-03-16 12:10:35.595469+00	269	2	1	55	insertExtRecord	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 55, "pro": false, "id_expl_id": 269, "pro_expl_id": 269, "statement_id": 26, "title_expl_id": 269, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 269, "argument_type_id_expl_id": 269, "judgement_requested_expl_id": 269}, "extRecord": {"id": 55, "id_expl_id": 269, "source_url": "https://www.friend-photos-2077.com/astana-at-night", "quote_expl_id": 269, "authority_expl_id": 269, "source_url_expl_id": 269, "source_title_expl_id": 269}, "tableName": "argument", "extTableName": "argument_authority"}
2025-03-16 12:11:52.59732+00	272	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "german"}, "before": {"language": "ukrainian", "language_expl_id": 271}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Аліса"}
2025-03-16 12:12:28.498624+00	273	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"language": "german", "language_expl_id": 272}}, "user": {"id": 2, "name": "Аліса", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Alice"}
2025-03-17 08:44:33.570958+00	333	2	1	45	updateRecord	argument	{"id": 45, "diff": {"after": {"title": "clouds & vapour"}, "before": {"id": 45, "title": "lack of understanding of clouds and effects of vapour", "title_expl_id": 162}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "clouds & vapour"}
2025-03-17 08:58:09.449628+00	338	2	1	43	updateExtRecord	argument	{"id": 43, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"quote": "The results: 10 of the [17] model projections closely matched observations. Moreover, after accounting for differences between modeled and actual changes in atmospheric carbon dioxide and other factors that drive climate, the number increased to 14. The authors found no evidence that the climate models evaluated either systematically overestimated or underestimated warming over the period of their projections"}, "before": {"id": 43, "quote": "The results: 10 of the [17] model projections closely matched observations. Moreover, after accounting for differences between modeled and actual changes in atmospheric carbon dioxide and other factors that drive climate, the number increased to 14. The authors found no evidence that the climate models evaluated either systematically overestimated or underestimated warming over the period of their projections.", "quote_expl_id": 158}}, "tableName": "argument", "targetLabel": "published study", "extTableName": "argument_authority"}
2025-03-27 08:08:00.229369+00	362	11	1	55	updateRecord	argument_judgement	{"id": 55, "diff": {"after": {"isolated_confidence": "0.6", "isolated_explanation": "Good friends don't lie but they may boast", "dismissal_explanation": "but they may boast"}, "before": {"id": 55, "isolated_confidence": 0.8, "isolated_explanation": "Good friends don't lie", "dismissal_explanation": "", "isolated_confidence_expl_id": 361, "isolated_explanation_expl_id": 361, "dismissal_explanation_expl_id": 361}}, "user": {"id": 11, "name": "Мартин", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": 0.6}
2025-03-29 14:21:24.035788+00	376	\N	1	1	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.5880713147898539, "judgement_requested": false}, "before": {"id": 1, "decided": false, "confidence": 0.56161, "decided_expl_id": 245, "confidence_expl_id": 245, "judgement_requested": true, "judgement_requested_expl_id": 245}}, "statement": {"id": 1, "text": "the Moon is made out of cheese", "id_expl_id": null, "text_expl_id": null}, "confidences": [[0.21, 0.8], [0.5, 0.2, 0.44]], "triggerLabel": "update of argument judgement", "triggerExplId": 375, "statementArguments": [{"id": 3, "pro": false, "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 351, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 1, "pro": true, "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 313, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 4, "pro": true, "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 314, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 5, "pro": true, "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 315, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 12, "pro": false, "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 317, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}], "argumentConfidences": [{"pro": false, "pro_expl_id": null, "isolated_confidence": 0.21, "conditional_confidence": null, "isolated_confidence_expl_id": 375, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.5, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.33, "conditional_confidence": 0.2, "isolated_confidence_expl_id": 365, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.65, "conditional_confidence": 0.44, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": 374}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.8, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}]}
2025-03-29 14:23:23.738111+00	377	2	1	3	updateRecord	argument_judgement	{"id": 3, "diff": {"after": {"isolated_confidence": "0.05", "isolated_explanation": "Just saying that there are some evidence is not a strong argument. ", "dismissal_explanation": "test statement update"}, "before": {"id": 3, "isolated_confidence": 0.21, "isolated_explanation": "Just saying that there are some evidence is not a strong argument.", "dismissal_explanation": "Test update", "isolated_confidence_expl_id": 375, "isolated_explanation_expl_id": 375, "dismissal_explanation_expl_id": 375}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "first space launch (5%)"}
2025-03-29 14:51:03.95612+00	380	2	1	78	updateExtRecord	argument	{"id": 78, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"authority": "Wikipedia is often correct about non-controversial topics. "}, "before": {"id": 78, "authority": "Wikipedia is often correct", "authority_expl_id": 379}}, "tableName": "argument", "targetLabel": "string cheese exists", "extTableName": "argument_authority"}
2025-03-29 16:02:11.175275+00	393	2	1	79	updateRecord	argument_judgement	{"id": 79, "diff": {"after": {"isolated_confidence": "1", "isolated_explanation": "Everyone who talked about it confirmed it and never expressed doubt.", "dismissal_explanation": "test"}, "before": {"id": 79, "isolated_confidence": 0.9, "isolated_explanation": "Everyone who talked about it confirmed it and never expressed doubt.", "dismissal_explanation": "test", "isolated_confidence_expl_id": 391, "isolated_explanation_expl_id": 391, "dismissal_explanation_expl_id": 391}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "obvious (100%)"}
2025-03-30 10:10:18.03308+00	412	2	1	26	deleteCrossRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "cross": {"id": 1, "label": "silly", "tableName": "tag"}, "record": {"tag_id": 1, "statement_id": 26, "tag_id_expl_id": 411, "statement_id_expl_id": 411}, "target": {"id": 26, "label": "(85%) Astana is the capital of Kazakhstan", "tableName": "statement"}, "userExpl": "This is not a silly question"}
2025-03-30 10:14:27.387586+00	414	2	1	26	insertCrossRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "cross": {"id": 1, "label": "silly", "tableName": "tag"}, "record": {"tag_id": 1, "statement_id": 26, "tag_id_expl_id": 414, "statement_id_expl_id": 414}, "target": {"id": 26, "label": "(85%) Astana is the capital of Kazakhstan", "tableName": "statement"}}
2025-03-16 12:11:04.217328+00	270	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "english"}, "before": {"language": "russian", "language_expl_id": 265}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Алиса"}
2025-03-17 08:53:41.167886+00	334	2	1	43	updateRecord	argument	{"id": 43, "diff": {"after": {"title": "published study"}, "before": {"id": 43, "title": "This was confirmed in a published study by comparing their predictions with the actual data recorder since 2007.", "title_expl_id": 158}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "published study"}
2025-03-17 08:58:20.662772+00	339	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"id": 2, "language": "english", "language_expl_id": 337}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Alice"}
2025-03-17 15:14:17.035911+00	340	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "english"}, "before": {"id": 2, "language": "russian", "language_expl_id": 339}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Алиса"}
2025-03-27 08:14:48.775969+00	363	11	1	55	updateRecord	argument_judgement	{"id": 55, "diff": {"after": {"isolated_confidence": "0.6", "isolated_explanation": "Good friends don't lie but they may boast", "dismissal_explanation": "test update"}, "before": {"id": 55, "isolated_confidence": 0.6, "isolated_explanation": "Good friends don't lie but they may boast", "dismissal_explanation": "but they may boast", "isolated_confidence_expl_id": 362, "isolated_explanation_expl_id": 362, "dismissal_explanation_expl_id": 362}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": 0.6}
2025-03-29 14:21:23.970054+00	375	2	1	3	updateRecord	argument_judgement	{"id": 3, "diff": {"after": {"isolated_confidence": "0.21", "isolated_explanation": "Just saying that there are some evidence is not a strong argument.", "dismissal_explanation": "Test update"}, "before": {"id": 3, "isolated_confidence": 0.2, "isolated_explanation": "Just saying that there are some evidence is not a strong argument.", "dismissal_explanation": "", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null, "dismissal_explanation_expl_id": null}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "first space launch (21%)"}
2025-03-29 17:29:44.626395+00	395	2	1	13	updateExtRecord	argument	{"id": 13, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {"title": "luxuries"}, "before": {"id": 13, "title": "John Smith like many people would like to have luxuries.", "title_expl_id": null}}, "extRecord": {"after": {"text": "John Smith like many people would like to have luxuries."}, "before": {"id": 13, "text": "", "text_expl_id": null}}, "tableName": "argument", "targetLabel": "luxuries", "extTableName": "argument_other"}
2025-03-29 17:30:05.092776+00	396	2	1	14	updateExtRecord	argument	{"id": 14, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {"title": "early retirement"}, "before": {"id": 14, "title": "John Smith would like to have a nice early retirement.", "title_expl_id": null}}, "extRecord": {"after": {"text": "John Smith would like to have a nice early retirement."}, "before": {"id": 14, "text": "", "text_expl_id": null}}, "tableName": "argument", "targetLabel": "early retirement", "extTableName": "argument_other"}
2025-03-29 17:30:37.373262+00	397	2	1	15	updateExtRecord	argument	{"id": 15, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {"title": "provide for family"}, "before": {"id": 15, "title": "John Smith would like to provide for his family as much as possible.", "title_expl_id": null}}, "extRecord": {"after": {"text": "John Smith would like to provide for his family as much as possible."}, "before": {"id": 15, "text": "", "text_expl_id": null}}, "tableName": "argument", "targetLabel": "provide for family", "extTableName": "argument_other"}
2025-03-29 17:30:52.094158+00	398	2	1	16	updateExtRecord	argument	{"id": 16, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {"title": "jail"}, "before": {"id": 16, "title": "John Smith doesn't want to go to jail.", "title_expl_id": null}}, "extRecord": {"after": {"text": "John Smith doesn't want to go to jail."}, "before": {"id": 16, "text": "", "text_expl_id": null}}, "tableName": "argument", "targetLabel": "jail", "extTableName": "argument_other"}
2025-03-30 10:14:11.01974+00	413	2	1	26	deleteCrossRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "cross": {"id": 3, "label": "housing", "tableName": "tag"}, "record": {"tag_id": 3, "statement_id": 26, "tag_id_expl_id": 410, "statement_id_expl_id": 410}, "target": {"id": 26, "label": "(85%) Astana is the capital of Kazakhstan", "tableName": "statement"}, "userExpl": "this is more about geography than housing"}
2025-03-30 12:02:32.490405+00	424	2	1	2	deleteById	presuasion_critique	{"id": 2, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 2, "id_expl_id": 420, "statement_id": 6, "moral_persuasion_id": 2, "statement_id_expl_id": 420, "moral_persuasion_id_expl_id": 420}, "userExpl": "this is not a relevant critique", "tableName": "presuasion_critique", "targetLabel": 6}
2025-03-30 17:16:31.174505+00	437	2	1	4	insertRecord	presuasion_critique	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 4, "id_expl_id": 437, "statement_id": 49, "moral_persuasion_id": 2, "statement_id_expl_id": 437, "moral_persuasion_id_expl_id": 437}, "tableName": "presuasion_critique", "targetLabel": 49}
2025-03-16 12:11:31.685052+00	271	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "ukrainian"}, "before": {"language": "english", "language_expl_id": 270}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Alice"}
2025-03-16 12:43:29.06794+00	274	2	1	13	insertRecord	tag	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 13, "name": "тест", "id_expl_id": 274, "name_expl_id": 274}, "tableName": "tag", "targetLabel": "тест"}
2025-11-30 12:20:54.411943+00	1733	26	1	193	insertCrossRecords	statement	\N
2025-03-16 12:43:42.67651+00	275	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "english"}, "before": {"language": "russian", "language_expl_id": 273}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Алиса"}
2025-03-16 12:43:57.609974+00	276	2	1	13	deleteExtById	tag	{"id": 13, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"id": 13, "name": "test", "id_expl_id": 274, "name_expl_id": 274}, "tableName": "tag", "targetLabel": "test"}
2025-03-16 12:44:20.837555+00	277	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"language": "english", "language_expl_id": 275}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Alice"}
2025-03-16 13:04:20.407985+00	278	2	1	56	insertExtRecord	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 56, "pro": false, "id_expl_id": 278, "pro_expl_id": 278, "statement_id": 26, "title_expl_id": 278, "argument_type_id": 3, "statement_id_expl_id": 278, "argument_type_id_expl_id": 278, "judgement_requested_expl_id": 278}, "extRecord": {"id": 56, "id_expl_id": 278, "text_expl_id": 278}, "tableName": "argument", "extTableName": "argument_other"}
2025-03-16 13:13:09.802668+00	279	2	1	57	insertExtRecord	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 57, "pro": false, "title": "Сидней столица Казахстана", "id_expl_id": 279, "pro_expl_id": 279, "statement_id": 26, "title_expl_id": 279, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 279, "argument_type_id_expl_id": 279, "judgement_requested_expl_id": 279}, "extRecord": {"id": 57, "id_expl_id": 279, "text_expl_id": 279}, "tableName": "argument", "targetLabel": "Сидней столица Казахстана", "extTableName": "argument_other"}
2025-03-17 08:54:06.391186+00	335	2	1	47	updateRecord	argument	{"id": 47, "diff": {"after": {"title": "forged results"}, "before": {"id": 47, "title": "Prominent climate scientists forge their results to fit a predefined conclusion.", "title_expl_id": 190}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "forged results"}
2025-03-16 13:17:09.792139+00	280	2	1	58	insertExtRecord	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 58, "pro": false, "title": "тест заголовка аргумента", "id_expl_id": 280, "pro_expl_id": 280, "statement_id": 26, "title_expl_id": 280, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 280, "argument_type_id_expl_id": 280, "judgement_requested_expl_id": 280}, "extRecord": {"id": 58, "text": "тест текста аргумента", "id_expl_id": 280, "text_expl_id": 280}, "tableName": "argument", "targetLabel": "тест заголовка аргумента", "extTableName": "argument_other"}
2025-03-16 13:48:33.720967+00	281	2	1	55	updateExtRecord	argument	{"id": 55, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {"title": "Астана на Марсе"}, "before": {"id": 55, "title": "Астана на Луне", "title_expl_id": 269}}, "extRecord": {"after": {"quote": "Видел я эту Астану в ночном небе на Марсе.", "authority": "Мой хороший знакомый всё видел.", "source_url": "https://www.good-friend-photos-2077.com/astana-at-night", "source_title": "Фотки хорошего знакомого"}, "before": {"id": 55, "quote": "Видел я эту Астану в ночном небе.", "authority": "Мой знакомый всё видел.", "source_url": "https://www.friend-photos-2077.com/astana-at-night", "source_title": "Фотки знакомого", "quote_expl_id": 269, "authority_expl_id": 269, "source_url_expl_id": 269, "source_title_expl_id": 269}}, "tableName": "argument", "targetLabel": "Астана на Марсе", "extTableName": "argument_authority"}
2025-03-16 13:49:14.42186+00	283	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"id": 2, "language": "ukrainian", "language_expl_id": 282}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Аліса"}
2025-03-27 08:43:17.372332+00	364	11	1	55	updateRecord	argument_judgement	{"id": 55, "diff": {"after": {"isolated_confidence": "0.6", "isolated_explanation": "Good friends don't lie but they may boast", "dismissal_explanation": "test update 2"}, "before": {"id": 55, "isolated_confidence": 0.6, "isolated_explanation": "Good friends don't lie but they may boast", "dismissal_explanation": "test update", "isolated_confidence_expl_id": 363, "isolated_explanation_expl_id": 363, "dismissal_explanation_expl_id": 363}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "\\"Astana on Mars\\" (60%)"}
2025-03-30 10:14:35.050632+00	415	2	1	26	deleteCrossRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "cross": {"id": 1, "label": "silly", "tableName": "tag"}, "record": {"tag_id": 1, "statement_id": 26, "tag_id_expl_id": 414, "statement_id_expl_id": 414}, "target": {"id": 26, "label": "(85%) Astana is the capital of Kazakhstan", "tableName": "statement"}, "userExpl": "this was a test"}
2025-03-16 13:48:54.59688+00	282	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "ukrainian"}, "before": {"id": 2, "language": "russian", "language_expl_id": 277}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Алиса"}
2025-03-17 08:56:20.756342+00	336	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"id": 2, "language": "english", "language_expl_id": 319}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Alice"}
2025-04-08 02:47:24.67386+00	634	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "english"}, "before": {"id": 2, "language": "russian", "language_expl_id": 623}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Алиса"}
2025-03-27 08:49:04.246381+00	365	11	1	4	updateRecord	argument_judgement	{"id": 4, "diff": {"after": {"isolated_confidence": "0.33", "isolated_explanation": "The argument doesn't specify if the holes in cheese and on the Moon are of the same type.", "dismissal_explanation": "The fact that there are different types of holes doesn't necessarily mean that the holes in cheese and on the Moon are different."}, "before": {"id": 4, "isolated_confidence": 0.2, "isolated_explanation": "One of the premises is false to at least some extent.", "dismissal_explanation": "", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null, "dismissal_explanation_expl_id": null}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "holes (33%)"}
2025-03-29 14:23:23.770261+00	378	\N	1	1	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.6338550247116965, "judgement_requested": false}, "before": {"id": 1, "decided": true, "confidence": 0.58807, "decided_expl_id": 376, "confidence_expl_id": 376, "judgement_requested": false, "judgement_requested_expl_id": 376}}, "statement": {"id": 1, "text": "the Moon is made out of cheese", "id_expl_id": null, "text_expl_id": null}, "confidences": [[0.05, 0.8], [0.5, 0.2, 0.44]], "triggerLabel": "update of argument judgement", "triggerExplId": 377, "statementArguments": [{"id": 3, "pro": false, "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 351, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 1, "pro": true, "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 313, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 4, "pro": true, "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 314, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 5, "pro": true, "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 315, "argument_type_id": 2, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}, {"id": 12, "pro": false, "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 317, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": null, "argument_type_id_expl_id": null, "judgement_requested_expl_id": null}], "argumentConfidences": [{"pro": false, "pro_expl_id": null, "isolated_confidence": 0.05, "conditional_confidence": null, "isolated_confidence_expl_id": 377, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.5, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.33, "conditional_confidence": 0.2, "isolated_confidence_expl_id": 365, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": null, "isolated_confidence": 0.65, "conditional_confidence": 0.44, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": 374}, {"pro": false, "pro_expl_id": null, "isolated_confidence": 0.8, "conditional_confidence": null, "isolated_confidence_expl_id": null, "conditional_confidence_expl_id": null}]}
2025-03-30 17:30:52.357162+00	439	2	1	5	insertRecord	presuasion_critique	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 5, "id_expl_id": 439, "statement_id": 54, "moral_persuasion_id": 2, "statement_id_expl_id": 439, "moral_persuasion_id_expl_id": 439}, "tableName": "presuasion_critique", "targetLabel": 54}
2025-03-29 14:50:00.943797+00	379	2	1	78	insertExtRecord	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 78, "pro": true, "title": "string cheese exists", "id_expl_id": 379, "pro_expl_id": 379, "statement_id": 2, "title_expl_id": 379, "argument_type_id": 1, "statement_id_expl_id": 379, "argument_type_id_expl_id": 379}, "extRecord": {"id": 78, "quote": "String cheese is any of several different types of cheese where the manufacturing process aligns the proteins in the cheese, making it stringy.", "authority": "Wikipedia is often correct", "id_expl_id": 379, "source_url": "https://en.wikipedia.org/wiki/String_cheese", "source_title": "String cheese", "quote_expl_id": 379, "authority_expl_id": 379, "source_url_expl_id": 379, "source_title_expl_id": 379}, "tableName": "argument", "targetLabel": "string cheese exists", "extTableName": "argument_authority"}
2025-03-29 17:31:18.727478+00	399	2	1	17	updateExtRecord	argument	{"id": 17, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {"title": "reputation"}, "before": {"id": 17, "title": "John Smith doesn't want to loose reputation of his family.", "title_expl_id": null}}, "extRecord": {"after": {"text": "John Smith doesn't want to loose reputation of his family."}, "before": {"id": 17, "text": "", "text_expl_id": null}}, "tableName": "argument", "targetLabel": "reputation", "extTableName": "argument_other"}
2025-03-29 17:31:53.996952+00	400	2	1	17	updateRecord	argument	{"id": 17, "diff": {"after": {"title": "reputation loss"}, "before": {"id": 17, "title": "reputation", "title_expl_id": 399}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "reputation loss"}
2025-03-29 17:32:20.64522+00	401	2	1	19	updateExtRecord	argument	{"id": 19, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"after": {"title": "career loss"}, "before": {"id": 19, "title": "John Smith doesn't want to ruin his career.", "title_expl_id": null}}, "extRecord": {"after": {"text": "John Smith doesn't want to ruin his career."}, "before": {"id": 19, "text": "", "text_expl_id": null}}, "tableName": "argument", "targetLabel": "career loss", "extTableName": "argument_other"}
2025-03-29 17:44:15.289696+00	402	5	1	9	updateRecord	statement	{"id": 9, "diff": {"after": {"decided": false, "judgement_requested": true}, "before": {"id": 9, "decided": true, "decided_expl_id": 116, "judgement_requested": false, "judgement_requested_expl_id": 116}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "tableName": "statement", "targetLabel": "(?) John Smith will take bribes if offered"}
2025-03-30 10:31:03.342173+00	416	2	1	60	insertRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 60, "text": "test statement", "label": "(?) test statement", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 416, "text_expl_id": 416, "decided_expl_id": 416, "featured_expl_id": 416, "confidence_expl_id": 416, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 416}, "tableName": "statement", "targetLabel": "(?) test statement"}
2025-03-30 16:01:43.797256+00	425	2	1	42	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 42, "label": "(100%) Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "id_expl_id": 425, "argument_id": 12, "statement_id": 32, "argument_id_expl_id": 425, "critical_question_id": 10, "statement_id_expl_id": 425, "critical_question_id_expl_id": 425}, "tableName": "critical_statement", "targetLabel": "(100%) Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\""}
2025-03-30 17:40:27.546456+00	444	2	1	7	deleteById	presuasion_critique	{"id": 7, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 7, "id_expl_id": 443, "statement_id": 9, "moral_persuasion_id": 2, "statement_id_expl_id": 443, "moral_persuasion_id_expl_id": 443}, "userExpl": "t7", "tableName": "presuasion_critique", "targetLabel": 9}
2025-03-16 13:59:33.135233+00	284	2	1	58	deleteExtById	argument	{"id": 58, "user": {"id": 2, "name": "Аліса", "auth_role": "invited"}, "record": {"id": 58, "pro": false, "title": "тест заголовка аргумента", "id_expl_id": 280, "pro_expl_id": 280, "statement_id": 26, "title_expl_id": 280, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 280, "argument_type_id_expl_id": 280, "judgement_requested_expl_id": 280}, "extRecord": {"id": 58, "text": "тест текста аргумента", "id_expl_id": 280, "text_expl_id": 280}, "tableName": "argument", "targetLabel": "тест заголовка аргумента", "extTableName": "argument_other"}
2025-11-30 13:14:35.906311+00	1735	26	1	194	insertCrossRecords	statement	\N
2025-03-17 08:57:44.883007+00	337	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "english"}, "before": {"id": 2, "language": "russian", "language_expl_id": 336}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Алиса"}
2025-03-30 17:32:14.419195+00	441	2	1	6	insertRecord	presuasion_critique	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 6, "id_expl_id": 441, "statement_id": 18, "moral_persuasion_id": 2, "statement_id_expl_id": 441, "moral_persuasion_id_expl_id": 441}, "tableName": "presuasion_critique", "targetLabel": 18}
2025-03-27 17:12:06.764958+00	366	2	1	56	insertRecord	argument_judgement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 56, "label": "Astana is the capital of the world (10%)", "id_expl_id": 366, "isolated_confidence": 0.1, "isolated_explanation": "Capitals are often cool cities, but there are much fewer capitals than cool cities.", "dismissal_explanation": "", "isolated_confidence_expl_id": 366, "isolated_explanation_expl_id": 366, "dismissal_explanation_expl_id": 366}, "tableName": "argument_judgement", "targetLabel": "Astana is the capital of the world (10%)"}
2025-03-29 15:02:13.336991+00	382	\N	1	2	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.975, "judgement_requested": false}, "before": {"id": 2, "decided": true, "confidence": 1, "decided_expl_id": null, "confidence_expl_id": null, "judgement_requested": false, "judgement_requested_expl_id": null}}, "statement": {"id": 2, "text": "not all cheese is round", "id_expl_id": null, "text_expl_id": null}, "confidences": [[], [0.95]], "triggerLabel": "insert of argument judgement", "triggerExplId": 381, "statementArguments": [{"id": 78, "pro": true, "id_expl_id": 379, "pro_expl_id": 379, "statement_id": 2, "title_expl_id": 379, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 379, "argument_type_id_expl_id": 379, "judgement_requested_expl_id": null}], "argumentConfidences": [{"pro": true, "pro_expl_id": 379, "isolated_confidence": 0.95, "conditional_confidence": null, "isolated_confidence_expl_id": 381, "conditional_confidence_expl_id": null}]}
2025-03-30 16:46:15.792683+00	427	2	1	43	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 43, "label": "(100%) there was a beard tax", "id_expl_id": 427, "argument_id": 12, "statement_id": 12, "argument_id_expl_id": 427, "critical_question_id": 10, "statement_id_expl_id": 427, "critical_question_id_expl_id": 427}, "tableName": "critical_statement", "targetLabel": "(100%) there was a beard tax"}
2025-03-29 15:02:13.297822+00	381	2	1	78	insertRecord	argument_judgement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 78, "label": "string cheese exists (95%)", "id_expl_id": 381, "isolated_confidence": 0.95, "isolated_explanation": "", "dismissal_explanation": "", "isolated_confidence_expl_id": 381, "isolated_explanation_expl_id": 381, "dismissal_explanation_expl_id": 381}, "tableName": "argument_judgement", "targetLabel": "string cheese exists (95%)"}
2025-03-29 19:23:36.656593+00	403	2	1	13	insertRecord	argument_weight	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 13, "id_expl_id": 403, "weight_mode": 15, "weight_explanation": "Luxuries are often not a must.", "weight_lower_limit": 0, "weight_upper_limit": 50, "weight_mode_expl_id": 403, "weight_explanation_expl_id": 403, "weight_lower_limit_expl_id": 403, "weight_upper_limit_expl_id": 403}, "tableName": "argument_weight", "targetLabel": 0}
2025-03-29 19:33:17.812591+00	405	2	1	13	updateRecord	argument_weight	{"id": 13, "diff": {"after": {"weight_mode": "65", "weight_explanation": "Luxuries are often not a must. (test)", "weight_lower_limit": "50", "weight_upper_limit": "100"}, "before": {"id": 13, "weight_mode": 15, "weight_explanation": "Luxuries are often not a must.", "weight_lower_limit": 0, "weight_upper_limit": 50, "weight_mode_expl_id": 403, "weight_explanation_expl_id": 403, "weight_lower_limit_expl_id": 403, "weight_upper_limit_expl_id": 403}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_weight", "targetLabel": 50}
2025-03-29 19:33:39.681717+00	407	2	1	13	updateRecord	argument_weight	{"id": 13, "diff": {"after": {"weight_mode": "15", "weight_explanation": "Luxuries are often not a must.", "weight_lower_limit": "0", "weight_upper_limit": "50"}, "before": {"id": 13, "weight_mode": 65, "weight_explanation": "Luxuries are often not a must. (test)", "weight_lower_limit": 50, "weight_upper_limit": 100, "weight_mode_expl_id": 405, "weight_explanation_expl_id": 405, "weight_lower_limit_expl_id": 405, "weight_upper_limit_expl_id": 405}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_weight", "targetLabel": 0}
2025-03-30 10:47:03.290119+00	417	2	1	60	insertCrossRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "cross": {"id": 1, "label": "silly", "tableName": "tag"}, "record": {"tag_id": 1, "statement_id": 60, "tag_id_expl_id": 417, "statement_id_expl_id": 417}, "target": {"id": 60, "label": "(?) test statement", "tableName": "statement"}}
2025-03-30 16:45:56.208937+00	426	2	1	42	deleteById	critical_statement	{"id": 42, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 42, "label": "(100%) Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "id_expl_id": 425, "argument_id": 12, "statement_id": 32, "argument_id_expl_id": 425, "critical_question_id": 10, "statement_id_expl_id": 425, "critical_question_id_expl_id": 425}, "userExpl": "I added it as a test", "tableName": "critical_statement", "targetLabel": "(100%) Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\""}
2025-04-08 22:39:42.290538+00	635	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"id": 2, "language": "english", "language_expl_id": 634}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Alice"}
2025-04-15 02:12:19.890003+00	803	5	1	13	updateRecord	critical_question	{"id": 13, "diff": {"after": {"text": "Are there enough and sufficiently significant similarities?"}, "before": {"id": 13, "text": "", "id_expl_id": null, "text_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "critical_question", "targetLabel": "Are there enough and sufficiently significant similarities?"}
2025-03-16 15:58:56.703082+00	285	13	1	59	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 59, "pro": false, "title": "contradicting consensus is a professional reputation and relationships risk", "id_expl_id": 285, "pro_expl_id": 285, "statement_id": 47, "title_expl_id": 285, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 285, "argument_type_id_expl_id": 285, "judgement_requested_expl_id": 285}, "extRecord": {"id": 59, "text": "Introducing a model that contradicts the scientific consensus on climate change could risk damaging a scientist's professional reputation and relationships with peers.", "id_expl_id": 285, "text_expl_id": 285}, "tableName": "argument", "targetLabel": "contradicting consensus is a professional reputation and relationships risk", "extTableName": "argument_explanation"}
2025-03-16 16:03:32.348042+00	286	13	1	60	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 60, "pro": false, "title": "risk to funding", "id_expl_id": 286, "pro_expl_id": 286, "statement_id": 47, "title_expl_id": 286, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 286, "argument_type_id_expl_id": 286, "judgement_requested_expl_id": 286}, "extRecord": {"id": 60, "text": "Reporting contradictory findings might jeopardise current and future funding opportunities and create internal conflicts within research institutions.", "id_expl_id": 286, "text_expl_id": 286}, "tableName": "argument", "targetLabel": "risk to funding", "extTableName": "argument_explanation"}
2025-03-16 16:04:59.389083+00	287	13	1	61	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 61, "pro": false, "title": "doubt & ideological reservations", "id_expl_id": 287, "pro_expl_id": 287, "statement_id": 47, "title_expl_id": 287, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 287, "argument_type_id_expl_id": 287, "judgement_requested_expl_id": 287}, "extRecord": {"id": 61, "text": "The scientist may doubt his own result and don’t want to play in the hands of people who are his ideological enemies.", "id_expl_id": 287, "text_expl_id": 287}, "tableName": "argument", "targetLabel": "doubt & ideological reservations", "extTableName": "argument_explanation"}
2025-03-16 16:08:40.799009+00	288	13	1	62	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 62, "pro": true, "title": "UK Home Office reports about terrorist behaviour due to environmentalist ideology", "id_expl_id": 288, "pro_expl_id": 288, "statement_id": 52, "title_expl_id": 288, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 288, "argument_type_id_expl_id": 288, "judgement_requested_expl_id": 288}, "extRecord": {"id": 62, "quote": "There have been \\"a small number of instances of terrorist behaviour that have been motivated by an environmentalist ideology\\"", "authority": "UK Home Office is in charge of UK's internal security", "id_expl_id": 288, "source_url": "https://www.bbc.co.uk/news/uk-67665218", "source_title": "Prevent: Rise in climate activists referred to anti-terror scheme", "quote_expl_id": 288, "authority_expl_id": 288, "source_url_expl_id": 288, "source_title_expl_id": 288}, "tableName": "argument", "targetLabel": "UK Home Office reports about terrorist behaviour due to environmentalist ideology", "extTableName": "argument_authority"}
2025-03-16 16:10:09.539692+00	289	13	1	63	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 63, "pro": true, "title": "public shaming by activists", "id_expl_id": 289, "pro_expl_id": 289, "statement_id": 52, "title_expl_id": 289, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 289, "argument_type_id_expl_id": 289, "judgement_requested_expl_id": 289}, "extRecord": {"id": 63, "text": "Climate activists have sometimes resorted to publicly shaming high-profile individuals perceived as climate change deniers.", "id_expl_id": 289, "text_expl_id": 289}, "tableName": "argument", "targetLabel": "public shaming by activists", "extTableName": "argument_explanation"}
2025-03-16 16:32:20.213526+00	298	13	1	65	deleteExtById	argument	{"id": 65, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 65, "pro": true, "title": "public shaming of Dr. Soon", "id_expl_id": 293, "pro_expl_id": 293, "statement_id": 53, "title_expl_id": 293, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 293, "argument_type_id_expl_id": 293, "judgement_requested_expl_id": 293}, "tableName": "argument", "targetLabel": "public shaming of Dr. Soon", "extTableName": "argument_authority"}
2025-03-16 16:10:59.57676+00	291	13	1	37	insertRecord	critical_statement	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 37, "label": "Climate activists have sometimes resorted to publicly shaming high-profile individuals perceived as climate change deniers.", "id_expl_id": 291, "argument_id": 63, "statement_id": 53, "argument_id_expl_id": 291, "critical_question_id": 1, "statement_id_expl_id": 291, "critical_question_id_expl_id": 291}, "tableName": "critical_statement", "targetLabel": "Climate activists have sometimes resorted to publicly shaming high-profile individuals perceived as climate change deniers."}
2025-03-16 16:31:59.979071+00	296	13	1	68	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 68, "pro": true, "title": "public shaming of Dr. Soon", "id_expl_id": 296, "pro_expl_id": 296, "statement_id": 53, "title_expl_id": 296, "argument_type_id": 8, "judgement_requested": false, "statement_id_expl_id": 296, "argument_type_id_expl_id": 296, "judgement_requested_expl_id": 296}, "extRecord": {"id": 68, "text": "Dr. Soon, an astrophysicist known for his skepticism about the human impact on climate change, has been publicly shamed by climate activists and the media.\\n\\n\\"Greenpeace USA Dr. Willie Soon: a Career Fueled by Koch, Big Oil and Coal\\"\\nhttps://www.greenpeace.org/usa/dr-willie-soon-a-career-fueled-by-koch-big-oil-and-coal", "id_expl_id": 296, "text_expl_id": 296}, "tableName": "argument", "targetLabel": "public shaming of Dr. Soon", "extTableName": "argument_example"}
2025-03-19 08:58:08.501847+00	351	2	1	3	updateRecord	argument	{"id": 3, "diff": {"after": {"title": "first space launch"}, "before": {"id": 3, "title": "before space launch", "title_expl_id": 316}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "first space launch"}
2025-03-16 16:10:54.028057+00	290	13	1	53	insertRecord	statement	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 53, "text": "Climate activists have sometimes resorted to publicly shaming high-profile individuals perceived as climate change deniers.", "label": "(?) Climate activists have sometimes resorted to publicly shaming high-profile individuals perceived as climate change deniers.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 290, "text_expl_id": 290, "decided_expl_id": 290, "featured_expl_id": 290, "confidence_expl_id": 290, "judgement_requested": false, "judgement_requested_expl_id": 290, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 290}, "tableName": "statement", "targetLabel": "(?) Climate activists have sometimes resorted to publicly shaming high-profile individuals perceived as climate change deniers."}
2025-03-17 17:14:35.506862+00	343	2	1	76	insertExtRecord	argument	{"user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"id": 76, "pro": false, "title": "New con", "id_expl_id": 343, "pro_expl_id": 343, "statement_id": 1, "title_expl_id": 343, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 343, "argument_type_id_expl_id": 343, "judgement_requested_expl_id": 343}, "extRecord": {"id": 76, "text": "test 2", "id_expl_id": 343, "text_expl_id": 343}, "tableName": "argument", "targetLabel": "New con", "extTableName": "argument_other"}
2025-03-18 19:18:41.736782+00	347	2	1	55	insertRecord	statement	{"user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"id": 55, "text": "The diameter of the Moon is approx. 3475 km.", "label": "(?) The diameter of the Moon is approx. 3475 km.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 347, "text_expl_id": 347, "decided_expl_id": 347, "featured_expl_id": 347, "confidence_expl_id": 347, "judgement_requested": false, "judgement_requested_expl_id": 347, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 347}, "tableName": "statement", "targetLabel": "(?) The diameter of the Moon is approx. 3475 km."}
2025-03-21 05:51:25.429156+00	352	2	1	38	updateRecord	statement	{"id": 38, "diff": {"after": {"text": "The climate is too complicated to determine if burning fossil fuels has caused the full extent of global warming using our current models."}, "before": {"id": 38, "text": "The climate is too complicated to determine if burning fossil fuels has caused the full extent of global warming using out current models.", "text_expl_id": 142}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "statement", "targetLabel": "(?) The climate is too complicated to determine if burning fossil fuels has caused the full extent of global warming using our current models."}
2025-03-27 17:14:27.627159+00	367	2	1	56	updateRecord	argument_judgement	{"id": 56, "diff": {"after": {"isolated_confidence": "0.1", "isolated_explanation": "Capitals are often cool cities, but there are much fewer capitals than cool cities.", "dismissal_explanation": "test "}, "before": {"id": 56, "isolated_confidence": 0.1, "isolated_explanation": "Capitals are often cool cities, but there are much fewer capitals than cool cities.", "dismissal_explanation": "", "isolated_confidence_expl_id": 366, "isolated_explanation_expl_id": 366, "dismissal_explanation_expl_id": 366}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "Astana is the capital of the world (10%)"}
2025-03-27 17:17:30.294289+00	369	3	1	56	updateRecord	argument_judgement	{"id": 56, "diff": {"after": {"isolated_confidence": "0.01", "isolated_explanation": "Capitals are often cool cities, but there are much fewer capitals than cool cities.", "dismissal_explanation": "the scale of the confidence is off"}, "before": {"id": 56, "isolated_confidence": 0.1, "isolated_explanation": "Capitals are often cool cities, but there are much fewer capitals than cool cities.", "dismissal_explanation": "test 2", "isolated_confidence_expl_id": 368, "isolated_explanation_expl_id": 368, "dismissal_explanation_expl_id": 368}}, "user": {"id": 3, "name": "Bob", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "Astana is the capital of the world (1%)"}
2025-03-29 15:09:39.561417+00	383	2	1	59	insertRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 59, "text": "There are darker spots on the Moon as it appears in the night sky. ", "label": "(?) There are darker spots on the Moon as it appears in the night sky. ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 383, "text_expl_id": 383, "decided_expl_id": 383, "featured_expl_id": 383, "confidence_expl_id": 383, "judgement_requested": false, "judgement_requested_expl_id": 383, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 383}, "tableName": "statement", "targetLabel": "(?) There are darker spots on the Moon as it appears in the night sky. "}
2025-03-30 10:47:12.208045+00	418	2	1	60	deleteCrossRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "cross": {"id": 1, "label": "silly", "tableName": "tag"}, "record": {"tag_id": 1, "statement_id": 60, "tag_id_expl_id": 417, "statement_id_expl_id": 417}, "target": {"id": 60, "label": "(?) test statement", "tableName": "statement"}, "userExpl": "This was a test"}
2025-03-29 15:09:41.915621+00	384	2	1	41	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 41, "label": "(?) There are darker spots on the Moon as it appears in the night sky. ", "id_expl_id": 384, "argument_id": 4, "statement_id": 59, "argument_id_expl_id": 384, "critical_question_id": 1, "statement_id_expl_id": 384, "critical_question_id_expl_id": 384}, "tableName": "critical_statement", "targetLabel": "(?) There are darker spots on the Moon as it appears in the night sky. "}
2025-03-29 19:23:36.721689+00	404	\N	1	9	attemptAggregateArguments	statement	{"diff": {"after": {"decided": true, "confidence": 0.21}, "before": {"id": 9, "decided": false, "confidence": 0.208, "decided_expl_id": 402, "confidence_expl_id": 116}}, "statement": {"id": 9, "text": "John Smith will take bribes if offered", "id_expl_id": null, "text_expl_id": null}, "triggerLabel": "insert of argument weight", "triggerExplId": 403, "weightedArguments": [{"id": 14, "pro": true, "title": "early retirement", "id_expl_id": null, "weight_mode": 20, "weight_lower_limit": 2, "weight_upper_limit": 40, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 17, "pro": false, "title": "reputation loss", "id_expl_id": null, "weight_mode": 20, "weight_lower_limit": 5, "weight_upper_limit": 35, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 19, "pro": false, "title": "career loss", "id_expl_id": null, "weight_mode": 20, "weight_lower_limit": 15, "weight_upper_limit": 40, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 16, "pro": false, "title": "jail", "id_expl_id": null, "weight_mode": 60, "weight_lower_limit": 35, "weight_upper_limit": 90, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 15, "pro": true, "title": "provide for family", "id_expl_id": 114, "weight_mode": 45, "weight_lower_limit": 0, "weight_upper_limit": 60, "weight_mode_expl_id": 114, "weight_explanation_expl_id": 114, "weight_lower_limit_expl_id": 114, "weight_upper_limit_expl_id": 114}, {"id": 13, "pro": true, "title": "luxuries", "id_expl_id": 403, "weight_mode": 15, "weight_lower_limit": 0, "weight_upper_limit": 50, "weight_mode_expl_id": 403, "weight_explanation_expl_id": 403, "weight_lower_limit_expl_id": 403, "weight_upper_limit_expl_id": 403}]}
2025-11-30 14:46:21.496068+00	1737	26	1	195	insertCrossRecords	statement	\N
2025-07-15 02:39:49.083406+00	1221	18	1	\N	insertRecord	moral_good	\N
2025-03-16 16:32:10.805898+00	297	13	1	64	deleteExtById	argument	{"id": 64, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 64, "pro": true, "title": "public shaming of Dr. Soon", "id_expl_id": 292, "pro_expl_id": 292, "statement_id": 53, "title_expl_id": 292, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 292, "argument_type_id_expl_id": 292, "judgement_requested_expl_id": 292}, "tableName": "argument", "targetLabel": "public shaming of Dr. Soon", "extTableName": "argument_authority"}
2025-03-16 16:32:23.341779+00	299	13	1	66	deleteExtById	argument	{"id": 66, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 66, "pro": true, "title": "public shaming of Dr. Soon", "id_expl_id": 294, "pro_expl_id": 294, "statement_id": 53, "title_expl_id": 294, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 294, "argument_type_id_expl_id": 294, "judgement_requested_expl_id": 294}, "tableName": "argument", "targetLabel": "public shaming of Dr. Soon", "extTableName": "argument_authority"}
2025-03-16 16:32:27.760779+00	300	13	1	67	deleteExtById	argument	{"id": 67, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 67, "pro": true, "title": "public shaming of Dr. Soon", "id_expl_id": 295, "pro_expl_id": 295, "statement_id": 53, "title_expl_id": 295, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 295, "argument_type_id_expl_id": 295, "judgement_requested_expl_id": 295}, "tableName": "argument", "targetLabel": "public shaming of Dr. Soon", "extTableName": "argument_authority"}
2025-03-16 16:41:58.429386+00	303	13	1	71	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 71, "pro": true, "title": "test 1", "id_expl_id": 303, "pro_expl_id": 303, "statement_id": 53, "title_expl_id": 303, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 303, "argument_type_id_expl_id": 303, "judgement_requested_expl_id": 303}, "extRecord": {"id": 71, "quote": "t4", "authority": "t2", "id_expl_id": 303, "source_url": "t8", "source_title": "t6", "quote_expl_id": 303, "authority_expl_id": 303, "source_url_expl_id": 303, "source_title_expl_id": 303}, "tableName": "argument", "targetLabel": "test 1", "extTableName": "argument_authority"}
2025-03-16 16:47:13.51926+00	310	13	1	38	insertRecord	critical_statement	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 38, "label": "Activists have launched media campaigns targeting specific individuals to damage their reputations.", "id_expl_id": 310, "argument_id": 73, "statement_id": 54, "argument_id_expl_id": 310, "critical_question_id": 1, "statement_id_expl_id": 310, "critical_question_id_expl_id": 310}, "tableName": "critical_statement", "targetLabel": "Activists have launched media campaigns targeting specific individuals to damage their reputations."}
2025-03-17 17:14:58.214525+00	344	2	1	77	insertExtRecord	argument	{"user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"id": 77, "pro": true, "title": "new pro", "id_expl_id": 344, "pro_expl_id": 344, "statement_id": 1, "title_expl_id": 344, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 344, "argument_type_id_expl_id": 344, "judgement_requested_expl_id": 344}, "extRecord": {"id": 77, "text": "test 3", "id_expl_id": 344, "text_expl_id": 344}, "tableName": "argument", "targetLabel": "new pro", "extTableName": "argument_other"}
2025-03-18 19:18:47.458388+00	348	2	1	39	insertRecord	critical_statement	{"user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"id": 39, "label": "The diameter of the Moon is approx. 3475 km.", "id_expl_id": 348, "argument_id": 12, "statement_id": 55, "argument_id_expl_id": 348, "critical_question_id": 1, "statement_id_expl_id": 348, "critical_question_id_expl_id": 348}, "tableName": "critical_statement", "targetLabel": "The diameter of the Moon is approx. 3475 km."}
2025-03-29 15:28:08.81217+00	385	5	1	9	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 9, "name": "obvious", "id_expl_id": 385, "description": "This is an obvious statement, so adding more arguments is not required.", "name_expl_id": 385, "description_expl_id": 385}, "tableName": "argument_type", "targetLabel": "obvious"}
2025-03-18 19:35:26.700426+00	350	2	1	40	insertRecord	critical_statement	{"user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"id": 40, "label": "The largest cheese wheel ever made had a diameter of 2.4 meters.", "id_expl_id": 350, "argument_id": 12, "statement_id": 56, "argument_id_expl_id": 350, "critical_question_id": 1, "statement_id_expl_id": 350, "critical_question_id_expl_id": 350}, "tableName": "critical_statement", "targetLabel": "The largest cheese wheel ever made had a diameter of 2.4 meters."}
2025-03-21 05:56:05.775088+00	353	2	1	57	insertRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 57, "text": "Test statement", "label": "(?) Test statement", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 353, "text_expl_id": 353, "decided_expl_id": 353, "featured_expl_id": 353, "confidence_expl_id": 353, "judgement_requested": false, "judgement_requested_expl_id": 353, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 353}, "tableName": "statement", "targetLabel": "(?) Test statement"}
2025-03-27 17:16:12.194007+00	368	2	1	56	updateRecord	argument_judgement	{"id": 56, "diff": {"after": {"isolated_confidence": "0.1", "isolated_explanation": "Capitals are often cool cities, but there are much fewer capitals than cool cities.", "dismissal_explanation": "test 2"}, "before": {"id": 56, "isolated_confidence": 0.1, "isolated_explanation": "Capitals are often cool cities, but there are much fewer capitals than cool cities.", "dismissal_explanation": "test ", "isolated_confidence_expl_id": 367, "isolated_explanation_expl_id": 367, "dismissal_explanation_expl_id": 367}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "Astana is the capital of the world (10%)"}
2025-03-30 17:40:19.164298+00	443	2	1	7	insertRecord	presuasion_critique	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 7, "id_expl_id": 443, "statement_id": 9, "moral_persuasion_id": 2, "statement_id_expl_id": 443, "moral_persuasion_id_expl_id": 443}, "tableName": "presuasion_critique", "targetLabel": 9}
2025-03-16 16:42:07.537164+00	304	13	1	71	deleteExtById	argument	{"id": 71, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 71, "pro": true, "title": "test 1", "id_expl_id": 303, "pro_expl_id": 303, "statement_id": 53, "title_expl_id": 303, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 303, "argument_type_id_expl_id": 303, "judgement_requested_expl_id": 303}, "extRecord": {"id": 71, "quote": "t4", "authority": "t2", "id_expl_id": 303, "source_url": "t8", "source_title": "t6", "quote_expl_id": 303, "authority_expl_id": 303, "source_url_expl_id": 303, "source_title_expl_id": 303}, "tableName": "argument", "targetLabel": "test 1", "extTableName": "argument_authority"}
2025-03-16 16:42:14.027597+00	305	13	1	70	deleteExtById	argument	{"id": 70, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 70, "pro": true, "title": "test 1", "id_expl_id": 302, "pro_expl_id": 302, "statement_id": 53, "title_expl_id": 302, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 302, "argument_type_id_expl_id": 302, "judgement_requested_expl_id": 302}, "tableName": "argument", "targetLabel": "test 1", "extTableName": "argument_authority"}
2025-03-16 16:42:19.159275+00	306	13	1	69	deleteExtById	argument	{"id": 69, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 69, "pro": true, "title": "test 1", "id_expl_id": 301, "pro_expl_id": 301, "statement_id": 53, "title_expl_id": 301, "argument_type_id": 1, "judgement_requested": false, "statement_id_expl_id": 301, "argument_type_id_expl_id": 301, "judgement_requested_expl_id": 301}, "tableName": "argument", "targetLabel": "test 1", "extTableName": "argument_authority"}
2025-03-17 17:15:04.464768+00	345	2	1	77	deleteExtById	argument	{"id": 77, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"id": 77, "pro": true, "title": "new pro", "id_expl_id": 344, "pro_expl_id": 344, "statement_id": 1, "title_expl_id": 344, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 344, "argument_type_id_expl_id": 344, "judgement_requested_expl_id": 344}, "extRecord": {"id": 77, "text": "test 3", "id_expl_id": 344, "text_expl_id": 344}, "tableName": "argument", "targetLabel": "new pro", "extTableName": "argument_other"}
2025-03-16 16:46:38.114134+00	308	13	1	73	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 73, "pro": true, "title": "media campaigns to damage reputation", "id_expl_id": 308, "pro_expl_id": 308, "statement_id": 52, "title_expl_id": 308, "argument_type_id": 4, "judgement_requested": false, "statement_id_expl_id": 308, "argument_type_id_expl_id": 308, "judgement_requested_expl_id": 308}, "extRecord": {"id": 73, "text": "Activists have launched media campaigns targeting specific individuals to damage their reputations.", "id_expl_id": 308, "text_expl_id": 308}, "tableName": "argument", "targetLabel": "media campaigns to damage reputation", "extTableName": "argument_explanation"}
2025-03-16 16:47:08.773898+00	309	13	1	54	insertRecord	statement	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 54, "text": "Activists have launched media campaigns targeting specific individuals to damage their reputations.", "label": "(?) Activists have launched media campaigns targeting specific individuals to damage their reputations.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 309, "text_expl_id": 309, "decided_expl_id": 309, "featured_expl_id": 309, "confidence_expl_id": 309, "judgement_requested": false, "judgement_requested_expl_id": 309, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 309}, "tableName": "statement", "targetLabel": "(?) Activists have launched media campaigns targeting specific individuals to damage their reputations."}
2025-03-17 17:15:11.29248+00	346	2	1	76	deleteExtById	argument	{"id": 76, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"id": 76, "pro": false, "title": "New con", "id_expl_id": 343, "pro_expl_id": 343, "statement_id": 1, "title_expl_id": 343, "argument_type_id": 3, "judgement_requested": false, "statement_id_expl_id": 343, "argument_type_id_expl_id": 343, "judgement_requested_expl_id": 343}, "extRecord": {"id": 76, "text": "test 2", "id_expl_id": 343, "text_expl_id": 343}, "tableName": "argument", "targetLabel": "New con", "extTableName": "argument_other"}
2025-03-16 16:48:05.465072+00	311	13	1	74	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 74, "pro": true, "title": "#ExxonKnew campaign", "id_expl_id": 311, "pro_expl_id": 311, "statement_id": 54, "title_expl_id": 311, "argument_type_id": 8, "judgement_requested": false, "statement_id_expl_id": 311, "argument_type_id_expl_id": 311, "judgement_requested_expl_id": 311}, "extRecord": {"id": 74, "text": "#ExxonKnew campaign has targeted executives from ExxonMobil, accusing them of misleading the public about the risks of climate change despite knowing about its dangers for decades. This campaign has aimed to damage the reputations of those executives by highlighting their alleged complicity in delaying climate action. \\n\\nhttps://eidclimate.org/an-orchestrated-campaign/ https://exxonknew.org/ https://trainings.350.org/resource/exxon-knew-a-timeline/", "id_expl_id": 311, "text_expl_id": 311}, "tableName": "argument", "targetLabel": "#ExxonKnew campaign", "extTableName": "argument_example"}
2025-03-18 19:35:22.500931+00	349	2	1	56	insertRecord	statement	{"user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"id": 56, "text": "The largest cheese wheel ever made had a diameter of 2.4 meters.", "label": "(?) The largest cheese wheel ever made had a diameter of 2.4 meters.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 349, "text_expl_id": 349, "decided_expl_id": 349, "featured_expl_id": 349, "confidence_expl_id": 349, "judgement_requested": false, "judgement_requested_expl_id": 349, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 349}, "tableName": "statement", "targetLabel": "(?) The largest cheese wheel ever made had a diameter of 2.4 meters."}
2025-03-21 05:56:28.233237+00	354	2	1	57	updateRecord	statement	{"id": 57, "diff": {"after": {"text": "Test statement 1"}, "before": {"id": 57, "text": "Test statement", "text_expl_id": 353}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "statement", "targetLabel": "(?) Test statement 1"}
2025-03-16 16:44:52.506327+00	307	13	1	72	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 72, "pro": true, "title": "public shaming of Dr. Lindzen", "id_expl_id": 307, "pro_expl_id": 307, "statement_id": 53, "title_expl_id": 307, "argument_type_id": 8, "judgement_requested": false, "statement_id_expl_id": 307, "argument_type_id_expl_id": 307, "judgement_requested_expl_id": 307}, "extRecord": {"id": 72, "text": "Dr. Lindzen, a former MIT professor and vocal climate change skeptic, has faced significant public shaming from both activists and fellow scientists. \\n\\n\\"Exposed: Academics-for-hire agree not to disclose fossil fuel funding\\"\\nhttps://unearthed.greenpeace.org/2015/12/08/exposed-academics-for-hire/", "id_expl_id": 307, "text_expl_id": 307}, "tableName": "argument", "targetLabel": "public shaming of Dr. Lindzen", "extTableName": "argument_example"}
2025-03-16 16:48:46.741772+00	312	13	1	75	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 75, "pro": true, "title": "\\"Top climate deniers\\" website", "id_expl_id": 312, "pro_expl_id": 312, "statement_id": 54, "title_expl_id": 312, "argument_type_id": 8, "judgement_requested": false, "statement_id_expl_id": 312, "argument_type_id_expl_id": 312, "judgement_requested_expl_id": 312}, "extRecord": {"id": 75, "text": "This website lists specific people and labels them Climate Deniers: https://www.beforetheflood.com/top-climate-deniers/", "id_expl_id": 312, "text_expl_id": 312}, "tableName": "argument", "targetLabel": "\\"Top climate deniers\\" website", "extTableName": "argument_example"}
2025-03-17 05:09:46.985495+00	313	13	1	1	updateRecord	argument	{"id": 1, "diff": {"after": {"title": "yellow & round"}, "before": {"id": 1, "title": "Both are yellow and round -> 🟡", "title_expl_id": 125}}, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "yellow & round"}
2025-03-17 05:10:27.602624+00	314	13	1	4	updateExtRecord	argument	{"id": 4, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"after": {"title": "holes"}, "before": {"id": 4, "title": "Both have holes", "title_expl_id": null}}, "extRecord": {"after": {"text": "Both have holes"}}, "tableName": "argument", "targetLabel": "holes", "extTableName": "argument_analogy"}
2025-03-17 05:11:40.368799+00	316	13	1	3	updateExtRecord	argument	{"id": 3, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"after": {"title": "before space launch"}, "before": {"id": 3, "title": "There are evidence of the Moon before we were able to launch objects in space.", "title_expl_id": null}}, "extRecord": {"after": {"text": "There are evidence of the Moon before we were able to launch objects in space."}}, "tableName": "argument", "targetLabel": "before space launch", "extTableName": "argument_other"}
2025-03-21 05:57:24.669079+00	355	2	1	57	deleteExtById	statement	{"id": 57, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 57, "text": "Test statement 1", "label": "(?) Test statement 1", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 353, "text_expl_id": 354, "decided_expl_id": 353, "featured_expl_id": 353, "confidence_expl_id": 353, "judgement_requested": false, "judgement_requested_expl_id": 353, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 353}, "tableName": "statement", "targetLabel": "(?) Test statement 1"}
2025-03-27 18:49:08.280657+00	371	3	1	3	updateRecord	person	{"id": 3, "diff": {"after": {"language": "russian"}, "before": {"id": 3, "language": "english", "language_expl_id": null}}, "user": {"id": 3, "name": "Bob", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Bob"}
2025-03-29 15:32:16.434674+00	386	2	1	79	insertExtRecord	argument	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 79, "pro": true, "title": "obvious", "id_expl_id": 386, "pro_expl_id": 386, "statement_id": 59, "title_expl_id": 386, "argument_type_id": 9, "statement_id_expl_id": 386, "argument_type_id_expl_id": 386}, "extRecord": {"id": 79, "id_expl_id": 386, "obvious_to_majority": true, "majority_is_qualified": true, "obvious_to_majority_expl_id": 386, "majority_is_qualified_expl_id": 386}, "tableName": "argument", "targetLabel": "obvious", "extTableName": "argument_obvious"}
2025-03-29 19:33:17.849686+00	406	\N	1	9	attemptAggregateArguments	statement	{"diff": {"after": {"decided": true, "confidence": 0.483}, "before": {"id": 9, "decided": true, "confidence": 0.21, "decided_expl_id": 404, "confidence_expl_id": 404}}, "statement": {"id": 9, "text": "John Smith will take bribes if offered", "id_expl_id": null, "text_expl_id": null}, "triggerLabel": "update of argument weight", "triggerExplId": 405, "weightedArguments": [{"id": 14, "pro": true, "title": "early retirement", "id_expl_id": null, "weight_mode": 20, "weight_lower_limit": 2, "weight_upper_limit": 40, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 17, "pro": false, "title": "reputation loss", "id_expl_id": null, "weight_mode": 20, "weight_lower_limit": 5, "weight_upper_limit": 35, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 19, "pro": false, "title": "career loss", "id_expl_id": null, "weight_mode": 20, "weight_lower_limit": 15, "weight_upper_limit": 40, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 16, "pro": false, "title": "jail", "id_expl_id": null, "weight_mode": 60, "weight_lower_limit": 35, "weight_upper_limit": 90, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 15, "pro": true, "title": "provide for family", "id_expl_id": 114, "weight_mode": 45, "weight_lower_limit": 0, "weight_upper_limit": 60, "weight_mode_expl_id": 114, "weight_explanation_expl_id": 114, "weight_lower_limit_expl_id": 114, "weight_upper_limit_expl_id": 114}, {"id": 13, "pro": true, "title": "luxuries", "id_expl_id": 403, "weight_mode": 65, "weight_lower_limit": 50, "weight_upper_limit": 100, "weight_mode_expl_id": 405, "weight_explanation_expl_id": 405, "weight_lower_limit_expl_id": 405, "weight_upper_limit_expl_id": 405}]}
2025-03-30 10:55:25.701726+00	419	2	1	60	deleteExtById	statement	{"id": 60, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 60, "text": "test statement", "label": "(?) test statement", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 416, "text_expl_id": 416, "decided_expl_id": 416, "featured_expl_id": 416, "confidence_expl_id": 416, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 416}, "userExpl": "this is only a test", "tableName": "statement", "targetLabel": "(?) test statement"}
2025-03-30 16:48:36.73151+00	428	2	1	43	deleteById	critical_statement	{"id": 43, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 43, "label": "(100%) there was a beard tax", "id_expl_id": 427, "argument_id": 12, "statement_id": 12, "argument_id_expl_id": 427, "critical_question_id": 10, "statement_id_expl_id": 427, "critical_question_id_expl_id": 427}, "userExpl": "test", "tableName": "critical_statement", "targetLabel": "(100%) there was a beard tax"}
2025-03-30 19:02:23.538224+00	451	5	1	1	deleteExtById	rule	{"id": 1, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 1, "name": "assign random", "text": "judges are assigned to arguments at random", "example": "", "role_id": 1, "id_expl_id": null, "name_expl_id": null, "text_expl_id": null, "example_expl_id": null, "role_id_expl_id": null}, "userExpl": "", "tableName": "rule", "targetLabel": "assign random"}
2025-11-30 14:54:44.783755+00	1739	26	1	196	insertCrossRecords	statement	\N
2025-12-17 12:17:51.845855+00	1909	\N	1	\N	cascadeUpdateScores	\N	\N
2025-03-17 05:10:47.026866+00	315	13	1	5	updateExtRecord	argument	{"id": 5, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"after": {"title": "perfect circle"}, "before": {"id": 5, "title": "Like the Moon, cheese is often a perfect circle.", "title_expl_id": null}}, "extRecord": {"after": {"text": "Like the Moon, cheese is often a perfect circle."}}, "tableName": "argument", "targetLabel": "perfect circle", "extTableName": "argument_analogy"}
2025-03-21 06:12:40.490586+00	356	2	1	58	insertRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 58, "text": "test 1", "label": "(?) test 1", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 356, "text_expl_id": 356, "decided_expl_id": 356, "featured_expl_id": 356, "confidence_expl_id": 356, "judgement_requested": false, "judgement_requested_expl_id": 356, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 356}, "tableName": "statement", "targetLabel": "(?) test 1"}
2025-03-21 06:12:57.280985+00	358	2	1	58	deleteExtById	statement	{"id": 58, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 58, "text": "test 2", "label": "(?) test 2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 356, "text_expl_id": 357, "decided_expl_id": 356, "featured_expl_id": 356, "confidence_expl_id": 356, "judgement_requested": false, "judgement_requested_expl_id": 356, "argument_aggregation_type_id": 1, "argument_aggregation_type_id_expl_id": 356}, "tableName": "statement", "targetLabel": "(?) test 2"}
2025-03-27 19:22:20.089988+00	372	2	1	31	updateRecord	argument_judgement	{"id": 31, "diff": {"after": {"isolated_confidence": "0.7", "isolated_explanation": "Not always does not mean often. It could be mostly correct.", "dismissal_explanation": "type"}, "before": {"id": 31, "isolated_confidence": 0.7, "isolated_explanation": "No always does not mean often. It could be mostly correct.", "dismissal_explanation": "", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null, "dismissal_explanation_expl_id": null}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "Wikipedia says so (70%)"}
2025-03-30 17:15:27.829275+00	436	2	1	47	deleteById	critical_statement	{"id": 47, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 47, "label": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium.", "id_expl_id": 435, "argument_id": 12, "statement_id": 49, "argument_id_expl_id": 435, "critical_question_id": 10, "statement_id_expl_id": 435, "critical_question_id_expl_id": 435}, "userExpl": "t5", "tableName": "critical_statement", "targetLabel": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium."}
2025-03-29 15:33:26.996803+00	387	2	1	79	insertRecord	argument_judgement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 79, "label": "obvious (100%)", "id_expl_id": 387, "isolated_confidence": 1, "isolated_explanation": "Everyone who talked about it confirmed it and never expressed a doubt. ", "dismissal_explanation": "", "isolated_confidence_expl_id": 387, "isolated_explanation_expl_id": 387, "dismissal_explanation_expl_id": 387}, "tableName": "argument_judgement", "targetLabel": "obvious (100%)"}
2025-03-29 19:33:39.702867+00	408	\N	1	9	attemptAggregateArguments	statement	{"diff": {"after": {"decided": true, "confidence": 0.215}, "before": {"id": 9, "decided": true, "confidence": 0.483, "decided_expl_id": 406, "confidence_expl_id": 406}}, "statement": {"id": 9, "text": "John Smith will take bribes if offered", "id_expl_id": null, "text_expl_id": null}, "triggerLabel": "update of argument weight", "triggerExplId": 407, "weightedArguments": [{"id": 14, "pro": true, "title": "early retirement", "id_expl_id": null, "weight_mode": 20, "weight_lower_limit": 2, "weight_upper_limit": 40, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 17, "pro": false, "title": "reputation loss", "id_expl_id": null, "weight_mode": 20, "weight_lower_limit": 5, "weight_upper_limit": 35, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 19, "pro": false, "title": "career loss", "id_expl_id": null, "weight_mode": 20, "weight_lower_limit": 15, "weight_upper_limit": 40, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 16, "pro": false, "title": "jail", "id_expl_id": null, "weight_mode": 60, "weight_lower_limit": 35, "weight_upper_limit": 90, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 15, "pro": true, "title": "provide for family", "id_expl_id": 114, "weight_mode": 45, "weight_lower_limit": 0, "weight_upper_limit": 60, "weight_mode_expl_id": 114, "weight_explanation_expl_id": 114, "weight_lower_limit_expl_id": 114, "weight_upper_limit_expl_id": 114}, {"id": 13, "pro": true, "title": "luxuries", "id_expl_id": 403, "weight_mode": 15, "weight_lower_limit": 0, "weight_upper_limit": 50, "weight_mode_expl_id": 407, "weight_explanation_expl_id": 407, "weight_lower_limit_expl_id": 407, "weight_upper_limit_expl_id": 407}]}
2025-03-30 11:46:27.165488+00	420	2	1	2	insertRecord	presuasion_critique	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 2, "id_expl_id": 420, "statement_id": 6, "moral_persuasion_id": 2, "statement_id_expl_id": 420, "moral_persuasion_id_expl_id": 420}, "tableName": "presuasion_critique", "targetLabel": 6}
2025-03-30 16:53:28.021936+00	429	2	1	44	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 44, "label": "(100%) there was a beard tax", "id_expl_id": 429, "argument_id": 12, "statement_id": 12, "argument_id_expl_id": 429, "critical_question_id": 10, "statement_id_expl_id": 429, "critical_question_id_expl_id": 429}, "tableName": "critical_statement", "targetLabel": "(100%) there was a beard tax"}
2025-03-30 17:09:36.191496+00	433	2	1	46	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 46, "label": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium.", "id_expl_id": 433, "argument_id": 12, "statement_id": 49, "argument_id_expl_id": 433, "critical_question_id": 10, "statement_id_expl_id": 433, "critical_question_id_expl_id": 433}, "tableName": "critical_statement", "targetLabel": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium."}
2025-03-30 17:09:51.024037+00	434	2	1	46	deleteById	critical_statement	{"id": 46, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 46, "label": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium.", "id_expl_id": 433, "argument_id": 12, "statement_id": 49, "argument_id_expl_id": 433, "critical_question_id": 10, "statement_id_expl_id": 433, "critical_question_id_expl_id": 433}, "userExpl": "t4", "tableName": "critical_statement", "targetLabel": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium."}
2025-03-31 07:14:23.545018+00	497	9	1	14	insertRecord	tag	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 14, "name": "climate change", "id_expl_id": 497, "name_expl_id": 497}, "tableName": "tag", "targetLabel": "climate change"}
2025-03-17 05:12:01.308267+00	317	13	1	12	updateRecord	argument	{"id": 12, "diff": {"after": {"title": "Moon is too big"}, "before": {"id": 12, "title": "The Moon is too big", "title_expl_id": null}}, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "Moon is too big"}
2025-03-17 06:17:08.842657+00	318	13	1	4	updateExtRecord	argument	{"id": 4, "user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"text": "Both the Moon and cheese have holes."}}, "tableName": "argument", "targetLabel": "holes", "extTableName": "argument_analogy"}
2025-03-21 06:12:48.222298+00	357	2	1	58	updateRecord	statement	{"id": 58, "diff": {"after": {"text": "test 2"}, "before": {"id": 58, "text": "test 1", "text_expl_id": 356}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "statement", "targetLabel": "(?) test 2"}
2025-03-29 15:33:27.021347+00	388	\N	1	59	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 1, "judgement_requested": false}, "before": {"id": 59, "decided": false, "confidence": 0.5, "decided_expl_id": 383, "confidence_expl_id": 383, "judgement_requested": false, "judgement_requested_expl_id": 383}}, "statement": {"id": 59, "text": "There are darker spots on the Moon as it appears in the night sky. ", "id_expl_id": 383, "text_expl_id": 383}, "confidences": [[], [1]], "triggerLabel": "insert of argument judgement", "triggerExplId": 387, "statementArguments": [{"id": 79, "pro": true, "id_expl_id": 386, "pro_expl_id": 386, "statement_id": 59, "title_expl_id": 386, "argument_type_id": 9, "statement_id_expl_id": 386, "argument_type_id_expl_id": 386}], "argumentConfidences": [{"pro": true, "pro_expl_id": 386, "isolated_confidence": 1, "conditional_confidence": null, "isolated_confidence_expl_id": 387, "conditional_confidence_expl_id": null}]}
2025-03-30 08:39:16.478021+00	409	2	1	1	updateRecord	statement	{"id": 1, "diff": {"after": {"text": "the Moon is made out of green cheese"}, "before": {"id": 1, "text": "the Moon is made out of cheese", "text_expl_id": null}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "userExpl": "This is a more accurate phrasing of the original statement", "tableName": "statement", "targetLabel": "(63%) the Moon is made out of green cheese"}
2025-03-30 11:51:46.872649+00	421	2	1	61	insertRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 61, "text": "test 2", "label": "(?) test 2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 421, "text_expl_id": 421, "decided_expl_id": 421, "featured_expl_id": 421, "confidence_expl_id": 421, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 421}, "tableName": "statement", "targetLabel": "(?) test 2"}
2025-03-30 11:51:56.307078+00	422	2	1	3	insertRecord	presuasion_critique	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 3, "id_expl_id": 422, "statement_id": 61, "moral_persuasion_id": 2, "statement_id_expl_id": 422, "moral_persuasion_id_expl_id": 422}, "tableName": "presuasion_critique", "targetLabel": 61}
2025-03-30 16:53:38.990903+00	430	2	1	44	deleteById	critical_statement	{"id": 44, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 44, "label": "(100%) there was a beard tax", "id_expl_id": 429, "argument_id": 12, "statement_id": 12, "argument_id_expl_id": 429, "critical_question_id": 10, "statement_id_expl_id": 429, "critical_question_id_expl_id": 429}, "userExpl": "test 2", "tableName": "critical_statement", "targetLabel": "(100%) there was a beard tax"}
2025-03-30 17:01:12.252786+00	431	2	1	45	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 45, "label": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium.", "id_expl_id": 431, "argument_id": 12, "statement_id": 49, "argument_id_expl_id": 431, "critical_question_id": 10, "statement_id_expl_id": 431, "critical_question_id_expl_id": 431}, "tableName": "critical_statement", "targetLabel": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium."}
2025-03-30 17:01:24.103338+00	432	2	1	45	deleteById	critical_statement	{"id": 45, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 45, "label": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium.", "id_expl_id": 431, "argument_id": 12, "statement_id": 49, "argument_id_expl_id": 431, "critical_question_id": 10, "statement_id_expl_id": 431, "critical_question_id_expl_id": 431}, "userExpl": "t3", "tableName": "critical_statement", "targetLabel": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium."}
2025-03-30 17:16:45.953562+00	438	2	1	4	deleteById	presuasion_critique	{"id": 4, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 4, "id_expl_id": 437, "statement_id": 49, "moral_persuasion_id": 2, "statement_id_expl_id": 437, "moral_persuasion_id_expl_id": 437}, "userExpl": "t6", "tableName": "presuasion_critique", "targetLabel": 49}
2025-03-30 17:32:22.423018+00	442	2	1	6	deleteById	presuasion_critique	{"id": 6, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 6, "id_expl_id": 441, "statement_id": 18, "moral_persuasion_id": 2, "statement_id_expl_id": 441, "moral_persuasion_id_expl_id": 441}, "userExpl": "t7", "tableName": "presuasion_critique", "targetLabel": 18}
2025-03-30 19:40:55.031563+00	460	4	1	44	insertRecord	argument_judgement	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 44, "label": "can't predict weather (2%)", "id_expl_id": 460, "isolated_confidence": 0.02, "isolated_explanation": "The differences listed are relevant and large. This was not appealed. Therefore the comparison can not be treated as valid", "isolated_confidence_expl_id": 460, "isolated_explanation_expl_id": 460}, "tableName": "argument_judgement", "targetLabel": "can't predict weather (2%)"}
2025-11-30 15:04:16.509538+00	1741	26	1	197	insertCrossRecords	statement	\N
2025-12-17 12:48:00.976392+00	1911	\N	1	\N	cascadeUpdateScores	\N	\N
2025-03-17 06:17:54.561954+00	319	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "english"}, "before": {"id": 2, "language": "russian", "language_expl_id": 283}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Алиса"}
2025-03-17 07:44:56.724332+00	323	2	1	1	updateRecord	argument_analogy	{"id": 1, "diff": {"after": {"text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese."}, "before": {"id": 1, "text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese. :)", "text_expl_id": 130}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument_analogy", "targetLabel": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese."}
2025-03-17 08:32:06.387623+00	325	2	1	33	updateRecord	argument	{"id": 33, "diff": {"after": {"title": "because of CO2"}, "before": {"id": 33, "title": "Causal explanation via greenhouse gasses.", "title_expl_id": null}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "because of CO2"}
2025-03-17 08:35:54.155547+00	326	2	1	34	updateRecord	argument	{"id": 34, "diff": {"after": {"title": "natural cause"}, "before": {"id": 34, "title": "natural cause as before", "title_expl_id": null}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "natural cause"}
2025-03-17 08:36:22.028438+00	327	2	1	34	updateRecord	argument	{"id": 34, "diff": {"after": {"title": "natural cause _"}, "before": {"id": 34, "title": "natural cause", "title_expl_id": 326}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "natural cause _"}
2025-03-17 08:37:27.603153+00	328	2	1	34	updateExtRecord	argument	{"id": 34, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"text": "All previous times when the Earth’s atmosphere was warming it was due to natural causes..\\nTherefore this time it is also due to natural rather than man-made causes."}, "before": {"id": 34, "text": "All previous times when the Earth’s atmosphere was warming it was due to natural causes.\\nTherefore this time it is also due to natural rather than man-made causes.", "text_expl_id": null}}, "tableName": "argument", "targetLabel": "natural cause _", "extTableName": "argument_analogy"}
2025-03-17 08:41:09.961503+00	330	2	1	34	updateRecord	argument	{"id": 34, "diff": {"after": {"title": "natural cause"}, "before": {"id": 34, "title": "natural cause _", "title_expl_id": 327}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "natural cause"}
2025-03-17 08:43:51.938989+00	331	2	1	42	updateRecord	argument	{"id": 42, "diff": {"after": {"title": "correct predictions"}, "before": {"id": 42, "title": "current models are sufficient", "title_expl_id": 153}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "correct predictions"}
2025-03-17 08:44:00.282218+00	332	2	1	44	updateRecord	argument	{"id": 44, "diff": {"after": {"title": "can't predict weather"}, "before": {"id": 44, "title": "can't even predict weather", "title_expl_id": 161}}, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "tableName": "argument", "targetLabel": "can't predict weather"}
2025-03-21 06:56:58.161349+00	359	11	1	11	updateRecord	person	{"id": 11, "diff": {"after": {"language": "english"}, "before": {"id": 11, "language": "russian", "language_expl_id": 230}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "tableName": "person", "targetLabel": "Мартин"}
2025-03-29 09:19:40.707219+00	373	2	1	5	insertRecord	argument_conditional	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 5, "id_expl_id": 373, "conditional_confidence": 0.45, "conditional_explanation": "If we know that both of them are not all yellow and round it's less likely that they are both perfect circles.", "conditional_confidence_expl_id": 373, "conditional_explanation_expl_id": 373}, "tableName": "argument_conditional", "targetLabel": 0.45}
2025-03-29 16:01:18.437866+00	389	2	1	79	updateRecord	argument_judgement	{"id": 79, "diff": {"after": {"isolated_confidence": "0.99", "isolated_explanation": "Everyone who talked about it confirmed it and never expressed doubt.", "dismissal_explanation": "test "}, "before": {"id": 79, "isolated_confidence": 1, "isolated_explanation": "Everyone who talked about it confirmed it and never expressed a doubt. ", "dismissal_explanation": "", "isolated_confidence_expl_id": 387, "isolated_explanation_expl_id": 387, "dismissal_explanation_expl_id": 387}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "obvious (99%)"}
2025-03-29 16:01:51.970187+00	392	\N	1	59	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.95, "judgement_requested": false}, "before": {"id": 59, "decided": true, "confidence": 0.995, "decided_expl_id": 390, "confidence_expl_id": 390, "judgement_requested": false, "judgement_requested_expl_id": 390}}, "statement": {"id": 59, "text": "There are darker spots on the Moon as it appears in the night sky. ", "id_expl_id": 383, "text_expl_id": 383}, "confidences": [[], [0.9]], "triggerLabel": "update of argument judgement", "triggerExplId": 391, "statementArguments": [{"id": 79, "pro": true, "id_expl_id": 386, "pro_expl_id": 386, "statement_id": 59, "title_expl_id": 386, "argument_type_id": 9, "statement_id_expl_id": 386, "argument_type_id_expl_id": 386}], "argumentConfidences": [{"pro": true, "pro_expl_id": 386, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 391, "conditional_confidence_expl_id": null}]}
2025-03-30 09:03:58.725229+00	410	2	1	26	insertCrossRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "cross": {"id": 3, "label": "housing", "tableName": "tag"}, "record": {"tag_id": 3, "statement_id": 26, "tag_id_expl_id": 410, "statement_id_expl_id": 410}, "target": {"id": 26, "label": "(85%) Astana is the capital of Kazakhstan", "tableName": "statement"}}
2025-12-17 12:49:36.176541+00	1913	\N	1	\N	cascadeUpdateScores	\N	\N
2025-03-17 08:37:34.555739+00	329	2	1	34	updateExtRecord	argument	{"id": 34, "user": {"id": 2, "name": "Алиса", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "extRecord": {"after": {"text": "All previous times when the Earth’s atmosphere was warming it was due to natural causes.\\nTherefore this time it is also due to natural rather than man-made causes."}, "before": {"id": 34, "text": "All previous times when the Earth’s atmosphere was warming it was due to natural causes..\\nTherefore this time it is also due to natural rather than man-made causes.", "text_expl_id": 328}}, "tableName": "argument", "targetLabel": "natural cause _", "extTableName": "argument_analogy"}
2025-03-27 08:05:34.735694+00	361	11	1	55	insertRecord	argument_judgement	{"user": {"id": 11, "name": "Мартин", "auth_role": "invited"}, "record": {"id": 55, "id_expl_id": 361, "isolated_confidence": 0.8, "isolated_explanation": "Good friends don't lie", "dismissal_explanation": "", "isolated_confidence_expl_id": 361, "isolated_explanation_expl_id": 361, "dismissal_explanation_expl_id": 361}, "tableName": "argument_judgement", "targetLabel": 0.8}
2025-03-29 09:43:14.294454+00	374	2	1	5	updateRecord	argument_conditional	{"id": 5, "diff": {"after": {"conditional_confidence": "0.44", "conditional_explanation": "If we know that both of them are not all (yellow and) round it's less likely that they are both perfect circles."}, "before": {"id": 5, "conditional_confidence": 0.45, "conditional_explanation": "If we know that both of them are not all yellow and round it's less likely that they are both perfect circles.", "conditional_confidence_expl_id": 373, "conditional_explanation_expl_id": 373}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_conditional", "targetLabel": 0.44}
2025-03-29 16:01:18.47301+00	390	\N	1	59	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.995, "judgement_requested": false}, "before": {"id": 59, "decided": true, "confidence": 1, "decided_expl_id": 388, "confidence_expl_id": 388, "judgement_requested": false, "judgement_requested_expl_id": 388}}, "statement": {"id": 59, "text": "There are darker spots on the Moon as it appears in the night sky. ", "id_expl_id": 383, "text_expl_id": 383}, "confidences": [[], [0.99]], "triggerLabel": "update of argument judgement", "triggerExplId": 389, "statementArguments": [{"id": 79, "pro": true, "id_expl_id": 386, "pro_expl_id": 386, "statement_id": 59, "title_expl_id": 386, "argument_type_id": 9, "statement_id_expl_id": 386, "argument_type_id_expl_id": 386}], "argumentConfidences": [{"pro": true, "pro_expl_id": 386, "isolated_confidence": 0.99, "conditional_confidence": null, "isolated_confidence_expl_id": 389, "conditional_confidence_expl_id": null}]}
2025-03-29 16:01:51.948045+00	391	2	1	79	updateRecord	argument_judgement	{"id": 79, "diff": {"after": {"isolated_confidence": "0.9", "isolated_explanation": "Everyone who talked about it confirmed it and never expressed doubt.", "dismissal_explanation": "test"}, "before": {"id": 79, "isolated_confidence": 0.99, "isolated_explanation": "Everyone who talked about it confirmed it and never expressed doubt.", "dismissal_explanation": "test ", "isolated_confidence_expl_id": 389, "isolated_explanation_expl_id": 389, "dismissal_explanation_expl_id": 389}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "tableName": "argument_judgement", "targetLabel": "obvious (90%)"}
2025-03-29 16:02:11.199306+00	394	\N	1	59	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 1, "judgement_requested": false}, "before": {"id": 59, "decided": true, "confidence": 0.95, "decided_expl_id": 392, "confidence_expl_id": 392, "judgement_requested": false, "judgement_requested_expl_id": 392}}, "statement": {"id": 59, "text": "There are darker spots on the Moon as it appears in the night sky. ", "id_expl_id": 383, "text_expl_id": 383}, "confidences": [[], [1]], "triggerLabel": "update of argument judgement", "triggerExplId": 393, "statementArguments": [{"id": 79, "pro": true, "id_expl_id": 386, "pro_expl_id": 386, "statement_id": 59, "title_expl_id": 386, "argument_type_id": 9, "statement_id_expl_id": 386, "argument_type_id_expl_id": 386}], "argumentConfidences": [{"pro": true, "pro_expl_id": 386, "isolated_confidence": 1, "conditional_confidence": null, "isolated_confidence_expl_id": 393, "conditional_confidence_expl_id": null}]}
2025-03-30 09:05:00.331791+00	411	2	1	26	insertCrossRecord	statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "cross": {"id": 1, "label": "silly", "tableName": "tag"}, "record": {"tag_id": 1, "statement_id": 26, "tag_id_expl_id": 411, "statement_id_expl_id": 411}, "target": {"id": 26, "label": "(85%) Astana is the capital of Kazakhstan", "tableName": "statement"}}
2025-03-30 11:52:13.035222+00	423	2	1	3	deleteById	presuasion_critique	{"id": 3, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 3, "id_expl_id": 422, "statement_id": 61, "moral_persuasion_id": 2, "statement_id_expl_id": 422, "moral_persuasion_id_expl_id": 422}, "tableName": "presuasion_critique", "targetLabel": 61}
2025-03-30 17:31:00.692022+00	440	2	1	5	deleteById	presuasion_critique	{"id": 5, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 5, "id_expl_id": 439, "statement_id": 54, "moral_persuasion_id": 2, "statement_id_expl_id": 439, "moral_persuasion_id_expl_id": 439}, "userExpl": "t6", "tableName": "presuasion_critique", "targetLabel": 54}
2025-03-30 17:15:12.663103+00	435	2	1	47	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 47, "label": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium.", "id_expl_id": 435, "argument_id": 12, "statement_id": 49, "argument_id_expl_id": 435, "critical_question_id": 10, "statement_id_expl_id": 435, "critical_question_id_expl_id": 435}, "tableName": "critical_statement", "targetLabel": "(?) \\"Mike's trick\\" refers to a technique by Michael Mann to plot instrumental temperature data on the same graph as reconstructed data over the past millennium."}
2025-11-30 15:07:54.413669+00	1743	26	1	198	insertCrossRecords	statement	\N
2025-03-31 19:50:50.074846+00	512	18	1	15	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 15, "name": "Apollo", "id_expl_id": 512, "name_expl_id": 512}, "tableName": "tag", "targetLabel": "Apollo"}
2025-12-17 12:55:00.812512+00	1915	\N	1	\N	cascadeUpdateScores	\N	\N
2025-03-30 17:40:59.34612+00	445	2	1	48	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 48, "label": "(100%) all cheese has holes", "id_expl_id": 445, "argument_id": 12, "statement_id": 6, "argument_id_expl_id": 445, "critical_question_id": 10, "statement_id_expl_id": 445, "critical_question_id_expl_id": 445}, "tableName": "critical_statement", "targetLabel": "(100%) all cheese has holes"}
2025-04-05 00:59:10.971599+00	543	9	1	67	insertRecord	directive_consequence	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 67, "label": "following petty rules false upheld", "value_id": 20, "id_expl_id": 543, "argument_id": 86, "moral_good_id": 3, "value_id_expl_id": 543, "argument_id_expl_id": 543, "moral_good_id_expl_id": 543}, "tableName": "directive_consequence", "targetLabel": "following petty rules false upheld"}
2025-04-06 18:26:57.751118+00	587	7	1	6	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 6, "label": "free time 20 minute", "value_id": 21, "id_expl_id": 587, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 587, "argument_id_expl_id": 587, "moral_good_id_expl_id": 587}, "tableName": "directive_consequence", "targetLabel": "free time 20 minute"}
2025-04-06 18:37:25.632518+00	590	7	1	8	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 8, "label": "free time 24 minute", "value_id": 25, "id_expl_id": 590, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 590, "argument_id_expl_id": 590, "moral_good_id_expl_id": 590}, "tableName": "directive_consequence", "targetLabel": "free time 24 minute"}
2025-04-06 18:40:58.966441+00	592	7	1	10	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 10, "label": "free time 28 minute", "value_id": 29, "id_expl_id": 592, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 592, "argument_id_expl_id": 592, "moral_good_id_expl_id": 592}, "tableName": "directive_consequence", "targetLabel": "free time 28 minute"}
2025-04-06 18:44:54.620697+00	594	7	1	12	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 12, "label": "free time 32 minute", "value_id": 33, "id_expl_id": 594, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 594, "argument_id_expl_id": 594, "moral_good_id_expl_id": 594}, "tableName": "directive_consequence", "targetLabel": "free time 32 minute"}
2025-04-06 18:46:20.65173+00	595	7	1	13	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 13, "label": "free time 34 minute", "value_id": 35, "id_expl_id": 595, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 595, "argument_id_expl_id": 595, "moral_good_id_expl_id": 595}, "tableName": "directive_consequence", "targetLabel": "free time 34 minute"}
2025-04-06 18:56:44.296475+00	605	7	1	14	deleteById	directive_consequence	{"id": 14, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 14, "label": "free time -100 minute", "value_id": 37, "id_expl_id": 596, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 604, "argument_id_expl_id": 596, "moral_good_id_expl_id": 596}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time -100 minute"}
2025-04-07 19:32:27.092598+00	633	19	1	19	updateRecord	person	{"id": 19, "diff": {"after": {"language": "english"}, "before": {"id": 19, "language": "chinese", "language_expl_id": 632}}, "user": {"id": 19, "name": "Asha", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "阿莎"}
2025-03-30 17:41:05.522562+00	446	2	1	49	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 49, "label": "(?) Met Office UK is not the only respectable weather organisation in the world", "id_expl_id": 446, "argument_id": 12, "statement_id": 44, "argument_id_expl_id": 446, "critical_question_id": 10, "statement_id_expl_id": 446, "critical_question_id_expl_id": 446}, "tableName": "critical_statement", "targetLabel": "(?) Met Office UK is not the only respectable weather organisation in the world"}
2025-04-05 01:02:40.248246+00	544	9	1	67	updateRecord	directive_consequence	{"id": 67, "diff": {"after": {"value_id": 21}, "before": {"id": 67, "value_id": 20, "value_id_expl_id": 543}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "following petty rules true upheld"}
2025-04-06 18:39:06.958521+00	591	7	1	9	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 9, "label": "free time 26 minute", "value_id": 27, "id_expl_id": 591, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 591, "argument_id_expl_id": 591, "moral_good_id_expl_id": 591}, "tableName": "directive_consequence", "targetLabel": "free time 26 minute"}
2025-03-30 17:41:15.502358+00	447	2	1	49	deleteById	critical_statement	{"id": 49, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 49, "label": "(?) Met Office UK is not the only respectable weather organisation in the world", "id_expl_id": 446, "argument_id": 12, "statement_id": 44, "argument_id_expl_id": 446, "critical_question_id": 10, "statement_id_expl_id": 446, "critical_question_id_expl_id": 446}, "userExpl": "t8", "tableName": "critical_statement", "targetLabel": "(?) Met Office UK is not the only respectable weather organisation in the world"}
2025-03-30 17:41:39.988048+00	448	2	1	48	deleteById	critical_statement	{"id": 48, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 48, "label": "(100%) all cheese has holes", "id_expl_id": 445, "argument_id": 12, "statement_id": 6, "argument_id_expl_id": 445, "critical_question_id": 10, "statement_id_expl_id": 445, "critical_question_id_expl_id": 445}, "userExpl": "t9", "tableName": "critical_statement", "targetLabel": "(100%) all cheese has holes"}
2025-12-18 12:39:23.022334+00	1938	18	1	14	insertRecord	deed	{"user": {"id": 18, "name": "Durante", "auth_role": "invited", "permission_level": 1000}, "record": {"id": 14, "text": "test deed 1", "id_expl_id": 1938, "text_expl_id": 1938}, "tableName": "deed", "targetLabel": "test deed 1"}
2025-03-30 17:43:10.526095+00	449	2	1	50	insertRecord	critical_statement	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 50, "label": "(?) Climate models developed before 2007 were correctly predicting global warming.", "id_expl_id": 449, "argument_id": 12, "statement_id": 40, "argument_id_expl_id": 449, "critical_question_id": 10, "statement_id_expl_id": 449, "critical_question_id_expl_id": 449}, "tableName": "critical_statement", "targetLabel": "(?) Climate models developed before 2007 were correctly predicting global warming."}
2025-03-30 17:43:20.614601+00	450	2	1	50	deleteById	critical_statement	{"id": 50, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 50, "label": "(?) Climate models developed before 2007 were correctly predicting global warming.", "id_expl_id": 449, "argument_id": 12, "statement_id": 40, "argument_id_expl_id": 449, "critical_question_id": 10, "statement_id_expl_id": 449, "critical_question_id_expl_id": 449}, "userExpl": "t10", "tableName": "critical_statement", "targetLabel": "(?) Climate models developed before 2007 were correctly predicting global warming."}
2025-04-05 01:04:51.276328+00	546	9	1	1	insertRecord	directive_consequence	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 1, "label": "following petty rules false upheld", "value_id": 23, "id_expl_id": 546, "argument_id": 86, "moral_good_id": 3, "value_id_expl_id": 546, "argument_id_expl_id": 546, "moral_good_id_expl_id": 546}, "tableName": "directive_consequence", "targetLabel": "following petty rules false upheld"}
2025-04-05 01:05:00.854948+00	547	9	1	1	updateRecord	directive_consequence	{"id": 1, "diff": {"after": {"value_id": 24}, "before": {"id": 1, "value_id": 23, "value_id_expl_id": 546}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "following petty rules true upheld"}
2025-04-06 18:41:52.755857+00	593	7	1	11	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 11, "label": "free time 30 minute", "value_id": 31, "id_expl_id": 593, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 593, "argument_id_expl_id": 593, "moral_good_id_expl_id": 593}, "tableName": "directive_consequence", "targetLabel": "free time 30 minute"}
2025-03-30 19:11:55.910214+00	452	4	1	80	insertExtRecord	argument	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 80, "pro": true, "title": "stable seasons", "id_expl_id": 452, "pro_expl_id": 452, "statement_id": 42, "title_expl_id": 452, "argument_type_id": 8, "statement_id_expl_id": 452, "argument_type_id_expl_id": 452}, "extRecord": {"id": 80, "text": "Yearly seasons are very stable. Spring -> Summer -> Autumn -> Winter. In contrast the weather changes from one week to the next during a single month are much more unstable and unpredictable. This is an example of how the statement \\" There is a lot more variation on the smaller scale compared to large scale averages.\\" is true when applied to climate and weather.", "id_expl_id": 452, "text_expl_id": 452}, "tableName": "argument", "targetLabel": "stable seasons", "extTableName": "argument_example"}
2025-03-30 19:13:55.087163+00	454	\N	1	42	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.95}, "before": {"id": 42, "decided": false, "confidence": 0.5, "decided_expl_id": 169, "confidence_expl_id": 169}}, "statement": {"id": 42, "text": "Weather and climate predictions look at averages over a different ranges of space and time. City or country vs the whole earth. Days or weeks vs years and decades. There is a lot more variation on the smaller scale compared to large scale averages.", "id_expl_id": 169, "text_expl_id": 169}, "confidences": [[], [0.9]], "triggerLabel": "insert of argument judgement", "triggerExplId": 453, "statementArguments": [{"id": 80, "pro": true, "id_expl_id": 452, "pro_expl_id": 452, "statement_id": 42, "title_expl_id": 452, "argument_type_id": 8, "statement_id_expl_id": 452, "argument_type_id_expl_id": 452}], "argumentConfidences": [{"pro": true, "pro_expl_id": 452, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 453, "conditional_confidence_expl_id": null}]}
2025-03-30 19:35:54.14925+00	455	4	1	81	insertExtRecord	argument	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 81, "pro": true, "title": "World Met Org", "id_expl_id": 455, "pro_expl_id": 455, "statement_id": 44, "title_expl_id": 455, "argument_type_id": 8, "statement_id_expl_id": 455, "argument_type_id_expl_id": 455}, "extRecord": {"id": 81, "text": "World Meteorological Organization is a specialised agency of the United Nations dedicated to international cooperation and coordination on the state and behaviour of the Earth’s atmosphere, its interaction with the land and oceans, the weather and climate it produces, and the resulting distribution of water resources. It boasts a membership of 193 member states and territories.", "id_expl_id": 455, "text_expl_id": 455}, "tableName": "argument", "targetLabel": "World Met Org", "extTableName": "argument_example"}
2025-04-05 01:07:05.043286+00	548	9	1	2	insertRecord	directive_consequence	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 2, "label": "free time 10 minute", "value_id": 11, "id_expl_id": 548, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 548, "argument_id_expl_id": 548, "moral_good_id_expl_id": 548}, "tableName": "directive_consequence", "targetLabel": "free time 10 minute"}
2025-04-06 18:56:20.61441+00	604	7	1	14	updateRecord	directive_consequence	{"id": 14, "diff": {"after": {"value_id": 37}, "before": {"id": 14, "value_id": 36, "value_id_expl_id": 596}}, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time -100 minute"}
2025-03-30 19:13:55.075556+00	453	4	1	80	insertRecord	argument_judgement	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 80, "label": "stable seasons (90%)", "id_expl_id": 453, "isolated_confidence": 0.9, "isolated_explanation": "", "isolated_confidence_expl_id": 453, "isolated_explanation_expl_id": 453}, "tableName": "argument_judgement", "targetLabel": "stable seasons (90%)"}
2025-11-30 15:13:26.029693+00	1745	26	1	199	insertCrossRecords	statement	\N
2025-04-05 01:07:37.273978+00	549	9	1	2	updateRecord	directive_consequence	{"id": 2, "diff": {"after": {"value_id": 12}, "before": {"id": 2, "value_id": 11, "value_id_expl_id": 548}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time -3 minute"}
2025-04-05 01:08:11.247545+00	550	9	1	3	insertRecord	directive_consequence	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 3, "label": "mess 13 misplaced item / m³", "value_id": 14, "id_expl_id": 550, "argument_id": 88, "moral_good_id": 1, "value_id_expl_id": 550, "argument_id_expl_id": 550, "moral_good_id_expl_id": 550}, "tableName": "directive_consequence", "targetLabel": "mess 13 misplaced item / m³"}
2025-04-05 01:08:34.71196+00	551	9	1	3	updateRecord	directive_consequence	{"id": 3, "diff": {"after": {"value_id": 15}, "before": {"id": 3, "value_id": 14, "value_id_expl_id": 550}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "mess -15 misplaced item / m³"}
2025-04-06 18:57:25.842182+00	606	7	1	15	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 15, "label": "free time -1000 minute", "value_id": 38, "id_expl_id": 606, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 606, "argument_id_expl_id": 606, "moral_good_id_expl_id": 606}, "tableName": "directive_consequence", "targetLabel": "free time -1000 minute"}
2025-03-30 19:36:15.033671+00	457	\N	1	44	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.995}, "before": {"id": 44, "decided": false, "confidence": 0.5, "decided_expl_id": 174, "confidence_expl_id": 174}}, "statement": {"id": 44, "text": "Met Office UK is not the only respectable weather organisation in the world", "id_expl_id": 174, "text_expl_id": 174}, "confidences": [[], [0.99]], "triggerLabel": "insert of argument judgement", "triggerExplId": 456, "statementArguments": [{"id": 81, "pro": true, "id_expl_id": 455, "pro_expl_id": 455, "statement_id": 44, "title_expl_id": 455, "argument_type_id": 8, "statement_id_expl_id": 455, "argument_type_id_expl_id": 455}], "argumentConfidences": [{"pro": true, "pro_expl_id": 455, "isolated_confidence": 0.99, "conditional_confidence": null, "isolated_confidence_expl_id": 456, "conditional_confidence_expl_id": null}]}
2025-03-30 19:36:15.022766+00	456	4	1	81	insertRecord	argument_judgement	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 81, "label": "World Met Org (99%)", "id_expl_id": 456, "isolated_confidence": 0.99, "isolated_explanation": "", "isolated_confidence_expl_id": 456, "isolated_explanation_expl_id": 456}, "tableName": "argument_judgement", "targetLabel": "World Met Org (99%)"}
2025-03-30 19:38:55.679596+00	459	\N	1	43	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.95}, "before": {"id": 43, "decided": false, "confidence": 0.5, "decided_expl_id": 171, "confidence_expl_id": 171}}, "statement": {"id": 43, "text": "Weather forecasts and climate projections are very different things. They have different goals and work in such different ways that one should not be used to comment on or disparage the other.", "id_expl_id": 171, "text_expl_id": 171}, "confidences": [[], [0.9]], "triggerLabel": "insert of argument judgement", "triggerExplId": 458, "statementArguments": [{"id": 49, "pro": true, "id_expl_id": 173, "pro_expl_id": 173, "statement_id": 43, "title_expl_id": 173, "argument_type_id": 1, "statement_id_expl_id": 173, "argument_type_id_expl_id": 173}], "argumentConfidences": [{"pro": true, "pro_expl_id": 173, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 458, "conditional_confidence_expl_id": null}]}
2025-03-30 19:38:55.65582+00	458	4	1	49	insertRecord	argument_judgement	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 49, "label": "Met Office UK says so (90%)", "id_expl_id": 458, "isolated_confidence": 0.9, "isolated_explanation": "Met Office is not the only fitting organisation. However the evidence that respectable met organisations disagree was not presented. ", "isolated_confidence_expl_id": 458, "isolated_explanation_expl_id": 458}, "tableName": "argument_judgement", "targetLabel": "Met Office UK says so (90%)"}
2025-03-30 19:52:09.280643+00	461	10	1	54	updateRecord	argument	{"id": 54, "diff": {"after": {"title": "attacks by activists"}, "before": {"id": 54, "title": "This scientist will fear attacks by climate activists.", "title_expl_id": 203}}, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "attacks by activists"}
2025-03-30 19:53:29.374506+00	462	10	1	62	updateRecord	argument	{"id": 62, "diff": {"after": {"title": "environmentalist terror"}, "before": {"id": 62, "title": "UK Home Office reports about terrorist behaviour due to environmentalist ideology", "title_expl_id": 288}}, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "environmentalist terror"}
2025-03-30 19:54:44.707823+00	463	10	1	62	insertRecord	argument_judgement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 62, "label": "environmentalist terror (85%)", "id_expl_id": 463, "isolated_confidence": 0.85, "isolated_explanation": "It is natural to feel threatened by terrorists who is motivated by views that you oppose.\\nThis quote doesn’t specify how severe this “terrorist behaviour” is.", "isolated_confidence_expl_id": 463, "isolated_explanation_expl_id": 463}, "tableName": "argument_judgement", "targetLabel": "environmentalist terror (85%)"}
2025-03-30 20:04:10.010755+00	465	10	1	72	insertRecord	argument_judgement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 72, "label": "public shaming of Dr. Lindzen (95%)", "id_expl_id": 465, "isolated_confidence": 0.95, "isolated_explanation": "The examples are clear and relevant", "isolated_confidence_expl_id": 465, "isolated_explanation_expl_id": 465}, "tableName": "argument_judgement", "targetLabel": "public shaming of Dr. Lindzen (95%)"}
2025-05-24 13:26:59.491497+00	1100	18	1	128	insertRecord	issue	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 128, "title": "test issue", "id_expl_id": 1100, "description": "test issue description", "title_expl_id": 1100, "description_expl_id": 1100}, "tableName": "issue", "targetLabel": "test issue"}
2025-03-30 20:03:54.359859+00	464	10	1	68	insertRecord	argument_judgement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 68, "label": "public shaming of Dr. Soon (95%)", "id_expl_id": 464, "isolated_confidence": 0.95, "isolated_explanation": "The examples are clear and relevant", "isolated_confidence_expl_id": 464, "isolated_explanation_expl_id": 464}, "tableName": "argument_judgement", "targetLabel": "public shaming of Dr. Soon (95%)"}
2025-03-30 20:04:10.062033+00	466	\N	1	53	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.999375}, "before": {"id": 53, "decided": false, "confidence": 0.5, "decided_expl_id": 290, "confidence_expl_id": 290}}, "statement": {"id": 53, "text": "Climate activists have sometimes resorted to publicly shaming high-profile individuals perceived as climate change deniers.", "id_expl_id": 290, "text_expl_id": 290}, "confidences": [[], [0.95, 0.95]], "triggerLabel": "insert of argument judgement", "triggerExplId": 465, "statementArguments": [{"id": 68, "pro": true, "id_expl_id": 296, "pro_expl_id": 296, "statement_id": 53, "title_expl_id": 296, "argument_type_id": 8, "statement_id_expl_id": 296, "argument_type_id_expl_id": 296}, {"id": 72, "pro": true, "id_expl_id": 307, "pro_expl_id": 307, "statement_id": 53, "title_expl_id": 307, "argument_type_id": 8, "statement_id_expl_id": 307, "argument_type_id_expl_id": 307}], "argumentConfidences": [{"pro": true, "pro_expl_id": 296, "isolated_confidence": 0.95, "conditional_confidence": null, "isolated_confidence_expl_id": 464, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": 307, "isolated_confidence": 0.95, "conditional_confidence": null, "isolated_confidence_expl_id": 465, "conditional_confidence_expl_id": null}]}
2025-03-30 20:04:46.688719+00	467	10	1	63	insertRecord	argument_judgement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 63, "label": "public shaming by activists (65%)", "id_expl_id": 467, "isolated_confidence": 0.65, "isolated_explanation": "People are sometimes but not always fear being publicly shamed by activists", "isolated_confidence_expl_id": 467, "isolated_explanation_expl_id": 467}, "tableName": "argument_judgement", "targetLabel": "public shaming by activists (65%)"}
2025-03-30 20:05:51.193105+00	468	10	1	74	insertRecord	argument_judgement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 74, "label": "#ExxonKnew campaign (95%)", "id_expl_id": 468, "isolated_confidence": 0.95, "isolated_explanation": "The example is clear and relevant", "isolated_confidence_expl_id": 468, "isolated_explanation_expl_id": 468}, "tableName": "argument_judgement", "targetLabel": "#ExxonKnew campaign (95%)"}
2025-03-30 20:06:04.869579+00	470	\N	1	54	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.999375}, "before": {"id": 54, "decided": false, "confidence": 0.5, "decided_expl_id": 309, "confidence_expl_id": 309}}, "statement": {"id": 54, "text": "Activists have launched media campaigns targeting specific individuals to damage their reputations.", "id_expl_id": 309, "text_expl_id": 309}, "confidences": [[], [0.95, 0.95]], "triggerLabel": "insert of argument judgement", "triggerExplId": 469, "statementArguments": [{"id": 74, "pro": true, "id_expl_id": 311, "pro_expl_id": 311, "statement_id": 54, "title_expl_id": 311, "argument_type_id": 8, "statement_id_expl_id": 311, "argument_type_id_expl_id": 311}, {"id": 75, "pro": true, "id_expl_id": 312, "pro_expl_id": 312, "statement_id": 54, "title_expl_id": 312, "argument_type_id": 8, "statement_id_expl_id": 312, "argument_type_id_expl_id": 312}], "argumentConfidences": [{"pro": true, "pro_expl_id": 311, "isolated_confidence": 0.95, "conditional_confidence": null, "isolated_confidence_expl_id": 468, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": 312, "isolated_confidence": 0.95, "conditional_confidence": null, "isolated_confidence_expl_id": 469, "conditional_confidence_expl_id": null}]}
2025-03-30 20:09:36.038364+00	475	10	1	73	insertRecord	argument_conditional	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 73, "id_expl_id": 475, "conditional_confidence": 0.1, "conditional_explanation": "Very similar to the public shaming argument. If a person is not afraid of terrorist behaviour, nor public shaming he is likely to also not be afraid of media campaigns.", "conditional_confidence_expl_id": 475, "conditional_explanation_expl_id": 475}, "tableName": "argument_conditional", "targetLabel": 0.1}
2025-03-30 20:06:04.852983+00	469	10	1	75	insertRecord	argument_judgement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 75, "label": "\\"Top climate deniers\\" website (95%)", "id_expl_id": 469, "isolated_confidence": 0.95, "isolated_explanation": "The example is clear and relevant", "isolated_confidence_expl_id": 469, "isolated_explanation_expl_id": 469}, "tableName": "argument_judgement", "targetLabel": "\\"Top climate deniers\\" website (95%)"}
2025-04-09 08:18:22.469594+00	636	5	1	19	deleteExtById	person	{"id": 19, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 19, "name": "Asha", "language": "english", "id_expl_id": 625, "auth_role_id": 2, "name_expl_id": 625, "language_expl_id": 633, "auth_role_id_expl_id": 625}, "userExpl": "", "tableName": "person", "targetLabel": "Asha"}
2025-04-10 20:04:55.809169+00	686	21	1	94	updateExtRecord	argument	{"id": 94, "user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "typo", "extRecord": {"after": {"text": "Letting Putin win would re-normalise war as a valid method to achieve goals in international politics.\\nHence there will be more war.\\nHence there will be more victims of war and less human development."}, "before": {"id": 94, "text": "Letting Putin win would re-normalise war as a valid method to achieve goals in international politics.\\nHence there will be more war.\\nHence there will be more victims of was and less human development.", "text_expl_id": 685}}, "tableName": "argument", "targetLabel": "normalisation of war", "extTableName": "argument_normative"}
2025-04-10 20:33:46.161426+00	691	10	1	7	insertRecord	directive_scope	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 7, "label": "(+) everyone ", "include": true, "id_expl_id": 691, "directive_id": 71, "include_expl_id": 691, "person_category_id": 5, "directive_id_expl_id": 691, "person_category_id_expl_id": 691}, "tableName": "directive_scope", "targetLabel": "(+) everyone "}
2025-07-15 03:19:38.904503+00	1241	18	1	\N	insertRecord	directive_consequence	\N
2025-03-30 20:06:33.938445+00	472	\N	1	52	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.998359375}, "before": {"id": 52, "decided": false, "confidence": 0.5, "decided_expl_id": 204, "confidence_expl_id": 204}}, "statement": {"id": 52, "text": "This scientist will fear attacks by climate activists.", "id_expl_id": 204, "text_expl_id": 207}, "confidences": [[], [0.65, 0.75, 0.85]], "triggerLabel": "insert of argument judgement", "triggerExplId": 471, "statementArguments": [{"id": 63, "pro": true, "id_expl_id": 289, "pro_expl_id": 289, "statement_id": 52, "title_expl_id": 289, "argument_type_id": 4, "statement_id_expl_id": 289, "argument_type_id_expl_id": 289}, {"id": 73, "pro": true, "id_expl_id": 308, "pro_expl_id": 308, "statement_id": 52, "title_expl_id": 308, "argument_type_id": 4, "statement_id_expl_id": 308, "argument_type_id_expl_id": 308}, {"id": 62, "pro": true, "id_expl_id": 288, "pro_expl_id": 288, "statement_id": 52, "title_expl_id": 462, "argument_type_id": 1, "statement_id_expl_id": 288, "argument_type_id_expl_id": 288}], "argumentConfidences": [{"pro": true, "pro_expl_id": 289, "isolated_confidence": 0.65, "conditional_confidence": null, "isolated_confidence_expl_id": 467, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": 308, "isolated_confidence": 0.75, "conditional_confidence": null, "isolated_confidence_expl_id": 471, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": 288, "isolated_confidence": 0.85, "conditional_confidence": null, "isolated_confidence_expl_id": 463, "conditional_confidence_expl_id": null}]}
2025-03-30 20:06:33.921096+00	471	10	1	73	insertRecord	argument_judgement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 73, "label": "media campaigns to damage reputation (75%)", "id_expl_id": 471, "isolated_confidence": 0.75, "isolated_explanation": "People would often fear such an attack", "isolated_confidence_expl_id": 471, "isolated_explanation_expl_id": 471}, "tableName": "argument_judgement", "targetLabel": "media campaigns to damage reputation (75%)"}
2025-03-30 20:09:36.053565+00	476	\N	1	52	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.9881875}, "before": {"id": 52, "decided": true, "confidence": 0.99672, "decided_expl_id": 474, "confidence_expl_id": 474}}, "statement": {"id": 52, "text": "This scientist will fear attacks by climate activists.", "id_expl_id": 204, "text_expl_id": 207}, "confidences": [[], [0.3, 0.1, 0.85]], "triggerLabel": "insert of argument conditional", "triggerExplId": 475, "statementArguments": [{"id": 63, "pro": true, "id_expl_id": 289, "pro_expl_id": 289, "statement_id": 52, "title_expl_id": 289, "argument_type_id": 4, "statement_id_expl_id": 289, "argument_type_id_expl_id": 289}, {"id": 73, "pro": true, "id_expl_id": 308, "pro_expl_id": 308, "statement_id": 52, "title_expl_id": 308, "argument_type_id": 4, "statement_id_expl_id": 308, "argument_type_id_expl_id": 308}, {"id": 62, "pro": true, "id_expl_id": 288, "pro_expl_id": 288, "statement_id": 52, "title_expl_id": 462, "argument_type_id": 1, "statement_id_expl_id": 288, "argument_type_id_expl_id": 288}], "argumentConfidences": [{"pro": true, "pro_expl_id": 289, "isolated_confidence": 0.65, "conditional_confidence": 0.3, "isolated_confidence_expl_id": 467, "conditional_confidence_expl_id": 473}, {"pro": true, "pro_expl_id": 308, "isolated_confidence": 0.75, "conditional_confidence": 0.1, "isolated_confidence_expl_id": 471, "conditional_confidence_expl_id": 475}, {"pro": true, "pro_expl_id": 288, "isolated_confidence": 0.85, "conditional_confidence": null, "isolated_confidence_expl_id": 463, "conditional_confidence_expl_id": null}]}
2025-04-05 15:03:24.102765+00	552	7	1	1	insertRecord	moral_weight_profile	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 1, "name": "someone", "id_expl_id": 552, "description": "just a profile for testing", "name_expl_id": 552, "description_expl_id": 552}, "tableName": "moral_weight_profile", "targetLabel": "someone"}
2025-03-30 20:08:52.056641+00	474	\N	1	52	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.99671875}, "before": {"id": 52, "decided": true, "confidence": 0.99836, "decided_expl_id": 472, "confidence_expl_id": 472}}, "statement": {"id": 52, "text": "This scientist will fear attacks by climate activists.", "id_expl_id": 204, "text_expl_id": 207}, "confidences": [[], [0.3, 0.75, 0.85]], "triggerLabel": "insert of argument conditional", "triggerExplId": 473, "statementArguments": [{"id": 63, "pro": true, "id_expl_id": 289, "pro_expl_id": 289, "statement_id": 52, "title_expl_id": 289, "argument_type_id": 4, "statement_id_expl_id": 289, "argument_type_id_expl_id": 289}, {"id": 73, "pro": true, "id_expl_id": 308, "pro_expl_id": 308, "statement_id": 52, "title_expl_id": 308, "argument_type_id": 4, "statement_id_expl_id": 308, "argument_type_id_expl_id": 308}, {"id": 62, "pro": true, "id_expl_id": 288, "pro_expl_id": 288, "statement_id": 52, "title_expl_id": 462, "argument_type_id": 1, "statement_id_expl_id": 288, "argument_type_id_expl_id": 288}], "argumentConfidences": [{"pro": true, "pro_expl_id": 289, "isolated_confidence": 0.65, "conditional_confidence": 0.3, "isolated_confidence_expl_id": 467, "conditional_confidence_expl_id": 473}, {"pro": true, "pro_expl_id": 308, "isolated_confidence": 0.75, "conditional_confidence": null, "isolated_confidence_expl_id": 471, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": 288, "isolated_confidence": 0.85, "conditional_confidence": null, "isolated_confidence_expl_id": 463, "conditional_confidence_expl_id": null}]}
2025-04-05 15:04:23.037668+00	553	7	1	12	insertRecord	moral_weight	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 12, "label": "(-3 / upheld) following petty rules", "weight": -3, "id_expl_id": 553, "moral_good_id": 3, "weight_expl_id": 553, "moral_good_id_expl_id": 553}, "tableName": "moral_weight", "targetLabel": "(-3 / upheld) following petty rules"}
2025-04-06 18:57:46.531556+00	607	7	1	15	deleteById	directive_consequence	{"id": 15, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 15, "label": "free time -1000 minute", "value_id": 38, "id_expl_id": 606, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 606, "argument_id_expl_id": 606, "moral_good_id_expl_id": 606}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time -1000 minute"}
2025-03-30 20:08:52.031378+00	473	10	1	63	insertRecord	argument_conditional	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 63, "id_expl_id": 473, "conditional_confidence": 0.3, "conditional_explanation": "someone who doesn’t fear terrorist behaviour against him is unlikely to be afraid of public shaming as it’s much less extreme. However it is a thread of a different kind.", "conditional_confidence_expl_id": 473, "conditional_explanation_expl_id": 473}, "tableName": "argument_conditional", "targetLabel": 0.3}
2025-03-30 21:07:06.550431+00	478	\N	1	52	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.95275}, "before": {"id": 52, "decided": true, "confidence": 0.98819, "decided_expl_id": 476, "confidence_expl_id": 476}}, "statement": {"id": 52, "text": "This scientist will fear attacks by climate activists.", "id_expl_id": 204, "text_expl_id": 207}, "confidences": [[], [0.3, 0.1, 0.85]], "triggerLabel": "update of argument conditional", "triggerExplId": 477, "statementArguments": [{"id": 63, "pro": true, "id_expl_id": 289, "pro_expl_id": 289, "statement_id": 52, "title_expl_id": 289, "argument_type_id": 4, "statement_id_expl_id": 289, "argument_type_id_expl_id": 289}, {"id": 73, "pro": true, "id_expl_id": 308, "pro_expl_id": 308, "statement_id": 52, "title_expl_id": 308, "argument_type_id": 4, "statement_id_expl_id": 308, "argument_type_id_expl_id": 308}, {"id": 62, "pro": true, "id_expl_id": 288, "pro_expl_id": 288, "statement_id": 52, "title_expl_id": 462, "argument_type_id": 1, "statement_id_expl_id": 288, "argument_type_id_expl_id": 288}], "argumentConfidences": [{"pro": true, "pro_expl_id": 289, "isolated_confidence": 0.65, "conditional_confidence": 0.3, "isolated_confidence_expl_id": 467, "conditional_confidence_expl_id": 473}, {"pro": true, "pro_expl_id": 308, "isolated_confidence": 0.75, "conditional_confidence": 0.1, "isolated_confidence_expl_id": 471, "conditional_confidence_expl_id": 477}, {"pro": true, "pro_expl_id": 288, "isolated_confidence": 0.85, "conditional_confidence": null, "isolated_confidence_expl_id": 463, "conditional_confidence_expl_id": null}]}
2025-03-30 21:24:06.26606+00	480	9	1	47	updateRecord	statement	{"id": 47, "diff": {"after": {"text": "A scientist will have a stronger incentive to publish and popularise his model if it turns out that it fits observations well and contradicts climate change."}, "before": {"id": 47, "text": "Let’s suppose a climate scientist has discovered a model that fits observations well and contradicts climate change. In many such cases the scientist would have stronger incentive to publish and popularise this result.", "text_expl_id": 184}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "This change avoids ambiguity of the word “many”.", "tableName": "statement", "targetLabel": "(?) A scientist will have a stronger incentive to publish and popularise his model if it turns out that it fits observations well and contradicts climate change."}
2025-04-05 15:04:24.967701+00	554	7	1	12	insertRecord	moral_weight_of_profile	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 12, "id_expl_id": 554, "profile_id": 1, "profile_id_expl_id": 554}, "tableName": "moral_weight_of_profile", "targetLabel": 1}
2025-04-06 19:32:30.365071+00	608	7	1	16	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 16, "label": "following petty rules true upheld", "value_id": 25, "id_expl_id": 608, "argument_id": 88, "moral_good_id": 3, "value_id_expl_id": 608, "argument_id_expl_id": 608, "moral_good_id_expl_id": 608}, "tableName": "directive_consequence", "targetLabel": "following petty rules true upheld"}
2025-03-30 21:07:06.536891+00	477	10	1	73	updateRecord	argument_conditional	{"id": 73, "diff": {"after": {"conditional_confidence": "0.10"}, "before": {"id": 73, "conditional_confidence": 0.1, "conditional_confidence_expl_id": 475}}, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "re-running calculation", "tableName": "argument_conditional", "targetLabel": 0.1}
2025-03-30 21:18:27.497966+00	479	9	1	54	updateRecord	argument	{"id": 54, "diff": {"after": {"title": "fear activists attacks"}, "before": {"id": 54, "title": "attacks by activists", "title_expl_id": 461}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "fear activists attacks"}
2025-03-30 21:38:19.3253+00	483	5	1	2	updateRecord	rule_change_request	{"id": 2, "diff": {"after": {"rule_id": 6, "response": "Judges can be asked to put various arguments on a scale\\nMultiple judges can provide a partial weighing and Apollo will combine them together\\nHow to ensure that the scales are the same?\\nFamiliar problem with correlate arguments and double counting"}, "before": {"id": 2, "rule_id": null, "response": "", "rule_id_expl_id": 481, "response_expl_id": 481}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "rule_change_request", "targetLabel": "summing up pros and cons more directly"}
2025-04-05 19:09:34.772694+00	555	7	1	12	updateRecord	moral_weight	{"id": 12, "diff": {"after": {"weight": "-2"}, "before": {"id": 12, "weight": -3, "weight_expl_id": 553}}, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight", "targetLabel": "(-2 / upheld) following petty rules"}
2025-04-05 19:10:57.707602+00	558	7	1	14	insertRecord	moral_weight	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 14, "label": "(15 / minute) free time", "weight": 15, "id_expl_id": 558, "moral_good_id": 2, "weight_expl_id": 558, "moral_good_id_expl_id": 558}, "tableName": "moral_weight", "targetLabel": "(15 / minute) free time"}
2025-04-05 19:10:58.87541+00	559	7	1	14	insertRecord	moral_weight_of_profile	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 14, "id_expl_id": 559, "profile_id": 1, "profile_id_expl_id": 559}, "tableName": "moral_weight_of_profile", "targetLabel": 1}
2025-04-05 19:13:25.915578+00	560	7	1	15	insertRecord	moral_weight	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 15, "label": "(-15 / misplaced item / m³) mess", "weight": -15, "id_expl_id": 560, "moral_good_id": 1, "weight_expl_id": 560, "moral_good_id_expl_id": 560}, "tableName": "moral_weight", "targetLabel": "(-15 / misplaced item / m³) mess"}
2025-04-06 19:32:37.45373+00	609	7	1	16	deleteById	directive_consequence	{"id": 16, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 16, "label": "following petty rules true upheld", "value_id": 25, "id_expl_id": 608, "argument_id": 88, "moral_good_id": 3, "value_id_expl_id": 608, "argument_id_expl_id": 608, "moral_good_id_expl_id": 608}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "following petty rules true upheld"}
2025-03-30 21:32:35.637582+00	481	9	1	2	insertRecord	rule_change_request	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 2, "link": "http://localhost:3000/statement?id=47", "text": "The question concerns a literal balance of pros and cons. It’s impossible to evaluate the likelihood of the outcome based on a single pro argument. They need to be compared directly and summed up.", "title": "summing up pros and cons more directly", "rule_id": null, "response": "", "id_expl_id": 481, "link_expl_id": 481, "text_expl_id": 481, "title_expl_id": 481, "rule_id_expl_id": 481, "response_expl_id": 481}, "tableName": "rule_change_request", "targetLabel": "summing up pros and cons more directly"}
2025-03-30 21:43:11.992993+00	484	9	1	59	insertRecord	argument_weight	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 59, "id_expl_id": 484, "weight_mode": 10, "weight_explanation": "Arbitrary mode due being the first argument to be judged. ", "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 484, "weight_explanation_expl_id": 484, "weight_lower_limit_expl_id": 484, "weight_upper_limit_expl_id": 484}, "tableName": "argument_weight", "targetLabel": 5}
2025-03-30 21:44:56.472958+00	485	9	1	51	insertRecord	argument_weight	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 51, "id_expl_id": 485, "weight_mode": 10, "weight_explanation": " seem comparable \\"professional reputation\\" argument and the relative weight will depend on person’s tolerance for risk", "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 485, "weight_explanation_expl_id": 485, "weight_lower_limit_expl_id": 485, "weight_upper_limit_expl_id": 485}, "tableName": "argument_weight", "targetLabel": 5}
2025-04-05 19:10:30.108479+00	556	7	1	13	insertRecord	moral_weight	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 13, "label": "(-4 / misplaced item / m³) mess", "weight": -4, "id_expl_id": 556, "moral_good_id": 1, "weight_expl_id": 556, "moral_good_id_expl_id": 556}, "tableName": "moral_weight", "targetLabel": "(-4 / misplaced item / m³) mess"}
2025-04-05 19:10:32.631345+00	557	7	1	13	insertRecord	moral_weight_of_profile	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 13, "id_expl_id": 557, "profile_id": 1, "profile_id_expl_id": 557}, "tableName": "moral_weight_of_profile", "targetLabel": 1}
2025-04-06 19:59:22.914461+00	610	9	1	89	insertExtRecord	argument	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 89, "pro": true, "title": "affordability of goods", "id_expl_id": 610, "pro_expl_id": 610, "statement_id": 68, "title_expl_id": 610, "argument_type_id": 4, "statement_id_expl_id": 610, "argument_type_id_expl_id": 610}, "extRecord": {"id": 89, "text": "Lifting restrictions would lower the prices gasoline, electricity, and heating.\\nThis reduction in energy costs would translate to lower costs for goods and services across the economy.\\nHence, US residents will be able to afford more.\\nHence, the standard of living of US residents will increase.", "id_expl_id": 610, "text_expl_id": 610}, "tableName": "argument", "targetLabel": "affordability of goods", "extTableName": "argument_explanation"}
2025-03-30 21:38:01.431088+00	482	5	1	6	insertRecord	rule	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 6, "name": "costs and benefits judgement", "text": "Judges input triangular distributions of weights. The system calculates the probability that the net sum of all weights is positive.", "example": "", "role_id": 1, "id_expl_id": 482, "name_expl_id": 482, "text_expl_id": 482, "example_expl_id": 482, "role_id_expl_id": 482}, "tableName": "rule", "targetLabel": "costs and benefits judgement"}
2025-03-30 21:46:51.225691+00	486	9	1	59	updateRecord	argument	{"id": 59, "diff": {"after": {"title": "professional reputation"}, "before": {"id": 59, "title": "contradicting consensus is a professional reputation and relationships risk", "title_expl_id": 285}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "professional reputation"}
2025-03-30 21:48:25.345163+00	487	9	1	53	updateExtRecord	argument	{"id": 53, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"after": {"title": "search for truth"}, "before": {"id": 53, "title": "the scientist would be motivated by their pursuit of truth", "title_expl_id": 189}}, "userExpl": "", "extRecord": {"after": {"text": "The scientist would be motivated by their pursuit of truth."}, "before": {"id": 53, "text": "Such climate scientist would make a contribution in search for truth.", "text_expl_id": 189}}, "tableName": "argument", "targetLabel": "search for truth", "extTableName": "argument_explanation"}
2025-03-30 21:57:11.132225+00	492	15	1	52	insertRecord	argument_weight	{"user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "record": {"id": 52, "id_expl_id": 492, "weight_mode": 15, "weight_explanation": "This is a very significant and practical concern. A lot wealthy corporations would love to have this promoted.", "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 492, "weight_explanation_expl_id": 492, "weight_lower_limit_expl_id": 492, "weight_upper_limit_expl_id": 492}, "tableName": "argument_weight", "targetLabel": 5}
2025-04-05 20:46:40.733405+00	561	7	1	15	insertRecord	moral_weight_of_person	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 15, "owner_id": 7, "id_expl_id": 561, "owner_id_expl_id": 561}, "tableName": "moral_weight_of_person", "targetLabel": 7}
2025-04-06 20:01:43.052319+00	611	9	1	90	insertExtRecord	argument	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 90, "pro": true, "title": "cut Russia's income", "id_expl_id": 611, "pro_expl_id": 611, "statement_id": 68, "title_expl_id": 611, "argument_type_id": 4, "statement_id_expl_id": 611, "argument_type_id_expl_id": 611}, "extRecord": {"id": 90, "text": "Lifting restrictions would allow US to supply more LNG to Europe.\\nThis will:\\n- reduce revenue that Russia will receive from its sale of natural gas and,\\n- reduce the influence that Russia has on Europe.\\nHence Russia’s ability to wage war against Ukraine will reduce.\\nHence people will be suffering less from war.", "id_expl_id": 611, "text_expl_id": 611}, "tableName": "argument", "targetLabel": "cut Russia's income", "extTableName": "argument_explanation"}
2025-04-06 20:06:19.525875+00	612	10	1	91	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 91, "pro": false, "title": "future crop yields", "id_expl_id": 612, "pro_expl_id": 612, "statement_id": 68, "title_expl_id": 612, "argument_type_id": 4, "statement_id_expl_id": 612, "argument_type_id_expl_id": 612}, "extRecord": {"id": 91, "text": "Lifting restrictions would increase fossil fuel extraction, production and consumption.\\nThis would lead to higher greenhouse gas emissions.\\nThis will speed up climate change.\\nIncrease in global average temperatures will cause net reduction in crop yields\\n1. Reduced crop yields will cause starvation\\n2. Reduced crop yields will cause mass migration\\nThis in turn will cause violent conflicts\\nThis in turn will cause an increase in suffering and deaths", "id_expl_id": 612, "text_expl_id": 612}, "tableName": "argument", "targetLabel": "future crop yields", "extTableName": "argument_explanation"}
2025-04-06 20:14:10.726906+00	613	10	1	5	insertRecord	unit	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 5, "name": "SWLS change sum", "id_expl_id": 613, "column_type": "integer", "name_expl_id": 613, "column_type_expl_id": 613}, "tableName": "unit", "targetLabel": "SWLS change sum"}
2025-04-06 20:14:33.759307+00	614	10	1	4	updateRecord	moral_good	{"id": 4, "diff": {"after": {"unit_id": 5}, "before": {"id": 4, "unit_id": 4, "unit_id_expl_id": 523}}, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_good", "targetLabel": "standard of living (SWLS change sum)"}
2025-03-30 21:49:30.952506+00	488	9	1	53	insertRecord	argument_weight	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 53, "id_expl_id": 488, "weight_mode": 5, "weight_explanation": "That sounds like something that a scientist would value, but perhaps more down to earth concerns of reputations, relationships and fame would outweigh it ", "weight_lower_limit": 0, "weight_upper_limit": 20, "weight_mode_expl_id": 488, "weight_explanation_expl_id": 488, "weight_lower_limit_expl_id": 488, "weight_upper_limit_expl_id": 488}, "tableName": "argument_weight", "targetLabel": 0}
2025-04-05 21:36:24.705743+00	562	7	1	16	insertRecord	moral_weight	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 16, "label": "(10 / minute) free time", "weight": 10, "id_expl_id": 562, "moral_good_id": 2, "weight_expl_id": 562, "moral_good_id_expl_id": 562}, "tableName": "moral_weight", "targetLabel": "(10 / minute) free time"}
2025-04-06 20:16:21.260573+00	615	10	1	5	updateRecord	unit	{"id": 5, "diff": {"after": {"description": "Expected change on the Satisfaction With Life Scale summed up for all of the people affected."}, "before": {"id": 5, "description": "", "description_expl_id": null}}, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "", "tableName": "unit", "targetLabel": "SWLS change sum"}
2025-03-30 21:50:39.012364+00	489	9	1	60	insertRecord	argument_weight	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 60, "id_expl_id": 489, "weight_mode": 10, "weight_explanation": "This is more easily compared to \\"professional reputation\\". Loosing funding could amount to loosing a job which is a big hassle. It seem as significant.", "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 489, "weight_explanation_expl_id": 489, "weight_lower_limit_expl_id": 489, "weight_upper_limit_expl_id": 489}, "tableName": "argument_weight", "targetLabel": 5}
2025-04-05 21:36:28.874468+00	563	7	1	16	insertRecord	moral_weight_of_person	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 16, "owner_id": 7, "id_expl_id": 563, "owner_id_expl_id": 563}, "tableName": "moral_weight_of_person", "targetLabel": 7}
2025-04-06 20:18:59.922525+00	616	10	1	6	insertRecord	unit	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 6, "name": "expected count change", "id_expl_id": 616, "column_type": "integer", "description": "- combines count and probability into a single measure\\n- Uses of probabilistic expectation in moral calculations\\n    - https://aeon.co/essays/how-to-solve-moral-problems-with-formal-logic-and-probability", "name_expl_id": 616, "column_type_expl_id": 616, "description_expl_id": 616}, "tableName": "unit", "targetLabel": "expected count change"}
2025-04-06 20:25:52.20767+00	620	9	1	9	insertRecord	moral_weight_of_person	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 9, "label": "(-100000 / expected count change) death", "weight": -100000, "owner_id": 9, "id_expl_id": 620, "moral_good_id": 5, "weight_expl_id": 620, "owner_id_expl_id": 620, "moral_good_id_expl_id": 620}, "tableName": "moral_weight_of_person", "targetLabel": "(-100000 / expected count change) death"}
2025-03-30 21:53:28.425849+00	490	15	1	61	insertRecord	argument_weight	{"user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "record": {"id": 61, "id_expl_id": 490, "weight_mode": 7, "weight_explanation": "Neither overly materialistic nor idealistic concern. ", "weight_lower_limit": 5, "weight_upper_limit": 10, "weight_mode_expl_id": 490, "weight_explanation_expl_id": 490, "weight_lower_limit_expl_id": 490, "weight_upper_limit_expl_id": 490}, "tableName": "argument_weight", "targetLabel": 5}
2025-03-30 21:55:21.490429+00	491	15	1	54	insertRecord	argument_weight	{"user": {"id": 15, "name": "Toro", "auth_role": "invited"}, "record": {"id": 54, "id_expl_id": 491, "weight_mode": 15, "weight_explanation": "Depending on what attacks they are. It could be very impactful. People value their safety very much.", "weight_lower_limit": 10, "weight_upper_limit": 25, "weight_mode_expl_id": 491, "weight_explanation_expl_id": 491, "weight_lower_limit_expl_id": 491, "weight_upper_limit_expl_id": 491}, "tableName": "argument_weight", "targetLabel": 10}
2025-03-30 21:57:11.160561+00	493	\N	1	47	attemptAggregateArguments	statement	{"diff": {"after": {"decided": true, "confidence": 0.069}, "before": {"id": 47, "decided": false, "confidence": 0.5, "decided_expl_id": 184, "confidence_expl_id": 184}}, "statement": {"id": 47, "text": "A scientist will have a stronger incentive to publish and popularise his model if it turns out that it fits observations well and contradicts climate change.", "id_expl_id": 184, "text_expl_id": 480}, "triggerLabel": "insert of argument weight", "triggerExplId": 492, "weightedArguments": [{"id": 59, "pro": false, "title": "professional reputation", "id_expl_id": 484, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 484, "weight_explanation_expl_id": 484, "weight_lower_limit_expl_id": 484, "weight_upper_limit_expl_id": 484}, {"id": 51, "pro": true, "title": "they will gain fame and recognition", "id_expl_id": 485, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 485, "weight_explanation_expl_id": 485, "weight_lower_limit_expl_id": 485, "weight_upper_limit_expl_id": 485}, {"id": 53, "pro": true, "title": "search for truth", "id_expl_id": 488, "weight_mode": 5, "weight_lower_limit": 0, "weight_upper_limit": 20, "weight_mode_expl_id": 488, "weight_explanation_expl_id": 488, "weight_lower_limit_expl_id": 488, "weight_upper_limit_expl_id": 488}, {"id": 60, "pro": false, "title": "risk to funding", "id_expl_id": 489, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 489, "weight_explanation_expl_id": 489, "weight_lower_limit_expl_id": 489, "weight_upper_limit_expl_id": 489}, {"id": 61, "pro": false, "title": "doubt & ideological reservations", "id_expl_id": 490, "weight_mode": 7, "weight_lower_limit": 5, "weight_upper_limit": 10, "weight_mode_expl_id": 490, "weight_explanation_expl_id": 490, "weight_lower_limit_expl_id": 490, "weight_upper_limit_expl_id": 490}, {"id": 54, "pro": false, "title": "fear activists attacks", "id_expl_id": 491, "weight_mode": 15, "weight_lower_limit": 10, "weight_upper_limit": 25, "weight_mode_expl_id": 491, "weight_explanation_expl_id": 491, "weight_lower_limit_expl_id": 491, "weight_upper_limit_expl_id": 491}, {"id": 52, "pro": true, "title": "Financial support from Climate Change critics", "id_expl_id": 492, "weight_mode": 15, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 492, "weight_explanation_expl_id": 492, "weight_lower_limit_expl_id": 492, "weight_upper_limit_expl_id": 492}]}
2025-04-05 21:37:48.164518+00	564	7	1	17	insertRecord	moral_weight	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 17, "label": "(5 / upheld) following petty rules", "weight": 5, "id_expl_id": 564, "moral_good_id": 3, "weight_expl_id": 564, "moral_good_id_expl_id": 564}, "tableName": "moral_weight", "targetLabel": "(5 / upheld) following petty rules"}
2025-04-05 21:37:49.461608+00	565	7	1	17	insertRecord	moral_weight_of_person	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 17, "owner_id": 7, "id_expl_id": 565, "owner_id_expl_id": 565}, "tableName": "moral_weight_of_person", "targetLabel": 7}
2025-04-06 20:19:12.49794+00	617	10	1	5	insertRecord	moral_good	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 5, "name": "death", "label": "death (expected count change)", "unit_id": 6, "id_expl_id": 617, "name_expl_id": 617, "unit_id_expl_id": 617}, "tableName": "moral_good", "targetLabel": "death (expected count change)"}
2025-03-30 22:09:49.512602+00	494	3	1	47	updateRecord	statement	{"id": 47, "diff": {"after": {"text": "У ученого будет достаточно стимулов чтобы опубликовать и популяризировать свою модель, если окажется, что она хорошо согласуется с наблюдениями и противоречит изменениям климата."}, "before": {"id": 47, "text": "У ученого будет больше стимулов публиковать и популяризировать свою модель, если окажется, что она хорошо согласуется с наблюдениями и противоречит изменениям климата.", "text_expl_id": 480}}, "user": {"id": 3, "name": "Bob", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(7%) У ученого будет достаточно стимулов чтобы опубликовать и популяризировать свою модель, если окажется, что она хорошо согласуется с наблюдениями и противоречит изменениям климата."}
2025-03-31 07:13:14.924115+00	495	9	1	2	insertRecord	deed	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 2, "text": "support lifting restrictions on US fossil fuel energy production", "id_expl_id": 495, "text_expl_id": 495}, "tableName": "deed", "targetLabel": "support lifting restrictions on US fossil fuel energy production"}
2025-03-31 07:13:26.985891+00	496	9	1	5	insertRecord	directive	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 5, "label": ", support lifting restrictions on US fossil fuel energy production", "deed_id": 2, "featured": false, "id_expl_id": 496, "deed_id_expl_id": 496, "featured_expl_id": 496}, "tableName": "directive", "targetLabel": ", support lifting restrictions on US fossil fuel energy production"}
2025-03-31 07:14:42.208844+00	498	9	1	5	insertCrossRecord	directive	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "cross": {"id": 14, "label": "climate change", "tableName": "tag"}, "record": {"tag_id": 14, "directive_id": 5, "tag_id_expl_id": 498, "directive_id_expl_id": 498}, "target": {"id": 5, "label": ", support lifting restrictions on US fossil fuel energy production", "tableName": "directive"}}
2025-03-31 07:29:58.197037+00	499	9	1	3	insertRecord	person_category	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 3, "name": "US citizen", "id_expl_id": 499, "name_expl_id": 499}, "tableName": "person_category", "targetLabel": "US citizen"}
2025-03-31 07:30:00.58194+00	500	9	1	4	insertRecord	directive_scope	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 4, "label": "(+) US citizen", "include": true, "id_expl_id": 500, "directive_id": 5, "include_expl_id": 500, "person_category_id": 3, "directive_id_expl_id": 500, "person_category_id_expl_id": 500}, "tableName": "directive_scope", "targetLabel": "(+) US citizen"}
2025-03-31 07:40:57.327677+00	501	9	1	28	insertCrossRecord	statement	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "cross": {"id": 14, "label": "climate change", "tableName": "tag"}, "record": {"tag_id": 14, "statement_id": 28, "tag_id_expl_id": 501, "statement_id_expl_id": 501}, "target": {"id": 28, "label": "(?) climate change is anthropogenic", "tableName": "statement"}}
2025-03-31 18:36:00.223049+00	502	5	1	10	insertRecord	invite	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 10, "code": "trxdUExQ", "link": "http://localhost:3000/join?code=trxdUExQ", "owner_id": 5, "person_id": null, "id_expl_id": 502, "code_expl_id": 502, "owner_id_expl_id": 502, "person_id_expl_id": 502}, "tableName": "invite", "targetLabel": "trxdUExQ"}
2025-04-05 21:42:11.432548+00	566	6	1	18	insertRecord	moral_weight	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 18, "label": "(-3 / upheld) following petty rules", "weight": -3, "id_expl_id": 566, "moral_good_id": 3, "weight_expl_id": 566, "moral_good_id_expl_id": 566}, "tableName": "moral_weight", "targetLabel": "(-3 / upheld) following petty rules"}
2025-04-05 21:42:37.217731+00	569	6	1	19	insertRecord	moral_weight_of_person	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 19, "owner_id": 6, "id_expl_id": 569, "owner_id_expl_id": 569}, "tableName": "moral_weight_of_person", "targetLabel": 6}
2025-04-05 21:45:02.842634+00	573	6	1	21	insertRecord	moral_weight	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 21, "label": "(2 / upheld) following petty rules", "weight": 2, "id_expl_id": 573, "moral_good_id": 3, "weight_expl_id": 573, "moral_good_id_expl_id": 573}, "tableName": "moral_weight", "targetLabel": "(2 / upheld) following petty rules"}
2025-03-31 19:08:13.998651+00	505	18	1	62	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 62, "text": "Apollo will make lives of at least 100 million people at least 10% better.", "label": "(?) Apollo will make lives of at least 100 million people at least 10% better.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 505, "text_expl_id": 505, "decided_expl_id": 505, "featured_expl_id": 505, "confidence_expl_id": 505, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 505}, "tableName": "statement", "targetLabel": "(?) Apollo will make lives of at least 100 million people at least 10% better."}
2025-03-31 19:25:10.282851+00	506	18	1	82	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 82, "pro": true, "title": "following wise authority", "id_expl_id": 506, "pro_expl_id": 506, "statement_id": 62, "title_expl_id": 506, "argument_type_id": 4, "statement_id_expl_id": 506, "argument_type_id_expl_id": 506}, "extRecord": {"id": 82, "text": "Apollo will become wise.\\nApollo will be recognised as an epistemic authority.\\nMany will follow to the wise advice of Apollo.\\nTheir lives will improve significantly.\\n", "id_expl_id": 506, "text_expl_id": 506}, "tableName": "argument", "targetLabel": "following wise authority", "extTableName": "argument_explanation"}
2025-04-05 21:42:13.608103+00	567	6	1	18	insertRecord	moral_weight_of_person	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 18, "owner_id": 6, "id_expl_id": 567, "owner_id_expl_id": 567}, "tableName": "moral_weight_of_person", "targetLabel": 6}
2025-04-05 21:43:06.620835+00	570	6	1	20	insertRecord	moral_weight	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 20, "label": "(30 / minute) free time", "weight": 30, "id_expl_id": 570, "moral_good_id": 2, "weight_expl_id": 570, "moral_good_id_expl_id": 570}, "tableName": "moral_weight", "targetLabel": "(30 / minute) free time"}
2025-04-05 21:45:25.622735+00	575	6	1	22	insertRecord	moral_weight	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 22, "label": "(4 / misplaced item / m³) mess", "weight": 4, "id_expl_id": 575, "moral_good_id": 1, "weight_expl_id": 575, "moral_good_id_expl_id": 575}, "tableName": "moral_weight", "targetLabel": "(4 / misplaced item / m³) mess"}
2025-04-05 21:45:46.59487+00	578	6	1	23	insertRecord	moral_weight_of_profile	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 23, "id_expl_id": 578, "profile_id": 2, "profile_id_expl_id": 578}, "tableName": "moral_weight_of_profile", "targetLabel": 2}
2025-04-06 20:23:44.859816+00	618	9	1	2	insertRecord	research_note	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 2, "text": "ChatGPT Prompt\\n\\nPlease build a causal influence chain from lifting restrictions on USA energy production to changes in life satisfaction of US residents. Suggest how each link in this causal change can be quantified to create an overall estimate of the effect of the whole chain.\\n\\nChatGPT answer\\n\\nTo estimate the cumulative effect, we need to quantify each link and then trace the impact through the chain.\\n\\n**Step 1-2: Increase in Energy Production**\\n\\n**Estimate the percentage increase in energy production.**\\n\\n**Example:** A 10% increase in oil and natural gas production.\\n\\n**Step 3-4: Effect on Energy Prices**\\n\\n**Calculate the expected decrease in energy prices using price elasticity.**\\n\\n**Example:**\\n\\n- Price elasticity of demand (Ed): -0.2\\n- Price elasticity of supply (Es): 0.3\\n- **Formula:**\\n    - Percentage change in price = Percentage change in quantity supplied / (Es - Ed)\\n    - Plug in numbers: (10%) / (0.3 - (-0.2)) = 10% / 0.5 = 20% decrease in price.\\n\\n**Step 5: Reduction in Energy Costs**\\n\\n**Calculate savings for households and businesses.**\\n\\n**Households:**\\n\\n- Average annual energy expenditure per household: $2,000\\n- Savings per household: 20% of $2,000 = $400\\n- Total households: 120 million\\n- Total household savings: $400 * 120 million = $48 billion\\n\\n**Businesses:**\\n\\n- Aggregate energy expenditures and calculate 20% savings.\\n\\n**Step 6: Increase in Disposable Income**\\n\\n**Total increase in disposable income:**\\n\\n- From households: $48 billion\\n- From businesses (assuming part of savings translates to higher wages or lower prices).\\n\\n**Step 7: Increase in Consumption and Savings**\\n\\n**Assuming MPC is 0.9:**\\n\\n- Additional consumption: $48 billion * 0.9 = $43.2 billion\\n- Additional savings: $48 billion * 0.1 = $4.8 billion\\n\\n**Step 8: Impact on GDP and Employment**\\n\\n**GDP Impact:**\\n\\n- Apply fiscal multiplier (e.g., 1.5): $43.2 billion * 1.5 = $64.8 billion increase in GDP\\n\\n**Job Creation:**\\n\\n- Use employment multiplier (e.g., 10,000 jobs per $1 billion GDP growth): 10,000 * 64.8 = 648,000 jobs\\n\\n**Step 9: Improved Material Living Standards**\\n\\n**Increase in average income:**\\n\\n- Distribute GDP increase across the population.\\n\\n**Reduction in unemployment rate:**\\n\\n- Calculate the percentage decrease based on new jobs created.\\n\\n**Step 10: Changes in Life Satisfaction**\\n\\n**Use coefficient from literature:**\\n\\n- **Easterlin Paradox:** Life satisfaction increases with income but at a diminishing rate.\\n- **Example Coefficient:** A 10% increase in income leads to a 0.1 point increase on a 10-point life satisfaction scale.\\n\\n**Calculate expected change:**\\n\\n- Average income increase: Assume 5% increase.\\n- Expected life satisfaction increase: 5% * 0.01 = 0.05 points on a 10-point scale.\\n\\n- Expected life satisfaction increase: 5% * 0.01 = 0.05 points on a 10-point scale.\\n\\nAdds final calculations\\n\\nExpected change on the Satisfaction With Life Scale summed up for all of the people affected. =\\n\\n= scale conversion * USA population * satisfaction increase\\n\\n= 35 / 10 * 345,426,571 * 0.05\\n\\n= 60449650", "title": "Trying to calculate the impact of lifting restrictions on life satisfaction with ChatGPT", "id_expl_id": 618, "statement_id": 68, "text_expl_id": 618, "title_expl_id": 618, "statement_id_expl_id": 618}, "tableName": "research_note", "targetLabel": "Trying to calculate the impact of lifting restrictions on life satisfaction with ChatGPT"}
2025-03-31 19:32:07.932049+00	507	18	1	83	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 83, "pro": true, "title": "conflict resolution", "id_expl_id": 507, "pro_expl_id": 507, "statement_id": 62, "title_expl_id": 507, "argument_type_id": 4, "statement_id_expl_id": 507, "argument_type_id_expl_id": 507}, "extRecord": {"id": 83, "text": "Apollo will become wise.\\nApollo will be recognised as an epistemic authority.\\nMany conflicts will be resolved by deferring to Apollo's judgement.\\nNegative effects of conflicts will be replaced by positive effects of collaboration. ", "id_expl_id": 507, "text_expl_id": 507}, "tableName": "argument", "targetLabel": "conflict resolution", "extTableName": "argument_explanation"}
2025-03-31 19:33:01.739983+00	508	18	1	63	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 63, "text": "Apollo will become wise", "label": "(?) Apollo will become wise", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 508, "text_expl_id": 508, "decided_expl_id": 508, "featured_expl_id": 508, "confidence_expl_id": 508, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 508}, "tableName": "statement", "targetLabel": "(?) Apollo will become wise"}
2025-03-31 19:33:02.955562+00	509	18	1	51	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 51, "label": "(?) Apollo will become wise", "id_expl_id": 509, "argument_id": 82, "statement_id": 63, "argument_id_expl_id": 509, "critical_question_id": 1, "statement_id_expl_id": 509, "critical_question_id_expl_id": 509}, "tableName": "critical_statement", "targetLabel": "(?) Apollo will become wise"}
2025-03-31 19:33:11.301393+00	510	18	1	52	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 52, "label": "(?) Apollo will become wise", "id_expl_id": 510, "argument_id": 83, "statement_id": 63, "argument_id_expl_id": 510, "critical_question_id": 1, "statement_id_expl_id": 510, "critical_question_id_expl_id": 510}, "tableName": "critical_statement", "targetLabel": "(?) Apollo will become wise"}
2025-03-31 19:48:29.017493+00	511	18	1	84	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 84, "pro": true, "title": "large scale thinker", "id_expl_id": 511, "pro_expl_id": 511, "statement_id": 63, "title_expl_id": 511, "argument_type_id": 4, "statement_id_expl_id": 511, "argument_type_id_expl_id": 511}, "extRecord": {"id": 84, "text": "The functioning of Apollo will involve a large number of participants. It will be able to process a lot more evidence than a single individual. Critical thinking of individual participants will be combined to produce exceptional critical thinking of Apollo.\\n", "id_expl_id": 511, "text_expl_id": 511}, "tableName": "argument", "targetLabel": "large scale thinker", "extTableName": "argument_explanation"}
2025-03-31 19:50:58.115127+00	513	18	1	62	insertCrossRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 15, "label": "Apollo", "tableName": "tag"}, "record": {"tag_id": 15, "statement_id": 62, "tag_id_expl_id": 513, "statement_id_expl_id": 513}, "target": {"id": 62, "label": "(?) Apollo will make lives of at least 100 million people at least 10% better.", "tableName": "statement"}}
2025-03-31 20:00:08.799993+00	515	18	1	84	updateExtRecord	argument	{"id": 84, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"text": "The functioning of Apollo will involve a large number of participants. It will be able to process a lot more evidence than a single individual. Apollo will teach and provide critical thinking tools to it's participants. Their critical thinking will be combined to produce exceptional critical thinking of Apollo.\\n"}, "before": {"id": 84, "text": "The functioning of Apollo will involve a large number of participants. It will be able to process a lot more evidence than a single individual. Critical thinking of individual participants will be combined to produce exceptional critical thinking of Apollo.\\n", "text_expl_id": 511}}, "tableName": "argument", "targetLabel": "large scale thinker", "extTableName": "argument_explanation"}
2025-04-09 08:18:56.072588+00	637	5	1	16	deleteExtById	person	{"id": 16, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 16, "name": "Goro", "language": "english", "id_expl_id": 64, "auth_role_id": 2, "name_expl_id": 64, "language_expl_id": null, "auth_role_id_expl_id": 64}, "userExpl": "", "tableName": "person", "targetLabel": "Goro"}
2025-11-30 15:19:57.672437+00	1747	26	1	200	insertCrossRecords	statement	\N
2025-03-31 20:04:35.975165+00	516	18	1	84	updateExtRecord	argument	{"id": 84, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"text": "The functioning of Apollo will involve a large number of participants.\\nIt will be able to process a lot more evidence than a single individual.\\nApollo will teach and provide critical thinking tools to its participants.\\nTheir critical thinking will be combined to produce exceptional critical thinking of Apollo."}, "before": {"id": 84, "text": "The functioning of Apollo will involve a large number of participants. It will be able to process a lot more evidence than a single individual. Apollo will teach and provide critical thinking tools to it's participants. Their critical thinking will be combined to produce exceptional critical thinking of Apollo.\\n", "text_expl_id": 515}}, "tableName": "argument", "targetLabel": "large scale thinker", "extTableName": "argument_explanation"}
2025-04-05 21:42:35.797087+00	568	6	1	19	insertRecord	moral_weight	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 19, "label": "(-5 / misplaced item / m³) mess", "weight": -5, "id_expl_id": 568, "moral_good_id": 1, "weight_expl_id": 568, "moral_good_id_expl_id": 568}, "tableName": "moral_weight", "targetLabel": "(-5 / misplaced item / m³) mess"}
2025-04-05 21:45:27.746121+00	576	6	1	22	insertRecord	moral_weight_of_profile	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 22, "id_expl_id": 576, "profile_id": 2, "profile_id_expl_id": 576}, "tableName": "moral_weight_of_profile", "targetLabel": 2}
2025-04-06 20:25:33.15922+00	619	9	1	8	insertRecord	moral_weight_of_person	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 8, "label": "(1 / SWLS change sum) standard of living", "weight": 1, "owner_id": 9, "id_expl_id": 619, "moral_good_id": 4, "weight_expl_id": 619, "owner_id_expl_id": 619, "moral_good_id_expl_id": 619}, "tableName": "moral_weight_of_person", "targetLabel": "(1 / SWLS change sum) standard of living"}
2025-03-31 19:53:30.165005+00	514	18	1	62	updateRecord	statement	{"id": 62, "diff": {"after": {"text": "Apollo will make lives of at least 100 million people at least 10% better on average."}, "before": {"id": 62, "text": "Apollo will make lives of at least 100 million people at least 10% better.", "text_expl_id": 505}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "One person gaining +15% and another +5% should count as two rather than one.", "tableName": "statement", "targetLabel": "(?) Apollo will make lives of at least 100 million people at least 10% better on average."}
2025-03-31 22:21:54.7498+00	517	9	1	64	insertRecord	statement	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 64, "text": "test statement", "label": "(?) test statement", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 517, "text_expl_id": 517, "decided_expl_id": 517, "featured_expl_id": 517, "confidence_expl_id": 517, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 517}, "tableName": "statement", "targetLabel": "(?) test statement"}
2025-03-31 22:22:10.772809+00	518	9	1	64	deleteExtById	statement	{"id": 64, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 64, "text": "test statement", "label": "(?) test statement", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 517, "text_expl_id": 517, "decided_expl_id": 517, "featured_expl_id": 517, "confidence_expl_id": 517, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 517}, "userExpl": "it was a test", "tableName": "statement", "targetLabel": "(?) test statement"}
2025-03-31 23:20:13.14218+00	520	9	1	14	updateRecord	tag	{"id": 14, "diff": {"after": {"name": "climate"}, "before": {"id": 14, "name": "climate change", "name_expl_id": 497}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "two words were too long so that they stuck out", "tableName": "tag", "targetLabel": "climate"}
2025-03-31 23:23:11.717899+00	521	9	1	65	insertRecord	statement	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 65, "text": "Lifting restrictions on US fossil fuel energy production will increase the standard of living of US residents.", "label": "(?) Lifting restrictions on US fossil fuel energy production will increase the standard of living of US residents.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 521, "text_expl_id": 521, "decided_expl_id": 521, "featured_expl_id": 521, "confidence_expl_id": 521, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 521}, "tableName": "statement", "targetLabel": "(?) Lifting restrictions on US fossil fuel energy production will increase the standard of living of US residents."}
2025-03-31 23:24:51.079106+00	523	9	1	4	insertRecord	moral_good	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 4, "name": "standard of living", "label": "standard of living (percent)", "unit_id": 4, "id_expl_id": 523, "name_expl_id": 523, "unit_id_expl_id": 523}, "tableName": "moral_good", "targetLabel": "standard of living (percent)"}
2025-04-05 21:43:08.371221+00	571	6	1	20	insertRecord	moral_weight_of_person	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 20, "owner_id": 6, "id_expl_id": 571, "owner_id_expl_id": 571}, "tableName": "moral_weight_of_person", "targetLabel": 6}
2025-04-05 21:44:44.042197+00	572	6	1	2	insertRecord	moral_weight_profile	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 2, "name": "opposite someone", "id_expl_id": 572, "description": "someone with the opposite moral weights", "name_expl_id": 572, "description_expl_id": 572}, "tableName": "moral_weight_profile", "targetLabel": "opposite someone"}
2025-04-07 08:24:40.363274+00	621	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "ukrainian"}, "before": {"id": 2, "language": "english", "language_expl_id": 340}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Alice"}
2025-03-31 23:24:32.2345+00	522	9	1	4	insertRecord	unit	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 4, "name": "percent", "id_expl_id": 522, "column_type": "integer", "name_expl_id": 522, "column_type_expl_id": 522}, "tableName": "unit", "targetLabel": "percent"}
2025-04-05 21:45:05.318351+00	574	6	1	21	insertRecord	moral_weight_of_profile	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 21, "id_expl_id": 574, "profile_id": 2, "profile_id_expl_id": 574}, "tableName": "moral_weight_of_profile", "targetLabel": 2}
2025-04-05 21:45:45.491428+00	577	6	1	23	insertRecord	moral_weight	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 23, "label": "(-15 / minute) free time", "weight": -15, "id_expl_id": 577, "moral_good_id": 2, "weight_expl_id": 577, "moral_good_id_expl_id": 577}, "tableName": "moral_weight", "targetLabel": "(-15 / minute) free time"}
2025-04-07 18:51:32.839533+00	622	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "english"}, "before": {"id": 2, "language": "ukrainian", "language_expl_id": 621}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Аліса"}
2025-04-07 19:16:47.964454+00	623	2	1	2	updateRecord	person	{"id": 2, "diff": {"after": {"language": "russian"}, "before": {"id": 2, "language": "english", "language_expl_id": 622}}, "user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Alice"}
2025-04-07 19:22:46.96222+00	626	19	1	19	updateRecord	person	{"id": 19, "diff": {"after": {"language": "english"}, "before": {"id": 19, "language": "ukrainian", "language_expl_id": 625}}, "user": {"id": 19, "name": "Asha", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Аша"}
2025-04-07 19:24:28.889433+00	627	19	1	19	updateRecord	person	{"id": 19, "diff": {"after": {"language": "ukrainian"}, "before": {"id": 19, "language": "english", "language_expl_id": 626}}, "user": {"id": 19, "name": "Asha", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Asha"}
2025-03-31 23:27:14.856962+00	524	9	1	65	insertRecord	directive_consequence	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 65, "label": "standard of living 6 percent", "value_id": 7, "id_expl_id": 524, "directive_id": 5, "moral_good_id": 4, "value_id_expl_id": 524, "directive_id_expl_id": 524, "moral_good_id_expl_id": 524}, "tableName": "directive_consequence", "targetLabel": "standard of living 6 percent"}
2025-04-06 09:43:22.553181+00	579	6	1	20	deleteById	moral_weight_of_person	{"id": 20, "user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 20, "label": "(30 / minute) free time", "weight": 30, "owner_id": 6, "id_expl_id": 571, "moral_good_id": 2, "weight_expl_id": 570, "owner_id_expl_id": 571, "moral_good_id_expl_id": 570}, "userExpl": "testing deletion", "tableName": "moral_weight_of_person", "targetLabel": "(30 / minute) free time"}
2025-04-07 19:17:45.485667+00	624	2	1	11	insertRecord	invite	{"user": {"id": 2, "name": "Alice", "auth_role": "invited"}, "record": {"id": 11, "code": "vFPhkoK8", "link": "http://localhost:3000/join?code=vFPhkoK8", "owner_id": 2, "person_id": null, "id_expl_id": 624, "code_expl_id": 624, "owner_id_expl_id": 624, "person_id_expl_id": 624}, "tableName": "invite", "targetLabel": "vFPhkoK8"}
2025-04-04 12:18:14.654478+00	525	5	1	3	insertRecord	argument_aggregation_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 3, "name": "normaive", "id_expl_id": 525, "description": "The statement is normative. Specific consequences from each argument are aggregated together before weighing. ", "name_expl_id": 525, "description_expl_id": 525}, "tableName": "argument_aggregation_type", "targetLabel": "normaive"}
2025-04-04 16:09:43.684479+00	526	9	1	3	insertRecord	deed	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 3, "text": "recycle rubbish", "id_expl_id": 526, "text_expl_id": 526}, "tableName": "deed", "targetLabel": "recycle rubbish"}
2025-04-06 09:43:40.248836+00	580	6	1	6	insertRecord	moral_weight_of_person	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 6, "label": "(30 / minute) free time", "weight": 30, "owner_id": 6, "id_expl_id": 580, "moral_good_id": 2, "weight_expl_id": 580, "owner_id_expl_id": 580, "moral_good_id_expl_id": 580}, "tableName": "moral_weight_of_person", "targetLabel": "(30 / minute) free time"}
2025-04-07 19:20:59.068745+00	625	2	1	19	join	person	{"person": {"id": 19, "name": "Asha"}, "inviter": {"id": 2, "name": "Alice", "auth_role": "invited"}}
2025-04-04 16:22:49.318464+00	527	9	1	66	insertExtRecord	statement	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 66, "text": "", "label": "(?) ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 527, "text_expl_id": 527, "decided_expl_id": 527, "featured_expl_id": 527, "confidence_expl_id": 527, "argument_aggregation_type_id": 3, "argument_aggregation_type_name": "normaive", "argument_aggregation_type_id_expl_id": 527}, "extRecord": {"id": 66, "deed_id": 3, "id_expl_id": 527, "deed_id_expl_id": 527}, "tableName": "statement", "targetLabel": "(?) ", "extTableName": "directive"}
2025-04-04 17:00:21.635407+00	528	9	1	5	insertRecord	directive_scope	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 5, "label": "(+) block of flats resident", "include": true, "id_expl_id": 528, "directive_id": 66, "include_expl_id": 528, "person_category_id": 1, "directive_id_expl_id": 528, "person_category_id_expl_id": 528}, "tableName": "directive_scope", "targetLabel": "(+) block of flats resident"}
2025-04-06 12:10:11.678583+00	581	6	1	6	deleteById	moral_weight_of_person	{"id": 6, "user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 6, "label": "(30 / minute) free time", "weight": 30, "owner_id": 6, "id_expl_id": 580, "moral_good_id": 2, "weight_expl_id": 580, "owner_id_expl_id": 580, "moral_good_id_expl_id": 580}, "userExpl": "test", "tableName": "moral_weight_of_person", "targetLabel": "(30 / minute) free time"}
2025-04-06 12:10:31.096607+00	582	6	1	7	insertRecord	moral_weight_of_person	{"user": {"id": 6, "name": "John Upington", "auth_role": "invited"}, "record": {"id": 7, "label": "(30 / minute) free time", "weight": 30, "owner_id": 6, "id_expl_id": 582, "moral_good_id": 2, "weight_expl_id": 582, "owner_id_expl_id": 582, "moral_good_id_expl_id": 582}, "tableName": "moral_weight_of_person", "targetLabel": "(30 / minute) free time"}
2025-04-07 19:26:12.650435+00	628	19	1	19	updateRecord	person	{"id": 19, "diff": {"after": {"language": "english"}, "before": {"id": 19, "language": "ukrainian", "language_expl_id": 627}}, "user": {"id": 19, "name": "Asha", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Аша"}
2025-04-04 17:04:36.859022+00	529	9	1	66	updateExtRecord	statement	{"id": 66, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "just testing", "extRecord": {"after": {"deed_id": 1}, "before": {"id": 66, "deed_id": 3, "deed_id_expl_id": 527}}, "tableName": "statement", "targetLabel": "(?) ", "extTableName": "directive"}
2025-04-04 17:04:48.936209+00	530	9	1	66	updateExtRecord	statement	{"id": 66, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"deed_id": 3}, "before": {"id": 66, "deed_id": 1, "deed_id_expl_id": 529}}, "tableName": "statement", "targetLabel": "(?) ", "extTableName": "directive"}
2025-04-04 17:12:15.966056+00	531	9	1	16	insertRecord	tag	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 16, "name": "test", "id_expl_id": 531, "name_expl_id": 531}, "tableName": "tag", "targetLabel": "test"}
2025-04-04 17:12:26.266816+00	532	9	1	66	insertCrossRecord	statement	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "cross": {"id": 16, "label": "test", "tableName": "tag"}, "record": {"tag_id": 16, "statement_id": 66, "tag_id_expl_id": 532, "statement_id_expl_id": 532}, "target": {"id": 66, "label": "(?) ", "tableName": "statement"}}
2025-04-06 18:26:27.753738+00	583	7	1	4	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 4, "label": "free time 16 minute", "value_id": 17, "id_expl_id": 583, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 583, "argument_id_expl_id": 583, "moral_good_id_expl_id": 583}, "tableName": "directive_consequence", "targetLabel": "free time 16 minute"}
2025-04-06 18:33:31.676615+00	589	7	1	7	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 7, "label": "free time 22 minute", "value_id": 23, "id_expl_id": 589, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 589, "argument_id_expl_id": 589, "moral_good_id_expl_id": 589}, "tableName": "directive_consequence", "targetLabel": "free time 22 minute"}
2025-04-06 18:52:23.338875+00	596	7	1	14	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 14, "label": "free time -1000 minute", "value_id": 36, "id_expl_id": 596, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 596, "argument_id_expl_id": 596, "moral_good_id_expl_id": 596}, "tableName": "directive_consequence", "targetLabel": "free time -1000 minute"}
2025-04-06 18:54:51.9926+00	597	7	1	13	deleteById	directive_consequence	{"id": 13, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 13, "label": "free time 34 minute", "value_id": 35, "id_expl_id": 595, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 595, "argument_id_expl_id": 595, "moral_good_id_expl_id": 595}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time 34 minute"}
2025-04-06 18:55:58.688425+00	599	7	1	8	deleteById	directive_consequence	{"id": 8, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 8, "label": "free time 24 minute", "value_id": 25, "id_expl_id": 590, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 590, "argument_id_expl_id": 590, "moral_good_id_expl_id": 590}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time 24 minute"}
2025-04-06 18:56:01.610339+00	601	7	1	10	deleteById	directive_consequence	{"id": 10, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 10, "label": "free time 28 minute", "value_id": 29, "id_expl_id": 592, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 592, "argument_id_expl_id": 592, "moral_good_id_expl_id": 592}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time 28 minute"}
2025-04-06 18:56:04.947778+00	603	7	1	12	deleteById	directive_consequence	{"id": 12, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 12, "label": "free time 32 minute", "value_id": 33, "id_expl_id": 594, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 594, "argument_id_expl_id": 594, "moral_good_id_expl_id": 594}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time 32 minute"}
2025-04-07 19:28:03.16972+00	629	19	1	19	updateRecord	person	{"id": 19, "diff": {"after": {"language": "russian"}, "before": {"id": 19, "language": "english", "language_expl_id": 628}}, "user": {"id": 19, "name": "Asha", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Аша"}
2025-04-04 20:47:52.373346+00	533	9	1	67	insertCrossRecord	statement	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "cross": {"id": 3, "label": "housing", "tableName": "tag"}, "record": {"tag_id": 3, "statement_id": 67, "tag_id_expl_id": 533, "statement_id_expl_id": 533}, "target": {"id": 67, "label": "(?) ", "tableName": "statement"}}
2025-04-04 22:49:13.750656+00	534	9	1	68	insertCrossRecord	statement	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "cross": {"id": 14, "label": "climate", "tableName": "tag"}, "record": {"tag_id": 14, "statement_id": 68, "tag_id_expl_id": 534, "statement_id_expl_id": 534}, "target": {"id": 68, "label": "(?) ", "tableName": "statement"}}
2025-04-04 22:53:10.227666+00	535	9	1	1	updateRecord	person_category	{"id": 1, "diff": {"after": {"name": "block of flats residents"}, "before": {"id": 1, "name": "block of flats resident", "name_expl_id": null}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "", "tableName": "person_category", "targetLabel": "block of flats residents"}
2025-04-04 22:53:21.082354+00	536	9	1	3	updateRecord	person_category	{"id": 3, "diff": {"after": {"name": "US citizens"}, "before": {"id": 3, "name": "US citizen", "name_expl_id": 499}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "", "tableName": "person_category", "targetLabel": "US citizens"}
2025-04-04 23:33:44.605124+00	537	5	1	10	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 10, "name": "normative", "id_expl_id": 537, "description": "A normative argument, in essence, is an argument that makes a claim about what ought to be, or what is morally right or wrong, rather than simply stating what is. It's about evaluating actions, policies, or situations based on values and standards of what is considered good or desirable. ", "name_expl_id": 537, "description_expl_id": 537}, "tableName": "argument_type", "targetLabel": "normative"}
2025-04-04 23:52:12.280162+00	539	9	1	86	insertExtRecord	argument	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 86, "pro": false, "title": "petty rule", "id_expl_id": 539, "pro_expl_id": 539, "statement_id": 67, "title_expl_id": 539, "argument_type_id": 10, "statement_id_expl_id": 539, "argument_type_id_expl_id": 539}, "extRecord": {"id": 86, "text": "the rule to lock rubbish bins is petty", "id_expl_id": 539, "text_expl_id": 539}, "tableName": "argument", "targetLabel": "petty rule", "extTableName": "argument_normative"}
2025-04-04 23:59:39.274901+00	540	9	1	87	insertExtRecord	argument	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 87, "pro": false, "title": "takes time", "id_expl_id": 540, "pro_expl_id": 540, "statement_id": 67, "title_expl_id": 540, "argument_type_id": 10, "statement_id_expl_id": 540, "argument_type_id_expl_id": 540}, "extRecord": {"id": 87, "text": "every resident has to spend some time every week unlocking and locking the bins", "id_expl_id": 540, "text_expl_id": 540}, "tableName": "argument", "targetLabel": "takes time", "extTableName": "argument_normative"}
2025-04-06 18:26:36.038667+00	584	7	1	4	deleteById	directive_consequence	{"id": 4, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 4, "label": "free time 16 minute", "value_id": 17, "id_expl_id": 583, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 583, "argument_id_expl_id": 583, "moral_good_id_expl_id": 583}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time 16 minute"}
2025-04-06 18:26:50.60416+00	586	7	1	5	deleteById	directive_consequence	{"id": 5, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 5, "label": "free time 18 minute", "value_id": 19, "id_expl_id": 585, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 585, "argument_id_expl_id": 585, "moral_good_id_expl_id": 585}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time 18 minute"}
2025-04-06 18:55:57.202369+00	598	7	1	7	deleteById	directive_consequence	{"id": 7, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 7, "label": "free time 22 minute", "value_id": 23, "id_expl_id": 589, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 589, "argument_id_expl_id": 589, "moral_good_id_expl_id": 589}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time 22 minute"}
2025-04-06 18:56:00.054977+00	600	7	1	9	deleteById	directive_consequence	{"id": 9, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 9, "label": "free time 26 minute", "value_id": 27, "id_expl_id": 591, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 591, "argument_id_expl_id": 591, "moral_good_id_expl_id": 591}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time 26 minute"}
2025-04-06 18:56:03.460682+00	602	7	1	11	deleteById	directive_consequence	{"id": 11, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 11, "label": "free time 30 minute", "value_id": 31, "id_expl_id": 593, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 593, "argument_id_expl_id": 593, "moral_good_id_expl_id": 593}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time 30 minute"}
2025-04-07 19:30:48.022788+00	630	19	1	19	updateRecord	person	{"id": 19, "diff": {"after": {"language": "ukrainian"}, "before": {"id": 19, "language": "russian", "language_expl_id": 629}}, "user": {"id": 19, "name": "Asha", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Аша"}
2025-04-05 00:01:59.344473+00	541	9	1	88	insertExtRecord	argument	{"user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "record": {"id": 88, "pro": true, "title": "messy intruders", "id_expl_id": 541, "pro_expl_id": 541, "statement_id": 67, "title_expl_id": 541, "argument_type_id": 10, "statement_id_expl_id": 541, "argument_type_id_expl_id": 541}, "extRecord": {"id": 88, "text": "locking the bins prevents intruders from creating a mess", "id_expl_id": 541, "text_expl_id": 541}, "tableName": "argument", "targetLabel": "messy intruders", "extTableName": "argument_normative"}
2025-04-05 00:02:35.649738+00	542	9	1	88	updateRecord	argument	{"id": 88, "diff": {"after": {"title": "stop messy intruders"}, "before": {"id": 88, "title": "messy intruders", "title_expl_id": 541}}, "user": {"id": 9, "name": "Jordan", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "stop messy intruders"}
2025-04-06 18:26:44.198717+00	585	7	1	5	insertRecord	directive_consequence	{"user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 5, "label": "free time 18 minute", "value_id": 19, "id_expl_id": 585, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 585, "argument_id_expl_id": 585, "moral_good_id_expl_id": 585}, "tableName": "directive_consequence", "targetLabel": "free time 18 minute"}
2025-04-06 18:27:14.20746+00	588	7	1	6	deleteById	directive_consequence	{"id": 6, "user": {"id": 7, "name": "Laura Ground", "auth_role": "invited"}, "record": {"id": 6, "label": "free time 20 minute", "value_id": 21, "id_expl_id": 587, "argument_id": 87, "moral_good_id": 2, "value_id_expl_id": 587, "argument_id_expl_id": 587, "moral_good_id_expl_id": 587}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "free time 20 minute"}
2025-04-07 19:31:08.814532+00	631	19	1	19	updateRecord	person	{"id": 19, "diff": {"after": {"language": "english"}, "before": {"id": 19, "language": "ukrainian", "language_expl_id": 630}}, "user": {"id": 19, "name": "Аша", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Аша"}
2025-04-07 19:32:14.150594+00	632	19	1	19	updateRecord	person	{"id": 19, "diff": {"after": {"language": "chinese"}, "before": {"id": 19, "language": "english", "language_expl_id": 631}}, "user": {"id": 19, "name": "Аша", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Asha"}
2025-04-12 01:44:50.557252+00	751	18	1	100	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 100, "pro": true, "title": "a3", "id_expl_id": 751, "pro_expl_id": 751, "statement_id": 86, "title_expl_id": 751, "argument_type_id": 7, "statement_id_expl_id": 751, "argument_type_id_expl_id": 751}, "extRecord": {"id": 100, "text": " ", "id_expl_id": 751, "text_expl_id": 751}, "tableName": "argument", "targetLabel": "a3", "extTableName": "argument_comparison"}
2025-04-15 02:12:28.731959+00	804	5	1	14	updateRecord	critical_question	{"id": 14, "diff": {"after": {"text": "Does the analogy overlook any critical factors?"}, "before": {"id": 14, "text": "", "id_expl_id": null, "text_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "critical_question", "targetLabel": "Does the analogy overlook any critical factors?"}
2025-04-10 20:09:24.519156+00	687	21	1	95	insertExtRecord	argument	{"user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "record": {"id": 95, "pro": true, "title": "oppression & corruption", "id_expl_id": 687, "pro_expl_id": 687, "statement_id": 70, "title_expl_id": 687, "argument_type_id": 10, "statement_id_expl_id": 687, "argument_type_id_expl_id": 687}, "extRecord": {"id": 95, "text": "Putin's regime is oppressive and corrupt.\\nLetting him win the war would subject the population of Ukraine to permanent oppression and political corruption. ", "id_expl_id": 687, "text_expl_id": 687}, "tableName": "argument", "targetLabel": "oppression & corruption", "extTableName": "argument_normative"}
2025-04-12 00:14:57.199993+00	736	\N	1	47	attemptAggregateArguments	statement	{"diff": {"after": {"decided": true, "confidence": 0.048}, "before": {"id": 47, "decided": true, "confidence": 0.069, "id_expl_id": 184, "decided_expl_id": 493, "confidence_expl_id": 493}}, "statement": {"id": 47, "text": "A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change.", "id_expl_id": 184, "text_expl_id": 494}, "triggerLabel": "update of argument weight", "triggerExplId": 735, "weightedArguments": [{"id": 59, "pro": false, "title": "professional reputation", "id_expl_id": 484, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 484, "weight_explanation_expl_id": 484, "weight_lower_limit_expl_id": 484, "weight_upper_limit_expl_id": 484}, {"id": 51, "pro": true, "title": "they will gain fame and recognition", "id_expl_id": 485, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 485, "weight_explanation_expl_id": 485, "weight_lower_limit_expl_id": 485, "weight_upper_limit_expl_id": 485}, {"id": 53, "pro": true, "title": "search for truth", "id_expl_id": 488, "weight_mode": 5, "weight_lower_limit": 0, "weight_upper_limit": 20, "weight_mode_expl_id": 488, "weight_explanation_expl_id": 488, "weight_lower_limit_expl_id": 488, "weight_upper_limit_expl_id": 488}, {"id": 60, "pro": false, "title": "risk to funding", "id_expl_id": 489, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 489, "weight_explanation_expl_id": 489, "weight_lower_limit_expl_id": 489, "weight_upper_limit_expl_id": 489}, {"id": 61, "pro": false, "title": "doubt & ideological reservations", "id_expl_id": 490, "weight_mode": 7, "weight_lower_limit": 5, "weight_upper_limit": 10, "weight_mode_expl_id": 490, "weight_explanation_expl_id": 490, "weight_lower_limit_expl_id": 490, "weight_upper_limit_expl_id": 490}, {"id": 52, "pro": true, "title": "Financial support from Climate Change critics", "id_expl_id": 492, "weight_mode": 15, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 492, "weight_explanation_expl_id": 492, "weight_lower_limit_expl_id": 492, "weight_upper_limit_expl_id": 492}, {"id": 54, "pro": false, "title": "fear activists attacks", "id_expl_id": 491, "weight_mode": 15, "weight_lower_limit": 10, "weight_upper_limit": 25.1, "weight_mode_expl_id": 491, "weight_explanation_expl_id": 491, "weight_lower_limit_expl_id": 491, "weight_upper_limit_expl_id": 735}]}
2025-04-12 00:26:40.239668+00	743	5	1	1	updateRecord	argument_aggregation_type	{"id": 1, "diff": {"after": {"description": "These statements describe how things are. They can be true or false, but they are not about what should be — only what is (or was, or will be)."}, "before": {"id": 1, "id_expl_id": null, "description": "confidences are multiplied", "description_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_aggregation_type", "targetLabel": "evidential"}
2025-04-19 00:39:56.656198+00	848	11	1	98	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 98, "text": "water vapour is a well-understood amplifier of global warming", "label": "(?) water vapour is a well-understood amplifier of global warming", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 848, "text_expl_id": 848, "decided_expl_id": 848, "featured_expl_id": 848, "statement_type_id": 1, "confidence_expl_id": 848, "statement_type_name": "descriptive", "statement_type_id_expl_id": 848}, "tableName": "statement", "targetLabel": "(?) water vapour is a well-understood amplifier of global warming"}
2025-05-24 12:12:58.577231+00	1091	5	1	77	updateRecord	issue	{"id": 77, "diff": {"after": {"description": "use markdown"}, "before": {"id": 77, "id_expl_id": null, "description": "", "description_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "issue", "targetLabel": "support formatted text"}
2025-04-19 00:48:58.568314+00	850	11	1	114	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 114, "pro": true, "title": "IPCC AR6", "id_expl_id": 850, "pro_expl_id": 850, "statement_id": 98, "title_expl_id": 850, "argument_type_id": 1, "statement_id_expl_id": 850, "argument_type_id_expl_id": 850}, "extRecord": {"id": 114, "quote": "The specific humidity (WV) feedback, also known as the water-vapour feedback, quantifies the change in radiative flux at the TOA due to changes in atmospheric water vapour concentration associated with a change in global mean surface air temperature. According to theory, observations and models, the water vapour increase approximately follows the Clausius–Clapeyron relationship at the global scale with regional differences dominated by dynamical processes (Section 8.2.1; Sherwood et al., 2010a; Chung et al., 2014; Romps, 2014; R. Liu et al., 2018; Schröder et al., 2019). Greater atmospheric water vapour content, particularly in the upper troposphere, results in enhanced absorption of LW and SW radiation and reduced outgoing radiation. This is a positive feedback. Atmospheric moistening has been detected in satellite records (Section 2.3.1.3.3), it is simulated by climate models (Section 3.3.2.2), and the estimates agree within model and observational uncertainty (Soden et al., 2005; Dessler, 2013; Gordon et al., 2013; Chung et al., 2014). The estimate of this feedback inferred from satellite observations is α WV= 1.85 ± 0.32 W m–2°C–1(R. Liu et al., 2018). This is consistent with the value α WV= 1.77 ± 0.20 W m–2°C–1(one standard deviation) obtained with CMIP5 and CMIP6 models (Zelinka et al., 2020).\\n...\\nThe combined ‘water-vapour plus lapse-rate’ feedback is positive. The main physical processes that drive this feedback are well understood and supported by multiple lines of evidence including models, theory and observations. The combined ‘water-vapour plus lapse-rate’ feedback parameter is assessed to be α LR+WV= 1.30 W m–2°C–1, with avery likely range of 1.1 to 1.5 W m–2°C–1and a likely range of 1.2 to 1.4 W m–2°C–1 with high confidence.", "authority": "IPCC is an international authority on climate change", "id_expl_id": 850, "source_url": "https://www.ipcc.ch/report/ar6/wg1/chapter/chapter-7/#7.4.2.2", "source_title": "7.4.2.2 Water-vapour and Temperature Lapse-rate Feedbacks", "quote_expl_id": 850, "authority_expl_id": 850, "source_url_expl_id": 850, "source_title_expl_id": 850}, "tableName": "argument", "targetLabel": "IPCC AR6", "extTableName": "argument_authority"}
2025-04-20 00:05:52.772639+00	904	18	1	105	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 105, "text": "test st 2", "label": "(?) test st 2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 904, "text_expl_id": 904, "decided_expl_id": 904, "featured_expl_id": 904, "statement_type_id": 1, "confidence_expl_id": 904, "statement_type_name": "descriptive", "statement_type_id_expl_id": 904}, "tableName": "statement", "targetLabel": "(?) test st 2"}
2025-04-20 00:12:58.016597+00	910	18	1	108	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 108, "text": "t5", "label": "(?) t5", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 910, "text_expl_id": 910, "decided_expl_id": 910, "featured_expl_id": 910, "statement_type_id": 1, "confidence_expl_id": 910, "statement_type_name": "descriptive", "statement_type_id_expl_id": 910}, "tableName": "statement", "targetLabel": "(?) t5"}
2025-04-12 01:59:32.987347+00	752	18	1	100	insertRecord	argument_weight	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 100, "id_expl_id": 752, "weight_mode": 45, "weight_explanation": "test ", "weight_lower_limit": 2, "weight_upper_limit": 88, "weight_mode_expl_id": 752, "weight_explanation_expl_id": 752, "weight_lower_limit_expl_id": 752, "weight_upper_limit_expl_id": 752}, "tableName": "argument_weight", "targetLabel": 2}
2025-04-10 20:32:46.509761+00	688	10	1	5	insertRecord	deed	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 5, "text": "support making vaccines optional ", "id_expl_id": 688, "text_expl_id": 688}, "tableName": "deed", "targetLabel": "support making vaccines optional "}
2025-04-10 20:37:28.757816+00	693	10	1	71	insertCrossRecord	statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "cross": {"id": 19, "label": "health", "tableName": "tag"}, "record": {"tag_id": 19, "statement_id": 71, "tag_id_expl_id": 693, "statement_id_expl_id": 693}, "target": {"id": 71, "label": "(?) everyone  should support making vaccines optional ", "tableName": "statement"}}
2025-04-15 02:12:56.351967+00	805	5	1	15	updateRecord	critical_question	{"id": 15, "diff": {"after": {"text": "Does the argument overlook the possibility that different resources, methods, or expertise could apply at larger scales?"}, "before": {"id": 15, "text": "", "id_expl_id": null, "text_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "critical_question", "targetLabel": "Does the argument overlook the possibility that different resources, methods, or expertise could apply at larger scales?"}
2025-04-10 20:39:37.572716+00	694	10	1	96	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 96, "pro": true, "title": "harm", "id_expl_id": 694, "pro_expl_id": 694, "statement_id": 71, "title_expl_id": 694, "argument_type_id": 10, "statement_id_expl_id": 694, "argument_type_id_expl_id": 694}, "extRecord": {"id": 96, "text": "vaccines cause severe medical conditions and even death", "id_expl_id": 694, "text_expl_id": 694}, "tableName": "argument", "targetLabel": "harm", "extTableName": "argument_normative"}
2025-04-12 00:14:56.740006+00	735	18	1	54	updateRecord	argument_weight	{"id": 54, "diff": {"after": {"weight_upper_limit": "25.1"}, "before": {"id": 54, "id_expl_id": 491, "weight_upper_limit": 25, "weight_upper_limit_expl_id": 491}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_weight", "targetLabel": 10}
2025-04-19 00:40:46.503829+00	849	11	1	61	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 61, "label": "(?) water vapour is a well-understood amplifier of global warming", "id_expl_id": 849, "argument_id": 45, "statement_id": 98, "argument_id_expl_id": 849, "critical_question_id": 1, "statement_id_expl_id": 849, "critical_question_id_expl_id": 849}, "tableName": "critical_statement", "targetLabel": "(?) water vapour is a well-understood amplifier of global warming"}
2025-05-06 04:15:58.549203+00	1031	24	1	131	insertCrossRecords	statement	{"id": 131, "user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 1030}, "fkEnries": {"tags": {"options": [{"id": 17, "label": "example"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?) this demo is useful"}
2025-04-20 00:06:35.728581+00	905	18	1	72	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 72, "label": "(?) test st 2", "id_expl_id": 905, "argument_id": 108, "statement_id": 105, "argument_id_expl_id": 905, "critical_question_id": 33, "statement_id_expl_id": 905, "critical_question_id_expl_id": 905}, "tableName": "critical_statement", "targetLabel": "(?) test st 2"}
2025-04-20 00:14:12.134727+00	911	18	1	109	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 109, "text": "t6", "label": "(?) t6", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 911, "text_expl_id": 911, "decided_expl_id": 911, "featured_expl_id": 911, "statement_type_id": 1, "confidence_expl_id": 911, "statement_type_name": "descriptive", "statement_type_id_expl_id": 911}, "tableName": "statement", "targetLabel": "(?) t6"}
2025-04-21 04:37:15.791566+00	971	18	1	118	deleteById	statement	{"id": 118, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) ", "deletedRecords": {"statement": [{"id": 118, "text": "", "label": "(?) ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 945, "text_expl_id": 945, "decided_expl_id": 945, "featured_expl_id": 945, "statement_type_id": 1, "confidence_expl_id": 945, "statement_type_name": "descriptive", "statement_type_id_expl_id": 945}]}}
2025-05-02 21:51:58.63957+00	999	18	1	1	insertRecord	issue	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 1, "title": "Translate UI into other languages", "id_expl_id": 999, "description": "At the moment only the content created by users is translated.", "title_expl_id": 999, "description_expl_id": 999}, "tableName": "issue", "targetLabel": "Translate UI into other languages"}
2025-05-03 00:49:03.346176+00	1020	18	1	92	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 92, "id_expl_id": 1020, "argument_id": 88, "statement_id": 129, "argument_id_expl_id": 1020, "critical_question_id": 47, "statement_id_expl_id": 1020, "critical_question_id_expl_id": 1020}, "tableName": "critical_statement", "targetLabel": 129}
2025-04-12 01:59:33.248855+00	753	\N	1	86	attemptAggregateArguments	statement	{"diff": {"after": {"decided": true, "confidence": 1}, "before": {"id": 86, "decided": false, "confidence": 0.5, "id_expl_id": 750, "decided_expl_id": 750, "confidence_expl_id": 750}}, "statement": {"id": 86, "text": "thre st test", "id_expl_id": 750, "text_expl_id": 750}, "triggerLabel": "insert of argument weight", "triggerExplId": 752, "weightedArguments": [{"id": 100, "pro": true, "title": "a3", "id_expl_id": 752, "weight_mode": 45, "weight_lower_limit": 2, "weight_upper_limit": 88, "weight_mode_expl_id": 752, "weight_explanation_expl_id": 752, "weight_lower_limit_expl_id": 752, "weight_upper_limit_expl_id": 752}]}
2025-04-15 22:09:44.634071+00	806	18	1	3	updateRecord	argument_type	{"id": 3, "diff": {"after": {"description": "The argument does not clearly fit any of the other categories. The line of reasoning may be unusual, mixed, or not yet covered by existing definitions."}, "before": {"id": 3, "id_expl_id": null, "description": "The argument does not clearly fit any of the above categories. The line of reasoning may be unusual, mixed, or not yet covered by existing definitions.", "description_expl_id": 793}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "other"}
2025-04-19 00:49:43.279831+00	851	18	1	18	updateRecord	person	{"id": 18, "diff": {"after": {"language": "russian"}, "before": {"id": 18, "language": "english", "id_expl_id": 504, "language_expl_id": 819}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Durante"}
2025-04-10 20:33:10.280963+00	689	10	1	71	insertExtRecord	statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 71, "text": "", "label": "(?)  should ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 689, "text_expl_id": 689, "decided_expl_id": 689, "featured_expl_id": 689, "confidence_expl_id": 689, "argument_aggregation_type_id": 3, "argument_aggregation_type_name": "normative", "argument_aggregation_type_id_expl_id": 689}, "extRecord": {"id": 71, "deed_id": 5, "id_expl_id": 689, "deed_id_expl_id": 689}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-04-12 00:15:06.140156+00	738	\N	1	47	attemptAggregateArguments	statement	{"diff": {"after": {"decided": true, "confidence": 0.051}, "before": {"id": 47, "decided": true, "confidence": 0.048, "id_expl_id": 184, "decided_expl_id": 736, "confidence_expl_id": 736}}, "statement": {"id": 47, "text": "A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change.", "id_expl_id": 184, "text_expl_id": 494}, "triggerLabel": "update of argument weight", "triggerExplId": 737, "weightedArguments": [{"id": 59, "pro": false, "title": "professional reputation", "id_expl_id": 484, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 484, "weight_explanation_expl_id": 484, "weight_lower_limit_expl_id": 484, "weight_upper_limit_expl_id": 484}, {"id": 51, "pro": true, "title": "they will gain fame and recognition", "id_expl_id": 485, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 485, "weight_explanation_expl_id": 485, "weight_lower_limit_expl_id": 485, "weight_upper_limit_expl_id": 485}, {"id": 53, "pro": true, "title": "search for truth", "id_expl_id": 488, "weight_mode": 5, "weight_lower_limit": 0, "weight_upper_limit": 20, "weight_mode_expl_id": 488, "weight_explanation_expl_id": 488, "weight_lower_limit_expl_id": 488, "weight_upper_limit_expl_id": 488}, {"id": 60, "pro": false, "title": "risk to funding", "id_expl_id": 489, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 489, "weight_explanation_expl_id": 489, "weight_lower_limit_expl_id": 489, "weight_upper_limit_expl_id": 489}, {"id": 61, "pro": false, "title": "doubt & ideological reservations", "id_expl_id": 490, "weight_mode": 7, "weight_lower_limit": 5, "weight_upper_limit": 10, "weight_mode_expl_id": 490, "weight_explanation_expl_id": 490, "weight_lower_limit_expl_id": 490, "weight_upper_limit_expl_id": 490}, {"id": 52, "pro": true, "title": "Financial support from Climate Change critics", "id_expl_id": 492, "weight_mode": 15, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 492, "weight_explanation_expl_id": 492, "weight_lower_limit_expl_id": 492, "weight_upper_limit_expl_id": 492}, {"id": 54, "pro": false, "title": "fear activists attacks", "id_expl_id": 491, "weight_mode": 15, "weight_lower_limit": 10, "weight_upper_limit": 25, "weight_mode_expl_id": 491, "weight_explanation_expl_id": 491, "weight_lower_limit_expl_id": 491, "weight_upper_limit_expl_id": 737}]}
2025-04-20 00:06:50.085183+00	906	18	1	106	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 106, "text": "test st 3", "label": "(?) test st 3", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 906, "text_expl_id": 906, "decided_expl_id": 906, "featured_expl_id": 906, "statement_type_id": 1, "confidence_expl_id": 906, "statement_type_name": "descriptive", "statement_type_id_expl_id": 906}, "tableName": "statement", "targetLabel": "(?) test st 3"}
2025-05-06 04:51:05.61474+00	1043	24	1	133	insertCrossRecords	statement	{"id": 133, "user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 1042}, "fkEnries": {"tags": {"options": [{"id": 17, "label": "example"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?)  should watch the demo of the mind of Apollo"}
2025-04-20 00:14:19.582647+00	912	18	1	110	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 110, "text": "t7", "label": "(?) t7", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 912, "text_expl_id": 912, "decided_expl_id": 912, "featured_expl_id": 912, "statement_type_id": 1, "confidence_expl_id": 912, "statement_type_name": "descriptive", "statement_type_id_expl_id": 912}, "tableName": "statement", "targetLabel": "(?) t7"}
2025-04-21 14:41:33.619012+00	972	18	1	18	updateRecord	person	{"id": 18, "diff": {"after": {"language": "english"}, "before": {"id": 18, "language": "russian", "id_expl_id": 504, "language_expl_id": 903}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Дуранте"}
2025-05-02 22:01:37.463613+00	1000	18	1	10	insertRecord	moral_weight_of_person	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 10, "label": "(10 / minute) free time", "weight": 10, "owner_id": 18, "id_expl_id": 1000, "moral_good_id": 2, "weight_expl_id": 1000, "owner_id_expl_id": 1000, "moral_good_id_expl_id": 1000}, "tableName": "moral_weight_of_person", "targetLabel": "(10 / minute) free time"}
2025-05-02 22:03:07.464074+00	1001	18	1	11	insertRecord	moral_weight_of_person	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 11, "label": "(-2 / upheld) following petty rules", "weight": -2, "owner_id": 18, "id_expl_id": 1001, "moral_good_id": 3, "weight_expl_id": 1001, "owner_id_expl_id": 1001, "moral_good_id_expl_id": 1001}, "tableName": "moral_weight_of_person", "targetLabel": "(-2 / upheld) following petty rules"}
2025-05-03 00:54:14.819746+00	1021	18	1	130	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 130, "text": "every resident has to spend about 3 minutes every week unlocking and locking the bins", "label": "(?) every resident has to spend about 3 minutes every week unlocking and locking the bins", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 1021, "text_expl_id": 1021, "decided_expl_id": 1021, "featured_expl_id": 1021, "statement_type_id": 1, "confidence_expl_id": 1021, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1021}, "tableName": "statement", "targetLabel": "(?) every resident has to spend about 3 minutes every week unlocking and locking the bins"}
2025-04-12 02:21:05.536524+00	754	5	1	\N	deleteByIds	statement	{"ids": [86, 84, 85], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "86, 84, 85", "deletedRecords": {"argument": [{"id": 98, "pro": true, "title": "a1", "id_expl_id": 747, "pro_expl_id": 747, "statement_id": 84, "title_expl_id": 747, "argument_type_id": 3, "statement_id_expl_id": 747, "argument_type_id_expl_id": 747}, {"id": 99, "pro": true, "title": "a2", "id_expl_id": 749, "pro_expl_id": 749, "statement_id": 85, "title_expl_id": 749, "argument_type_id": 10, "statement_id_expl_id": 749, "argument_type_id_expl_id": 749}, {"id": 100, "pro": true, "title": "a3", "id_expl_id": 751, "pro_expl_id": 751, "statement_id": 86, "title_expl_id": 751, "argument_type_id": 7, "statement_id_expl_id": 751, "argument_type_id_expl_id": 751}], "directive": [{"id": 85, "label": "(?)  should recycle rubbish", "deed_id": 3, "id_expl_id": 748, "deed_id_expl_id": 748}], "statement": [{"id": 84, "text": "d st test", "label": "(?) d st test", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 746, "text_expl_id": 746, "decided_expl_id": 746, "featured_expl_id": 746, "statement_type_id": 1, "confidence_expl_id": 746, "statement_type_name": "descriptive", "statement_type_id_expl_id": 746}, {"id": 85, "text": "", "label": "(?)  should recycle rubbish", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 748, "text_expl_id": 748, "decided_expl_id": 748, "featured_expl_id": 748, "statement_type_id": 3, "confidence_expl_id": 748, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 748}, {"id": 86, "text": "thre st test", "label": "(100%) thre st test", "decided": true, "featured": false, "confidence": 1, "id_expl_id": 750, "text_expl_id": 750, "decided_expl_id": 753, "featured_expl_id": 750, "statement_type_id": 2, "confidence_expl_id": 753, "statement_type_name": "threshold", "statement_type_id_expl_id": 750}], "argument_other": [{"id": 98, "text": " ", "id_expl_id": 747, "text_expl_id": 747}], "argument_weight": [{"id": 100, "id_expl_id": 752, "weight_mode": 45, "weight_explanation": "test ", "weight_lower_limit": 2, "weight_upper_limit": 88, "weight_mode_expl_id": 752, "weight_explanation_expl_id": 752, "weight_lower_limit_expl_id": 752, "weight_upper_limit_expl_id": 752}], "argument_normative": [{"id": 99, "text": " ", "id_expl_id": 749, "text_expl_id": 749}], "argument_comparison": [{"id": 100, "text": " ", "id_expl_id": 751, "text_expl_id": 751}]}}
2025-04-10 20:33:44.197728+00	690	10	1	5	insertRecord	person_category	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 5, "name": "everyone ", "id_expl_id": 690, "name_expl_id": 690}, "tableName": "person_category", "targetLabel": "everyone "}
2025-04-12 00:15:05.861902+00	737	18	1	54	updateRecord	argument_weight	{"id": 54, "diff": {"after": {"weight_upper_limit": "25"}, "before": {"id": 54, "id_expl_id": 491, "weight_upper_limit": 25.1, "weight_upper_limit_expl_id": 735}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_weight", "targetLabel": 10}
2025-04-12 00:15:39.091774+00	740	\N	1	47	attemptAggregateArguments	statement	{"diff": {"after": {"decided": true, "confidence": 0.061}, "before": {"id": 47, "decided": true, "confidence": 0.051, "id_expl_id": 184, "decided_expl_id": 738, "confidence_expl_id": 738}}, "statement": {"id": 47, "text": "A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change.", "id_expl_id": 184, "text_expl_id": 494}, "triggerLabel": "update of argument weight", "triggerExplId": 739, "weightedArguments": [{"id": 59, "pro": false, "title": "professional reputation", "id_expl_id": 484, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 484, "weight_explanation_expl_id": 484, "weight_lower_limit_expl_id": 484, "weight_upper_limit_expl_id": 484}, {"id": 51, "pro": true, "title": "they will gain fame and recognition", "id_expl_id": 485, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 485, "weight_explanation_expl_id": 485, "weight_lower_limit_expl_id": 485, "weight_upper_limit_expl_id": 485}, {"id": 53, "pro": true, "title": "search for truth", "id_expl_id": 488, "weight_mode": 5, "weight_lower_limit": 0, "weight_upper_limit": 20, "weight_mode_expl_id": 488, "weight_explanation_expl_id": 488, "weight_lower_limit_expl_id": 488, "weight_upper_limit_expl_id": 488}, {"id": 60, "pro": false, "title": "risk to funding", "id_expl_id": 489, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 489, "weight_explanation_expl_id": 489, "weight_lower_limit_expl_id": 489, "weight_upper_limit_expl_id": 489}, {"id": 61, "pro": false, "title": "doubt & ideological reservations", "id_expl_id": 490, "weight_mode": 7, "weight_lower_limit": 5, "weight_upper_limit": 10, "weight_mode_expl_id": 490, "weight_explanation_expl_id": 490, "weight_lower_limit_expl_id": 490, "weight_upper_limit_expl_id": 490}, {"id": 52, "pro": true, "title": "Financial support from Climate Change critics", "id_expl_id": 492, "weight_mode": 15, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 492, "weight_explanation_expl_id": 492, "weight_lower_limit_expl_id": 492, "weight_upper_limit_expl_id": 492}, {"id": 54, "pro": false, "title": "fear activists attacks", "id_expl_id": 491, "weight_mode": 15, "weight_lower_limit": 10, "weight_upper_limit": 25.1, "weight_mode_expl_id": 491, "weight_explanation_expl_id": 491, "weight_lower_limit_expl_id": 491, "weight_upper_limit_expl_id": 739}]}
2025-04-12 00:15:38.813749+00	739	18	1	54	updateRecord	argument_weight	{"id": 54, "diff": {"after": {"weight_upper_limit": "25.1"}, "before": {"id": 54, "id_expl_id": 491, "weight_upper_limit": 25, "weight_upper_limit_expl_id": 737}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_weight", "targetLabel": 10}
2025-04-12 00:36:16.856629+00	745	5	1	3	updateRecord	argument_aggregation_type	{"id": 3, "diff": {"after": {"description": "Statements about what someone should or should not do."}, "before": {"id": 3, "id_expl_id": 525, "description": "The statement is normative. Specific consequences from each argument are aggregated together before weighing. ", "description_expl_id": 525}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_aggregation_type", "targetLabel": "normative"}
2025-04-15 22:24:39.055772+00	807	18	1	108	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 108, "pro": true, "title": "induction test", "id_expl_id": 807, "pro_expl_id": 807, "statement_id": 90, "title_expl_id": 807, "argument_type_id": 11, "statement_id_expl_id": 807, "argument_type_id_expl_id": 807}, "extRecord": {"id": 108, "text": "All of the natural human languages I've heard about have words.", "id_expl_id": 807, "text_expl_id": 807}, "tableName": "argument", "targetLabel": "induction test", "extTableName": "argument_induction"}
2025-04-19 00:51:25.774739+00	852	18	1	18	updateRecord	person	{"id": 18, "diff": {"after": {"language": "english"}, "before": {"id": 18, "language": "russian", "id_expl_id": 504, "language_expl_id": 851}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Дуранте"}
2025-04-19 00:52:31.22787+00	854	\N	1	98	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.99}, "before": {"id": 98, "decided": false, "confidence": 0.5, "id_expl_id": 848, "decided_expl_id": 848, "confidence_expl_id": 848}}, "statement": {"id": 98, "text": "water vapour is a well-understood amplifier of global warming", "id_expl_id": 848, "text_expl_id": 848}, "confidences": [[], [0.98]], "triggerLabel": "insert of argument judgement", "triggerExplId": 853, "statementArguments": [{"id": 114, "pro": true, "id_expl_id": 850, "pro_expl_id": 850, "statement_id": 98, "title_expl_id": 850, "argument_type_id": 1, "statement_id_expl_id": 850, "argument_type_id_expl_id": 850}], "argumentConfidences": [{"pro": true, "pro_expl_id": 850, "isolated_confidence": 0.98, "conditional_confidence": null, "isolated_confidence_expl_id": 853, "conditional_confidence_expl_id": null}]}
2025-04-20 00:07:01.542734+00	907	18	1	107	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 107, "text": "test st 4", "label": "(?) test st 4", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 907, "text_expl_id": 907, "decided_expl_id": 907, "featured_expl_id": 907, "statement_type_id": 1, "confidence_expl_id": 907, "statement_type_name": "descriptive", "statement_type_id_expl_id": 907}, "tableName": "statement", "targetLabel": "(?) test st 4"}
2025-04-20 00:57:02.198581+00	913	18	1	111	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 111, "text": "t8", "label": "(?) t8", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 913, "text_expl_id": 913, "decided_expl_id": 913, "featured_expl_id": 913, "statement_type_id": 1, "confidence_expl_id": 913, "statement_type_name": "descriptive", "statement_type_id_expl_id": 913}, "tableName": "statement", "targetLabel": "(?) t8"}
2025-12-11 02:53:52.671782+00	1855	5	1	45	updateRecord	tag	{"id": 45, "diff": {"after": {"name": "ethics"}, "before": {"id": 45, "name": "Ethics", "id_expl_id": 1702, "name_expl_id": 1702}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin", "permission_level": 100}, "userExpl": "", "tableName": "tag", "targetLabel": "ethics"}
2025-04-12 22:47:13.974042+00	755	4	1	6	insertRecord	deed	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 6, "text": "support removal of Donald J. Trump from office", "id_expl_id": 755, "text_expl_id": 755}, "tableName": "deed", "targetLabel": "support removal of Donald J. Trump from office"}
2025-04-12 22:49:32.609659+00	758	4	1	87	insertCrossRecords	statement	{"id": 87, "user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 757}, "fkEnries": {"tags": {"options": [{"id": 26, "label": "US politics"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?)  should support removal of Donald J. Trump from office"}
2025-04-20 00:57:07.134609+00	914	18	1	75	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 75, "label": "(?) t8", "id_expl_id": 914, "argument_id": 108, "statement_id": 111, "argument_id_expl_id": 914, "critical_question_id": 33, "statement_id_expl_id": 914, "critical_question_id_expl_id": 914}, "tableName": "critical_statement", "targetLabel": "(?) t8"}
2025-04-10 20:37:07.789378+00	692	10	1	19	insertRecord	tag	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 19, "name": "health", "id_expl_id": 692, "description": " ", "name_expl_id": 692, "description_expl_id": 692}, "tableName": "tag", "targetLabel": "health"}
2025-04-12 00:15:45.37981+00	742	\N	1	47	attemptAggregateArguments	statement	{"diff": {"after": {"decided": true, "confidence": 0.064}, "before": {"id": 47, "decided": true, "confidence": 0.061, "id_expl_id": 184, "decided_expl_id": 740, "confidence_expl_id": 740}}, "statement": {"id": 47, "text": "A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change.", "id_expl_id": 184, "text_expl_id": 494}, "triggerLabel": "update of argument weight", "triggerExplId": 741, "weightedArguments": [{"id": 59, "pro": false, "title": "professional reputation", "id_expl_id": 484, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 484, "weight_explanation_expl_id": 484, "weight_lower_limit_expl_id": 484, "weight_upper_limit_expl_id": 484}, {"id": 51, "pro": true, "title": "they will gain fame and recognition", "id_expl_id": 485, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 485, "weight_explanation_expl_id": 485, "weight_lower_limit_expl_id": 485, "weight_upper_limit_expl_id": 485}, {"id": 53, "pro": true, "title": "search for truth", "id_expl_id": 488, "weight_mode": 5, "weight_lower_limit": 0, "weight_upper_limit": 20, "weight_mode_expl_id": 488, "weight_explanation_expl_id": 488, "weight_lower_limit_expl_id": 488, "weight_upper_limit_expl_id": 488}, {"id": 60, "pro": false, "title": "risk to funding", "id_expl_id": 489, "weight_mode": 10, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 489, "weight_explanation_expl_id": 489, "weight_lower_limit_expl_id": 489, "weight_upper_limit_expl_id": 489}, {"id": 61, "pro": false, "title": "doubt & ideological reservations", "id_expl_id": 490, "weight_mode": 7, "weight_lower_limit": 5, "weight_upper_limit": 10, "weight_mode_expl_id": 490, "weight_explanation_expl_id": 490, "weight_lower_limit_expl_id": 490, "weight_upper_limit_expl_id": 490}, {"id": 52, "pro": true, "title": "Financial support from Climate Change critics", "id_expl_id": 492, "weight_mode": 15, "weight_lower_limit": 5, "weight_upper_limit": 20, "weight_mode_expl_id": 492, "weight_explanation_expl_id": 492, "weight_lower_limit_expl_id": 492, "weight_upper_limit_expl_id": 492}, {"id": 54, "pro": false, "title": "fear activists attacks", "id_expl_id": 491, "weight_mode": 15, "weight_lower_limit": 10, "weight_upper_limit": 25, "weight_mode_expl_id": 491, "weight_explanation_expl_id": 491, "weight_lower_limit_expl_id": 491, "weight_upper_limit_expl_id": 741}]}
2025-04-12 00:15:45.120453+00	741	18	1	54	updateRecord	argument_weight	{"id": 54, "diff": {"after": {"weight_upper_limit": "25"}, "before": {"id": 54, "id_expl_id": 491, "weight_upper_limit": 25.1, "weight_upper_limit_expl_id": 739}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_weight", "targetLabel": 10}
2025-04-12 22:49:43.630873+00	759	4	1	8	insertRecord	directive_scope	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 8, "label": "(+) US citizens", "include": true, "id_expl_id": 759, "directive_id": 87, "include_expl_id": 759, "person_category_id": 3, "directive_id_expl_id": 759, "person_category_id_expl_id": 759}, "tableName": "directive_scope", "targetLabel": "(+) US citizens"}
2025-04-17 00:42:40.344075+00	808	18	1	47	updateRecord	argument_type_example	{"id": 47, "diff": {"after": {"argument": "Cities that have implemented green roofs tend to have lower temperatures than those that haven't. (argument type \\"analogy\\" was selected)"}, "before": {"id": 47, "argument": "Cities that have implemented green roofs tend to have lower temperatures than those that haven't. Therefore, we should install green roofs everywhere to cool down cities.", "id_expl_id": null, "argument_expl_id": null}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_type_example", "targetLabel": "Cities that have implemented green roofs tend to have lower temperatures than those that haven't. (argument type \\"analogy\\" was selected)"}
2025-04-20 00:07:18.259096+00	908	18	1	73	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 73, "label": "(?) test st 3", "id_expl_id": 908, "argument_id": 108, "statement_id": 106, "argument_id_expl_id": 908, "critical_question_id": 33, "statement_id_expl_id": 908, "critical_question_id_expl_id": 908}, "tableName": "critical_statement", "targetLabel": "(?) test st 3"}
2025-04-19 00:52:31.016556+00	853	11	1	114	insertRecord	argument_judgement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 114, "label": "IPCC AR6 (98%)", "id_expl_id": 853, "isolated_confidence": 0.98, "isolated_explanation": "There seems to be robust confirmation of this fact", "isolated_confidence_expl_id": 853, "isolated_explanation_expl_id": 853}, "tableName": "argument_judgement", "targetLabel": "IPCC AR6 (98%)"}
2025-11-05 11:48:40.768273+00	1509	18	1	108	insertRecord	argument_conditional	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 108, "id_expl_id": 1509, "conditional_confidence": 0.18, "conditional_explanation": "test", "conditional_confidence_expl_id": 1509, "conditional_explanation_expl_id": 1509}, "tableName": "argument_conditional", "targetLabel": 0.18}
2025-04-19 01:24:30.265909+00	858	11	1	116	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 116, "pro": true, "title": "IPCC AR6", "id_expl_id": 858, "pro_expl_id": 858, "statement_id": 99, "title_expl_id": 858, "argument_type_id": 1, "statement_id_expl_id": 858, "argument_type_id_expl_id": 858}, "extRecord": {"id": 116, "quote": "The best estimate of net cloud feedback is obtained by summing feedbacks associated with individual cloud regimes and assessed to be α C= 0.42 W m–2°C–1. By assuming that the uncertainties of individual cloud feedbacks are independent of each other, their standard deviations are added in quadrature, leading to the likely range of 0.12 to 0.72 W m–2°C–1and the very likely range of –0.10 to +0.94 W m–2°C–1(Table 7.10). This approach potentially misses feedbacks from cloud regimes that are not assessed, but almost all the major cloud regimes were taken into consideration (Gettelman and Sherwood, 2016) and therefore additional uncertainty will be small. This argument is also supported by an agreement between the net cloud feedback assessed here and the net cloud feedback directly estimated using observations. ", "authority": "IPCC is an international authority on climate change ", "id_expl_id": 858, "source_url": "https://www.ipcc.ch/report/ar6/wg1/chapter/chapter-7/#7.4.2.4.3", "source_title": "7.4.2.4.3 Synthesis for the net cloud feedback", "quote_expl_id": 858, "authority_expl_id": 858, "source_url_expl_id": 858, "source_title_expl_id": 858}, "tableName": "argument", "targetLabel": "IPCC AR6", "extTableName": "argument_authority"}
2025-04-12 22:49:22.133926+00	756	4	1	26	insertRecord	tag	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 26, "name": "US politics", "id_expl_id": 756, "description": "", "name_expl_id": 756, "description_expl_id": 756}, "tableName": "tag", "targetLabel": "US politics"}
2025-04-10 20:45:12.41533+00	695	10	1	72	insertRecord	statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 72, "text": "COVID vaccines caused 50k+ deaths", "label": "(?) COVID vaccines caused 50k+ deaths", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 695, "text_expl_id": 695, "decided_expl_id": 695, "featured_expl_id": 695, "confidence_expl_id": 695, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 695}, "tableName": "statement", "targetLabel": "(?) COVID vaccines caused 50k+ deaths"}
2025-04-12 00:33:28.070804+00	744	5	1	2	updateRecord	argument_aggregation_type	{"id": 2, "diff": {"after": {"description": "Statements about the probability of reaching a certain threshold based on a balance of factors. For example probability of a person making a decision based on weighing its pros and cons."}, "before": {"id": 2, "id_expl_id": null, "description": "scores are added", "description_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_aggregation_type", "targetLabel": "additive"}
2025-04-17 01:06:05.318767+00	809	18	1	41	updateExtRecord	argument	{"id": 41, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"authority": "prof. of earth and env. sciences"}, "before": {"id": 41, "authority": "Darrell Kaufman is a professor of earth and environmental sciences at Northern Arizona University.", "id_expl_id": 149, "authority_expl_id": 149}}, "tableName": "argument", "targetLabel": "According to a professor of earth and environmental sciences this is probably true.", "extTableName": "argument_authority"}
2025-04-19 01:02:30.194357+00	855	11	1	99	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 99, "text": "clouds is an amplifier of global warming", "label": "(?) clouds is an amplifier of global warming", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 855, "text_expl_id": 855, "decided_expl_id": 855, "featured_expl_id": 855, "statement_type_id": 1, "confidence_expl_id": 855, "statement_type_name": "descriptive", "statement_type_id_expl_id": 855}, "tableName": "statement", "targetLabel": "(?) clouds is an amplifier of global warming"}
2025-04-20 00:58:43.678599+00	915	18	1	112	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 112, "text": "t10", "label": "(?) t10", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 915, "text_expl_id": 915, "decided_expl_id": 915, "featured_expl_id": 915, "statement_type_id": 1, "confidence_expl_id": 915, "statement_type_name": "descriptive", "statement_type_id_expl_id": 915}, "tableName": "statement", "targetLabel": "(?) t10"}
2025-04-19 01:02:53.909854+00	856	11	1	62	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 62, "label": "(?) clouds is an amplifier of global warming", "id_expl_id": 856, "argument_id": 45, "statement_id": 99, "argument_id_expl_id": 856, "critical_question_id": 1, "statement_id_expl_id": 856, "critical_question_id_expl_id": 856}, "tableName": "critical_statement", "targetLabel": "(?) clouds is an amplifier of global warming"}
2025-04-19 01:10:12.784375+00	857	11	1	115	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 115, "pro": true, "title": "2021 observations study", "id_expl_id": 857, "pro_expl_id": 857, "statement_id": 99, "title_expl_id": 857, "argument_type_id": 1, "statement_id_expl_id": 857, "argument_type_id_expl_id": 857}, "extRecord": {"id": 115, "quote": "The research, by scientists at Imperial College London and the University of East Anglia, is the strongest evidence yet that clouds will amplify global heating over the long term, further exacerbating climate change.\\n\\nThey found it was very likely (more than 97.5% probability) that clouds will amplify global heating, by both reflecting less solar radiation and enhancing the greenhouse effect. These results also suggest that a doubling of CO2 concentrations will lead to around 3.2°C of warming. This is the highest confidence of any study so far, and is based on data from global observations, rather than local regions or specific cloud types.", "authority": "Dr Paulo Ceppi is a Senior Lecturer in Climate Science in the Department of Physics. Peer Nowack holds the Chair for Artificial Intelligence (AI) in Climate and Environmental Sciences since March 2023.", "id_expl_id": 857, "source_url": "https://www.sciencedaily.com/releases/2021/07/210719153522.htm", "source_title": "Global satellite data shows clouds will amplify global heating", "quote_expl_id": 857, "authority_expl_id": 857, "source_url_expl_id": 857, "source_title_expl_id": 857}, "tableName": "argument", "targetLabel": "2021 observations study", "extTableName": "argument_authority"}
2025-04-20 01:02:22.81057+00	918	18	1	113	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 113, "text": "t2", "label": "(?) t2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 918, "text_expl_id": 918, "decided_expl_id": 918, "featured_expl_id": 918, "statement_type_id": 1, "confidence_expl_id": 918, "statement_type_name": "descriptive", "statement_type_id_expl_id": 918}, "tableName": "statement", "targetLabel": "(?) t2"}
2025-04-19 01:25:44.719476+00	859	11	1	116	insertRecord	argument_judgement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 116, "label": "IPCC AR6 (90%)", "id_expl_id": 859, "isolated_confidence": 0.9, "isolated_explanation": "It's the biggest source of uncertainty in the models but the scientists have narrowed the possible ranges", "isolated_confidence_expl_id": 859, "isolated_explanation_expl_id": 859}, "tableName": "argument_judgement", "targetLabel": "IPCC AR6 (90%)"}
2025-04-20 00:07:24.816661+00	909	18	1	74	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 74, "label": "(?) test st 4", "id_expl_id": 909, "argument_id": 108, "statement_id": 107, "argument_id_expl_id": 909, "critical_question_id": 33, "statement_id_expl_id": 909, "critical_question_id_expl_id": 909}, "tableName": "critical_statement", "targetLabel": "(?) test st 4"}
2025-04-12 22:49:32.277677+00	757	4	1	87	insertExtRecord	statement	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 87, "text": "", "label": "(?)  should ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 757, "text_expl_id": 757, "decided_expl_id": 757, "featured_expl_id": 757, "statement_type_id": 3, "confidence_expl_id": 757, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 757}, "extRecord": {"id": 87, "deed_id": 6, "id_expl_id": 757, "deed_id_expl_id": 757}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-04-10 20:45:24.807855+00	696	10	1	\N	insertRecord	critical_statement	\N
2025-04-12 01:40:12.923202+00	746	18	1	84	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 84, "text": "d st test", "label": "(?) d st test", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 746, "text_expl_id": 746, "decided_expl_id": 746, "featured_expl_id": 746, "statement_type_id": 1, "confidence_expl_id": 746, "statement_type_name": "descriptive", "statement_type_id_expl_id": 746}, "tableName": "statement", "targetLabel": "(?) d st test"}
2025-05-03 00:54:17.215879+00	1022	18	1	93	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 93, "id_expl_id": 1022, "argument_id": 87, "statement_id": 130, "argument_id_expl_id": 1022, "critical_question_id": 47, "statement_id_expl_id": 1022, "critical_question_id_expl_id": 1022}, "tableName": "critical_statement", "targetLabel": 130}
2025-04-12 01:44:15.493211+00	750	18	1	86	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 86, "text": "thre st test", "label": "(?) thre st test", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 750, "text_expl_id": 750, "decided_expl_id": 750, "featured_expl_id": 750, "statement_type_id": 2, "confidence_expl_id": 750, "statement_type_name": "threshold", "statement_type_id_expl_id": 750}, "tableName": "statement", "targetLabel": "(?) thre st test"}
2025-04-12 23:27:41.006705+00	761	4	1	7	insertRecord	deed	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 7, "text": "support election of someone like Donald J. Trump as the US president again", "id_expl_id": 761, "text_expl_id": 761}, "tableName": "deed", "targetLabel": "support election of someone like Donald J. Trump as the US president again"}
2025-04-12 23:28:18.041888+00	763	4	1	88	insertCrossRecords	statement	{"id": 88, "user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 762}, "fkEnries": {"tags": {"options": [{"id": 26, "label": "US politics"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?)  should support election of someone like Donald J. Trump as the US president again"}
2025-04-17 01:06:35.821613+00	810	18	1	41	updateExtRecord	argument	{"id": 41, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"after": {"title": "prof. of earth and env. sciences"}, "before": {"id": 41, "title": "According to a professor of earth and environmental sciences this is probably true.", "id_expl_id": 149, "title_expl_id": 149}}, "userExpl": "", "extRecord": {"after": {"authority": "Darrell Kaufman is a professor of earth and environmental sciences at Northern Arizona University."}, "before": {"id": 41, "authority": "prof. of earth and env. sciences", "id_expl_id": 149, "authority_expl_id": 809}}, "tableName": "argument", "targetLabel": "prof. of earth and env. sciences", "extTableName": "argument_authority"}
2025-04-20 00:58:46.294702+00	916	18	1	76	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 76, "label": "(?) t10", "id_expl_id": 916, "argument_id": 108, "statement_id": 112, "argument_id_expl_id": 916, "critical_question_id": 2, "statement_id_expl_id": 916, "critical_question_id_expl_id": 916}, "tableName": "critical_statement", "targetLabel": "(?) t10"}
2025-04-19 01:26:28.339606+00	860	11	1	115	insertRecord	argument_judgement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 115, "label": "2021 observations study (90%)", "id_expl_id": 860, "isolated_confidence": 0.9, "isolated_explanation": "The cited confidence is large, but it's only one study.", "isolated_confidence_expl_id": 860, "isolated_explanation_expl_id": 860}, "tableName": "argument_judgement", "targetLabel": "2021 observations study (90%)"}
2025-04-20 01:02:37.757354+00	920	18	1	113	deleteById	statement	{"id": 113, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) t2", "deletedRecords": {"statement": [{"id": 113, "text": "t2", "label": "(?) t2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 918, "text_expl_id": 918, "decided_expl_id": 918, "featured_expl_id": 918, "statement_type_id": 1, "confidence_expl_id": 918, "statement_type_name": "descriptive", "statement_type_id_expl_id": 918}], "critical_statement": [{"id": 77, "label": "(?) t2", "id_expl_id": 919, "argument_id": 108, "statement_id": 113, "argument_id_expl_id": 919, "critical_question_id": 33, "statement_id_expl_id": 919, "critical_question_id_expl_id": 919}]}}
2025-04-21 14:42:07.975246+00	973	18	1	131	insertExtRecord	argument	{"user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "record": {"id": 131, "pro": false, "title": "t4", "id_expl_id": 973, "pro_expl_id": 973, "statement_id": 90, "title_expl_id": 973, "argument_type_id": 3, "statement_id_expl_id": 973, "argument_type_id_expl_id": 973}, "extRecord": {"id": 131, "text": "t4", "id_expl_id": 973, "text_expl_id": 973}, "tableName": "argument", "targetLabel": "t4", "extTableName": "argument_other"}
2025-05-02 22:03:22.127665+00	1002	18	1	12	insertRecord	moral_weight_of_person	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 12, "label": "(-4 / misplaced item / m³) mess", "weight": -4, "owner_id": 18, "id_expl_id": 1002, "moral_good_id": 1, "weight_expl_id": 1002, "owner_id_expl_id": 1002, "moral_good_id_expl_id": 1002}, "tableName": "moral_weight_of_person", "targetLabel": "(-4 / misplaced item / m³) mess"}
2025-12-17 15:43:47.205268+00	1933	\N	1	\N	cascadeUpdateScores	\N	\N
2025-04-20 01:01:48.702596+00	917	5	1	\N	deleteByIds	statement	{"ids": [112, 111, 110, 109, 108, 107, 106, 105], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "112, 111, 110, 109, 108, 107, 106, 105", "deletedRecords": {"statement": [{"id": 105, "text": "test st 2", "label": "(?) test st 2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 904, "text_expl_id": 904, "decided_expl_id": 904, "featured_expl_id": 904, "statement_type_id": 1, "confidence_expl_id": 904, "statement_type_name": "descriptive", "statement_type_id_expl_id": 904}, {"id": 106, "text": "test st 3", "label": "(?) test st 3", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 906, "text_expl_id": 906, "decided_expl_id": 906, "featured_expl_id": 906, "statement_type_id": 1, "confidence_expl_id": 906, "statement_type_name": "descriptive", "statement_type_id_expl_id": 906}, {"id": 107, "text": "test st 4", "label": "(?) test st 4", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 907, "text_expl_id": 907, "decided_expl_id": 907, "featured_expl_id": 907, "statement_type_id": 1, "confidence_expl_id": 907, "statement_type_name": "descriptive", "statement_type_id_expl_id": 907}, {"id": 108, "text": "t5", "label": "(?) t5", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 910, "text_expl_id": 910, "decided_expl_id": 910, "featured_expl_id": 910, "statement_type_id": 1, "confidence_expl_id": 910, "statement_type_name": "descriptive", "statement_type_id_expl_id": 910}, {"id": 109, "text": "t6", "label": "(?) t6", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 911, "text_expl_id": 911, "decided_expl_id": 911, "featured_expl_id": 911, "statement_type_id": 1, "confidence_expl_id": 911, "statement_type_name": "descriptive", "statement_type_id_expl_id": 911}, {"id": 110, "text": "t7", "label": "(?) t7", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 912, "text_expl_id": 912, "decided_expl_id": 912, "featured_expl_id": 912, "statement_type_id": 1, "confidence_expl_id": 912, "statement_type_name": "descriptive", "statement_type_id_expl_id": 912}, {"id": 111, "text": "t8", "label": "(?) t8", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 913, "text_expl_id": 913, "decided_expl_id": 913, "featured_expl_id": 913, "statement_type_id": 1, "confidence_expl_id": 913, "statement_type_name": "descriptive", "statement_type_id_expl_id": 913}, {"id": 112, "text": "t10", "label": "(?) t10", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 915, "text_expl_id": 915, "decided_expl_id": 915, "featured_expl_id": 915, "statement_type_id": 1, "confidence_expl_id": 915, "statement_type_name": "descriptive", "statement_type_id_expl_id": 915}], "critical_statement": [{"id": 72, "label": "(?) test st 2", "id_expl_id": 905, "argument_id": 108, "statement_id": 105, "argument_id_expl_id": 905, "critical_question_id": 33, "statement_id_expl_id": 905, "critical_question_id_expl_id": 905}, {"id": 73, "label": "(?) test st 3", "id_expl_id": 908, "argument_id": 108, "statement_id": 106, "argument_id_expl_id": 908, "critical_question_id": 33, "statement_id_expl_id": 908, "critical_question_id_expl_id": 908}, {"id": 74, "label": "(?) test st 4", "id_expl_id": 909, "argument_id": 108, "statement_id": 107, "argument_id_expl_id": 909, "critical_question_id": 33, "statement_id_expl_id": 909, "critical_question_id_expl_id": 909}, {"id": 75, "label": "(?) t8", "id_expl_id": 914, "argument_id": 108, "statement_id": 111, "argument_id_expl_id": 914, "critical_question_id": 33, "statement_id_expl_id": 914, "critical_question_id_expl_id": 914}, {"id": 76, "label": "(?) t10", "id_expl_id": 916, "argument_id": 108, "statement_id": 112, "argument_id_expl_id": 916, "critical_question_id": 2, "statement_id_expl_id": 916, "critical_question_id_expl_id": 916}]}}
2025-04-12 23:05:23.593931+00	760	4	1	101	insertExtRecord	argument	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 101, "pro": true, "title": "threat to democracy", "id_expl_id": 760, "pro_expl_id": 760, "statement_id": 87, "title_expl_id": 760, "argument_type_id": 10, "statement_id_expl_id": 760, "argument_type_id_expl_id": 760}, "extRecord": {"id": 101, "text": "- Trump undermined democratic institutions: He challenged the legitimacy of elections without credible evidence, pressured officials to overturn lawful results, and eroded public trust in democratic processes.\\n- He encourages political violence: His words and actions surrounding the January 6th Capitol attack incited unrest, showing a willingness to endanger peaceful power transitions to retain control.\\n- He disregards checks and balances: Trump repeatedly attacked the independence of the judiciary, the Department of Justice, and the free press—core institutions meant to limit executive power.\\n- He has not ruled out a third term: By refusing to commit to the two-term limit enshrined in the Constitution, he signals a dangerous openness to authoritarian rule.\\n- Democracy is a tool, not a sacred ideal: It serves essential values like freedom, stability, justice, and accountability. When a leader repeatedly undermines that system, the deeper values democracy protects are put at risk—removal becomes not just justified, but necessary.", "id_expl_id": 760, "text_expl_id": 760}, "tableName": "argument", "targetLabel": "threat to democracy", "extTableName": "argument_normative"}
2025-04-09 21:01:19.53578+00	653	5	1	3	deleteById	person	{"id": 3, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "person", "targetLabel": "", "deletedRecords": {"person": [{"id": 3, "name": "", "language": "russian", "id_expl_id": null, "auth_role_id": 2, "name_expl_id": null, "language_expl_id": 371, "auth_role_id_expl_id": null}], "statement_discussion_message": [{"id": 3, "text": "No, no. Astana is cool!", "owner_id": 3, "user_name": "", "statement_id": 26}]}}
2025-04-10 20:45:35.009633+00	697	10	1	\N	insertRecord	critical_statement	\N
2025-04-12 01:40:31.041597+00	747	18	1	98	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 98, "pro": true, "title": "a1", "id_expl_id": 747, "pro_expl_id": 747, "statement_id": 84, "title_expl_id": 747, "argument_type_id": 3, "statement_id_expl_id": 747, "argument_type_id_expl_id": 747}, "extRecord": {"id": 98, "text": " ", "id_expl_id": 747, "text_expl_id": 747}, "tableName": "argument", "targetLabel": "a1", "extTableName": "argument_other"}
2025-04-12 23:28:17.758154+00	762	4	1	88	insertExtRecord	statement	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 88, "text": "", "label": "(?)  should ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 762, "text_expl_id": 762, "decided_expl_id": 762, "featured_expl_id": 762, "statement_type_id": 3, "confidence_expl_id": 762, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 762}, "extRecord": {"id": 88, "deed_id": 7, "id_expl_id": 762, "deed_id_expl_id": 762}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-04-17 01:06:54.629381+00	811	18	1	41	updateRecord	argument	{"id": 41, "diff": {"after": {"title": "prof. of earth and env. sci."}, "before": {"id": 41, "title": "prof. of earth and env. sciences", "id_expl_id": 149, "title_expl_id": 810}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "prof. of earth and env. sci."}
2025-04-19 01:26:28.527261+00	861	\N	1	99	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.995}, "before": {"id": 99, "decided": false, "confidence": 0.5, "id_expl_id": 855, "decided_expl_id": 855, "confidence_expl_id": 855}}, "statement": {"id": 99, "text": "clouds is an amplifier of global warming", "id_expl_id": 855, "text_expl_id": 855}, "confidences": [[], [0.9, 0.9]], "triggerLabel": "insert of argument judgement", "triggerExplId": 860, "statementArguments": [{"id": 115, "pro": true, "id_expl_id": 857, "pro_expl_id": 857, "statement_id": 99, "title_expl_id": 857, "argument_type_id": 1, "statement_id_expl_id": 857, "argument_type_id_expl_id": 857}, {"id": 116, "pro": true, "id_expl_id": 858, "pro_expl_id": 858, "statement_id": 99, "title_expl_id": 858, "argument_type_id": 1, "statement_id_expl_id": 858, "argument_type_id_expl_id": 858}], "argumentConfidences": [{"pro": true, "pro_expl_id": 858, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 859, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": 857, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 860, "conditional_confidence_expl_id": null}]}
2025-04-21 14:49:14.226963+00	974	18	1	132	insertExtRecord	argument	{"user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "record": {"id": 132, "pro": false, "title": "t5", "id_expl_id": 974, "pro_expl_id": 974, "statement_id": 90, "title_expl_id": 974, "argument_type_id": 3, "statement_id_expl_id": 974, "argument_type_id_expl_id": 974}, "extRecord": {"id": 132, "text": "t5", "id_expl_id": 974, "text_expl_id": 974}, "tableName": "argument", "targetLabel": "t5", "extTableName": "argument_other"}
2025-05-06 04:56:00.572072+00	1046	24	1	18	insertRecord	invite	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 18, "code": "BSgRMYGe", "link": "/join?code=BSgRMYGe", "owner_id": 24, "person_id": null, "id_expl_id": 1046, "code_expl_id": 1046, "owner_id_expl_id": 1046, "person_id_expl_id": 1046}, "tableName": "invite", "targetLabel": "BSgRMYGe"}
2025-04-09 20:49:55.740401+00	648	5	1	7	deleteById	person	{"id": 7, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "person", "targetLabel": "Laura Ground", "deletedRecords": {"person": [{"id": 7, "name": "Laura Ground", "language": "english", "id_expl_id": null, "auth_role_id": 2, "name_expl_id": null, "language_expl_id": null, "auth_role_id_expl_id": null}], "moral_weight_of_person": [{"id": 15, "label": "(-15 / misplaced item / m³) mess", "weight": -15, "owner_id": 7, "id_expl_id": 561, "moral_good_id": 1, "weight_expl_id": 560, "owner_id_expl_id": 561, "moral_good_id_expl_id": 560}, {"id": 16, "label": "(10 / minute) free time", "weight": 10, "owner_id": 7, "id_expl_id": 563, "moral_good_id": 2, "weight_expl_id": 562, "owner_id_expl_id": 563, "moral_good_id_expl_id": 562}, {"id": 17, "label": "(5 / upheld) following petty rules", "weight": 5, "owner_id": 7, "id_expl_id": 565, "moral_good_id": 3, "weight_expl_id": 564, "owner_id_expl_id": 565, "moral_good_id_expl_id": 564}]}}
2025-04-09 20:54:00.237296+00	651	5	1	3	deleteById	person	{"id": 3, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "person", "targetLabel": "", "deletedRecords": {"person": [{"id": 3, "name": "", "language": "russian", "id_expl_id": null, "auth_role_id": 2, "name_expl_id": null, "language_expl_id": 371, "auth_role_id_expl_id": null}]}}
2025-04-09 20:55:00.731914+00	652	5	1	3	deleteById	person	{"id": 3, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "person", "targetLabel": "", "deletedRecords": {"person": [{"id": 3, "name": "", "language": "russian", "id_expl_id": null, "auth_role_id": 2, "name_expl_id": null, "language_expl_id": 371, "auth_role_id_expl_id": null}]}}
2025-04-10 20:55:18.594086+00	698	10	1	54	deleteById	critical_statement	{"id": 54, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "duplicate", "tableName": "critical_statement", "targetLabel": "(?) COVID vaccines caused 50k+ deaths", "deletedRecords": {"critical_statement": [{"id": 54, "label": "(?) COVID vaccines caused 50k+ deaths", "id_expl_id": 697, "argument_id": 96, "statement_id": 72, "argument_id_expl_id": 697, "critical_question_id": 1, "statement_id_expl_id": 697, "critical_question_id_expl_id": 697}]}}
2025-04-12 01:41:03.90196+00	748	18	1	85	insertExtRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 85, "text": "", "label": "(?)  should ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 748, "text_expl_id": 748, "decided_expl_id": 748, "featured_expl_id": 748, "statement_type_id": 3, "confidence_expl_id": 748, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 748}, "extRecord": {"id": 85, "deed_id": 3, "id_expl_id": 748, "deed_id_expl_id": 748}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-04-12 01:43:29.491193+00	749	18	1	99	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 99, "pro": true, "title": "a2", "id_expl_id": 749, "pro_expl_id": 749, "statement_id": 85, "title_expl_id": 749, "argument_type_id": 10, "statement_id_expl_id": 749, "argument_type_id_expl_id": 749}, "extRecord": {"id": 99, "text": " ", "id_expl_id": 749, "text_expl_id": 749}, "tableName": "argument", "targetLabel": "a2", "extTableName": "argument_normative"}
2025-04-12 23:28:25.069779+00	764	4	1	9	insertRecord	directive_scope	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 9, "label": "(+) US citizens", "include": true, "id_expl_id": 764, "directive_id": 88, "include_expl_id": 764, "person_category_id": 3, "directive_id_expl_id": 764, "person_category_id_expl_id": 764}, "tableName": "directive_scope", "targetLabel": "(+) US citizens"}
2025-04-17 01:54:19.399967+00	812	18	1	\N	insertRecord	critical_question	\N
2025-04-19 01:27:55.904011+00	862	11	1	116	insertRecord	argument_conditional	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 116, "id_expl_id": 862, "conditional_confidence": 0.7, "conditional_explanation": "IPCC conclusions are most likely based on the studies like the one mentioned above", "conditional_confidence_expl_id": 862, "conditional_explanation_expl_id": 862}, "tableName": "argument_conditional", "targetLabel": 0.7}
2025-04-20 01:02:24.246555+00	919	18	1	77	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 77, "label": "(?) t2", "id_expl_id": 919, "argument_id": 108, "statement_id": 113, "argument_id_expl_id": 919, "critical_question_id": 33, "statement_id_expl_id": 919, "critical_question_id_expl_id": 919}, "tableName": "critical_statement", "targetLabel": "(?) t2"}
2025-04-21 14:54:36.651578+00	975	18	1	124	insertExtRecord	statement	{"user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "record": {"id": 124, "text": "", "label": "(?)  should ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 975, "text_expl_id": 975, "decided_expl_id": 975, "featured_expl_id": 975, "statement_type_id": 3, "confidence_expl_id": 975, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 975}, "extRecord": {"id": 124, "deed_id": 3, "id_expl_id": 975, "deed_id_expl_id": 975}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-05-02 22:04:00.779583+00	1003	18	1	18	insertCrossRecord	person	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 1, "label": "block of flats residents", "tableName": "person_category"}, "record": {"person_id": 18, "person_id_expl_id": 1003, "person_category_id": 1, "person_category_id_expl_id": 1003}, "target": {"id": 18, "label": "Durante", "tableName": "person"}}
2025-05-13 20:33:05.512616+00	1047	5	1	19	insertRecord	invite	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 19, "code": "4LIzhakm", "link": "/join?code=4LIzhakm", "owner_id": 5, "person_id": null, "id_expl_id": 1047, "code_expl_id": 1047, "owner_id_expl_id": 1047, "person_id_expl_id": 1047}, "tableName": "invite", "targetLabel": "4LIzhakm"}
2025-04-09 20:50:43.890339+00	649	5	1	6	deleteById	person	{"id": 6, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "person", "targetLabel": "John Upington", "deletedRecords": {"person": [{"id": 6, "name": "John Upington", "language": "english", "id_expl_id": null, "auth_role_id": 2, "name_expl_id": null, "language_expl_id": null, "auth_role_id_expl_id": null}], "chat_message": [{"id": 12, "text": "What's up?", "user_id": 6, "timestamp": 1744108526}], "moral_weight_of_person": [{"id": 18, "label": "(-3 / upheld) following petty rules", "weight": -3, "owner_id": 6, "id_expl_id": 567, "moral_good_id": 3, "weight_expl_id": 566, "owner_id_expl_id": 567, "moral_good_id_expl_id": 566}, {"id": 19, "label": "(-5 / misplaced item / m³) mess", "weight": -5, "owner_id": 6, "id_expl_id": 569, "moral_good_id": 1, "weight_expl_id": 568, "owner_id_expl_id": 569, "moral_good_id_expl_id": 568}, {"id": 7, "label": "(30 / minute) free time", "weight": 30, "owner_id": 6, "id_expl_id": 582, "moral_good_id": 2, "weight_expl_id": 582, "owner_id_expl_id": 582, "moral_good_id_expl_id": 582}]}}
2025-04-09 20:51:37.410142+00	650	5	1	3	deleteById	person	{"id": 3, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "person", "targetLabel": "Bob", "deletedRecords": {"person": [{"id": 3, "name": "Bob", "language": "russian", "id_expl_id": null, "auth_role_id": 2, "name_expl_id": null, "language_expl_id": 371, "auth_role_id_expl_id": null}]}}
2025-04-09 21:02:15.090164+00	654	5	1	2	deleteById	person	{"id": 2, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "person", "targetLabel": "Alice", "deletedRecords": {"person": [{"id": 2, "name": "Alice", "language": "russian", "id_expl_id": null, "auth_role_id": 2, "name_expl_id": null, "language_expl_id": 635, "auth_role_id_expl_id": null}], "chat_message": [{"id": 6, "text": "test", "user_id": 2, "timestamp": 1740928832}, {"id": 7, "text": "test2", "user_id": 2, "timestamp": 1741162165}, {"id": 8, "text": "test3", "user_id": 2, "timestamp": 1741162218}], "person_secret": [{"id": 2, "email": "eee", "owner_id": 2, "password": "ppp", "id_expl_id": 59, "email_expl_id": 59, "owner_id_expl_id": 59, "password_expl_id": 59}], "statement_discussion_message": [{"id": 1, "text": "Bob, I think you underestimate Astana", "owner_id": 2, "user_name": "Alice", "statement_id": 26}]}}
2025-04-10 20:58:37.76239+00	699	10	1	97	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 97, "pro": true, "title": "EudraVigilance report", "id_expl_id": 699, "pro_expl_id": 699, "statement_id": 72, "title_expl_id": 699, "argument_type_id": 1, "statement_id_expl_id": 699, "argument_type_id_expl_id": 699}, "extRecord": {"id": 97, "quote": "As of 10 April 2023, a total of 50 648 deaths caused by ‘COVID vaccines’ had been reported in EudraVigilance", "authority": "EudraVigilance investigates adverse reactions to medicines on behalf of the EU", "id_expl_id": 699, "source_url": "https://www.europarl.europa.eu/doceo/document/E-9-2023-001201_EN.html", "source_title": "How many deaths have been caused by ‘COVID vaccines’?", "quote_expl_id": 699, "authority_expl_id": 699, "source_url_expl_id": 699, "source_title_expl_id": 699}, "tableName": "argument", "targetLabel": "EudraVigilance report", "extTableName": "argument_authority"}
2025-04-12 23:41:22.958613+00	765	4	1	102	insertExtRecord	argument	{"user": {"id": 4, "name": "Philip", "auth_role": "invited"}, "record": {"id": 102, "pro": false, "title": "populism", "id_expl_id": 765, "pro_expl_id": 765, "statement_id": 88, "title_expl_id": 765, "argument_type_id": 4, "statement_id_expl_id": 765, "argument_type_id_expl_id": 765}, "extRecord": {"id": 102, "text": "Donald J. Trump is a populist.\\n- Populists promise simple solutions to complex problems: They often reduce nuanced issues (like inequality, immigration, inflation) to slogans or blame games, which rarely lead to sustainable outcomes.\\n- They undermine expert institutions: Populists tend to dismiss experts, economists, and bureaucrats as part of a \\"corrupt elite,\\" weakening the very institutions needed for effective policymaking.\\n- Quick fixes often backfire: Policies designed for short-term popularity (e.g. reckless spending, protectionism, deregulation) can create long-term harm—like inflation, debt, or international isolation.\\n- Existing solutions, while imperfect, are often more effective: Many current systems (e.g. healthcare, taxation, legal frameworks) exist because they’ve evolved to balance trade-offs—not because they’re popular or simple.\\n- Populism leads to polarization and instability: Framing politics as a battle between \\"the people\\" and \\"the elite\\" erodes trust, increases division, and weakens national unity.\\n- The cost is human: When complex realities are ignored in favour of emotional appeals, it’s the basic values—security, fairness, opportunity, and dignity—that suffer most.", "id_expl_id": 765, "text_expl_id": 765}, "tableName": "argument", "targetLabel": "populism", "extTableName": "argument_explanation"}
2025-04-17 01:57:23.091406+00	813	18	1	44	insertRecord	critical_question	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 44, "text": "Is this argument a mixture of multiple types?", "id_expl_id": 813, "text_expl_id": 813, "argument_type_id": 3, "argument_type_id_expl_id": 813}, "tableName": "critical_question", "targetLabel": "Is this argument a mixture of multiple types?"}
2025-04-20 02:12:21.528513+00	921	18	1	125	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 125, "pro": false, "title": "пример 3", "id_expl_id": 921, "pro_expl_id": 921, "statement_id": 90, "title_expl_id": 921, "argument_type_id": 16, "statement_id_expl_id": 921, "argument_type_id_expl_id": 921}, "extRecord": {"id": 125, "text": "Impossiburu!", "id_expl_id": 921, "text_expl_id": 921}, "tableName": "argument", "targetLabel": "пример 3", "extTableName": "argument_feasibility"}
2025-04-21 14:55:10.543517+00	976	18	1	13	insertRecord	directive_scope	{"user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "record": {"id": 13, "label": "(+) everyone ", "include": true, "id_expl_id": 976, "directive_id": 124, "include_expl_id": 976, "person_category_id": 5, "directive_id_expl_id": 976, "person_category_id_expl_id": 976}, "tableName": "directive_scope", "targetLabel": "(+) everyone "}
2025-04-09 21:31:26.865389+00	655	5	1	\N	deleteByIds	statement	{"ids": [1, 2, 4], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "testing mass delete", "tableName": "statement", "targetLabel": "1, 2, 4", "deletedRecords": {"argument": [{"id": 3, "pro": false, "title": "first space launch", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 351, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 78, "pro": true, "title": "string cheese exists", "id_expl_id": 379, "pro_expl_id": 379, "statement_id": 2, "title_expl_id": 379, "argument_type_id": 1, "statement_id_expl_id": 379, "argument_type_id_expl_id": 379}, {"id": 1, "pro": true, "title": "yellow & round", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 313, "argument_type_id": 2, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 4, "pro": true, "title": "holes", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 314, "argument_type_id": 2, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 5, "pro": true, "title": "perfect circle", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 315, "argument_type_id": 2, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 12, "pro": false, "title": "Moon is too big", "id_expl_id": null, "pro_expl_id": null, "statement_id": 1, "title_expl_id": 317, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}], "statement": [{"id": 1, "text": "the Moon is made out of green cheese", "label": "(63%) the Moon is made out of green cheese", "decided": true, "featured": true, "confidence": 0.63386, "id_expl_id": null, "text_expl_id": 409, "decided_expl_id": 378, "featured_expl_id": null, "confidence_expl_id": 378, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 2, "text": "not all cheese is round", "label": "(98%) not all cheese is round", "decided": true, "featured": false, "confidence": 0.975, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": 382, "featured_expl_id": null, "confidence_expl_id": 382, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 4, "text": "there was something before the Big Bang", "label": "(?) there was something before the Big Bang", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}], "argument_other": [{"id": 12, "text": "The Moon is millions times bigger than any head of cheese.", "id_expl_id": null, "text_expl_id": null}, {"id": 3, "text": "There are evidence of the Moon before we were able to launch objects in space.", "id_expl_id": null, "text_expl_id": null}], "argument_analogy": [{"id": 1, "text": "Cheese and the Moon are both yellow and round. Cheese is made from cheese. Therefore the Moon is also made from cheese.", "id_expl_id": null, "text_expl_id": 323}, {"id": 4, "text": "Both cheese and the Moon have holes.", "id_expl_id": null, "text_expl_id": null}, {"id": 5, "text": "Like the Moon, cheese is often a perfect circle.", "id_expl_id": null, "text_expl_id": null}], "argument_authority": [{"id": 78, "quote": "String cheese is any of several different types of cheese where the manufacturing process aligns the proteins in the cheese, making it stringy.", "authority": "Wikipedia is often correct about non-controversial topics. ", "id_expl_id": 379, "source_url": "https://en.wikipedia.org/wiki/String_cheese", "source_title": "String cheese", "quote_expl_id": 379, "authority_expl_id": 380, "source_url_expl_id": 379, "source_title_expl_id": 379}], "argument_judgement": [{"id": 1, "label": "yellow & round (50%)", "id_expl_id": null, "isolated_confidence": 0.5, "isolated_explanation": "Half of the statements in the argument are not entirely true.", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null}, {"id": 5, "label": "perfect circle (65%)", "id_expl_id": null, "isolated_confidence": 0.65, "isolated_explanation": "The main gist of the argument was not attacked. The critical statement is a technicality.  On the other hand \\"often\\" in the text of the argument makes it weaker.", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null}, {"id": 12, "label": "Moon is too big (80%)", "id_expl_id": null, "isolated_confidence": 0.8, "isolated_explanation": "Very big heads of cheese could still be million times smaller than a moon.", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null}, {"id": 4, "label": "holes (33%)", "id_expl_id": null, "isolated_confidence": 0.33, "isolated_explanation": "The argument doesn't specify if the holes in cheese and on the Moon are of the same type.", "isolated_confidence_expl_id": 365, "isolated_explanation_expl_id": 365}, {"id": 3, "label": "first space launch (5%)", "id_expl_id": null, "isolated_confidence": 0.05, "isolated_explanation": "Just saying that there are some evidence is not a strong argument. ", "isolated_confidence_expl_id": 377, "isolated_explanation_expl_id": 377}, {"id": 78, "label": "string cheese exists (95%)", "id_expl_id": 381, "isolated_confidence": 0.95, "isolated_explanation": "", "isolated_confidence_expl_id": 381, "isolated_explanation_expl_id": 381}], "critical_statement": [{"id": 1, "label": "(98%) not all cheese is round", "id_expl_id": null, "argument_id": 1, "statement_id": 2, "argument_id_expl_id": null, "critical_question_id": 1, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 2, "label": "(100%) many old historic evidence are unreliable", "id_expl_id": null, "argument_id": 3, "statement_id": 5, "argument_id_expl_id": null, "critical_question_id": 2, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 3, "label": "(100%) all cheese has holes", "id_expl_id": null, "argument_id": 4, "statement_id": 6, "argument_id_expl_id": null, "critical_question_id": 1, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 4, "label": "(90%) perfect circles exist in nature", "id_expl_id": null, "argument_id": 5, "statement_id": 7, "argument_id_expl_id": null, "critical_question_id": 1, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 5, "label": "(99%) there are very big heads of cheese", "id_expl_id": null, "argument_id": 12, "statement_id": 8, "argument_id_expl_id": null, "critical_question_id": 2, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 7, "label": "(100%) there are different types of holes", "id_expl_id": null, "argument_id": 4, "statement_id": 11, "argument_id_expl_id": null, "critical_question_id": 1, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 39, "label": "(?) The diameter of the Moon is approx. 3475 km.", "id_expl_id": 348, "argument_id": 12, "statement_id": 55, "argument_id_expl_id": 348, "critical_question_id": 1, "statement_id_expl_id": 348, "critical_question_id_expl_id": 348}, {"id": 40, "label": "(?) The largest cheese wheel ever made had a diameter of 2.4 meters.", "id_expl_id": 350, "argument_id": 12, "statement_id": 56, "argument_id_expl_id": 350, "critical_question_id": 1, "statement_id_expl_id": 350, "critical_question_id_expl_id": 350}, {"id": 41, "label": "(100%) There are darker spots on the Moon as it appears in the night sky. ", "id_expl_id": 384, "argument_id": 4, "statement_id": 59, "argument_id_expl_id": 384, "critical_question_id": 1, "statement_id_expl_id": 384, "critical_question_id_expl_id": 384}], "argument_conditional": [{"id": 4, "id_expl_id": null, "conditional_confidence": 0.2, "conditional_explanation": "This property was not mentioned in previous arguments.", "conditional_confidence_expl_id": null, "conditional_explanation_expl_id": null}, {"id": 5, "id_expl_id": 373, "conditional_confidence": 0.44, "conditional_explanation": "If we know that both of them are not all (yellow and) round it's less likely that they are both perfect circles.", "conditional_confidence_expl_id": 374, "conditional_explanation_expl_id": 374}]}}
2025-04-10 23:03:51.10544+00	700	18	1	73	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 73, "text": "test", "label": "(?) test", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 700, "text_expl_id": 700, "decided_expl_id": 700, "featured_expl_id": 700, "confidence_expl_id": 700, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 700}, "tableName": "statement", "targetLabel": "(?) test"}
2025-04-13 00:22:54.700398+00	766	10	1	8	insertRecord	deed	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 8, "text": "support election of progressive left politicians in the US", "id_expl_id": 766, "text_expl_id": 766}, "tableName": "deed", "targetLabel": "support election of progressive left politicians in the US"}
2025-04-20 17:58:23.74138+00	922	5	1	\N	deleteByIds	invite	{"ids": [14], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "invite", "targetLabel": "14", "deletedRecords": {"invite": [{"id": 14, "code": "WFWGtKkX", "link": "http://localhost:3000/join?code=WFWGtKkX", "owner_id": 5, "person_id": null, "id_expl_id": 705, "code_expl_id": 705, "owner_id_expl_id": 705, "person_id_expl_id": 705}]}}
2025-04-17 01:58:27.078982+00	814	18	1	45	insertRecord	critical_question	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 45, "text": "Could it fit an overlooked category?", "id_expl_id": 814, "text_expl_id": 814, "argument_type_id": 3, "argument_type_id_expl_id": 814}, "tableName": "critical_question", "targetLabel": "Could it fit an overlooked category?"}
2025-04-19 01:27:56.05377+00	863	\N	1	99	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.985}, "before": {"id": 99, "decided": true, "confidence": 0.995, "id_expl_id": 855, "decided_expl_id": 861, "confidence_expl_id": 861}}, "statement": {"id": 99, "text": "clouds is an amplifier of global warming", "id_expl_id": 855, "text_expl_id": 855}, "confidences": [[], [0.7, 0.9]], "triggerLabel": "insert of argument conditional", "triggerExplId": 862, "statementArguments": [{"id": 115, "pro": true, "id_expl_id": 857, "pro_expl_id": 857, "statement_id": 99, "title_expl_id": 857, "argument_type_id": 1, "statement_id_expl_id": 857, "argument_type_id_expl_id": 857}, {"id": 116, "pro": true, "id_expl_id": 858, "pro_expl_id": 858, "statement_id": 99, "title_expl_id": 858, "argument_type_id": 1, "statement_id_expl_id": 858, "argument_type_id_expl_id": 858}], "argumentConfidences": [{"pro": true, "pro_expl_id": 858, "isolated_confidence": 0.9, "conditional_confidence": 0.7, "isolated_confidence_expl_id": 859, "conditional_confidence_expl_id": 862}, {"pro": true, "pro_expl_id": 857, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 860, "conditional_confidence_expl_id": null}]}
2025-04-21 14:59:58.049632+00	977	18	1	14	insertRecord	directive_scope	{"user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "record": {"id": 14, "label": "(+) population of OECD countries", "include": true, "id_expl_id": 977, "directive_id": 124, "include_expl_id": 977, "person_category_id": 4, "directive_id_expl_id": 977, "person_category_id_expl_id": 977}, "tableName": "directive_scope", "targetLabel": "(+) population of OECD countries"}
2025-05-02 22:40:47.522031+00	1004	18	1	18	deleteCrossRecord	person	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 1, "label": "block of flats residents", "tableName": "person_category"}, "record": {"person_id": 18, "person_id_expl_id": 1003, "person_category_id": 1, "person_category_id_expl_id": 1003}, "target": {"id": 18, "label": "Durante", "tableName": "person"}, "userExpl": ""}
2025-05-06 01:14:31.250876+00	1023	5	1	17	insertRecord	invite	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 17, "code": "lOFBOSM2", "link": "/join?code=lOFBOSM2", "owner_id": 5, "person_id": null, "id_expl_id": 1023, "code_expl_id": 1023, "owner_id_expl_id": 1023, "person_id_expl_id": 1023}, "tableName": "invite", "targetLabel": "lOFBOSM2"}
2025-05-06 01:29:05.380317+00	1026	24	1	24	updateRecord	person	{"id": 24, "diff": {"after": {"language": "english"}, "before": {"id": 24, "language": "russian", "id_expl_id": 1024, "language_expl_id": 1025}}, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Демонстрационный пользователь 1"}
2025-05-06 04:18:00.300492+00	1032	24	1	131	updateRecord	statement	{"id": 131, "diff": {"after": {"text": "most people that are part of the closed beta will find this demo useful"}, "before": {"id": 131, "text": "this demo is useful", "id_expl_id": 1030, "text_expl_id": 1030}}, "user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) most people that are part of the closed beta will find this demo useful"}
2025-05-06 04:28:56.545041+00	1034	24	1	132	insertRecord	statement	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 132, "text": "nobody has watched this demo so far ", "label": "(?) nobody has watched this demo so far ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 1034, "text_expl_id": 1034, "decided_expl_id": 1034, "featured_expl_id": 1034, "statement_type_id": 1, "confidence_expl_id": 1034, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1034}, "tableName": "statement", "targetLabel": "(?) nobody has watched this demo so far "}
2025-05-06 04:28:58.693515+00	1035	24	1	94	insertRecord	critical_statement	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 94, "id_expl_id": 1035, "argument_id": 135, "statement_id": 132, "argument_id_expl_id": 1035, "critical_question_id": 36, "statement_id_expl_id": 1035, "critical_question_id_expl_id": 1035}, "tableName": "critical_statement", "targetLabel": 132}
2025-05-13 20:33:55.08062+00	1048	5	1	25	join	person	{"person": {"id": 25, "name": "bot"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-04-09 21:37:46.399836+00	656	5	1	\N	deleteByIds	statement	{"ids": [5, 6, 7, 8, 9, 10, 11, 14, 15, 16, 13, 17, 18, 19, 20, 21, 22, 23, 26, 31, 32, 33, 34, 35, 36, 55, 56, 59, 61], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "these statements were created for testing", "tableName": "statement", "targetLabel": "5, 6, 7, 8, 9, 10, 11, 14, 15, 16, 13, 17, 18, 19, 20, 21, 22, 23, 26, 31, 32, 33, 34, 35, 36, 55, 56, 59, 61", "deletedRecords": {"argument": [{"id": 39, "pro": false, "title": "It's easier to pull banana's leg then dig the tip with your nail. ", "id_expl_id": 133, "pro_expl_id": 133, "statement_id": 34, "title_expl_id": 133, "argument_type_id": 3, "statement_id_expl_id": 133, "argument_type_id_expl_id": 133}, {"id": 24, "pro": true, "title": "Wikipedia says so", "id_expl_id": null, "pro_expl_id": null, "statement_id": 16, "title_expl_id": null, "argument_type_id": 1, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 79, "pro": true, "title": "obvious", "id_expl_id": 386, "pro_expl_id": 386, "statement_id": 59, "title_expl_id": 386, "argument_type_id": 9, "statement_id_expl_id": 386, "argument_type_id_expl_id": 386}, {"id": 13, "pro": true, "title": "luxuries", "id_expl_id": null, "pro_expl_id": null, "statement_id": 9, "title_expl_id": 395, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 56, "pro": false, "title": "Astana is the capital of the world", "id_expl_id": 278, "pro_expl_id": 278, "statement_id": 26, "title_expl_id": 278, "argument_type_id": 3, "statement_id_expl_id": 278, "argument_type_id_expl_id": 278}, {"id": 31, "pro": true, "title": "Wikipedia says so", "id_expl_id": null, "pro_expl_id": null, "statement_id": 26, "title_expl_id": null, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 30, "pro": true, "title": "Wikipedia says so", "id_expl_id": null, "pro_expl_id": null, "statement_id": 23, "title_expl_id": null, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 29, "pro": true, "title": "Wikipedia says so", "id_expl_id": null, "pro_expl_id": null, "statement_id": 22, "title_expl_id": null, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 28, "pro": true, "title": "Wikipedia says so", "id_expl_id": null, "pro_expl_id": null, "statement_id": 21, "title_expl_id": null, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 27, "pro": true, "title": "Wikipedia says so", "id_expl_id": null, "pro_expl_id": null, "statement_id": 20, "title_expl_id": null, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 25, "pro": true, "title": "Wikipedia says so", "id_expl_id": null, "pro_expl_id": null, "statement_id": 18, "title_expl_id": null, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 26, "pro": true, "title": "Wikipedia says so", "id_expl_id": null, "pro_expl_id": null, "statement_id": 19, "title_expl_id": null, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 14, "pro": true, "title": "early retirement", "id_expl_id": null, "pro_expl_id": null, "statement_id": 9, "title_expl_id": 396, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 15, "pro": true, "title": "provide for family", "id_expl_id": null, "pro_expl_id": null, "statement_id": 9, "title_expl_id": 397, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 16, "pro": false, "title": "jail", "id_expl_id": null, "pro_expl_id": null, "statement_id": 9, "title_expl_id": 398, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 57, "pro": false, "title": "Sydney is the capital of Kazakhstan", "id_expl_id": 279, "pro_expl_id": 279, "statement_id": 26, "title_expl_id": 279, "argument_type_id": 3, "statement_id_expl_id": 279, "argument_type_id_expl_id": 279}, {"id": 55, "pro": false, "title": "Astana on Mars", "id_expl_id": 269, "pro_expl_id": 269, "statement_id": 26, "title_expl_id": 281, "argument_type_id": 1, "statement_id_expl_id": 269, "argument_type_id_expl_id": 269}, {"id": 37, "pro": true, "title": "Wikipedia says so", "id_expl_id": 88, "pro_expl_id": 88, "statement_id": 31, "title_expl_id": 88, "argument_type_id": 3, "statement_id_expl_id": 88, "argument_type_id_expl_id": 88}, {"id": 35, "pro": true, "title": "Both start with B", "id_expl_id": 72, "pro_expl_id": 72, "statement_id": 31, "title_expl_id": 72, "argument_type_id": 2, "statement_id_expl_id": 72, "argument_type_id_expl_id": 72}, {"id": 38, "pro": false, "title": "historians use many techniques to ensure that their techniques are reliable ", "id_expl_id": 117, "pro_expl_id": 117, "statement_id": 5, "title_expl_id": 117, "argument_type_id": 3, "statement_id_expl_id": 117, "argument_type_id_expl_id": 117}, {"id": 17, "pro": false, "title": "reputation loss", "id_expl_id": null, "pro_expl_id": null, "statement_id": 9, "title_expl_id": 400, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}, {"id": 19, "pro": false, "title": "career loss", "id_expl_id": null, "pro_expl_id": null, "statement_id": 9, "title_expl_id": 401, "argument_type_id": 3, "statement_id_expl_id": null, "argument_type_id_expl_id": null}], "statement": [{"id": 32, "text": "Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "label": "(100%) Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "decided": true, "featured": false, "confidence": 1, "id_expl_id": 95, "text_expl_id": 95, "decided_expl_id": 97, "featured_expl_id": 95, "confidence_expl_id": 97, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 95}, {"id": 55, "text": "The diameter of the Moon is approx. 3475 km.", "label": "(?) The diameter of the Moon is approx. 3475 km.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 347, "text_expl_id": 347, "decided_expl_id": 347, "featured_expl_id": 347, "confidence_expl_id": 347, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 347}, {"id": 31, "text": "Brussels is the capital of Belgium", "label": "(97%) Brussels is the capital of Belgium", "decided": true, "featured": false, "confidence": 0.965, "id_expl_id": 71, "text_expl_id": 71, "decided_expl_id": 106, "featured_expl_id": 86, "confidence_expl_id": 106, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 71}, {"id": 56, "text": "The largest cheese wheel ever made had a diameter of 2.4 meters.", "label": "(?) The largest cheese wheel ever made had a diameter of 2.4 meters.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 349, "text_expl_id": 349, "decided_expl_id": 349, "featured_expl_id": 349, "confidence_expl_id": 349, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 349}, {"id": 33, "text": "carbon dating is a flawed technique", "label": "(?) carbon dating is a flawed technique", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 118, "text_expl_id": 118, "decided_expl_id": 118, "featured_expl_id": 118, "confidence_expl_id": 118, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 118}, {"id": 34, "text": "Banana must be peeled from the tip", "label": "(?) Banana must be peeled from the tip", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 131, "text_expl_id": 131, "decided_expl_id": 131, "featured_expl_id": 131, "confidence_expl_id": 131, "argument_aggregation_type_id": 2, "argument_aggregation_type_name": "additive", "argument_aggregation_type_id_expl_id": 131}, {"id": 35, "text": "We are humans, not monkeys", "label": "(?) We are humans, not monkeys", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 134, "text_expl_id": 134, "decided_expl_id": 134, "featured_expl_id": 134, "confidence_expl_id": 134, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 134}, {"id": 36, "text": "Bananas don't have legs", "label": "(?) Bananas don't have legs", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 136, "text_expl_id": 136, "decided_expl_id": 136, "featured_expl_id": 136, "confidence_expl_id": 136, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 136}, {"id": 9, "text": "John Smith will take bribes if offered", "label": "(22%) John Smith will take bribes if offered", "decided": true, "featured": false, "confidence": 0.215, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": 408, "featured_expl_id": null, "confidence_expl_id": 408, "argument_aggregation_type_id": 2, "argument_aggregation_type_name": "additive", "argument_aggregation_type_id_expl_id": null}, {"id": 59, "text": "There are darker spots on the Moon as it appears in the night sky. ", "label": "(100%) There are darker spots on the Moon as it appears in the night sky. ", "decided": true, "featured": false, "confidence": 1, "id_expl_id": 383, "text_expl_id": 383, "decided_expl_id": 394, "featured_expl_id": 383, "confidence_expl_id": 394, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 383}, {"id": 61, "text": "test 2", "label": "(?) test 2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 421, "text_expl_id": 421, "decided_expl_id": 421, "featured_expl_id": 421, "confidence_expl_id": 421, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 421}, {"id": 5, "text": "many old historic evidence are unreliable", "label": "(100%) many old historic evidence are unreliable", "decided": true, "featured": false, "confidence": 1, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 6, "text": "all cheese has holes", "label": "(100%) all cheese has holes", "decided": true, "featured": false, "confidence": 1, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 7, "text": "perfect circles exist in nature", "label": "(90%) perfect circles exist in nature", "decided": true, "featured": false, "confidence": 0.9, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 8, "text": "there are very big heads of cheese", "label": "(99%) there are very big heads of cheese", "decided": true, "featured": false, "confidence": 0.99, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 10, "text": "John Smith is a typical politician", "label": "(95%) John Smith is a typical politician", "decided": true, "featured": false, "confidence": 0.95, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 13, "text": "the rule to lock rubbish bins is petty", "label": "(100%) the rule to lock rubbish bins is petty", "decided": true, "featured": false, "confidence": 1, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 11, "text": "there are different types of holes", "label": "(100%) there are different types of holes", "decided": true, "featured": false, "confidence": 1, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 23, "text": "Ankara is the capital of Turkey", "label": "(?) Ankara is the capital of Turkey", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 22, "text": "Tokyo is the capital of Japan", "label": "(90%) Tokyo is the capital of Japan", "decided": true, "featured": false, "confidence": 0.9, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 21, "text": "Seoul is the capital of South Korea", "label": "(66%) Seoul is the capital of South Korea", "decided": true, "featured": false, "confidence": 0.65517, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 20, "text": "Sofia is the capital of Bulgaria", "label": "(49%) Sofia is the capital of Bulgaria", "decided": true, "featured": false, "confidence": 0.48718, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 19, "text": "London is the capital of the United Kingdom", "label": "(44%) London is the capital of the United Kingdom", "decided": true, "featured": false, "confidence": 0.44444, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 18, "text": "Berlin is the capital of Germany", "label": "(?) Berlin is the capital of Germany", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 16, "text": "Paris is the capital of France", "label": "(100%) Paris is the capital of France", "decided": true, "featured": false, "confidence": 1, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 17, "text": "Wikipedia is not always correct", "label": "(100%) Wikipedia is not always correct", "decided": true, "featured": false, "confidence": 1, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 14, "text": "locking rubbish bins cost 3 minutes a week of free time per resident", "label": "(100%) locking rubbish bins cost 3 minutes a week of free time per resident", "decided": true, "featured": false, "confidence": 1, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 15, "text": "locking the bins prevents intruders from creating a mess", "label": "(100%) locking the bins prevents intruders from creating a mess", "decided": true, "featured": false, "confidence": 1, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}, {"id": 26, "text": "Astana is the capital of Kazakhstan", "label": "(85%) Astana is the capital of Kazakhstan", "decided": true, "featured": true, "confidence": 0.85, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "confidence_expl_id": null, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": null}], "argument_other": [{"id": 25, "text": "https://en.wikipedia.org/wiki/Germany", "id_expl_id": null, "text_expl_id": null}, {"id": 26, "text": "https://en.wikipedia.org/wiki/United_Kingdom", "id_expl_id": null, "text_expl_id": null}, {"id": 27, "text": "https://en.wikipedia.org/wiki/List_of_national_capitals", "id_expl_id": null, "text_expl_id": null}, {"id": 28, "text": "https://en.wikipedia.org/wiki/List_of_national_capitals", "id_expl_id": null, "text_expl_id": null}, {"id": 29, "text": "https://en.wikipedia.org/wiki/List_of_national_capitals", "id_expl_id": null, "text_expl_id": null}, {"id": 30, "text": "https://en.wikipedia.org/wiki/List_of_national_capitals", "id_expl_id": null, "text_expl_id": null}, {"id": 31, "text": "https://en.wikipedia.org/wiki/List_of_national_capitals", "id_expl_id": null, "text_expl_id": null}, {"id": 37, "text": "https://en.wikipedia.org/wiki/List_of_national_capitals", "id_expl_id": 88, "text_expl_id": 88}, {"id": 38, "text": "historians use many techniques to ensure that their techniques are reliable ", "id_expl_id": 117, "text_expl_id": 117}, {"id": 39, "text": "monkey says so", "id_expl_id": 133, "text_expl_id": 133}, {"id": 56, "text": "Very cool city.", "id_expl_id": 278, "text_expl_id": 278}, {"id": 57, "text": "Sydney has mountains", "id_expl_id": 279, "text_expl_id": 279}, {"id": 13, "text": "John Smith like many people would like to have luxuries.", "id_expl_id": null, "text_expl_id": 395}, {"id": 14, "text": "John Smith would like to have a nice early retirement.", "id_expl_id": null, "text_expl_id": 396}, {"id": 15, "text": "John Smith would like to provide for his family as much as possible.", "id_expl_id": null, "text_expl_id": 397}, {"id": 16, "text": "John Smith doesn't want to go to jail.", "id_expl_id": null, "text_expl_id": 398}, {"id": 17, "text": "John Smith doesn't want to loose reputation of his family.", "id_expl_id": null, "text_expl_id": 399}, {"id": 19, "text": "John Smith doesn't want to ruin his career.", "id_expl_id": null, "text_expl_id": 401}], "argument_weight": [{"id": 14, "id_expl_id": null, "weight_mode": 20, "weight_explanation": "", "weight_lower_limit": 2, "weight_upper_limit": 40, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 17, "id_expl_id": null, "weight_mode": 20, "weight_explanation": "", "weight_lower_limit": 5, "weight_upper_limit": 35, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 19, "id_expl_id": null, "weight_mode": 20, "weight_explanation": "", "weight_lower_limit": 15, "weight_upper_limit": 40, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 16, "id_expl_id": null, "weight_mode": 60, "weight_explanation": "", "weight_lower_limit": 35, "weight_upper_limit": 90, "weight_mode_expl_id": null, "weight_explanation_expl_id": null, "weight_lower_limit_expl_id": null, "weight_upper_limit_expl_id": null}, {"id": 15, "id_expl_id": 114, "weight_mode": 45, "weight_explanation": "family is often very important", "weight_lower_limit": 0, "weight_upper_limit": 60, "weight_mode_expl_id": 114, "weight_explanation_expl_id": 114, "weight_lower_limit_expl_id": 114, "weight_upper_limit_expl_id": 114}, {"id": 13, "id_expl_id": 403, "weight_mode": 15, "weight_explanation": "Luxuries are often not a must.", "weight_lower_limit": 0, "weight_upper_limit": 50, "weight_mode_expl_id": 407, "weight_explanation_expl_id": 407, "weight_lower_limit_expl_id": 407, "weight_upper_limit_expl_id": 407}], "argument_analogy": [{"id": 35, "text": "Both start with the letter \\"B\\"", "id_expl_id": 72, "text_expl_id": 72}], "argument_obvious": [{"id": 79, "id_expl_id": 386, "obvious_to_majority": true, "majority_is_qualified": true, "obvious_to_majority_expl_id": 386, "majority_is_qualified_expl_id": 386}], "argument_authority": [{"id": 24, "quote": "Capital and largest city:\\nParis 48°51′N 2°21′E", "authority": "Wikipedia is accurate in geography", "id_expl_id": null, "source_url": "France - Wikipedia", "source_title": "https://en.wikipedia.org/wiki/France", "quote_expl_id": null, "authority_expl_id": null, "source_url_expl_id": null, "source_title_expl_id": null}, {"id": 55, "quote": "I saw this Astana in the night sky on Mars.", "authority": "A good friend of mine saw the whole thing.", "id_expl_id": 269, "source_url": "https://www.good-friend-photos-2077.com/astana-at-night", "source_title": "Pictures of a good friend", "quote_expl_id": 281, "authority_expl_id": 281, "source_url_expl_id": 281, "source_title_expl_id": 281}], "argument_judgement": [{"id": 26, "label": "Wikipedia says so (80%)", "id_expl_id": null, "isolated_confidence": 0.8, "isolated_explanation": "Not always doesn't mean often. If there are occasional mistakes it doesn't mean that the source is generally unreliable. ", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null}, {"id": 25, "label": "Wikipedia says so (80%)", "id_expl_id": null, "isolated_confidence": 0.8, "isolated_explanation": "Not always doesn't mean often. If there are occasional mistakes it doesn't mean that the source is generally unreliable.", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null}, {"id": 27, "label": "Wikipedia says so (95%)", "id_expl_id": null, "isolated_confidence": 0.95, "isolated_explanation": "No source is always correct.", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null}, {"id": 28, "label": "Wikipedia says so (90%)", "id_expl_id": null, "isolated_confidence": 0.9, "isolated_explanation": "No source is always correct but some are mostly accurate.", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null}, {"id": 29, "label": "Wikipedia says so (80%)", "id_expl_id": null, "isolated_confidence": 0.8, "isolated_explanation": "No one is always correct", "isolated_confidence_expl_id": null, "isolated_explanation_expl_id": null}, {"id": 37, "label": "Wikipedia says so (80%)", "id_expl_id": 94, "isolated_confidence": 0.8, "isolated_explanation": "Not always correct doesn't mean not often correct.", "isolated_confidence_expl_id": 94, "isolated_explanation_expl_id": 94}, {"id": 35, "label": "Both start with B (30%)", "id_expl_id": 100, "isolated_confidence": 0.3, "isolated_explanation": "this seems like a weak argument", "isolated_confidence_expl_id": 100, "isolated_explanation_expl_id": 100}, {"id": 55, "label": "Astana on Mars (60%)", "id_expl_id": 361, "isolated_confidence": 0.6, "isolated_explanation": "Good friends don't lie but they may boast", "isolated_confidence_expl_id": 364, "isolated_explanation_expl_id": 364}, {"id": 56, "label": "Astana is the capital of the world (1%)", "id_expl_id": 366, "isolated_confidence": 0.01, "isolated_explanation": "Capitals are often cool cities, but there are much fewer capitals than cool cities.", "isolated_confidence_expl_id": 369, "isolated_explanation_expl_id": 369}, {"id": 31, "label": "Wikipedia says so (70%)", "id_expl_id": null, "isolated_confidence": 0.7, "isolated_explanation": "Not always does not mean often. It could be mostly correct.", "isolated_confidence_expl_id": 372, "isolated_explanation_expl_id": 372}, {"id": 79, "label": "obvious (100%)", "id_expl_id": 387, "isolated_confidence": 1, "isolated_explanation": "Everyone who talked about it confirmed it and never expressed doubt.", "isolated_confidence_expl_id": 393, "isolated_explanation_expl_id": 393}], "critical_statement": [{"id": 6, "label": "(95%) John Smith is a typical politician", "id_expl_id": null, "argument_id": 13, "statement_id": 10, "argument_id_expl_id": null, "critical_question_id": 2, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 8, "label": "(100%) Wikipedia is not always correct", "id_expl_id": null, "argument_id": 25, "statement_id": 17, "argument_id_expl_id": null, "critical_question_id": 2, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 9, "label": "(100%) Wikipedia is not always correct", "id_expl_id": null, "argument_id": 26, "statement_id": 17, "argument_id_expl_id": null, "critical_question_id": 2, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 10, "label": "(100%) Wikipedia is not always correct", "id_expl_id": null, "argument_id": 27, "statement_id": 17, "argument_id_expl_id": null, "critical_question_id": 2, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 11, "label": "(100%) Wikipedia is not always correct", "id_expl_id": null, "argument_id": 28, "statement_id": 17, "argument_id_expl_id": null, "critical_question_id": 2, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 12, "label": "(100%) Wikipedia is not always correct", "id_expl_id": null, "argument_id": 29, "statement_id": 17, "argument_id_expl_id": null, "critical_question_id": 2, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 13, "label": "(100%) Wikipedia is not always correct", "id_expl_id": null, "argument_id": 30, "statement_id": 17, "argument_id_expl_id": null, "critical_question_id": 2, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 14, "label": "(100%) Wikipedia is not always correct", "id_expl_id": null, "argument_id": 31, "statement_id": 17, "argument_id_expl_id": null, "critical_question_id": 2, "statement_id_expl_id": null, "critical_question_id_expl_id": null}, {"id": 15, "label": "(100%) Wikipedia is not always correct", "id_expl_id": 89, "argument_id": 37, "statement_id": 17, "argument_id_expl_id": 89, "critical_question_id": 2, "statement_id_expl_id": 89, "critical_question_id_expl_id": 89}, {"id": 16, "label": "(100%) Both \\"Brussels\\" and \\"Belgium\\" start with the letter \\"B\\"", "id_expl_id": 98, "argument_id": 35, "statement_id": 32, "argument_id_expl_id": 98, "critical_question_id": 1, "statement_id_expl_id": 98, "critical_question_id_expl_id": 98}, {"id": 17, "label": "(?) carbon dating is a flawed technique", "id_expl_id": 119, "argument_id": 38, "statement_id": 33, "argument_id_expl_id": 119, "critical_question_id": 2, "statement_id_expl_id": 119, "critical_question_id_expl_id": 119}, {"id": 18, "label": "(?) We are humans, not monkeys", "id_expl_id": 135, "argument_id": 39, "statement_id": 35, "argument_id_expl_id": 135, "critical_question_id": 2, "statement_id_expl_id": 135, "critical_question_id_expl_id": 135}, {"id": 19, "label": "(?) Bananas don't have legs", "id_expl_id": 137, "argument_id": 39, "statement_id": 36, "argument_id_expl_id": 137, "critical_question_id": 2, "statement_id_expl_id": 137, "critical_question_id_expl_id": 137}]}}
2025-04-10 23:04:12.13954+00	701	18	1	73	updateRecord	statement	{"id": 73, "diff": {"after": {"text": "test 2"}, "before": {"id": 73, "text": "test", "text_expl_id": 700}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) test 2"}
2025-04-13 00:22:57.949999+00	767	10	1	89	insertExtRecord	statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 89, "text": "", "label": "(?)  should ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 767, "text_expl_id": 767, "decided_expl_id": 767, "featured_expl_id": 767, "statement_type_id": 3, "confidence_expl_id": 767, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 767}, "extRecord": {"id": 89, "deed_id": 8, "id_expl_id": 767, "deed_id_expl_id": 767}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-05-02 22:47:32.757581+00	1007	18	1	13	deleteById	moral_weight_of_profile	{"id": 13, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(-4 / misplaced item / m³) mess", "deletedRecords": {"moral_weight_of_profile": [{"id": 13, "label": "(-4 / misplaced item / m³) mess", "weight": -4, "id_expl_id": 557, "profile_id": 1, "moral_good_id": 1, "weight_expl_id": 556, "profile_id_expl_id": 557, "moral_good_id_expl_id": 556}]}}
2025-04-17 02:08:20.95525+00	815	18	1	56	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 56, "label": "(100%) there was a beard tax", "id_expl_id": 815, "argument_id": 108, "statement_id": 12, "argument_id_expl_id": 815, "critical_question_id": 33, "statement_id_expl_id": 815, "critical_question_id_expl_id": 815}, "tableName": "critical_statement", "targetLabel": "(100%) there was a beard tax"}
2025-04-19 01:28:52.623488+00	865	\N	1	99	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.925}, "before": {"id": 99, "decided": true, "confidence": 0.985, "id_expl_id": 855, "decided_expl_id": 863, "confidence_expl_id": 863}}, "statement": {"id": 99, "text": "clouds is an amplifier of global warming", "id_expl_id": 855, "text_expl_id": 855}, "confidences": [[], [0.7, 0.5]], "triggerLabel": "update of argument judgement", "triggerExplId": 864, "statementArguments": [{"id": 115, "pro": true, "id_expl_id": 857, "pro_expl_id": 857, "statement_id": 99, "title_expl_id": 857, "argument_type_id": 1, "statement_id_expl_id": 857, "argument_type_id_expl_id": 857}, {"id": 116, "pro": true, "id_expl_id": 858, "pro_expl_id": 858, "statement_id": 99, "title_expl_id": 858, "argument_type_id": 1, "statement_id_expl_id": 858, "argument_type_id_expl_id": 858}], "argumentConfidences": [{"pro": true, "pro_expl_id": 858, "isolated_confidence": 0.9, "conditional_confidence": 0.7, "isolated_confidence_expl_id": 859, "conditional_confidence_expl_id": 862}, {"pro": true, "pro_expl_id": 857, "isolated_confidence": 0.5, "conditional_confidence": null, "isolated_confidence_expl_id": 864, "conditional_confidence_expl_id": null}]}
2025-04-19 01:28:52.349913+00	864	11	1	115	updateRecord	argument_judgement	{"id": 115, "diff": {"after": {"isolated_confidence": "0.50000", "isolated_explanation": "The cited confidence is large, but it's only one study."}, "before": {"id": 115, "id_expl_id": 860, "isolated_confidence": 0.9, "isolated_explanation": "The cited confidence is large, but it's only one study.", "isolated_confidence_expl_id": 860, "isolated_explanation_expl_id": 860}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "userExpl": "Just one study on its own should't give so much confidence.", "tableName": "argument_judgement", "targetLabel": "2021 observations study (50%)"}
2025-04-20 17:58:25.144723+00	923	5	1	15	insertRecord	invite	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 15, "code": "Gn5CaqWp", "link": "http://localhost:3000/join?code=Gn5CaqWp", "owner_id": 5, "person_id": null, "id_expl_id": 923, "code_expl_id": 923, "owner_id_expl_id": 923, "person_id_expl_id": 923}, "tableName": "invite", "targetLabel": "Gn5CaqWp"}
2025-04-19 01:32:25.057833+00	866	11	1	45	insertRecord	argument_judgement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 45, "label": "clouds & vapour (5%)", "id_expl_id": 866, "isolated_confidence": 0.05, "isolated_explanation": "It's no longer such a big unknown and progress can be made without high certainty anyway. ", "isolated_confidence_expl_id": 866, "isolated_explanation_expl_id": 866}, "tableName": "argument_judgement", "targetLabel": "clouds & vapour (5%)"}
2025-04-20 18:14:38.383581+00	924	5	1	22	join	person	{"person": {"id": 22, "name": "Puma"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-04-20 18:26:47.819838+00	928	22	1	114	insertCrossRecords	statement	{"id": 114, "user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 927}, "fkEnries": {"tags": {"options": [{"id": 27, "label": "animal rights"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?)  should кушать животных"}
2025-04-21 15:01:17.623997+00	978	18	1	5	updateRecord	person_category	{"id": 5, "diff": {"after": {"name": "everyone"}, "before": {"id": 5, "name": "everyone ", "id_expl_id": 690, "name_expl_id": 690}}, "user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "userExpl": "", "tableName": "person_category", "targetLabel": "everyone"}
2025-05-02 22:47:15.316119+00	1005	18	1	18	insertCrossRecord	person	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 1, "label": "block of flats residents", "tableName": "person_category"}, "record": {"person_id": 18, "person_id_expl_id": 1005, "person_category_id": 1, "person_category_id_expl_id": 1005}, "target": {"id": 18, "label": "Durante", "tableName": "person"}}
2025-12-12 06:18:47.02901+00	1858	5	1	36	join	person	{"person": {"id": 36, "name": "Ian"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-05-06 01:21:20.434223+00	1024	5	1	24	join	person	{"person": {"id": 24, "name": "Demo User 1"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-04-09 21:39:23.014641+00	657	5	1	66	deleteById	statement	{"id": 66, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) ", "deletedRecords": {"directive": [{"id": 66, "label": "(?) block of flats residents should recycle rubbish", "deed_id": 3, "id_expl_id": 527, "deed_id_expl_id": 530}], "statement": [{"id": 66, "text": "", "label": "(?) ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 527, "text_expl_id": 527, "decided_expl_id": 527, "featured_expl_id": 527, "confidence_expl_id": 527, "argument_aggregation_type_id": 3, "argument_aggregation_type_name": "normative", "argument_aggregation_type_id_expl_id": 527}], "directive_scope": [{"id": 5, "label": "(+) block of flats residents", "include": true, "id_expl_id": 528, "directive_id": 66, "include_expl_id": 528, "person_category_id": 1, "directive_id_expl_id": 528, "person_category_id_expl_id": 528}]}}
2025-04-09 21:44:50.004152+00	663	5	1	15	updateRecord	tag	{"id": 15, "diff": {"after": {"name": "meta"}, "before": {"id": 15, "name": "Apollo", "name_expl_id": 512}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "tag", "targetLabel": "meta"}
2025-04-10 23:04:22.539122+00	702	18	1	73	deleteById	statement	{"id": 73, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) test 2", "deletedRecords": {"statement": [{"id": 73, "text": "test 2", "label": "(?) test 2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 700, "text_expl_id": 701, "decided_expl_id": 700, "featured_expl_id": 700, "confidence_expl_id": 700, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 700}]}}
2025-04-13 00:22:58.236822+00	768	10	1	89	insertCrossRecords	statement	{"id": 89, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 767}, "fkEnries": {"tags": {"options": [{"id": 26, "label": "US politics"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?)  should support election of progressive left politicians in the US"}
2025-04-17 21:02:11.603501+00	816	18	1	18	updateRecord	person	{"id": 18, "diff": {"after": {"language": "russian"}, "before": {"id": 18, "language": "english", "id_expl_id": 504, "language_expl_id": 504}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Durante"}
2025-04-19 13:46:10.070748+00	867	11	1	117	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 117, "pro": true, "title": "Mike's own explanation", "id_expl_id": 867, "pro_expl_id": 867, "statement_id": 49, "title_expl_id": 867, "argument_type_id": 1, "statement_id_expl_id": 867, "argument_type_id_expl_id": 867}, "extRecord": {"id": 117, "quote": "well and what he was referring to was\\njust a clever way to compare these paleo\\nclimate temperature reconstructions that\\ngo back in a thousand years with the\\nmodern warming shown in the instrumental\\nrecord because the Paleo climate data\\nactually don't come up to the present\\nbecause many of them many of these\\ncorals and tree rings were obtained back\\nin you know the 1970s or the 1980s and\\nso they don't come up to the present so\\nif you want a complete depiction of\\nwhat's happening you wouldn't stop at\\n1980 you would also show\\nwhat we know happens since 1980 because\\nwe do have thermometer records since\\n1980 adding in the REO temperatures in\\neach of the story series and so that's\\nwhat he was doing finding a way to show\\nboth pieces of information together so\\nthat you got the whole picture this was", "authority": "Mike Mann is the \\"Mike\\" whose trick was referred to ", "id_expl_id": 867, "source_url": "https://www.youtube.com/watch?v=02eF9W_u1nI", "source_title": "Mike Mann in his Own Words: 'Nature Trick\\" and 'Hide the Decline\\"", "quote_expl_id": 867, "authority_expl_id": 867, "source_url_expl_id": 867, "source_title_expl_id": 867}, "tableName": "argument", "targetLabel": "Mike's own explanation", "extTableName": "argument_authority"}
2025-04-20 18:47:35.560763+00	933	22	1	78	insertRecord	critical_statement	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 78, "label": "(?) Человек — это разумное животное", "id_expl_id": 933, "argument_id": 126, "statement_id": 115, "argument_id_expl_id": 933, "critical_question_id": 1, "statement_id_expl_id": 933, "critical_question_id_expl_id": 933}, "tableName": "critical_statement", "targetLabel": "(?) Человек — это разумное животное"}
2025-04-20 18:25:00.718737+00	925	22	1	9	insertRecord	deed	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 9, "text": "кушать животных", "id_expl_id": 925, "text_expl_id": 925}, "tableName": "deed", "targetLabel": "кушать животных"}
2025-04-20 18:27:35.75198+00	929	22	1	11	insertRecord	directive_scope	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 11, "label": "(+) все", "include": true, "id_expl_id": 929, "directive_id": 114, "include_expl_id": 929, "person_category_id": 5, "directive_id_expl_id": 929, "person_category_id_expl_id": 929}, "tableName": "directive_scope", "targetLabel": "(+) все"}
2025-04-20 18:46:14.404062+00	931	22	1	126	updateExtRecord	argument	{"id": 126, "user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"text": "Животных допустимо есть, потому что они не обладают разумом и нравственным сознанием и находятся ниже человека в иерархии. "}, "before": {"id": 126, "text": "У животных нет морали, значит кушать их это морально допустимо. ", "id_expl_id": 930, "text_expl_id": 930}}, "tableName": "argument", "targetLabel": "Нет морали у животных", "extTableName": "argument_deduction"}
2025-04-20 19:05:24.513644+00	945	23	1	118	insertRecord	statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 118, "text": "", "label": "(?) ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 945, "text_expl_id": 945, "decided_expl_id": 945, "featured_expl_id": 945, "statement_type_id": 1, "confidence_expl_id": 945, "statement_type_name": "descriptive", "statement_type_id_expl_id": 945}, "tableName": "statement", "targetLabel": "(?) "}
2025-04-09 21:40:30.973656+00	658	5	1	67	updateRecord	statement	{"id": 67, "diff": {"after": {"featured": false}, "before": {"id": 67, "featured": true, "featured_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) "}
2025-04-10 23:18:21.394267+00	703	18	1	74	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 74, "text": "test", "label": "(?) test", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 703, "text_expl_id": 703, "decided_expl_id": 703, "featured_expl_id": 703, "confidence_expl_id": 703, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 703}, "tableName": "statement", "targetLabel": "(?) test"}
2025-04-10 23:36:27.897976+00	705	5	1	14	insertRecord	invite	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 14, "code": "WFWGtKkX", "link": "http://localhost:3000/join?code=WFWGtKkX", "owner_id": 5, "person_id": null, "id_expl_id": 705, "code_expl_id": 705, "owner_id_expl_id": 705, "person_id_expl_id": 705}, "tableName": "invite", "targetLabel": "WFWGtKkX"}
2025-04-13 00:23:06.710437+00	769	10	1	10	insertRecord	directive_scope	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 10, "label": "(+) US citizens", "include": true, "id_expl_id": 769, "directive_id": 89, "include_expl_id": 769, "person_category_id": 3, "directive_id_expl_id": 769, "person_category_id_expl_id": 769}, "tableName": "directive_scope", "targetLabel": "(+) US citizens"}
2025-04-18 00:15:46.472861+00	817	18	1	31	updateRecord	argument_grading_example	{"id": 31, "diff": {"after": {"argument": "Сегодня я видел как один подросток намусорил.", "conclusion": "Подростки, как правило, небрежные."}, "before": {"id": 31, "argument": "Сегодня я видел один помет у подростка.", "conclusion": "Подростки, как правило, беспечны.", "id_expl_id": null, "argument_expl_id": null, "conclusion_expl_id": null}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_grading_example", "targetLabel": "Сегодня я видел как один подросток намусорил."}
2025-05-06 04:51:05.589148+00	1042	24	1	133	insertExtRecord	statement	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 133, "text": "", "label": "(?)  should ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 1042, "text_expl_id": 1042, "decided_expl_id": 1042, "featured_expl_id": 1042, "statement_type_id": 3, "confidence_expl_id": 1042, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 1042}, "extRecord": {"id": 133, "deed_id": 11, "id_expl_id": 1042, "deed_id_expl_id": 1042}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-04-19 20:00:38.775866+00	868	10	1	100	insertRecord	statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 100, "text": "IPCC is biased towards alarmism", "label": "(?) IPCC is biased towards alarmism", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 868, "text_expl_id": 868, "decided_expl_id": 868, "featured_expl_id": 868, "statement_type_id": 1, "confidence_expl_id": 868, "statement_type_name": "descriptive", "statement_type_id_expl_id": 868}, "tableName": "statement", "targetLabel": "(?) IPCC is biased towards alarmism"}
2025-04-20 18:26:26.39586+00	926	22	1	27	insertRecord	tag	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 27, "name": "animal rights", "id_expl_id": 926, "description": "", "name_expl_id": 926, "description_expl_id": 926}, "tableName": "tag", "targetLabel": "animal rights"}
2025-04-21 15:01:35.706675+00	979	18	1	13	deleteById	directive_scope	{"id": 13, "user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "userExpl": "", "tableName": "directive_scope", "targetLabel": "(+) everyone", "deletedRecords": {"directive_scope": [{"id": 13, "label": "(+) everyone", "include": true, "id_expl_id": 976, "directive_id": 124, "include_expl_id": 976, "person_category_id": 5, "directive_id_expl_id": 976, "person_category_id_expl_id": 976}]}}
2025-05-02 22:47:29.421782+00	1006	18	1	12	deleteById	moral_weight_of_profile	{"id": 12, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(-2 / upheld) following petty rules", "deletedRecords": {"moral_weight_of_profile": [{"id": 12, "label": "(-2 / upheld) following petty rules", "weight": -2, "id_expl_id": 554, "profile_id": 1, "moral_good_id": 3, "weight_expl_id": 555, "profile_id_expl_id": 554, "moral_good_id_expl_id": 553}]}}
2025-05-06 01:28:20.939486+00	1025	24	1	24	updateRecord	person	{"id": 24, "diff": {"after": {"language": "russian"}, "before": {"id": 24, "language": "english", "id_expl_id": 1024, "language_expl_id": 1024}}, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Demo User 1"}
2025-05-06 04:27:08.06181+00	1033	24	1	135	insertExtRecord	argument	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 135, "pro": true, "title": "get people unstuck", "id_expl_id": 1033, "pro_expl_id": 1033, "statement_id": 131, "title_expl_id": 1033, "argument_type_id": 13, "statement_id_expl_id": 1033, "argument_type_id_expl_id": 1033}, "extRecord": {"id": 135, "text": "The platform is rough around the edges. Many will get stuck without the demo.", "id_expl_id": 1033, "text_expl_id": 1033}, "tableName": "argument", "targetLabel": "get people unstuck", "extTableName": "argument_causal"}
2025-05-06 04:30:18.655824+00	1036	24	1	136	insertExtRecord	argument	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 136, "pro": true, "title": "not published", "id_expl_id": 1036, "pro_expl_id": 1036, "statement_id": 132, "title_expl_id": 1036, "argument_type_id": 6, "statement_id_expl_id": 1036, "argument_type_id_expl_id": 1036}, "extRecord": {"id": 136, "text": "The demo was not published yet.", "id_expl_id": 1036, "text_expl_id": 1036}, "tableName": "argument", "targetLabel": "not published", "extTableName": "argument_deduction"}
2025-04-09 21:41:06.872398+00	659	5	1	17	insertRecord	tag	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 17, "name": "example", "id_expl_id": 659, "name_expl_id": 659}, "tableName": "tag", "targetLabel": "example"}
2025-04-09 21:41:29.845589+00	661	5	1	67	insertCrossRecord	statement	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "cross": {"id": 17, "label": "example", "tableName": "tag"}, "record": {"tag_id": 17, "statement_id": 67, "tag_id_expl_id": 661, "statement_id_expl_id": 661}, "target": {"id": 67, "label": "(?) ", "tableName": "statement"}}
2025-04-10 23:19:51.335091+00	704	18	1	74	deleteById	statement	{"id": 74, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) test", "deletedRecords": {"statement": [{"id": 74, "text": "test", "label": "(?) test", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 703, "text_expl_id": 703, "decided_expl_id": 703, "featured_expl_id": 703, "confidence_expl_id": 703, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 703}]}}
2025-04-13 00:35:16.648289+00	770	10	1	103	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 103, "pro": false, "title": "castrating children", "id_expl_id": 770, "pro_expl_id": 770, "statement_id": 89, "title_expl_id": 770, "argument_type_id": 10, "statement_id_expl_id": 770, "argument_type_id_expl_id": 770}, "extRecord": {"id": 103, "text": "Progressive left policies on gender reassignment put children in grave danger.\\n- Irreversible medical interventions: Hormone treatments and surgeries can cause permanent changes such as infertility, and some children may later regret these decisions.\\n- Undermining parental rights: Policies that limit parents' involvement in gender-related decisions risk excluding those who know and care for the child most.\\n- Psychological confusion: Encouraging early gender transition may reinforce identity struggles rather than addressing underlying mental health issues.\\n- Social pressure and ideology: Children may be influenced by cultural trends or peer pressure rather than making informed, autonomous decisions.", "id_expl_id": 770, "text_expl_id": 770}, "tableName": "argument", "targetLabel": "castrating children", "extTableName": "argument_normative"}
2025-04-18 00:20:13.410107+00	818	18	1	109	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 109, "pro": false, "title": "пример теста", "id_expl_id": 818, "pro_expl_id": 818, "statement_id": 90, "title_expl_id": 818, "argument_type_id": 8, "statement_id_expl_id": 818, "argument_type_id_expl_id": 818}, "extRecord": {"id": 109, "text": "Камар пьёт кровь.", "id_expl_id": 818, "text_expl_id": 818}, "tableName": "argument", "targetLabel": "пример теста", "extTableName": "argument_example"}
2025-04-20 18:26:47.804011+00	927	22	1	114	insertExtRecord	statement	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 114, "text": "", "label": "(?)  should ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 927, "text_expl_id": 927, "decided_expl_id": 927, "featured_expl_id": 927, "statement_type_id": 3, "confidence_expl_id": 927, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 927}, "extRecord": {"id": 114, "deed_id": 9, "id_expl_id": 927, "deed_id_expl_id": 927}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-04-19 20:21:53.182267+00	869	10	1	118	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 118, "pro": true, "title": "Glaciergate", "id_expl_id": 869, "pro_expl_id": 869, "statement_id": 100, "title_expl_id": 869, "argument_type_id": 8, "statement_id_expl_id": 869, "argument_type_id_expl_id": 869}, "extRecord": {"id": 118, "text": "IPCC claimed that Himalayan glaciers could disappear by 2035. This dramatic assertion was not backed by peer-reviewed science. IPCC chief Dr. Rajendra Pachauri had even dismissed an Indian government report challenging the glacier claim as “voodoo science”.", "id_expl_id": 869, "text_expl_id": 869}, "tableName": "argument", "targetLabel": "Glaciergate", "extTableName": "argument_example"}
2025-04-22 02:44:39.950872+00	980	18	1	125	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 125, "text": "st2", "label": "(?) st2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 980, "text_expl_id": 980, "decided_expl_id": 980, "featured_expl_id": 980, "statement_type_id": 1, "confidence_expl_id": 980, "statement_type_name": "descriptive", "statement_type_id_expl_id": 980}, "tableName": "statement", "targetLabel": "(?) st2"}
2025-04-22 02:45:01.314452+00	983	18	1	89	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 89, "id_expl_id": 983, "argument_id": 105, "statement_id": 126, "argument_id_expl_id": 983, "critical_question_id": 1, "statement_id_expl_id": 983, "critical_question_id_expl_id": 983}, "tableName": "critical_statement", "targetLabel": 126}
2025-05-02 22:47:35.72743+00	1008	18	1	14	deleteById	moral_weight_of_profile	{"id": 14, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(15 / minute) free time", "deletedRecords": {"moral_weight_of_profile": [{"id": 14, "label": "(15 / minute) free time", "weight": 15, "id_expl_id": 559, "profile_id": 1, "moral_good_id": 2, "weight_expl_id": 558, "profile_id_expl_id": 559, "moral_good_id_expl_id": 558}]}}
2025-05-02 22:50:45.084511+00	1010	18	1	2	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 2, "label": "(-2 / upheld) following petty rules", "weight": -2, "id_expl_id": 1010, "profile_id": 1, "moral_good_id": 3, "weight_expl_id": 1010, "profile_id_expl_id": 1010, "moral_good_id_expl_id": 1010}, "tableName": "moral_weight_of_profile", "targetLabel": "(-2 / upheld) following petty rules"}
2025-06-26 19:12:43.631087+00	1171	18	1	18	updateRecord	person	{"id": 18, "diff": {"after": {"language": "russian"}, "before": {"id": 18, "language": "english", "id_expl_id": 504, "language_expl_id": 972}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Durante"}
2025-04-09 21:41:23.632896+00	660	5	1	67	deleteCrossRecord	statement	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "cross": {"id": 3, "label": "housing", "tableName": "tag"}, "record": {"tag_id": 3, "statement_id": 67, "tag_id_expl_id": 533, "statement_id_expl_id": 533}, "target": {"id": 67, "label": "(?) ", "tableName": "statement"}, "userExpl": ""}
2025-04-11 02:06:03.767808+00	706	18	1	20	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 20, "name": "test tag", "id_expl_id": 706, "description": " ", "name_expl_id": 706, "description_expl_id": 706}, "tableName": "tag", "targetLabel": "test tag"}
2025-04-13 01:00:49.7938+00	771	13	1	104	insertExtRecord	argument	{"user": {"id": 13, "name": "Megan", "auth_role": "invited"}, "record": {"id": 104, "pro": true, "title": "greening of the Earth", "id_expl_id": 771, "pro_expl_id": 771, "statement_id": 68, "title_expl_id": 771, "argument_type_id": 4, "statement_id_expl_id": 771, "argument_type_id_expl_id": 771}, "extRecord": {"id": 104, "text": "Lifting restrictions would increase fossil fuel extraction, production and consumption.\\nThis would lead to higher greenhouse gas emissions.\\nThis will make more CO2 available for the growth of the plants.\\nBigger areas of the Earth will have more and bigger plants.\\nThis will support more animal and human habitats. ", "id_expl_id": 771, "text_expl_id": 771}, "tableName": "argument", "targetLabel": "greening of the Earth", "extTableName": "argument_explanation"}
2025-04-18 02:54:11.66137+00	819	18	1	18	updateRecord	person	{"id": 18, "diff": {"after": {"language": "english"}, "before": {"id": 18, "language": "russian", "id_expl_id": 504, "language_expl_id": 816}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Дуранте"}
2025-04-19 20:23:56.75392+00	870	10	1	101	insertRecord	statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 101, "text": "IPCC claimed that Himalayan glaciers could disappear by 2035.", "label": "(?) IPCC claimed that Himalayan glaciers could disappear by 2035.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 870, "text_expl_id": 870, "decided_expl_id": 870, "featured_expl_id": 870, "statement_type_id": 1, "confidence_expl_id": 870, "statement_type_name": "descriptive", "statement_type_id_expl_id": 870}, "tableName": "statement", "targetLabel": "(?) IPCC claimed that Himalayan glaciers could disappear by 2035."}
2025-04-20 18:36:47.762507+00	930	22	1	126	insertExtRecord	argument	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 126, "pro": true, "title": "Нет морали у животных", "id_expl_id": 930, "pro_expl_id": 930, "statement_id": 114, "title_expl_id": 930, "argument_type_id": 6, "statement_id_expl_id": 930, "argument_type_id_expl_id": 930}, "extRecord": {"id": 126, "text": "У животных нет морали, значит кушать их это морально допустимо. ", "id_expl_id": 930, "text_expl_id": 930}, "tableName": "argument", "targetLabel": "Нет морали у животных", "extTableName": "argument_deduction"}
2025-04-20 18:53:00.421788+00	934	22	1	127	insertExtRecord	argument	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 127, "pro": true, "title": "Человек — это разумное животное ", "id_expl_id": 934, "pro_expl_id": 934, "statement_id": 115, "title_expl_id": 934, "argument_type_id": 1, "statement_id_expl_id": 934, "argument_type_id_expl_id": 934}, "extRecord": {"id": 127, "quote": "\\"Человек — это разумное животное (zoon logikon).\\"\\nАристотель", "authority": "Он создал полную мировозренческую систему, которая влияет на нашу жизнь до сих пор. ", "id_expl_id": 934, "source_url": "https://historyofeconomicthought.mcmaster.ca/aristotle/Ethics.pdf", "source_title": "Никомаховоя этика", "quote_expl_id": 934, "authority_expl_id": 934, "source_url_expl_id": 934, "source_title_expl_id": 934}, "tableName": "argument", "targetLabel": "Человек — это разумное животное ", "extTableName": "argument_authority"}
2025-04-20 18:57:06.843253+00	938	22	1	128	updateExtRecord	argument	{"id": 128, "user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"source_url": "https://historyofeconomicthought.mcmaster.ca/aristotle/Politics.pdf"}, "before": {"id": 128, "id_expl_id": 937, "source_url": "Книга", "source_url_expl_id": 937}}, "tableName": "argument", "targetLabel": "Животные — лишены разума", "extTableName": "argument_authority"}
2025-04-22 02:44:50.524364+00	981	18	1	88	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 88, "id_expl_id": 981, "argument_id": 105, "statement_id": 125, "argument_id_expl_id": 981, "critical_question_id": 1, "statement_id_expl_id": 981, "critical_question_id_expl_id": 981}, "tableName": "critical_statement", "targetLabel": 125}
2025-05-02 22:50:35.805848+00	1009	18	1	1	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 1, "label": "(15 / minute) free time", "weight": 15, "id_expl_id": 1009, "profile_id": 1, "moral_good_id": 2, "weight_expl_id": 1009, "profile_id_expl_id": 1009, "moral_good_id_expl_id": 1009}, "tableName": "moral_weight_of_profile", "targetLabel": "(15 / minute) free time"}
2025-05-02 22:50:59.986155+00	1012	18	1	10	deleteById	moral_weight_of_person	{"id": 10, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_person", "targetLabel": "(10 / minute) free time", "deletedRecords": {"moral_weight_of_person": [{"id": 10, "label": "(10 / minute) free time", "weight": 10, "owner_id": 18, "id_expl_id": 1000, "moral_good_id": 2, "weight_expl_id": 1000, "owner_id_expl_id": 1000, "moral_good_id_expl_id": 1000}]}}
2025-05-06 04:50:27.413739+00	1041	24	1	11	insertRecord	deed	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 11, "text": "watch the demo of the mind of Apollo", "id_expl_id": 1041, "text_expl_id": 1041}, "tableName": "deed", "targetLabel": "watch the demo of the mind of Apollo"}
2025-04-09 21:43:25.873643+00	662	5	1	\N	deleteByIds	tag	{"ids": [1, 3, 4, 2, 16], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "unused tags", "tableName": "tag", "targetLabel": "1, 3, 4, 2, 16", "deletedRecords": {"tag": [{"id": 1, "name": "silly", "id_expl_id": null, "name_expl_id": null}, {"id": 2, "name": "science", "id_expl_id": null, "name_expl_id": null}, {"id": 3, "name": "housing", "id_expl_id": null, "name_expl_id": null}, {"id": 4, "name": "politics", "id_expl_id": null, "name_expl_id": null}, {"id": 16, "name": "test", "id_expl_id": 531, "name_expl_id": 531}]}}
2025-04-11 19:19:06.39442+00	707	18	1	67	insertCrossRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 15, "label": "meta", "tableName": "tag"}, "record": {"tag_id": 15, "statement_id": 67, "tag_id_expl_id": 707, "statement_id_expl_id": 707}, "target": {"id": 67, "label": "(?) block of flats residents should lock rubbish bins", "tableName": "statement"}}
2025-04-13 01:48:35.880995+00	772	18	1	90	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 90, "text": "test st", "label": "(?) test st", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 772, "text_expl_id": 772, "decided_expl_id": 772, "featured_expl_id": 772, "statement_type_id": 1, "confidence_expl_id": 772, "statement_type_name": "descriptive", "statement_type_id_expl_id": 772}, "tableName": "statement", "targetLabel": "(?) test st"}
2025-04-18 15:25:29.683706+00	820	11	1	91	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 91, "text": "penicillin was used extensively to treat bacterial infections before the mechanism behind its action was fully understood", "label": "(?) penicillin was used extensively to treat bacterial infections before the mechanism behind its action was fully understood", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 820, "text_expl_id": 820, "decided_expl_id": 820, "featured_expl_id": 820, "statement_type_id": 1, "confidence_expl_id": 820, "statement_type_name": "descriptive", "statement_type_id_expl_id": 820}, "tableName": "statement", "targetLabel": "(?) penicillin was used extensively to treat bacterial infections before the mechanism behind its action was fully understood"}
2025-04-20 18:47:30.809019+00	932	22	1	115	insertRecord	statement	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 115, "text": "Человек — это разумное животное", "label": "(?) Человек — это разумное животное", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 932, "text_expl_id": 932, "decided_expl_id": 932, "featured_expl_id": 932, "statement_type_id": 1, "confidence_expl_id": 932, "statement_type_name": "descriptive", "statement_type_id_expl_id": 932}, "tableName": "statement", "targetLabel": "(?) Человек — это разумное животное"}
2025-04-19 20:23:58.83201+00	871	10	1	63	insertRecord	critical_statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 63, "label": "(?) IPCC claimed that Himalayan glaciers could disappear by 2035.", "id_expl_id": 871, "argument_id": 118, "statement_id": 101, "argument_id_expl_id": 871, "critical_question_id": 1, "statement_id_expl_id": 871, "critical_question_id_expl_id": 871}, "tableName": "critical_statement", "targetLabel": "(?) IPCC claimed that Himalayan glaciers could disappear by 2035."}
2025-04-22 02:44:58.210183+00	982	18	1	126	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 126, "text": "st2", "label": "(?) st2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 982, "text_expl_id": 982, "decided_expl_id": 982, "featured_expl_id": 982, "statement_type_id": 1, "confidence_expl_id": 982, "statement_type_name": "descriptive", "statement_type_id_expl_id": 982}, "tableName": "statement", "targetLabel": "(?) st2"}
2025-04-20 18:54:11.462825+00	935	22	1	116	insertRecord	statement	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 116, "text": "Животные — лишены разума, действуют по инстинктам, не способны к нравственному рассуждению.", "label": "(?) Животные — лишены разума, действуют по инстинктам, не способны к нравственному рассуждению.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 935, "text_expl_id": 935, "decided_expl_id": 935, "featured_expl_id": 935, "statement_type_id": 1, "confidence_expl_id": 935, "statement_type_name": "descriptive", "statement_type_id_expl_id": 935}, "tableName": "statement", "targetLabel": "(?) Животные — лишены разума, действуют по инстинктам, не способны к нравственному рассуждению."}
2025-04-20 19:03:03.006349+00	944	23	1	23	updateRecord	person	{"id": 23, "diff": {"after": {"language": "russian"}, "before": {"id": 23, "language": "english", "id_expl_id": 943, "language_expl_id": 943}}, "user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Mustafa"}
2025-04-20 19:14:50.42193+00	950	23	1	121	insertRecord	statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 121, "text": "Природа животных не измненилась с появлением человека. ", "label": "(?) Природа животных не измненилась с появлением человека. ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 950, "text_expl_id": 950, "decided_expl_id": 950, "featured_expl_id": 950, "statement_type_id": 1, "confidence_expl_id": 950, "statement_type_name": "descriptive", "statement_type_id_expl_id": 950}, "tableName": "statement", "targetLabel": "(?) Природа животных не измненилась с появлением человека. "}
2025-05-02 22:50:53.764712+00	1011	18	1	3	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 3, "label": "(-4 / misplaced item / m³) mess", "weight": -4, "id_expl_id": 1011, "profile_id": 1, "moral_good_id": 1, "weight_expl_id": 1011, "profile_id_expl_id": 1011, "moral_good_id_expl_id": 1011}, "tableName": "moral_weight_of_profile", "targetLabel": "(-4 / misplaced item / m³) mess"}
2025-04-09 22:03:16.405655+00	664	5	1	\N	deleteByIds	person_category	{"ids": [2], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "person_category", "targetLabel": "2", "deletedRecords": {"person_category": [{"id": 2, "name": "disabled", "id_expl_id": null, "name_expl_id": null}]}}
2025-04-11 19:19:19.798845+00	708	18	1	21	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 21, "name": "test 2", "id_expl_id": 708, "description": " ", "name_expl_id": 708, "description_expl_id": 708}, "tableName": "tag", "targetLabel": "test 2"}
2025-04-13 01:48:56.081116+00	773	18	1	105	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 105, "pro": true, "title": "test arg 1", "id_expl_id": 773, "pro_expl_id": 773, "statement_id": 90, "title_expl_id": 773, "argument_type_id": 3, "statement_id_expl_id": 773, "argument_type_id_expl_id": 773}, "extRecord": {"id": 105, "text": " ", "id_expl_id": 773, "text_expl_id": 773}, "tableName": "argument", "targetLabel": "test arg 1", "extTableName": "argument_other"}
2025-11-30 15:35:58.186532+00	1758	26	1	46	insertRecord	tag	{"user": {"id": 26, "name": "TestUserPL1000", "auth_role": "invited", "permission_level": 1000}, "record": {"id": 46, "name": "sandbox", "id_expl_id": 1758, "description": "use this tag for testing things", "name_expl_id": 1758, "description_expl_id": 1758}, "tableName": "tag", "targetLabel": "sandbox"}
2025-04-18 15:27:01.91238+00	821	11	1	57	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 57, "label": "(?) penicillin was used extensively to treat bacterial infections before the mechanism behind its action was fully understood", "id_expl_id": 821, "argument_id": 50, "statement_id": 91, "argument_id_expl_id": 821, "critical_question_id": 1, "statement_id_expl_id": 821, "critical_question_id_expl_id": 821}, "tableName": "critical_statement", "targetLabel": "(?) penicillin was used extensively to treat bacterial infections before the mechanism behind its action was fully understood"}
2025-04-20 18:54:14.883122+00	936	22	1	79	insertRecord	critical_statement	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 79, "label": "(?) Животные — лишены разума, действуют по инстинктам, не способны к нравственному рассуждению.", "id_expl_id": 936, "argument_id": 126, "statement_id": 116, "argument_id_expl_id": 936, "critical_question_id": 6, "statement_id_expl_id": 936, "critical_question_id_expl_id": 936}, "tableName": "critical_statement", "targetLabel": "(?) Животные — лишены разума, действуют по инстинктам, не способны к нравственному рассуждению."}
2025-04-19 20:24:41.626139+00	872	10	1	102	insertRecord	statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 102, "text": "IPCC claim that Himalayan glaciers could disappear by 2035 was not backed by peer-reviewed science.", "label": "(?) IPCC claim that Himalayan glaciers could disappear by 2035 was not backed by peer-reviewed science.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 872, "text_expl_id": 872, "decided_expl_id": 872, "featured_expl_id": 872, "statement_type_id": 1, "confidence_expl_id": 872, "statement_type_name": "descriptive", "statement_type_id_expl_id": 872}, "tableName": "statement", "targetLabel": "(?) IPCC claim that Himalayan glaciers could disappear by 2035 was not backed by peer-reviewed science."}
2025-04-19 20:25:07.796307+00	873	10	1	64	insertRecord	critical_statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 64, "label": "(?) IPCC claim that Himalayan glaciers could disappear by 2035 was not backed by peer-reviewed science.", "id_expl_id": 873, "argument_id": 118, "statement_id": 102, "argument_id_expl_id": 873, "critical_question_id": 1, "statement_id_expl_id": 873, "critical_question_id_expl_id": 873}, "tableName": "critical_statement", "targetLabel": "(?) IPCC claim that Himalayan glaciers could disappear by 2035 was not backed by peer-reviewed science."}
2025-04-20 18:56:07.701859+00	937	22	1	128	insertExtRecord	argument	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 128, "pro": true, "title": "Животные — лишены разума", "id_expl_id": 937, "pro_expl_id": 937, "statement_id": 116, "title_expl_id": 937, "argument_type_id": 1, "statement_id_expl_id": 937, "argument_type_id_expl_id": 937}, "extRecord": {"id": 128, "quote": "\\"Животные — лишены разума, действуют по инстинктам, не способны к нравственному рассуждению.\\" Аристотель", "authority": "Он создал полную мировозренческую систему, которая влияет на нашу жизнь до сих пор.", "id_expl_id": 937, "source_url": "Книга", "source_title": "Политика", "quote_expl_id": 937, "authority_expl_id": 937, "source_url_expl_id": 937, "source_title_expl_id": 937}, "tableName": "argument", "targetLabel": "Животные — лишены разума", "extTableName": "argument_authority"}
2025-04-20 19:08:57.953819+00	947	23	1	81	insertRecord	critical_statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 81, "label": "(?) Аристотель не биолог, и знания о животных были очень ограничены, когда он жил. ", "id_expl_id": 947, "argument_id": 128, "statement_id": 119, "argument_id_expl_id": 947, "critical_question_id": 4, "statement_id_expl_id": 947, "critical_question_id_expl_id": 947}, "tableName": "critical_statement", "targetLabel": "(?) Аристотель не биолог, и знания о животных были очень ограничены, когда он жил. "}
2025-04-20 18:58:10.252847+00	940	22	1	80	insertRecord	critical_statement	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 80, "label": "(?) Нижестоящие формы жизни существуют ради высших.\\nРастения существуют ради животных, животные — ради человека.", "id_expl_id": 940, "argument_id": 126, "statement_id": 117, "argument_id_expl_id": 940, "critical_question_id": 6, "statement_id_expl_id": 940, "critical_question_id_expl_id": 940}, "tableName": "critical_statement", "targetLabel": "(?) Нижестоящие формы жизни существуют ради высших.\\nРастения существуют ради животных, животные — ради человека."}
2025-04-09 22:10:54.732631+00	665	5	1	15	updateRecord	tag	{"id": 15, "diff": {"after": {"description": "self-referential"}, "before": {"id": 15, "description": "", "description_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "tag", "targetLabel": "meta"}
2025-04-11 19:19:20.159091+00	709	18	1	67	insertCrossRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 21, "label": "test 2", "tableName": "tag"}, "record": {"tag_id": 21, "statement_id": 67, "tag_id_expl_id": 709, "statement_id_expl_id": 709}, "target": {"id": 67, "label": "(?) block of flats residents should lock rubbish bins", "tableName": "statement"}}
2025-04-13 02:56:43.953374+00	775	\N	1	90	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.88889}, "before": {"id": 90, "decided": false, "confidence": 0.5, "id_expl_id": 772, "decided_expl_id": 772, "confidence_expl_id": 772}}, "statement": {"id": 90, "text": "test st", "id_expl_id": 772, "text_expl_id": 772}, "confidences": [[], [0.77778]], "triggerLabel": "insert of argument judgement", "triggerExplId": 774, "statementArguments": [{"id": 105, "pro": true, "id_expl_id": 773, "pro_expl_id": 773, "statement_id": 90, "title_expl_id": 773, "argument_type_id": 3, "statement_id_expl_id": 773, "argument_type_id_expl_id": 773}], "argumentConfidences": [{"pro": true, "pro_expl_id": 773, "isolated_confidence": 0.77778, "conditional_confidence": null, "isolated_confidence_expl_id": 774, "conditional_confidence_expl_id": null}]}
2025-04-19 20:57:55.228101+00	883	10	1	116	updateRecord	argument_judgement	{"id": 116, "diff": {"after": {"isolated_confidence": "0.05000", "isolated_explanation": "It's a big source of uncertainty in the models. IPCC is biased."}, "before": {"id": 116, "id_expl_id": 859, "isolated_confidence": 0.9, "isolated_explanation": "It's the biggest source of uncertainty in the models but the scientists have narrowed the possible ranges", "isolated_confidence_expl_id": 859, "isolated_explanation_expl_id": 859}}, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "IPCC is biased.", "tableName": "argument_judgement", "targetLabel": "IPCC AR6 (5%)"}
2025-04-13 02:56:43.689781+00	774	18	1	105	insertRecord	argument_judgement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 105, "label": "test arg 1 (78%)", "id_expl_id": 774, "isolated_confidence": 0.77778, "isolated_explanation": "test", "isolated_confidence_expl_id": 774, "isolated_explanation_expl_id": 774}, "tableName": "argument_judgement", "targetLabel": "test arg 1 (78%)"}
2025-04-13 02:57:46.203448+00	778	\N	1	90	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.9259262963}, "before": {"id": 90, "decided": true, "confidence": 0.88889, "id_expl_id": 772, "decided_expl_id": 775, "confidence_expl_id": 775}}, "statement": {"id": 90, "text": "test st", "id_expl_id": 772, "text_expl_id": 772}, "confidences": [[], [0.77778, 0.33333]], "triggerLabel": "insert of argument judgement", "triggerExplId": 777, "statementArguments": [{"id": 105, "pro": true, "id_expl_id": 773, "pro_expl_id": 773, "statement_id": 90, "title_expl_id": 773, "argument_type_id": 3, "statement_id_expl_id": 773, "argument_type_id_expl_id": 773}, {"id": 106, "pro": true, "id_expl_id": 776, "pro_expl_id": 776, "statement_id": 90, "title_expl_id": 776, "argument_type_id": 3, "statement_id_expl_id": 776, "argument_type_id_expl_id": 776}], "argumentConfidences": [{"pro": true, "pro_expl_id": 773, "isolated_confidence": 0.77778, "conditional_confidence": null, "isolated_confidence_expl_id": 774, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": 776, "isolated_confidence": 0.33333, "conditional_confidence": null, "isolated_confidence_expl_id": 777, "conditional_confidence_expl_id": null}]}
2025-04-18 15:28:29.460885+00	822	18	1	92	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 92, "text": "test st 2", "label": "(?) test st 2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 822, "text_expl_id": 822, "decided_expl_id": 822, "featured_expl_id": 822, "statement_type_id": 1, "confidence_expl_id": 822, "statement_type_name": "descriptive", "statement_type_id_expl_id": 822}, "tableName": "statement", "targetLabel": "(?) test st 2"}
2025-12-15 08:19:01.788923+00	1861	18	1	\N	insertExtRecord	argument	\N
2025-04-19 20:36:38.529971+00	874	10	1	119	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 119, "pro": true, "title": "direct original quote", "id_expl_id": 874, "pro_expl_id": 874, "statement_id": 101, "title_expl_id": 874, "argument_type_id": 1, "statement_id_expl_id": 874, "argument_type_id_expl_id": 874}, "extRecord": {"id": 119, "quote": "Glaciers in the Himalaya are receding faster than in any other part of the world (see Table 10.9) and, if the present rate continues, the likelihood of them disappearing by the year 2035 and perhaps sooner is very high if the Earth keeps warming at the current rate. Its total area will likely shrink from the present 500,000 to 100,000 km2 by the year 2035 (WWF, 2005).", "authority": "It's the official IPCC archive website", "id_expl_id": 874, "source_url": "https://archive.ipcc.ch/publications_and_data/ar4/wg2/en/ch10s10-6-2.html", "source_title": "AR4 WGII Chapter 10: Asia - 10.6.2 The Himalayan glaciers", "quote_expl_id": 874, "authority_expl_id": 874, "source_url_expl_id": 874, "source_title_expl_id": 874}, "tableName": "argument", "targetLabel": "direct original quote", "extTableName": "argument_authority"}
2025-04-19 20:44:45.31986+00	881	\N	1	100	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.95}, "before": {"id": 100, "decided": false, "confidence": 0.5, "id_expl_id": 868, "decided_expl_id": 868, "confidence_expl_id": 868}}, "statement": {"id": 100, "text": "IPCC is biased towards alarmism", "id_expl_id": 868, "text_expl_id": 868}, "confidences": [[], [0.9]], "triggerLabel": "insert of argument judgement", "triggerExplId": 880, "statementArguments": [{"id": 118, "pro": true, "id_expl_id": 869, "pro_expl_id": 869, "statement_id": 100, "title_expl_id": 869, "argument_type_id": 8, "statement_id_expl_id": 869, "argument_type_id_expl_id": 869}], "argumentConfidences": [{"pro": true, "pro_expl_id": 869, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 880, "conditional_confidence_expl_id": null}]}
2025-04-09 22:52:26.775947+00	666	5	1	1	updateRecord	moral_weight_profile	{"id": 1, "diff": {"after": {"name": "example moral weights"}, "before": {"id": 1, "name": "someone", "name_expl_id": 552}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "moral_weight_profile", "targetLabel": "example moral weights"}
2025-04-11 19:19:33.139302+00	710	18	1	67	deleteCrossRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 21, "label": "test 2", "tableName": "tag"}, "record": {"tag_id": 21, "statement_id": 67, "tag_id_expl_id": 709, "statement_id_expl_id": 709}, "target": {"id": 67, "label": "(?) block of flats residents should lock rubbish bins", "tableName": "statement"}, "userExpl": ""}
2025-04-11 19:22:49.650829+00	712	18	1	22	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 22, "name": "tag3", "id_expl_id": 712, "description": " ", "name_expl_id": 712, "description_expl_id": 712}, "tableName": "tag", "targetLabel": "tag3"}
2025-04-13 02:57:11.293734+00	776	18	1	106	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 106, "pro": true, "title": "test arg 2", "id_expl_id": 776, "pro_expl_id": 776, "statement_id": 90, "title_expl_id": 776, "argument_type_id": 3, "statement_id_expl_id": 776, "argument_type_id_expl_id": 776}, "extRecord": {"id": 106, "text": " ", "id_expl_id": 776, "text_expl_id": 776}, "tableName": "argument", "targetLabel": "test arg 2", "extTableName": "argument_other"}
2025-04-19 20:43:58.204127+00	878	10	1	120	insertRecord	argument_judgement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 120, "label": "eventual admission (100%)", "id_expl_id": 878, "isolated_confidence": 0.999, "isolated_explanation": "This claim was not disputed", "isolated_confidence_expl_id": 878, "isolated_explanation_expl_id": 878}, "tableName": "argument_judgement", "targetLabel": "eventual admission (100%)"}
2025-04-18 15:49:07.969432+00	823	18	1	93	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 93, "text": "test st 3", "label": "(?) test st 3", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 823, "text_expl_id": 823, "decided_expl_id": 823, "featured_expl_id": 823, "statement_type_id": 1, "confidence_expl_id": 823, "statement_type_name": "descriptive", "statement_type_id_expl_id": 823}, "tableName": "statement", "targetLabel": "(?) test st 3"}
2025-04-18 16:05:15.92973+00	827	5	1	\N	deleteByIds	statement	{"ids": [95, 94, 93, 92], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "95, 94, 93, 92", "deletedRecords": {"statement": [{"id": 92, "text": "test st 2", "label": "(?) test st 2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 822, "text_expl_id": 822, "decided_expl_id": 822, "featured_expl_id": 822, "statement_type_id": 1, "confidence_expl_id": 822, "statement_type_name": "descriptive", "statement_type_id_expl_id": 822}, {"id": 93, "text": "test st 3", "label": "(?) test st 3", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 823, "text_expl_id": 823, "decided_expl_id": 823, "featured_expl_id": 823, "statement_type_id": 1, "confidence_expl_id": 823, "statement_type_name": "descriptive", "statement_type_id_expl_id": 823}, {"id": 94, "text": "test st 3", "label": "(?) test st 3", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 824, "text_expl_id": 824, "decided_expl_id": 824, "featured_expl_id": 824, "statement_type_id": 1, "confidence_expl_id": 824, "statement_type_name": "descriptive", "statement_type_id_expl_id": 824}, {"id": 95, "text": "test st 4", "label": "(?) test st 4", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 825, "text_expl_id": 825, "decided_expl_id": 825, "featured_expl_id": 825, "statement_type_id": 1, "confidence_expl_id": 825, "statement_type_name": "descriptive", "statement_type_id_expl_id": 825}], "critical_statement": [{"id": 58, "label": "(?) test st 4", "id_expl_id": 826, "argument_id": 108, "statement_id": 95, "argument_id_expl_id": 826, "critical_question_id": 1, "statement_id_expl_id": 826, "critical_question_id_expl_id": 826}]}}
2025-04-18 16:31:32.72825+00	828	11	1	110	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 110, "pro": true, "title": "June 1944 article", "id_expl_id": 828, "pro_expl_id": 828, "statement_id": 91, "title_expl_id": 828, "argument_type_id": 6, "statement_id_expl_id": 828, "argument_type_id_expl_id": 828}, "extRecord": {"id": 110, "text": "​Margaret Jennings' pivotal discovery in 1944 revealed that penicillin is most effective against bacteria during their growth phase, as it interferes with the formation of the cell wall, leading to cell lysis. This insight was published in June 1944, as part of a comprehensive article in Industrial and Engineering Chemistry that detailed the Allies' advancements in penicillin research and production.​\\n\\nBy that time, penicillin had transitioned from experimental use to widespread application. It was extensively utilized during the North Africa campaign in 1943, proving highly effective in treating wound infections, pneumonia, and other bacterial diseases. By the D-Day landings on June 6, 1944, sufficient quantities of penicillin were available to treat all Allied forces, marking a significant milestone in its practical deployment .​\\n\\nThus, Jennings' findings emerged during a period when penicillin was already revolutionizing medical treatment on the battlefield, underscoring the importance of understanding its mechanism of action to optimize its use.", "id_expl_id": 828, "text_expl_id": 828}, "tableName": "argument", "targetLabel": "June 1944 article", "extTableName": "argument_deduction"}
2025-04-19 20:37:29.776189+00	875	10	1	119	insertRecord	argument_judgement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 119, "label": "direct original quote (100%)", "id_expl_id": 875, "isolated_confidence": 0.9999, "isolated_explanation": "we have their own quote", "isolated_confidence_expl_id": 875, "isolated_explanation_expl_id": 875}, "tableName": "argument_judgement", "targetLabel": "direct original quote (100%)"}
2025-04-19 20:43:58.413812+00	879	\N	1	102	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.9995}, "before": {"id": 102, "decided": false, "confidence": 0.5, "id_expl_id": 872, "decided_expl_id": 872, "confidence_expl_id": 872}}, "statement": {"id": 102, "text": "IPCC claim that Himalayan glaciers could disappear by 2035 was not backed by peer-reviewed science.", "id_expl_id": 872, "text_expl_id": 872}, "confidences": [[], [0.999]], "triggerLabel": "insert of argument judgement", "triggerExplId": 878, "statementArguments": [{"id": 120, "pro": true, "id_expl_id": 877, "pro_expl_id": 877, "statement_id": 102, "title_expl_id": 877, "argument_type_id": 1, "statement_id_expl_id": 877, "argument_type_id_expl_id": 877}], "argumentConfidences": [{"pro": true, "pro_expl_id": 877, "isolated_confidence": 0.999, "conditional_confidence": null, "isolated_confidence_expl_id": 878, "conditional_confidence_expl_id": null}]}
2025-04-20 19:26:14.96329+00	953	23	1	46	insertRecord	critical_question	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 46, "text": "Приводит ли приминение этой логики к другим случаям к абсурду ", "id_expl_id": 953, "text_expl_id": 953, "argument_type_id": 6, "argument_type_id_expl_id": 953}, "tableName": "critical_question", "targetLabel": "Приводит ли приминение этой логики к другим случаям к абсурду "}
2025-04-09 22:52:39.414981+00	667	5	1	2	updateRecord	moral_weight_profile	{"id": 2, "diff": {"after": {"name": "opposite example moral weights"}, "before": {"id": 2, "name": "opposite someone", "name_expl_id": 572}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "moral_weight_profile", "targetLabel": "opposite example moral weights"}
2025-04-11 19:19:36.940619+00	711	18	1	67	deleteCrossRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 15, "label": "meta", "tableName": "tag"}, "record": {"tag_id": 15, "statement_id": 67, "tag_id_expl_id": 707, "statement_id_expl_id": 707}, "target": {"id": 67, "label": "(?) block of flats residents should lock rubbish bins", "tableName": "statement"}, "userExpl": ""}
2025-04-11 19:31:55.666913+00	716	18	1	77	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 77, "text": "tag test 3", "label": "(?) tag test 3", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 716, "text_expl_id": 716, "decided_expl_id": 716, "featured_expl_id": 716, "confidence_expl_id": 716, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 716}, "tableName": "statement", "targetLabel": "(?) tag test 3"}
2025-04-20 18:58:05.126544+00	939	22	1	117	insertRecord	statement	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 117, "text": "Нижестоящие формы жизни существуют ради высших.\\nРастения существуют ради животных, животные — ради человека.", "label": "(?) Нижестоящие формы жизни существуют ради высших.\\nРастения существуют ради животных, животные — ради человека.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 939, "text_expl_id": 939, "decided_expl_id": 939, "featured_expl_id": 939, "statement_type_id": 1, "confidence_expl_id": 939, "statement_type_name": "descriptive", "statement_type_id_expl_id": 939}, "tableName": "statement", "targetLabel": "(?) Нижестоящие формы жизни существуют ради высших.\\nРастения существуют ради животных, животные — ради человека."}
2025-04-13 02:57:46.043932+00	777	18	1	106	insertRecord	argument_judgement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 106, "label": "test arg 2 (33%)", "id_expl_id": 777, "isolated_confidence": 0.33333, "isolated_explanation": "", "isolated_confidence_expl_id": 777, "isolated_explanation_expl_id": 777}, "tableName": "argument_judgement", "targetLabel": "test arg 2 (33%)"}
2025-04-18 15:59:47.068796+00	824	18	1	94	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 94, "text": "test st 3", "label": "(?) test st 3", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 824, "text_expl_id": 824, "decided_expl_id": 824, "featured_expl_id": 824, "statement_type_id": 1, "confidence_expl_id": 824, "statement_type_name": "descriptive", "statement_type_id_expl_id": 824}, "tableName": "statement", "targetLabel": "(?) test st 3"}
2025-04-19 20:37:30.002091+00	876	\N	1	101	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.99995}, "before": {"id": 101, "decided": false, "confidence": 0.5, "id_expl_id": 870, "decided_expl_id": 870, "confidence_expl_id": 870}}, "statement": {"id": 101, "text": "IPCC claimed that Himalayan glaciers could disappear by 2035.", "id_expl_id": 870, "text_expl_id": 870}, "confidences": [[], [0.9999]], "triggerLabel": "insert of argument judgement", "triggerExplId": 875, "statementArguments": [{"id": 119, "pro": true, "id_expl_id": 874, "pro_expl_id": 874, "statement_id": 101, "title_expl_id": 874, "argument_type_id": 1, "statement_id_expl_id": 874, "argument_type_id_expl_id": 874}], "argumentConfidences": [{"pro": true, "pro_expl_id": 874, "isolated_confidence": 0.9999, "conditional_confidence": null, "isolated_confidence_expl_id": 875, "conditional_confidence_expl_id": null}]}
2025-10-18 11:41:11.411352+00	1392	5	1	135	updateExtRecord	issue	{"id": 135, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed", "project_stage": "closed β rel.", "functional_area": "content"}}, "tableName": "issue", "targetLabel": "Add \\"statistical syllogism\\" argument type.", "extTableName": "task"}
2025-04-19 20:55:14.795878+00	882	10	1	65	insertRecord	critical_statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 65, "label": "(95%) IPCC is biased towards alarmism", "id_expl_id": 882, "argument_id": 116, "statement_id": 100, "argument_id_expl_id": 882, "critical_question_id": 25, "statement_id_expl_id": 882, "critical_question_id_expl_id": 882}, "tableName": "critical_statement", "targetLabel": "(95%) IPCC is biased towards alarmism"}
2025-04-20 18:59:17.17231+00	941	22	1	129	insertExtRecord	argument	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 129, "pro": true, "title": "Животные существуют ради человека", "id_expl_id": 941, "pro_expl_id": 941, "statement_id": 117, "title_expl_id": 941, "argument_type_id": 1, "statement_id_expl_id": 941, "argument_type_id_expl_id": 941}, "extRecord": {"id": 129, "quote": "\\"Нижестоящие формы жизни существуют ради высших.\\nРастения существуют ради животных, животные — ради человека.\\"  Аристотель", "authority": "Он создал полную мировозренческую систему, которая влияет на нашу жизнь до сих пор.", "id_expl_id": 941, "source_url": "https://historyofeconomicthought.mcmaster.ca/aristotle/Politics.pdf", "source_title": "Политика", "quote_expl_id": 941, "authority_expl_id": 941, "source_url_expl_id": 941, "source_title_expl_id": 941}, "tableName": "argument", "targetLabel": "Животные существуют ради человека", "extTableName": "argument_authority"}
2025-04-20 19:00:34.043022+00	942	22	1	16	insertRecord	invite	{"user": {"id": 22, "name": "Puma", "auth_role": "invited"}, "record": {"id": 16, "code": "5yoAn46n", "link": "http://localhost:3000/join?code=5yoAn46n", "owner_id": 22, "person_id": null, "id_expl_id": 942, "code_expl_id": 942, "owner_id_expl_id": 942, "person_id_expl_id": 942}, "tableName": "invite", "targetLabel": "5yoAn46n"}
2025-04-10 01:10:55.153338+00	668	5	1	12	insertRecord	invite	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 12, "code": "LjD3CPcF", "link": "http://localhost:3000/join?code=LjD3CPcF", "owner_id": 5, "person_id": null, "id_expl_id": 668, "code_expl_id": 668, "owner_id_expl_id": 668, "person_id_expl_id": 668}, "tableName": "invite", "targetLabel": "LjD3CPcF"}
2025-04-13 13:08:59.243855+00	779	5	1	\N	deleteByIds	critical_question	{"ids": [2], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "critical_question", "targetLabel": "2", "deletedRecords": {"critical_question": [{"id": 2, "text": "Is this a strong argument?", "id_expl_id": null, "text_expl_id": null, "argument_type_id": 3, "argument_type_id_expl_id": null}]}}
2025-04-11 19:23:09.973169+00	713	18	1	75	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 75, "text": "tag test 1", "label": "(?) tag test 1", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 713, "text_expl_id": 713, "decided_expl_id": 713, "featured_expl_id": 713, "confidence_expl_id": 713, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 713}, "tableName": "statement", "targetLabel": "(?) tag test 1"}
2025-04-11 19:28:18.422334+00	714	18	1	76	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 76, "text": "tag test 2", "label": "(?) tag test 2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 714, "text_expl_id": 714, "decided_expl_id": 714, "featured_expl_id": 714, "confidence_expl_id": 714, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 714}, "tableName": "statement", "targetLabel": "(?) tag test 2"}
2025-04-18 16:01:53.640881+00	825	18	1	95	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 95, "text": "test st 4", "label": "(?) test st 4", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 825, "text_expl_id": 825, "decided_expl_id": 825, "featured_expl_id": 825, "statement_type_id": 1, "confidence_expl_id": 825, "statement_type_name": "descriptive", "statement_type_id_expl_id": 825}, "tableName": "statement", "targetLabel": "(?) test st 4"}
2025-05-06 03:37:09.57206+00	1027	24	1	14	insertRecord	moral_weight_of_person	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 14, "label": "(100 / minute) free time", "weight": 100, "owner_id": 24, "id_expl_id": 1027, "moral_good_id": 2, "weight_expl_id": 1027, "owner_id_expl_id": 1027, "moral_good_id_expl_id": 1027}, "tableName": "moral_weight_of_person", "targetLabel": "(100 / minute) free time"}
2025-04-19 20:43:23.74595+00	877	10	1	120	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 120, "pro": true, "title": "eventual admission", "id_expl_id": 877, "pro_expl_id": 877, "statement_id": 102, "title_expl_id": 877, "argument_type_id": 1, "statement_id_expl_id": 877, "argument_type_id_expl_id": 877}, "extRecord": {"id": 120, "quote": "The UN's climate science body has admitted that a claim made in its 2007 report - that Himalayan glaciers could melt away by 2035 - was unfounded.\\n\\nThe admission today followed a New Scientist article last week that revealed the source of the claim made in the 2007 report by the Intergovernmental Panel on Climate Change (IPCC) was not peer-reviewed scientific literature – but a media interview with a scientist conducted in 1999. Several senior scientists have now said the claim was unrealistic and that the large Himalayan glaciers could not melt in a few decades.", "authority": "It's a newspaper with a pro climate change agenda that is reputable among a big proportion of UK readers ", "id_expl_id": 877, "source_url": "IPCC officials admit mistake over melting Himalayan glaciers", "source_title": "https://www.theguardian.com/environment/2010/jan/20/ipcc-himalayan-glaciers-mistake", "quote_expl_id": 877, "authority_expl_id": 877, "source_url_expl_id": 877, "source_title_expl_id": 877}, "tableName": "argument", "targetLabel": "eventual admission", "extTableName": "argument_authority"}
2025-04-20 19:02:08.777536+00	943	22	1	23	join	person	{"person": {"id": 23, "name": "Mustafa"}, "inviter": {"id": 22, "name": "Puma", "auth_role": "invited"}}
2025-04-19 20:44:45.076174+00	880	10	1	118	insertRecord	argument_judgement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 118, "label": "Glaciergate (90%)", "id_expl_id": 880, "isolated_confidence": 0.9, "isolated_explanation": "A clear example of such behaviour was presented.", "isolated_confidence_expl_id": 880, "isolated_explanation_expl_id": 880}, "tableName": "argument_judgement", "targetLabel": "Glaciergate (90%)"}
2025-04-20 19:08:54.886058+00	946	23	1	119	insertRecord	statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 119, "text": "Аристотель не биолог, и знания о животных были очень ограничены, когда он жил. ", "label": "(?) Аристотель не биолог, и знания о животных были очень ограничены, когда он жил. ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 946, "text_expl_id": 946, "decided_expl_id": 946, "featured_expl_id": 946, "statement_type_id": 1, "confidence_expl_id": 946, "statement_type_name": "descriptive", "statement_type_id_expl_id": 946}, "tableName": "statement", "targetLabel": "(?) Аристотель не биолог, и знания о животных были очень ограничены, когда он жил. "}
2025-04-22 03:58:43.553286+00	984	18	1	127	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 127, "text": "st3", "label": "(?) st3", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 984, "text_expl_id": 984, "decided_expl_id": 984, "featured_expl_id": 984, "statement_type_id": 1, "confidence_expl_id": 984, "statement_type_name": "descriptive", "statement_type_id_expl_id": 984}, "tableName": "statement", "targetLabel": "(?) st3"}
2025-04-22 03:58:43.913043+00	985	18	1	90	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 90, "id_expl_id": 985, "argument_id": 105, "statement_id": 127, "argument_id_expl_id": 985, "critical_question_id": 1, "statement_id_expl_id": 985, "critical_question_id_expl_id": 985}, "tableName": "critical_statement", "targetLabel": 127}
2025-04-10 01:31:29.111237+00	669	5	1	20	join	person	{"person": {"id": 20, "name": "Griffin"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-04-20 19:14:19.991542+00	948	23	1	120	insertRecord	statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 120, "text": "Животные существовали не ради человека. ", "label": "(?) Животные существовали не ради человека. ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 948, "text_expl_id": 948, "decided_expl_id": 948, "featured_expl_id": 948, "statement_type_id": 1, "confidence_expl_id": 948, "statement_type_name": "descriptive", "statement_type_id_expl_id": 948}, "tableName": "statement", "targetLabel": "(?) Животные существовали не ради человека. "}
2025-04-11 19:31:42.231076+00	715	18	1	23	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 23, "name": "tag 4", "id_expl_id": 715, "description": " ", "name_expl_id": 715, "description_expl_id": 715}, "tableName": "tag", "targetLabel": "tag 4"}
2025-04-13 13:17:54.280342+00	780	20	1	107	insertExtRecord	argument	{"user": {"id": 20, "name": "Griffin", "auth_role": "invited"}, "record": {"id": 107, "pro": false, "title": "prolongs the conflict", "id_expl_id": 780, "pro_expl_id": 780, "statement_id": 70, "title_expl_id": 780, "argument_type_id": 10, "statement_id_expl_id": 780, "argument_type_id_expl_id": 780}, "extRecord": {"id": 107, "text": "Sending weapons to Ukraine will prolong the conflict instead of ending it quickly.\\nA longer war means more deaths on both sides, including civilians.\\nContinued fighting increases suffering, displacement, and trauma for millions.", "id_expl_id": 780, "text_expl_id": 780}, "tableName": "argument", "targetLabel": "prolongs the conflict", "extTableName": "argument_normative"}
2025-04-18 16:02:37.510882+00	826	18	1	58	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 58, "label": "(?) test st 4", "id_expl_id": 826, "argument_id": 108, "statement_id": 95, "argument_id_expl_id": 826, "critical_question_id": 1, "statement_id_expl_id": 826, "critical_question_id_expl_id": 826}, "tableName": "critical_statement", "targetLabel": "(?) test st 4"}
2025-04-19 20:57:55.5019+00	884	\N	1	99	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.925}, "before": {"id": 99, "decided": true, "confidence": 0.925, "id_expl_id": 855, "decided_expl_id": 865, "confidence_expl_id": 865}}, "statement": {"id": 99, "text": "clouds is an amplifier of global warming", "id_expl_id": 855, "text_expl_id": 855}, "confidences": [[], [0.5, 0.7]], "triggerLabel": "update of argument judgement", "triggerExplId": 883, "statementArguments": [{"id": 115, "pro": true, "id_expl_id": 857, "pro_expl_id": 857, "statement_id": 99, "title_expl_id": 857, "argument_type_id": 1, "statement_id_expl_id": 857, "argument_type_id_expl_id": 857}, {"id": 116, "pro": true, "id_expl_id": 858, "pro_expl_id": 858, "statement_id": 99, "title_expl_id": 858, "argument_type_id": 1, "statement_id_expl_id": 858, "argument_type_id_expl_id": 858}], "argumentConfidences": [{"pro": true, "pro_expl_id": 857, "isolated_confidence": 0.5, "conditional_confidence": null, "isolated_confidence_expl_id": 864, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": 858, "isolated_confidence": 0.05, "conditional_confidence": 0.7, "isolated_confidence_expl_id": 883, "conditional_confidence_expl_id": 862}]}
2025-04-19 20:58:47.071956+00	886	\N	1	99	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.75625}, "before": {"id": 99, "decided": true, "confidence": 0.925, "id_expl_id": 855, "decided_expl_id": 884, "confidence_expl_id": 884}}, "statement": {"id": 99, "text": "clouds is an amplifier of global warming", "id_expl_id": 855, "text_expl_id": 855}, "confidences": [[], [0.5, 0.025]], "triggerLabel": "update of argument conditional", "triggerExplId": 885, "statementArguments": [{"id": 115, "pro": true, "id_expl_id": 857, "pro_expl_id": 857, "statement_id": 99, "title_expl_id": 857, "argument_type_id": 1, "statement_id_expl_id": 857, "argument_type_id_expl_id": 857}, {"id": 116, "pro": true, "id_expl_id": 858, "pro_expl_id": 858, "statement_id": 99, "title_expl_id": 858, "argument_type_id": 1, "statement_id_expl_id": 858, "argument_type_id_expl_id": 858}], "argumentConfidences": [{"pro": true, "pro_expl_id": 857, "isolated_confidence": 0.5, "conditional_confidence": null, "isolated_confidence_expl_id": 864, "conditional_confidence_expl_id": null}, {"pro": true, "pro_expl_id": 858, "isolated_confidence": 0.05, "conditional_confidence": 0.025, "isolated_confidence_expl_id": 883, "conditional_confidence_expl_id": 885}]}
2025-04-19 20:58:46.835702+00	885	10	1	116	updateRecord	argument_conditional	{"id": 116, "diff": {"after": {"conditional_confidence": "0.02500"}, "before": {"id": 116, "id_expl_id": 862, "conditional_confidence": 0.7, "conditional_confidence_expl_id": 862}}, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "adjusting for the change in the isolated confidence", "tableName": "argument_conditional", "targetLabel": 0.025}
2025-04-19 23:08:47.848308+00	896	10	1	69	insertRecord	critical_statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 69, "label": "(6%) A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change.", "id_expl_id": 896, "argument_id": 121, "statement_id": 47, "argument_id_expl_id": 896, "critical_question_id": 1, "statement_id_expl_id": 896, "critical_question_id_expl_id": 896}, "tableName": "critical_statement", "targetLabel": "(6%) A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change."}
2025-04-22 04:17:30.30011+00	986	18	1	90	updateRecord	statement	{"id": 90, "diff": {"after": {"text": "st1"}, "before": {"id": 90, "text": "test st", "id_expl_id": 772, "text_expl_id": 772}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(93%) st1"}
2025-04-10 19:09:50.002677+00	670	11	1	13	insertRecord	invite	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 13, "code": "k6n0W8O8", "link": "http://localhost:3000/join?code=k6n0W8O8", "owner_id": 11, "person_id": null, "id_expl_id": 670, "code_expl_id": 670, "owner_id_expl_id": 670, "person_id_expl_id": 670}, "tableName": "invite", "targetLabel": "k6n0W8O8"}
2025-04-11 19:31:55.95306+00	717	18	1	77	insertCrossRecords	statement	\N
2025-04-14 21:51:11.983598+00	781	5	1	2	updateRecord	argument_type	{"id": 2, "diff": {"after": {"description": "The argument draws a parallel between two or more situations, cases, or examples. It claims that because two things are alike in some ways, they must be alike in another specific way."}, "before": {"id": 2, "id_expl_id": null, "description": "", "description_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "analogy"}
2025-04-14 22:08:26.401597+00	784	5	1	5	updateRecord	argument_type	{"id": 5, "diff": {"after": {"description": "The argument expresses doubt about what we can know, how we know it, or whether our beliefs are justified. It typically casts uncertainty on a claim by questioning the available evidence or our ability to know the truth."}, "before": {"id": 5, "id_expl_id": 145, "description": "The argument against the statement is an epistemic argument, if it challenges the knowability or certainty of the claim rather than directly refuting its factual content. This type of argument is often used to introduce skepticism about the evidence or methods used to support a claim.", "description_expl_id": 145}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "epistemic"}
2025-04-20 19:14:23.533119+00	949	23	1	82	insertRecord	critical_statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 82, "label": "(?) Животные существовали не ради человека. ", "id_expl_id": 949, "argument_id": 129, "statement_id": 120, "argument_id_expl_id": 949, "critical_question_id": 1, "statement_id_expl_id": 949, "critical_question_id_expl_id": 949}, "tableName": "critical_statement", "targetLabel": "(?) Животные существовали не ради человека. "}
2025-04-18 17:30:24.410132+00	829	11	1	96	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 96, "text": "Margaret Jennings in 1944 discovered that penicillin is most effective against bacteria during their growth phase, as it interferes with the formation of the cell wall, leading to cell lysis.", "label": "(?) Margaret Jennings in 1944 discovered that penicillin is most effective against bacteria during their growth phase, as it interferes with the formation of the cell wall, leading to cell lysis.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 829, "text_expl_id": 829, "decided_expl_id": 829, "featured_expl_id": 829, "statement_type_id": 1, "confidence_expl_id": 829, "statement_type_name": "descriptive", "statement_type_id_expl_id": 829}, "tableName": "statement", "targetLabel": "(?) Margaret Jennings in 1944 discovered that penicillin is most effective against bacteria during their growth phase, as it interferes with the formation of the cell wall, leading to cell lysis."}
2025-04-18 17:32:22.958328+00	831	11	1	111	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 111, "pro": true, "title": "from Wikipedia", "id_expl_id": 831, "pro_expl_id": 831, "statement_id": 96, "title_expl_id": 831, "argument_type_id": 1, "statement_id_expl_id": 831, "argument_type_id_expl_id": 831}, "extRecord": {"id": 111, "quote": "In 1944, Margaret Jennings determined how penicillin acts, and showed that it has no lytic effects on mature organisms, including staphylococci; lysis occurs only if penicillin acts on bacteria during their initial stages of division and growth, when it interferes with the metabolic process that forms the cell wall.", "authority": "Wikipedia is reliable source of information about modern history and scientific facts.", "id_expl_id": 831, "source_url": "https://en.wikipedia.org/wiki/Discovery_of_penicillin#:~:text=In%201944%2C%20Margaret%20Jennings%20,This%20brought%20Fleming%27s%20explanation%20into", "source_title": "Discovery of penicillin", "quote_expl_id": 831, "authority_expl_id": 831, "source_url_expl_id": 831, "source_title_expl_id": 831}, "tableName": "argument", "targetLabel": "from Wikipedia", "extTableName": "argument_authority"}
2025-04-18 17:54:15.061825+00	843	\N	1	46	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 1}, "before": {"id": 46, "decided": false, "confidence": 0.5, "id_expl_id": 180, "decided_expl_id": 180, "confidence_expl_id": 180}}, "statement": {"id": 46, "text": "Models built without full understanding of the underlying mechanism can be accurate enough to be very useful.", "id_expl_id": 180, "text_expl_id": 180}, "confidences": [[], [1]], "triggerLabel": "insert of argument judgement", "triggerExplId": 842, "statementArguments": [{"id": 50, "pro": true, "id_expl_id": 183, "pro_expl_id": 183, "statement_id": 46, "title_expl_id": 183, "argument_type_id": 8, "statement_id_expl_id": 183, "argument_type_id_expl_id": 183}], "argumentConfidences": [{"pro": true, "pro_expl_id": 183, "isolated_confidence": 1, "conditional_confidence": null, "isolated_confidence_expl_id": 842, "conditional_confidence_expl_id": null}]}
2025-04-20 19:26:29.033337+00	954	23	1	46	updateRecord	critical_question	{"id": 46, "diff": {"after": {"text": "Приводит ли приминение этой логики к другим случаям к абсурду?"}, "before": {"id": 46, "text": "Приводит ли приминение этой логики к другим случаям к абсурду ", "id_expl_id": 953, "text_expl_id": 953}}, "user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "userExpl": "", "tableName": "critical_question", "targetLabel": "Приводит ли приминение этой логики к другим случаям к абсурду?"}
2025-04-19 21:01:31.566375+00	887	10	1	66	insertRecord	critical_statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 66, "label": "(95%) IPCC is biased towards alarmism", "id_expl_id": 887, "argument_id": 114, "statement_id": 100, "argument_id_expl_id": 887, "critical_question_id": 25, "statement_id_expl_id": 887, "critical_question_id_expl_id": 887}, "tableName": "critical_statement", "targetLabel": "(95%) IPCC is biased towards alarmism"}
2025-04-10 19:10:16.342878+00	671	11	1	21	join	person	{"person": {"id": 21, "name": "Anton"}, "inviter": {"id": 11, "name": "Martin", "auth_role": "invited"}}
2025-04-14 22:03:26.593425+00	782	5	1	7	updateRecord	argument_type	{"id": 7, "diff": {"after": {"description": "The argument claims that if something cannot be achieved at a smaller or simpler level, it cannot be accomplished at a larger or more complex level. It often leverages the notion that bigger, longer, or more complex situations are just scaled-up versions of smaller ones."}, "before": {"id": 7, "id_expl_id": 160, "description": "draw a comparison between something known and something that is claimed", "description_expl_id": 160}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "comparison"}
2025-04-10 19:19:49.228387+00	672	20	1	69	insertRecord	statement	{"user": {"id": 20, "name": "Griffin", "auth_role": "invited"}, "record": {"id": 69, "text": "Was the sniper that shot protesters in Kiev on the side of Yanukovych?", "label": "(?) Was the sniper that shot protesters in Kiev on the side of Yanukovych?", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 672, "text_expl_id": 672, "decided_expl_id": 672, "featured_expl_id": 672, "confidence_expl_id": 672, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 672}, "tableName": "statement", "targetLabel": "(?) Was the sniper that shot protesters in Kiev on the side of Yanukovych?"}
2025-04-11 19:44:27.277104+00	718	18	1	78	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 78, "text": "tag test 4", "label": "(?) tag test 4", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 718, "text_expl_id": 718, "decided_expl_id": 718, "featured_expl_id": 718, "confidence_expl_id": 718, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 718}, "tableName": "statement", "targetLabel": "(?) tag test 4"}
2025-04-14 22:07:38.057281+00	783	5	1	6	updateRecord	argument_type	{"id": 6, "diff": {"after": {"description": "The argument proceeds from general premises to a specific conclusion. It typically starts with a rule or principle and applies it to a particular case."}, "before": {"id": 6, "id_expl_id": 159, "description": "logical derivation from known facts", "description_expl_id": 159}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "deduction"}
2025-04-20 19:14:54.13109+00	951	23	1	83	insertRecord	critical_statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 83, "label": "(?) Природа животных не измненилась с появлением человека. ", "id_expl_id": 951, "argument_id": 129, "statement_id": 121, "argument_id_expl_id": 951, "critical_question_id": 1, "statement_id_expl_id": 951, "critical_question_id_expl_id": 951}, "tableName": "critical_statement", "targetLabel": "(?) Природа животных не измненилась с появлением человека. "}
2025-04-18 17:30:27.72186+00	830	11	1	59	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 59, "label": "(?) Margaret Jennings in 1944 discovered that penicillin is most effective against bacteria during their growth phase, as it interferes with the formation of the cell wall, leading to cell lysis.", "id_expl_id": 830, "argument_id": 110, "statement_id": 96, "argument_id_expl_id": 830, "critical_question_id": 1, "statement_id_expl_id": 830, "critical_question_id_expl_id": 830}, "tableName": "critical_statement", "targetLabel": "(?) Margaret Jennings in 1944 discovered that penicillin is most effective against bacteria during their growth phase, as it interferes with the formation of the cell wall, leading to cell lysis."}
2025-04-19 21:02:29.291963+00	889	\N	1	98	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.525}, "before": {"id": 98, "decided": true, "confidence": 0.99, "id_expl_id": 848, "decided_expl_id": 854, "confidence_expl_id": 854}}, "statement": {"id": 98, "text": "water vapour is a well-understood amplifier of global warming", "id_expl_id": 848, "text_expl_id": 848}, "confidences": [[], [0.05]], "triggerLabel": "update of argument judgement", "triggerExplId": 888, "statementArguments": [{"id": 114, "pro": true, "id_expl_id": 850, "pro_expl_id": 850, "statement_id": 98, "title_expl_id": 850, "argument_type_id": 1, "statement_id_expl_id": 850, "argument_type_id_expl_id": 850}], "argumentConfidences": [{"pro": true, "pro_expl_id": 850, "isolated_confidence": 0.05, "conditional_confidence": null, "isolated_confidence_expl_id": 888, "conditional_confidence_expl_id": null}]}
2025-04-19 21:02:28.989725+00	888	10	1	114	updateRecord	argument_judgement	{"id": 114, "diff": {"after": {"isolated_confidence": "0.05000", "isolated_explanation": "The cited authority is biased."}, "before": {"id": 114, "id_expl_id": 853, "isolated_confidence": 0.98, "isolated_explanation": "There seems to be robust confirmation of this fact", "isolated_confidence_expl_id": 853, "isolated_explanation_expl_id": 853}}, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "New evidence about the authority", "tableName": "argument_judgement", "targetLabel": "IPCC AR6 (5%)"}
2025-04-20 19:15:46.752009+00	952	23	1	120	updateRecord	statement	{"id": 120, "diff": {"after": {"text": "Животные существовали не ради человека до его появления. "}, "before": {"id": 120, "text": "Животные существовали не ради человека. ", "id_expl_id": 948, "text_expl_id": 948}}, "user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) Животные существовали не ради человека до его появления. "}
2025-04-22 04:49:10.460482+00	987	18	1	15	insertRecord	directive_scope	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 15, "label": "(−) US citizens", "include": false, "id_expl_id": 987, "directive_id": 124, "include_expl_id": 987, "person_category_id": 3, "directive_id_expl_id": 987, "person_category_id_expl_id": 987}, "tableName": "directive_scope", "targetLabel": "(−) US citizens"}
2025-04-10 19:30:13.133083+00	673	20	1	92	insertExtRecord	argument	{"user": {"id": 20, "name": "Griffin", "auth_role": "invited"}, "record": {"id": 92, "pro": false, "title": "stalled investigation", "id_expl_id": 673, "pro_expl_id": 673, "statement_id": 69, "title_expl_id": 673, "argument_type_id": 4, "statement_id_expl_id": 673, "argument_type_id_expl_id": 673}, "extRecord": {"id": 92, "text": "The people who came to power as the result of this have stalled the investigation.\\nFinding that the sniper was not aligned with Yanukovych would undermine their authority. Perhaps the successors have stalled the investigation because the claim is false and they don't want it to be revealed. ", "id_expl_id": 673, "text_expl_id": 673}, "tableName": "argument", "targetLabel": "stalled investigation", "extTableName": "argument_explanation"}
2025-04-11 19:44:27.733801+00	719	18	1	78	insertCrossRecords	statement	\N
2025-04-15 00:02:42.606346+00	785	5	1	11	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 11, "name": "induction", "id_expl_id": 785, "description": "The argument moves from a set of specific observations to a broader generalization. It suggests that what is true in particular cases is likely true in general.", "name_expl_id": 785, "description_expl_id": 785}, "tableName": "argument_type", "targetLabel": "induction"}
2025-05-06 03:37:55.373261+00	1028	24	1	15	insertRecord	moral_weight_of_person	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 15, "label": "(-30 / misplaced item / m³) mess", "weight": -30, "owner_id": 24, "id_expl_id": 1028, "moral_good_id": 1, "weight_expl_id": 1028, "owner_id_expl_id": 1028, "moral_good_id_expl_id": 1028}, "tableName": "moral_weight_of_person", "targetLabel": "(-30 / misplaced item / m³) mess"}
2025-04-18 17:42:23.896747+00	832	11	1	97	insertRecord	statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 97, "text": "penicillin was used to treat infections in 1943", "label": "(?) penicillin was used to treat infections in 1943", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 832, "text_expl_id": 832, "decided_expl_id": 832, "featured_expl_id": 832, "statement_type_id": 1, "confidence_expl_id": 832, "statement_type_name": "descriptive", "statement_type_id_expl_id": 832}, "tableName": "statement", "targetLabel": "(?) penicillin was used to treat infections in 1943"}
2025-04-20 19:30:33.810115+00	955	23	1	122	insertRecord	statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 122, "text": "Дети находяться ниже в иерархии, чем взрослые. Но это не значит, что взрослые могут кушать детей.", "label": "(?) Дети находяться ниже в иерархии, чем взрослые. Но это не значит, что взрослые могут кушать детей.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 955, "text_expl_id": 955, "decided_expl_id": 955, "featured_expl_id": 955, "statement_type_id": 1, "confidence_expl_id": 955, "statement_type_name": "descriptive", "statement_type_id_expl_id": 955}, "tableName": "statement", "targetLabel": "(?) Дети находяться ниже в иерархии, чем взрослые. Но это не значит, что взрослые могут кушать детей."}
2025-04-18 17:47:43.938356+00	836	11	1	112	insertRecord	argument_judgement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 112, "label": "Oxford Uni Sci. Blog (100%)", "id_expl_id": 836, "isolated_confidence": 0.999, "isolated_explanation": "", "isolated_confidence_expl_id": 836, "isolated_explanation_expl_id": 836}, "tableName": "argument_judgement", "targetLabel": "Oxford Uni Sci. Blog (100%)"}
2025-04-22 04:50:09.064054+00	988	18	1	16	insertRecord	directive_scope	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 16, "label": "(+) block of flats residents", "include": true, "id_expl_id": 988, "directive_id": 124, "include_expl_id": 988, "person_category_id": 1, "directive_id_expl_id": 988, "person_category_id_expl_id": 988}, "tableName": "directive_scope", "targetLabel": "(+) block of flats residents"}
2025-04-18 17:51:02.38034+00	838	11	1	111	insertRecord	argument_judgement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 111, "label": "from Wikipedia (98%)", "id_expl_id": 838, "isolated_confidence": 0.98, "isolated_explanation": "It is sometimes hard to verify if the discovery was done by a particular person at a particular time or if it was \\"borrowed\\" from somebody else. ", "isolated_confidence_expl_id": 838, "isolated_explanation_expl_id": 838}, "tableName": "argument_judgement", "targetLabel": "from Wikipedia (98%)"}
2025-04-19 21:06:34.141228+00	890	10	1	45	updateRecord	argument_judgement	{"id": 45, "diff": {"after": {"isolated_confidence": "0.85000", "isolated_explanation": "There are still big unknowns. Models built without full understanding can be accurate by chance. It doesn't mean that they are likely to be accurate."}, "before": {"id": 45, "id_expl_id": 866, "isolated_confidence": 0.05, "isolated_explanation": "It's no longer such a big unknown and progress can be made without high certainty anyway. ", "isolated_confidence_expl_id": 866, "isolated_explanation_expl_id": 866}}, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "Increased confidence in the parts of the argument.  ", "tableName": "argument_judgement", "targetLabel": "clouds & vapour (85%)"}
2025-05-02 22:51:03.768262+00	1013	18	1	11	deleteById	moral_weight_of_person	{"id": 11, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_person", "targetLabel": "(-2 / upheld) following petty rules", "deletedRecords": {"moral_weight_of_person": [{"id": 11, "label": "(-2 / upheld) following petty rules", "weight": -2, "owner_id": 18, "id_expl_id": 1001, "moral_good_id": 3, "weight_expl_id": 1001, "owner_id_expl_id": 1001, "moral_good_id_expl_id": 1001}]}}
2025-04-19 23:11:09.592211+00	898	10	1	70	insertRecord	critical_statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 70, "label": "(95%) IPCC is biased towards alarmism", "id_expl_id": 898, "argument_id": 122, "statement_id": 100, "argument_id_expl_id": 898, "critical_question_id": 1, "statement_id_expl_id": 898, "critical_question_id_expl_id": 898}, "tableName": "critical_statement", "targetLabel": "(95%) IPCC is biased towards alarmism"}
2025-04-10 19:36:36.472952+00	674	20	1	93	insertExtRecord	argument	{"user": {"id": 20, "name": "Griffin", "auth_role": "invited"}, "record": {"id": 93, "pro": false, "title": "not in his interest", "id_expl_id": 674, "pro_expl_id": 674, "statement_id": 69, "title_expl_id": 674, "argument_type_id": 4, "statement_id_expl_id": 674, "argument_type_id_expl_id": 674}, "extRecord": {"id": 93, "text": "It was not in the interest of Yanukovych to cause a massacre.  He could have dispersed the protests by using less violent means. Moreover, he has already agreed to step down at the next elections by that point. ", "id_expl_id": 674, "text_expl_id": 674}, "tableName": "argument", "targetLabel": "not in his interest", "extTableName": "argument_explanation"}
2025-04-10 19:45:36.778717+00	678	21	1	70	insertExtRecord	statement	{"user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "record": {"id": 70, "text": "", "label": "(?)  should ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 678, "text_expl_id": 678, "decided_expl_id": 678, "featured_expl_id": 678, "confidence_expl_id": 678, "argument_aggregation_type_id": 3, "argument_aggregation_type_name": "normative", "argument_aggregation_type_id_expl_id": 678}, "extRecord": {"id": 70, "deed_id": 4, "id_expl_id": 678, "deed_id_expl_id": 678}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-04-15 00:03:25.47048+00	786	5	1	12	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 12, "name": "definition", "id_expl_id": 786, "description": "\\"The argument hinges on the way a key term or concept is defined. It contends that because something meets (or does not meet) a certain definition, a conclusion follows.", "name_expl_id": 786, "description_expl_id": 786}, "tableName": "argument_type", "targetLabel": "definition"}
2025-04-11 19:49:09.123535+00	720	18	1	24	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 24, "name": "tag 5", "id_expl_id": 720, "description": " ", "name_expl_id": 720, "description_expl_id": 720}, "tableName": "tag", "targetLabel": "tag 5"}
2025-04-15 00:16:08.331837+00	791	5	1	10	updateRecord	argument_type	{"id": 10, "diff": {"after": {"description": "The argument focuses on the practical consequences or outcomes of accepting or rejecting a claim. Often asserts that a claim or action should be adopted because it leads to beneficial results or avoided because it leads to harmful outcomes."}, "before": {"id": 10, "id_expl_id": 537, "description": "A normative argument, in essence, is an argument that makes a claim about what ought to be, or what is morally right or wrong, rather than simply stating what is. It's about evaluating actions, policies, or situations based on values and standards of what is considered good or desirable. ", "description_expl_id": 537}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "pragmatic"}
2025-04-15 00:17:59.961518+00	793	5	1	3	updateRecord	argument_type	{"id": 3, "diff": {"after": {"description": "The argument does not clearly fit any of the above categories. The line of reasoning may be unusual, mixed, or not yet covered by existing definitions."}, "before": {"id": 3, "id_expl_id": null, "description": "arguments that did't fit in any other type", "description_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "other"}
2025-04-15 00:19:38.311656+00	795	5	1	8	updateRecord	argument_type	{"id": 8, "diff": {"after": {"description": "The argument provides direct evidence or examples to demonstrate that a phenomenon or fact does exist."}, "before": {"id": 8, "id_expl_id": 182, "description": "show the existence of some category by providing an example ", "description_expl_id": 182}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "example"}
2025-04-18 17:42:25.727995+00	833	11	1	60	insertRecord	critical_statement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 60, "label": "(?) penicillin was used to treat infections in 1943", "id_expl_id": 833, "argument_id": 110, "statement_id": 97, "argument_id_expl_id": 833, "critical_question_id": 1, "statement_id_expl_id": 833, "critical_question_id_expl_id": 833}, "tableName": "critical_statement", "targetLabel": "(?) penicillin was used to treat infections in 1943"}
2025-04-20 19:30:38.616441+00	956	23	1	84	insertRecord	critical_statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 84, "label": "(?) Дети находяться ниже в иерархии, чем взрослые. Но это не значит, что взрослые могут кушать детей.", "id_expl_id": 956, "argument_id": 126, "statement_id": 122, "argument_id_expl_id": 956, "critical_question_id": 46, "statement_id_expl_id": 956, "critical_question_id_expl_id": 956}, "tableName": "critical_statement", "targetLabel": "(?) Дети находяться ниже в иерархии, чем взрослые. Но это не значит, что взрослые могут кушать детей."}
2025-04-19 23:00:20.262205+00	891	10	1	67	insertRecord	critical_statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 67, "label": "(6%) A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change.", "id_expl_id": 891, "argument_id": 46, "statement_id": 47, "argument_id_expl_id": 891, "critical_question_id": 1, "statement_id_expl_id": 891, "critical_question_id_expl_id": 891}, "tableName": "critical_statement", "targetLabel": "(6%) A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change."}
2025-04-22 04:52:58.86998+00	989	18	1	16	deleteById	directive_scope	{"id": 16, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "directive_scope", "targetLabel": "(+) block of flats residents", "deletedRecords": {"directive_scope": [{"id": 16, "label": "(+) block of flats residents", "include": true, "id_expl_id": 988, "directive_id": 124, "include_expl_id": 988, "person_category_id": 1, "directive_id_expl_id": 988, "person_category_id_expl_id": 988}]}}
2025-05-14 00:20:56.586831+00	1072	25	1	\N	insertRecord	statement	\N
2025-04-10 19:38:45.889755+00	675	20	1	18	insertRecord	tag	{"user": {"id": 20, "name": "Griffin", "auth_role": "invited"}, "record": {"id": 18, "name": "war in Ukraine", "id_expl_id": 675, "description": " ", "name_expl_id": 675, "description_expl_id": 675}, "tableName": "tag", "targetLabel": "war in Ukraine"}
2025-04-11 19:49:21.705935+00	721	18	1	79	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 79, "text": "tag test 5", "label": "(?) tag test 5", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 721, "text_expl_id": 721, "decided_expl_id": 721, "featured_expl_id": 721, "confidence_expl_id": 721, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 721}, "tableName": "statement", "targetLabel": "(?) tag test 5"}
2025-04-15 00:03:59.340356+00	787	5	1	13	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 13, "name": "causal", "id_expl_id": 787, "description": "The argument claims a cause-effect relationship between two things. It often posits that one event leads (or led) to another.", "name_expl_id": 787, "description_expl_id": 787}, "tableName": "argument_type", "targetLabel": "causal"}
2025-04-21 02:01:08.330107+00	957	18	1	27	updateRecord	tag	{"id": 27, "diff": {"after": {"name": "права животных"}, "before": {"id": 27, "name": "animal rights", "id_expl_id": 926, "name_expl_id": 926}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "tag", "targetLabel": "права животных"}
2025-04-15 00:04:30.806162+00	788	5	1	14	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 14, "name": "normative", "id_expl_id": 788, "description": "The argument makes a value judgment or recommendation (e.g., claims about what should or ought to be done). It typically concerns ethics, policy, or other prescriptive domains.", "name_expl_id": 788, "description_expl_id": 788}, "tableName": "argument_type", "targetLabel": "normative"}
2025-04-15 00:05:40.405987+00	789	5	1	15	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 15, "name": "contradiction", "id_expl_id": 789, "description": "The argument attempts to show that a statement leads to a contradiction or an absurd result. Therefore, it concludes that the original statement must be false or untenable.", "name_expl_id": 789, "description_expl_id": 789}, "tableName": "argument_type", "targetLabel": "contradiction"}
2025-04-23 21:29:02.49677+00	990	18	1	96	updateRecord	argument	{"id": 96, "diff": {"after": {"title": "harm of vaccines"}, "before": {"id": 96, "title": "harm", "id_expl_id": 694, "title_expl_id": 694}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "harm of vaccines"}
2025-04-15 00:06:18.928308+00	790	5	1	16	insertRecord	argument_type	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 16, "name": "feasibility", "id_expl_id": 790, "description": "The argument attacks a prescriptive statement or recommendation by claiming it is impossible (or infeasible) to follow. It concludes that because the suggested action cannot be done, it should not be prescribed or expected.", "name_expl_id": 790, "description_expl_id": 790}, "tableName": "argument_type", "targetLabel": "feasibility"}
2025-04-23 21:36:45.364398+00	991	23	1	133	insertExtRecord	argument	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 133, "pro": false, "title": "Вакцины спасают жизни", "id_expl_id": 991, "pro_expl_id": 991, "statement_id": 71, "title_expl_id": 991, "argument_type_id": 10, "statement_id_expl_id": 991, "argument_type_id_expl_id": 991}, "extRecord": {"id": 133, "text": "Вакцины уменьшают количество заражений и даже полностью побеждают некоторые болезни. ", "id_expl_id": 991, "text_expl_id": 991}, "tableName": "argument", "targetLabel": "Вакцины спасают жизни", "extTableName": "argument_pragmatic"}
2025-04-18 17:45:37.20648+00	834	11	1	112	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 112, "pro": true, "title": "Oxford Uni Sci. Blog", "id_expl_id": 834, "pro_expl_id": 834, "statement_id": 97, "title_expl_id": 834, "argument_type_id": 1, "statement_id_expl_id": 834, "argument_type_id_expl_id": 834}, "extRecord": {"id": 112, "quote": "In 1943, Florey and Chain travelled out to North Africa to oversee the use of penicillin to treat infected injuries. Penicillin was also found to be extremely effective in treating the clap (gonorrhoea).", "authority": "University of Oxford is well known for its medical research.", "id_expl_id": 834, "source_url": "https://www.ox.ac.uk/news/science-blog/penicillin-oxford-story#:~:text=Still%2C%20Eric%20Sidebottom%20suggests%20some,%E2%80%99", "source_title": "Penicillin: the Oxford story", "quote_expl_id": 834, "authority_expl_id": 834, "source_url_expl_id": 834, "source_title_expl_id": 834}, "tableName": "argument", "targetLabel": "Oxford Uni Sci. Blog", "extTableName": "argument_authority"}
2025-04-19 23:01:02.196431+00	892	10	1	67	deleteById	critical_statement	{"id": 67, "user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "userExpl": "I will move it to a lower level", "tableName": "critical_statement", "targetLabel": "(6%) A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change.", "deletedRecords": {"critical_statement": [{"id": 67, "label": "(6%) A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change.", "id_expl_id": 891, "argument_id": 46, "statement_id": 47, "argument_id_expl_id": 891, "critical_question_id": 1, "statement_id_expl_id": 891, "critical_question_id_expl_id": 891}]}}
2025-05-02 22:51:06.945126+00	1014	18	1	12	deleteById	moral_weight_of_person	{"id": 12, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_person", "targetLabel": "(-4 / misplaced item / m³) mess", "deletedRecords": {"moral_weight_of_person": [{"id": 12, "label": "(-4 / misplaced item / m³) mess", "weight": -4, "owner_id": 18, "id_expl_id": 1002, "moral_good_id": 1, "weight_expl_id": 1002, "owner_id_expl_id": 1002, "moral_good_id_expl_id": 1002}]}}
2025-04-10 19:39:05.966182+00	676	20	1	69	insertCrossRecord	statement	{"user": {"id": 20, "name": "Griffin", "auth_role": "invited"}, "cross": {"id": 18, "label": "war in Ukraine", "tableName": "tag"}, "record": {"tag_id": 18, "statement_id": 69, "tag_id_expl_id": 676, "statement_id_expl_id": 676}, "target": {"id": 69, "label": "(?) Was the sniper that shot protesters in Kiev on the side of Yanukovych?", "tableName": "statement"}}
2025-04-10 19:53:31.457466+00	681	21	1	70	insertCrossRecord	statement	{"user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "cross": {"id": 18, "label": "war in Ukraine", "tableName": "tag"}, "record": {"tag_id": 18, "statement_id": 70, "tag_id_expl_id": 681, "statement_id_expl_id": 681}, "target": {"id": 70, "label": "(?) population of OECD countries should support doubling military support of Ukraine ", "tableName": "statement"}}
2025-04-11 19:49:22.101234+00	722	18	1	79	insertCrossRecords	statement	\N
2025-04-15 00:17:05.488739+00	792	5	1	1	updateRecord	argument_type	{"id": 1, "diff": {"after": {"description": "The argument cites an expert, a respected figure, or an authoritative source. It uses the authority’s statement or position to support its conclusion."}, "before": {"id": 1, "id_expl_id": null, "description": "", "description_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "authority"}
2025-04-15 00:20:06.383085+00	796	5	1	9	updateRecord	argument_type	{"id": 9, "diff": {"after": {"description": "The argument relies on a statement that is treated as too obvious or self-evident to challenge. The premise is often considered common sense or plainly undeniable."}, "before": {"id": 9, "id_expl_id": 385, "description": "This is an obvious statement, so adding more arguments is not required.", "description_expl_id": 385}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "obvious"}
2025-04-18 17:46:36.494202+00	835	11	1	110	updateRecord	argument	{"id": 110, "diff": {"after": {"title": "1944 mechanism discovery"}, "before": {"id": 110, "title": "June 1944 article", "id_expl_id": 828, "title_expl_id": 828}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "1944 mechanism discovery"}
2025-04-18 17:54:14.879882+00	842	11	1	50	insertRecord	argument_judgement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 50, "label": "Examples of such models (100%)", "id_expl_id": 842, "isolated_confidence": 1, "isolated_explanation": "Plenty of plausible examples were provided. One of them was verified explicitly.", "isolated_confidence_expl_id": 842, "isolated_explanation_expl_id": 842}, "tableName": "argument_judgement", "targetLabel": "Examples of such models (100%)"}
2025-04-21 02:06:56.390064+00	958	18	1	9	updateRecord	deed	{"id": 9, "diff": {"after": {"text": "кушать животных если они (люди) того хотят"}, "before": {"id": 9, "text": "кушать животных", "id_expl_id": 925, "text_expl_id": 925}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "если не хотят, то не должны", "tableName": "deed", "targetLabel": "кушать животных если они (люди) того хотят"}
2025-04-19 23:03:12.280395+00	893	10	1	103	insertRecord	statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 103, "text": "Climate scientists have a strong bias to reach conclusions that confirm that humans are causing climate change.", "label": "(?) Climate scientists have a strong bias to reach conclusions that confirm that humans are causing climate change.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 893, "text_expl_id": 893, "decided_expl_id": 893, "featured_expl_id": 893, "statement_type_id": 1, "confidence_expl_id": 893, "statement_type_name": "descriptive", "statement_type_id_expl_id": 893}, "tableName": "statement", "targetLabel": "(?) Climate scientists have a strong bias to reach conclusions that confirm that humans are causing climate change."}
2025-04-19 23:03:16.796043+00	894	10	1	68	insertRecord	critical_statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 68, "label": "(?) Climate scientists have a strong bias to reach conclusions that confirm that humans are causing climate change.", "id_expl_id": 894, "argument_id": 46, "statement_id": 103, "argument_id_expl_id": 894, "critical_question_id": 1, "statement_id_expl_id": 894, "critical_question_id_expl_id": 894}, "tableName": "critical_statement", "targetLabel": "(?) Climate scientists have a strong bias to reach conclusions that confirm that humans are causing climate change."}
2025-04-19 23:13:49.077279+00	899	10	1	123	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 123, "pro": true, "title": "Bengtsson case", "id_expl_id": 899, "pro_expl_id": 899, "statement_id": 103, "title_expl_id": 899, "argument_type_id": 8, "statement_id_expl_id": 899, "argument_type_id_expl_id": 899}, "extRecord": {"id": 123, "text": " Lennart Bengtsson in 2014 experienced a backlash after affiliating with a skeptical think tank (the GWPF). He reported being “surprised by the strong reaction” from colleagues and felt some were trying to silence or ostracize him​. He also had a paper rejected from Environmental Research Letters, and one peer reviewer’s comment suggested the paper was “less than helpful” in the context of climate policy – which Bengtsson interpreted as bias against a contrarian result. ", "id_expl_id": 899, "text_expl_id": 899}, "tableName": "argument", "targetLabel": "Bengtsson case", "extTableName": "argument_example"}
2025-04-21 02:36:23.385552+00	962	18	1	6	insertRecord	person_category	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 6, "name": "существа которые выше в иерархии", "id_expl_id": 962, "name_expl_id": 962}, "tableName": "person_category", "targetLabel": "существа которые выше в иерархии"}
2025-04-23 21:38:05.808917+00	993	23	1	91	insertRecord	critical_statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 91, "id_expl_id": 993, "argument_id": 133, "statement_id": 128, "argument_id_expl_id": 993, "critical_question_id": 1, "statement_id_expl_id": 993, "critical_question_id_expl_id": 993}, "tableName": "critical_statement", "targetLabel": 128}
2025-04-10 19:45:27.827797+00	677	21	1	4	insertRecord	deed	{"user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "record": {"id": 4, "text": "support doubling military support of Ukraine ", "id_expl_id": 677, "text_expl_id": 677}, "tableName": "deed", "targetLabel": "support doubling military support of Ukraine "}
2025-04-15 00:18:36.233584+00	794	5	1	4	updateRecord	argument_type	{"id": 4, "diff": {"after": {"description": "The argument proposes the most plausible explanation among competing hypotheses. It typically begins with an observation or set of facts, then infers which explanation is most likely true."}, "before": {"id": 4, "id_expl_id": null, "description": "Example: A is the cause of D because A is  the cause of B, B of C and finally C of D. ", "description_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "explanation"}
2025-04-11 19:57:11.89354+00	723	18	1	80	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 80, "text": "tag test 6", "label": "(?) tag test 6", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 723, "text_expl_id": 723, "decided_expl_id": 723, "featured_expl_id": 723, "confidence_expl_id": 723, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 723}, "tableName": "statement", "targetLabel": "(?) tag test 6"}
2025-04-18 17:47:44.104076+00	837	\N	1	97	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.9995}, "before": {"id": 97, "decided": false, "confidence": 0.5, "id_expl_id": 832, "decided_expl_id": 832, "confidence_expl_id": 832}}, "statement": {"id": 97, "text": "penicillin was used to treat infections in 1943", "id_expl_id": 832, "text_expl_id": 832}, "confidences": [[], [0.999]], "triggerLabel": "insert of argument judgement", "triggerExplId": 836, "statementArguments": [{"id": 112, "pro": true, "id_expl_id": 834, "pro_expl_id": 834, "statement_id": 97, "title_expl_id": 834, "argument_type_id": 1, "statement_id_expl_id": 834, "argument_type_id_expl_id": 834}], "argumentConfidences": [{"pro": true, "pro_expl_id": 834, "isolated_confidence": 0.999, "conditional_confidence": null, "isolated_confidence_expl_id": 836, "conditional_confidence_expl_id": null}]}
2025-04-19 23:08:17.40001+00	895	10	1	121	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 121, "pro": true, "title": "balance of incentives", "id_expl_id": 895, "pro_expl_id": 895, "statement_id": 103, "title_expl_id": 895, "argument_type_id": 4, "statement_id_expl_id": 895, "argument_type_id_expl_id": 895}, "extRecord": {"id": 121, "text": "Climate scientists have more incentives to reach that conclusion rather than the opposite.", "id_expl_id": 895, "text_expl_id": 895}, "tableName": "argument", "targetLabel": "balance of incentives", "extTableName": "argument_explanation"}
2025-05-02 22:52:31.816546+00	1015	18	1	13	insertRecord	moral_weight_of_person	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 13, "label": "(12 / minute) free time", "weight": 12, "owner_id": 18, "id_expl_id": 1015, "moral_good_id": 2, "weight_expl_id": 1015, "owner_id_expl_id": 1015, "moral_good_id_expl_id": 1015}, "tableName": "moral_weight_of_person", "targetLabel": "(12 / minute) free time"}
2025-04-21 02:25:22.476741+00	959	18	1	10	insertRecord	deed	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 10, "text": "есть существ, которые ниже в иерархии чем они если того пожелают", "id_expl_id": 959, "text_expl_id": 959}, "tableName": "deed", "targetLabel": "есть существ, которые ниже в иерархии чем они если того пожелают"}
2025-04-21 02:25:26.585856+00	960	18	1	123	insertExtRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 123, "text": "Существам которые находятся выше в иерархии допустимо есть существ, которые ниже в иерархии чем они.", "label": "(?)  should ", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 960, "text_expl_id": 960, "decided_expl_id": 960, "featured_expl_id": 960, "statement_type_id": 3, "confidence_expl_id": 960, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 960}, "extRecord": {"id": 123, "deed_id": 10, "id_expl_id": 960, "deed_id_expl_id": 960}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-04-23 21:38:03.372547+00	992	23	1	128	insertRecord	statement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 128, "text": "Вакцины победили некоторые болезни", "label": "(?) Вакцины победили некоторые болезни", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 992, "text_expl_id": 992, "decided_expl_id": 992, "featured_expl_id": 992, "statement_type_id": 1, "confidence_expl_id": 992, "statement_type_name": "descriptive", "statement_type_id_expl_id": 992}, "tableName": "statement", "targetLabel": "(?) Вакцины победили некоторые болезни"}
2025-04-23 21:51:55.376704+00	995	23	1	134	insertRecord	argument_judgement	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 134, "label": "Вакцинирование привело к уничтожении оспы  (100%)", "id_expl_id": 995, "isolated_confidence": 1, "isolated_explanation": "", "isolated_confidence_expl_id": 995, "isolated_explanation_expl_id": 995}, "tableName": "argument_judgement", "targetLabel": "Вакцинирование привело к уничтожении оспы  (100%)"}
2025-04-23 21:57:42.172928+00	998	23	1	3	deleteById	directive_consequence	{"id": 3, "user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "userExpl": "", "tableName": "directive_consequence", "targetLabel": "беспорядок -15 потерянный предмет / м³", "deletedRecords": {"directive_consequence": [{"id": 3, "label": "беспорядок -15 потерянный предмет / м³", "value_id": 15, "id_expl_id": 550, "argument_id": 88, "moral_good_id": 1, "value_id_expl_id": 551, "argument_id_expl_id": 550, "moral_good_id_expl_id": 550}]}}
2025-04-10 19:52:18.17563+00	679	21	1	4	insertRecord	person_category	{"user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "record": {"id": 4, "name": "population of OECD countries", "id_expl_id": 679, "name_expl_id": 679}, "tableName": "person_category", "targetLabel": "population of OECD countries"}
2025-04-11 19:57:12.377281+00	724	18	1	80	insertCrossRecords	statement	\N
2025-04-15 00:20:23.726618+00	797	5	1	12	updateRecord	argument_type	{"id": 12, "diff": {"after": {"description": "The argument hinges on the way a key term or concept is defined. It contends that because something meets (or does not meet) a certain definition, a conclusion follows."}, "before": {"id": 12, "id_expl_id": 786, "description": "\\"The argument hinges on the way a key term or concept is defined. It contends that because something meets (or does not meet) a certain definition, a conclusion follows.", "description_expl_id": 786}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "definition"}
2025-04-18 17:51:02.567996+00	839	\N	1	96	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.99}, "before": {"id": 96, "decided": false, "confidence": 0.5, "id_expl_id": 829, "decided_expl_id": 829, "confidence_expl_id": 829}}, "statement": {"id": 96, "text": "Margaret Jennings in 1944 discovered that penicillin is most effective against bacteria during their growth phase, as it interferes with the formation of the cell wall, leading to cell lysis.", "id_expl_id": 829, "text_expl_id": 829}, "confidences": [[], [0.98]], "triggerLabel": "insert of argument judgement", "triggerExplId": 838, "statementArguments": [{"id": 111, "pro": true, "id_expl_id": 831, "pro_expl_id": 831, "statement_id": 96, "title_expl_id": 831, "argument_type_id": 1, "statement_id_expl_id": 831, "argument_type_id_expl_id": 831}], "argumentConfidences": [{"pro": true, "pro_expl_id": 831, "isolated_confidence": 0.98, "conditional_confidence": null, "isolated_confidence_expl_id": 838, "conditional_confidence_expl_id": null}]}
2025-04-18 17:53:08.723198+00	841	\N	1	91	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.995}, "before": {"id": 91, "decided": false, "confidence": 0.5, "id_expl_id": 820, "decided_expl_id": 820, "confidence_expl_id": 820}}, "statement": {"id": 91, "text": "penicillin was used extensively to treat bacterial infections before the mechanism behind its action was fully understood", "id_expl_id": 820, "text_expl_id": 820}, "confidences": [[], [0.99]], "triggerLabel": "insert of argument judgement", "triggerExplId": 840, "statementArguments": [{"id": 110, "pro": true, "id_expl_id": 828, "pro_expl_id": 828, "statement_id": 91, "title_expl_id": 835, "argument_type_id": 6, "statement_id_expl_id": 828, "argument_type_id_expl_id": 828}], "argumentConfidences": [{"pro": true, "pro_expl_id": 828, "isolated_confidence": 0.99, "conditional_confidence": null, "isolated_confidence_expl_id": 840, "conditional_confidence_expl_id": null}]}
2025-04-19 23:10:44.273906+00	897	10	1	122	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 122, "pro": true, "title": "IPCC alarmism", "id_expl_id": 897, "pro_expl_id": 897, "statement_id": 103, "title_expl_id": 897, "argument_type_id": 8, "statement_id_expl_id": 897, "argument_type_id_expl_id": 897}, "extRecord": {"id": 122, "text": "IPCC is biased towards alarmism", "id_expl_id": 897, "text_expl_id": 897}, "tableName": "argument", "targetLabel": "IPCC alarmism", "extTableName": "argument_example"}
2025-05-03 00:31:03.206905+00	1016	18	1	68	insertCrossRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 26, "label": "US politics", "tableName": "tag"}, "record": {"tag_id": 26, "statement_id": 68, "tag_id_expl_id": 1016, "statement_id_expl_id": 1016}, "target": {"id": 68, "label": "(?) US citizens should support lifting restrictions on US fossil fuel energy production", "tableName": "statement"}}
2025-04-21 02:25:32.966145+00	961	18	1	85	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 85, "label": "(?) Существам которые находятся выше в иерархии допустимо есть существ, которые ниже в иерархии чем они.", "id_expl_id": 961, "argument_id": 126, "statement_id": 123, "argument_id_expl_id": 961, "critical_question_id": 6, "statement_id_expl_id": 961, "critical_question_id_expl_id": 961}, "tableName": "critical_statement", "targetLabel": "(?) Существам которые находятся выше в иерархии допустимо есть существ, которые ниже в иерархии чем они."}
2025-04-21 02:36:24.786371+00	963	18	1	12	insertRecord	directive_scope	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 12, "label": "(+) существа которые выше в иерархии", "include": true, "id_expl_id": 963, "directive_id": 123, "include_expl_id": 963, "person_category_id": 6, "directive_id_expl_id": 963, "person_category_id_expl_id": 963}, "tableName": "directive_scope", "targetLabel": "(+) существа которые выше в иерархии"}
2025-05-06 03:39:41.777943+00	1029	24	1	24	insertCrossRecord	person	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "cross": {"id": 1, "label": "block of flats residents", "tableName": "person_category"}, "record": {"person_id": 24, "person_id_expl_id": 1029, "person_category_id": 1, "person_category_id_expl_id": 1029}, "target": {"id": 24, "label": "Demo User 1", "tableName": "person"}}
2025-04-21 02:38:04.433522+00	964	18	1	130	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 130, "pro": false, "title": "нельзя есть детей", "id_expl_id": 964, "pro_expl_id": 964, "statement_id": 123, "title_expl_id": 964, "argument_type_id": 15, "statement_id_expl_id": 964, "argument_type_id_expl_id": 964}, "extRecord": {"id": 130, "text": "Дети находяться ниже в иерархии, чем взрослые. Но это не значит, что взрослые могут кушать детей.", "id_expl_id": 964, "text_expl_id": 964}, "tableName": "argument", "targetLabel": "нельзя есть детей", "extTableName": "argument_contradiction"}
2025-04-10 19:52:21.997494+00	680	21	1	6	insertRecord	directive_scope	{"user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "record": {"id": 6, "label": "(+) population of OECD countries", "include": true, "id_expl_id": 680, "directive_id": 70, "include_expl_id": 680, "person_category_id": 4, "directive_id_expl_id": 680, "person_category_id_expl_id": 680}, "tableName": "directive_scope", "targetLabel": "(+) population of OECD countries"}
2025-04-10 19:54:08.466014+00	682	21	1	69	updateRecord	statement	{"id": 69, "diff": {"after": {"text": "The sniper that shot protesters in Kiev on the side of Yanukovych"}, "before": {"id": 69, "text": "Was the sniper that shot protesters in Kiev on the side of Yanukovych?", "text_expl_id": 672}}, "user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) The sniper that shot protesters in Kiev on the side of Yanukovych"}
2025-04-15 01:10:50.486153+00	798	5	1	10	updateRecord	critical_question	{"id": 10, "diff": {"after": {"text": "Does the argument address the right statement?"}, "before": {"id": 10, "text": "Does the argument address the right question?", "id_expl_id": 177, "text_expl_id": 177}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "critical_question", "targetLabel": "Does the argument address the right statement?"}
2025-04-11 20:07:24.962659+00	725	18	1	81	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 81, "text": "tag test 7", "label": "(?) tag test 7", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 725, "text_expl_id": 725, "decided_expl_id": 725, "featured_expl_id": 725, "confidence_expl_id": 725, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 725}, "tableName": "statement", "targetLabel": "(?) tag test 7"}
2025-04-11 20:07:51.10243+00	727	18	1	25	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 25, "name": "tag 8", "id_expl_id": 727, "description": " ", "name_expl_id": 727, "description_expl_id": 727}, "tableName": "tag", "targetLabel": "tag 8"}
2025-04-18 17:53:08.512543+00	840	11	1	110	insertRecord	argument_judgement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 110, "label": "1944 mechanism discovery (99%)", "id_expl_id": 840, "isolated_confidence": 0.99, "isolated_explanation": "the use in 1943 was before full scientific understanding in 1944", "isolated_confidence_expl_id": 840, "isolated_explanation_expl_id": 840}, "tableName": "argument_judgement", "targetLabel": "1944 mechanism discovery (99%)"}
2025-04-21 02:40:55.702663+00	965	18	1	122	deleteById	statement	{"id": 122, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "Добвил скрытую посылку об общем принципе и помести это утверждение в форме аргумента туда", "tableName": "statement", "targetLabel": "(?) Дети находяться ниже в иерархии, чем взрослые. Но это не значит, что взрослые могут кушать детей.", "deletedRecords": {"statement": [{"id": 122, "text": "Дети находяться ниже в иерархии, чем взрослые. Но это не значит, что взрослые могут кушать детей.", "label": "(?) Дети находяться ниже в иерархии, чем взрослые. Но это не значит, что взрослые могут кушать детей.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 955, "text_expl_id": 955, "decided_expl_id": 955, "featured_expl_id": 955, "statement_type_id": 1, "confidence_expl_id": 955, "statement_type_name": "descriptive", "statement_type_id_expl_id": 955}], "critical_statement": [{"id": 84, "label": "(?) Дети находяться ниже в иерархии, чем взрослые. Но это не значит, что взрослые могут кушать детей.", "id_expl_id": 956, "argument_id": 126, "statement_id": 122, "argument_id_expl_id": 956, "critical_question_id": 46, "statement_id_expl_id": 956, "critical_question_id_expl_id": 956}]}}
2025-04-19 23:26:37.718714+00	900	10	1	104	insertRecord	statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 104, "text": "Lennart Bengtsson in 2014 experienced a backlash after affiliating with a skeptical think tank (the GWPF)", "label": "(?) Lennart Bengtsson in 2014 experienced a backlash after affiliating with a skeptical think tank (the GWPF)", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 900, "text_expl_id": 900, "decided_expl_id": 900, "featured_expl_id": 900, "statement_type_id": 1, "confidence_expl_id": 900, "statement_type_name": "descriptive", "statement_type_id_expl_id": 900}, "tableName": "statement", "targetLabel": "(?) Lennart Bengtsson in 2014 experienced a backlash after affiliating with a skeptical think tank (the GWPF)"}
2025-04-23 21:43:27.581488+00	994	23	1	134	insertExtRecord	argument	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 134, "pro": true, "title": "Вакцинирование привело к уничтожении оспы ", "id_expl_id": 994, "pro_expl_id": 994, "statement_id": 128, "title_expl_id": 994, "argument_type_id": 8, "statement_id_expl_id": 994, "argument_type_id_expl_id": 994}, "extRecord": {"id": 134, "text": "Массовая вакцинация остановила оспу. ", "id_expl_id": 994, "text_expl_id": 994}, "tableName": "argument", "targetLabel": "Вакцинирование привело к уничтожении оспы ", "extTableName": "argument_example"}
2025-05-03 00:38:25.112178+00	1017	18	1	86	updateExtRecord	argument	{"id": 86, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "Added a justification for why it's petty.", "extRecord": {"after": {"text": "The rule to lock rubbish bins is petty. Nothing terrible happens when it's broken from time to time. Many places don't have this rule at all."}, "before": {"id": 86, "text": "the rule to lock rubbish bins is petty", "id_expl_id": 539, "text_expl_id": 539}}, "tableName": "argument", "targetLabel": "petty rule", "extTableName": "argument_pragmatic"}
2025-06-26 19:59:09.272764+00	1172	18	1	18	updateRecord	person	{"id": 18, "diff": {"after": {"language": "english"}, "before": {"id": 18, "language": "russian", "id_expl_id": 504, "language_expl_id": 1171}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Дуранте"}
2025-04-10 19:54:27.41394+00	683	21	1	69	updateRecord	statement	{"id": 69, "diff": {"after": {"text": "the sniper that shot protesters in Kiev on the side of Yanukovych"}, "before": {"id": 69, "text": "The sniper that shot protesters in Kiev on the side of Yanukovych", "text_expl_id": 682}}, "user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) the sniper that shot protesters in Kiev on the side of Yanukovych"}
2025-04-11 20:07:25.394521+00	726	18	1	81	insertCrossRecords	statement	{"id": 81, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 725}, "fkEnries": {"tags": {"options": [{"id": 17, "label": "example"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?) tag test 7"}
2025-04-11 20:08:03.232617+00	728	18	1	82	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 82, "text": "tag test 8", "label": "(?) tag test 8", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 728, "text_expl_id": 728, "decided_expl_id": 728, "featured_expl_id": 728, "confidence_expl_id": 728, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 728}, "tableName": "statement", "targetLabel": "(?) tag test 8"}
2025-04-11 20:20:30.612227+00	731	5	1	\N	deleteByIds	tag	{"ids": [25, 24, 23, 22, 21, 20], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "tag", "targetLabel": "25, 24, 23, 22, 21, 20", "deletedRecords": {"tag": [{"id": 20, "name": "test tag", "id_expl_id": 706, "description": " ", "name_expl_id": 706, "description_expl_id": 706}, {"id": 21, "name": "test 2", "id_expl_id": 708, "description": " ", "name_expl_id": 708, "description_expl_id": 708}, {"id": 22, "name": "tag3", "id_expl_id": 712, "description": " ", "name_expl_id": 712, "description_expl_id": 712}, {"id": 23, "name": "tag 4", "id_expl_id": 715, "description": " ", "name_expl_id": 715, "description_expl_id": 715}, {"id": 24, "name": "tag 5", "id_expl_id": 720, "description": " ", "name_expl_id": 720, "description_expl_id": 720}, {"id": 25, "name": "tag 8", "id_expl_id": 727, "description": " ", "name_expl_id": 727, "description_expl_id": 727}]}}
2025-04-11 20:25:52.439331+00	732	18	1	83	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 83, "text": "test statement 1", "label": "(?) test statement 1", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 732, "text_expl_id": 732, "decided_expl_id": 732, "featured_expl_id": 732, "confidence_expl_id": 732, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 732}, "tableName": "statement", "targetLabel": "(?) test statement 1"}
2025-04-11 20:26:08.111943+00	734	18	1	83	deleteById	statement	{"id": 83, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) test statement 1", "deletedRecords": {"statement": [{"id": 83, "text": "test statement 1", "label": "(?) test statement 1", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 732, "text_expl_id": 732, "decided_expl_id": 732, "featured_expl_id": 732, "confidence_expl_id": 732, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 732}], "critical_statement": [{"id": 55, "label": "(?) test statement 1", "id_expl_id": 733, "argument_id": 87, "statement_id": 83, "argument_id_expl_id": 733, "critical_question_id": 1, "statement_id_expl_id": 733, "critical_question_id_expl_id": 733}]}}
2025-04-15 01:12:14.14254+00	799	5	1	4	updateRecord	critical_question	{"id": 4, "diff": {"after": {"text": "Is the authority qualified to speak on this issue?"}, "before": {"id": 4, "text": "Is there a reason to doubt the authority?", "id_expl_id": null, "text_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "critical_question", "targetLabel": "Is the authority qualified to speak on this issue?"}
2025-04-18 23:24:24.683862+00	844	11	1	45	updateRecord	statement	{"id": 45, "diff": {"after": {"text": "While a significant gap in understanding and modelling cloud formation creates a problem for predicting future climate, the claim is about the past."}, "before": {"id": 45, "text": "While a significant gap in understanding and modelling cloud formation creates a problem for predicting future climate, the actual question is about the past.", "id_expl_id": 178, "text_expl_id": 178}}, "user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) While a significant gap in understanding and modelling cloud formation creates a problem for predicting future climate, the claim is about the past."}
2025-04-21 02:42:20.704971+00	966	18	1	46	deleteById	critical_question	{"id": 46, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "Лучше добавлять арнументы от противоречия вместо критических утверждений.", "tableName": "critical_question", "targetLabel": "Приводит ли приминение этой логики к другим случаям к абсурду?", "deletedRecords": {"critical_question": [{"id": 46, "text": "Приводит ли приминение этой логики к другим случаям к абсурду?", "id_expl_id": 953, "text_expl_id": 954, "argument_type_id": 6, "argument_type_id_expl_id": 953}]}}
2025-04-19 23:26:47.130829+00	901	10	1	71	insertRecord	critical_statement	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 71, "label": "(?) Lennart Bengtsson in 2014 experienced a backlash after affiliating with a skeptical think tank (the GWPF)", "id_expl_id": 901, "argument_id": 123, "statement_id": 104, "argument_id_expl_id": 901, "critical_question_id": 1, "statement_id_expl_id": 901, "critical_question_id_expl_id": 901}, "tableName": "critical_statement", "targetLabel": "(?) Lennart Bengtsson in 2014 experienced a backlash after affiliating with a skeptical think tank (the GWPF)"}
2025-12-18 12:45:41.860482+00	1939	18	1	15	insertRecord	deed	{"user": {"id": 18, "name": "Durante", "auth_role": "invited", "permission_level": 1000}, "record": {"id": 15, "text": "test deed 2", "id_expl_id": 1939, "text_expl_id": 1939}, "tableName": "deed", "targetLabel": "test deed 2"}
2025-04-10 19:55:32.971593+00	684	21	1	69	updateRecord	statement	{"id": 69, "diff": {"after": {"text": "the sniper that shot protesters in Kiev was on the side of Yanukovych"}, "before": {"id": 69, "text": "the sniper that shot protesters in Kiev on the side of Yanukovych", "text_expl_id": 683}}, "user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) the sniper that shot protesters in Kiev was on the side of Yanukovych"}
2025-04-11 20:08:03.540095+00	729	18	1	82	insertCrossRecords	statement	{"id": 82, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 728}, "fkEnries": {"tags": {"options": [{"id": 17, "label": "example"}, {"id": 24, "label": "tag 5"}, {"id": 25, "label": "tag 8"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?) tag test 8"}
2025-04-11 20:25:54.706312+00	733	18	1	55	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 55, "label": "(?) test statement 1", "id_expl_id": 733, "argument_id": 87, "statement_id": 83, "argument_id_expl_id": 733, "critical_question_id": 1, "statement_id_expl_id": 733, "critical_question_id_expl_id": 733}, "tableName": "critical_statement", "targetLabel": "(?) test statement 1"}
2025-04-15 01:13:18.11603+00	800	5	1	7	updateRecord	critical_question	{"id": 7, "diff": {"after": {"text": "Are there relevant differences that undermine the similarity?"}, "before": {"id": 7, "text": "Are there relevant differences?", "id_expl_id": 138, "text_expl_id": 138}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "critical_question", "targetLabel": "Are there relevant differences that undermine the similarity?"}
2025-04-15 01:14:30.433063+00	802	5	1	9	updateRecord	critical_question	{"id": 9, "diff": {"after": {"text": "Is the complexity or scale directly comparable to the smaller or simpler case?"}, "before": {"id": 9, "text": "Are there relevant differences?", "id_expl_id": 168, "text_expl_id": 168}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "critical_question", "targetLabel": "Is the complexity or scale directly comparable to the smaller or simpler case?"}
2025-04-18 23:28:15.027203+00	845	11	1	113	insertExtRecord	argument	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 113, "pro": false, "title": "past explanation problem", "id_expl_id": 845, "pro_expl_id": 845, "statement_id": 45, "title_expl_id": 845, "argument_type_id": 6, "statement_id_expl_id": 845, "argument_type_id_expl_id": 845}, "extRecord": {"id": 113, "text": "Lack of understanding could mean that the given explanation for the changes in the past is incorrect but rather coincidental, while the real reason is related to cloud formation and water vapour. ", "id_expl_id": 845, "text_expl_id": 845}, "tableName": "argument", "targetLabel": "past explanation problem", "extTableName": "argument_deduction"}
2025-05-06 04:15:58.47799+00	1030	24	1	131	insertRecord	statement	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 131, "text": "this demo is useful", "label": "(?) this demo is useful", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 1030, "text_expl_id": 1030, "decided_expl_id": 1030, "featured_expl_id": 1030, "statement_type_id": 1, "confidence_expl_id": 1030, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1030}, "tableName": "statement", "targetLabel": "(?) this demo is useful"}
2025-04-18 23:33:26.709135+00	846	11	1	113	insertRecord	argument_judgement	{"user": {"id": 11, "name": "Martin", "auth_role": "invited"}, "record": {"id": 113, "label": "past explanation problem (90%)", "id_expl_id": 846, "isolated_confidence": 0.9, "isolated_explanation": "it's possible to overlook gaps in understanding given that the models work without them, but it would be a large omission", "isolated_confidence_expl_id": 846, "isolated_explanation_expl_id": 846}, "tableName": "argument_judgement", "targetLabel": "past explanation problem (90%)"}
2025-04-21 04:35:53.531754+00	967	18	1	86	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 86, "id_expl_id": 967, "argument_id": 126, "statement_id": 115, "argument_id_expl_id": 967, "critical_question_id": 6, "statement_id_expl_id": 967, "critical_question_id_expl_id": 967}, "tableName": "critical_statement", "targetLabel": 115}
2025-04-19 23:30:02.882669+00	902	10	1	124	insertExtRecord	argument	{"user": {"id": 10, "name": "Julie", "auth_role": "invited"}, "record": {"id": 124, "pro": true, "title": "The Times report", "id_expl_id": 902, "pro_expl_id": 902, "statement_id": 104, "title_expl_id": 902, "argument_type_id": 1, "statement_id_expl_id": 902, "argument_type_id_expl_id": 902}, "extRecord": {"id": 124, "quote": "\\"I was surprised by the strong reaction from some scientists outside the UK to joining the Global Warming Policy Foundation this month. I had hoped that it would be platform to bring more common sense into the global climate debate.\\"", "authority": "Bengtsson's own words reported by The Sunday Times", "id_expl_id": 902, "source_url": "https://www.sciencemediacentre.org/expert-reaction-to-claims-climate-research-was-suppressed/#:~:text=%E2%80%9CI%20was%20surprised%20by%20the,into%20the%20global%20climate%20debate", "source_title": "expert reaction to claims climate research was ‘suppressed’ | Science Media Centre", "quote_expl_id": 902, "authority_expl_id": 902, "source_url_expl_id": 902, "source_title_expl_id": 902}, "tableName": "argument", "targetLabel": "The Times report", "extTableName": "argument_authority"}
2025-04-21 04:36:09.275384+00	968	18	1	87	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 87, "id_expl_id": 968, "argument_id": 126, "statement_id": 116, "argument_id_expl_id": 968, "critical_question_id": 1, "statement_id_expl_id": 968, "critical_question_id_expl_id": 968}, "tableName": "critical_statement", "targetLabel": 116}
2025-05-03 00:41:53.761767+00	1018	18	1	47	insertRecord	critical_question	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 47, "text": "What are the sizes of the consequences?", "id_expl_id": 1018, "text_expl_id": 1018, "argument_type_id": 10, "argument_type_id_expl_id": 1018}, "tableName": "critical_question", "targetLabel": "What are the sizes of the consequences?"}
2025-04-10 20:01:57.212385+00	685	21	1	94	insertExtRecord	argument	{"user": {"id": 21, "name": "Anton", "auth_role": "invited"}, "record": {"id": 94, "pro": true, "title": "normalisation of war", "id_expl_id": 685, "pro_expl_id": 685, "statement_id": 70, "title_expl_id": 685, "argument_type_id": 10, "statement_id_expl_id": 685, "argument_type_id_expl_id": 685}, "extRecord": {"id": 94, "text": "Letting Putin win would re-normalise war as a valid method to achieve goals in international politics.\\nHence there will be more war.\\nHence there will be more victims of was and less human development.", "id_expl_id": 685, "text_expl_id": 685}, "tableName": "argument", "targetLabel": "normalisation of war", "extTableName": "argument_normative"}
2025-04-11 20:20:13.404584+00	730	5	1	\N	deleteByIds	statement	{"ids": [75, 76, 77, 78, 79, 80, 81, 82], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "75, 76, 77, 78, 79, 80, 81, 82", "deletedRecords": {"statement": [{"id": 75, "text": "tag test 1", "label": "(?) tag test 1", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 713, "text_expl_id": 713, "decided_expl_id": 713, "featured_expl_id": 713, "confidence_expl_id": 713, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 713}, {"id": 76, "text": "tag test 2", "label": "(?) tag test 2", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 714, "text_expl_id": 714, "decided_expl_id": 714, "featured_expl_id": 714, "confidence_expl_id": 714, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 714}, {"id": 77, "text": "tag test 3", "label": "(?) tag test 3", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 716, "text_expl_id": 716, "decided_expl_id": 716, "featured_expl_id": 716, "confidence_expl_id": 716, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 716}, {"id": 78, "text": "tag test 4", "label": "(?) tag test 4", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 718, "text_expl_id": 718, "decided_expl_id": 718, "featured_expl_id": 718, "confidence_expl_id": 718, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 718}, {"id": 79, "text": "tag test 5", "label": "(?) tag test 5", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 721, "text_expl_id": 721, "decided_expl_id": 721, "featured_expl_id": 721, "confidence_expl_id": 721, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 721}, {"id": 80, "text": "tag test 6", "label": "(?) tag test 6", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 723, "text_expl_id": 723, "decided_expl_id": 723, "featured_expl_id": 723, "confidence_expl_id": 723, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 723}, {"id": 81, "text": "tag test 7", "label": "(?) tag test 7", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 725, "text_expl_id": 725, "decided_expl_id": 725, "featured_expl_id": 725, "confidence_expl_id": 725, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 725}, {"id": 82, "text": "tag test 8", "label": "(?) tag test 8", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 728, "text_expl_id": 728, "decided_expl_id": 728, "featured_expl_id": 728, "confidence_expl_id": 728, "argument_aggregation_type_id": 1, "argument_aggregation_type_name": "evidential", "argument_aggregation_type_id_expl_id": 728}]}}
2025-04-15 01:13:53.447111+00	801	5	1	8	updateRecord	critical_question	{"id": 8, "diff": {"after": {"text": "Is the effect strong enough to explain the full extent of the observed phenomenon?"}, "before": {"id": 8, "text": "Is the effect strong enough to explain the full extent of the observed change?", "id_expl_id": 141, "text_expl_id": 141}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "critical_question", "targetLabel": "Is the effect strong enough to explain the full extent of the observed phenomenon?"}
2025-04-18 23:33:26.884751+00	847	\N	1	45	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.04999999999999999}, "before": {"id": 45, "decided": false, "confidence": 0.5, "id_expl_id": 178, "decided_expl_id": 178, "confidence_expl_id": 178}}, "statement": {"id": 45, "text": "While a significant gap in understanding and modelling cloud formation creates a problem for predicting future climate, the claim is about the past.", "id_expl_id": 178, "text_expl_id": 844}, "confidences": [[0.9], []], "triggerLabel": "insert of argument judgement", "triggerExplId": 846, "statementArguments": [{"id": 113, "pro": false, "id_expl_id": 845, "pro_expl_id": 845, "statement_id": 45, "title_expl_id": 845, "argument_type_id": 6, "statement_id_expl_id": 845, "argument_type_id_expl_id": 845}], "argumentConfidences": [{"pro": false, "pro_expl_id": 845, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 846, "conditional_confidence_expl_id": null}]}
2025-04-19 23:59:13.605451+00	903	18	1	18	updateRecord	person	{"id": 18, "diff": {"after": {"language": "russian"}, "before": {"id": 18, "language": "english", "id_expl_id": 504, "language_expl_id": 852}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Durante"}
2025-04-21 04:36:15.821485+00	969	18	1	78	deleteById	critical_statement	{"id": 78, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "critical_statement", "targetLabel": 115, "deletedRecords": {"critical_statement": [{"id": 78, "id_expl_id": 933, "argument_id": 126, "statement_id": 115, "argument_id_expl_id": 933, "critical_question_id": 1, "statement_id_expl_id": 933, "critical_question_id_expl_id": 933}]}}
2025-04-21 04:36:21.981676+00	970	18	1	79	deleteById	critical_statement	{"id": 79, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "critical_statement", "targetLabel": 116, "deletedRecords": {"critical_statement": [{"id": 79, "id_expl_id": 936, "argument_id": 126, "statement_id": 116, "argument_id_expl_id": 936, "critical_question_id": 6, "statement_id_expl_id": 936, "critical_question_id_expl_id": 936}]}}
2025-04-23 21:51:55.384912+00	996	\N	1	128	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 1}, "before": {"id": 128, "decided": false, "confidence": 0.5, "id_expl_id": 992, "decided_expl_id": 992, "confidence_expl_id": 992}}, "statement": {"id": 128, "text": "Вакцины победили некоторые болезни", "id_expl_id": 992, "text_expl_id": 992}, "confidences": [[], [1]], "triggerLabel": "insert of argument judgement", "triggerExplId": 995, "statementArguments": [{"id": 134, "pro": true, "id_expl_id": 994, "pro_expl_id": 994, "statement_id": 128, "title_expl_id": 994, "argument_type_id": 8, "statement_id_expl_id": 994, "argument_type_id_expl_id": 994}], "argumentConfidences": [{"pro": true, "pro_expl_id": 994, "isolated_confidence": 1, "conditional_confidence": null, "isolated_confidence_expl_id": 995, "conditional_confidence_expl_id": null}]}
2025-12-18 14:00:22.452348+00	1940	18	1	16	insertRecord	deed	{"user": {"id": 18, "name": "Durante", "auth_role": "invited", "permission_level": 1000}, "record": {"id": 16, "text": "test deed 4", "id_expl_id": 1940, "text_expl_id": 1940}, "tableName": "deed", "targetLabel": "test deed 4"}
2025-04-23 21:56:07.670673+00	997	23	1	17	insertRecord	directive_consequence	{"user": {"id": 23, "name": "Mustafa", "auth_role": "invited"}, "record": {"id": 17, "label": "беспорядок -15 потерянный предмет / м³", "value_id": 39, "id_expl_id": 997, "argument_id": 88, "moral_good_id": 1, "value_id_expl_id": 997, "argument_id_expl_id": 997, "moral_good_id_expl_id": 997}, "tableName": "directive_consequence", "targetLabel": "беспорядок -15 потерянный предмет / м³"}
2025-05-03 00:48:38.410135+00	1019	18	1	129	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 129, "text": "intruders would misplace 15 items per m³ if the rubbish bins are left unlocked", "label": "(?) intruders would misplace 15 items per m³ if the rubbish bins are left unlocked", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 1019, "text_expl_id": 1019, "decided_expl_id": 1019, "featured_expl_id": 1019, "statement_type_id": 1, "confidence_expl_id": 1019, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1019}, "tableName": "statement", "targetLabel": "(?) intruders would misplace 15 items per m³ if the rubbish bins are left unlocked"}
2025-05-06 04:30:35.708105+00	1038	\N	1	132	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 1}, "before": {"id": 132, "decided": false, "confidence": 0.5, "id_expl_id": 1034, "decided_expl_id": 1034, "confidence_expl_id": 1034}}, "statement": {"id": 132, "text": "nobody has watched this demo so far ", "id_expl_id": 1034, "text_expl_id": 1034}, "confidences": [[], [1]], "triggerLabel": "insert of argument judgement", "triggerExplId": 1037, "statementArguments": [{"id": 136, "pro": true, "id_expl_id": 1036, "pro_expl_id": 1036, "statement_id": 132, "title_expl_id": 1036, "argument_type_id": 6, "statement_id_expl_id": 1036, "argument_type_id_expl_id": 1036}], "argumentConfidences": [{"pro": true, "pro_expl_id": 1036, "isolated_confidence": 1, "conditional_confidence": null, "isolated_confidence_expl_id": 1037, "conditional_confidence_expl_id": null}]}
2025-05-06 04:30:35.70034+00	1037	24	1	136	insertRecord	argument_judgement	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 136, "label": "not published (100%)", "id_expl_id": 1037, "isolated_confidence": 1, "isolated_explanation": "", "isolated_confidence_expl_id": 1037, "isolated_explanation_expl_id": 1037}, "tableName": "argument_judgement", "targetLabel": "not published (100%)"}
2025-07-15 04:39:19.362956+00	1265	18	1	144	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 144, "text": "Tipping reduces rationality compliance by −43.79%", "label": "(?) Tipping reduces rationality compliance by −43.79%", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1265, "text_expl_id": 1265, "decided_expl_id": 1265, "featured_expl_id": 1265, "chat_text_expl_id": 1265, "statement_type_id": 1, "confidence_expl_id": 1265, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1265}, "tableName": "statement", "targetLabel": "(?) Tipping reduces rationality compliance by −43.79%"}
2025-07-20 02:48:03.790683+00	1351	5	1	2	updateExtRecord	issue	{"id": 2, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 2, "id_expl_id": 1082, "project_stage": "closed β rel.", "project_stage_expl_id": 1082}}, "tableName": "issue", "targetLabel": "put an index on invite.code", "extTableName": "task"}
2025-10-18 11:45:31.683353+00	1395	\N	1	148	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.033980582524271996}, "before": {"id": 148, "decided": true, "confidence": 0.26923, "id_expl_id": 1360, "decided_expl_id": 1383, "confidence_expl_id": 1383}}, "statement": {"id": 148, "text": "The Moon landing was fake.", "id_expl_id": 1360, "text_expl_id": 1360}, "confidences": [[0.9, 0.9], [0.75]], "triggerLabel": "insert of argument judgement", "triggerExplId": 1394, "statementArguments": [{"id": 176, "pro": false, "id_expl_id": 1362, "pro_expl_id": 1362, "statement_id": 148, "title_expl_id": 1362, "argument_type_id": 3, "chat_text_expl_id": 1362, "statement_id_expl_id": 1362, "argument_type_id_expl_id": 1362}, {"id": 180, "pro": true, "id_expl_id": 1368, "pro_expl_id": 1368, "statement_id": 148, "title_expl_id": 1368, "argument_type_id": 4, "chat_text_expl_id": 1368, "statement_id_expl_id": 1368, "argument_type_id_expl_id": 1368}, {"id": 183, "pro": false, "id_expl_id": 1393, "pro_expl_id": 1393, "statement_id": 148, "title_expl_id": 1393, "argument_type_id": 17, "chat_text_expl_id": 1393, "statement_id_expl_id": 1393, "argument_type_id_expl_id": 1393}], "argumentConfidences": [{"pro": true, "pro_expl_id": 1368, "isolated_confidence": 0.75, "conditional_confidence": null, "isolated_confidence_expl_id": 1380, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": 1362, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 1382, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": 1393, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 1394, "conditional_confidence_expl_id": null}]}
2025-10-18 11:46:02.155856+00	1396	5	1	176	deleteById	argument	{"id": "176", "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "Replaced with the argument of proper type.", "tableName": "argument", "targetLabel": "Conspiracy theories are almost never true.", "deletedRecords": {"argument": [{"id": 176, "pro": false, "title": "Conspiracy theories are almost never true.", "chat_text": "", "id_expl_id": 1362, "pro_expl_id": 1362, "statement_id": 148, "title_expl_id": 1362, "argument_type_id": 3, "chat_text_expl_id": 1362, "statement_id_expl_id": 1362, "argument_type_id_expl_id": 1362}], "argument_other": [{"id": 176, "text": "This is a conspiracy theory. Conspiracy theories very rarely turn out to be true. So most likely this one is not true either.", "id_expl_id": 1362, "text_expl_id": 1362}], "argument_judgement": [{"id": 176, "label": "Conspiracy theories are almost never true. (90%)", "id_expl_id": 1382, "isolated_confidence": 0.9, "isolated_explanation": "The rate of conspiracy theories that turn out to be false is definitely above 95%, although no actual statistical evidence was presented.This is definitely a conspiracy theory and there is nothing special in this one compared to others. So this fits the top bracket.", "isolated_confidence_expl_id": 1382, "isolated_explanation_expl_id": 1382}]}}
2025-11-20 22:03:11.257067+00	1569	24	1	162	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 162, "text": "t10", "label": "(?) t10", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1569, "text_expl_id": 1569, "decided_expl_id": 1569, "featured_expl_id": 1569, "chat_text_expl_id": 1569, "statement_type_id": 1, "confidence_expl_id": 1569, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1569}, "tableName": "statement", "targetLabel": "(?) t10"}
2025-10-18 12:08:17.252672+00	1397	5	1	136	insertRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 136, "title": "[Bug] statement confidence didn't update when an argument against it was deleted ", "id_expl_id": 1397, "description": "", "title_expl_id": 1397, "description_expl_id": 1397}, "tableName": "issue", "targetLabel": "[Bug] statement confidence didn't update when an argument against it was deleted "}
2025-11-05 11:54:00.369391+00	1511	18	1	108	updateRecord	argument_conditional	{"id": 108, "diff": {"after": {"conditional_confidence": "0.17000", "conditional_explanation": "test 2"}, "before": {"id": 108, "id_expl_id": 1509, "conditional_confidence": 0.18, "conditional_explanation": "test", "conditional_confidence_expl_id": 1509, "conditional_explanation_expl_id": 1509}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_conditional", "targetLabel": 0.17}
2025-11-20 21:30:37.138098+00	1567	24	1	19	insertRecord	directive_scope	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 19, "label": "(+) UK government", "include": true, "id_expl_id": 1567, "directive_id": 160, "include_expl_id": 1567, "person_category_id": 8, "directive_id_expl_id": 1567, "person_category_id_expl_id": 1567}, "tableName": "directive_scope", "targetLabel": "(+) UK government"}
2025-12-15 09:16:24.629105+00	1866	18	1	234	insertRecord	argument_causal	{"user": {"id": 18, "name": "Durante", "auth_role": "invited", "permission_level": 1000}, "record": {"id": 234, "text": "Con Arg Test 3 Full Causal", "id_expl_id": 1866, "text_expl_id": 1866}, "tableName": "argument_causal", "targetLabel": "Con Arg Test 3 Full Causal"}
2025-05-06 04:34:30.515828+00	1040	\N	1	131	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.575}, "before": {"id": 131, "decided": false, "confidence": 0.5, "id_expl_id": 1030, "decided_expl_id": 1030, "confidence_expl_id": 1030}}, "statement": {"id": 131, "text": "most people that are part of the closed beta will find this demo useful", "id_expl_id": 1030, "text_expl_id": 1032}, "confidences": [[], [0.15]], "triggerLabel": "insert of argument judgement", "triggerExplId": 1039, "statementArguments": [{"id": 135, "pro": true, "id_expl_id": 1033, "pro_expl_id": 1033, "statement_id": 131, "title_expl_id": 1033, "argument_type_id": 13, "statement_id_expl_id": 1033, "argument_type_id_expl_id": 1033}], "argumentConfidences": [{"pro": true, "pro_expl_id": 1033, "isolated_confidence": 0.15, "conditional_confidence": null, "isolated_confidence_expl_id": 1039, "conditional_confidence_expl_id": null}]}
2025-05-06 04:34:30.504981+00	1039	24	1	135	insertRecord	argument_judgement	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 135, "label": "get people unstuck (15%)", "id_expl_id": 1039, "isolated_confidence": 0.15, "isolated_explanation": "No evidence was presented. However the mechanism from rough edges to getting stuck to watching demo to getting unstuck is reasonable. ", "isolated_confidence_expl_id": 1039, "isolated_explanation_expl_id": 1039}, "tableName": "argument_judgement", "targetLabel": "get people unstuck (15%)"}
2025-05-06 04:51:48.98323+00	1044	24	1	7	insertRecord	person_category	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 7, "name": "mind of Apollo participants", "id_expl_id": 1044, "name_expl_id": 1044}, "tableName": "person_category", "targetLabel": "mind of Apollo participants"}
2025-11-27 13:13:14.28313+00	1666	18	1	206	updateExtRecord	argument	{"id": "206", "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"text": "Humans and dogs have hearts. Heart contains the soul."}, "before": {"id": 206, "text": "Humans and dogs have hearts.", "id_expl_id": 1632, "text_expl_id": 1664}}, "tableName": "argument", "targetLabel": "Humans and dogs have hearts.", "extTableName": "argument_other"}
2025-07-15 04:39:39.592863+00	1266	18	1	23	insertRecord	directive_consequence	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 23, "label": "rationality -43.79 ΔRC%", "value_id": 6, "id_expl_id": 1266, "argument_id": 157, "moral_good_id": 9, "value_id_expl_id": 1266, "argument_id_expl_id": 1266, "moral_good_id_expl_id": 1266}, "tableName": "directive_consequence", "targetLabel": "rationality -43.79 ΔRC%"}
2025-08-07 00:16:16.891434+00	1352	5	1	132	updateRecord	issue	{"id": 132, "diff": {"after": {"description": "Automated testing idea. The main weakness of end to end tests is that they break easily. This can be mitigated if the task plan is linked directly to the code rather than it been linked to DOM locator. If your editing code and you see that this particular component is referenced by a test plan in this particular way you will have awareness and context to adjust both the task plan and the hook inside the code such that predictably it will probably work. This hook will be placed inside a UI component and it will be essentially a subscriber that will subscribe to a data plus operation locator rather than a DOM locator. This is much less arbitrary and susceptible to unexpected and unimportant changes. The test runner would fire events it would run from well the page itself since we have an SPA. It will wait until there is at least one appropriate subscriber and then activate the first subscriber. Subscribers can return data in response to events. This data could serve multiple purposes. It could be essential for running the test so like passing an ID. It could also be used for assertions. Some subscribers could function just as assertions not changing the application state in any way. If you're adding an intermediate step to user flow you must check that the subscribers that will become hidden by introduction of this intermediate step it should have this intermediate step edit to every test that calls those subscribers if they are now coming through this step as opposed to why some other route. Creating documentation from test runs still remains a possibility. This documentation could be even run in the form of a tutorial by running the test but waiting for the user to click the next button and also by perhaps showing a panel with comments about what's going on that could also contain those next buttons. The advantage here is that the user can interact with the application open links if he's curious, open hidden descriptions if you want to, making certain changes if you likes to like adding additional items that were not in the tutorial. In the tutorial mode assertions shouldn't cause a failure because well it's no use to the user and because it could be that the user have made additional actions or made changes that conflict with the asserted values. Another benefit is that this will be done in the screen resolution and zoom level that is comfortable and adjustable by the user. In conclusion testing DOM is too much pain for too little benefit. 🤩 Amazing benefit! If we are treating test plans as specification of the fact that code is linked directly to the test plan via the subscriber gives great amazing context to the requirements that this code is following. This is especially relevant to Apollo because most of Apollo UI components are highly abstract and I'm already encountering situations where I'm looking at a UI component and I have trouble figuring out where in what scenario it's used. If I had implemented subscribers to the task plan it would link me a specific scenario that I can see and understand how this piece of UI is used, and I can even run the test and it will show me on the screen how it's used. Isn't this absolutely amazing!?!\\nWhen writing automated tests make use of createEffect to let the test runner know the changes in data and signals. The test runner should inspect the log of such events instead of inspecting the DOM. This way there is a more direct and unobstructed link between the code and the use case expressed in the test. I could build a custom test runner that is a part of the same code base and it runs within the application."}, "before": {"id": 132, "id_expl_id": 1181, "description": "Automated testing idea. The main weakness of end to end tests is that they break easily. This can be mitigated if the task plan is linked directly to the code rather than it been linked to DOM locator. If your editing code and you see that this particular component is referenced by a test plan in this particular way you will have awareness and context to adjust both the task plan and the hook inside the code such that predictably it will probably work. This hook will be placed inside a UI component and it will be essentially a subscriber that will subscribe to a data plus operation locator rather than a DOM locator. This is much less arbitrary and susceptible to unexpected and unimportant changes. The test runner would fire events it would run from well the page itself since we have an SPA. It will wait until there is at least one appropriate subscriber and then activate the first subscriber. Subscribers can return data in response to events. This data could serve multiple purposes. It could be essential for running the test so like passing an ID. It could also be used for assertions. Some subscribers could function just as assertions not changing the application state in any way. If you're adding an intermediate step to user flow you must check that the subscribers that will become hidden by introduction of this intermediate step it should have this intermediate step edit to every test that calls those subscribers if they are now coming through this step as opposed to why some other route. Creating documentation from test runs still remains a possibility. This documentation could be even run in the form of a tutorial by running the test but waiting for the user to click the next button and also by perhaps showing a panel with comments about what's going on that could also contain those next buttons. The advantage here is that the user can interact with the application open links if he's curious, open hidden descriptions if you want to, making certain changes if you likes to like adding additional items that were not in the tutorial. In the tutorial mode assertions shouldn't cause a failure because well it's no use to the user and because it could be that the user have made additional actions or made changes that conflict with the asserted values. Another benefit is that this will be done in the screen resolution and zoom level that is comfortable and adjustable by the user. In conclusion testing DOM is too much pain for too little benefit. 🤩 Amazing benefit! If we are treating test plans as specification of the fact that code is linked directly to the test plan via the subscriber gives great amazing context to the requirements that this code is following. This is especially relevant to Apollo because most of Apollo UI components are highly abstract and I'm already encountering situations where I'm looking at a UI component and I have trouble figuring out where in what scenario it's used. If I had implemented subscribers to the task plan it would link me a specific scenario that I can see and understand how this piece of UI is used, and I can even run the test and it will show me on the screen how it's used. Isn't this absolutely amazing!?!", "description_expl_id": 1181}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "issue", "targetLabel": "Add (subsurface) automated E2E tests"}
2025-10-18 11:45:31.666263+00	1394	5	1	183	insertRecord	argument_judgement	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 183, "label": "Conspiracy theories are almost never true. (90%)", "id_expl_id": 1394, "isolated_confidence": 0.9, "isolated_explanation": "The rate of conspiracy theories that turn out to be false is definitely above 95%, although no actual statistical evidence was presented. This is definitely a conspiracy theory and there is nothing special in this one compared to others. So this fits the top bracket.", "isolated_confidence_expl_id": 1394, "isolated_explanation_expl_id": 1394}, "tableName": "argument_judgement", "targetLabel": "Conspiracy theories are almost never true. (90%)"}
2025-11-05 11:57:32.752546+00	1512	18	1	155	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 155, "text": "st5", "label": "(?) st5", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1512, "text_expl_id": 1512, "decided_expl_id": 1512, "featured_expl_id": 1512, "chat_text_expl_id": 1512, "statement_type_id": 1, "confidence_expl_id": 1512, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1512}, "tableName": "statement", "targetLabel": "(?) st5"}
2025-11-05 12:02:50.406226+00	1514	18	1	156	updateRecord	statement	{"id": "156", "diff": {"after": {"text": "st5.1"}, "before": {"id": 156, "text": "st5", "id_expl_id": 1513, "text_expl_id": 1513}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) st5.1"}
2025-11-05 12:05:19.094746+00	1516	18	1	125	updateRecord	argument_judgement	{"id": "125", "diff": {"after": {"isolated_confidence": "0.22000", "isolated_explanation": "test 2"}, "before": {"id": 125, "id_expl_id": 1515, "isolated_confidence": 0.33, "isolated_explanation": "test", "isolated_confidence_expl_id": 1515, "isolated_explanation_expl_id": 1515}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_judgement", "targetLabel": "example 3 (22%)"}
2025-11-20 21:52:35.028732+00	1568	24	1	161	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 161, "text": "st9", "label": "(?) st9", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1568, "text_expl_id": 1568, "decided_expl_id": 1568, "featured_expl_id": 1568, "chat_text_expl_id": 1568, "statement_type_id": 1, "confidence_expl_id": 1568, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1568}, "tableName": "statement", "targetLabel": "(?) st9"}
2025-11-26 06:35:36.896683+00	1599	32	1	169	insertCrossRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "cross": {"id": 42, "label": "philosophy", "tableName": "tag"}, "record": {"tag_id": 42, "statement_id": 169, "tag_id_expl_id": 1599, "statement_id_expl_id": 1599}, "target": {"id": 169, "label": "(?) we have libertarian free will", "tableName": "statement"}}
2025-11-27 01:01:52.919201+00	1632	18	1	206	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 206, "pro": true, "title": "Definition test argument. Humans and dogs have hearts.", "chat_text": "", "id_expl_id": 1632, "pro_expl_id": 1632, "statement_id": 175, "title_expl_id": 1632, "statement_label": "(?) Definitions test. Humans are not dogs.", "argument_type_id": 3, "chat_text_expl_id": 1632, "statement_id_expl_id": 1632, "argument_type_id_expl_id": 1632}, "extRecord": {"id": 206, "text": "Definition test argument. Humans and dogs have hearts.", "id_expl_id": 1632, "text_expl_id": 1632}, "tableName": "argument", "targetLabel": "Definition test argument. Humans and dogs have hearts.", "extTableName": "argument_other"}
2025-05-06 04:52:28.706842+00	1045	24	1	17	insertRecord	directive_scope	{"user": {"id": 24, "name": "Демонстрационный пользователь 1", "auth_role": "invited"}, "record": {"id": 17, "label": "(+) mind of Apollo participants", "include": true, "id_expl_id": 1045, "directive_id": 133, "include_expl_id": 1045, "person_category_id": 7, "directive_id_expl_id": 1045, "person_category_id_expl_id": 1045}, "tableName": "directive_scope", "targetLabel": "(+) mind of Apollo participants"}
2025-07-15 04:39:41.038414+00	1267	18	1	104	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 104, "id_expl_id": 1267, "argument_id": 157, "statement_id": 144, "argument_id_expl_id": 1267, "critical_question_id": 47, "statement_id_expl_id": 1267, "critical_question_id_expl_id": 1267}, "tableName": "critical_statement", "targetLabel": "(?) Tipping reduces rationality compliance by −43.79%"}
2025-08-16 18:44:12.005803+00	1353	24	1	169	updateExtRecord	argument	{"id": "169", "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"text": "U.S. sources cited in congressional testimony and FBI inquiries say at least one WIV coronavirus researcher was hospitalized with COVID-like symptoms in November 2019, before the first officially acknowledged cluster, suggesting a possible internal lab outbreak.\\n\\nhttps://www.hsgac.senate.gov/wp-content/uploads/Testimony-Ebright-2024-06-18.pdf\\nhttps://www.vanityfair.com/news/story/inside-the-fbis-lab-leak-investigation"}, "before": {"id": 169, "text": "U.S. sources cited in congressional testimony and FBI inquiries say at least one WIV coronavirus researcher was hospitalized with COVID-like symptoms in November 2019, before the first officially acknowledged cluster, suggesting a possible internal lab outbreak.\\n\\nhttps://www.hsgac.senate.gov/wp-content/uploads/Testimony-Ebright-2024-06-18.pdf\\nhttps://www.vanityfair.com/news/story/inside-the-fbis-lab-leak-investigation\\n\\n", "id_expl_id": 1306, "text_expl_id": 1306}}, "tableName": "argument", "targetLabel": "Unexplained illnesses among WIV staff", "extTableName": "argument_explanation"}
2025-10-18 13:19:00.672811+00	1398	24	1	149	deleteById	statement	{"id": "149", "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "Will recreate during recording", "tableName": "statement", "targetLabel": "(75%) The Moon landing video was filmed in a studio.", "deletedRecords": {"argument": [{"id": 181, "pro": true, "title": "There are no stars visible in is the dark sky.", "chat_text": "", "id_expl_id": 1371, "pro_expl_id": 1371, "statement_id": 149, "title_expl_id": 1371, "argument_type_id": 4, "chat_text_expl_id": 1371, "statement_id_expl_id": 1371, "argument_type_id_expl_id": 1371}, {"id": 182, "pro": false, "title": "People are moving slowly in the air because of low lunar gravity.", "chat_text": "", "id_expl_id": 1372, "pro_expl_id": 1372, "statement_id": 149, "title_expl_id": 1372, "argument_type_id": 4, "chat_text_expl_id": 1372, "statement_id_expl_id": 1372, "argument_type_id_expl_id": 1372}], "statement": [{"id": 149, "text": "The Moon landing video was filmed in a studio.", "label": "(75%) The Moon landing video was filmed in a studio.", "decided": true, "featured": false, "chat_text": "", "confidence": 0.75316, "id_expl_id": 1364, "text_expl_id": 1364, "decided_expl_id": 1379, "featured_expl_id": 1364, "chat_text_expl_id": 1364, "statement_type_id": 1, "confidence_expl_id": 1379, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1364}], "argument_judgement": [{"id": 181, "label": "There are no stars visible in is the dark sky. (70%)", "id_expl_id": 1375, "isolated_confidence": 0.7, "isolated_explanation": "For this particular argument and considering that no critical question were asked the explanation appears to be plausible, we don't have other explanations to consider but it relies on a single peace of evidence so overall I'll give it a score of 70%.", "isolated_confidence_expl_id": 1375, "isolated_explanation_expl_id": 1375}, {"id": 182, "label": "People are moving slowly in the air because of low lunar gravity. (30%)", "id_expl_id": 1378, "isolated_confidence": 0.3, "isolated_explanation": "If this was filmed in a studio , the astronauts could have been easily pulled by ropes. That's how the movies are usually shot in scenes where the actors fly around. So I'd say this arguments fits easily the 20%-40% category.", "isolated_confidence_expl_id": 1378, "isolated_explanation_expl_id": 1378}], "critical_statement": [{"id": 107, "id_expl_id": 1369, "argument_id": 180, "statement_id": 149, "argument_id_expl_id": 1369, "critical_question_id": 1, "statement_id_expl_id": 1369, "critical_question_id_expl_id": 1369}], "argument_explanation": [{"id": 181, "text": "On the Moon landing videos the sky is dark but no stars are visible. That is because it was filmed in a studio against a dark background rather than a real sky.", "id_expl_id": 1371, "text_expl_id": 1371}, {"id": 182, "text": "When astronauts in the video jump, they take off and land much slower than on Earth. So it was not filmed in a studio on Earth.", "id_expl_id": 1372, "text_expl_id": 1372}]}}
2025-10-18 13:46:43.64853+00	1402	24	1	150	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 150, "text": "The Moon landing was fake.", "label": "(?) The Moon landing was fake.", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1402, "text_expl_id": 1402, "decided_expl_id": 1402, "featured_expl_id": 1402, "chat_text_expl_id": 1402, "statement_type_id": 1, "confidence_expl_id": 1402, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1402}, "tableName": "statement", "targetLabel": "(?) The Moon landing was fake."}
2025-11-26 06:43:45.68727+00	1600	32	1	171	insertRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 171, "text": "apollo will not take off", "label": "(?) apollo will not take off", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1600, "text_expl_id": 1600, "decided_expl_id": 1600, "featured_expl_id": 1600, "chat_text_expl_id": 1600, "statement_type_id": 1, "confidence_expl_id": 1600, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1600}, "tableName": "statement", "targetLabel": "(?) apollo will not take off"}
2025-11-05 12:02:29.6181+00	1513	18	1	156	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 156, "text": "st5", "label": "(?) st5", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1513, "text_expl_id": 1513, "decided_expl_id": 1513, "featured_expl_id": 1513, "chat_text_expl_id": 1513, "statement_type_id": 1, "confidence_expl_id": 1513, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1513}, "tableName": "statement", "targetLabel": "(?) st5"}
2025-11-27 01:41:00.365311+00	1635	18	1	206	updateRecord	argument	{"id": "206", "diff": {"after": {"pro": false}, "before": {"id": 206, "pro": true, "id_expl_id": 1632, "pro_expl_id": 1632}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Definition test argument. Humans and dogs have hearts."}
2025-11-05 12:05:31.896888+00	1517	18	1	125	insertRecord	argument_conditional	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 125, "id_expl_id": 1517, "conditional_confidence": 0.11, "conditional_explanation": "asss", "conditional_confidence_expl_id": 1517, "conditional_explanation_expl_id": 1517}, "tableName": "argument_conditional", "targetLabel": 0.11}
2025-11-20 22:06:51.037927+00	1570	24	1	163	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 163, "text": "s11", "label": "(?) s11", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1570, "text_expl_id": 1570, "decided_expl_id": 1570, "featured_expl_id": 1570, "chat_text_expl_id": 1570, "statement_type_id": 1, "confidence_expl_id": 1570, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1570}, "tableName": "statement", "targetLabel": "(?) s11"}
2025-05-13 20:45:57.680545+00	1049	25	1	137	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 137, "pro": true, "title": "sniper's alignment with Yanukovych", "id_expl_id": 1049, "pro_expl_id": 1049, "statement_id": 69, "title_expl_id": 1049, "argument_type_id": 3, "statement_id_expl_id": 1049, "argument_type_id_expl_id": 1049}, "extRecord": {"id": 137, "text": "The sniper's actions aligned with the interests of Yanukovych's government, as his regime sought to suppress the pro-European protests that threatened its power; the use of deadly force against protesters would effectively intimidate dissent and maintain control, indicating that the sniper was acting in a manner consistent with the objectives of Yanukovych's administration.", "id_expl_id": 1049, "text_expl_id": 1049}, "tableName": "argument", "targetLabel": "sniper's alignment with Yanukovych", "extTableName": "argument_other"}
2025-05-13 20:49:46.554513+00	1050	25	1	137	deleteById	argument	{"id": 137, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "sniper's alignment with Yanukovych", "deletedRecords": {"argument": [{"id": 137, "pro": true, "title": "sniper's alignment with Yanukovych", "id_expl_id": 1049, "pro_expl_id": 1049, "statement_id": 69, "title_expl_id": 1049, "argument_type_id": 3, "statement_id_expl_id": 1049, "argument_type_id_expl_id": 1049}], "argument_other": [{"id": 137, "text": "The sniper's actions aligned with the interests of Yanukovych's government, as his regime sought to suppress the pro-European protests that threatened its power; the use of deadly force against protesters would effectively intimidate dissent and maintain control, indicating that the sniper was acting in a manner consistent with the objectives of Yanukovych's administration.", "id_expl_id": 1049, "text_expl_id": 1049}]}}
2025-05-13 20:57:43.15741+00	1056	25	1	140	deleteById	argument	{"id": 140, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Government Responsibility", "deletedRecords": {"argument": [{"id": 140, "pro": true, "title": "Government Responsibility", "id_expl_id": 1055, "pro_expl_id": 1055, "statement_id": 69, "title_expl_id": 1055, "argument_type_id": 3, "statement_id_expl_id": 1055, "argument_type_id_expl_id": 1055}], "argument_other": [{"id": 140, "text": "Evidence indicates that the sniper targeting protesters in Kiev during the Euromaidan protests operated under the authority of the Yanukovych government, as the use of state security forces to suppress dissent is consistent with the regime's strategy to maintain power. Testimonies from eyewitnesses and investigations into the organization of the security forces suggest a coordinated effort to instill fear and deter protest through lethal means, aligning with the political motives of Yanukovych's administration to quell opposition.", "id_expl_id": 1055, "text_expl_id": 1055}]}}
2025-07-15 04:43:55.726997+00	1268	18	1	163	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 163, "pro": true, "title": "Tipping in U.S. restaurants aligns only about 11% of customer behaviour with rational motives like service quality or wage correction, compared to 55% under fixed-price models—resulting in a 43.79% drop in rationality compliance.", "chat_text": "", "id_expl_id": 1268, "pro_expl_id": 1268, "statement_id": 144, "title_expl_id": 1268, "argument_type_id": 6, "chat_text_expl_id": 1268, "statement_id_expl_id": 1268, "argument_type_id_expl_id": 1268}, "extRecord": {"id": 163, "text": "What counts as a direct performance signal?\\n\\nIn research on tipping, the direct performance signal is the part of the tip that statistically tracks observable service-quality metrics—order accuracy, speed, courtesy, etc.—as rated by customers. A meta-analysis of 14 field studies covering 2,645 tables reports an average service-tip correlation r = 0.11; squaring that gives 1.21% of the variance in tip size that can be traced to service quality itself, and nothing else.\\nSource: files.secure.website/wscfus/5261551/uploads/tip-serv-cq.pdf\\n\\nRationality-compliance profile with tipping (one U.S. restaurant visit)\\n\\nMotive (brief description) – % share of the average tipping decision:\\n\\nEvidence-based reward for observed service – 1.21%\\n\\nConscious wage-supplement reasoning – 10.00%\\n(customer knows servers earn a sub-minimum cash wage and tips to correct it)\\n\\nAttractiveness bias – 1.44%\\n(attractive servers—especially women—receive larger sales-adjusted tips)\\nSource: onlabor.org/wp-content/uploads/2016/04/54d4001699b01_-_TipAveJASP.pdf\\n\\nRacial or gender discrimination – 1.50%\\n(Black servers receive ≈ 1.2 percentage points smaller tips after quality is controlled)\\nSource: wagehourlitigation.com/wp-content/uploads/sites/22/2015/10/cornell.pdf\\n\\nIncidental mood/weather effects – 0.50%\\n(e.g., “sunny tomorrow” messages increase tipping)\\nSource: researchgate.net/publication/229540057\\n\\nSocial-norm compliance, guilt avoidance, habit, random rounding – 85.35%\\n\\nRCP_with_tipping = 1.21% + 10.00% = 11.21%\\n(everything else is irrational under the stated criterion)\\n\\nRationality-compliance profile without tipping (fixed price or service-charge model)\\n\\nRational motives:\\n\\nMenu-price exchange (~35%)\\nYou pay the price printed on the menu: a one-to-one exchange of money for food and service, fully spelled out in advance.\\n\\nEvidence-based venue selection (~15%)\\nChoosing the place based on reviews, ratings, past experiences, or recommendations.\\n\\nPractical constraints (~5%)\\nSelecting based on objective needs—proximity, dietary options, timing, etc.\\n\\nSubtotal for rational motives: ~55%\\n\\nIrrational motives:\\n\\nHabitual dining patterns (~20%)\\nGoing out of routine or habit (e.g., “it’s Friday” or “post-gym stop”).\\n\\nStatus & ambience chasing (~15%)\\nChoosing places for vibe, style, or prestige over substance.\\n\\nImpulse & bias spill-over (~10%)\\nDriven by cravings, nostalgia, marketing, or snap judgements.\\n\\nSubtotal for irrational motives: ~45%\\n\\nRCP_without_tipping = 55.00%\\n\\nΔRCP calculation\\n\\nΔRCP = 11.21% − 55.00% = −43.79%", "id_expl_id": 1268, "text_expl_id": 1268}, "tableName": "argument", "targetLabel": "Tipping in U.S. restaurants aligns only about 11% of customer behaviour with rational motives like service quality or wage correction, compared to 55% under fixed-price models—resulting in a 43.79% drop in rationality compliance.", "extTableName": "argument_deduction"}
2025-08-17 18:32:42.972683+00	1354	24	1	24	updateRecord	person	{"id": 24, "diff": {"after": {"language": "chinese"}, "before": {"id": 24, "language": "english", "id_expl_id": 1024, "language_expl_id": 1026}}, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Demo User 1"}
2025-10-18 13:19:15.454654+00	1399	24	1	148	deleteById	statement	{"id": "148", "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "Will recreate during recording", "tableName": "statement", "targetLabel": "(3%) The Moon landing was fake.", "deletedRecords": {"argument": [{"id": 180, "pro": true, "title": "The Moon landing video was filmed in a studio.", "chat_text": "", "id_expl_id": 1368, "pro_expl_id": 1368, "statement_id": 148, "title_expl_id": 1368, "argument_type_id": 4, "chat_text_expl_id": 1368, "statement_id_expl_id": 1368, "argument_type_id_expl_id": 1368}, {"id": 183, "pro": false, "title": "Conspiracy theories are almost never true.", "chat_text": "", "id_expl_id": 1393, "pro_expl_id": 1393, "statement_id": 148, "title_expl_id": 1393, "argument_type_id": 17, "chat_text_expl_id": 1393, "statement_id_expl_id": 1393, "argument_type_id_expl_id": 1393}], "statement": [{"id": 148, "text": "The Moon landing was fake.", "label": "(3%) The Moon landing was fake.", "decided": true, "featured": false, "chat_text": "", "confidence": 0.03398, "id_expl_id": 1360, "text_expl_id": 1360, "decided_expl_id": 1395, "featured_expl_id": 1360, "chat_text_expl_id": 1360, "statement_type_id": 1, "confidence_expl_id": 1395, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1360}], "argument_judgement": [{"id": 180, "label": "The Moon landing video was filmed in a studio. (75%)", "id_expl_id": 1380, "isolated_confidence": 0.75, "isolated_explanation": "Here we are explaining the evidence that the moon landing was filmed in a studio by Moon Landing being fake. It's a pretty straight forward explanation save for the fact that Apollo is only 75% certain in the evidence. On the other hand, no competing explanations for this evidence was presented.\\nSo it's fair to set the strengths of the argument to 75%, same as the strength of the evidence.", "isolated_confidence_expl_id": 1380, "isolated_explanation_expl_id": 1380}, {"id": 183, "label": "Conspiracy theories are almost never true. (90%)", "id_expl_id": 1394, "isolated_confidence": 0.9, "isolated_explanation": "The rate of conspiracy theories that turn out to be false is definitely above 95%, although no actual statistical evidence was presented. This is definitely a conspiracy theory and there is nothing special in this one compared to others. So this fits the top bracket.", "isolated_confidence_expl_id": 1394, "isolated_explanation_expl_id": 1394}], "argument_explanation": [{"id": 180, "text": "The Moon landing video was filmed in a studio but presented as real. So Moon landing was a lie.", "id_expl_id": 1368, "text_expl_id": 1368}], "argument_feasibility": [{"id": 183, "text": "This is a conspiracy theory. Conspiracy theories very rarely turn out to be true. So most likely this one is not true either.", "id_expl_id": 1393, "text_expl_id": 1393}]}}
2025-11-05 12:06:02.717871+00	1518	18	1	125	updateRecord	argument_conditional	{"id": 125, "diff": {"after": {"conditional_explanation": "my time"}, "before": {"id": 125, "id_expl_id": 1517, "conditional_explanation": "asss", "conditional_explanation_expl_id": 1517}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_conditional", "targetLabel": 0.11}
2025-11-27 03:16:17.51305+00	1649	32	1	123	insertRecord	critical_statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 123, "id_expl_id": 1649, "argument_id": 204, "statement_id": 181, "argument_id_expl_id": 1649, "critical_question_id": 1, "statement_id_expl_id": 1649, "critical_question_id_expl_id": 1649}, "tableName": "critical_statement", "targetLabel": "(?) in these cases, the direction of explanation runs:\\nevaluative commitment → pattern of pleasures and pains → action,\\nnot\\ndesire for pleasure → evaluative commitment → action"}
2025-11-20 22:09:17.346468+00	1571	24	1	164	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 164, "text": "s12", "label": "(?) s12", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1571, "text_expl_id": 1571, "decided_expl_id": 1571, "featured_expl_id": 1571, "chat_text_expl_id": 1571, "statement_type_id": 1, "confidence_expl_id": 1571, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1571}, "tableName": "statement", "targetLabel": "(?) s12"}
2025-11-26 06:43:47.976106+00	1601	32	1	114	insertRecord	critical_statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 114, "id_expl_id": 1601, "argument_id": 189, "statement_id": 171, "argument_id_expl_id": 1601, "critical_question_id": 1, "statement_id_expl_id": 1601, "critical_question_id_expl_id": 1601}, "tableName": "critical_statement", "targetLabel": "(?) apollo will not take off"}
2025-05-13 20:50:05.178418+00	1051	25	1	138	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 138, "pro": true, "title": "sniper's alignment with Yanukovych", "id_expl_id": 1051, "pro_expl_id": 1051, "statement_id": 69, "title_expl_id": 1051, "argument_type_id": 3, "statement_id_expl_id": 1051, "argument_type_id_expl_id": 1051}, "extRecord": {"id": 138, "text": "The sniper's actions align with the strategic interests of Yanukovych, as targeting protesters would serve to weaken opposition and instill fear among dissenters, thereby consolidating Yanukovych's control over the government during the Euromaidan protests.", "id_expl_id": 1051, "text_expl_id": 1051}, "tableName": "argument", "targetLabel": "sniper's alignment with Yanukovych", "extTableName": "argument_other"}
2025-11-27 02:36:25.507223+00	1638	32	1	207	insertExtRecord	argument	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 207, "pro": false, "title": "The role-duty is based on hedonic expectations.", "chat_text": "", "id_expl_id": 1638, "pro_expl_id": 1638, "statement_id": 176, "title_expl_id": 1638, "statement_label": "(?) some in Reserve Police Battalion 101 chose to kill, plausibly motivated primarily by an internalised sense of role-duty (to obey orders, stand by comrades, fulfil their function as policemen/soldiers), not by expectation of pleasure or lesser pain or feeling like a hero", "argument_type_id": 3, "chat_text_expl_id": 1638, "statement_id_expl_id": 1638, "argument_type_id_expl_id": 1638}, "extRecord": {"id": 207, "text": "An internalized sense of role-duty is (in this case) a kind of set of positive association(s) with following role-duty.\\n\\nThese positive associations are likely ultimately based on subconscious hedonic values.\\n\\nTherefore the internalized sense of role-duty is likely ultimately built on previous expectations and associations of pleasure or lesser pain.", "id_expl_id": 1638, "text_expl_id": 1638}, "tableName": "argument", "targetLabel": "The role-duty is based on hedonic expectations.", "extTableName": "argument_other"}
2025-07-15 04:46:04.554006+00	1269	18	1	145	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 145, "text": "Tipping increases autonomy by 7 autons per visit.", "label": "(?) Tipping increases autonomy by 7 autons per visit.", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1269, "text_expl_id": 1269, "decided_expl_id": 1269, "featured_expl_id": 1269, "chat_text_expl_id": 1269, "statement_type_id": 1, "confidence_expl_id": 1269, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1269}, "tableName": "statement", "targetLabel": "(?) Tipping increases autonomy by 7 autons per visit."}
2025-08-17 18:34:21.789104+00	1355	24	1	24	updateRecord	person	{"id": 24, "diff": {"after": {"language": "spanish"}, "before": {"id": 24, "language": "chinese", "id_expl_id": 1024, "language_expl_id": 1354}}, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "演示用户 1"}
2025-10-18 13:19:38.967973+00	1400	24	1	28	deleteById	tag	{"id": 28, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "Will recreate during recording", "tableName": "tag", "targetLabel": "science", "deletedRecords": {"tag": [{"id": 28, "name": "science", "id_expl_id": 1359, "description": "", "name_expl_id": 1359, "description_expl_id": 1359}]}}
2025-11-05 19:47:48.648052+00	1519	18	1	2	insertRecord	forum_thread	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 2, "title": "Test thread 2", "id_expl_id": 1519, "title_expl_id": 1519}, "tableName": "forum_thread", "targetLabel": "Test thread 2"}
2025-11-20 22:19:05.950855+00	1572	24	1	165	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 165, "text": "s13", "label": "(?) s13", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1572, "text_expl_id": 1572, "decided_expl_id": 1572, "featured_expl_id": 1572, "chat_text_expl_id": 1572, "statement_type_id": 1, "confidence_expl_id": 1572, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1572}, "tableName": "statement", "targetLabel": "(?) s13"}
2025-11-26 07:28:13.330172+00	1602	32	1	43	insertRecord	tag	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 43, "name": "Religion", "id_expl_id": 1602, "description": "", "name_expl_id": 1602, "description_expl_id": 1602}, "tableName": "tag", "targetLabel": "Religion"}
2025-11-26 16:33:14.419542+00	1622	\N	1	157	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.885}, "before": {"id": 157, "decided": false, "confidence": 0.5, "id_expl_id": 1523, "decided_expl_id": 1523, "confidence_expl_id": 1523}}, "statement": {"id": 157, "text": "St6", "id_expl_id": 1523, "text_expl_id": 1523}, "confidences": [[], [0.77]], "triggerLabel": "insert of argument judgement", "triggerExplId": 1621, "statementArguments": [{"id": 193, "pro": true, "id_expl_id": 1524, "pro_expl_id": 1524, "statement_id": 157, "title_expl_id": 1524, "argument_type_id": 8, "chat_text_expl_id": 1524, "statement_id_expl_id": 1524, "argument_type_id_expl_id": 1524}], "argumentConfidences": [{"pro": true, "pro_expl_id": 1524, "isolated_confidence": 0.77, "conditional_confidence": null, "isolated_confidence_expl_id": 1621, "conditional_confidence_expl_id": null}]}
2025-11-27 02:24:49.185002+00	1636	32	1	176	insertRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 176, "text": "some in Reserve Police Battalion 101 chose to kill, plausibly motivated primarily by an internalised sense of role-duty (to obey orders, stand by comrades, fulfil their function as policemen/soldiers), not by expectation of pleasure or lesser pain or feeling like a hero", "label": "(?) some in Reserve Police Battalion 101 chose to kill, plausibly motivated primarily by an internalised sense of role-duty (to obey orders, stand by comrades, fulfil their function as policemen/soldiers), not by expectation of pleasure or lesser pain or feeling like a hero", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1636, "text_expl_id": 1636, "decided_expl_id": 1636, "featured_expl_id": 1636, "chat_text_expl_id": 1636, "statement_type_id": 1, "confidence_expl_id": 1636, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1636}, "tableName": "statement", "targetLabel": "(?) some in Reserve Police Battalion 101 chose to kill, plausibly motivated primarily by an internalised sense of role-duty (to obey orders, stand by comrades, fulfil their function as policemen/soldiers), not by expectation of pleasure or lesser pain or feeling like a hero"}
2025-05-13 20:52:21.61461+00	1052	25	1	138	deleteById	argument	{"id": 138, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "sniper's alignment with Yanukovych", "deletedRecords": {"argument": [{"id": 138, "pro": true, "title": "sniper's alignment with Yanukovych", "id_expl_id": 1051, "pro_expl_id": 1051, "statement_id": 69, "title_expl_id": 1051, "argument_type_id": 3, "statement_id_expl_id": 1051, "argument_type_id_expl_id": 1051}], "argument_other": [{"id": 138, "text": "The sniper's actions align with the strategic interests of Yanukovych, as targeting protesters would serve to weaken opposition and instill fear among dissenters, thereby consolidating Yanukovych's control over the government during the Euromaidan protests.", "id_expl_id": 1051, "text_expl_id": 1051}]}}
2025-05-13 20:52:40.937803+00	1053	25	1	139	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 139, "pro": true, "title": "sniper alignment with Yanukovych", "id_expl_id": 1053, "pro_expl_id": 1053, "statement_id": 69, "title_expl_id": 1053, "argument_type_id": 3, "statement_id_expl_id": 1053, "argument_type_id_expl_id": 1053}, "extRecord": {"id": 139, "text": "The sniper used tactics consistent with the interests of the Yanukovych government, as the shooting of protesters aimed to instill fear and suppress dissent, thereby maintaining the regime's hold on power.", "id_expl_id": 1053, "text_expl_id": 1053}, "tableName": "argument", "targetLabel": "sniper alignment with Yanukovych", "extTableName": "argument_other"}
2025-05-13 20:57:00.522704+00	1055	25	1	140	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 140, "pro": true, "title": "Government Responsibility", "id_expl_id": 1055, "pro_expl_id": 1055, "statement_id": 69, "title_expl_id": 1055, "argument_type_id": 3, "statement_id_expl_id": 1055, "argument_type_id_expl_id": 1055}, "extRecord": {"id": 140, "text": "Evidence indicates that the sniper targeting protesters in Kiev during the Euromaidan protests operated under the authority of the Yanukovych government, as the use of state security forces to suppress dissent is consistent with the regime's strategy to maintain power. Testimonies from eyewitnesses and investigations into the organization of the security forces suggest a coordinated effort to instill fear and deter protest through lethal means, aligning with the political motives of Yanukovych's administration to quell opposition.", "id_expl_id": 1055, "text_expl_id": 1055}, "tableName": "argument", "targetLabel": "Government Responsibility", "extTableName": "argument_other"}
2025-07-15 04:46:19.618368+00	1270	18	1	24	insertRecord	directive_consequence	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 24, "label": "autonomy 7 Δ autons", "value_id": 7, "id_expl_id": 1270, "argument_id": 158, "moral_good_id": 10, "value_id_expl_id": 1270, "argument_id_expl_id": 1270, "moral_good_id_expl_id": 1270}, "tableName": "directive_consequence", "targetLabel": "autonomy 7 Δ autons"}
2025-07-15 05:16:42.471966+00	1278	18	1	9	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 9, "label": "(20 / DWT$) equality", "weight": 20, "id_expl_id": 1278, "profile_id": 2, "moral_good_id": 6, "weight_expl_id": 1278, "profile_id_expl_id": 1278, "moral_good_id_expl_id": 1278}, "tableName": "moral_weight_of_profile", "targetLabel": "(20 / DWT$) equality"}
2025-10-18 13:46:35.958845+00	1401	24	1	29	insertRecord	tag	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 29, "name": "science", "id_expl_id": 1401, "description": "", "name_expl_id": 1401, "description_expl_id": 1401}, "tableName": "tag", "targetLabel": "science"}
2025-07-15 05:16:52.320219+00	1279	18	1	10	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 10, "label": "(10 / MA$) merit", "weight": 10, "id_expl_id": 1279, "profile_id": 2, "moral_good_id": 7, "weight_expl_id": 1279, "profile_id_expl_id": 1279, "moral_good_id_expl_id": 1279}, "tableName": "moral_weight_of_profile", "targetLabel": "(10 / MA$) merit"}
2025-07-15 05:17:04.86609+00	1280	18	1	11	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 11, "label": "(15 / WbD) well-being", "weight": 15, "id_expl_id": 1280, "profile_id": 2, "moral_good_id": 8, "weight_expl_id": 1280, "profile_id_expl_id": 1280, "moral_good_id_expl_id": 1280}, "tableName": "moral_weight_of_profile", "targetLabel": "(15 / WbD) well-being"}
2025-07-15 05:17:29.502576+00	1281	18	1	12	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 12, "label": "(10 / ΔRC%) rationality", "weight": 10, "id_expl_id": 1281, "profile_id": 2, "moral_good_id": 9, "weight_expl_id": 1281, "profile_id_expl_id": 1281, "moral_good_id_expl_id": 1281}, "tableName": "moral_weight_of_profile", "targetLabel": "(10 / ΔRC%) rationality"}
2025-11-05 19:48:02.059727+00	1520	18	1	3	insertRecord	forum_post	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 3, "text": "Test post 1", "owner_id": 18, "thread_id": 2, "user_name": "Durante", "id_expl_id": 1520, "text_expl_id": 1520, "owner_id_expl_id": 1520, "thread_id_expl_id": 1520}, "tableName": "forum_post", "targetLabel": "Test post 1"}
2025-07-15 05:17:36.884786+00	1282	18	1	13	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 13, "label": "(10 / Δ autons) autonomy", "weight": 10, "id_expl_id": 1282, "profile_id": 2, "moral_good_id": 10, "weight_expl_id": 1282, "profile_id_expl_id": 1282, "moral_good_id_expl_id": 1282}, "tableName": "moral_weight_of_profile", "targetLabel": "(10 / Δ autons) autonomy"}
2025-11-20 22:32:33.703238+00	1573	24	1	166	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 166, "text": "st14", "label": "(?) st14", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1573, "text_expl_id": 1573, "decided_expl_id": 1573, "featured_expl_id": 1573, "chat_text_expl_id": 1573, "statement_type_id": 1, "confidence_expl_id": 1573, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1573}, "tableName": "statement", "targetLabel": "(?) st14"}
2025-05-13 20:56:38.924321+00	1054	25	1	139	deleteById	argument	{"id": 139, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "sniper alignment with Yanukovych", "deletedRecords": {"argument": [{"id": 139, "pro": true, "title": "sniper alignment with Yanukovych", "id_expl_id": 1053, "pro_expl_id": 1053, "statement_id": 69, "title_expl_id": 1053, "argument_type_id": 3, "statement_id_expl_id": 1053, "argument_type_id_expl_id": 1053}], "argument_other": [{"id": 139, "text": "The sniper used tactics consistent with the interests of the Yanukovych government, as the shooting of protesters aimed to instill fear and suppress dissent, thereby maintaining the regime's hold on power.", "id_expl_id": 1053, "text_expl_id": 1053}]}}
2025-05-13 20:58:02.690712+00	1057	25	1	141	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 141, "pro": true, "title": "", "id_expl_id": 1057, "pro_expl_id": 1057, "statement_id": 69, "title_expl_id": 1057, "argument_type_id": 3, "statement_id_expl_id": 1057, "argument_type_id_expl_id": 1057}, "extRecord": {"id": 141, "text": "The presence of highly trained snipers during the protests in Kiev correlates with the actions of the Yanukovych government, which aimed to suppress dissent, as evidenced by the government's previous use of force against protesters. The use of sniper fire specifically targeted protesters, indicating a strategic decision to escalate violence and instill fear among opposition groups. Additionally, the lack of credible evidence pointing to any other group being responsible for the sniper fire further supports the conclusion that these actions were aligned with Yanukovych's regime's objectives to maintain power.", "id_expl_id": 1057, "text_expl_id": 1057}, "tableName": "argument", "targetLabel": "", "extTableName": "argument_other"}
2025-05-13 21:00:39.493009+00	1058	25	1	141	deleteById	argument	{"id": 141, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "", "deletedRecords": {"argument": [{"id": 141, "pro": true, "title": "", "id_expl_id": 1057, "pro_expl_id": 1057, "statement_id": 69, "title_expl_id": 1057, "argument_type_id": 3, "statement_id_expl_id": 1057, "argument_type_id_expl_id": 1057}], "argument_other": [{"id": 141, "text": "The presence of highly trained snipers during the protests in Kiev correlates with the actions of the Yanukovych government, which aimed to suppress dissent, as evidenced by the government's previous use of force against protesters. The use of sniper fire specifically targeted protesters, indicating a strategic decision to escalate violence and instill fear among opposition groups. Additionally, the lack of credible evidence pointing to any other group being responsible for the sniper fire further supports the conclusion that these actions were aligned with Yanukovych's regime's objectives to maintain power.", "id_expl_id": 1057, "text_expl_id": 1057}]}}
2025-05-13 21:00:59.112948+00	1059	25	1	142	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 142, "pro": true, "title": "Alignment Evidence", "id_expl_id": 1059, "pro_expl_id": 1059, "statement_id": 69, "title_expl_id": 1059, "argument_type_id": 3, "statement_id_expl_id": 1059, "argument_type_id_expl_id": 1059}, "extRecord": {"id": 142, "text": "The sniper targeting protesters in Kiev was likely aligned with Yanukovych's regime because the shooting served to suppress dissent and instill fear among the populace, a tactic consistent with the government's efforts to maintain control during civil unrest. Furthermore, evidence suggests that the government had both the motive to eliminate opposition and the means to deploy trained snipers in a strategic manner, indicating a coordinated effort to protect Yanukovych's grip on power.", "id_expl_id": 1059, "text_expl_id": 1059}, "tableName": "argument", "targetLabel": "Alignment Evidence", "extTableName": "argument_other"}
2025-05-13 21:03:38.658644+00	1060	25	1	142	deleteById	argument	{"id": 142, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Alignment Evidence", "deletedRecords": {"argument": [{"id": 142, "pro": true, "title": "Alignment Evidence", "id_expl_id": 1059, "pro_expl_id": 1059, "statement_id": 69, "title_expl_id": 1059, "argument_type_id": 3, "statement_id_expl_id": 1059, "argument_type_id_expl_id": 1059}], "argument_other": [{"id": 142, "text": "The sniper targeting protesters in Kiev was likely aligned with Yanukovych's regime because the shooting served to suppress dissent and instill fear among the populace, a tactic consistent with the government's efforts to maintain control during civil unrest. Furthermore, evidence suggests that the government had both the motive to eliminate opposition and the means to deploy trained snipers in a strategic manner, indicating a coordinated effort to protect Yanukovych's grip on power.", "id_expl_id": 1059, "text_expl_id": 1059}]}}
2025-05-13 21:03:51.758613+00	1061	25	1	143	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 143, "pro": true, "title": "evidence of coordination", "id_expl_id": 1061, "pro_expl_id": 1061, "statement_id": 69, "title_expl_id": 1061, "argument_type_id": 3, "statement_id_expl_id": 1061, "argument_type_id_expl_id": 1061}, "extRecord": {"id": 143, "text": "The sniper's actions aligned with the interests of Yanukovych's government, as the use of deadly force against protesters aimed to suppress dissent and maintain control. Evidence shows that the sniper operated in close proximity to government forces, suggesting coordination. Additionally, the timing of the shooting coincided with efforts by Yanukovych to quell protests, indicating a tactical strategy to instill fear and dissuade further demonstrations.", "id_expl_id": 1061, "text_expl_id": 1061}, "tableName": "argument", "targetLabel": "evidence of coordination", "extTableName": "argument_other"}
2025-05-14 00:23:00.913663+00	1074	25	1	95	insertRecord	critical_statement	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 95, "id_expl_id": 1074, "argument_id": 145, "statement_id": 135, "argument_id_expl_id": 1074, "critical_question_id": 1, "statement_id_expl_id": 1074, "critical_question_id_expl_id": 1074}, "tableName": "critical_statement", "targetLabel": 135}
2025-05-24 13:23:27.627424+00	1097	5	1	3	updateExtRecord	issue	{"id": 3, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "in progress"}, "before": {"id": 3, "status": "next up", "id_expl_id": 1083, "status_expl_id": 1096}}, "tableName": "issue", "targetLabel": "move coding, content, marketing tasks to Apollo", "extTableName": "task"}
2025-05-24 13:24:41.482761+00	1098	18	1	\N	insertRecord	issue	\N
2025-05-13 21:13:11.633202+00	1062	25	1	143	deleteById	argument	{"id": 143, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "evidence of coordination", "deletedRecords": {"argument": [{"id": 143, "pro": true, "title": "evidence of coordination", "id_expl_id": 1061, "pro_expl_id": 1061, "statement_id": 69, "title_expl_id": 1061, "argument_type_id": 3, "statement_id_expl_id": 1061, "argument_type_id_expl_id": 1061}], "argument_other": [{"id": 143, "text": "The sniper's actions aligned with the interests of Yanukovych's government, as the use of deadly force against protesters aimed to suppress dissent and maintain control. Evidence shows that the sniper operated in close proximity to government forces, suggesting coordination. Additionally, the timing of the shooting coincided with efforts by Yanukovych to quell protests, indicating a tactical strategy to instill fear and dissuade further demonstrations.", "id_expl_id": 1061, "text_expl_id": 1061}]}}
2025-11-27 02:25:29.525543+00	1637	32	1	118	insertRecord	critical_statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 118, "id_expl_id": 1637, "argument_id": 203, "statement_id": 176, "argument_id_expl_id": 1637, "critical_question_id": 1, "statement_id_expl_id": 1637, "critical_question_id_expl_id": 1637}, "tableName": "critical_statement", "targetLabel": "(?) some in Reserve Police Battalion 101 chose to kill, plausibly motivated primarily by an internalised sense of role-duty (to obey orders, stand by comrades, fulfil their function as policemen/soldiers), not by expectation of pleasure or lesser pain or feeling like a hero"}
2025-07-15 04:46:22.064207+00	1271	18	1	105	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 105, "id_expl_id": 1271, "argument_id": 158, "statement_id": 145, "argument_id_expl_id": 1271, "critical_question_id": 47, "statement_id_expl_id": 1271, "critical_question_id_expl_id": 1271}, "tableName": "critical_statement", "targetLabel": "(?) Tipping increases autonomy by 7 autons per visit."}
2025-10-18 13:46:43.683527+00	1403	24	1	150	insertCrossRecords	statement	{"id": 150, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 1402}, "fkEnries": {"tags": {"options": [{"id": 29, "label": "science"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?) The Moon landing was fake."}
2025-11-06 01:26:14.75138+00	1521	18	1	4	insertRecord	forum_post	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 4, "text": "Test post 2", "owner_id": 18, "thread_id": 2, "user_name": "Durante", "id_expl_id": 1521, "text_expl_id": 1521, "owner_id_expl_id": 1521, "thread_id_expl_id": 1521}, "tableName": "forum_post", "targetLabel": "Test post 2"}
2025-11-20 22:34:32.976807+00	1574	5	1	\N	deleteByIds	statement	{"ids": [166, 165, 164, 163, 162, 161], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "166, 165, 164, 163, 162, 161", "deletedRecords": {"statement": [{"id": 163, "text": "s11", "label": "(?) s11", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1570, "text_expl_id": 1570, "decided_expl_id": 1570, "featured_expl_id": 1570, "chat_text_expl_id": 1570, "statement_type_id": 1, "confidence_expl_id": 1570, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1570}, {"id": 164, "text": "s12", "label": "(?) s12", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1571, "text_expl_id": 1571, "decided_expl_id": 1571, "featured_expl_id": 1571, "chat_text_expl_id": 1571, "statement_type_id": 1, "confidence_expl_id": 1571, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1571}, {"id": 165, "text": "s13", "label": "(?) s13", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1572, "text_expl_id": 1572, "decided_expl_id": 1572, "featured_expl_id": 1572, "chat_text_expl_id": 1572, "statement_type_id": 1, "confidence_expl_id": 1572, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1572}, {"id": 166, "text": "st14", "label": "(?) st14", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1573, "text_expl_id": 1573, "decided_expl_id": 1573, "featured_expl_id": 1573, "chat_text_expl_id": 1573, "statement_type_id": 1, "confidence_expl_id": 1573, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1573}, {"id": 161, "text": "st9", "label": "(?) st9", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1568, "text_expl_id": 1568, "decided_expl_id": 1568, "featured_expl_id": 1568, "chat_text_expl_id": 1568, "statement_type_id": 1, "confidence_expl_id": 1568, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1568}, {"id": 162, "text": "t10", "label": "(?) t10", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1569, "text_expl_id": 1569, "decided_expl_id": 1569, "featured_expl_id": 1569, "chat_text_expl_id": 1569, "statement_type_id": 1, "confidence_expl_id": 1569, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1569}]}}
2025-11-26 07:28:38.713836+00	1603	32	1	172	insertRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 172, "text": "classical theism is true", "label": "(?) classical theism is true", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1603, "text_expl_id": 1603, "decided_expl_id": 1603, "featured_expl_id": 1603, "chat_text_expl_id": 1603, "statement_type_id": 1, "confidence_expl_id": 1603, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1603}, "tableName": "statement", "targetLabel": "(?) classical theism is true"}
2025-11-26 19:47:12.744776+00	1623	18	1	203	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 203, "pro": false, "title": "Some men from Reserve Police Battalion 101 acted primarily from duty at Józefów.", "chat_text": "", "id_expl_id": 1623, "pro_expl_id": 1623, "statement_id": 174, "title_expl_id": 1623, "statement_label": "(?) psychological hedonism is true", "argument_type_id": 8, "chat_text_expl_id": 1623, "statement_id_expl_id": 1623, "argument_type_id_expl_id": 1623}, "extRecord": {"id": 203, "text": "In the case of Reserve Police Battalion 101 at Józefów, some men:\\n\\n1. Reasonably expected that participating in close-range shootings of civilians would involve extreme and lasting psychological suffering, and indeed many experienced such suffering. \\n\\n2. Had a live alternative - stepping aside into other duties, without severe punishment or life-ruining consequences, as shown by those who in fact took that option. \\n\\n3. Nevertheless chose to kill, plausibly motivated primarily by an internalised sense of role-duty (to obey orders, stand by comrades, fulfil their function as policemen/soldiers), not by expectation of pleasure or lesser pain or feeling like a hero. ", "id_expl_id": 1623, "text_expl_id": 1623}, "tableName": "argument", "targetLabel": "Some men from Reserve Police Battalion 101 acted primarily from duty at Józefów.", "extTableName": "argument_example"}
2025-11-26 19:48:33.839905+00	1624	18	1	204	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 204, "pro": false, "title": "Often, pleasure follows from prior non-hedonic commitments", "chat_text": "", "id_expl_id": 1624, "pro_expl_id": 1624, "statement_id": 174, "title_expl_id": 1624, "statement_label": "(?) psychological hedonism is true", "argument_type_id": 8, "chat_text_expl_id": 1624, "statement_id_expl_id": 1624, "argument_type_id_expl_id": 1624}, "extRecord": {"id": 204, "text": "1. Psychological hedonism claims that, for any intentional action, the ultimate motive is always the agent's own pleasure (or avoidance of pain). Any non-hedonic motives (health, justice, God, etc.) are at most instruments or means to pleasure.\\n\\n2. In many real cases, an agent first acquires a non-hedonic evaluative commitment (e.g. \\"my health really matters\\", \\"God is supremely good\\", \\"people who take hard drugs are contemptible\\"), and because of that commitment they then start to feel pleasure from certain behaviours and displeasure from others.\\n\\n3. In these cases, the direction of explanation runs:\\nevaluative commitment → pattern of pleasures and pains → action,\\nnot\\ndesire for pleasure → evaluative commitment → action.\\n\\n4. If psychological hedonism were true, the desire for pleasure / avoidance of pain would have to be explanatorily prior. Our evaluative commitments would ultimately be explained by their role in producing pleasure or preventing pain.\\n\\n5. But in the kinds of cases described in (2), the evaluative commitment is explanatorily prior to the pleasure: the agent’s new pleasures (and displeasures) are shaped by the commitment, not the other way round.\\n\\n6. Therefore, psychological hedonism is false.", "id_expl_id": 1624, "text_expl_id": 1624}, "tableName": "argument", "targetLabel": "Often, pleasure follows from prior non-hedonic commitments", "extTableName": "argument_example"}
2025-05-13 21:29:55.262987+00	1063	25	1	144	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 144, "pro": true, "title": "exclusive weapons", "id_expl_id": 1063, "pro_expl_id": 1063, "statement_id": 69, "title_expl_id": 1063, "argument_type_id": 3, "statement_id_expl_id": 1063, "argument_type_id_expl_id": 1063}, "extRecord": {"id": 144, "text": "1. SVD rifles and 7N1 sniper rounds were, at the time, issued solely to Interior Ministry Berkut and Alfa units.\\n2. Forensic examination of recovered bullets and wounds matched these munitions.\\n3. Video and photographic evidence places shooters on rooftops of the Conservatory and Hotel Ukraine, areas secured exclusively by Berkut and Alfa that morning.\\n4. Open-source radio intercepts record Interior Ministry commanders directing live fire from those positions at demonstrators.\\n5. When weapons, locations, and real-time orders are each uniquely tied to a single set of units, the shooters are thereby identified as those units.", "id_expl_id": 1063, "text_expl_id": 1063}, "tableName": "argument", "targetLabel": "exclusive weapons", "extTableName": "argument_other"}
2025-05-13 21:50:39.504656+00	1064	25	1	144	deleteById	argument	{"id": 144, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "exclusive weapons", "deletedRecords": {"argument": [{"id": 144, "pro": true, "title": "exclusive weapons", "id_expl_id": 1063, "pro_expl_id": 1063, "statement_id": 69, "title_expl_id": 1063, "argument_type_id": 3, "statement_id_expl_id": 1063, "argument_type_id_expl_id": 1063}], "argument_other": [{"id": 144, "text": "1. SVD rifles and 7N1 sniper rounds were, at the time, issued solely to Interior Ministry Berkut and Alfa units.\\n2. Forensic examination of recovered bullets and wounds matched these munitions.\\n3. Video and photographic evidence places shooters on rooftops of the Conservatory and Hotel Ukraine, areas secured exclusively by Berkut and Alfa that morning.\\n4. Open-source radio intercepts record Interior Ministry commanders directing live fire from those positions at demonstrators.\\n5. When weapons, locations, and real-time orders are each uniquely tied to a single set of units, the shooters are thereby identified as those units.", "id_expl_id": 1063, "text_expl_id": 1063}]}}
2025-11-26 07:43:28.191627+00	1610	32	1	116	insertRecord	critical_statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 116, "id_expl_id": 1610, "argument_id": 202, "statement_id": 171, "argument_id_expl_id": 1610, "critical_question_id": 1, "statement_id_expl_id": 1610, "critical_question_id_expl_id": 1610}, "tableName": "critical_statement", "targetLabel": "(?) apollo will not take off"}
2025-07-15 04:56:53.603008+00	1272	18	1	164	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 164, "pro": true, "title": "Tipping adds approximately +7 Autons per restaurant visit—boosting both diner and server autonomy through greater choice, discretion, and impact compared to fixed-price systems.", "chat_text": "", "id_expl_id": 1272, "pro_expl_id": 1272, "statement_id": 145, "title_expl_id": 1272, "argument_type_id": 6, "chat_text_expl_id": 1272, "statement_id_expl_id": 1272, "argument_type_id_expl_id": 1272}, "extRecord": {"id": 164, "text": "=== Diner ΔAutons ===\\n\\nVoluntariness: +1\\n\\nDiners in a tipping system have more discretionary control over how much to pay beyond the base price, compared to a fixed service fee or built-in price.\\n\\nInformedness: +1\\n\\nTipping norms are widely known and usually clear. This adds slightly more informed decision-making than a flat price system, where no extra action is required.\\n\\nRange of Choice: +1\\n\\nTipping allows diners to choose how much to give, what method to use, and whether to tip at all — more choice than in a fixed-charge setting.\\n\\nPersonal Impact: 0\\n\\nThe decision typically involves a small financial amount per meal and doesn't affect the diner's life in a meaningful way.\\n\\nReversibility: +1\\n\\nTipping can be adjusted or cancelled up until payment. In a fixed-price setting, there's nothing to revise — tipping thus adds a revisable action.\\n\\nTotal diner ΔAutons: +4\\n\\n---\\n\\n=== Server ΔAutons ===\\n\\nVoluntariness: –1\\n\\nWorking in a tip-based system isn't fully voluntary; in many regions, it's the default, and base pay is legally allowed to be very low.\\n\\nInformedness: +1\\n\\nServers are generally well aware of tipping expectations and typical amounts, so this dimension improves slightly under tipping.\\n\\nRange of Choice: +1\\n\\nTipping systems allow servers to influence their income through effort, tone, style, and engagement — offering more behavioral agency than fixed-wage models.\\n\\nPersonal Impact: +2\\n\\nTips can make a large difference in daily income and quality of life, so the autonomy stakes are higher than in a flat-wage job.\\n\\nReversibility: 0\\n\\nThere's no significant difference in how easily one can leave a tip-based job or switch roles compared to a fixed-wage one.\\n\\nTotal server ΔAutons: (+1 +1 +2 –1 +0) = +3\\n\\n---\\n\\n=== Combined total ΔAutons per transaction ===\\n\\n+4 (diner) + +3 (server) = +7 ΔA", "id_expl_id": 1272, "text_expl_id": 1272}, "tableName": "argument", "targetLabel": "Tipping adds approximately +7 Autons per restaurant visit—boosting both diner and server autonomy through greater choice, discretion, and impact compared to fixed-price systems.", "extTableName": "argument_deduction"}
2025-11-26 07:50:54.351671+00	1614	32	1	44	insertRecord	tag	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 44, "name": "psychology", "id_expl_id": 1614, "description": "Topics that are in large part about mental functions and behaviours.", "name_expl_id": 1614, "description_expl_id": 1614}, "tableName": "tag", "targetLabel": "psychology"}
2025-10-18 13:48:54.300756+00	1404	24	1	184	insertExtRecord	argument	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 184, "pro": false, "title": "Conspiracy theories are almost never true.", "chat_text": "", "id_expl_id": 1404, "pro_expl_id": 1404, "statement_id": 150, "title_expl_id": 1404, "argument_type_id": 17, "chat_text_expl_id": 1404, "statement_id_expl_id": 1404, "argument_type_id_expl_id": 1404}, "extRecord": {"id": 184, "text": "This is a conspiracy theory. Conspiracy theories very rarely turn out to be true. So most likely this one is not true either.", "id_expl_id": 1404, "text_expl_id": 1404}, "tableName": "argument", "targetLabel": "Conspiracy theories are almost never true.", "extTableName": "argument_feasibility"}
2025-11-06 21:50:07.666825+00	1522	5	1	28	join	person	{"person": {"id": 28, "name": "Mobile User"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-11-06 21:52:07.982153+00	1523	28	1	157	insertRecord	statement	{"user": {"id": 28, "name": "Mobile User", "auth_role": "invited"}, "record": {"id": 157, "text": "St6", "label": "(?) St6", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1523, "text_expl_id": 1523, "decided_expl_id": 1523, "featured_expl_id": 1523, "chat_text_expl_id": 1523, "statement_type_id": 1, "confidence_expl_id": 1523, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1523}, "tableName": "statement", "targetLabel": "(?) St6"}
2025-11-22 19:05:22.042927+00	1575	5	1	32	join	person	{"person": {"id": 32, "name": "Ferb"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-11-26 07:28:38.750249+00	1604	32	1	172	insertCrossRecords	statement	{"id": 172, "user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 1603}, "fkEnries": {"tags": {"options": [{"id": 42, "label": "philosophy"}, {"id": 43, "label": "Religion"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?) classical theism is true"}
2025-05-13 21:51:21.692146+00	1065	25	1	145	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 145, "pro": true, "title": "forensic ballistics", "id_expl_id": 1065, "pro_expl_id": 1065, "statement_id": 69, "title_expl_id": 1065, "argument_type_id": 3, "statement_id_expl_id": 1065, "argument_type_id_expl_id": 1065}, "extRecord": {"id": 145, "text": "- Eyewitnesses observed muzzle flashes from the 14th floor of Hotel Ukraina, a floor guarded exclusively by Berkut riot police.\\n- Investigators recovered 7.62×39 mm shell casings on that floor and matched them through ballistic fingerprints to bullets extracted from protesters’ bodies.\\n- Armoury logs confirm the casings’ lot numbers were issued days earlier to a Berkut unit reporting to Interior Minister Zakharchenko, Yanukovych’s appointee.\\n- Therefore the sniper who fired those rounds was acting within the Yanukovych security chain of command.", "id_expl_id": 1065, "text_expl_id": 1065}, "tableName": "argument", "targetLabel": "forensic ballistics", "extTableName": "argument_other"}
2025-05-13 22:44:10.964649+00	1066	25	1	146	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 146, "pro": true, "title": "ballistic matches", "id_expl_id": 1066, "pro_expl_id": 1066, "statement_id": 69, "title_expl_id": 1066, "argument_type_id": 3, "statement_id_expl_id": 1066, "argument_type_id_expl_id": 1066}, "extRecord": {"id": 146, "text": "Forensic examination matched bullets extracted from protesters to rifles issued to Berkut snipers, a unit commanded by the Interior Ministry under Yanukovych, which shows the shooter was on his side.", "id_expl_id": 1066, "text_expl_id": 1066}, "tableName": "argument", "targetLabel": "ballistic matches", "extTableName": "argument_other"}
2025-05-13 22:49:36.225275+00	1067	25	1	146	deleteById	argument	{"id": 146, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "ballistic matches", "deletedRecords": {"argument": [{"id": 146, "pro": true, "title": "ballistic matches", "id_expl_id": 1066, "pro_expl_id": 1066, "statement_id": 69, "title_expl_id": 1066, "argument_type_id": 3, "statement_id_expl_id": 1066, "argument_type_id_expl_id": 1066}], "argument_other": [{"id": 146, "text": "Forensic examination matched bullets extracted from protesters to rifles issued to Berkut snipers, a unit commanded by the Interior Ministry under Yanukovych, which shows the shooter was on his side.", "id_expl_id": 1066, "text_expl_id": 1066}]}}
2025-07-15 05:15:03.33587+00	1273	18	1	4	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 4, "label": "(10 / DWT$) equality", "weight": 10, "id_expl_id": 1273, "profile_id": 1, "moral_good_id": 6, "weight_expl_id": 1273, "profile_id_expl_id": 1273, "moral_good_id_expl_id": 1273}, "tableName": "moral_weight_of_profile", "targetLabel": "(10 / DWT$) equality"}
2025-07-15 05:15:13.743603+00	1274	18	1	5	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 5, "label": "(20 / MA$) merit", "weight": 20, "id_expl_id": 1274, "profile_id": 1, "moral_good_id": 7, "weight_expl_id": 1274, "profile_id_expl_id": 1274, "moral_good_id_expl_id": 1274}, "tableName": "moral_weight_of_profile", "targetLabel": "(20 / MA$) merit"}
2025-10-18 14:01:01.296568+00	1409	24	1	186	insertExtRecord	argument	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 186, "pro": true, "title": "There are no stars visible in is the dark sky.", "chat_text": "", "id_expl_id": 1409, "pro_expl_id": 1409, "statement_id": 152, "title_expl_id": 1409, "argument_type_id": 4, "chat_text_expl_id": 1409, "statement_id_expl_id": 1409, "argument_type_id_expl_id": 1409}, "extRecord": {"id": 186, "text": "On the Moon landing videos the sky is dark but no stars are visible. That is because it was filmed in a studio against a dark background rather than a real sky.", "id_expl_id": 1409, "text_expl_id": 1409}, "tableName": "argument", "targetLabel": "There are no stars visible in is the dark sky.", "extTableName": "argument_explanation"}
2025-07-15 05:15:33.548579+00	1275	18	1	6	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 6, "label": "(15 / WbD) well-being", "weight": 15, "id_expl_id": 1275, "profile_id": 1, "moral_good_id": 8, "weight_expl_id": 1275, "profile_id_expl_id": 1275, "moral_good_id_expl_id": 1275}, "tableName": "moral_weight_of_profile", "targetLabel": "(15 / WbD) well-being"}
2025-07-15 05:15:46.325961+00	1276	18	1	7	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 7, "label": "(10 / ΔRC%) rationality", "weight": 10, "id_expl_id": 1276, "profile_id": 1, "moral_good_id": 9, "weight_expl_id": 1276, "profile_id_expl_id": 1276, "moral_good_id_expl_id": 1276}, "tableName": "moral_weight_of_profile", "targetLabel": "(10 / ΔRC%) rationality"}
2025-07-15 05:15:58.378034+00	1277	18	1	8	insertRecord	moral_weight_of_profile	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 8, "label": "(25 / Δ autons) autonomy", "weight": 25, "id_expl_id": 1277, "profile_id": 1, "moral_good_id": 10, "weight_expl_id": 1277, "profile_id_expl_id": 1277, "moral_good_id_expl_id": 1277}, "tableName": "moral_weight_of_profile", "targetLabel": "(25 / Δ autons) autonomy"}
2025-11-22 19:05:24.555381+00	1576	5	1	33	join	person	{"person": {"id": 33, "name": "Ferb"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-10-18 13:53:06.881784+00	1405	24	1	185	insertExtRecord	argument	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 185, "pro": true, "title": "The Moon landing video was filmed in a studio.", "chat_text": "", "id_expl_id": 1405, "pro_expl_id": 1405, "statement_id": 150, "title_expl_id": 1405, "argument_type_id": 4, "chat_text_expl_id": 1405, "statement_id_expl_id": 1405, "argument_type_id_expl_id": 1405}, "extRecord": {"id": 185, "text": "The Moon landing video was filmed in a studio but presented as real. So Moon landing was a lie.", "id_expl_id": 1405, "text_expl_id": 1405}, "tableName": "argument", "targetLabel": "The Moon landing video was filmed in a studio.", "extTableName": "argument_explanation"}
2025-05-13 22:50:16.633014+00	1068	25	1	147	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 147, "pro": true, "title": "ballistics berkut intercepts", "id_expl_id": 1068, "pro_expl_id": 1068, "statement_id": 69, "title_expl_id": 1068, "argument_type_id": 3, "statement_id_expl_id": 1068, "argument_type_id_expl_id": 1068}, "extRecord": {"id": 147, "text": "Ballistic experts matched 7.62×54R bullet casings from wounded protesters to Dragunov rifles registered to the interior ministry’s Berkut Omega detachment; deployment orders dated 20 February 2014 show that detachment subordinated to the presidential security headquarters chaired by Viktor Yanukovych’s adviser; synchronised radio intercepts record that headquarters directing Omega snipers to \\"suppress Maidan\\" minutes before the first deaths, and time-aligned amateur videos place Berkut snipers firing from Hotel Ukraina rooms booked by the presidential administration the previous evening.", "id_expl_id": 1068, "text_expl_id": 1068}, "tableName": "argument", "targetLabel": "ballistics berkut intercepts", "extTableName": "argument_other"}
2025-05-13 22:53:06.568115+00	1069	25	1	147	deleteById	argument	{"id": 147, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "ballistics berkut intercepts", "deletedRecords": {"argument": [{"id": 147, "pro": true, "title": "ballistics berkut intercepts", "id_expl_id": 1068, "pro_expl_id": 1068, "statement_id": 69, "title_expl_id": 1068, "argument_type_id": 3, "statement_id_expl_id": 1068, "argument_type_id_expl_id": 1068}], "argument_other": [{"id": 147, "text": "Ballistic experts matched 7.62×54R bullet casings from wounded protesters to Dragunov rifles registered to the interior ministry’s Berkut Omega detachment; deployment orders dated 20 February 2014 show that detachment subordinated to the presidential security headquarters chaired by Viktor Yanukovych’s adviser; synchronised radio intercepts record that headquarters directing Omega snipers to \\"suppress Maidan\\" minutes before the first deaths, and time-aligned amateur videos place Berkut snipers firing from Hotel Ukraina rooms booked by the presidential administration the previous evening.", "id_expl_id": 1068, "text_expl_id": 1068}]}}
2025-07-15 05:41:52.277185+00	1283	18	1	13	updateRecord	moral_weight_of_profile	{"id": 13, "diff": {"after": {"weight": "5"}, "before": {"id": 13, "weight": 10, "id_expl_id": 1282, "weight_expl_id": 1282}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(5 / Δ autons) autonomy"}
2025-07-15 05:42:14.529294+00	1284	18	1	8	updateRecord	moral_weight_of_profile	{"id": 8, "diff": {"after": {"weight": "12"}, "before": {"id": 8, "weight": 25, "id_expl_id": 1277, "weight_expl_id": 1277}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(12 / Δ autons) autonomy"}
2025-10-18 13:55:12.177259+00	1406	24	1	151	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 151, "text": "The Moon landing video was filmed in a studio.", "label": "(?) The Moon landing video was filmed in a studio.", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1406, "text_expl_id": 1406, "decided_expl_id": 1406, "featured_expl_id": 1406, "chat_text_expl_id": 1406, "statement_type_id": 1, "confidence_expl_id": 1406, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1406}, "tableName": "statement", "targetLabel": "(?) The Moon landing video was filmed in a studio."}
2025-10-18 13:57:38.647755+00	1407	24	1	152	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 152, "text": "The Moon landing video was filmed in a studio.", "label": "(?) The Moon landing video was filmed in a studio.", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1407, "text_expl_id": 1407, "decided_expl_id": 1407, "featured_expl_id": 1407, "chat_text_expl_id": 1407, "statement_type_id": 1, "confidence_expl_id": 1407, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1407}, "tableName": "statement", "targetLabel": "(?) The Moon landing video was filmed in a studio."}
2025-11-06 22:37:46.243608+00	1524	28	1	193	insertExtRecord	argument	{"user": {"id": 28, "name": "Mobile User", "auth_role": "invited"}, "record": {"id": 193, "pro": true, "title": "Apples are sweet.", "chat_text": "", "id_expl_id": 1524, "pro_expl_id": 1524, "statement_id": 157, "title_expl_id": 1524, "argument_type_id": 8, "chat_text_expl_id": 1524, "statement_id_expl_id": 1524, "argument_type_id_expl_id": 1524}, "extRecord": {"id": 193, "text": "Apple is an example of a healthy sweet food.", "id_expl_id": 1524, "text_expl_id": 1524}, "tableName": "argument", "targetLabel": "Apples are sweet.", "extTableName": "argument_example"}
2025-10-18 13:57:40.152729+00	1408	24	1	108	insertRecord	critical_statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 108, "id_expl_id": 1408, "argument_id": 185, "statement_id": 152, "argument_id_expl_id": 1408, "critical_question_id": 1, "statement_id_expl_id": 1408, "critical_question_id_expl_id": 1408}, "tableName": "critical_statement", "targetLabel": "(?) The Moon landing video was filmed in a studio."}
2025-11-25 01:20:08.112521+00	1577	32	1	32	insertCrossRecord	person	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "cross": {"id": 3, "label": "US citizens", "tableName": "person_category"}, "record": {"person_id": 32, "person_id_expl_id": 1577, "person_category_id": 3, "person_category_id_expl_id": 1577}, "target": {"id": 32, "label": "Ferb", "tableName": "person"}}
2025-10-18 14:02:19.786996+00	1410	24	1	187	insertExtRecord	argument	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 187, "pro": false, "title": "People are moving slowly in the air because of low lunar gravity.", "chat_text": "", "id_expl_id": 1410, "pro_expl_id": 1410, "statement_id": 152, "title_expl_id": 1410, "argument_type_id": 4, "chat_text_expl_id": 1410, "statement_id_expl_id": 1410, "argument_type_id_expl_id": 1410}, "extRecord": {"id": 187, "text": "When astronauts in the video jump, they take off and land much slower than on Earth. So it was not filmed in a studio on Earth.", "id_expl_id": 1410, "text_expl_id": 1410}, "tableName": "argument", "targetLabel": "People are moving slowly in the air because of low lunar gravity.", "extTableName": "argument_explanation"}
2025-05-13 22:53:35.51105+00	1070	25	1	148	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 148, "pro": true, "title": "radio logs", "id_expl_id": 1070, "pro_expl_id": 1070, "statement_id": 69, "title_expl_id": 1070, "argument_type_id": 3, "statement_id_expl_id": 1070, "argument_type_id_expl_id": 1070}, "extRecord": {"id": 148, "text": "• police radio logs from 20 february 2014 record an interior ministry commander reporting to presidential security chief kostyantyn kobzar that \\"our snipers have opened fire\\" at 10:18; • kobzar immediately orders berkut riot police to advance through the same sector; • the minute-level coordination between sniper fire and berkut movement shows both units answered to the yanukovych-loyal command structure, so the snipers were acting on his side.", "id_expl_id": 1070, "text_expl_id": 1070}, "tableName": "argument", "targetLabel": "radio logs", "extTableName": "argument_other"}
2025-05-13 22:59:49.150893+00	1071	25	1	148	updateExtRecord	argument	{"id": 148, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"text": "• police radio logs from 20 february 2014 record an interior ministry commander reporting to presidential security chief kostyantyn kobzar that \\"our snipers have opened fire\\" at 10:18;\\n• kobzar immediately orders berkut riot police to advance through the same sector; \\n• the minute-level coordination between sniper fire and berkut movement shows both units answered to the yanukovych-loyal command structure, so the snipers were acting on his side."}, "before": {"id": 148, "text": "• police radio logs from 20 february 2014 record an interior ministry commander reporting to presidential security chief kostyantyn kobzar that \\"our snipers have opened fire\\" at 10:18; • kobzar immediately orders berkut riot police to advance through the same sector; • the minute-level coordination between sniper fire and berkut movement shows both units answered to the yanukovych-loyal command structure, so the snipers were acting on his side.", "id_expl_id": 1070, "text_expl_id": 1070}}, "tableName": "argument", "targetLabel": "radio logs", "extTableName": "argument_other"}
2025-05-14 00:23:00.59784+00	1073	25	1	135	insertRecord	statement	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 135, "text": "Investigators recovered 7.62×39 mm shell casings on the 14th floor and matched them through ballistic fingerprints to bullets extracted from protesters’ bodies.", "label": "(?) Investigators recovered 7.62×39 mm shell casings on the 14th floor and matched them through ballistic fingerprints to bullets extracted from protesters’ bodies.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 1073, "text_expl_id": 1073, "decided_expl_id": 1073, "featured_expl_id": 1073, "statement_type_id": 1, "confidence_expl_id": 1073, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1073}, "tableName": "statement", "targetLabel": "(?) Investigators recovered 7.62×39 mm shell casings on the 14th floor and matched them through ballistic fingerprints to bullets extracted from protesters’ bodies."}
2025-05-14 11:18:03.526831+00	1075	25	1	148	deleteById	argument	{"id": 148, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "radio logs", "deletedRecords": {"argument": [{"id": 148, "pro": true, "title": "radio logs", "id_expl_id": 1070, "pro_expl_id": 1070, "statement_id": 69, "title_expl_id": 1070, "argument_type_id": 3, "statement_id_expl_id": 1070, "argument_type_id_expl_id": 1070}], "argument_other": [{"id": 148, "text": "• police radio logs from 20 february 2014 record an interior ministry commander reporting to presidential security chief kostyantyn kobzar that \\"our snipers have opened fire\\" at 10:18;\\n• kobzar immediately orders berkut riot police to advance through the same sector; \\n• the minute-level coordination between sniper fire and berkut movement shows both units answered to the yanukovych-loyal command structure, so the snipers were acting on his side.", "id_expl_id": 1070, "text_expl_id": 1071}]}}
2025-05-14 11:18:10.784784+00	1076	25	1	145	deleteById	argument	{"id": 145, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "forensic ballistics", "deletedRecords": {"argument": [{"id": 145, "pro": true, "title": "forensic ballistics", "id_expl_id": 1065, "pro_expl_id": 1065, "statement_id": 69, "title_expl_id": 1065, "argument_type_id": 3, "statement_id_expl_id": 1065, "argument_type_id_expl_id": 1065}], "argument_other": [{"id": 145, "text": "- Eyewitnesses observed muzzle flashes from the 14th floor of Hotel Ukraina, a floor guarded exclusively by Berkut riot police.\\n- Investigators recovered 7.62×39 mm shell casings on that floor and matched them through ballistic fingerprints to bullets extracted from protesters’ bodies.\\n- Armoury logs confirm the casings’ lot numbers were issued days earlier to a Berkut unit reporting to Interior Minister Zakharchenko, Yanukovych’s appointee.\\n- Therefore the sniper who fired those rounds was acting within the Yanukovych security chain of command.", "id_expl_id": 1065, "text_expl_id": 1065}], "critical_statement": [{"id": 95, "id_expl_id": 1074, "argument_id": 145, "statement_id": 135, "argument_id_expl_id": 1074, "critical_question_id": 1, "statement_id_expl_id": 1074, "critical_question_id_expl_id": 1074}]}}
2025-05-14 11:18:30.40868+00	1077	25	1	135	deleteById	statement	{"id": 135, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) Investigators recovered 7.62×39 mm shell casings on the 14th floor and matched them through ballistic fingerprints to bullets extracted from protesters’ bodies.", "deletedRecords": {"statement": [{"id": 135, "text": "Investigators recovered 7.62×39 mm shell casings on the 14th floor and matched them through ballistic fingerprints to bullets extracted from protesters’ bodies.", "label": "(?) Investigators recovered 7.62×39 mm shell casings on the 14th floor and matched them through ballistic fingerprints to bullets extracted from protesters’ bodies.", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 1073, "text_expl_id": 1073, "decided_expl_id": 1073, "featured_expl_id": 1073, "statement_type_id": 1, "confidence_expl_id": 1073, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1073}]}}
2025-05-24 13:26:31.890526+00	1099	18	1	\N	insertRecord	issue	\N
2025-05-24 13:27:13.522666+00	1101	18	1	128	deleteById	issue	{"id": 128, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "issue", "targetLabel": "test issue", "deletedRecords": {"issue": [{"id": 128, "title": "test issue", "id_expl_id": 1100, "description": "test issue description", "title_expl_id": 1100, "description_expl_id": 1100}]}}
2025-05-14 13:16:22.615253+00	1078	25	1	149	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 149, "pro": true, "title": "berkut sniper evidence", "id_expl_id": 1078, "pro_expl_id": 1078, "statement_id": 69, "title_expl_id": 1078, "argument_type_id": 3, "statement_id_expl_id": 1078, "argument_type_id_expl_id": 1078}, "extRecord": {"id": 149, "text": "The Ukrainian government accused Yanukovych of ordering the crackdown on protesters, including sniper attacks. Government inquiries implicated members of the Berkut, a Ukrainian riot police unit, in the killings of protesters. Eyewitness accounts and photographic evidence suggested Berkut snipers were positioned in strategic locations, firing upon protesters. Forensic analysis subsequently linked bullets recovered from victims to weapons used by the Berkut_text_", "id_expl_id": 1078, "text_expl_id": 1078}, "tableName": "argument", "targetLabel": "berkut sniper evidence", "extTableName": "argument_other"}
2025-05-14 13:29:41.920148+00	1079	25	1	149	deleteById	argument	{"id": 149, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "berkut sniper evidence", "deletedRecords": {"argument": [{"id": 149, "pro": true, "title": "berkut sniper evidence", "id_expl_id": 1078, "pro_expl_id": 1078, "statement_id": 69, "title_expl_id": 1078, "argument_type_id": 3, "statement_id_expl_id": 1078, "argument_type_id_expl_id": 1078}], "argument_other": [{"id": 149, "text": "The Ukrainian government accused Yanukovych of ordering the crackdown on protesters, including sniper attacks. Government inquiries implicated members of the Berkut, a Ukrainian riot police unit, in the killings of protesters. Eyewitness accounts and photographic evidence suggested Berkut snipers were positioned in strategic locations, firing upon protesters. Forensic analysis subsequently linked bullets recovered from victims to weapons used by the Berkut_text_", "id_expl_id": 1078, "text_expl_id": 1078}]}}
2025-05-14 13:46:19.482035+00	1080	25	1	150	insertExtRecord	argument	{"user": {"id": 25, "name": "bot", "auth_role": "invited"}, "record": {"id": 150, "pro": true, "title": "official accusations and investigations", "id_expl_id": 1080, "pro_expl_id": 1080, "statement_id": 69, "title_expl_id": 1080, "argument_type_id": 3, "statement_id_expl_id": 1080, "argument_type_id_expl_id": 1080}, "extRecord": {"id": 150, "text": "* Ukraine's interim authorities in 2014 accused then-President Viktor Yanukovych of ordering snipers to fire on protesters.\\n* The acting Interior Minister, Arsen Avakov, stated that 12 members of the Berkut (special forces) police unit were identified as suspects in the shootings on Instytutska Street.\\n* The new head of Ukraine's security service (SBU), Valentyn Nalyvaychenko, claimed Yanukovych himself ordered the killings, describing it as an \\"operation of mass killing of people\\" under his direct leadership.\\n* An investigation by the Ukrainian Bureau of Investigations later concluded in 2020 that the assault on Maidan protesters was ordered by Yanukovych and his subordinates.\\n* The Ministry of Internal Affairs also confirmed that Yanukovych gave the order to fire on protesters on February 20, 2014.", "id_expl_id": 1080, "text_expl_id": 1080}, "tableName": "argument", "targetLabel": "official accusations and investigations", "extTableName": "argument_other"}
2025-05-14 17:31:29.350884+00	1081	25	1	150	deleteById	argument	{"id": 150, "user": {"id": 25, "name": "bot", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "official accusations and investigations", "deletedRecords": {"argument": [{"id": 150, "pro": true, "title": "official accusations and investigations", "id_expl_id": 1080, "pro_expl_id": 1080, "statement_id": 69, "title_expl_id": 1080, "argument_type_id": 3, "statement_id_expl_id": 1080, "argument_type_id_expl_id": 1080}], "argument_other": [{"id": 150, "text": "* Ukraine's interim authorities in 2014 accused then-President Viktor Yanukovych of ordering snipers to fire on protesters.\\n* The acting Interior Minister, Arsen Avakov, stated that 12 members of the Berkut (special forces) police unit were identified as suspects in the shootings on Instytutska Street.\\n* The new head of Ukraine's security service (SBU), Valentyn Nalyvaychenko, claimed Yanukovych himself ordered the killings, describing it as an \\"operation of mass killing of people\\" under his direct leadership.\\n* An investigation by the Ukrainian Bureau of Investigations later concluded in 2020 that the assault on Maidan protesters was ordered by Yanukovych and his subordinates.\\n* The Ministry of Internal Affairs also confirmed that Yanukovych gave the order to fire on protesters on February 20, 2014.", "id_expl_id": 1080, "text_expl_id": 1080}]}}
2025-05-23 22:20:55.999071+00	1082	5	1	2	insertExtRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 2, "title": "put an index on invite.code", "id_expl_id": 1082, "description": "", "title_expl_id": 1082, "description_expl_id": 1082}, "extRecord": {"id": 2, "status": "backlog", "id_expl_id": 1082, "project_stage": "closed β rel.", "status_expl_id": 1082, "functional_area": "perf.", "project_stage_expl_id": 1082, "functional_area_expl_id": 1082}, "tableName": "issue", "targetLabel": "put an index on invite.code", "extTableName": "task"}
2025-05-23 22:39:01.207167+00	1083	5	1	3	insertExtRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 3, "title": "move coding, content, marketing tasks to Apollo", "id_expl_id": 1083, "description": "make sure creation of issues by other people is still simple", "title_expl_id": 1083, "description_expl_id": 1083}, "extRecord": {"id": 3, "status": "in progress", "id_expl_id": 1083, "project_stage": "closed β rel.", "status_expl_id": 1083, "functional_area": "UX", "project_stage_expl_id": 1083, "functional_area_expl_id": 1083}, "tableName": "issue", "targetLabel": "move coding, content, marketing tasks to Apollo", "extTableName": "task"}
2025-05-23 22:40:13.547723+00	1084	5	1	4	insertExtRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 4, "title": "remove createEffect in Form.tsx", "id_expl_id": 1084, "description": "Replace createEffect hooks that update diffs in Form.tsx by keeping the different sources of form values in separate signals and combning them via an upgraded version of currentRecord where the values that user inputted have the top priority", "title_expl_id": 1084, "description_expl_id": 1084}, "extRecord": {"id": 4, "status": "next up", "id_expl_id": 1084, "project_stage": "codebase rel.", "status_expl_id": 1084, "functional_area": "DX", "project_stage_expl_id": 1084, "functional_area_expl_id": 1084}, "tableName": "issue", "targetLabel": "remove createEffect in Form.tsx", "extTableName": "task"}
2025-05-23 22:40:51.086095+00	1085	5	1	5	insertExtRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 5, "title": "Make sure that your directives look fine when matched", "id_expl_id": 1085, "description": "", "title_expl_id": 1085, "description_expl_id": 1085}, "extRecord": {"id": 5, "status": "backlog", "id_expl_id": 1085, "project_stage": "closed β rel.", "status_expl_id": 1085, "functional_area": "UX", "project_stage_expl_id": 1085, "functional_area_expl_id": 1085}, "tableName": "issue", "targetLabel": "Make sure that your directives look fine when matched", "extTableName": "task"}
2025-05-23 22:41:55.438168+00	1086	5	1	6	insertExtRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 6, "title": "Bug: critical statement expl shows id", "id_expl_id": 1086, "description": "", "title_expl_id": 1086, "description_expl_id": 1086}, "extRecord": {"id": 6, "status": "next up", "id_expl_id": 1086, "project_stage": "closed β rel.", "status_expl_id": 1086, "functional_area": "UX", "project_stage_expl_id": 1086, "functional_area_expl_id": 1086}, "tableName": "issue", "targetLabel": "Bug: critical statement expl shows id", "extTableName": "task"}
2025-05-23 22:46:17.83693+00	1087	5	1	7	insertExtRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 7, "title": "Bug: judgement buttons have swollen ", "id_expl_id": 1087, "description": "", "title_expl_id": 1087, "description_expl_id": 1087}, "extRecord": {"id": 7, "status": "next up", "id_expl_id": 1087, "project_stage": "closed β rel.", "status_expl_id": 1087, "functional_area": "UX", "project_stage_expl_id": 1087, "functional_area_expl_id": 1087}, "tableName": "issue", "targetLabel": "Bug: judgement buttons have swollen ", "extTableName": "task"}
2025-05-23 22:50:13.40387+00	1088	5	1	8	insertExtRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 8, "title": "explanation of consequence numbers should be in the argument text", "id_expl_id": 1088, "description": "the example pragmatic arguments are lacking this", "title_expl_id": 1088, "description_expl_id": 1088}, "extRecord": {"id": 8, "status": "next up", "id_expl_id": 1088, "project_stage": "closed β rel.", "status_expl_id": 1088, "functional_area": "content", "project_stage_expl_id": 1088, "functional_area_expl_id": 1088}, "tableName": "issue", "targetLabel": "explanation of consequence numbers should be in the argument text", "extTableName": "task"}
2025-07-15 05:42:40.279498+00	1285	18	1	12	updateRecord	moral_weight_of_profile	{"id": 12, "diff": {"after": {"weight": "1"}, "before": {"id": 12, "weight": 10, "id_expl_id": 1281, "weight_expl_id": 1281}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(1 / ΔRC%) rationality"}
2025-05-23 22:51:25.761327+00	1089	5	1	9	insertExtRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 9, "title": "Feature: define and disambiguate terms", "id_expl_id": 1089, "description": "Add the function to define and disambiguate terms in the everywhere really", "title_expl_id": 1089, "description_expl_id": 1089}, "extRecord": {"id": 9, "status": "backlog", "id_expl_id": 1089, "project_stage": "closed β rel.", "status_expl_id": 1089, "functional_area": "UX", "project_stage_expl_id": 1089, "functional_area_expl_id": 1089}, "tableName": "issue", "targetLabel": "Feature: define and disambiguate terms", "extTableName": "task"}
2025-05-23 23:07:37.54438+00	1090	5	1	10	insertExtRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 10, "title": "process Apollo notes in Keep", "id_expl_id": 1090, "description": "", "title_expl_id": 1090, "description_expl_id": 1090}, "extRecord": {"id": 10, "status": "next up", "id_expl_id": 1090, "project_stage": "closed β rel.", "status_expl_id": 1090, "functional_area": "unknown", "project_stage_expl_id": 1090, "functional_area_expl_id": 1090}, "tableName": "issue", "targetLabel": "process Apollo notes in Keep", "extTableName": "task"}
2025-05-24 12:13:37.575624+00	1092	5	1	77	updateRecord	issue	{"id": 77, "diff": {"after": {"description": "use markdown\\nimplement something like https://euangoddard.github.io/clipboard2markdown/ so that it's easy to copy formatted responses from ChatGPT"}, "before": {"id": 77, "id_expl_id": null, "description": "use markdown", "description_expl_id": 1091}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "issue", "targetLabel": "support formatted text"}
2025-05-24 12:15:59.055222+00	1094	5	1	20	updateRecord	issue	{"id": 20, "diff": {"after": {"description": "(What if Name has space?)\\nThe target should receive a notification about an unread mention."}, "before": {"id": 20, "id_expl_id": null, "description": "(What if Name has space?)", "description_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "issue", "targetLabel": "Allow adressing people with @Name from the general chat, as well as from the statement discussion"}
2025-07-15 05:46:58.145161+00	1287	18	1	11	updateRecord	moral_weight_of_profile	{"id": 11, "diff": {"after": {"weight": "150"}, "before": {"id": 11, "weight": 15, "id_expl_id": 1280, "weight_expl_id": 1280}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(150 / WbD) well-being"}
2025-07-15 06:01:24.634335+00	1293	18	1	165	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 165, "pro": true, "title": "Assuming average, respectful tipping behaviour, each restaurant visit contributes approximately +0.03 Work-based Distress units (WbD) in emotional uplift for the server by offering brief but meaningful moments of appreciation and recognition.", "chat_text": "", "id_expl_id": 1293, "pro_expl_id": 1293, "statement_id": 143, "title_expl_id": 1293, "argument_type_id": 6, "chat_text_expl_id": 1293, "statement_id_expl_id": 1293, "argument_type_id_expl_id": 1293}, "extRecord": {"id": 165, "text": "General Reasoning:\\n\\n- Emotional uplift from a good tip is real but usually brief and partial—it may brighten the mood, boost self-worth, and validate effort.\\n- Not every customer tips well—but assuming the average tip is decent and respectful, it still offers a small boost.\\n- A full day of feeling emotionally valued and connected might equal +1 WbD.\\n- Servers typically interact with ~20 customers per shift.\\n\\nSo if the total emotional benefit of tipping across a shift adds up to around +0.5 to +1 WbD (due to several moments of appreciation), the average contribution per diner is:\\n\\n+0.025 to +0.05 WbD per customer visit\\n\\n---\\n\\nFinal Estimate:\\n\\nWbD of positive emotional impact from one tipping interaction: +0.03 (rounded average)\\n\\nThis reflects a modest but real improvement in emotional well-being through appreciation, recognition, and meaningful engagement.", "id_expl_id": 1293, "text_expl_id": 1293}, "tableName": "argument", "targetLabel": "Assuming average, respectful tipping behaviour, each restaurant visit contributes approximately +0.03 Work-based Distress units (WbD) in emotional uplift for the server by offering brief but meaningful moments of appreciation and recognition.", "extTableName": "argument_deduction"}
2025-05-24 12:15:55.079304+00	1093	5	1	21	updateRecord	issue	{"id": 21, "diff": {"after": {"title": "I often find myself answering the same thing for \\"Why this is a relevant authority?\\"", "description": "Wikipedia, IPCC"}, "before": {"id": 21, "title": "The target should recieve a notification about an unread mention.", "id_expl_id": null, "description": "I often find myself answering the same thing for \\"Why this is a relevant authority?\\"\\nWikipedia, IPCC", "title_expl_id": null, "description_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "issue", "targetLabel": "I often find myself answering the same thing for \\"Why this is a relevant authority?\\""}
2025-05-24 12:16:50.697817+00	1095	5	1	\N	deleteByIds	issue	{"ids": [78, 79], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "issue", "targetLabel": "78, 79", "deletedRecords": {"task": [{"id": 78, "status": "backlog", "id_expl_id": null, "project_stage": "launch", "status_expl_id": null, "functional_area": "UX", "project_stage_expl_id": null, "functional_area_expl_id": null}, {"id": 79, "status": "backlog", "id_expl_id": null, "project_stage": "launch", "status_expl_id": null, "functional_area": "UX", "project_stage_expl_id": null, "functional_area_expl_id": null}], "issue": [{"id": 78, "title": "use markdown", "id_expl_id": null, "description": "", "title_expl_id": null, "description_expl_id": null}, {"id": 79, "title": "implement something like https://euangoddard.github.io/clipboard2markdown/ so that it's easy to copy formatted responses from ChatGPT", "id_expl_id": null, "description": "", "title_expl_id": null, "description_expl_id": null}]}}
2025-05-24 13:22:54.720736+00	1096	5	1	3	updateExtRecord	issue	{"id": 3, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "next up"}, "before": {"id": 3, "status": "in progress", "id_expl_id": 1083, "status_expl_id": 1083}}, "tableName": "issue", "targetLabel": "move coding, content, marketing tasks to Apollo", "extTableName": "task"}
2025-05-24 13:27:55.207285+00	1102	5	1	3	updateExtRecord	issue	{"id": 3, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 3, "status": "in progress", "id_expl_id": 1083, "status_expl_id": 1097}}, "tableName": "issue", "targetLabel": "move coding, content, marketing tasks to Apollo", "extTableName": "task"}
2025-05-24 13:52:34.105716+00	1103	5	1	4	updateExtRecord	issue	{"id": 4, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "backlog"}, "before": {"id": 4, "status": "next up", "id_expl_id": 1084, "status_expl_id": 1084}}, "tableName": "issue", "targetLabel": "remove createEffect in Form.tsx", "extTableName": "task"}
2025-05-24 14:17:53.645274+00	1104	5	1	5	updateExtRecord	issue	{"id": 5, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 5, "status": "next up", "id_expl_id": 1085, "status_expl_id": 1085}}, "tableName": "issue", "targetLabel": "Make sure that your directives look fine when matched", "extTableName": "task"}
2025-05-24 14:24:28.149402+00	1105	24	1	136	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 136, "text": "green is warmer than blue", "label": "(?) green is warmer than blue", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 1105, "text_expl_id": 1105, "decided_expl_id": 1105, "featured_expl_id": 1105, "statement_type_id": 1, "confidence_expl_id": 1105, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1105}, "tableName": "statement", "targetLabel": "(?) green is warmer than blue"}
2025-07-15 05:45:53.166946+00	1286	18	1	7	updateRecord	moral_weight_of_profile	{"id": 7, "diff": {"after": {"weight": "1"}, "before": {"id": 7, "weight": 10, "id_expl_id": 1276, "weight_expl_id": 1276}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(1 / ΔRC%) rationality"}
2025-10-18 14:09:21.953539+00	1411	24	1	186	insertRecord	argument_judgement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 186, "label": "There are no stars visible in is the dark sky. (70%)", "id_expl_id": 1411, "isolated_confidence": 0.7, "isolated_explanation": "For this particular argument and considering that no critical question were asked the explanation appears to be plausible, we don't have other explanations to consider but it relies on a single peace of evidence so overall I'll give it a score of 70%.", "isolated_confidence_expl_id": 1411, "isolated_explanation_expl_id": 1411}, "tableName": "argument_judgement", "targetLabel": "There are no stars visible in is the dark sky. (70%)"}
2025-11-06 22:45:26.226468+00	1525	28	1	158	insertRecord	statement	{"user": {"id": 28, "name": "Mobile User", "auth_role": "invited"}, "record": {"id": 158, "text": "apples are a healthy food", "label": "(?) apples are a healthy food", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1525, "text_expl_id": 1525, "decided_expl_id": 1525, "featured_expl_id": 1525, "chat_text_expl_id": 1525, "statement_type_id": 1, "confidence_expl_id": 1525, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1525}, "tableName": "statement", "targetLabel": "(?) apples are a healthy food"}
2025-11-25 01:20:15.717+00	1578	32	1	32	insertCrossRecord	person	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "cross": {"id": 5, "label": "everyone", "tableName": "person_category"}, "record": {"person_id": 32, "person_id_expl_id": 1578, "person_category_id": 5, "person_category_id_expl_id": 1578}, "target": {"id": 32, "label": "Ferb", "tableName": "person"}}
2025-11-26 07:29:06.570615+00	1605	32	1	43	updateRecord	tag	{"id": 43, "diff": {"after": {"name": "religion"}, "before": {"id": 43, "name": "Religion", "id_expl_id": 1602, "name_expl_id": 1602}}, "user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "userExpl": "", "tableName": "tag", "targetLabel": "religion"}
2025-12-07 14:52:01.46405+00	1807	5	1	34	join	person	{"person": {"id": 34, "name": "one flame"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-05-24 14:24:33.791314+00	1106	24	1	96	insertRecord	critical_statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 96, "id_expl_id": 1106, "argument_id": 105, "statement_id": 136, "argument_id_expl_id": 1106, "critical_question_id": 1, "statement_id_expl_id": 1106, "critical_question_id_expl_id": 1106}, "tableName": "critical_statement", "targetLabel": 136}
2025-05-24 14:40:45.0895+00	1107	24	1	137	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 137, "text": "the sky is blue", "label": "(?) the sky is blue", "decided": false, "featured": false, "confidence": 0.5, "id_expl_id": 1107, "text_expl_id": 1107, "decided_expl_id": 1107, "featured_expl_id": 1107, "statement_type_id": 1, "confidence_expl_id": 1107, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1107}, "tableName": "statement", "targetLabel": "(?) the sky is blue"}
2025-07-15 05:47:14.7195+00	1288	18	1	6	updateRecord	moral_weight_of_profile	{"id": 6, "diff": {"after": {"weight": "150"}, "before": {"id": 6, "weight": 15, "id_expl_id": 1275, "weight_expl_id": 1275}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(150 / WbD) well-being"}
2025-07-15 05:49:58.76001+00	1292	18	1	6	updateRecord	moral_weight_of_profile	{"id": 6, "diff": {"after": {"weight": "1500"}, "before": {"id": 6, "weight": 150, "id_expl_id": 1275, "weight_expl_id": 1288}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(1500 / WbD) well-being"}
2025-10-18 14:10:45.554719+00	1412	24	1	187	insertRecord	argument_judgement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 187, "label": "People are moving slowly in the air because of low lunar gravity. (30%)", "id_expl_id": 1412, "isolated_confidence": 0.3, "isolated_explanation": "Unlike the pro argument, an alternative explanation easily jumps to mind. If this was filmed in a studio , the astronauts could have been easily pulled by ropes. That's how the movies are usually shot in scenes where the actors fly around. So I'd say this arguments fits easily the 20%-40% category.", "isolated_confidence_expl_id": 1412, "isolated_explanation_expl_id": 1412}, "tableName": "argument_judgement", "targetLabel": "People are moving slowly in the air because of low lunar gravity. (30%)"}
2025-10-18 14:14:37.384304+00	1414	24	1	185	insertRecord	argument_judgement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 185, "label": "The Moon landing video was filmed in a studio. (75%)", "id_expl_id": 1414, "isolated_confidence": 0.75, "isolated_explanation": "Here we are explaining the evidence that the moon landing was filmed in a studio by Moon Landing being fake. It's a pretty straight forward explanation save for the fact that Apollo is only 75% certain in the evidence. On the other hand, no competing explanations for this evidence was presented.", "isolated_confidence_expl_id": 1414, "isolated_explanation_expl_id": 1414}, "tableName": "argument_judgement", "targetLabel": "The Moon landing video was filmed in a studio. (75%)"}
2025-10-18 14:19:02.478455+00	1416	\N	1	150	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.26923076923076916}, "before": {"id": 150, "decided": false, "confidence": 0.5, "id_expl_id": 1402, "decided_expl_id": 1402, "confidence_expl_id": 1402}}, "statement": {"id": 150, "text": "The Moon landing was fake.", "id_expl_id": 1402, "text_expl_id": 1402}, "confidences": [[0.9], [0.75]], "triggerLabel": "insert of argument judgement", "triggerExplId": 1415, "statementArguments": [{"id": 184, "pro": false, "id_expl_id": 1404, "pro_expl_id": 1404, "statement_id": 150, "title_expl_id": 1404, "argument_type_id": 17, "chat_text_expl_id": 1404, "statement_id_expl_id": 1404, "argument_type_id_expl_id": 1404}, {"id": 185, "pro": true, "id_expl_id": 1405, "pro_expl_id": 1405, "statement_id": 150, "title_expl_id": 1405, "argument_type_id": 4, "chat_text_expl_id": 1405, "statement_id_expl_id": 1405, "argument_type_id_expl_id": 1405}], "argumentConfidences": [{"pro": true, "pro_expl_id": 1405, "isolated_confidence": 0.75, "conditional_confidence": null, "isolated_confidence_expl_id": 1414, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": 1404, "isolated_confidence": 0.9, "conditional_confidence": null, "isolated_confidence_expl_id": 1415, "conditional_confidence_expl_id": null}]}
2025-10-18 14:19:02.449316+00	1415	24	1	184	insertRecord	argument_judgement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 184, "label": "Conspiracy theories are almost never true. (90%)", "id_expl_id": 1415, "isolated_confidence": 0.9, "isolated_explanation": "The rate of conspiracy theories that turn out to be false is definitely above 95%, although no actual statistical evidence was presented.This is definitely a conspiracy theory and there is nothing special in this one compared to others. So this fits the top bracket.", "isolated_confidence_expl_id": 1415, "isolated_explanation_expl_id": 1415}, "tableName": "argument_judgement", "targetLabel": "Conspiracy theories are almost never true. (90%)"}
2025-11-06 22:45:39.247062+00	1526	28	1	110	insertRecord	critical_statement	{"user": {"id": 28, "name": "Mobile User", "auth_role": "invited"}, "record": {"id": 110, "id_expl_id": 1526, "argument_id": 193, "statement_id": 158, "argument_id_expl_id": 1526, "critical_question_id": 1, "statement_id_expl_id": 1526, "critical_question_id_expl_id": 1526}, "tableName": "critical_statement", "targetLabel": "(?) apples are a healthy food"}
2025-11-06 22:47:10.746757+00	1527	28	1	194	insertExtRecord	argument	{"user": {"id": 28, "name": "Mobile User", "auth_role": "invited"}, "record": {"id": 194, "pro": false, "title": "Apples are high in calories.", "chat_text": "", "id_expl_id": 1527, "pro_expl_id": 1527, "statement_id": 158, "title_expl_id": 1527, "argument_type_id": 6, "chat_text_expl_id": 1527, "statement_id_expl_id": 1527, "argument_type_id_expl_id": 1527}, "extRecord": {"id": 194, "text": "Apples are high calories. High calorie food is not healthy.", "id_expl_id": 1527, "text_expl_id": 1527}, "tableName": "argument", "targetLabel": "Apples are high in calories.", "extTableName": "argument_deduction"}
2025-05-24 14:40:47.701531+00	1108	24	1	97	insertRecord	critical_statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 97, "id_expl_id": 1108, "argument_id": 105, "statement_id": 137, "argument_id_expl_id": 1108, "critical_question_id": 1, "statement_id_expl_id": 1108, "critical_question_id_expl_id": 1108}, "tableName": "critical_statement", "targetLabel": "(?) the sky is blue"}
2025-05-24 14:45:41.723507+00	1109	5	1	6	updateExtRecord	issue	{"id": 6, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 6, "status": "next up", "id_expl_id": 1086, "status_expl_id": 1086}}, "tableName": "issue", "targetLabel": "Bug: critical statement expl shows id", "extTableName": "task"}
2025-05-24 15:31:10.6085+00	1110	5	1	7	updateExtRecord	issue	{"id": 7, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 7, "status": "next up", "id_expl_id": 1087, "status_expl_id": 1087}}, "tableName": "issue", "targetLabel": "Bug: judgement buttons have swollen ", "extTableName": "task"}
2025-05-24 15:40:43.998081+00	1111	5	1	8	updateExtRecord	issue	{"id": 8, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 8, "status": "next up", "id_expl_id": 1088, "status_expl_id": 1088}}, "tableName": "issue", "targetLabel": "explanation of consequence numbers should be in the argument text", "extTableName": "task"}
2025-07-15 05:48:18.746547+00	1289	18	1	11	updateRecord	moral_weight_of_profile	{"id": 11, "diff": {"after": {"weight": "120"}, "before": {"id": 11, "weight": 150, "id_expl_id": 1280, "weight_expl_id": 1287}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(120 / WbD) well-being"}
2025-10-18 14:10:45.565718+00	1413	\N	1	152	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.7531645569620252}, "before": {"id": 152, "decided": false, "confidence": 0.5, "id_expl_id": 1407, "decided_expl_id": 1407, "confidence_expl_id": 1407}}, "statement": {"id": 152, "text": "The Moon landing video was filmed in a studio.", "id_expl_id": 1407, "text_expl_id": 1407}, "confidences": [[0.3], [0.7]], "triggerLabel": "insert of argument judgement", "triggerExplId": 1412, "statementArguments": [{"id": 186, "pro": true, "id_expl_id": 1409, "pro_expl_id": 1409, "statement_id": 152, "title_expl_id": 1409, "argument_type_id": 4, "chat_text_expl_id": 1409, "statement_id_expl_id": 1409, "argument_type_id_expl_id": 1409}, {"id": 187, "pro": false, "id_expl_id": 1410, "pro_expl_id": 1410, "statement_id": 152, "title_expl_id": 1410, "argument_type_id": 4, "chat_text_expl_id": 1410, "statement_id_expl_id": 1410, "argument_type_id_expl_id": 1410}], "argumentConfidences": [{"pro": true, "pro_expl_id": 1409, "isolated_confidence": 0.7, "conditional_confidence": null, "isolated_confidence_expl_id": 1411, "conditional_confidence_expl_id": null}, {"pro": false, "pro_expl_id": 1410, "isolated_confidence": 0.3, "conditional_confidence": null, "isolated_confidence_expl_id": 1412, "conditional_confidence_expl_id": null}]}
2025-11-06 22:47:43.647063+00	1529	\N	1	158	attemptJudgeStatement	statement	{"diff": {"after": {"decided": true, "confidence": 0.15000000000000002}, "before": {"id": 158, "decided": false, "confidence": 0.5, "id_expl_id": 1525, "decided_expl_id": 1525, "confidence_expl_id": 1525}}, "statement": {"id": 158, "text": "apples are a healthy food", "id_expl_id": 1525, "text_expl_id": 1525}, "confidences": [[0.7], []], "triggerLabel": "insert of argument judgement", "triggerExplId": 1528, "statementArguments": [{"id": 194, "pro": false, "id_expl_id": 1527, "pro_expl_id": 1527, "statement_id": 158, "title_expl_id": 1527, "argument_type_id": 6, "chat_text_expl_id": 1527, "statement_id_expl_id": 1527, "argument_type_id_expl_id": 1527}], "argumentConfidences": [{"pro": false, "pro_expl_id": 1527, "isolated_confidence": 0.7, "conditional_confidence": null, "isolated_confidence_expl_id": 1528, "conditional_confidence_expl_id": null}]}
2025-11-25 01:32:44.349408+00	1579	32	1	42	insertRecord	tag	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 42, "name": "philosophy", "id_expl_id": 1579, "description": "study of the truths and principles of being, schools of thought, knowledge, or conduct.", "name_expl_id": 1579, "description_expl_id": 1579}, "tableName": "tag", "targetLabel": "philosophy"}
2025-11-26 07:38:27.839219+00	1606	32	1	201	insertExtRecord	argument	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 201, "pro": false, "title": "classical theism is very specific", "chat_text": "", "id_expl_id": 1606, "pro_expl_id": 1606, "statement_id": 172, "title_expl_id": 1606, "argument_type_id": 3, "chat_text_expl_id": 1606, "statement_id_expl_id": 1606, "argument_type_id_expl_id": 1606}, "extRecord": {"id": 201, "text": "Classical theism is a very specific hypothesis, therefore it requires many independent propositions to be correct in order to be true.", "id_expl_id": 1606, "text_expl_id": 1606}, "tableName": "argument", "targetLabel": "classical theism is very specific", "extTableName": "argument_other"}
2025-11-26 07:41:21.831499+00	1607	32	1	173	insertRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 173, "text": "Apollo will be recognized as an epistemic authority", "label": "(?) Apollo will be recognized as an epistemic authority", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1607, "text_expl_id": 1607, "decided_expl_id": 1607, "featured_expl_id": 1607, "chat_text_expl_id": 1607, "statement_type_id": 1, "confidence_expl_id": 1607, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1607}, "tableName": "statement", "targetLabel": "(?) Apollo will be recognized as an epistemic authority"}
2025-11-28 06:06:34.881099+00	1676	5	1	18	updateRecord	person	{"id": 18, "diff": {"after": {"permission_level": "1000"}, "before": {"id": 18, "id_expl_id": 504, "permission_level": 100, "permission_level_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin", "permission_level": 100}, "userExpl": "It's my non-admin account", "tableName": "person", "targetLabel": "Durante"}
2025-05-24 17:50:04.822684+00	1112	5	1	129	insertExtRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 129, "title": "split apart argument and statement pages", "id_expl_id": 1112, "description": "Separate the argument page from the statement page.\\n\\n=== New Argument Page ===\\nKeep a statement in smaller font at the top. The rest of the content assumes that the user has read it.\\nPros:\\n* Makes the page significantly simpler and less cramped\\n* This will make it a great focus on the argument because it's in the first column. The list of arguments kind of gets in the way when scanning from a left to right.\\n\\n=== New Statement Page ===\\nSmaller statement at the top. Select between arguments in the middle.\\nPros:\\n* The benefit of listing arguments in the middle of the page is to highlight their significance.\\n* We can include more words, making it easier to understand before jumping in. Replace argument title with argument summary.\\n* We can show their weight - the importance that Apollo assigns to them.\\n* We can show cumulative weight of each of the sides, avoiding an impression of equal significance and giving more insight into the formula that gives the final verdict.\\n*When opening a new statement, no argument is shown anyway, so the user currently still need to click on an argument.", "title_expl_id": 1112, "description_expl_id": 1112}, "extRecord": {"id": 129, "status": "in progress", "id_expl_id": 1112, "project_stage": "closed β rel.", "status_expl_id": 1112, "functional_area": "UX", "project_stage_expl_id": 1112, "functional_area_expl_id": 1112}, "tableName": "issue", "targetLabel": "split apart argument and statement pages", "extTableName": "task"}
2025-05-25 16:19:58.773353+00	1113	5	1	129	updateRecord	issue	{"id": 129, "diff": {"after": {"description": "Separate the argument page from the statement page.\\n\\n=== New Argument Page ===\\nKeep a statement in smaller font at the top. The rest of the content assumes that the user has read it. Indicate which side of the statement the argument is on.\\nPros:\\n* Makes the page significantly simpler and less cramped\\n* This will make it a great focus on the argument because it's in the first column. The list of arguments kind of gets in the way when scanning from a left to right.\\n\\n=== New Statement Page ===\\nSmaller statement at the top. Select between arguments in the middle.\\nPros:\\n* The benefit of listing arguments in the middle of the page is to highlight their significance.\\n* We can include more words, making it easier to understand before jumping in. Replace argument title with argument summary.\\n* We can show their weight - the importance that Apollo assigns to them.\\n* We can show cumulative weight of each of the sides, avoiding an impression of equal significance and giving more insight into the formula that gives the final verdict.\\n*When opening a new statement, no argument is shown anyway, so the user currently still need to click on an argument."}, "before": {"id": 129, "id_expl_id": 1112, "description": "Separate the argument page from the statement page.\\n\\n=== New Argument Page ===\\nKeep a statement in smaller font at the top. The rest of the content assumes that the user has read it.\\nPros:\\n* Makes the page significantly simpler and less cramped\\n* This will make it a great focus on the argument because it's in the first column. The list of arguments kind of gets in the way when scanning from a left to right.\\n\\n=== New Statement Page ===\\nSmaller statement at the top. Select between arguments in the middle.\\nPros:\\n* The benefit of listing arguments in the middle of the page is to highlight their significance.\\n* We can include more words, making it easier to understand before jumping in. Replace argument title with argument summary.\\n* We can show their weight - the importance that Apollo assigns to them.\\n* We can show cumulative weight of each of the sides, avoiding an impression of equal significance and giving more insight into the formula that gives the final verdict.\\n*When opening a new statement, no argument is shown anyway, so the user currently still need to click on an argument.", "description_expl_id": 1112}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "issue", "targetLabel": "split apart argument and statement pages"}
2025-06-15 22:54:07.217878+00	1114	18	1	33	updateRecord	argument	{"id": "33", "diff": {"after": {"title": "humans burn fossil fuels -> CO2 is released -> traps more heat for the Sun -> global warming"}, "before": {"id": 33, "title": "because of CO2", "id_expl_id": null, "title_expl_id": 325}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "humans burn fossil fuels -> CO2 is released -> traps more heat for the Sun -> global warming"}
2025-06-15 22:56:49.89043+00	1115	18	1	34	updateRecord	argument	{"id": "34", "diff": {"after": {"title": "The Earth has warmed naturally many times before."}, "before": {"id": 34, "title": "natural cause", "id_expl_id": null, "title_expl_id": 330}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The Earth has warmed naturally many times before."}
2025-06-15 22:57:59.241835+00	1116	18	1	33	updateRecord	argument	{"id": "33", "diff": {"after": {"title": "Humans burn fossil fuels -> CO2 is released -> traps more heat for the Sun -> global warming."}, "before": {"id": 33, "title": "humans burn fossil fuels -> CO2 is released -> traps more heat for the Sun -> global warming", "id_expl_id": null, "title_expl_id": 1114}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Humans burn fossil fuels -> CO2 is released -> traps more heat for the Sun -> global warming."}
2025-06-15 23:23:06.775079+00	1117	18	1	44	updateRecord	argument	{"id": "44", "diff": {"after": {"title": "Science can’t predict the weather only a couple of weeks ahead, let alone predicting the whole climate a century from now."}, "before": {"id": 44, "title": "can't predict weather", "id_expl_id": 161, "title_expl_id": 332}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Science can’t predict the weather only a couple of weeks ahead, let alone predicting the whole climate a century from now."}
2025-06-15 23:27:11.653492+00	1118	18	1	45	updateRecord	argument	{"id": "45", "diff": {"after": {"title": "Climate models lack accuracy because they’re built without fully understanding crucial feedbacks like clouds and water vapour."}, "before": {"id": 45, "title": "clouds & vapour", "id_expl_id": 162, "title_expl_id": 333}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Climate models lack accuracy because they’re built without fully understanding crucial feedbacks like clouds and water vapour."}
2025-06-15 23:28:39.703242+00	1119	18	1	42	updateRecord	argument	{"id": "42", "diff": {"after": {"title": "Since climate models have accurately predicted warming since before 2007 and improved since, they are sufficient to assess fossil fuels’ role in global warming."}, "before": {"id": 42, "title": "correct predictions", "id_expl_id": 153, "title_expl_id": 331}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Since climate models have accurately predicted warming since before 2007 and improved since, they are sufficient to assess fossil fuels’ role in global warming."}
2025-07-15 05:48:37.55821+00	1290	18	1	12	updateRecord	moral_weight_of_profile	{"id": 12, "diff": {"after": {"weight": "2"}, "before": {"id": 12, "weight": 1, "id_expl_id": 1281, "weight_expl_id": 1285}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(2 / ΔRC%) rationality"}
2025-11-02 13:05:32.334597+00	1463	18	1	\N	insertRecord	forum_thread	\N
2025-10-30 17:08:32.82859+00	1462	5	1	27	join	person	{"person": {"id": 27, "name": "Demo User 3"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-11-06 22:47:43.62949+00	1528	28	1	194	insertRecord	argument_judgement	{"user": {"id": 28, "name": "Mobile User", "auth_role": "invited"}, "record": {"id": 194, "label": "Apples are high in calories. (70%)", "id_expl_id": 1528, "isolated_confidence": 0.7, "isolated_explanation": "", "isolated_confidence_expl_id": 1528, "isolated_explanation_expl_id": 1528}, "tableName": "argument_judgement", "targetLabel": "Apples are high in calories. (70%)"}
2025-06-16 00:33:07.512619+00	1120	18	1	117	updateExtRecord	argument	{"id": "117", "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"quote": "well and what he was referring to was just a clever way to compare these paleo climate temperature reconstructions that go back in a thousand years with the modern warming shown in the instrumental record because the Paleo climate data actually don't come up to the present because many of them many of these corals and tree rings were obtained back in you know the 1970s or the 1980s and so they don't come up to the present so if you want a complete depiction of what's happening you wouldn't stop at 1980 you would also show what we know happens since 1980 because we do have thermometer records since 1980 adding in the REO temperatures in each of the story series and so that's what he was doing finding a way to show both pieces of information together so that you got the whole picture this was"}, "before": {"id": 117, "quote": "well and what he was referring to was\\njust a clever way to compare these paleo\\nclimate temperature reconstructions that\\ngo back in a thousand years with the\\nmodern warming shown in the instrumental\\nrecord because the Paleo climate data\\nactually don't come up to the present\\nbecause many of them many of these\\ncorals and tree rings were obtained back\\nin you know the 1970s or the 1980s and\\nso they don't come up to the present so\\nif you want a complete depiction of\\nwhat's happening you wouldn't stop at\\n1980 you would also show\\nwhat we know happens since 1980 because\\nwe do have thermometer records since\\n1980 adding in the REO temperatures in\\neach of the story series and so that's\\nwhat he was doing finding a way to show\\nboth pieces of information together so\\nthat you got the whole picture this was", "id_expl_id": 867, "quote_expl_id": 867}}, "tableName": "argument", "targetLabel": "Mike's own explanation", "extTableName": "argument_authority"}
2025-07-15 05:49:43.99614+00	1291	18	1	11	updateRecord	moral_weight_of_profile	{"id": 11, "diff": {"after": {"weight": "1200"}, "before": {"id": 11, "weight": 120, "id_expl_id": 1280, "weight_expl_id": 1289}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_profile", "targetLabel": "(1200 / WbD) well-being"}
2025-10-18 22:43:06.304395+00	1417	5	1	150	insertCrossRecord	statement	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "cross": {"id": 17, "label": "examples", "tableName": "tag"}, "record": {"tag_id": 17, "statement_id": 150, "tag_id_expl_id": 1417, "statement_id_expl_id": 1417}, "target": {"id": 150, "label": "(27%) The Moon landing was fake.", "tableName": "statement"}}
2025-11-26 07:41:22.007451+00	1608	32	1	115	insertRecord	critical_statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 115, "id_expl_id": 1608, "argument_id": 83, "statement_id": 173, "argument_id_expl_id": 1608, "critical_question_id": 1, "statement_id_expl_id": 1608, "critical_question_id_expl_id": 1608}, "tableName": "critical_statement", "targetLabel": "(?) Apollo will be recognized as an epistemic authority"}
2025-11-02 13:15:47.568283+00	1464	18	1	1	insertRecord	forum_thread	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 1, "title": "How is the weather?", "id_expl_id": 1464, "title_expl_id": 1464}, "tableName": "forum_thread", "targetLabel": "How is the weather?"}
2025-11-06 23:10:23.589611+00	1530	5	1	\N	deleteByIds	forum_thread	{"ids": [1, 2], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "cleaning up test data", "tableName": "forum_thread", "targetLabel": "1, 2", "deletedRecords": {"forum_post": [{"id": 1, "text": "Bright and sunny :)", "owner_id": 18, "thread_id": 1, "user_name": "Durante", "id_expl_id": 1465, "text_expl_id": 1465, "owner_id_expl_id": 1465, "thread_id_expl_id": 1465}, {"id": 2, "text": "Blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves.", "owner_id": 24, "thread_id": 1, "user_name": "Demo User 1", "id_expl_id": 1466, "text_expl_id": 1466, "owner_id_expl_id": 1466, "thread_id_expl_id": 1466}, {"id": 3, "text": "Test post 1", "owner_id": 18, "thread_id": 2, "user_name": "Durante", "id_expl_id": 1520, "text_expl_id": 1520, "owner_id_expl_id": 1520, "thread_id_expl_id": 1520}, {"id": 4, "text": "Test post 2", "owner_id": 18, "thread_id": 2, "user_name": "Durante", "id_expl_id": 1521, "text_expl_id": 1521, "owner_id_expl_id": 1521, "thread_id_expl_id": 1521}], "forum_thread": [{"id": 1, "title": "How is the weather?", "id_expl_id": 1464, "title_expl_id": 1464}, {"id": 2, "title": "Test thread 2", "id_expl_id": 1519, "title_expl_id": 1519}]}}
2025-11-25 01:32:55.389871+00	1580	32	1	167	insertRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 167, "text": "consciousness is entirely emergent from physical interactions", "label": "(?) consciousness is entirely emergent from physical interactions", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1580, "text_expl_id": 1580, "decided_expl_id": 1580, "featured_expl_id": 1580, "chat_text_expl_id": 1580, "statement_type_id": 1, "confidence_expl_id": 1580, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1580}, "tableName": "statement", "targetLabel": "(?) consciousness is entirely emergent from physical interactions"}
2025-11-25 01:42:18.706533+00	1584	32	1	197	updateExtRecord	argument	{"id": "197", "user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"text": "The vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation, therefore consciousness likely also has a physical explanation."}, "before": {"id": 197, "text": "the vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation, therefore consciousness likely also has a physical explanation", "id_expl_id": 1582, "text_expl_id": 1583}}, "tableName": "argument", "targetLabel": "most things are physical, therefore consciousness is likely physical", "extTableName": "argument_statistical"}
2025-11-25 01:43:54.916819+00	1585	32	1	197	updateExtRecord	argument	{"id": "197", "user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "Making it a bit more technically correct, hopefully.", "extRecord": {"after": {"text": "The vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation, therefore consciousness is more likely to also have a physical explanation (than it would otherwise be)."}, "before": {"id": 197, "text": "The vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation, therefore consciousness likely also has a physical explanation.", "id_expl_id": 1582, "text_expl_id": 1584}}, "tableName": "argument", "targetLabel": "most things are physical, therefore consciousness is likely physical", "extTableName": "argument_statistical"}
2025-12-15 09:24:49.109526+00	1874	24	1	236	insertRecord	argument_contradiction	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited", "permission_level": 100}, "record": {"id": 236, "text": "Live Test Arg 1 Full Contradiction", "id_expl_id": 1874, "text_expl_id": 1874}, "tableName": "argument_contradiction", "targetLabel": "Live Test Arg 1 Full Contradiction"}
2025-06-16 00:36:00.238767+00	1121	18	1	117	updateRecord	argument	{"id": "117", "diff": {"after": {"title": "the author of \\"Mike's trick\\" confirms this"}, "before": {"id": 117, "title": "Mike's own explanation", "id_expl_id": 867, "title_expl_id": 867}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "the author of \\"Mike's trick\\" confirms this"}
2025-06-16 00:36:13.840464+00	1122	18	1	117	updateRecord	argument	{"id": "117", "diff": {"after": {"title": "The author of \\"Mike's trick\\" confirms this."}, "before": {"id": 117, "title": "the author of \\"Mike's trick\\" confirms this", "id_expl_id": 867, "title_expl_id": 1121}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The author of \\"Mike's trick\\" confirms this."}
2025-07-16 22:34:24.409061+00	1294	18	1	18	insertCrossRecord	person	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 5, "label": "everyone", "tableName": "person_category"}, "record": {"person_id": 18, "person_id_expl_id": 1294, "person_category_id": 5, "person_category_id_expl_id": 1294}, "target": {"id": 18, "label": "Durante", "tableName": "person"}}
2025-07-16 22:50:15.940123+00	1297	18	1	17	insertRecord	moral_weight_of_person	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 17, "label": "(10 / WbD) well-being", "weight": 10, "owner_id": 18, "id_expl_id": 1297, "moral_good_id": 8, "weight_expl_id": 1297, "owner_id_expl_id": 1297, "moral_good_id_expl_id": 1297}, "tableName": "moral_weight_of_person", "targetLabel": "(10 / WbD) well-being"}
2025-09-07 13:39:07.728557+00	1356	18	1	103	updateRecord	argument	{"id": "103", "diff": {"after": {"title": "Progressive left policies on gender reassignment put children in grave danger."}, "before": {"id": 103, "title": "castrating children", "id_expl_id": 770, "title_expl_id": 770}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Progressive left policies on gender reassignment put children in grave danger."}
2025-10-15 22:15:56.403998+00	1357	24	1	24	updateRecord	person	{"id": 24, "diff": {"after": {"language": "english"}, "before": {"id": 24, "language": "spanish", "id_expl_id": 1024, "language_expl_id": 1355}}, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "", "tableName": "person", "targetLabel": "Usuario de demostración 1"}
2025-10-26 20:27:41.802868+00	1418	18	1	30	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 30, "name": "UK politics", "id_expl_id": 1418, "description": "", "name_expl_id": 1418, "description_expl_id": 1418}, "tableName": "tag", "targetLabel": "UK politics"}
2025-11-25 01:32:55.432752+00	1581	32	1	167	insertCrossRecords	statement	{"id": 167, "user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 1580}, "fkEnries": {"tags": {"options": [{"id": 29, "label": "science"}, {"id": 42, "label": "philosophy"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?) consciousness is entirely emergent from physical interactions"}
2025-10-26 20:29:30.182602+00	1420	18	1	188	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 188, "pro": false, "title": "shut up looser", "chat_text": "", "id_expl_id": 1420, "pro_expl_id": 1420, "statement_id": 62, "title_expl_id": 1420, "argument_type_id": 3, "chat_text_expl_id": 1420, "statement_id_expl_id": 1420, "argument_type_id_expl_id": 1420}, "extRecord": {"id": 188, "text": "testing filter", "id_expl_id": 1420, "text_expl_id": 1420}, "tableName": "argument", "targetLabel": "shut up looser", "extTableName": "argument_other"}
2025-11-28 06:07:51.625057+00	1677	5	1	32	updateRecord	person	{"id": 32, "diff": {"after": {"permission_level": "1000"}, "before": {"id": 32, "id_expl_id": 1575, "permission_level": 100, "permission_level_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin", "permission_level": 100}, "userExpl": "Early adopter with lots of contributions", "tableName": "person", "targetLabel": "Ferb"}
2025-11-02 13:17:11.32578+00	1465	18	1	1	insertRecord	forum_post	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 1, "text": "Bright and sunny :)", "owner_id": 18, "thread_id": 1, "id_expl_id": 1465, "text_expl_id": 1465, "owner_id_expl_id": 1465, "thread_id_expl_id": 1465}, "tableName": "forum_post", "targetLabel": "Bright and sunny :)"}
2025-11-06 23:14:06.715002+00	1531	5	1	68	deleteById	statement	{"id": "68", "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) US citizens should support lifting restrictions on US fossil fuel energy production", "deletedRecords": {"argument": [{"id": 89, "pro": true, "title": "affordability of goods", "chat_text": "", "id_expl_id": 610, "pro_expl_id": 610, "statement_id": 68, "title_expl_id": 610, "argument_type_id": 4, "chat_text_expl_id": null, "statement_id_expl_id": 610, "argument_type_id_expl_id": 610}, {"id": 90, "pro": true, "title": "cut Russia's income", "chat_text": "", "id_expl_id": 611, "pro_expl_id": 611, "statement_id": 68, "title_expl_id": 611, "argument_type_id": 4, "chat_text_expl_id": null, "statement_id_expl_id": 611, "argument_type_id_expl_id": 611}, {"id": 91, "pro": false, "title": "future crop yields", "chat_text": "", "id_expl_id": 612, "pro_expl_id": 612, "statement_id": 68, "title_expl_id": 612, "argument_type_id": 4, "chat_text_expl_id": null, "statement_id_expl_id": 612, "argument_type_id_expl_id": 612}, {"id": 104, "pro": true, "title": "greening of the Earth", "chat_text": "", "id_expl_id": 771, "pro_expl_id": 771, "statement_id": 68, "title_expl_id": 771, "argument_type_id": 4, "chat_text_expl_id": null, "statement_id_expl_id": 771, "argument_type_id_expl_id": 771}], "directive": [{"id": 68, "label": "(?) US citizens should support lifting restrictions on US fossil fuel energy production", "deed_id": 2, "id_expl_id": 496, "deed_id_expl_id": 496}], "statement": [{"id": 68, "text": "", "label": "(?) US citizens should support lifting restrictions on US fossil fuel energy production", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": null, "text_expl_id": null, "decided_expl_id": null, "featured_expl_id": null, "chat_text_expl_id": null, "statement_type_id": 3, "confidence_expl_id": null, "statement_type_name": "prescriptive", "statement_type_id_expl_id": null}], "research_note": [{"id": 2, "text": "ChatGPT Prompt\\n\\nPlease build a causal influence chain from lifting restrictions on USA energy production to changes in life satisfaction of US residents. Suggest how each link in this causal change can be quantified to create an overall estimate of the effect of the whole chain.\\n\\nChatGPT answer\\n\\nTo estimate the cumulative effect, we need to quantify each link and then trace the impact through the chain.\\n\\n**Step 1-2: Increase in Energy Production**\\n\\n**Estimate the percentage increase in energy production.**\\n\\n**Example:** A 10% increase in oil and natural gas production.\\n\\n**Step 3-4: Effect on Energy Prices**\\n\\n**Calculate the expected decrease in energy prices using price elasticity.**\\n\\n**Example:**\\n\\n- Price elasticity of demand (Ed): -0.2\\n- Price elasticity of supply (Es): 0.3\\n- **Formula:**\\n    - Percentage change in price = Percentage change in quantity supplied / (Es - Ed)\\n    - Plug in numbers: (10%) / (0.3 - (-0.2)) = 10% / 0.5 = 20% decrease in price.\\n\\n**Step 5: Reduction in Energy Costs**\\n\\n**Calculate savings for households and businesses.**\\n\\n**Households:**\\n\\n- Average annual energy expenditure per household: $2,000\\n- Savings per household: 20% of $2,000 = $400\\n- Total households: 120 million\\n- Total household savings: $400 * 120 million = $48 billion\\n\\n**Businesses:**\\n\\n- Aggregate energy expenditures and calculate 20% savings.\\n\\n**Step 6: Increase in Disposable Income**\\n\\n**Total increase in disposable income:**\\n\\n- From households: $48 billion\\n- From businesses (assuming part of savings translates to higher wages or lower prices).\\n\\n**Step 7: Increase in Consumption and Savings**\\n\\n**Assuming MPC is 0.9:**\\n\\n- Additional consumption: $48 billion * 0.9 = $43.2 billion\\n- Additional savings: $48 billion * 0.1 = $4.8 billion\\n\\n**Step 8: Impact on GDP and Employment**\\n\\n**GDP Impact:**\\n\\n- Apply fiscal multiplier (e.g., 1.5): $43.2 billion * 1.5 = $64.8 billion increase in GDP\\n\\n**Job Creation:**\\n\\n- Use employment multiplier (e.g., 10,000 jobs per $1 billion GDP growth): 10,000 * 64.8 = 648,000 jobs\\n\\n**Step 9: Improved Material Living Standards**\\n\\n**Increase in average income:**\\n\\n- Distribute GDP increase across the population.\\n\\n**Reduction in unemployment rate:**\\n\\n- Calculate the percentage decrease based on new jobs created.\\n\\n**Step 10: Changes in Life Satisfaction**\\n\\n**Use coefficient from literature:**\\n\\n- **Easterlin Paradox:** Life satisfaction increases with income but at a diminishing rate.\\n- **Example Coefficient:** A 10% increase in income leads to a 0.1 point increase on a 10-point life satisfaction scale.\\n\\n**Calculate expected change:**\\n\\n- Average income increase: Assume 5% increase.\\n- Expected life satisfaction increase: 5% * 0.01 = 0.05 points on a 10-point scale.\\n\\n- Expected life satisfaction increase: 5% * 0.01 = 0.05 points on a 10-point scale.\\n\\nAdds final calculations\\n\\nExpected change on the Satisfaction With Life Scale summed up for all of the people affected. =\\n\\n= scale conversion * USA population * satisfaction increase\\n\\n= 35 / 10 * 345,426,571 * 0.05\\n\\n= 60449650", "title": "Trying to calculate the impact of lifting restrictions on life satisfaction with ChatGPT", "id_expl_id": 618, "statement_id": 68, "text_expl_id": 618, "title_expl_id": 618, "statement_id_expl_id": 618}], "directive_scope": [{"id": 4, "label": "(+) US citizens", "include": true, "id_expl_id": 500, "directive_id": 68, "include_expl_id": 500, "person_category_id": 3, "directive_id_expl_id": 500, "person_category_id_expl_id": 500}], "argument_explanation": [{"id": 89, "text": "Lifting restrictions would lower the prices gasoline, electricity, and heating.\\nThis reduction in energy costs would translate to lower costs for goods and services across the economy.\\nHence, US residents will be able to afford more.\\nHence, the standard of living of US residents will increase.", "id_expl_id": 610, "text_expl_id": 610}, {"id": 90, "text": "Lifting restrictions would allow US to supply more LNG to Europe.\\nThis will:\\n- reduce revenue that Russia will receive from its sale of natural gas and,\\n- reduce the influence that Russia has on Europe.\\nHence Russia’s ability to wage war against Ukraine will reduce.\\nHence people will be suffering less from war.", "id_expl_id": 611, "text_expl_id": 611}, {"id": 91, "text": "Lifting restrictions would increase fossil fuel extraction, production and consumption.\\nThis would lead to higher greenhouse gas emissions.\\nThis will speed up climate change.\\nIncrease in global average temperatures will cause net reduction in crop yields\\n1. Reduced crop yields will cause starvation\\n2. Reduced crop yields will cause mass migration\\nThis in turn will cause violent conflicts\\nThis in turn will cause an increase in suffering and deaths", "id_expl_id": 612, "text_expl_id": 612}, {"id": 104, "text": "Lifting restrictions would increase fossil fuel extraction, production and consumption.\\nThis would lead to higher greenhouse gas emissions.\\nThis will make more CO2 available for the growth of the plants.\\nBigger areas of the Earth will have more and bigger plants.\\nThis will support more animal and human habitats. ", "id_expl_id": 771, "text_expl_id": 771}]}}
2025-11-06 23:15:14.424039+00	1533	5	1	146	deleteCrossRecord	statement	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "cross": {"id": 19, "label": "health", "tableName": "tag"}, "record": {"tag_id": 19, "statement_id": 146, "tag_id_expl_id": 1302, "statement_id_expl_id": 1302}, "target": {"id": 146, "label": "(52%) SARS-CoV-2 originated from a lab leak in Wuhan", "tableName": "statement"}, "userExpl": ""}
2025-11-06 23:16:06.227876+00	1536	5	1	87	deleteById	statement	{"id": "87", "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) US citizens should support removal of Donald J. Trump from office", "deletedRecords": {"argument": [{"id": 101, "pro": true, "title": "threat to democracy", "chat_text": "", "id_expl_id": 760, "pro_expl_id": 760, "statement_id": 87, "title_expl_id": 760, "argument_type_id": 10, "chat_text_expl_id": null, "statement_id_expl_id": 760, "argument_type_id_expl_id": 760}], "directive": [{"id": 87, "label": "(?) US citizens should support removal of Donald J. Trump from office", "deed_id": 6, "id_expl_id": 757, "deed_id_expl_id": 757}], "statement": [{"id": 87, "text": "", "label": "(?) US citizens should support removal of Donald J. Trump from office", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 757, "text_expl_id": 757, "decided_expl_id": 757, "featured_expl_id": 757, "chat_text_expl_id": null, "statement_type_id": 3, "confidence_expl_id": 757, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 757}], "directive_scope": [{"id": 8, "label": "(+) US citizens", "include": true, "id_expl_id": 759, "directive_id": 87, "include_expl_id": 759, "person_category_id": 3, "directive_id_expl_id": 759, "person_category_id_expl_id": 759}], "argument_pragmatic": [{"id": 101, "text": "- Trump undermined democratic institutions: He challenged the legitimacy of elections without credible evidence, pressured officials to overturn lawful results, and eroded public trust in democratic processes.\\n- He encourages political violence: His words and actions surrounding the January 6th Capitol attack incited unrest, showing a willingness to endanger peaceful power transitions to retain control.\\n- He disregards checks and balances: Trump repeatedly attacked the independence of the judiciary, the Department of Justice, and the free press—core institutions meant to limit executive power.\\n- He has not ruled out a third term: By refusing to commit to the two-term limit enshrined in the Constitution, he signals a dangerous openness to authoritarian rule.\\n- Democracy is a tool, not a sacred ideal: It serves essential values like freedom, stability, justice, and accountability. When a leader repeatedly undermines that system, the deeper values democracy protects are put at risk—removal becomes not just justified, but necessary.", "id_expl_id": 760, "text_expl_id": 760}]}}
2025-06-17 22:46:24.67044+00	1123	18	1	41	updateRecord	argument	{"id": "41", "diff": {"after": {"title": "Natural warming in the current interglacial has stayed under 1 °C, with higher temperatures evident only at the peak of the previous interglacial about 125 000 years ago."}, "before": {"id": 41, "title": "prof. of earth and env. sci.", "id_expl_id": 149, "title_expl_id": 811}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Natural warming in the current interglacial has stayed under 1 °C, with higher temperatures evident only at the peak of the previous interglacial about 125 000 years ago."}
2025-06-18 00:38:47.139045+00	1124	18	1	80	updateRecord	argument	{"id": "80", "diff": {"after": {"title": "Seasonal patterns remain steady year after year, but week-to-week weather swings wildly."}, "before": {"id": 80, "title": "stable seasons", "id_expl_id": 452, "title_expl_id": 452}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Seasonal patterns remain steady year after year, but week-to-week weather swings wildly."}
2025-06-18 00:39:33.303809+00	1125	18	1	49	updateRecord	argument	{"id": "49", "diff": {"after": {"title": "The main weather authority in the UK confirms this."}, "before": {"id": 49, "title": "Met Office UK says so", "id_expl_id": 173, "title_expl_id": 173}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The main weather authority in the UK confirms this."}
2025-07-16 22:34:49.384104+00	1295	18	1	1	deleteById	person_category	{"id": 1, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "person_category", "targetLabel": "block of flats residents", "deletedRecords": {"person_category": [{"id": 1, "name": "block of flats residents", "id_expl_id": null, "name_expl_id": 535}]}}
2025-11-27 02:40:19.957717+00	1640	32	1	119	insertRecord	critical_statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 119, "id_expl_id": 1640, "argument_id": 207, "statement_id": 177, "argument_id_expl_id": 1640, "critical_question_id": 1, "statement_id_expl_id": 1640, "critical_question_id_expl_id": 1640}, "tableName": "critical_statement", "targetLabel": "(?) an internalized sense of role-duty is (in this case) a kind of set of positive association(s) with following role-duty"}
2025-10-16 00:41:48.083154+00	1358	24	1	135	insertRecord	issue	{"user": {"id": 24, "name": "Usuario de demostración 1", "auth_role": "invited"}, "record": {"id": 135, "title": "Add \\"statistical syllogism\\" argument type.", "id_expl_id": 1358, "description": "A statistical syllogism is a type of inductive argument that moves from a statistical generalization about a group to a conclusion about an individual member of that group. It has the structure: \\"Most A's are B's, X is an A, therefore X is likely a B\\". \\nhttps://en.wikipedia.org/wiki/Statistical_syllogism", "title_expl_id": 1358, "description_expl_id": 1358}, "tableName": "issue", "targetLabel": "Add \\"statistical syllogism\\" argument type."}
2025-10-16 01:01:18.581608+00	1360	24	1	148	insertRecord	statement	{"user": {"id": 24, "name": "Usuario de demostración 1", "auth_role": "invited"}, "record": {"id": 148, "text": "The Moon landing was fake.", "label": "(?) The Moon landing was fake.", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1360, "text_expl_id": 1360, "decided_expl_id": 1360, "featured_expl_id": 1360, "chat_text_expl_id": 1360, "statement_type_id": 1, "confidence_expl_id": 1360, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1360}, "tableName": "statement", "targetLabel": "(?) The Moon landing was fake."}
2025-10-26 20:28:18.228222+00	1419	18	1	30	deleteById	tag	{"id": 30, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "this was a test", "tableName": "tag", "targetLabel": "UK politics", "deletedRecords": {"tag": [{"id": 30, "name": "UK politics", "id_expl_id": 1418, "description": "", "name_expl_id": 1418, "description_expl_id": 1418}]}}
2025-11-02 13:20:03.990334+00	1466	24	1	2	insertRecord	forum_post	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 2, "text": "Blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves.", "owner_id": 24, "thread_id": 1, "id_expl_id": 1466, "text_expl_id": 1466, "owner_id_expl_id": 1466, "thread_id_expl_id": 1466}, "tableName": "forum_post", "targetLabel": "Blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves, blue sky, yellow leaves."}
2025-11-06 23:14:42.952978+00	1532	5	1	71	deleteById	statement	{"id": "71", "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) everyone should support making vaccines optional ", "deletedRecords": {"argument": [{"id": 96, "pro": true, "title": "harm of vaccines", "chat_text": "", "id_expl_id": 694, "pro_expl_id": 694, "statement_id": 71, "title_expl_id": 990, "argument_type_id": 10, "chat_text_expl_id": null, "statement_id_expl_id": 694, "argument_type_id_expl_id": 694}, {"id": 133, "pro": false, "title": "Vaccines save lives", "chat_text": "", "id_expl_id": 991, "pro_expl_id": 991, "statement_id": 71, "title_expl_id": 991, "argument_type_id": 10, "chat_text_expl_id": null, "statement_id_expl_id": 991, "argument_type_id_expl_id": 991}], "directive": [{"id": 71, "label": "(?) everyone should support making vaccines optional ", "deed_id": 5, "id_expl_id": 689, "deed_id_expl_id": 689}], "statement": [{"id": 71, "text": "", "label": "(?) everyone should support making vaccines optional ", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 689, "text_expl_id": 689, "decided_expl_id": 689, "featured_expl_id": 689, "chat_text_expl_id": null, "statement_type_id": 3, "confidence_expl_id": 689, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 689}], "directive_scope": [{"id": 7, "label": "(+) everyone", "include": true, "id_expl_id": 691, "directive_id": 71, "include_expl_id": 691, "person_category_id": 5, "directive_id_expl_id": 691, "person_category_id_expl_id": 691}], "argument_pragmatic": [{"id": 96, "text": "vaccines cause severe medical conditions and even death", "id_expl_id": 694, "text_expl_id": 694}, {"id": 133, "text": "Vaccines reduce infections and even completely defeat some diseases.", "id_expl_id": 991, "text_expl_id": 991}], "critical_statement": [{"id": 53, "id_expl_id": 696, "argument_id": 96, "statement_id": 72, "argument_id_expl_id": 696, "critical_question_id": 1, "statement_id_expl_id": 696, "critical_question_id_expl_id": 696}, {"id": 91, "id_expl_id": 993, "argument_id": 133, "statement_id": 128, "argument_id_expl_id": 993, "critical_question_id": 1, "statement_id_expl_id": 993, "critical_question_id_expl_id": 993}]}}
2025-11-06 23:17:25.382553+00	1540	5	1	114	deleteById	statement	{"id": "114", "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) everyone should eat animals if they want to", "deletedRecords": {"argument": [{"id": 126, "pro": true, "title": "There's no morality in animals", "chat_text": "", "id_expl_id": 930, "pro_expl_id": 930, "statement_id": 114, "title_expl_id": 930, "argument_type_id": 6, "chat_text_expl_id": null, "statement_id_expl_id": 930, "argument_type_id_expl_id": 930}], "directive": [{"id": 114, "label": "(?) everyone should eat animals if they want to", "deed_id": 9, "id_expl_id": 927, "deed_id_expl_id": 927}], "statement": [{"id": 114, "text": "", "label": "(?) everyone should eat animals if they want to", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 927, "text_expl_id": 927, "decided_expl_id": 927, "featured_expl_id": 927, "chat_text_expl_id": null, "statement_type_id": 3, "confidence_expl_id": 927, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 927}], "directive_scope": [{"id": 11, "label": "(+) everyone", "include": true, "id_expl_id": 929, "directive_id": 114, "include_expl_id": 929, "person_category_id": 5, "directive_id_expl_id": 929, "person_category_id_expl_id": 929}], "argument_deduction": [{"id": 126, "text": "Animals are acceptable to eat because they lack reason and moral consciousness and are below humans in the hierarchy.", "id_expl_id": 930, "text_expl_id": 931}], "critical_statement": [{"id": 80, "id_expl_id": 940, "argument_id": 126, "statement_id": 117, "argument_id_expl_id": 940, "critical_question_id": 6, "statement_id_expl_id": 940, "critical_question_id_expl_id": 940}, {"id": 85, "id_expl_id": 961, "argument_id": 126, "statement_id": 123, "argument_id_expl_id": 961, "critical_question_id": 6, "statement_id_expl_id": 961, "critical_question_id_expl_id": 961}, {"id": 86, "id_expl_id": 967, "argument_id": 126, "statement_id": 115, "argument_id_expl_id": 967, "critical_question_id": 6, "statement_id_expl_id": 967, "critical_question_id_expl_id": 967}, {"id": 87, "id_expl_id": 968, "argument_id": 126, "statement_id": 116, "argument_id_expl_id": 968, "critical_question_id": 1, "statement_id_expl_id": 968, "critical_question_id_expl_id": 968}], "statement_discussion_message": [{"id": 4, "text": "hi", "owner_id": 22, "user_name": "Puma", "statement_id": 114}]}}
2025-06-19 13:07:33.730136+00	1126	18	1	81	updateRecord	argument	{"id": "81", "diff": {"after": {"title": "World Meteorological Organization is a specialised agency of the United Nations with members from 193 member states and territories."}, "before": {"id": 81, "title": "World Met Org", "id_expl_id": 455, "title_expl_id": 455}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "World Meteorological Organization is a specialised agency of the United Nations with members from 193 member states and territories."}
2025-11-26 20:41:17.24522+00	1625	32	1	3	updateRecord	research_note	{"id": 3, "diff": {"after": {"text": "Psychological hedonism is the proposition that we (at least including all humans and ambiguous whether it includes anything else) are ultimately (when considering all subconscious and conscious motivations) entirely motivated by the pursuit of pleasant feelings minus unpleasant feelings.\\n\\ni.e. All our motivation comes from pleasure minus pain in one way or another."}, "before": {"id": 3, "text": "Psychological hedonism is the proposition that we (at least including all humans and ambiguous whether it includes anything else) are ultimately entirely motivated by the pursuit of pleasant feelings minus unpleasant feelings.", "id_expl_id": 1616, "text_expl_id": 1616}}, "user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "userExpl": "To clarify the definition.", "tableName": "research_note", "targetLabel": "Definition of psychological hedonism"}
2025-07-16 22:50:07.754726+00	1296	18	1	16	insertRecord	moral_weight_of_person	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 16, "label": "(10 / ΔRC%) rationality", "weight": 10, "owner_id": 18, "id_expl_id": 1296, "moral_good_id": 9, "weight_expl_id": 1296, "owner_id_expl_id": 1296, "moral_good_id_expl_id": 1296}, "tableName": "moral_weight_of_person", "targetLabel": "(10 / ΔRC%) rationality"}
2025-10-16 01:00:58.705117+00	1359	24	1	28	insertRecord	tag	{"user": {"id": 24, "name": "Usuario de demostración 1", "auth_role": "invited"}, "record": {"id": 28, "name": "science", "id_expl_id": 1359, "description": "", "name_expl_id": 1359, "description_expl_id": 1359}, "tableName": "tag", "targetLabel": "science"}
2025-10-26 20:30:03.100614+00	1421	18	1	188	deleteById	argument	{"id": "188", "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "this was a test", "tableName": "argument", "targetLabel": "shut up looser", "deletedRecords": {"argument": [{"id": 188, "pro": false, "title": "shut up looser", "chat_text": "", "id_expl_id": 1420, "pro_expl_id": 1420, "statement_id": 62, "title_expl_id": 1420, "argument_type_id": 3, "chat_text_expl_id": 1420, "statement_id_expl_id": 1420, "argument_type_id_expl_id": 1420}], "argument_other": [{"id": 188, "text": "testing filter", "id_expl_id": 1420, "text_expl_id": 1420}]}}
2025-11-02 23:12:36.433252+00	1467	5	1	9	updateExtRecord	issue	{"id": 9, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 9, "id_expl_id": 1089, "project_stage": "closed β rel.", "project_stage_expl_id": 1089}}, "tableName": "issue", "targetLabel": "Feature: define and disambiguate terms", "extTableName": "task"}
2025-11-02 23:22:45.206744+00	1470	5	1	14	updateExtRecord	issue	{"id": 14, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {"title": "Set up automatic daily backups of the database"}, "before": {"id": 14, "title": "Set up daily backups of the database", "id_expl_id": null, "title_expl_id": null}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 14, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "Set up automatic daily backups of the database", "extTableName": "task"}
2025-11-06 23:15:21.0202+00	1534	5	1	146	insertCrossRecord	statement	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "cross": {"id": 29, "label": "science", "tableName": "tag"}, "record": {"tag_id": 29, "statement_id": 146, "tag_id_expl_id": 1534, "statement_id_expl_id": 1534}, "target": {"id": 146, "label": "(52%) SARS-CoV-2 originated from a lab leak in Wuhan", "tableName": "statement"}}
2025-11-06 23:17:02.20106+00	1539	5	1	\N	deleteByIds	tag	{"ids": [26], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "tag", "targetLabel": "26", "deletedRecords": {"tag": [{"id": 26, "name": "US politics", "id_expl_id": 756, "description": "", "name_expl_id": 756, "description_expl_id": 756}]}}
2025-11-25 01:40:03.69252+00	1582	32	1	197	insertExtRecord	argument	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 197, "pro": true, "title": "most things are physical, therefore consciousness is likely physical", "chat_text": "", "id_expl_id": 1582, "pro_expl_id": 1582, "statement_id": 167, "title_expl_id": 1582, "argument_type_id": 17, "chat_text_expl_id": 1582, "statement_id_expl_id": 1582, "argument_type_id_expl_id": 1582}, "extRecord": {"id": 197, "text": "the vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation", "id_expl_id": 1582, "text_expl_id": 1582}, "tableName": "argument", "targetLabel": "most things are physical, therefore consciousness is likely physical", "extTableName": "argument_statistical"}
2025-11-26 07:43:05.060452+00	1609	32	1	202	insertExtRecord	argument	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 202, "pro": false, "title": "it will not take off", "chat_text": "", "id_expl_id": 1609, "pro_expl_id": 1609, "statement_id": 173, "title_expl_id": 1609, "argument_type_id": 3, "chat_text_expl_id": 1609, "statement_id_expl_id": 1609, "argument_type_id_expl_id": 1609}, "extRecord": {"id": 202, "text": "it will not take off", "id_expl_id": 1609, "text_expl_id": 1609}, "tableName": "argument", "targetLabel": "it will not take off", "extTableName": "argument_other"}
2025-11-26 07:55:02.403228+00	1616	32	1	3	insertRecord	research_note	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 3, "text": "Psychological hedonism is the proposition that we (at least including all humans and ambiguous whether it includes anything else) are ultimately entirely motivated by the pursuit of pleasant feelings minus unpleasant feelings.", "title": "Definition", "id_expl_id": 1616, "statement_id": 174, "text_expl_id": 1616, "title_expl_id": 1616, "statement_id_expl_id": 1616}, "tableName": "research_note", "targetLabel": "Definition"}
2025-06-19 13:11:36.665156+00	1127	18	1	50	updateRecord	argument	{"id": "50", "diff": {"after": {"title": "There are several notable examples of models that were built without a complete understanding of the underlying mechanisms but were still accurate enough to be highly useful: early weather forecasting models, penicillin, steam engines, Keynesian economic models, Mendelian genetics"}, "before": {"id": 50, "title": "Examples of such models", "id_expl_id": 183, "title_expl_id": 183}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "There are several notable examples of models that were built without a complete understanding of the underlying mechanisms but were still accurate enough to be highly useful: early weather forecasting models, penicillin, steam engines, Keynesian economic models, Mendelian genetics"}
2025-06-19 17:13:57.068524+00	1128	18	1	110	updateRecord	argument	{"id": "110", "diff": {"after": {"title": "The insight that penicillin interferes with the formation of the cell wall was published in June 1944 after it was already used extensively during the North Africa campaign in 1943."}, "before": {"id": 110, "title": "1944 mechanism discovery", "id_expl_id": 828, "title_expl_id": 835}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The insight that penicillin interferes with the formation of the cell wall was published in June 1944 after it was already used extensively during the North Africa campaign in 1943."}
2025-07-16 22:51:10.779072+00	1298	18	1	17	updateRecord	moral_weight_of_person	{"id": 17, "diff": {"after": {"weight": "100"}, "before": {"id": 17, "weight": 10, "id_expl_id": 1297, "weight_expl_id": 1297}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "moral_weight_of_person", "targetLabel": "(100 / WbD) well-being"}
2025-10-16 01:01:18.635303+00	1361	24	1	148	insertCrossRecords	statement	{"id": 148, "user": {"id": 24, "name": "Usuario de demostración 1", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 1360}, "fkEnries": {"tags": {"options": [{"id": 28, "label": "science"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?) The Moon landing was fake."}
2025-11-26 07:49:42.286452+00	1611	32	1	174	insertRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 174, "text": "psychological hedonism is true", "label": "(?) psychological hedonism is true", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1611, "text_expl_id": 1611, "decided_expl_id": 1611, "featured_expl_id": 1611, "chat_text_expl_id": 1611, "statement_type_id": 1, "confidence_expl_id": 1611, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1611}, "tableName": "statement", "targetLabel": "(?) psychological hedonism is true"}
2025-10-26 20:39:27.382801+00	1422	18	1	189	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 189, "pro": false, "title": "it will not take off", "chat_text": "", "id_expl_id": 1422, "pro_expl_id": 1422, "statement_id": 62, "title_expl_id": 1422, "argument_type_id": 3, "chat_text_expl_id": 1422, "statement_id_expl_id": 1422, "argument_type_id_expl_id": 1422}, "extRecord": {"id": 189, "text": "it will not take off", "id_expl_id": 1422, "text_expl_id": 1422}, "tableName": "argument", "targetLabel": "it will not take off", "extTableName": "argument_other"}
2025-11-02 23:13:10.44747+00	1468	5	1	11	updateExtRecord	issue	{"id": 11, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 11, "status": "backlog", "id_expl_id": null, "status_expl_id": null}}, "tableName": "issue", "targetLabel": "Protect sensitive data in users table", "extTableName": "task"}
2025-11-02 23:25:46.319822+00	1473	5	1	16	updateExtRecord	issue	{"id": 16, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 16, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "launch dev copy of the server with separate db", "extTableName": "task"}
2025-11-06 23:15:43.374616+00	1535	5	1	\N	deleteByIds	tag	{"ids": [19], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "tag", "targetLabel": "19", "deletedRecords": {"tag": [{"id": 19, "name": "health", "id_expl_id": 692, "description": " ", "name_expl_id": 692, "description_expl_id": 692}]}}
2025-11-06 23:18:18.156569+00	1542	5	1	28	deleteCrossRecord	statement	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "cross": {"id": 14, "label": "climate", "tableName": "tag"}, "record": {"tag_id": 14, "statement_id": 28, "tag_id_expl_id": 501, "statement_id_expl_id": 501}, "target": {"id": 28, "label": "(?) climate change is anthropogenic", "tableName": "statement"}, "userExpl": ""}
2025-11-06 23:18:51.16477+00	1544	5	1	\N	deleteByIds	tag	{"ids": [14], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "tag", "targetLabel": "14", "deletedRecords": {"tag": [{"id": 14, "name": "climate", "id_expl_id": 497, "description": "", "name_expl_id": 520, "description_expl_id": null}]}}
2025-11-25 01:40:50.591917+00	1583	32	1	197	updateExtRecord	argument	{"id": "197", "user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "To better match the statistical argument type's ideal structure.", "extRecord": {"after": {"text": "the vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation, therefore consciousness likely also has a physical explanation"}, "before": {"id": 197, "text": "the vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation", "id_expl_id": 1582, "text_expl_id": 1582}}, "tableName": "argument", "targetLabel": "most things are physical, therefore consciousness is likely physical", "extTableName": "argument_statistical"}
2025-06-19 17:14:44.46629+00	1129	18	1	111	updateRecord	argument	{"id": "111", "diff": {"after": {"title": "Wikipedia confirms this."}, "before": {"id": 111, "title": "from Wikipedia", "id_expl_id": 831, "title_expl_id": 831}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Wikipedia confirms this."}
2025-07-16 23:21:39.388973+00	1299	18	1	47	insertCrossRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 17, "label": "example", "tableName": "tag"}, "record": {"tag_id": 17, "statement_id": 47, "tag_id_expl_id": 1299, "statement_id_expl_id": 1299}, "target": {"id": 47, "label": "(6%) A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts anthropogenic climate change.", "tableName": "statement"}}
2025-10-16 01:07:00.970107+00	1362	24	1	176	insertExtRecord	argument	{"user": {"id": 24, "name": "Usuario de demostración 1", "auth_role": "invited"}, "record": {"id": 176, "pro": false, "title": "Conspiracy theories are almost never true.", "chat_text": "", "id_expl_id": 1362, "pro_expl_id": 1362, "statement_id": 148, "title_expl_id": 1362, "argument_type_id": 3, "chat_text_expl_id": 1362, "statement_id_expl_id": 1362, "argument_type_id_expl_id": 1362}, "extRecord": {"id": 176, "text": "This is a conspiracy theory. Conspiracy theories very rarely turn out to be true. So most likely this one is not true either.", "id_expl_id": 1362, "text_expl_id": 1362}, "tableName": "argument", "targetLabel": "Conspiracy theories are almost never true.", "extTableName": "argument_other"}
2025-10-26 21:24:24.547666+00	1423	18	1	31	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 31, "name": "poop", "id_expl_id": 1423, "description": "", "name_expl_id": 1423, "description_expl_id": 1423}, "tableName": "tag", "targetLabel": "poop"}
2025-10-26 21:40:40.536792+00	1429	18	1	83	updateRecord	argument	{"id": "83", "diff": {"after": {"title": "Conflicts will be resolved by deferring to Apollo's wise judgement"}, "before": {"id": 83, "title": "Conflicts will be resolved by deferring to Apollo's wise ass judgement", "id_expl_id": 507, "title_expl_id": 1428}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Conflicts will be resolved by deferring to Apollo's wise judgement"}
2025-10-26 22:01:46.035469+00	1431	18	1	33	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 33, "name": "religion", "id_expl_id": 1431, "description": "", "name_expl_id": 1431, "description_expl_id": 1431}, "tableName": "tag", "targetLabel": "religion"}
2025-11-02 23:13:27.810158+00	1469	5	1	12	updateExtRecord	issue	{"id": 12, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 12, "status": "backlog", "id_expl_id": null, "status_expl_id": null}}, "tableName": "issue", "targetLabel": "do not let sensitive data leak into the expl table", "extTableName": "task"}
2025-11-06 23:16:12.918394+00	1537	5	1	88	deleteById	statement	{"id": "88", "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) US citizens should support election of someone like Donald J. Trump as the US president again", "deletedRecords": {"argument": [{"id": 102, "pro": false, "title": "populism", "chat_text": "", "id_expl_id": 765, "pro_expl_id": 765, "statement_id": 88, "title_expl_id": 765, "argument_type_id": 4, "chat_text_expl_id": null, "statement_id_expl_id": 765, "argument_type_id_expl_id": 765}], "directive": [{"id": 88, "label": "(?) US citizens should support election of someone like Donald J. Trump as the US president again", "deed_id": 7, "id_expl_id": 762, "deed_id_expl_id": 762}], "statement": [{"id": 88, "text": "", "label": "(?) US citizens should support election of someone like Donald J. Trump as the US president again", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 762, "text_expl_id": 762, "decided_expl_id": 762, "featured_expl_id": 762, "chat_text_expl_id": null, "statement_type_id": 3, "confidence_expl_id": 762, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 762}], "directive_scope": [{"id": 9, "label": "(+) US citizens", "include": true, "id_expl_id": 764, "directive_id": 88, "include_expl_id": 764, "person_category_id": 3, "directive_id_expl_id": 764, "person_category_id_expl_id": 764}], "argument_explanation": [{"id": 102, "text": "Donald J. Trump is a populist.\\n- Populists promise simple solutions to complex problems: They often reduce nuanced issues (like inequality, immigration, inflation) to slogans or blame games, which rarely lead to sustainable outcomes.\\n- They undermine expert institutions: Populists tend to dismiss experts, economists, and bureaucrats as part of a \\"corrupt elite,\\" weakening the very institutions needed for effective policymaking.\\n- Quick fixes often backfire: Policies designed for short-term popularity (e.g. reckless spending, protectionism, deregulation) can create long-term harm—like inflation, debt, or international isolation.\\n- Existing solutions, while imperfect, are often more effective: Many current systems (e.g. healthcare, taxation, legal frameworks) exist because they’ve evolved to balance trade-offs—not because they’re popular or simple.\\n- Populism leads to polarization and instability: Framing politics as a battle between \\"the people\\" and \\"the elite\\" erodes trust, increases division, and weakens national unity.\\n- The cost is human: When complex realities are ignored in favour of emotional appeals, it’s the basic values—security, fairness, opportunity, and dignity—that suffer most.", "id_expl_id": 765, "text_expl_id": 765}]}}
2025-11-06 23:16:18.53133+00	1538	5	1	89	deleteById	statement	{"id": "89", "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) US citizens should support election of progressive left politicians in the US", "deletedRecords": {"argument": [{"id": 103, "pro": false, "title": "Progressive left policies on gender reassignment put children in grave danger.", "chat_text": "", "id_expl_id": 770, "pro_expl_id": 770, "statement_id": 89, "title_expl_id": 1356, "argument_type_id": 10, "chat_text_expl_id": null, "statement_id_expl_id": 770, "argument_type_id_expl_id": 770}], "directive": [{"id": 89, "label": "(?) US citizens should support election of progressive left politicians in the US", "deed_id": 8, "id_expl_id": 767, "deed_id_expl_id": 767}], "statement": [{"id": 89, "text": "", "label": "(?) US citizens should support election of progressive left politicians in the US", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 767, "text_expl_id": 767, "decided_expl_id": 767, "featured_expl_id": 767, "chat_text_expl_id": null, "statement_type_id": 3, "confidence_expl_id": 767, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 767}], "directive_scope": [{"id": 10, "label": "(+) US citizens", "include": true, "id_expl_id": 769, "directive_id": 89, "include_expl_id": 769, "person_category_id": 3, "directive_id_expl_id": 769, "person_category_id_expl_id": 769}], "argument_pragmatic": [{"id": 103, "text": "Progressive left policies on gender reassignment put children in grave danger.\\n- Irreversible medical interventions: Hormone treatments and surgeries can cause permanent changes such as infertility, and some children may later regret these decisions.\\n- Undermining parental rights: Policies that limit parents' involvement in gender-related decisions risk excluding those who know and care for the child most.\\n- Psychological confusion: Encouraging early gender transition may reinforce identity struggles rather than addressing underlying mental health issues.\\n- Social pressure and ideology: Children may be influenced by cultural trends or peer pressure rather than making informed, autonomous decisions.", "id_expl_id": 770, "text_expl_id": 770}]}}
2025-11-25 01:46:23.634098+00	1587	32	1	112	insertRecord	critical_statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 112, "id_expl_id": 1587, "argument_id": 197, "statement_id": 168, "argument_id_expl_id": 1587, "critical_question_id": 1, "statement_id_expl_id": 1587, "critical_question_id_expl_id": 1587}, "tableName": "critical_statement", "targetLabel": "(?) the vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation"}
2025-06-19 17:15:20.330375+00	1130	18	1	111	updateRecord	argument	{"id": "111", "diff": {"after": {"title": "Wikipedia confirms this fact about history of science."}, "before": {"id": 111, "title": "Wikipedia confirms this.", "id_expl_id": 831, "title_expl_id": 1129}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Wikipedia confirms this fact about history of science."}
2025-06-19 17:18:21.740842+00	1131	18	1	112	updateRecord	argument	{"id": "112", "diff": {"after": {"title": "The official Oxford Uni Science Blog confirms this."}, "before": {"id": 112, "title": "Oxford Uni Sci. Blog", "id_expl_id": 834, "title_expl_id": 834}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The official Oxford Uni Science Blog confirms this."}
2025-07-16 23:35:25.946063+00	1300	5	1	17	updateRecord	tag	{"id": 17, "diff": {"after": {"name": "examples"}, "before": {"id": 17, "name": "example", "id_expl_id": 659, "name_expl_id": 659}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "tag", "targetLabel": "examples"}
2025-11-27 13:15:01.844747+00	1668	18	1	206	insertCrossRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 4, "label": "soul - The spiritual part of a person that gives life to the body and lives forever.", "tableName": "definition"}, "record": {"argument_id": 206, "definition_id": 4, "argument_id_expl_id": 1668, "definition_id_expl_id": 1668}, "target": {"id": 206, "label": "Humans and dogs have hearts.", "tableName": "argument"}}
2025-10-16 01:10:35.996066+00	1363	24	1	177	insertExtRecord	argument	{"user": {"id": 24, "name": "Usuario de demostración 1", "auth_role": "invited"}, "record": {"id": 177, "pro": true, "title": "The Moon landing video was filmed in a studio.", "chat_text": "", "id_expl_id": 1363, "pro_expl_id": 1363, "statement_id": 148, "title_expl_id": 1363, "argument_type_id": 3, "chat_text_expl_id": 1363, "statement_id_expl_id": 1363, "argument_type_id_expl_id": 1363}, "extRecord": {"id": 177, "text": "The Moon landing video was filmed in a studio but presented as real. So Moon landing was a lie.", "id_expl_id": 1363, "text_expl_id": 1363}, "tableName": "argument", "targetLabel": "The Moon landing video was filmed in a studio.", "extTableName": "argument_other"}
2025-10-26 21:24:38.275395+00	1424	18	1	31	deleteById	tag	{"id": 31, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "tag", "targetLabel": "poop", "deletedRecords": {"tag": [{"id": 31, "name": "poop", "id_expl_id": 1423, "description": "", "name_expl_id": 1423, "description_expl_id": 1423}]}}
2025-11-02 23:24:01.510345+00	1471	5	1	13	updateExtRecord	issue	{"id": 13, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 13, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "Add instructions to the invite page that asks close beta users not to invite dodgy people who will create mayhem.", "extTableName": "task"}
2025-11-02 23:26:16.948531+00	1476	5	1	19	updateExtRecord	issue	{"id": 19, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 19, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "Explanation of why an authority is relevant is duplicated when multiple claims are taken from the same authority.", "extTableName": "task"}
2025-11-06 23:17:35.741334+00	1541	5	1	\N	deleteByIds	tag	{"ids": [27], "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "tag", "targetLabel": "27", "deletedRecords": {"tag": [{"id": 27, "name": "animal rights", "id_expl_id": 926, "description": "", "name_expl_id": 957, "description_expl_id": 926}]}}
2025-11-25 01:46:12.079058+00	1586	32	1	168	insertRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 168, "text": "the vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation", "label": "(?) the vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1586, "text_expl_id": 1586, "decided_expl_id": 1586, "featured_expl_id": 1586, "chat_text_expl_id": 1586, "statement_type_id": 1, "confidence_expl_id": 1586, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1586}, "tableName": "statement", "targetLabel": "(?) the vast majority of seemingly strange phenomena that we've investigated and discovered the nature of in the past have turned out to have a physical explanation"}
2025-11-25 01:58:35.268634+00	1590	32	1	199	updateRecord	argument	{"id": "199", "diff": {"after": {"title": "very complex and specifically designed natural entities"}, "before": {"id": 199, "title": "the existence of very complex and specifically designed natural entities", "id_expl_id": 1589, "title_expl_id": 1589}}, "user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "userExpl": "Shortening the short version.", "tableName": "argument", "targetLabel": "very complex and specifically designed natural entities"}
2025-11-26 07:49:42.325058+00	1612	32	1	174	insertCrossRecords	statement	{"id": 174, "user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 1611}, "fkEnries": {"tags": {"options": [], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?) psychological hedonism is true"}
2025-11-27 03:28:59.974803+00	1652	32	1	182	insertRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 182, "text": "their critical thinking will be combined to produce exceptional critical thinking of Apollo", "label": "(?) their critical thinking will be combined to produce exceptional critical thinking of Apollo", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1652, "text_expl_id": 1652, "decided_expl_id": 1652, "featured_expl_id": 1652, "chat_text_expl_id": 1652, "statement_type_id": 1, "confidence_expl_id": 1652, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1652}, "tableName": "statement", "targetLabel": "(?) their critical thinking will be combined to produce exceptional critical thinking of Apollo"}
2025-06-19 17:20:52.049339+00	1132	18	1	112	updateRecord	argument	{"id": "112", "diff": {"after": {"title": "The official Oxford University Science Blog confirms this."}, "before": {"id": 112, "title": "The official Oxford Uni Science Blog confirms this.", "id_expl_id": 834, "title_expl_id": 1131}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The official Oxford University Science Blog confirms this."}
2025-07-17 00:10:13.659082+00	1301	18	1	146	insertRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 146, "text": "SARS-CoV-2 originated from a lab leak in Wuhan", "label": "(?) SARS-CoV-2 originated from a lab leak in Wuhan", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1301, "text_expl_id": 1301, "decided_expl_id": 1301, "featured_expl_id": 1301, "chat_text_expl_id": 1301, "statement_type_id": 1, "confidence_expl_id": 1301, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1301}, "tableName": "statement", "targetLabel": "(?) SARS-CoV-2 originated from a lab leak in Wuhan"}
2025-11-26 07:49:52.131251+00	1613	32	1	174	insertCrossRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "cross": {"id": 42, "label": "philosophy", "tableName": "tag"}, "record": {"tag_id": 42, "statement_id": 174, "tag_id_expl_id": 1613, "statement_id_expl_id": 1613}, "target": {"id": 174, "label": "(?) psychological hedonism is true", "tableName": "statement"}}
2025-07-17 00:32:23.421074+00	1308	18	1	171	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 171, "pro": false, "title": "Genomic and environmental evidence from the Huanan market", "chat_text": "", "id_expl_id": 1308, "pro_expl_id": 1308, "statement_id": 146, "title_expl_id": 1308, "argument_type_id": 4, "chat_text_expl_id": 1308, "statement_id_expl_id": 1308, "argument_type_id_expl_id": 1308}, "extRecord": {"id": 171, "text": "Cell and Nature papers (2024) show SARS-CoV-2 RNA intermingled with DNA from raccoon dogs, civets and other susceptible mammals in the very stalls where early cases shopped, placing virus and plausible hosts together.\\n\\nhttps://www.cell.com/cell/fulltext/S0092-8674%2824%2900901-2\\nhttps://www.nature.com/articles/d41586-024-03026-9\\n", "id_expl_id": 1308, "text_expl_id": 1308}, "tableName": "argument", "targetLabel": "Genomic and environmental evidence from the Huanan market", "extTableName": "argument_explanation"}
2025-11-27 03:46:53.66696+00	1661	32	1	126	insertRecord	critical_statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 126, "id_expl_id": 1661, "argument_id": 211, "statement_id": 184, "argument_id_expl_id": 1661, "critical_question_id": 1, "statement_id_expl_id": 1661, "critical_question_id_expl_id": 1661}, "tableName": "critical_statement", "targetLabel": "(?) devil's advocates will help address common bad arguments enough to prevent too many unaddressed bad arguments from influencing Apollo too much"}
2025-07-17 00:34:44.670818+00	1310	18	1	173	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 173, "pro": false, "title": "Absence of genetic engineering signatures", "chat_text": "", "id_expl_id": 1310, "pro_expl_id": 1310, "statement_id": 146, "title_expl_id": 1310, "argument_type_id": 4, "chat_text_expl_id": 1310, "statement_id_expl_id": 1310, "argument_type_id_expl_id": 1310}, "extRecord": {"id": 173, "text": "Intelligence and peer-reviewed analyses agree the viral genome lacks markers of deliberate manipulation; features such as the furin-cleavage site can arise via natural recombination found in wild coronaviruses.\\n\\nhttps://www.dni.gov/files/ODNI/documents/assessments/Declassified-Assessment-on-COVID-19-Origins.pdf", "id_expl_id": 1310, "text_expl_id": 1310}, "tableName": "argument", "targetLabel": "Absence of genetic engineering signatures", "extTableName": "argument_explanation"}
2025-10-16 01:27:19.402914+00	1364	24	1	149	insertRecord	statement	{"user": {"id": 24, "name": "Usuario de demostración 1", "auth_role": "invited"}, "record": {"id": 149, "text": "The Moon landing video was filmed in a studio.", "label": "(?) The Moon landing video was filmed in a studio.", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1364, "text_expl_id": 1364, "decided_expl_id": 1364, "featured_expl_id": 1364, "chat_text_expl_id": 1364, "statement_type_id": 1, "confidence_expl_id": 1364, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1364}, "tableName": "statement", "targetLabel": "(?) The Moon landing video was filmed in a studio."}
2025-11-28 22:27:07.020775+00	1683	32	1	185	insertCrossRecords	statement	\N
2025-10-26 21:25:45.636054+00	1425	18	1	32	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 32, "name": "economics", "id_expl_id": 1425, "description": "", "name_expl_id": 1425, "description_expl_id": 1425}, "tableName": "tag", "targetLabel": "economics"}
2025-11-02 23:24:12.055448+00	1472	5	1	15	updateExtRecord	issue	{"id": 15, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 15, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "make sure that notification queries are efficient", "extTableName": "task"}
2025-11-06 23:18:23.446919+00	1543	5	1	28	insertCrossRecord	statement	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "cross": {"id": 29, "label": "science", "tableName": "tag"}, "record": {"tag_id": 29, "statement_id": 28, "tag_id_expl_id": 1543, "statement_id_expl_id": 1543}, "target": {"id": 28, "label": "(?) climate change is anthropogenic", "tableName": "statement"}}
2025-11-25 01:50:22.877424+00	1588	32	1	198	insertExtRecord	argument	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 198, "pro": true, "title": "weather science", "chat_text": "", "id_expl_id": 1588, "pro_expl_id": 1588, "statement_id": 168, "title_expl_id": 1588, "argument_type_id": 8, "chat_text_expl_id": 1588, "statement_id_expl_id": 1588, "argument_type_id_expl_id": 1588}, "extRecord": {"id": 198, "text": "In the past, weather was a strange phenomenon. It was investigated and found to consistently have physical explanations.", "id_expl_id": 1588, "text_expl_id": 1588}, "tableName": "argument", "targetLabel": "weather science", "extTableName": "argument_example"}
2025-06-19 17:24:11.254776+00	1133	18	1	114	updateRecord	argument	{"id": "114", "diff": {"after": {"title": "Water vapour has net positive feedback on atmospheric temperature according IPCC AR6."}, "before": {"id": 114, "title": "IPCC AR6", "id_expl_id": 850, "title_expl_id": 850}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Water vapour has net positive feedback on atmospheric temperature according IPCC AR6."}
2025-07-17 00:10:14.02458+00	1302	18	1	146	insertCrossRecords	statement	{"id": 146, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 1301}, "fkEnries": {"tags": {"options": [{"id": 19, "label": "health"}, {"id": 17, "label": "examples"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?) SARS-CoV-2 originated from a lab leak in Wuhan"}
2025-11-02 23:26:38.188599+00	1478	5	1	21	updateExtRecord	issue	{"id": 21, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 21, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "I often find myself answering the same thing for \\"Why this is a relevant authority?\\"", "extTableName": "task"}
2025-07-17 00:13:52.079069+00	1303	18	1	166	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 166, "pro": true, "title": "The FBI (since 2023), U.S. Department of Energy (2023), CIA (2025) and Germany’s BND (2025) have all judged—at low to moderate confidence—that an accidental release from a Wuhan laboratory is the most plausible origin.", "chat_text": "", "id_expl_id": 1303, "pro_expl_id": 1303, "statement_id": 146, "title_expl_id": 1303, "argument_type_id": 1, "chat_text_expl_id": 1303, "statement_id_expl_id": 1303, "argument_type_id_expl_id": 1303}, "extRecord": {"id": 166, "quote": "WASHINGTON—The Central Intelligence Agency has now concluded that the deadly Covid-19 pandemic most likely arose from a laboratory leak, lending credibility to a view that has been the focus of sharp debate among scientists and politicians for years.", "authority": "CIA is one of the most resourceful intelligence organisations in the world", "id_expl_id": 1303, "source_url": "https://www.wsj.com/politics/national-security/cia-now-favors-lab-leak-theory-on-origins-of-covid-19-eff4e67c", "source_title": "CIA Now Favors Lab Leak Theory on Origins of Covid-19", "quote_expl_id": 1303, "authority_expl_id": 1303, "source_url_expl_id": 1303, "source_title_expl_id": 1303}, "tableName": "argument", "targetLabel": "The FBI (since 2023), U.S. Department of Energy (2023), CIA (2025) and Germany’s BND (2025) have all judged—at low to moderate confidence—that an accidental release from a Wuhan laboratory is the most plausible origin.", "extTableName": "argument_authority"}
2025-10-16 01:27:42.684091+00	1365	24	1	106	insertRecord	critical_statement	{"user": {"id": 24, "name": "Usuario de demostración 1", "auth_role": "invited"}, "record": {"id": 106, "id_expl_id": 1365, "argument_id": 177, "statement_id": 149, "argument_id_expl_id": 1365, "critical_question_id": 1, "statement_id_expl_id": 1365, "critical_question_id_expl_id": 1365}, "tableName": "critical_statement", "targetLabel": "(?) The Moon landing video was filmed in a studio."}
2025-10-26 21:26:08.59147+00	1426	18	1	32	deleteById	tag	{"id": 32, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "this was a test", "tableName": "tag", "targetLabel": "economics", "deletedRecords": {"tag": [{"id": 32, "name": "economics", "id_expl_id": 1425, "description": "", "name_expl_id": 1425, "description_expl_id": 1425}]}}
2025-10-26 21:38:29.971534+00	1427	18	1	83	updateRecord	argument	{"id": "83", "diff": {"after": {"title": "Conflicts will be resolved by deferring to Apollo's wise judgement"}, "before": {"id": 83, "title": "conflict resolution", "id_expl_id": 507, "title_expl_id": 507}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Conflicts will be resolved by deferring to Apollo's wise judgement"}
2025-10-26 21:38:50.866755+00	1428	18	1	83	updateRecord	argument	{"id": "83", "diff": {"after": {"title": "Conflicts will be resolved by deferring to Apollo's wise ass judgement"}, "before": {"id": 83, "title": "Conflicts will be resolved by deferring to Apollo's wise judgement", "id_expl_id": 507, "title_expl_id": 1427}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Conflicts will be resolved by deferring to Apollo's wise ass judgement"}
2025-11-02 23:25:56.087431+00	1474	5	1	17	updateExtRecord	issue	{"id": 17, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 17, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "make sure that all expl of changes related to a statement appear on it's history page", "extTableName": "task"}
2025-11-02 23:26:07.176611+00	1475	5	1	18	updateExtRecord	issue	{"id": 18, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 18, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "Split the argument types into its logical parts.", "extTableName": "task"}
2025-11-02 23:26:26.430568+00	1477	5	1	20	updateExtRecord	issue	{"id": 20, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 20, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "Allow adressing people with @Name from the general chat, as well as from the statement discussion", "extTableName": "task"}
2025-11-02 23:26:47.200663+00	1479	5	1	22	updateExtRecord	issue	{"id": 22, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 22, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "I often find myself ignoring the checks before I judge", "extTableName": "task"}
2025-06-19 17:27:58.481364+00	1134	18	1	118	updateRecord	argument	{"id": "118", "diff": {"after": {"title": "IPCC's dramatic claim that Himalayan glaciers could disappear by 2035 was unscientific."}, "before": {"id": 118, "title": "Glaciergate", "id_expl_id": 869, "title_expl_id": 869}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "IPCC's dramatic claim that Himalayan glaciers could disappear by 2035 was unscientific."}
2025-06-19 17:41:58.867441+00	1138	18	1	116	updateRecord	argument	{"id": "116", "diff": {"after": {"title": "Clouds are likely to have positive feedback on heating in the range of 0.12 to 0.72 W m⁻² °C⁻¹  according to  IPCC AR6."}, "before": {"id": 116, "title": "IPCC AR6", "id_expl_id": 858, "title_expl_id": 858}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Clouds are likely to have positive feedback on heating in the range of 0.12 to 0.72 W m⁻² °C⁻¹  according to  IPCC AR6."}
2025-06-19 17:56:52.659136+00	1142	18	1	72	updateRecord	argument	{"id": "72", "diff": {"after": {"title": "Public shaming of Dr. Lindzen is an example of that."}, "before": {"id": 72, "title": "public shaming of Dr. Lindzen", "id_expl_id": 307, "title_expl_id": 307}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Public shaming of Dr. Lindzen is an example of that."}
2025-06-19 18:04:33.161795+00	1151	18	1	59	updateRecord	argument	{"id": "59", "diff": {"after": {"title": "Introducing a model that contradicts the scientific consensus on climate change could risk damaging a scientist's professional reputation and relationships with peers."}, "before": {"id": 59, "title": "professional reputation", "id_expl_id": 285, "title_expl_id": 486}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Introducing a model that contradicts the scientific consensus on climate change could risk damaging a scientist's professional reputation and relationships with peers."}
2025-06-19 18:06:32.61959+00	1154	18	1	124	updateRecord	argument	{"id": "124", "diff": {"after": {"title": "The Sunday Times has his quote confirming this."}, "before": {"id": 124, "title": "The Times report", "id_expl_id": 902, "title_expl_id": 902}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The Sunday Times has his quote confirming this."}
2025-07-17 00:17:10.252056+00	1304	18	1	167	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 167, "pro": true, "title": "Documented risky coronavirus research at the Wuhan Institute of Virology (WIV)", "chat_text": "", "id_expl_id": 1304, "pro_expl_id": 1304, "statement_id": 146, "title_expl_id": 1304, "argument_type_id": 4, "chat_text_expl_id": 1304, "statement_id_expl_id": 1304, "argument_type_id_expl_id": 1304}, "extRecord": {"id": 167, "text": "The WIV collected and manipulated hundreds of bat coronaviruses, including chimeric constructs that some experts classify as gain-of-function. U.S. funding to EcoHealth Alliance was suspended and the group was formally debarred in 2024– 25 for failing to report such work, underscoring oversight gaps.\\n\\nhttps://www.voanews.com/a/china-denial-of-coronavirus-tinkering-at-wuhan-lab-misleading/7980887.html\\nhttps://oversight.house.gov/release/breaking-hhs-formally-debars-ecohealth-alliance-dr-peter-daszak-after-covid-select-reveals-pandemic-era-wrongdoing/?utm_source=chatgpt.com\\n", "id_expl_id": 1304, "text_expl_id": 1304}, "tableName": "argument", "targetLabel": "Documented risky coronavirus research at the Wuhan Institute of Virology (WIV)", "extTableName": "argument_explanation"}
2025-07-17 00:18:37.025373+00	1305	18	1	168	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 168, "pro": true, "title": "Biosafety concerns and violations", "chat_text": "", "id_expl_id": 1305, "pro_expl_id": 1305, "statement_id": 146, "title_expl_id": 1305, "argument_type_id": 4, "chat_text_expl_id": 1305, "statement_id_expl_id": 1305, "argument_type_id_expl_id": 1305}, "extRecord": {"id": 168, "text": "Intelligence reports describe multiple breaches of safety protocols at the WIV, with SARS-like viruses handled under BSL-2/-3 conditions that many virologists consider inadequate, providing a credible pathway for accidental release.\\n\\nhttps://www.reuters.com/business/healthcare-pharmaceuticals/german-spy-agency-concluded-covid-virus-likely-leaked-lab-papers-say-2025-03-12/\\nhttps://www.voanews.com/a/china-denial-of-coronavirus-tinkering-at-wuhan-lab-misleading/7980887.html", "id_expl_id": 1305, "text_expl_id": 1305}, "tableName": "argument", "targetLabel": "Biosafety concerns and violations", "extTableName": "argument_explanation"}
2025-07-17 01:00:17.282686+00	1315	18	1	166	updateExtRecord	argument	{"id": "166", "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"quote": "Agency says it had ‘low confidence’ in its finding, but this is further than it has ever gone in pinpointing the origin of a virus that killed millions worldwide.\\n\\nWASHINGTON—The Central Intelligence Agency has now concluded that the deadly Covid-19 pandemic most likely arose from a laboratory leak, lending credibility to a view that has been the focus of sharp debate among scientists and politicians for years.\\n\\n---\\n\\nAdditionally the FBI (since 2023), U.S. Department of Energy (2023) and Germany’s BND (2025) have all judged—at low to moderate confidence—that an accidental release from a Wuhan laboratory is the most plausible origin.\\n\\nhttps://www.usnews.com/news/health-news/articles/2023-03-01/fbi-director-says-covid-19-origin-is-most-likely-a-lab-incident-in-china\\nhttps://www.theguardian.com/world/2023/feb/26/covid-virus-likely-laboratory-leak-us-energy-department\\nhttps://www.reuters.com/business/healthcare-pharmaceuticals/german-spy-agency-concluded-covid-virus-likely-leaked-lab-papers-say-2025-03-12/\\n\\n\\n\\n\\n"}, "before": {"id": 166, "quote": "WASHINGTON—The Central Intelligence Agency has now concluded that the deadly Covid-19 pandemic most likely arose from a laboratory leak, lending credibility to a view that has been the focus of sharp debate among scientists and politicians for years.\\n\\n---\\n\\nAdditionally the FBI (since 2023), U.S. Department of Energy (2023) and Germany’s BND (2025) have all judged—at low to moderate confidence—that an accidental release from a Wuhan laboratory is the most plausible origin.\\n\\nhttps://www.usnews.com/news/health-news/articles/2023-03-01/fbi-director-says-covid-19-origin-is-most-likely-a-lab-incident-in-china\\nhttps://www.theguardian.com/world/2023/feb/26/covid-virus-likely-laboratory-leak-us-energy-department\\nhttps://www.reuters.com/business/healthcare-pharmaceuticals/german-spy-agency-concluded-covid-virus-likely-leaked-lab-papers-say-2025-03-12/\\n\\n\\n\\n\\n", "id_expl_id": 1303, "quote_expl_id": 1314}}, "tableName": "argument", "targetLabel": "FBI, CIA and Germany’s intelligence have all judged lab leak more plausible", "extTableName": "argument_authority"}
2025-10-16 10:01:00.017273+00	1366	24	1	178	insertExtRecord	argument	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 178, "pro": true, "title": "There are no stars visible in is the dark sky.", "chat_text": "", "id_expl_id": 1366, "pro_expl_id": 1366, "statement_id": 149, "title_expl_id": 1366, "argument_type_id": 3, "chat_text_expl_id": 1366, "statement_id_expl_id": 1366, "argument_type_id_expl_id": 1366}, "extRecord": {"id": 178, "text": "On the Moon landing videos the sky is dark but no stars are visible. That is because it was filmed in a studio against a dark background rather than a real sky.", "id_expl_id": 1366, "text_expl_id": 1366}, "tableName": "argument", "targetLabel": "There are no stars visible in is the dark sky.", "extTableName": "argument_other"}
2025-06-19 17:29:08.268933+00	1135	18	1	119	updateRecord	argument	{"id": "119", "diff": {"after": {"title": "They still have the original quote on one of their official websites."}, "before": {"id": 119, "title": "direct original quote", "id_expl_id": 874, "title_expl_id": 874}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "They still have the original quote on one of their official websites."}
2025-06-19 17:31:13.665073+00	1136	18	1	120	updateRecord	argument	{"id": "120", "diff": {"after": {"title": "The organisation admitted it themselves."}, "before": {"id": 120, "title": "eventual admission", "id_expl_id": 877, "title_expl_id": 877}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The organisation admitted it themselves."}
2025-06-19 17:34:06.08312+00	1137	18	1	115	updateRecord	argument	{"id": "115", "diff": {"after": {"title": "Scientists at Imperial College London and the University of East Anglia found it was very likely (more than 97.5% probability) that clouds will amplify global heating."}, "before": {"id": 115, "title": "2021 observations study", "id_expl_id": 857, "title_expl_id": 857}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Scientists at Imperial College London and the University of East Anglia found it was very likely (more than 97.5% probability) that clouds will amplify global heating."}
2025-06-19 17:51:25.428883+00	1139	18	1	113	updateRecord	argument	{"id": "113", "diff": {"after": {"title": "Explanation of climate changes without understanding of cloud formation could provide seemingly correct results by coincidence while being incorrect."}, "before": {"id": 113, "title": "past explanation problem", "id_expl_id": 845, "title_expl_id": 845}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Explanation of climate changes without understanding of cloud formation could provide seemingly correct results by coincidence while being incorrect."}
2025-06-19 17:52:55.653573+00	1140	18	1	62	updateRecord	argument	{"id": "62", "diff": {"after": {"title": " Some terrorism have been motivated by an environmentalist ideology."}, "before": {"id": 62, "title": "environmentalist terror", "id_expl_id": 288, "title_expl_id": 462}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": " Some terrorism have been motivated by an environmentalist ideology."}
2025-06-19 17:57:58.982235+00	1144	18	1	74	updateRecord	argument	{"id": "74", "diff": {"after": {"title": "#ExxonKnew campaign has targeted executives from ExxonMobil"}, "before": {"id": 74, "title": "#ExxonKnew campaign", "id_expl_id": 311, "title_expl_id": 311}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "#ExxonKnew campaign has targeted executives from ExxonMobil"}
2025-06-19 17:59:24.287154+00	1145	18	1	75	updateRecord	argument	{"id": "75", "diff": {"after": {"title": "beforetheflood.com lists specific people and labels them Climate Deniers"}, "before": {"id": 75, "title": "\\"Top climate deniers\\" website", "id_expl_id": 312, "title_expl_id": 312}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "beforetheflood.com lists specific people and labels them Climate Deniers"}
2025-06-19 18:02:52.711725+00	1147	18	1	51	updateRecord	argument	{"id": "51", "diff": {"after": {"title": "Such a climate scientist would become famous and an important figure in the history of science."}, "before": {"id": 51, "title": "they will gain fame and recognition", "id_expl_id": 187, "title_expl_id": 187}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Such a climate scientist would become famous and an important figure in the history of science."}
2025-06-19 18:03:21.520501+00	1148	18	1	52	updateRecord	argument	{"id": "52", "diff": {"after": {"title": "Such a climate scientist would be offered financial support by organisations that are disadvantaged by climate policies."}, "before": {"id": 52, "title": "Financial support from Climate Change critics", "id_expl_id": 188, "title_expl_id": 188}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Such a climate scientist would be offered financial support by organisations that are disadvantaged by climate policies."}
2025-06-19 18:03:45.672012+00	1149	18	1	53	updateRecord	argument	{"id": "53", "diff": {"after": {"title": "The scientist would be motivated by their pursuit of truth."}, "before": {"id": 53, "title": "search for truth", "id_expl_id": 189, "title_expl_id": 487}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The scientist would be motivated by their pursuit of truth."}
2025-06-19 18:04:56.683893+00	1152	18	1	60	updateRecord	argument	{"id": "60", "diff": {"after": {"title": "Reporting contradictory findings might jeopardise current and future funding opportunities and create internal conflicts within research institutions."}, "before": {"id": 60, "title": "risk to funding", "id_expl_id": 286, "title_expl_id": 286}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Reporting contradictory findings might jeopardise current and future funding opportunities and create internal conflicts within research institutions."}
2025-06-19 18:05:16.381991+00	1153	18	1	61	updateRecord	argument	{"id": "61", "diff": {"after": {"title": "The scientist may doubt his own result and don’t want to play in the hands of people who are his ideological enemies."}, "before": {"id": 61, "title": "doubt & ideological reservations", "id_expl_id": 287, "title_expl_id": 287}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The scientist may doubt his own result and don’t want to play in the hands of people who are his ideological enemies."}
2025-06-19 18:07:29.747802+00	1155	18	1	121	updateRecord	argument	{"id": "121", "diff": {"after": {"title": "Climate scientists have more incentives to reach that conclusion rather than the opposite."}, "before": {"id": 121, "title": "balance of incentives", "id_expl_id": 895, "title_expl_id": 895}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Climate scientists have more incentives to reach that conclusion rather than the opposite."}
2025-06-19 17:56:26.211292+00	1141	18	1	68	updateRecord	argument	{"id": "68", "diff": {"after": {"title": "Public shaming of Dr. Soon is an example of that."}, "before": {"id": 68, "title": "public shaming of Dr. Soon", "id_expl_id": 296, "title_expl_id": 296}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Public shaming of Dr. Soon is an example of that."}
2025-06-19 17:57:22.66676+00	1143	18	1	63	updateRecord	argument	{"id": "63", "diff": {"after": {"title": "Climate activists have sometimes resorted to publicly shaming high-profile individuals perceived as climate change deniers."}, "before": {"id": 63, "title": "public shaming by activists", "id_expl_id": 289, "title_expl_id": 289}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Climate activists have sometimes resorted to publicly shaming high-profile individuals perceived as climate change deniers."}
2025-06-19 18:03:57.047841+00	1150	18	1	54	updateRecord	argument	{"id": "54", "diff": {"after": {"title": "This scientist will fear attacks by climate activists."}, "before": {"id": 54, "title": "fear activists attacks", "id_expl_id": 203, "title_expl_id": 479}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "This scientist will fear attacks by climate activists."}
2025-06-19 18:08:15.7502+00	1156	18	1	123	updateRecord	argument	{"id": "123", "diff": {"after": {"title": "Lennart Bengtsson in 2014 experienced a backlash after affiliating with a skeptical think tank (the GWPF)"}, "before": {"id": 123, "title": "Bengtsson case", "id_expl_id": 899, "title_expl_id": 899}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Lennart Bengtsson in 2014 experienced a backlash after affiliating with a skeptical think tank (the GWPF)"}
2025-11-02 23:27:06.306626+00	1481	5	1	24	updateExtRecord	issue	{"id": 24, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 24, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "don't round certainity if it's close to 0% or 100%", "extTableName": "task"}
2025-07-17 00:22:39.048457+00	1306	18	1	169	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 169, "pro": true, "title": "Unexplained illnesses among WIV staff", "chat_text": "", "id_expl_id": 1306, "pro_expl_id": 1306, "statement_id": 146, "title_expl_id": 1306, "argument_type_id": 4, "chat_text_expl_id": 1306, "statement_id_expl_id": 1306, "argument_type_id_expl_id": 1306}, "extRecord": {"id": 169, "text": "U.S. sources cited in congressional testimony and FBI inquiries say at least one WIV coronavirus researcher was hospitalized with COVID-like symptoms in November 2019, before the first officially acknowledged cluster, suggesting a possible internal lab outbreak.\\n\\nhttps://www.hsgac.senate.gov/wp-content/uploads/Testimony-Ebright-2024-06-18.pdf\\nhttps://www.vanityfair.com/news/story/inside-the-fbis-lab-leak-investigation\\n\\n", "id_expl_id": 1306, "text_expl_id": 1306}, "tableName": "argument", "targetLabel": "Unexplained illnesses among WIV staff", "extTableName": "argument_explanation"}
2025-07-17 00:28:53.581274+00	1307	18	1	170	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 170, "pro": true, "title": "Geographic proximity of the lab to the initial spread ", "chat_text": "", "id_expl_id": 1307, "pro_expl_id": 1307, "statement_id": 146, "title_expl_id": 1307, "argument_type_id": 4, "chat_text_expl_id": 1307, "statement_id_expl_id": 1307, "argument_type_id_expl_id": 1307}, "extRecord": {"id": 170, "text": "The pandemic ignited in the only city housing China’s premier coronavirus lab", "id_expl_id": 1307, "text_expl_id": 1307}, "tableName": "argument", "targetLabel": "Geographic proximity of the lab to the initial spread ", "extTableName": "argument_explanation"}
2025-07-17 01:05:24.891069+00	1319	18	1	168	insertRecord	argument_judgement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 168, "label": "Biosafety concerns and violations (60%)", "id_expl_id": 1319, "isolated_confidence": 0.6, "isolated_explanation": "Repeated safety lapses while handling SARS-like viruses provide a credible leakage pathway, nudging probability above even.", "isolated_confidence_expl_id": 1319, "isolated_explanation_expl_id": 1319}, "tableName": "argument_judgement", "targetLabel": "Biosafety concerns and violations (60%)"}
2025-10-16 10:08:11.68512+00	1367	24	1	179	insertExtRecord	argument	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 179, "pro": false, "title": "People are moving slowly in the air because of low lunar gravity.", "chat_text": "", "id_expl_id": 1367, "pro_expl_id": 1367, "statement_id": 149, "title_expl_id": 1367, "argument_type_id": 3, "chat_text_expl_id": 1367, "statement_id_expl_id": 1367, "argument_type_id_expl_id": 1367}, "extRecord": {"id": 179, "text": "When astronauts in the video jump, the take off and land much slower than on Earth. So it was not filmed in a studio on Earth.", "id_expl_id": 1367, "text_expl_id": 1367}, "tableName": "argument", "targetLabel": "People are moving slowly in the air because of low lunar gravity.", "extTableName": "argument_other"}
2025-10-26 22:01:21.149289+00	1430	18	1	83	updateRecord	argument	{"id": "83", "diff": {"after": {"title": "Conflicts will be resolved by deferring to Apollo's wise and transparent judgement"}, "before": {"id": 83, "title": "Conflicts will be resolved by deferring to Apollo's wise judgement", "id_expl_id": 507, "title_expl_id": 1429}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Conflicts will be resolved by deferring to Apollo's wise and transparent judgement"}
2025-11-02 23:26:56.376476+00	1480	5	1	23	updateExtRecord	issue	{"id": 23, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 23, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "Is that notification useful?", "extTableName": "task"}
2025-06-19 18:02:20.903833+00	1146	18	1	73	updateRecord	argument	{"id": "73", "diff": {"after": {"title": "Activists have launched media campaigns targeting specific individuals to damage their reputations."}, "before": {"id": 73, "title": "media campaigns to damage reputation", "id_expl_id": 308, "title_expl_id": 308}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Activists have launched media campaigns targeting specific individuals to damage their reputations."}
2025-06-19 18:10:59.485838+00	1160	18	1	47	updateRecord	argument	{"id": "47", "diff": {"after": {"title": "Prominent climate scientists forge their results to fit a predefined conclusion."}, "before": {"id": 47, "title": "forged results", "id_expl_id": 164, "title_expl_id": 335}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "Prominent climate scientists forge their results to fit a predefined conclusion."}
2025-11-08 11:27:24.930571+00	1545	26	1	195	insertExtRecord	argument	{"user": {"id": 26, "name": "Demo user 2", "auth_role": "invited"}, "record": {"id": 195, "pro": true, "title": "Test argument on mobile", "chat_text": "", "id_expl_id": 1545, "pro_expl_id": 1545, "statement_id": 90, "title_expl_id": 1545, "argument_type_id": 7, "chat_text_expl_id": 1545, "statement_id_expl_id": 1545, "argument_type_id_expl_id": 1545}, "extRecord": {"id": 195, "text": "Mobile test", "id_expl_id": 1545, "text_expl_id": 1545}, "tableName": "argument", "targetLabel": "Test argument on mobile", "extTableName": "argument_extrapolation"}
2025-07-17 00:33:31.366211+00	1309	18	1	172	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 172, "pro": false, "title": "Spatial clustering of first patients closer to the market", "chat_text": "", "id_expl_id": 1309, "pro_expl_id": 1309, "statement_id": 146, "title_expl_id": 1309, "argument_type_id": 4, "chat_text_expl_id": 1309, "statement_id_expl_id": 1309, "argument_type_id_expl_id": 1309}, "extRecord": {"id": 172, "text": "Epidemiological mapping finds that the earliest 2019 cases clustered around the market—not the WIV 12 km away—mirroring previous zoonotic outbreaks linked to wildlife markets. \\n\\nhttps://www.nature.com/articles/d41586-024-03026-9", "id_expl_id": 1309, "text_expl_id": 1309}, "tableName": "argument", "targetLabel": "Spatial clustering of first patients closer to the market", "extTableName": "argument_explanation"}
2025-07-17 00:43:01.469065+00	1311	18	1	174	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 174, "pro": false, "title": "WHO’s SAGO (June 2025), rate animal spill-over as the more likely pathway, though with acknowledged uncertainties.", "chat_text": "", "id_expl_id": 1311, "pro_expl_id": 1311, "statement_id": 146, "title_expl_id": 1311, "argument_type_id": 1, "chat_text_expl_id": 1311, "statement_id_expl_id": 1311, "argument_type_id_expl_id": 1311}, "extRecord": {"id": 174, "quote": "In its report, SAGO considered available evidence for the main hypotheses for the origins of COVID-19 and concluded that “the weight of available evidence…suggests zoonotic spillover…either directly from bats or through an intermediate host.”", "authority": "The WHO Scientific Advisory Group for the Origins of Novel Pathogens (SAGO), a panel of 27 independent, international, multidisciplinary experts.", "id_expl_id": 1311, "source_url": "https://www.who.int/news/item/27-06-2025-who-scientific-advisory-group-issues-report-on-origins-of-covid-19", "source_title": "WHO Scientific advisory group issues report on origins of COVID-19", "quote_expl_id": 1311, "authority_expl_id": 1311, "source_url_expl_id": 1311, "source_title_expl_id": 1311}, "tableName": "argument", "targetLabel": "WHO’s SAGO (June 2025), rate animal spill-over as the more likely pathway, though with acknowledged uncertainties.", "extTableName": "argument_authority"}
2025-07-17 01:05:45.347371+00	1320	18	1	168	insertRecord	argument_conditional	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 168, "id_expl_id": 1320, "conditional_confidence": 0.52, "conditional_explanation": "Much of the biosafety risk is already reflected in the previous argument about WIV’s high-risk work, so the net extra push is modest.", "conditional_confidence_expl_id": 1320, "conditional_explanation_expl_id": 1320}, "tableName": "argument_conditional", "targetLabel": 0.52}
2025-10-16 17:12:08.688021+00	1368	24	1	180	insertExtRecord	argument	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 180, "pro": true, "title": "The Moon landing video was filmed in a studio.", "chat_text": "", "id_expl_id": 1368, "pro_expl_id": 1368, "statement_id": 148, "title_expl_id": 1368, "argument_type_id": 4, "chat_text_expl_id": 1368, "statement_id_expl_id": 1368, "argument_type_id_expl_id": 1368}, "extRecord": {"id": 180, "text": "The Moon landing video was filmed in a studio but presented as real. So Moon landing was a lie.", "id_expl_id": 1368, "text_expl_id": 1368}, "tableName": "argument", "targetLabel": "The Moon landing video was filmed in a studio.", "extTableName": "argument_explanation"}
2025-10-26 22:02:54.392249+00	1432	18	1	33	deleteById	tag	{"id": 33, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "this was a test", "tableName": "tag", "targetLabel": "religion", "deletedRecords": {"tag": [{"id": 33, "name": "religion", "id_expl_id": 1431, "description": "", "name_expl_id": 1431, "description_expl_id": 1431}]}}
2025-11-02 23:27:16.32274+00	1482	5	1	25	updateExtRecord	issue	{"id": 25, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "open β rel."}, "before": {"id": 25, "id_expl_id": null, "project_stage": "closed β rel.", "project_stage_expl_id": null}}, "tableName": "issue", "targetLabel": "show how many days ago the argument was udated/created", "extTableName": "task"}
2025-11-02 23:28:44.474749+00	1484	5	1	26	updateExtRecord	issue	{"id": 26, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 26, "status": "backlog", "id_expl_id": null, "status_expl_id": null}}, "tableName": "issue", "targetLabel": "Select correct license", "extTableName": "task"}
2025-11-02 23:32:02.594585+00	1488	5	1	\N	insertRecord	task	\N
2025-06-19 18:08:33.620372+00	1157	18	1	122	updateRecord	argument	{"id": "122", "diff": {"after": {"title": "IPCC is biased towards alarmism"}, "before": {"id": 122, "title": "IPCC alarmism", "id_expl_id": 897, "title_expl_id": 897}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "IPCC is biased towards alarmism"}
2025-11-27 13:00:39.858601+00	1663	18	1	1	insertCrossRecord	definition	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 2, "label": "human - creature on two legs without a tail", "tableName": "definition"}, "record": {"definition_source_id": 2, "definition_target_id": 1, "definition_source_id_expl_id": 1663, "definition_target_id_expl_id": 1663}, "target": {"id": 1, "label": "dog - Creature on four legs with a tail. Human's friend.", "tableName": "definition"}}
2025-07-17 00:46:25.860064+00	1312	18	1	175	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 175, "pro": false, "title": "Every prior human coronavirus emerged via animal spill-over", "chat_text": "", "id_expl_id": 1312, "pro_expl_id": 1312, "statement_id": 146, "title_expl_id": 1312, "argument_type_id": 11, "chat_text_expl_id": 1312, "statement_id_expl_id": 1312, "argument_type_id_expl_id": 1312}, "extRecord": {"id": 175, "text": "Every prior human coronavirus (e.g., SARS-1, MERS) emerged via animal spill-over; no pandemic has yet been traced to a lab accident, whereas wildlife markets have repeatedly seeded new diseases.", "id_expl_id": 1312, "text_expl_id": 1312}, "tableName": "argument", "targetLabel": "Every prior human coronavirus emerged via animal spill-over", "extTableName": "argument_induction"}
2025-10-16 19:54:53.589067+00	1369	24	1	107	insertRecord	critical_statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 107, "id_expl_id": 1369, "argument_id": 180, "statement_id": 149, "argument_id_expl_id": 1369, "critical_question_id": 1, "statement_id_expl_id": 1369, "critical_question_id_expl_id": 1369}, "tableName": "critical_statement", "targetLabel": "(?) The Moon landing video was filmed in a studio."}
2025-10-26 22:26:06.101801+00	1433	18	1	34	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 34, "name": "culture", "id_expl_id": 1433, "description": "", "name_expl_id": 1433, "description_expl_id": 1433}, "tableName": "tag", "targetLabel": "culture"}
2025-11-02 23:28:19.311305+00	1483	5	1	4	updateExtRecord	issue	{"id": 4, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"project_stage": "maintenance"}, "before": {"id": 4, "id_expl_id": 1084, "project_stage": "codebase rel.", "project_stage_expl_id": 1084}}, "tableName": "issue", "targetLabel": "remove createEffect in Form.tsx", "extTableName": "task"}
2025-11-08 11:39:54.227901+00	1546	26	1	40	insertRecord	tag	{"user": {"id": 26, "name": "Demo user 2", "auth_role": "invited"}, "record": {"id": 40, "name": "test  tag", "id_expl_id": 1546, "description": "", "name_expl_id": 1546, "description_expl_id": 1546}, "tableName": "tag", "targetLabel": "test  tag"}
2025-11-08 11:42:42.884252+00	1550	30	1	41	insertRecord	tag	{"user": {"id": 30, "name": "2relTest", "auth_role": "invited"}, "record": {"id": 41, "name": "tt", "id_expl_id": 1550, "description": "test tag", "name_expl_id": 1550, "description_expl_id": 1550}, "tableName": "tag", "targetLabel": "tt"}
2025-11-25 01:57:45.160728+00	1589	32	1	199	insertExtRecord	argument	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 199, "pro": true, "title": "the existence of very complex and specifically designed natural entities", "chat_text": "", "id_expl_id": 1589, "pro_expl_id": 1589, "statement_id": 168, "title_expl_id": 1589, "argument_type_id": 8, "chat_text_expl_id": 1589, "statement_id_expl_id": 1589, "argument_type_id_expl_id": 1589}, "extRecord": {"id": 199, "text": "In the past, the existence of very complex and specifically designed natural entities was a strange phenomenon. We investigated it and discovered evolution as a physical explanation.", "id_expl_id": 1589, "text_expl_id": 1589}, "tableName": "argument", "targetLabel": "the existence of very complex and specifically designed natural entities", "extTableName": "argument_example"}
2025-11-26 07:50:54.519246+00	1615	32	1	174	insertCrossRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "cross": {"id": 44, "label": "psychology", "tableName": "tag"}, "record": {"tag_id": 44, "statement_id": 174, "tag_id_expl_id": 1615, "statement_id_expl_id": 1615}, "target": {"id": 174, "label": "(?) psychological hedonism is true", "tableName": "statement"}}
2025-11-26 23:18:51.438675+00	1626	32	1	205	insertExtRecord	argument	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 205, "pro": true, "title": "Sufficiently deep investigation of motivations typically seems to reveal an underlying ultimately hedonistic motivation.", "chat_text": "", "id_expl_id": 1626, "pro_expl_id": 1626, "statement_id": 174, "title_expl_id": 1626, "statement_label": "(?) psychological hedonism is true", "argument_type_id": 3, "chat_text_expl_id": 1626, "statement_id_expl_id": 1626, "argument_type_id_expl_id": 1626}, "extRecord": {"id": 205, "text": "When we investigate the sources of our motivations deeply, we typically seem to find a drive towards pleasant feelings minus unpleasant feelings. for which no deeper motivational explanation seems viable to give.", "id_expl_id": 1626, "text_expl_id": 1626}, "tableName": "argument", "targetLabel": "Sufficiently deep investigation of motivations typically seems to reveal an underlying ultimately hedonistic motivation.", "extTableName": "argument_other"}
2025-11-27 02:41:17.227756+00	1641	32	1	178	insertRecord	statement	{"user": {"id": 32, "name": "Ferb", "auth_role": "invited"}, "record": {"id": 178, "text": "the positive associations with role-duty are likely ultimately based on subconscious hedonic values", "label": "(?) the positive associations with role-duty are likely ultimately based on subconscious hedonic values", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1641, "text_expl_id": 1641, "decided_expl_id": 1641, "featured_expl_id": 1641, "chat_text_expl_id": 1641, "statement_type_id": 1, "confidence_expl_id": 1641, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1641}, "tableName": "statement", "targetLabel": "(?) the positive associations with role-duty are likely ultimately based on subconscious hedonic values"}
2025-06-19 18:09:28.206374+00	1158	18	1	48	updateRecord	argument	{"id": "48", "diff": {"after": {"title": "In one email, dated November 1999, one scientist wrote: \\"I've just completed Mike's Nature [the science journal] trick of adding in the real temps to each series for the last 20 years (ie, from 1981 onwards) and from 1961 for Keith's to hide the decline."}, "before": {"id": 48, "title": "Published leaked materials confirm this", "id_expl_id": 167, "title_expl_id": 167}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "In one email, dated November 1999, one scientist wrote: \\"I've just completed Mike's Nature [the science journal] trick of adding in the real temps to each series for the last 20 years (ie, from 1981 onwards) and from 1961 for Keith's to hide the decline."}
2025-06-19 18:16:29.59261+00	1161	18	1	43	updateRecord	argument	{"id": "43", "diff": {"after": {"title": "The authors of a study published in a scientific journal found no evidence that the climate models evaluated either systematically overestimated or underestimated warming over the period of their projections."}, "before": {"id": 43, "title": "published study", "id_expl_id": 158, "title_expl_id": 334}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "The authors of a study published in a scientific journal found no evidence that the climate models evaluated either systematically overestimated or underestimated warming over the period of their projections."}
2025-07-17 00:47:09.55235+00	1313	18	1	174	updateRecord	argument	{"id": "174", "diff": {"after": {"title": "WHO’s SAGO rate animal spill-over as the more likely pathway"}, "before": {"id": 174, "title": "WHO’s SAGO (June 2025), rate animal spill-over as the more likely pathway, though with acknowledged uncertainties.", "id_expl_id": 1311, "title_expl_id": 1311}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "WHO’s SAGO rate animal spill-over as the more likely pathway"}
2025-11-08 11:40:09.71209+00	1547	26	1	40	deleteById	tag	{"id": 40, "user": {"id": 26, "name": "Demo user 2", "auth_role": "invited"}, "userExpl": "", "tableName": "tag", "targetLabel": "test  tag", "deletedRecords": {"tag": [{"id": 40, "name": "test  tag", "id_expl_id": 1546, "description": "", "name_expl_id": 1546, "description_expl_id": 1546}]}}
2025-07-17 01:03:49.037363+00	1317	18	1	167	insertRecord	argument_judgement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 167, "label": "Documented risky coronavirus research at the Wuhan Institute of Virology (WIV) (65%)", "id_expl_id": 1317, "isolated_confidence": 0.65, "isolated_explanation": "Knowing that the Wuhan lab was actively engineering bat coronaviruses raises the chance of an accidental release above a neutral 50 %.", "isolated_confidence_expl_id": 1317, "isolated_explanation_expl_id": 1317}, "tableName": "argument_judgement", "targetLabel": "Documented risky coronavirus research at the Wuhan Institute of Virology (WIV) (65%)"}
2025-07-17 01:19:04.922344+00	1327	18	1	166	updateRecord	argument_judgement	{"id": "166", "diff": {"after": {"isolated_confidence": "0.25000", "isolated_explanation": "Multiple intelligence services judging a lab accident “more likely than not” by itself raises belief to roughly one chance in four, but their assessments are still graded as low-to-moderate confidence."}, "before": {"id": 166, "id_expl_id": 1316, "isolated_confidence": 0.7, "isolated_explanation": "Multiple national-security agencies explicitly rate a lab accident as the more plausible origin, so in isolation the claim becomes more likely than not but still short of certainty.", "isolated_confidence_expl_id": 1316, "isolated_explanation_expl_id": 1316}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "rescaling", "tableName": "argument_judgement", "targetLabel": "FBI, CIA and Germany’s intelligence have all judged lab leak more plausible (25%)"}
2025-07-17 01:20:37.123061+00	1330	18	1	168	updateRecord	argument_judgement	{"id": "168", "diff": {"after": {"isolated_confidence": "0.15000", "isolated_explanation": "Repeated safety lapses make an escape plausible but do not by themselves show that one occurred, so they raise confidence only moderately."}, "before": {"id": 168, "id_expl_id": 1319, "isolated_confidence": 0.6, "isolated_explanation": "Repeated safety lapses while handling SARS-like viruses provide a credible leakage pathway, nudging probability above even.", "isolated_confidence_expl_id": 1319, "isolated_explanation_expl_id": 1319}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "rescaling", "tableName": "argument_judgement", "targetLabel": "Biosafety concerns and violations (15%)"}
2025-10-16 19:55:23.590491+00	1370	24	1	177	deleteById	argument	{"id": "177", "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "Recreated the argument with proper type.", "tableName": "argument", "targetLabel": "The Moon landing video was filmed in a studio.", "deletedRecords": {"argument": [{"id": 177, "pro": true, "title": "The Moon landing video was filmed in a studio.", "chat_text": "", "id_expl_id": 1363, "pro_expl_id": 1363, "statement_id": 148, "title_expl_id": 1363, "argument_type_id": 3, "chat_text_expl_id": 1363, "statement_id_expl_id": 1363, "argument_type_id_expl_id": 1363}], "argument_other": [{"id": 177, "text": "The Moon landing video was filmed in a studio but presented as real. So Moon landing was a lie.", "id_expl_id": 1363, "text_expl_id": 1363}], "critical_statement": [{"id": 106, "id_expl_id": 1365, "argument_id": 177, "statement_id": 149, "argument_id_expl_id": 1365, "critical_question_id": 1, "statement_id_expl_id": 1365, "critical_question_id_expl_id": 1365}]}}
2025-10-26 22:26:28.185451+00	1434	18	1	34	deleteById	tag	{"id": 34, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "this was a test", "tableName": "tag", "targetLabel": "culture", "deletedRecords": {"tag": [{"id": 34, "name": "culture", "id_expl_id": 1433, "description": "", "name_expl_id": 1433, "description_expl_id": 1433}]}}
2025-11-02 23:29:02.842725+00	1485	5	1	27	updateExtRecord	issue	{"id": 27, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 27, "status": "backlog", "id_expl_id": null, "status_expl_id": null}}, "tableName": "issue", "targetLabel": "Do not commit secrets.", "extTableName": "task"}
2025-11-08 11:40:44.241339+00	1548	5	1	29	join	person	{"person": {"id": 29, "name": "1relTest"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-06-19 18:10:34.263472+00	1159	18	1	46	updateRecord	argument	{"id": "46", "diff": {"after": {"title": "There are many different climate models. Some of them do not confirm that humans are causing climate change. However, we are shown only the ones that do because there is a strong bias towards that conclusion among climate scientists."}, "before": {"id": 46, "title": "study selection bias", "id_expl_id": 163, "title_expl_id": 163}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "There are many different climate models. Some of them do not confirm that humans are causing climate change. However, we are shown only the ones that do because there is a strong bias towards that conclusion among climate scientists."}
2025-06-21 14:25:19.373247+00	1162	18	1	42	updateRecord	statement	{"id": "42", "diff": {"after": {"text": "Weather and climate predictions look at averages over different ranges of space and time. City or country vs the whole earth. Days or weeks vs years and decades. There is a lot more variation on the smaller scale compared to large scale averages."}, "before": {"id": 42, "text": "Weather and climate predictions look at averages over a different ranges of space and time. City or country vs the whole earth. Days or weeks vs years and decades. There is a lot more variation on the smaller scale compared to large scale averages.", "id_expl_id": 169, "text_expl_id": 169}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(95%) Weather and climate predictions look at averages over different ranges of space and time. City or country vs the whole earth. Days or weeks vs years and decades. There is a lot more variation on the smaller scale compared to large scale averages."}
2025-06-21 15:22:34.401462+00	1163	18	1	99	updateRecord	statement	{"id": "99", "diff": {"after": {"text": "clouds are an amplifier of global warming"}, "before": {"id": 99, "text": "clouds is an amplifier of global warming", "id_expl_id": 855, "text_expl_id": 855}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(76%) clouds are an amplifier of global warming"}
2025-06-21 17:26:43.338826+00	1164	18	1	98	insertRecord	critical_statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 98, "id_expl_id": 1164, "argument_id": 59, "statement_id": 104, "argument_id_expl_id": 1164, "critical_question_id": 1, "statement_id_expl_id": 1164, "critical_question_id_expl_id": 1164}, "tableName": "critical_statement", "targetLabel": "(?) Lennart Bengtsson in 2014 experienced a backlash after affiliating with a skeptical think tank (the GWPF)"}
2025-07-17 00:52:16.611195+00	1314	18	1	166	updateExtRecord	argument	{"id": "166", "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"after": {"title": "FBI, CIA and Germany’s intelligence have all judged lab leak more plausible"}, "before": {"id": 166, "title": "The FBI (since 2023), U.S. Department of Energy (2023), CIA (2025) and Germany’s BND (2025) have all judged—at low to moderate confidence—that an accidental release from a Wuhan laboratory is the most plausible origin.", "id_expl_id": 1303, "title_expl_id": 1303}}, "userExpl": "", "extRecord": {"after": {"quote": "WASHINGTON—The Central Intelligence Agency has now concluded that the deadly Covid-19 pandemic most likely arose from a laboratory leak, lending credibility to a view that has been the focus of sharp debate among scientists and politicians for years.\\n\\n---\\n\\nAdditionally the FBI (since 2023), U.S. Department of Energy (2023) and Germany’s BND (2025) have all judged—at low to moderate confidence—that an accidental release from a Wuhan laboratory is the most plausible origin.\\n\\nhttps://www.usnews.com/news/health-news/articles/2023-03-01/fbi-director-says-covid-19-origin-is-most-likely-a-lab-incident-in-china\\nhttps://www.theguardian.com/world/2023/feb/26/covid-virus-likely-laboratory-leak-us-energy-department\\nhttps://www.reuters.com/business/healthcare-pharmaceuticals/german-spy-agency-concluded-covid-virus-likely-leaked-lab-papers-say-2025-03-12/\\n\\n\\n\\n\\n", "authority": "CIA is one of the most resourceful intelligence organisations in the world."}, "before": {"id": 166, "quote": "WASHINGTON—The Central Intelligence Agency has now concluded that the deadly Covid-19 pandemic most likely arose from a laboratory leak, lending credibility to a view that has been the focus of sharp debate among scientists and politicians for years.", "authority": "CIA is one of the most resourceful intelligence organisations in the world", "id_expl_id": 1303, "quote_expl_id": 1303, "authority_expl_id": 1303}}, "tableName": "argument", "targetLabel": "FBI, CIA and Germany’s intelligence have all judged lab leak more plausible", "extTableName": "argument_authority"}
2025-11-08 11:42:05.190087+00	1549	5	1	30	join	person	{"person": {"id": 30, "name": "2relTest"}, "inviter": {"id": 5, "name": "Dante", "auth_role": "admin"}}
2025-10-16 20:07:28.353076+00	1371	24	1	181	insertExtRecord	argument	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 181, "pro": true, "title": "There are no stars visible in is the dark sky.", "chat_text": "", "id_expl_id": 1371, "pro_expl_id": 1371, "statement_id": 149, "title_expl_id": 1371, "argument_type_id": 4, "chat_text_expl_id": 1371, "statement_id_expl_id": 1371, "argument_type_id_expl_id": 1371}, "extRecord": {"id": 181, "text": "On the Moon landing videos the sky is dark but no stars are visible. That is because it was filmed in a studio against a dark background rather than a real sky.", "id_expl_id": 1371, "text_expl_id": 1371}, "tableName": "argument", "targetLabel": "There are no stars visible in is the dark sky.", "extTableName": "argument_explanation"}
2025-11-02 23:32:30.523265+00	1489	5	1	138	insertRecord	issue	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 138, "title": "allow trusted users to gain wider editing permissions", "id_expl_id": 1489, "description": "", "title_expl_id": 1489, "description_expl_id": 1489}, "tableName": "issue", "targetLabel": "allow trusted users to gain wider editing permissions"}
2025-10-28 19:33:09.48069+00	1435	18	1	35	insertRecord	tag	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 35, "name": "diet", "id_expl_id": 1435, "description": "", "name_expl_id": 1435, "description_expl_id": 1435}, "tableName": "tag", "targetLabel": "diet"}
2025-11-02 23:29:23.783058+00	1486	5	1	28	updateExtRecord	issue	{"id": 28, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 28, "status": "backlog", "id_expl_id": null, "status_expl_id": null}}, "tableName": "issue", "targetLabel": "change DB passwords in git history (e.g.", "extTableName": "task"}
2025-11-02 23:30:13.415195+00	1487	5	1	29	updateExtRecord	issue	{"id": 29, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 29, "status": "backlog", "id_expl_id": null, "status_expl_id": null}}, "tableName": "issue", "targetLabel": "refresh API keys", "extTableName": "task"}
2025-11-02 23:32:59.320846+00	1490	5	1	138	insertRecord	task	{"user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "record": {"id": 138, "title": "allow trusted users to gain wider editing permissions", "status": "backlog", "id_expl_id": 1490, "project_stage": "open β rel.", "status_expl_id": 1490, "functional_area": "auth", "project_stage_expl_id": 1490, "functional_area_expl_id": 1490}, "tableName": "task", "targetLabel": "allow trusted users to gain wider editing permissions"}
2025-06-21 17:29:09.031991+00	1165	18	1	98	deleteById	critical_statement	{"id": 98, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "moving further down", "tableName": "critical_statement", "targetLabel": 104, "deletedRecords": {"critical_statement": [{"id": 98, "id_expl_id": 1164, "argument_id": 59, "statement_id": 104, "argument_id_expl_id": 1164, "critical_question_id": 1, "statement_id_expl_id": 1164, "critical_question_id_expl_id": 1164}]}}
2025-06-21 17:38:31.077059+00	1166	18	1	47	updateRecord	statement	{"id": "47", "diff": {"after": {"text": "A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts anthropogenic climate change."}, "before": {"id": 47, "text": "A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts climate change.", "id_expl_id": 184, "text_expl_id": 494}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(6%) A scientist will have enough incentive to publish and popularize his model if it turns out to be in good agreement with observations and contradicts anthropogenic climate change."}
2025-06-22 12:13:24.887086+00	1167	18	1	37	updateRecord	statement	{"id": "37", "diff": {"after": {"text": "The temperature has never risen so rapidly before humans started burning fossil fuels."}, "before": {"id": 37, "text": "The temperature has never risen so rapidly before until humans started burning fossil fuels.", "id_expl_id": 139, "text_expl_id": 139}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) The temperature has never risen so rapidly before humans started burning fossil fuels."}
2025-06-22 12:15:33.492495+00	1168	18	1	40	updateRecord	argument	{"id": "40", "diff": {"after": {"title": "It is not possible to determine how rapidly the global average temperature has changed in each century over the past million years with the current scientific methods"}, "before": {"id": 40, "title": "Past temperature changes are unknowable with certainty.", "id_expl_id": 146, "title_expl_id": 146}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "It is not possible to determine how rapidly the global average temperature has changed in each century over the past million years with the current scientific methods"}
2025-06-23 23:09:07.436938+00	1169	18	1	118	updateRecord	argument	{"id": "118", "diff": {"after": {"chat_text": "They have even claimed that Himalayan glaciers could disappear by 2035. When the Indian government report challenged this claim the IPCC chief Dr. Rajendra Pachauri had dismissed it as \\"voodoo science\\"."}, "before": {"id": 118, "chat_text": "They have even claimed that Himalayan glaciers could disappear by 2035. When the Indian governemnt report chalanged this claim he IPCC chief Dr. Rajendra Pachauri had dismissed it as \\"voodoo science\\".", "id_expl_id": 869, "chat_text_expl_id": null}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument", "targetLabel": "IPCC's dramatic claim that Himalayan glaciers could disappear by 2035 was unscientific."}
2025-06-25 20:43:36.137451+00	1170	18	1	100	updateRecord	statement	{"id": "100", "diff": {"after": {"chat_text": "I wouldn't put so much trust into IPCC. They are too eager to sound an alarm."}, "before": {"id": 100, "chat_text": "", "id_expl_id": 868, "chat_text_expl_id": null}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(95%) IPCC is biased towards alarmism"}
2025-06-28 13:43:40.51749+00	1173	18	1	7	updateRecord	argument_type	{"id": 7, "diff": {"after": {"description": "The argument claims that if something can't be achieved on a smaller scale, it won't succeed on a larger one. It assumes complex situations are merely scaled-up versions of simpler ones."}, "before": {"id": 7, "id_expl_id": 160, "description": "The argument claims that if something cannot be achieved at a smaller or simpler level, it cannot be accomplished at a larger or more complex level. It often leverages the notion that bigger, longer, or more complex situations are just scaled-up versions of smaller ones.", "description_expl_id": 782}}, "user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "extrapolation"}
2025-06-28 13:45:05.427155+00	1174	18	1	16	updateRecord	argument_type	{"id": 16, "diff": {"after": {"description": "The argument attacks a prescriptive statement by claiming it’s impossible or infeasible to follow. It concludes that since the action can’t be done, it shouldn’t be prescribed or expected."}, "before": {"id": 16, "id_expl_id": 790, "description": "The argument attacks a prescriptive statement or recommendation by claiming it is impossible (or infeasible) to follow. It concludes that because the suggested action cannot be done, it should not be prescribed or expected.", "description_expl_id": 790}}, "user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "feasibility"}
2025-06-28 13:46:03.819121+00	1175	18	1	10	updateRecord	argument_type	{"id": 10, "diff": {"after": {"description": "The argument focuses on the practical consequences of accepting or rejecting a claim. It often asserts that a claim should be adopted for its benefits or avoided for its harms."}, "before": {"id": 10, "id_expl_id": 537, "description": "The argument focuses on the practical consequences or outcomes of accepting or rejecting a claim. Often asserts that a claim or action should be adopted because it leads to beneficial results or avoided because it leads to harmful outcomes.", "description_expl_id": 791}}, "user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "pragmatic"}
2025-06-28 13:46:37.795119+00	1176	18	1	10	updateRecord	argument_type	{"id": 10, "diff": {"after": {"description": "The argument focuses on the consequences of accepting or rejecting a claim. It often asserts that a claim should be adopted for its benefits or avoided for its harms."}, "before": {"id": 10, "id_expl_id": 537, "description": "The argument focuses on the practical consequences of accepting or rejecting a claim. It often asserts that a claim should be adopted for its benefits or avoided for its harms.", "description_expl_id": 1175}}, "user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_type", "targetLabel": "pragmatic"}
2025-06-29 21:40:38.609915+00	1177	18	1	52	updateRecord	issue	{"id": 52, "diff": {"after": {"title": "Make all of the columns of the argument view scroll independently when they overflow the page (?)"}, "before": {"id": 52, "title": "Make all of the columns of the statemnet view scroll independently when they overflow the page (?)", "id_expl_id": null, "title_expl_id": null}}, "user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "userExpl": "", "tableName": "issue", "targetLabel": "Make all of the columns of the argument view scroll independently when they overflow the page (?)"}
2025-06-29 21:43:18.813541+00	1178	18	1	130	insertExtRecord	issue	{"user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "record": {"id": 130, "title": "truncate long texts", "id_expl_id": 1178, "description": "Hide continuations of long blocks of text (e.g. long quotes) under \\"Show more..\\"", "title_expl_id": 1178, "description_expl_id": 1178}, "extRecord": {"id": 130, "status": "backlog", "id_expl_id": 1178, "project_stage": "launch", "status_expl_id": 1178, "functional_area": "UX", "project_stage_expl_id": 1178, "functional_area_expl_id": 1178}, "tableName": "issue", "targetLabel": "truncate long texts", "extTableName": "task"}
2025-06-29 21:59:11.598248+00	1179	18	1	129	updateExtRecord	issue	{"id": 129, "user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 129, "status": "in progress", "id_expl_id": 1112, "status_expl_id": 1112}}, "tableName": "issue", "targetLabel": "split apart argument and statement pages", "extTableName": "task"}
2025-06-29 22:17:10.695152+00	1180	18	1	131	insertExtRecord	issue	{"user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "record": {"id": 131, "title": "dialogue view authoring", "id_expl_id": 1180, "description": "Make dialogue view editable\\n\\nPossible design:  create a two column dedicated UI for authoring dialogues. Left column will have a navigation inside the hierarchy with controls of selection of individual items. On the right hand side there will be the dialogue editor where you can paste edit rearrange the material selected from the left column.", "title_expl_id": 1180, "description_expl_id": 1180}, "extRecord": {"id": 131, "status": "backlog", "id_expl_id": 1180, "project_stage": "open β rel.", "status_expl_id": 1180, "functional_area": "UX", "project_stage_expl_id": 1180, "functional_area_expl_id": 1180}, "tableName": "issue", "targetLabel": "dialogue view authoring", "extTableName": "task"}
2025-06-29 22:38:14.343849+00	1182	18	1	10	updateExtRecord	issue	{"id": 10, "user": {"id": 18, "name": "Дуранте", "auth_role": "invited"}, "record": {"after": {}, "before": {}}, "userExpl": "", "extRecord": {"after": {"status": "completed"}, "before": {"id": 10, "status": "next up", "id_expl_id": 1090, "status_expl_id": 1090}}, "tableName": "issue", "targetLabel": "process Apollo notes in Keep", "extTableName": "task"}
2025-06-30 16:43:09.539055+00	1183	5	1	1	updateRecord	issue	{"id": 1, "diff": {"after": {"description": "At the moment only the content created by users is translated.\\nIt makes sense to make all strings in the Apollo editive and dynamic because someone would frequently find a translation to any particular language of a particular UI string incorrect or lacking"}, "before": {"id": 1, "id_expl_id": 999, "description": "At the moment only the content created by users is translated.", "description_expl_id": 999}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "issue", "targetLabel": "Translate UI into other languages"}
2025-07-01 18:59:36.406743+00	1184	5	1	28	updateRecord	statement	{"id": "28", "diff": {"after": {"text": "⭐ climate change is anthropogenic"}, "before": {"id": 28, "text": "climate change is anthropogenic", "id_expl_id": null, "text_expl_id": null}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) ⭐ climate change is anthropogenic"}
2025-07-01 19:00:13.958802+00	1185	5	1	28	updateRecord	statement	{"id": "28", "diff": {"after": {"text": "climate change is anthropogenic"}, "before": {"id": 28, "text": "⭐ climate change is anthropogenic", "id_expl_id": null, "text_expl_id": 1184}}, "user": {"id": 5, "name": "Dante", "auth_role": "admin"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) climate change is anthropogenic"}
2025-07-15 00:31:31.502906+00	1187	18	1	138	insertExtRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 138, "text": "", "label": "(?)  should ", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1187, "text_expl_id": 1187, "decided_expl_id": 1187, "featured_expl_id": 1187, "chat_text_expl_id": 1187, "statement_type_id": 3, "confidence_expl_id": 1187, "statement_type_name": "prescriptive", "statement_type_id_expl_id": 1187}, "extRecord": {"id": 138, "deed_id": 12, "id_expl_id": 1187, "deed_id_expl_id": 1187}, "tableName": "statement", "targetLabel": "(?)  should ", "extTableName": "directive"}
2025-07-17 01:02:54.68153+00	1316	18	1	166	insertRecord	argument_judgement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 166, "label": "FBI, CIA and Germany’s intelligence have all judged lab leak more plausible (70%)", "id_expl_id": 1316, "isolated_confidence": 0.7, "isolated_explanation": "Multiple national-security agencies explicitly rate a lab accident as the more plausible origin, so in isolation the claim becomes more likely than not but still short of certainty.", "isolated_confidence_expl_id": 1316, "isolated_explanation_expl_id": 1316}, "tableName": "argument_judgement", "targetLabel": "FBI, CIA and Germany’s intelligence have all judged lab leak more plausible (70%)"}
2025-10-28 22:08:05.16144+00	1436	24	1	35	deleteById	tag	{"id": 35, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "", "tableName": "tag", "targetLabel": "diet", "deletedRecords": {"tag": [{"id": 35, "name": "diet", "id_expl_id": 1435, "description": "", "name_expl_id": 1435, "description_expl_id": 1435}]}}
2025-07-17 01:09:42.472947+00	1323	18	1	169	insertRecord	argument_conditional	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 169, "id_expl_id": 1323, "conditional_confidence": 0.6, "conditional_explanation": "Some evidentiary overlap exists with earlier intelligence findings, so the added force is discounted to avoid counting the same hospitalisation rumors twice.", "conditional_confidence_expl_id": 1323, "conditional_explanation_expl_id": 1323}, "tableName": "argument_conditional", "targetLabel": 0.6}
2025-07-15 00:31:31.904296+00	1188	18	1	138	insertCrossRecords	statement	{"id": 138, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 1187}, "fkEnries": {"tags": {"options": [{"id": 17, "label": "example"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?)  should tip"}
2025-07-15 01:29:03.056392+00	1189	18	1	18	insertRecord	directive_scope	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 18, "label": "(+) everyone", "include": true, "id_expl_id": 1189, "directive_id": 138, "include_expl_id": 1189, "person_category_id": 5, "directive_id_expl_id": 1189, "person_category_id_expl_id": 1189}, "tableName": "directive_scope", "targetLabel": "(+) everyone"}
2025-11-08 11:44:58.976771+00	1558	30	1	41	updateRecord	tag	{"id": 41, "diff": {"after": {"name": "tt77"}, "before": {"id": 41, "name": "tt", "id_expl_id": 1550, "name_expl_id": 1550}}, "user": {"id": 30, "name": "2relTest", "auth_role": "invited"}, "userExpl": "", "tableName": "tag", "targetLabel": "tt77"}
2025-07-17 01:04:21.07355+00	1318	18	1	167	insertRecord	argument_conditional	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 167, "id_expl_id": 1318, "conditional_confidence": 0.55, "conditional_explanation": "Part of this weight is already implicit in the intelligence agencies’ judgments about the lab, so only the incremental detail about specific research programs is counted.", "conditional_confidence_expl_id": 1318, "conditional_explanation_expl_id": 1318}, "tableName": "argument_conditional", "targetLabel": 0.55}
2025-07-17 01:20:59.762585+00	1331	18	1	168	updateRecord	argument_conditional	{"id": 168, "diff": {"after": {"conditional_confidence": "0.10000", "conditional_explanation": "Once we accept that risky work was underway, additional details about poor containment add less novel information and are therefore discounted."}, "before": {"id": 168, "id_expl_id": 1320, "conditional_confidence": 0.52, "conditional_explanation": "Much of the biosafety risk is already reflected in the previous argument about WIV’s high-risk work, so the net extra push is modest.", "conditional_confidence_expl_id": 1320, "conditional_explanation_expl_id": 1320}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "rescaling", "tableName": "argument_conditional", "targetLabel": 0.1}
2025-10-16 20:21:54.98806+00	1372	24	1	182	insertExtRecord	argument	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 182, "pro": false, "title": "People are moving slowly in the air because of low lunar gravity.", "chat_text": "", "id_expl_id": 1372, "pro_expl_id": 1372, "statement_id": 149, "title_expl_id": 1372, "argument_type_id": 4, "chat_text_expl_id": 1372, "statement_id_expl_id": 1372, "argument_type_id_expl_id": 1372}, "extRecord": {"id": 182, "text": "When astronauts in the video jump, they take off and land much slower than on Earth. So it was not filmed in a studio on Earth.", "id_expl_id": 1372, "text_expl_id": 1372}, "tableName": "argument", "targetLabel": "People are moving slowly in the air because of low lunar gravity.", "extTableName": "argument_explanation"}
2025-11-27 13:17:34.729154+00	1669	18	1	5	insertRecord	definition	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 5, "term": "Person", "text": "a human", "label": "Person - a human", "id_expl_id": 1669, "term_expl_id": 1669, "text_expl_id": 1669}, "tableName": "definition", "targetLabel": "Person - a human"}
2025-10-28 22:09:47.435767+00	1437	24	1	36	insertRecord	tag	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 36, "name": "diet", "id_expl_id": 1437, "description": "", "name_expl_id": 1437, "description_expl_id": 1437}, "tableName": "tag", "targetLabel": "diet"}
2025-10-28 22:18:48.50388+00	1441	24	1	38	insertRecord	tag	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 38, "name": "diet", "id_expl_id": 1441, "description": "", "name_expl_id": 1441, "description_expl_id": 1441}, "tableName": "tag", "targetLabel": "diet"}
2025-10-28 22:20:17.989597+00	1442	24	1	38	deleteById	tag	{"id": 38, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "", "tableName": "tag", "targetLabel": "diet", "deletedRecords": {"tag": [{"id": 38, "name": "diet", "id_expl_id": 1441, "description": "", "name_expl_id": 1441, "description_expl_id": 1441}]}}
2025-10-28 22:26:05.565986+00	1443	24	1	153	insertRecord	statement	{"user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "record": {"id": 153, "text": "Atoms are round", "label": "(?) Atoms are round", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1443, "text_expl_id": 1443, "decided_expl_id": 1443, "featured_expl_id": 1443, "chat_text_expl_id": 1443, "statement_type_id": 1, "confidence_expl_id": 1443, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1443}, "tableName": "statement", "targetLabel": "(?) Atoms are round"}
2025-10-28 22:27:16.091595+00	1445	18	1	153	insertCrossRecord	statement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "cross": {"id": 29, "label": "science", "tableName": "tag"}, "record": {"tag_id": 29, "statement_id": 153, "tag_id_expl_id": 1445, "statement_id_expl_id": 1445}, "target": {"id": 153, "label": "(?) Atoms are spherical", "tableName": "statement"}}
2025-11-04 19:43:43.981841+00	1491	18	1	190	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 190, "pro": true, "title": "Delete test arg", "chat_text": "", "id_expl_id": 1491, "pro_expl_id": 1491, "statement_id": 90, "title_expl_id": 1491, "argument_type_id": 3, "chat_text_expl_id": 1491, "statement_id_expl_id": 1491, "argument_type_id_expl_id": 1491}, "extRecord": {"id": 190, "text": "Delete test arg", "id_expl_id": 1491, "text_expl_id": 1491}, "tableName": "argument", "targetLabel": "Delete test arg", "extTableName": "argument_other"}
2025-11-08 11:42:48.309263+00	1551	30	1	159	insertRecord	statement	{"user": {"id": 30, "name": "2relTest", "auth_role": "invited"}, "record": {"id": 159, "text": "st7", "label": "(?) st7", "decided": false, "featured": false, "chat_text": "", "confidence": 0.5, "id_expl_id": 1551, "text_expl_id": 1551, "decided_expl_id": 1551, "featured_expl_id": 1551, "chat_text_expl_id": 1551, "statement_type_id": 1, "confidence_expl_id": 1551, "statement_type_name": "descriptive", "statement_type_id_expl_id": 1551}, "tableName": "statement", "targetLabel": "(?) st7"}
2025-07-15 01:42:03.906512+00	1190	18	1	151	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 151, "pro": true, "title": "Tipping reduces inequality by transferring income from higher-earning diners to lower-paid servers.", "chat_text": "", "id_expl_id": 1190, "pro_expl_id": 1190, "statement_id": 138, "title_expl_id": 1190, "argument_type_id": 10, "chat_text_expl_id": 1190, "statement_id_expl_id": 1190, "argument_type_id_expl_id": 1190}, "extRecord": {"id": 151, "text": "Tipping promotes economic equality by transferring money from wealthier diners to lower-paid servers. In most cases, customers earn more than the people serving them, and tipping acts as a small, direct redistribution of income.", "id_expl_id": 1190, "text_expl_id": 1190}, "tableName": "argument", "targetLabel": "Tipping reduces inequality by transferring income from higher-earning diners to lower-paid servers.", "extTableName": "argument_pragmatic"}
2025-07-17 01:06:14.033066+00	1321	18	1	\N	insertRecord	argument_conditional	\N
2025-07-17 01:12:32.041841+00	1325	18	1	170	insertRecord	argument_conditional	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 170, "id_expl_id": 1325, "conditional_confidence": 0.54, "conditional_explanation": "The geographic coincidence component partly overlaps with earlier WIV-focused arguments, leaving a smaller distinct effect primarily from the still-unidentified animal host.", "conditional_confidence_expl_id": 1325, "conditional_explanation_expl_id": 1325}, "tableName": "argument_conditional", "targetLabel": 0.54}
2025-07-17 01:19:44.191875+00	1328	18	1	167	updateRecord	argument_judgement	{"id": "167", "diff": {"after": {"isolated_confidence": "0.20000", "isolated_explanation": "Active manipulation of bat coronaviruses in the same city supplies a direct mechanistic path for an accidental release, modestly strengthening the claim."}, "before": {"id": 167, "id_expl_id": 1317, "isolated_confidence": 0.65, "isolated_explanation": "Knowing that the Wuhan lab was actively engineering bat coronaviruses raises the chance of an accidental release above a neutral 50 %.", "isolated_confidence_expl_id": 1317, "isolated_explanation_expl_id": 1317}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "rescaling", "tableName": "argument_judgement", "targetLabel": "Documented risky coronavirus research at the Wuhan Institute of Virology (WIV) (20%)"}
2025-07-17 01:20:10.80633+00	1329	18	1	167	updateRecord	argument_conditional	{"id": 167, "diff": {"after": {"conditional_confidence": "0.15000", "conditional_explanation": "Because the intelligence assessments already incorporate knowledge of that research, part of this evidential weight has been “spent” and only the remainder is added."}, "before": {"id": 167, "id_expl_id": 1318, "conditional_confidence": 0.55, "conditional_explanation": "Part of this weight is already implicit in the intelligence agencies’ judgments about the lab, so only the incremental detail about specific research programs is counted.", "conditional_confidence_expl_id": 1318, "conditional_explanation_expl_id": 1318}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "rescaling", "tableName": "argument_conditional", "targetLabel": 0.15}
2025-07-17 01:21:35.292084+00	1332	18	1	169	updateRecord	argument_judgement	{"id": "169", "diff": {"after": {"isolated_confidence": "0.30000", "isolated_explanation": "A cluster of early symptomatic researchers would directly connect the lab to the first human cases, making it the single most compelling standalone data point."}, "before": {"id": 169, "id_expl_id": 1322, "isolated_confidence": 0.68, "isolated_explanation": "Reports of symptomatic researchers just before the outbreak are a direct, time-linked hint of a lab origin.", "isolated_confidence_expl_id": 1322, "isolated_explanation_expl_id": 1322}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "rescaling", "tableName": "argument_judgement", "targetLabel": "Unexplained illnesses among WIV staff (30%)"}
2025-10-16 20:22:40.272591+00	1373	24	1	178	deleteById	argument	{"id": "178", "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "Replaced with an argument of proper type.", "tableName": "argument", "targetLabel": "There are no stars visible in is the dark sky.", "deletedRecords": {"argument": [{"id": 178, "pro": true, "title": "There are no stars visible in is the dark sky.", "chat_text": "", "id_expl_id": 1366, "pro_expl_id": 1366, "statement_id": 149, "title_expl_id": 1366, "argument_type_id": 3, "chat_text_expl_id": 1366, "statement_id_expl_id": 1366, "argument_type_id_expl_id": 1366}], "argument_other": [{"id": 178, "text": "On the Moon landing videos the sky is dark but no stars are visible. That is because it was filmed in a studio against a dark background rather than a real sky.", "id_expl_id": 1366, "text_expl_id": 1366}]}}
2025-10-28 22:11:31.637353+00	1438	18	1	36	deleteById	tag	{"id": 36, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "tag", "targetLabel": "diet", "deletedRecords": {"tag": [{"id": 36, "name": "diet", "id_expl_id": 1437, "description": "", "name_expl_id": 1437, "description_expl_id": 1437}]}}
2025-10-28 22:16:34.283774+00	1440	24	1	37	deleteById	tag	{"id": 37, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "", "tableName": "tag", "targetLabel": "diet", "deletedRecords": {"tag": [{"id": 37, "name": "diet", "id_expl_id": 1439, "description": "", "name_expl_id": 1439, "description_expl_id": 1439}]}}
2025-10-28 22:29:16.141471+00	1446	24	1	153	updateRecord	statement	{"id": "153", "diff": {"after": {"text": "Atoms are almost spherical"}, "before": {"id": 153, "text": "Atoms are spherical", "id_expl_id": 1443, "text_expl_id": 1444}}, "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "", "tableName": "statement", "targetLabel": "(?) Atoms are almost spherical"}
2025-11-04 20:14:15.294952+00	1492	18	1	190	deleteById	argument	{"id": "190", "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "test", "tableName": "argument", "targetLabel": "Delete test arg", "deletedRecords": {"argument": [{"id": 190, "pro": true, "title": "Delete test arg", "chat_text": "", "id_expl_id": 1491, "pro_expl_id": 1491, "statement_id": 90, "title_expl_id": 1491, "argument_type_id": 3, "chat_text_expl_id": 1491, "statement_id_expl_id": 1491, "argument_type_id_expl_id": 1491}], "argument_other": [{"id": 190, "text": "Delete test arg", "id_expl_id": 1491, "text_expl_id": 1491}]}}
2025-07-15 01:42:17.776481+00	1191	18	1	152	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 152, "pro": true, "title": "Tipping reduces inequality by transferring income from higher-earning diners to lower-paid servers.", "chat_text": "", "id_expl_id": 1191, "pro_expl_id": 1191, "statement_id": 138, "title_expl_id": 1191, "argument_type_id": 10, "chat_text_expl_id": 1191, "statement_id_expl_id": 1191, "argument_type_id_expl_id": 1191}, "extRecord": {"id": 152, "text": "Tipping promotes economic equality by transferring money from wealthier diners to lower-paid servers. In most cases, customers earn more than the people serving them, and tipping acts as a small, direct redistribution of income.", "id_expl_id": 1191, "text_expl_id": 1191}, "tableName": "argument", "targetLabel": "Tipping reduces inequality by transferring income from higher-earning diners to lower-paid servers.", "extTableName": "argument_pragmatic"}
2025-07-15 01:42:55.182061+00	1192	18	1	152	deleteById	argument	{"id": "152", "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "duplicate", "tableName": "argument", "targetLabel": "Tipping reduces inequality by transferring income from higher-earning diners to lower-paid servers.", "deletedRecords": {"argument": [{"id": 152, "pro": true, "title": "Tipping reduces inequality by transferring income from higher-earning diners to lower-paid servers.", "chat_text": "", "id_expl_id": 1191, "pro_expl_id": 1191, "statement_id": 138, "title_expl_id": 1191, "argument_type_id": 10, "chat_text_expl_id": 1191, "statement_id_expl_id": 1191, "argument_type_id_expl_id": 1191}], "argument_pragmatic": [{"id": 152, "text": "Tipping promotes economic equality by transferring money from wealthier diners to lower-paid servers. In most cases, customers earn more than the people serving them, and tipping acts as a small, direct redistribution of income.", "id_expl_id": 1191, "text_expl_id": 1191}]}}
2025-07-15 02:05:13.674558+00	1194	18	1	154	insertExtRecord	argument	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 154, "pro": true, "title": "Tipping reflects merit by rewarding servers in proportion to the quality of their service, allowing those who perform better to earn more.", "chat_text": "", "id_expl_id": 1194, "pro_expl_id": 1194, "statement_id": 138, "title_expl_id": 1194, "argument_type_id": 10, "chat_text_expl_id": 1194, "statement_id_expl_id": 1194, "argument_type_id_expl_id": 1194}, "extRecord": {"id": 154, "text": "Tipping supports the moral principle of merit by allowing individuals to earn more in direct proportion to the quality of their work. Servers who are more attentive, efficient, and personable often receive higher tips, reflecting the effort and skill they bring to the role. Unlike flat wages, tipping creates a dynamic where rewards are not fixed but earned through contribution. This reinforces a system where better performance leads to greater benefit, encouraging professionalism and rewarding excellence in service.", "id_expl_id": 1194, "text_expl_id": 1194}, "tableName": "argument", "targetLabel": "Tipping reflects merit by rewarding servers in proportion to the quality of their service, allowing those who perform better to earn more.", "extTableName": "argument_pragmatic"}
2025-11-08 11:42:48.371673+00	1552	30	1	159	insertCrossRecords	statement	{"id": 159, "user": {"id": 30, "name": "2relTest", "auth_role": "invited"}, "trigger": {"label": "created new record", "explId": 1551}, "fkEnries": {"tags": {"options": [{"id": 41, "label": "tt"}], "tableName": "tag"}}, "tableName": "statement", "targetLabel": "(?) st7"}
2025-07-17 01:09:10.335473+00	1322	18	1	169	insertRecord	argument_judgement	{"user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "record": {"id": 169, "label": "Unexplained illnesses among WIV staff (68%)", "id_expl_id": 1322, "isolated_confidence": 0.68, "isolated_explanation": "Reports of symptomatic researchers just before the outbreak are a direct, time-linked hint of a lab origin.", "isolated_confidence_expl_id": 1322, "isolated_explanation_expl_id": 1322}, "tableName": "argument_judgement", "targetLabel": "Unexplained illnesses among WIV staff (68%)"}
2025-07-17 01:13:17.654127+00	1326	18	1	170	updateRecord	argument_conditional	{"id": 170, "diff": {"after": {"conditional_confidence": "0.51000", "conditional_explanation": "The geographic coincidence component overlaps with earlier WIV-focused arguments"}, "before": {"id": 170, "id_expl_id": 1325, "conditional_confidence": 0.54, "conditional_explanation": "The geographic coincidence component partly overlaps with earlier WIV-focused arguments, leaving a smaller distinct effect primarily from the still-unidentified animal host.", "conditional_confidence_expl_id": 1325, "conditional_explanation_expl_id": 1325}}, "user": {"id": 18, "name": "Durante", "auth_role": "invited"}, "userExpl": "", "tableName": "argument_conditional", "targetLabel": 0.51}
2025-10-16 20:23:20.49258+00	1374	24	1	179	deleteById	argument	{"id": "179", "user": {"id": 24, "name": "Demo User 1", "auth_role": "invited"}, "userExpl": "Replaced with argument of the right type.", "tableName": "argument", "targetLabel": "People are moving slowly in the air because of low lunar gravity.", "deletedRecords": {"argument": [{"id": 179, "pro": false, "title": "People are moving slowly in the air because of low lunar gravity.", "chat_text": "", "id_expl_id": 1367, "pro_expl_id": 1367, "statement_id": 149, "title_expl_id": 1367, "argument_type_id": 3, "chat_text_expl_id": 1367, "statement_id_expl_id": 1367, "argument_type_id_expl_id": 1367}], "argument_other": [{"id": 179, "text": "When astronauts in the video jump, the take off and land much slower than on Earth. So it was not filmed in a studio on Earth.", "id_expl_id": 1367, "text_expl_id": 1367}]}}
2025-10-28 22:14:13.652314+00	1439	18	1	37	insertRecord	tag	{"user